.TH sneep 1
.SH NAME
sneep \-
Serial Number in EEPROM
.br
Save and retrieve Chassis Serial Number  ( CSN )
.br
and other user-defined information using system EEPROM.
.SH SYNOPSIS
.PP
sneep [-aeFhTvV] [-t tag[,tag...]] [-s setting ] \\
.br
.RS
[-P ds1:ds2...] [-d default] [-o separator]
.RE
.br
sneep [start | stop | restart ]
.br
setcsn -c serialnumber
.br
showplatform -p csn
.SH DESCRIPTION
Sneep uses the system EEPROM to save and retrieve
the Chassis Serial Number and other important data
on all known Sun Solaris systems.
.PP
Without sneep, only certain Sun platforms which support the
"setcsn" and "showplatform" programs (from System Management Service [SMS] 1.4)
have a mechanism to maintain a software-accessible serial number.
.br
Sneep has a limited emulation of "showplatform" and "setcsn" ,
and does not provide any of the other functionality of the actual
showplatform and setcsn programs.
.PP
To promote configuration consistency and minimize administrative work, 
sneep can also reference and update any available "explorer" 
and "CST" (Configuration Service Tracker) configuration files,
and will create a special Serial tracking event in the CST event history.
.PP
sneep logs all important changes or problems to syslogd for auditing purposes.
.SH OPTIONS
The following options are supported:
.PP
-a
.RS 1i
All sources: show results from all data sources.
Implies -v .
.RE
.PP
-c serial
.RS 1i
(setcsn only) Set serial number to <serial>
.RE
.PP
-d defaultval
.RS 1i
Specify the default value returned if the requested information is not found.
Standard default is "unknown"
.RE
.PP
-e
.RS 1i
Erase. When used in combination with options -T and -v,
output the sneep commands necessary to erase selected tags and values.
.br
This option has no effect except in conjunction with -T and -v.
.RE
.PP
-F
.RS 1i
Force.  Override safety limits if program refuses to
allow you to change a setting.
.br
NOTE: Use this only if you are certain that the
true limit is greater than the conservative estimate
which the program uses. Exceeding the true limits of
the nvram can have severe consequences including
failure to boot.
.RE
.PP
-h
.RS 1i
This help message
.RE
.PP
-o separator
.RS 1i
Output Field Separator.  Inserted between each value printed when 
more than one tag is specified.  
See option -t .
.br
Default separator is comma.
.RE
.PP
-p csn
.RS 1i
(showplatform only) Print serial number.
.br
<csn> parameter must be literally "csn" .
.RE
.PP
-P ds1:ds2...
.RS 1i
Set Priority of data sources. Colon-separated list.
Sequence used for data sources which can also
be controlled by environment variable SNEEPPATH.
.br
For retrieving data only.
Default is "fruid:sms:eeprom:backup:explorer:cst"
.RE
.PP
-s setting
.RS 1i
Associate <setting> with EEPROM identifier tag.
.br
In normal usage,  <setting> is a Serial Number.
.RE
.PP
-t tag[,tag...]
.RS 1i
Use <tag> as EEPROM identifier to store or retrieve values.
.br
When storing a value, only one tag may be specified.
.br
Default tag is "ChassisSerialNumber". 
.br
.sp 1
Tags "serial", "csn", and "CSN" are equivalent to "ChassisSerialNumber".
.br
Pseudo-tags "hostname" and "hostid" can be used to retrieve the Operating
System values for host (domain) name and host identifier.
Use of these two tags to store information in eeprom is discouraged, as
the information can only be retrieved from the Operating System, 
and not from eeprom.
.sp 1
.RE
.PP
-T
.RS 1i
Report tags as well as values. Normally, sneep reports only values.
If the option -t is not used to select particular tags, 
all tags and their values are reported.
Ignores option -a .
.br
.sp 1
The default output format has the tag followed a tab, followed by the
corresponding value enclosed in quotation marks. 
Each tag/value pair  is presented on a separate line.
.sp 1
If -v option is used with -T, the ouput is a series of
commands suitable for setting the tags.
.br
This is intended to simplify recovery of data.
.sp 1
If -e option is used with -T and -v, the ouput is a series of
commands suitable for erasing the tags.
.RE
.PP
-v
.RS 1i
Verbose: show the source of the reported value.
With -T, show commands, do not show the data source.
.RE
.PP
-V
.RS 1i
Print version information.
Please report this information any time you request
help from sneep-support@sun.com
.RE
.PP
start | restart
.RS 1i
Perform data consistency checks, 
logging messages if the Chassis Serial Number in EEPROM
is missing or inconsistent with any other available data sources.
.br
The start option is used automatically by default at system startup,
and is not intended for use at any other time.
.PP
If the serial number is present in the eeprom, but is not present in the
sneep backup file, then all of the sneep settings in the eeprom 
will be used to automatically
correct the backup file and other sources.
Any settings found only in the backup file will remain unchanged.
.PP
If the serial number is missing from the eeprom, but is present in the
backup file, and if the backup file is the correct one for the current system, 
all of the settings from the backup which are not already in the eeprom
will be used to correct the eeprom and other sources.
.RE
.PP
stop
.RS 1i
Ignored. Included for completeness.
.br
.SH  OPERANDS
.sp 1
.PP
tag		
.RS 1i
Identifier used to save or retrieve a value.  
Does not have to be supplied in normal usage for Chassis Serial Number.
.sp
Only a few special characters are permitted in the tag.
These characters are @ # _ + = - 
.RE
.PP
setting		
.RS 1i
The value to be stored in the EEPROM.
It may not contain quotation marks or control characters 
( including newline ).
If the Chassis Serial Number is being set,
the setting will be converted to upper case,
and will be checked for length and content.
.RE
.PP
ds1:ds2...	
.RS 1i
Data Source (n).
.RS
 e.g. eeprom:backup:explorer:cst...
.RE
A colon-separated sequence of places which sneep understands as
sources of data. When requesting a value for a tag,
sneep searches them in the given sequence, returning the first
value found. 
The default list is arranged to search the most authoritative
sources first.
.SH NOTES
Superuser privilege is required to save information in EEPROM and in the 
explorer and CST configuration files. It is likely that any user can use sneep to retrieve data, although some sources (like SMS) may require special
privileges.
.PP
Serial numbers are stored in upper case only. 
This can be overridden if necessary, but it will be incompatible 
with serial number data used by Sun and may fail to provide full value.
Values for other tags are left unchanged.	
.SH EXAMPLES
.PP
Save  serial number in EEPROM, updating explorer and CST configuration files.
.RS 1i
# sneep -s 1234abcd
.br
#
.RE
.PP
Print previously saved serial number:
.RS 1i
$ sneep
.br
1234ABCD
.br
$
.RE
.PP
Save asset data in EEPROM :
.RS 1i
# sneep -t ASSETTAG -s Asset1234	
.RE
.PP
Print value for ASSETTAG :
.RS 1i
$ sneep -t ASSETTAG
.br
Asset1234
.RE
.PP
Show Serial number using showplatform format
.RS 1i
$ showplatform -p csn
.RS
CSN:
.br
====
.br
Chassis Serial Number: 1234ABCD
.RE
.RE
.PP
Show all tags and values :
.RS 1i
$ sneep -T 
.br
ChassisSerialNumber "1234ABCD"
.br
ASSETTAG "Asset1234"
.RE
.PP
Show Inventory data as comma-separated list
.RS 1i
$ sneep -t hostname,hostid,serial,ASSETTAG
.br
MyHostname,8000008,1234ABCD,Asset1234
.RE
.SH ENVIRONMENT
The following environment variables permit the user to override
defaults:
.PP
SNEEPPATH
.RS
The priority search path for data sources, like option -P.
.br
Can also be set permanently in the sneep backup file.
.RE
.PP
SNEEP_SYSLOG
.RS
The syslog facility.priority to override the default "daemon.notice".
.br
Can also be set permanently in the sneep backup file.
.RE
.PP
FORCE_UCASE
.RS
If "false", do not force serial numbers to be upper case.
Serial numbers containing lower case may be incompatible to some degree 
with internal Sun tools.
.RE
.SH EXIT STATUS
0 indicates normal or successful operation.
.br
1 indicates an error in usage, or an inability to perform the requested
action; e.g. because of insufficient privilege.
.SH FILES
.PP
/etc/default/SUNWsneep
.RS
Backup file containing all tags and settings for recovery of eeprom,
as well as customized default settings for syslog and priority search path.
Format for the customized default settings:
.RS
sneep<space>syslog<tab><facility.priority>
.br
sneep<space>path<tab><ds1:ds2:...dsn>
.RE
.RE
.SH SEE ALSO
.PP
eeprom(1M), syslogd(1M), logger(1), explorer(1M), 
.br
Sneep User Guide,
Configuration Service Tracker
.SH SUPPORT
.sp
To report problems, request enhancements, or contribute helpful information
regarding sneep, please send email to
.PP
.RS
sneep-support@sun.com
.RE
.PP
If you report a problem, please include the version information
from sneep -V .

