#!/bin/sh

# bb-cpu.sh
#
# BIG BROTHER MONITORING SCRIPT
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#
# echo "***** BBHOME IS SET TO $BBHOME"
# echo "***** BBTMP IS SET TO $BBTMP"

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
	 # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

if test ! "$MACHINEDOTS"		# THIS SHOULD ALREADY BE SET...
then
	# Setup the name of the local host
	# Save a version of the machine name with '.' 
	# instead of ',', if any are there
	MACHINEDOTS=`echo $MACHINE | $SED 's/,/\./g'`
	if [ "$FQDN" != "TRUE" ]
	then
		OLDIFS=$IFS
		IFS='.'
		set $MACHINEDOTS >/dev/null
		IFS=$OLDIFS
		MACHINEMASK="${1}"
	else
		MACHINEMASK="${MACHINEDOTS}"
	fi
	export MACHINEDOTS MACHINEMASK
fi

#=====================================================================
# CPU TEST AND UPTIME WARNINGS
# AUTOMATIC WARNING IF THE SYSTEM IS UP FOR LESS THAN 1 HOUR
#=====================================================================
#
# echo "*** CPU TEST ***"

if [ -f "$BBHOME/etc/bb-cputab" ]
then
	# a line can start with
	# :....
	#  :....
	# localhost:...
	# www:....
	# www.bb4.com:...
	#
	# All mask should allow for spaces/tabs before :
	# Grep for each mask
	$RM -f $BBTMP/BBCPU.$$
	for mask in "[ 	]*${MACHINEMASK}[ 	]*:" "[ 	]*${MACHINEMASK}\..*:" "[ 	]*localhost[ 	]*:" "[ 	]*:"
	do
		# Save values in FILE
		# Stop on 1st match
		$GREP "^${mask}" $BBHOME/etc/bb-cputab | $HEAD -1 >>$BBTMP/BBCPU.$$ 2>/dev/null
		if [ -s $BBTMP/BBCPU.$$ ]
		then
			break
		fi
	done

	# If any line matched then process
	if [ -s $BBTMP/BBCPU.$$ ]
	then
		# If any ":" are found, force spaces around it to
		# make Solaris happy :(
		# Thanks to  Larry Parmelee <parmelee@CS.Cornell.EDU>
		cpuline=`$CAT "$BBTMP/BBCPU.$$" | $SED 's/:/ : /g' 2>/dev/null`
		OLDIFS=$IFS
		IFS=':'
		set $cpuline 2>/dev/null
		IFS=$OLDIFS
		if [ $# -eq 4 ]
		then
			# Get rid of spaces
			ARG2=`echo $2`
			ARG3=`echo $3`
			ARG4=`echo $4`

			# Do we need to reset BBTOOMANYDAYSUP ?
			daysup=`echo $ARG2 | $GREP daysup | $SED 's/daysup=//g' | $SED 's/[^0-9]//g'`
			if [ "$daysup" != "" ]
			then
				BBTOOMANYDAYSUP=$daysup
			fi

			# Get CPUWARN / CPUPANIC values
			WARN=`echo "$ARG3" | $SED 's/[^0-9]//g' 2>/dev/null`
			PANIC=`echo "$ARG4" | $SED 's/[^0-9]//g' 2>/dev/null`
			if [ "$ARG3" != "$WARN" -o "$ARG4" != "$PANIC" ]
			then
				echo "`$DATE` bb-cpu.sh Invalid WARN/PANIC entry: $cpuline"
			else
				CPUWARN=$WARN
				CPUPANIC=$PANIC
			fi
		else
			echo "`$DATE` bb-cpu.sh Invalid config line: $cpuline"
		fi
	fi
	$RM -f $BBTMP/BBCPU.$$
fi

set `$UPTIME`

echo $3 | $GREP "," > /dev/null 2>&1
if test "$?" = 0
then
	UP=`echo $3 | $SED "s/,//"`
	UPVAL="-1"
else
	UP=`echo $3 $4 | $SED "s/,//"`
	UPVAL="$3"
fi

shift;shift;shift;shift;

ARG=`$EXPR $# - 2`			# 5 MINUTE LOAD AVERAGE
COUNT=1
while test "$COUNT" -le "$ARG"
do
	shift;
	COUNT=`$EXPR $COUNT + 1`
done

# DISPLAY REAL LOAD AVG IF REQUESTED
# FROM A SUGGESTION BY adam@wesolveit.com.au
REALAVG=`echo $1 | $SED "s/\,//g"`
AVG=`echo $REALAVG | $SED "s/\.//" `
AVG=`$EXPR $AVG + 0`
# echo "LOAD AVERAGE: $AVG"

if [ "$DISPREALLOADAVG" = "TRUE" ]
then
	DISPAVG=$REALAVG
else
	DISPAVG=$AVG
fi

LINE="LOAD AVG on $MACHINE is ${DISPAVG}"

if test "$AVG" -ge "$CPUPANIC"
then
	COLOR="red"
elif test "$AVG" -ge "$CPUWARN"
then
	COLOR="yellow"
else	
	COLOR="green"
fi

# echo "*** PS COMMAND $PS ***"

$PS > $BBTMP/bb.$$			# GET A PS LISTING
P=`$CAT $BBTMP/bb.$$ | $WC`		# NUMBER OF PROCESSES
P=`echo $P`
U=`$WHO | $WC`				# GET NUMBER OF USERS
U=`echo $U`

#
# AUTOMATIC WARNING IF A SYSTEM HAS BEEN UP LESS THAN AN HOUR
# THIS WILL HELP US NOTICE SPONTANEOUS REBOOTS!
#
# Mark yellow only if non red already
# Thanks to  jim <jjg@disasters.interactive8.com>

LINE1=""
echo $UP | $GREP "min" > /dev/null 2>&1
if test "$?" = "0"
then
	if [ "$UPVAL" -gt -1 -a "$UPVAL" -le "$WARNMINSONREBOOT" ]
	then
		case "$WARNCOLORONREBOOT"
		in
			[Rr][Ee][Dd] )
				COLOR=red
				;;
			[Yy][Ee][Ll][Ll][Oo][Ww] )
				if [ "$COLOR" != "red" ]
				then
					COLOR=yellow
				fi
				;;
			# disregard any other color
		esac
		LINE1="
Warning: Machine recently rebooted"
	fi
fi


#
# HAS THIS MACHINE BEEN UP SO LONG IT NEEDS TO BE REBOOTED?
# IF NOT NECESSARY, DON'T SET BBTOOMANYDAYSUP IN bbdef.sh
# Thanks to jim <jjg@disasters.interactive8.com>

LINE2=""
if test -n "$BBTOOMANYDAYSUP"
then
        echo $UP | $GREP "day" > /dev/null 2>&1
        if test "$?" = "0"
        then
                NUMDAYS="$UPVAL"
                if [ "$NUMDAYS" -ge 0 -a "$NUMDAYS" -gt "$BBTOOMANYDAYSUP" ]
                then
                        if test "$COLOR" != "red"
                        then
                                COLOR="yellow"
                        fi
                        LINE2="
Warning: This machine has been up for $NUMDAYS days,
which is greater than $BBTOOMANYDAYSUP, the number of days (BBTOOMANYDAYSUP)
you have specified as when a machine should be rebooted."
                fi
        fi
fi

set bogus $TOP >/dev/null 2>&1
shift

if test -x "$1"
then
	unset TOP				# SIDESTEP DUMB TOP PROB ON SUN
        $1 $TOPARGS > $BBTMP/TOP.$$
	if [ "$?" -ne 0 ]
	then
		echo $LINE > $BBTMP/TOP.$$
	else
		if test -f "$BBTMP/TOP"
		then
			$MV $BBTMP/TOP $BBTMP/TOP.$$
		fi
	fi
else
	echo $LINE > $BBTMP/TOP.$$
fi

#
# NOW SEND THIS INFORMATION TO THE BIG BROTHER DISPLAY UNIT
#
$BBHOME/bin/bb-combo.sh add "status $MACHINE.cpu $COLOR `date` up: $UP, $U users, $P procs, load=${DISPAVG}
$LINE1
$LINE2
`cat $BBTMP/TOP.$$`
"

$RM -f $BBTMP/TOP.$$
$RM -f $BBTMP/bb.$$
