#!/bin/sh
#
# bbchkcmds.sh:	Check that commands are in the right place.
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

#--------------------------------------------------------
# FIGURE OUT WHERE WE ARE AND SET BBHOME
#--------------------------------------------------------

echo "*** Verifying pathnames to necessary commands..."

PROG="$0"
XNAME=`basename $0`
DIR=`echo $PROG | sed "s/${XNAME}$//"`

cd $DIR				# GET TO THE INSTALL DIRECTORY
cd ..				# GO UP TO BBHOME
BBHOME=`pwd`			# SET IT THE EASY WAY

# Check if the BB program paths are correct
# Most of them live in here read 'em in.

. $BBHOME/etc/bbsys.sh 2> /dev/null
. $BBHOME/etc/bbsys.local 2> /dev/null

rm -f /tmp/BBCHK.$$
rm -f /tmp/BADCMDS.$$
rm -f /tmp/BBMISS.$$

#
# TOOK LYNX OUT OF THE COMMAND TO CHECK SINCE IT'S SET IN bbdef.sh
# AND NEEDS SPECIAL ARGUMENTS...
#
varset="MAIL NSLOOKUP PING LS FIND TOUCH CAT GREP SORT UNIQ DATE TAIL SED UPTIME WC WHO RM EGREP AWK EXPR HEAD CP MV ID DIG LN TOP DF PS"

for var in $varset
do
	varval="\$${var}"
	pathval=`eval echo $varval`
	if [ -z "$pathval" ]
	then
		if [ "$var" = "TOP" ]
		then
			continue
		else
			set "EMPTY"
		fi
	else
		set $pathval
	fi
	cmdpath=$1

	if test "$#" -gt 1	# IF THERE ARE ANY ARGS, THEN
	then
		shift;
		ARGS="$*"	# SAVE THE ARGUMENTS!
	else
		ARGS=""
	fi

        if [ ! -f "$cmdpath" ]	# THE COMMAND DOESN'T EXIST...
        then
		cmd=`echo $var | sed 'y/ABCDEFGHIJKLMNOPQRSTUVWXYZ/abcdefghijklmnopqrstuvwxyz/'`
		CMDLINE=`type $cmd 2> /dev/null`
		if [ "$?" -eq 0 ]	# FOUND IT - MOVE IT IN...
		then
			set $CMDLINE
			while test "$#" -gt 1
			do
				shift;
			done
			if [ "$ARGS" != "" ]
			then
				NEWPATH="$1 $ARGS";
			else
				NEWPATH="$1"
			fi
			echo "$var=\"$NEWPATH\"; export $var" >> /tmp/BBCHK.$$
			if test "$pathval"
			then
				echo "	--> $pathval changed to $NEWPATH" >> /tmp/BADCMDS.$$
			else
				echo "	--> added $NEWPATH" >> /tmp/BADCMDS.$$
			fi
		else
			echo "$var" >> /tmp/BBMISS.$$
		fi
		if [ "$var" = "DIG" ]
		then
			echo "DIG is unavailable, the directive \"dig\" cannot be used in bb-hosts"
		fi
		continue
	else
		case $var
		in
			EGREP ) 
				echo xxx | $cmdpath -x xxx >/dev/null 2>&1
				if [ "$?" -ne 0 ]
				then
					echo "$var does not seem to understand the -x option, please replace"
					echo "    with a version that understands the -x option"
				fi
				;;

			* )
				;;
		esac
		
        fi
done

for file in $MSGFILE
do
	if [ ! -f "$file" ]
	then
		echo "MSGFILE=$MSGFILE is incorrectly defined, fix in bbsys.local"
	fi
done

#
# NOW FIX THE PROBLEMATIC ENTRIES - IF ANY
# THE EASIEST WAY TO DO THIS IS BY TACKING THEM
# ONTO bbsys.local
if test -f /tmp/BBCHK.$$ -o -f /tmp/BBMISS.$$
then
	if [ -f /tmp/BBMISS.$$ ]
	then
		#
		# Tell the installer that some commands are missing
		#
		echo ""
		echo "You are missing these commands: "
		cat /tmp/BBMISS.$$ | \
		while read cmd
		do
			echo $cmd
		done
		rm -f /tmp/BBMISS.$$
	fi

	if [ -f /tmp/BBCHK.$$ ]
	then
		echo "*** The following changes need to be made..."
		cat /tmp/BADCMDS.$$

		if test "$NAME" != "bbconfig"
		then
			ANS=""
			echo "*** Do you want to make these changes? [y/n]"
			read ANS
		else
			echo "*** Making changes..."
			ANS="y"
		fi

		if test "$ANS" = "y"
		then
			echo "
#
# *** PLEASE DO NOT EDIT BY HAND...
# *** AUTOMATIC PATHNAME CORRECTIONS
# *** ADDED BY bbchkcmds.sh
# *** ON: `date` FOR `uname -a`
#
			" >> $BBHOME/etc/bbsys.local
			cat /tmp/BBCHK.$$ >> $BBHOME/etc/bbsys.local


			#
			# SEE IF THEY'LL BE NICE ENOUGH TO ALLOW US TO UPDATE
			# OUR PATHNAME DATABASE WITH THIS INFO...
			#
			echo "
*** We've noticed that we've set some of the pathnames wrong
*** by default here.  May we mail a summary of the paths we
*** missed back to info@bb4.com so we can update our installs?
[y/n]"
			read ANS
			if test "$ANS" = "y"
			then
				. $BBHOME/etc/bbsys.local	# GET THE RIGHT PATHS...

				echo "*** Please enter the OS name and version:"
				read OSNAME

				# Add title in case MAIL can't send title, this may help	
				echo "Corrections to $OSNAME" >>  /tmp/BBCHK.$$	
				# We get the exact uname for further enhancements
				echo "uname: `uname -a`" >>  /tmp/BBCHK.$$	
				$MAIL "Corrections to $OSNAME" bbconfig@bb4.com < /tmp/BBCHK.$$
				echo "*** Mail sent, thanks!"
			fi


		fi
		rm -f /tmp/BBCHK.$$
		rm -f /tmp/BADCMDS.$$
	fi
	echo "*** Done."
else
	echo "*** All pathnames OK".
fi


exit 0
