#!/bin/sh
#
# bbdef.sh
#
# BIG BROTHER DEFINITIONS AREA
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

#
# LOCAL CLIENT MONITORING CONFIGURATION FOR bb-local.sh
#
# WARNING AND PANIC LEVELS FOR LOCAL SYSTEM INFOMRAION
# YOU CAN SET VALUES ON A SPECIFIC FILESYSTEM BY USING
#	THE etc/bb-dftab FILE
#

DFWARN=90				# (YELLOW) DISK % TO WARN
DFPANIC=95				# (RED) DISK % TO PANIC
export DFWARN DFPANIC


#
# CPU LEVELS ARE THE 5 MINUTE LOAD AVERAGE x 100
#

CPUWARN=150				# (YELLOW) WARN AT LOAD AVG OF 1.5
CPUPANIC=300				# (RED) PANIC AT LOAD AVG OF 3
DISPREALLOADAVG="FALSE"			# DISPLAY THE LOAD AVERAGE AS FOUND IN UPTIME
					# BB REMOVES THE '.' BY DEFAULT
export CPUPANIC CPUWARN DISPREALLOADAVG


#
# PROCESS MONITORING
# THESE VALUES ARE OVERRIDDEN BY THE etc/bb-proctab FILE
#

PROCS="bbrun"				# (YELLOW) WARN IF NOT RUNNING 
PAGEPROC="cron"				# (RED) PAGE IF NOT RUNNING
export PROCS PAGEPROC


#
# MESSAGE FILE MONITORING (/var/adm/messages or similar)
#
# SMM: NEW IN BB 1.4
# CHKMSGLEN IS SET TO TRUE BY DEFAULT.  IT WILL SCREAM IF IT FINDS
# AN EMPTY MESSAGES FILE.  BETTER SAFE THAN SORRY.
#
# NOTE: AS OF VERSION 1.8 YOU CAN USE etc/bb-msgstab TO
#       CONFIGURE THE VALUES OF PAGEMSG, MSGS AND IGNMSGS
# NOTE THAT KEYWORDS ARE SPACE SEPERATED HERE AS OPPOSED
# TO ';' SEPERTATED IN etc/bb-msgstab
#
CHKMSGLEN="TRUE"			# MAKE SURE MSG FILE IS NON-ZERO LEN
PAGEMSG="NOTICE"			# (RED) PAGE IF WE SEE THIS MESSAGE
MSGS="$PAGEMSG WARNING"			# (YELLOW) MESSAGES TO WATCH FOR 
					# NOTE: WORDS IN PAGEMSG *MUST ALSO*
					#       BE DEFINED IN MSGS
IGNMSGS=""              # List of messages to ignore if string(s) matches line
                        # delimit each message with ;
MSGEXPIRE="30:60"	# EXPIRE WARNINGS IN 30 MIN, PANICS IN 60
YELLOWMSGSLINES=10	# Return the XX most recent WARNING messages
REDMSGSLINES=20		# Return the XX most recent PANIC messages
OLDSTYLEBBMSGS="FALSE"	# Don't expire messages found 
			#   just like the old days (they must be cleared by hand)
export MSGS PAGEMSG IGNMSGS CHKMSGLEN MSGEXPIRE YELLOWMSGSLINES REDMSGSLINES OLDSTYLEBBMSGS

#
# Control the color of the cpu dot when a host reboots
# Note that the maximum of minutes definable is 60, anything over will be reset to 60
#
WARNMINSONREBOOT=60
WARNCOLORONREBOOT=yellow
export WARNMINSONREBOOT WARNCOLORONREBOOT

# 
# THIS SETS A VALUE FOR IF YOU THINK MACHINES SHOULD BE REBOOTED EVERY X DAYS
# 
BBTOOMANYDAYSUP=9999
export BBTOOMANYDAYSUP

# 
# Variables to determine if local test is to be run
# and if so, does it send a msg anyway
# 
DOCPU="TRUE"
DOMSGS="TRUE"
DOPROCS="TRUE"
DODISK="TRUE"
NOCPUCOLOR="clear"	# Set to "" if you don't want a message sent
NOMSGSCOLOR="clear"	# anything else will send a message to BBDISPLAY
NODISKCOLOR="clear"
NOPROCSCOLOR="clear"
export DOMSGS DOPROCS DODISK DOCPU
export NOCPUCOLOR NOMSGSCOLOR NODISKCOLOR NOPROCSCOLOR
