#!/bin/sh
#
# bbinc.sh
#
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

BBREL="1.9i"
BBRELDATE="Fri, 30 Dec 2005 20:19:58 PST"
export BBREL BBRELDATE

# --------------------------------------------------
# Big Brother - Pager codes and system definitions
#
# NO CHANGES SHOULD BE NEEDED HERE
# --------------------------------------------------
#
if [ "$BBHOME" = "" ]
then
	echo "bbinc.sh: BBHOME not set !"
	exit 1
fi

BB="${BBHOME}/bin/bb"			# WHERE bb LIVES
BBHOSTS="${BBHOME}/etc/bb-hosts"        # BIG BROTHER HOSTS FILE
BBEXTTAB="${BBHOME}/etc/bb-bbexttab"    # EXTERNAL SCRIPTS TO RUN LOCALLY
export BB BBHOSTS BBEXTTAB

#
# FIGURE OUT THE LOCAL MACHINE NAME
# USE FULLY QUALIFIED MACHINE NAMES?
# DOT -> COMMA -> DOT FOR WEB DISPLAY
#

if [ -f "$BBHOME/etc/bbaliasname" ]; then
        MACHINE=`$CAT $BBHOME/etc/bbaliasname`
else
        MACHINE=`uname -n`
fi

# New code 1.09 - RAC
#
# Extract the host part if not FQDN
if test "$FQDN" != "TRUE"
then
	set `echo $MACHINE | $SED "s/\./ /"` >/dev/null 2>&1
	MACHINE=$1
fi

set ""		# force a set or it will keep the old $* if it failed

# Do we match: "255.255.255.255 ${MACHINE}" ?
set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}$" $BBHOSTS` >/dev/null 2>&1
if [ "$#" -lt 2 -o "$2" = "" ]
then
	# Do we match: "255.255.255.255 ${MACHINE} # blah blah blah" ?
	# Do we match: "255.255.255.255 ${MACHINE}.domain.com # blah blah blah" ?
	set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}[\. 	].*$" $BBHOSTS` >/dev/null 2>&1
fi

if [ "$#" -lt 2 -o "$2" = "" ]
then
	echo "This host <${MACHINE}> was not found in the etc/bb-hosts file"
	echo "Please use the same name from 'uname -n'"
	exit 1
fi
# End of new code 1.09 - RAC

# SMM 1.09 - OFFLOAD CODE FROM RUNBB.SH 
# CHECK IF THIS MACHINE IS A BBDISPLAY

# echo "TESTING RESULTS FROM $*"

results="$*"

if [ "$BBPORT" = "" ]
then
	BBPORT=1984
fi

for token in $results
do
	case $token in
		BBDISPLAY* )
				BBSERVER="TRUE"
				BBDISPLAY=TRUE
				OLDIFS=$IFS
				IFS=:
				set $token
				IFS=$OLDIFS
				if [ "$#" -gt 1 -a "$2" != "" ]
				then
					BBPORT=$2
				fi
				break
				;;
		* )
			;;
	esac
done

for token in $results
do
	case $token in
		BBPAGER* )
				BBSERVER="TRUE"
				BBPAGER=TRUE
				OLDIFS=$IFS
				IFS=:
				set $token
				IFS=$OLDIFS
				if [ "$#" -gt 1 -a "$2" != "" ]
				then
					if [ "$BBDISPLAY" != TRUE ]
					then
						BBPORT=$2
					else
						if [ "$BBPORT" != "$2" ]
						then
							echo "BBPAGER and BBDISPLAY must use the same port"
							echo "BBPAGER and BBDISPLAY must use the same port" >> $BBOUT
							echo "Using port ${BBPORT} for BBPAGER"
							echo "Using port ${BBPORT} for BBPAGER" >> $BBOUT
						fi
					fi
				fi
				break
				;;
		* )
			;;
	esac
done

echo "$results" | $GREP BBNET > /dev/null 2>&1 
if test "$?" = "0"
then
	BBNET="TRUE"
fi

relayline=`echo "$results" | $GREP "BBRELAY:" 2>/dev/null`

export BBDISPLAY BBPAGER BBNET BBPORT

# Reset args
set bogus $results
shift

MACHINE=$2				# GET FQDN NAME FROM etc/bb-hosts
MACHIP=`echo $1 | $SED "s/\.//g"`	# IP ADDRESS FOR PAGER DISPLAY

#
# MACHINEADDR REPRESENTS THE IP or THE NAME OF THE LOCAL HOST
# USE NAME IF IP = 0.0.0.0
#
if [ "$1" = "0.0.0.0" ]
then
	MACHINEADDR="$2"
else
	MACHINEADDR="$1"
fi
export MACHINEADDR

if test "$FQDN" = "TRUE"
then
	MACHINEDOTS=$MACHINE
	MACHINE=`echo $MACHINE | $SED "s/\./,/g"`
else
	set `echo $MACHINE | $SED "s/\./ /"`
	MACHINE=$1
	MACHINEDOTS=$MACHINE
fi

export MACHINE MACHIP MACHINEDOTS

#
# WHERE THE BIG BROTHER SERVERS LIVE
# LOOK IN bb-hosts FOR DISPLAY AND PAGER HOSTS
# SMM ADD SUPPORT FOR MULTIPLE BBDISPLAYS
#

# PULL OUT THE IP ADDRESS, HOSTNAME AND BBDISPLAY KEYWORDS

bbline=`$CAT $BBHOSTS | $GREP BBDISPLAY | $GREP "^[0-9]" |\
while read line
do
	set bogus $line
	shift
	if [ $# -lt 3 ]
	then
		continue
	fi
	echo $1
	echo $2
	shift;shift
	while [ $# -gt 0 ]
	do
		case $1 in
			BBDISPLAY* )
				echo $1
				break
				;;
		esac
		shift
	done
done`

if [ -z "$bbline" ]
then
	echo "*** FATAL ERROR: BBDISPLAY not set in etc/bb-hosts!"
	exit 2
fi

set $bbline
BBDISPLAYS=""

while [ "$#" -ne 0 ]
do
	IP=$1
	HOSTNAME=$2
	IPPORT=""
	OLDIFS=$IFS
	IFS=":"
	set bogus $3
	shift
	IFS=$OLDIFS
	if [ "$#" -gt 1 ]
	then
		if [ "$2" != "" ]
		then
			# ADD PORT IF NEEDED
			IPPORT=":$2"
		fi
	fi
	if test "$IP" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
	then
		echo " ${BBDISPLAYS} " | $GREP " ${HOSTNAME} " >/dev/null 2>/dev/null
		if [ "$?" -ne 0 ]
		then
			BBDISPLAYS="${BBDISPLAYS} ${HOSTNAME}${IPPORT}" 	# USE THE NAME
		fi
	else	
		echo " ${BBDISPLAYS} " | $GREP " ${IP} " >/dev/null 2>/dev/null
		if [ "$?" -ne 0 ]
		then
			BBDISPLAYS="${BBDISPLAYS} ${IP}${IPPORT}"	# USE THE IP ADDR
		fi
	fi
	set bogus $bbline
	shift
	shift;shift;shift			# Advance to next BBDISPLAY
	bbline=$*
done

BBDISPLAYS=`echo $BBDISPLAYS`

set $BBDISPLAYS
if test "$#" -eq 1
then
	BBDISP="$1"			# ORIGINAL FLAVOR...
	BBDISPLAYS=""
else
	BBDISP="0.0.0.0"		# DUMMY - DON'T USE...
fi

export BBDISP
export BBDISPLAYS		# bb EXECUTABLE USE THIS INSTEAD IF BBDISP = 0.0.0.0


# SMM ADD SUPPORT FOR MULTIPLE BBPAGERS

bbline=`$CAT $BBHOSTS | $GREP BBPAGER | $GREP "^[0-9]" |\
while read line
do
	set bogus $line
	shift
	if [ $# -lt 3 ]
	then
		continue
	fi
	echo $1
	echo $2
	shift;shift
	while [ $# -gt 0 ]
	do
		case $1 in
			BBPAGER* )
				echo $1
				break
				;;
		esac
		shift
	done
done`

if [ -z "$bbline" ]
then
	# DEFAULT TO THE SAME THING AS BBDISPLAY
	BBPAGE=$BBDISP
	BBPAGERS=$BBDISPLAYS
else
	set $bbline
	BBPAGERS=""

	while [ "$#" -ne 0 ]
	do
		IP=$1
		HOSTNAME=$2
		IPPORT=""
		OLDIFS=$IFS
		IFS=":"
		set bogus $3
		shift
		IFS=$OLDIFS
		if [ "$#" -gt 1 ]
		then
			if [ "$2" != "" ]
			then
				# ADD PORT IF NEEDED
				IPPORT=":$2"
			fi
		fi
		if test "$IP" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
		then
			echo " ${BBPAGERS} " | $GREP " ${HOSTNAME} " >/dev/null 2>/dev/null
			if [ "$?" -ne 0 ]
			then
				BBPAGERS="${BBPAGERS} ${HOSTNAME}${IPPORT}" 	# USE THE NAME
			fi
		else	
			echo " ${BBPAGERS} " | $GREP " ${IP} " >/dev/null 2>/dev/null
			if [ "$?" -ne 0 ]
			then
				BBPAGERS="${BBPAGERS} ${IP}${IPPORT}"	# USE THE IP ADDR
			fi
		fi
		set bogus $bbline
		shift
		shift;shift;shift		# Advance to next BBPAGER
		bbline=$*
	done

	BBPAGERS=`echo $BBPAGERS`
	set $BBPAGERS
	if test "$#" -eq 1
	then
		BBPAGE="$1"			# ORIGINAL FLAVOR...
		BBPAGERS=""
	else
		BBPAGE="0.0.0.0"		# DUMMY - DON'T USE...
	fi
fi

unset bbline

export BBPAGE
export BBPAGERS		# bb EXECUTABLE USE THIS INSTEAD IF BBPAGE = 0.0.0.0

#
# Determine if any relay host has been defined
#
BBRELAYS=""
for relay in $relayline
do
	case $relay
	in
		BBRELAY:* )
			OLDIFS=$IFS
			IFS=':'
			set $relay
			IFS=$OLDIFS
			shift		# Remove BBRELAY from arg list
			if [ "$#" -ge 1 -a "$#" -le 2 -a "$1" != "0.0.0.0" -a "$1" != "" ]
			then
				if [ "$#" -eq 1 -o "$2" = "" ]
				then
					NEWRELAY="$1"
				else
					NEWRELAY="$1:$2"
				fi
				#
				# NOTE: A SPACE HAS BEEN ADDED AT THE END TO HELP IN PROCESSING
				#	HOST:1985 != HOST    HOST USES DEFAULT PORT 1984
				#
				if [ "$BBRELAYS" = "" ]
				then
					BBRELAYS="$NEWRELAY "
				else
					echo "$BBRELAYS" | $GREP "$NEWRELAY " >/dev/null 2>&1
					if [ "$?" -ne 0 ]
					then
						BBRELAYS="$BBRELAYS $NEWRELAY "
					fi
				fi
			fi
			;;
		* )
			;;
	esac
done

if [ "$BBRELAYS" != "" ]
then
	BBSERVER="TRUE"
fi

export BBRELAYS

unset relayline


export BBSERVER 


#
# GET PAGELEVELS FROM etc/bbwarnsetup.cfg. IT CONTAINS THE COLOR
# ON WHICH A NOTIFICATION SHOULD BE SENT
# IF YOU CHANGE THE VALUE pagelevels IN etc/bbwarnsetup.cfg YOU
# MUST RESTART BB.  MAKE SURE THE pagelevels VALUE IS
# IDENTICAL ON ALL CLIENTS
# Default colors are in bbdef.sh

pagelevelsline=`$GREP "^pagelevels:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $pagelevelsline >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then
                shift           # remove pagelevels token from line
                param="$*"

                # Check if it's a valid parameter, remove bad values

                PAGELEVELS=""
                for color in $param
                do
                        case $color in  
      
                        yellow | red | purple )

                                PAGELEVELS="$PAGELEVELS $color"
                                ;;

                        * )
                                ;;

                        esac
                done
		unset param
        fi
fi
export PAGELEVELS

unset pagelevelsline
unset OLDIFS

if [ -x "$BBHOME/bin/bbd" ]
then
	# We're a server
	. $BBHOME/etc/bbinc-server.sh
else
	# We're a clieint
	. $BBHOME/etc/bbinc-client.sh
fi

#echo "=====> 1) $MACHINE 2) $MACHIP 3) $BBDISP 4) $BBPAGE 5) $BBDISPLAYS 6) $BBPAGERS"
