#!/bin/sh
#
# bb-mailack.sh - E-MAIL ACKS TO BB NOTIFICATIONS
#
# Sean MacGuire
# Robert-Andre Croteau
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#
# HOW IT WORKS
#
# BB-generated e-mail messages all have the security code and problem
# in the subject line.  Since the user bb is running as shouldn't ever
# get mail (unless maybe it's bouncing), replies can be acked automatically
# by parsing the subject line and sending BB and ACK message.  This user
# can still receive mail, this script will disregard non-ack message
# and save the mail message in the folder
#
# To set up: (do read note #1 and #2 as setup may differ)
#
#   On the BBPAGER host, create a .forward file under the
#   user BB is running as:
#   |<BBHOME>/bin/bb-mailack.sh
#   Adjust BBHOME to your own BBHOME
#
#   Note #1, recent version of sendmail will only execute
#    programs that are located in /etc/smrsh (check your
#    sendmail config for the proper directory).  Save
#    The solution is to put a symlink in the smrsh home
#    to the bb-mailack.sh, then use an alias rather than
#    a .forward.  Thanks to mw@nextjet.com.
#
#   Note #2, words of wisdom from John Alexander <alexandj@fortrex.com>
#   a) If you have later versions of SendMail (8.11) install Procmail.
#   b) Put a .procmailrc file in the bbuser home directory to redirect the mail
#   c) Ensure .procmailrc has permissions of 600 or it will gripe and fail.
#   d) Ensure the bbuser home directory has perms of 755 or Procmail
#      will gripe and fail
#   e) Procmail will fail with a "suspicious rcfile" error if the home
#      directory or .procmailrc is writable by anything more than the owner.
#   f) /var/log/syslog is your friend ;)
#
#   Set the following variables to the required values
#   BBUSER    User name
#   BBHOME    Location of the BB tree
#   MAILFILE  Location of the user's mailbox
#   REPLYPFX  Prefix returned with the mail message
#   DELAY     Default delay value
#   ACK	      Send confirmation message ?
#
# To use:
#   Just reply th the e-mail notifications sent by your bbuser
#
#   You can set a different DELAY value than the default
#   Type in DELAY=XXX  right after the !BB - XXXXXYY!
#      !BB - XXXXXYY! DELAY=30
#
#   You can put a defaut


######################################################
# CONFIGURATION
#
# SET SOME VARIABLES WE NEED.  SEASON TO TASTE...
# Yes, we could have tried "who am i", whoami, id -u -n
# for BBUSER but instead to figure out what's portable
# it's easier to ask you for 30secs to set them up ;)
# Also applies to MAILFILE

BBUSER="bbuser"
BBHOME="/home/sean/bb/bb"; export BBHOME
MAILFILE="/var/mail/$BBUSER"
REPLYPFX="[RrAa][EeWw]:"
DELAY=60
ACK=""		# Set to Y if you want a confirmation message by default

#######################################################
# START SCRIPT

# First store the incoming message...
FILE="/tmp/ACKME.$BBUSER.$$"
FILESUBJ="/tmp/ACKME.SUBJECT.$BBUSER.$$"

set -f
rm -f $FILE
rm -f $FILESUBJ

dd of=$FILE 2>/dev/null

SAVEMAIL="FALSE"

if [ -d "$BBHOME" ]
then
	. $BBHOME/etc/bbdef.sh

	# Keep only valid characters
	$GREP -i "^Subject:[ 	]*$REPLYPFX" $FILE | $HEAD -1 | $SED 's/[^a-zA-z0-9.= 	]//g' > $FILESUBJ 2>/dev/null

	# If it's a valid BB reply
	# We should have something in this format
	# Subject Re BB 9999999 Host.service 999999999999999
	NUMBER=""
	if [ -s $FILESUBJ ]
	then
		set `$CAT "$FILESUBJ"` 2>&1 >/dev/null
		while [ "$#" -gt 1 ]
		do
			# echo $1
			if [ "$1" = "BB" ]
			then
				NUMBER=`echo "$2" | $SED "s/[^0-9]//g"`
				# echo $NUMBER
				if [ "$2" = "$NUMBER" ]
				then
					break;
				fi
			fi
			shift
		done

		if test "$NUMBER"
		then
			DELAYVAL=`$CAT $FILESUBJ | $GREP -i "DELAY" | $SED 's/^.*[Dd][Ee][Ll][][Aa][Yy]=\([0-9]*\).*$/\1/' 2>/dev/null`
			if [ "$DELAYVAL" != "" ]
			then
				DELAY="$DELAYVAL"
			fi

			# Note that spaces are converted to + and will be converted back to spaces
			# after the message has been processes
			
			MESSAGE=`$CAT $FILESUBJ | $GREP -i "MSG=" | $SED 's/^.*[Mm][Ss][Gg]=\(.*\)$/\1/' | $SED 's/[ 	]/+/g' 2>/dev/null`
			# Get the mail Id of the sender
			FROM=`$GREP -i "^From:" $FILE | $HEAD -1 | $SED 's/[^a-zA-Z0-9.@_<> 	"-]//g' | $SED 's/^From[ 	]*\(.*$\)/\1/g' 2>/dev/null`

			if [ "$MESSAGE" = "" ]
			then
				MESSAGE=`echo "$FROM" | $SED 's/[ 	]/+/g' 2>/dev/null`
			fi

			# ack_event must go to all BBPAGERS...  RAC
			OLDBBDISPLAYS=$BBDISPLAYS
			BBDISPLAYS=$BBPAGERS
			$BB $BBPAGE "ack ack_event ${NUMBER} ${DELAY} ${MESSAGE}"
			BBDISPLAYS=$OLDBBDISPLAYS

			ACKVAL=`$CAT $FILESUBJ | $GREP -i "ACK" | $SED 's/^.*[Aa][Cc][Kk]=\([YyNn]\).*$/\1/' 2>/dev/null`
			if [ "$ACKVAL" != "" ]
			then
				ACK="$ACKVAL"
			fi
			if [ "$ACK" = "Y" -o "$ACK" = "y" ]
			then
				FROMMAIL=`echo $FROM | $SED 's/\([a-zA-Z0-9._-]*@[a-zA-Z0-9._-]*\)/<<<&>>>/1' |\
						$SED 's/^.*\(<<<[a-zA-Z0-9._-]*@[a-zA-Z0-9._-]*>>>\).*$/\1/g' |\
						$SED 's/["<>]//g' 2>/dev/null`
				if [ "$FROMMAIL" != "" ]
				then
					echo "This message is an acknowledgment of the reception
of the ACK message for the notification ID $NUMBER
It does not guarantee success of the acknowledgment" |\
						$MAIL "Received ACK for !BB - $NUMBER!" "$FROMMAIL"
				fi
			fi
		else
			SAVEMAIL="TRUE"
		fi
	else
		SAVEMAIL="TRUE"
	fi
else
	SAVEMAIL="TRUE"
fi

if [ -f "$MAILFILE" -a "$SAVEMAIL" = "TRUE" ]
then
	cat $FILE >> $MAILFILE
fi

rm -f $FILE
rm -f $FILESUBJ

exit 0
