#!/bin/sh

# bb-network.sh
#
# BIG BROTHER NETWORK MONITORING SCRIPT
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#
# SEND THE TEST RESULTS TO THE DISPLAY SERVER USING bb

# echo "***** BBHOME IS SET TO $BBHOME IN bb-net"
if test ! "$BBTMP"			# GET DEFINITIONS IF NEEDED
then
	. $BBHOME/etc/bbdef.sh		# INCLUDE STANDARD DEFINITIONS
fi

# Create multiple threads of bb-network.sh as requested
if [ "$BBNETTHREADS" != "" -a "$BBNETHOSTS" = "" ]
then
	if [ "$BBNETTHREADS" -gt 1 ]
	then
		# NUMBER OF LINES IN etc/bb-hosts
		BBHOSTLINES=`$GREP "^[0-9]" $BBHOSTS | $WC`
		BBHOSTLINES=`echo $BBHOSTLINES`

		# YOU CAN'T HAVE MORE THREADS THAN LINES
		if [ "$BBHOSTLINES" -lt "$BBNETTHREADS" ]
		then
			BBNETTHREADS=$BBHOSTLINES
		fi

		# HOW MANY LINES FROM etc/bb-hosts TO SAVE
		# IN TEMPORARY HOSTS FILE
		NUMLINES=`$EXPR $BBHOSTLINES / $BBNETTHREADS`

		# SAVE EACH TEMPORARY HOSTS FILE AND CALL bb-network.sh AGAIN
		LOOPS=1
		while [ "$LOOPS" -le "$BBNETTHREADS" ]
		do
			TEMPLINES=`$EXPR $LOOPS \* $NUMLINES`
			BBNETHOSTS=$BBTMP/bb-hosts.$$.$LOOPS
			export BBNETHOSTS
			$GREP "^[0-9]" $BBHOSTS | $HEAD -$TEMPLINES | $TAIL -$NUMLINES > $BBNETHOSTS
			$BBHOME/bin/bb-network.sh &
			LOOPS=`$EXPR $LOOPS + 1`
		done
		
		# ANY LINES LEFT TO DO
		REMAINLINES=`$EXPR $BBHOSTLINES - $TEMPLINES`
		if [ "$REMAINLINES" -gt 0 ]
		then
			BBNETHOSTS=$BBTMP/bb-hosts.$$.$LOOPS
			export BBNETHOSTS
			$GREP "^[0-9]" $BBHOSTS | $TAIL -$REMAINLINES > $BBNETHOSTS
			$BBHOME/bin/bb-network.sh &
			LOOPS=`$EXPR $LOOPS + 1`
		fi

		# Do dialups on their own
		BBNETHOSTS=$BBTMP/bb-hosts.$$.$LOOPS
		export BBNETHOSTS
		$GREP "^dialup" $BBHOSTS >> $BBNETHOSTS
		if [ "$?" -eq 0 ]
		then
			$BBHOME/bin/bb-network.sh &
		else
			$RM -f $BBNETHOSTS
		fi

		# Wait for all child processes to terminate	
		wait
	
		exit 0
	fi
fi

# IF # OF THREADS WAS 1 OR UNSPECIFIED THEN USE etc/bb-hosts
# SUCH THAT BBNETHOSTS WAS NEVER SET
if [ "$BBNETHOSTS" = "" ]
then
	BBNETHOSTS="$BBTMP/bbnethosts.$$.1"
	$CAT $BBHOSTS > $BBNETHOSTS
fi

#
# SMM - NEW FOR 1.05
# ALLOW TESTING OF BANKS OF CONNECTIONS ONLY
# FORMAT OF THE LINE IS
# dialup name IP-ADDRESS COUNT
# dialup modem-bank1 132.220.50.1 16
#
$GREP "^dialup" $BBNETHOSTS |
while read line
do
	set $line
	if test "$#" != "4"
	then
		echo "MISSING ARGUMENTS FOR dialup"
		echo "Line format is:"
		echo "dialup pool-name start-ip count"
		exit 1
	fi
	NAME="$2"
	TTL="$4"
	set `echo $3 | $SED "s/\./ /g"`
	BASE="$1.$2.$3"
	START="$4"
	END=`$EXPR $START + $TTL - 1`
	# echo "NAME IS $NAME"
	# echo "TTL IS $TTL"
	# echo "BASE IS $BASE"
	# echo "START IS $START"
	# echo "END IS $END"
	LINE="FROM $BASE.$START TO $END DATA "
	while test "$START" -le "$END"
	do
		TEST="${BASE}.$START"
		# echo $TEST
		$PING $PINGPAR1 $TEST $PINGPAR2 2>/dev/null | $SED 's/octet/byte/g' | $GREP -v SO_TIMESTAMP > $BBTMP/BBPING.$$ 2>&1
		bytesfrom=`$GREP "bytes from" $BBTMP/BBPING.$$ | $GREP -vi "unreachable" | $GREP -vi "exceeded" | $GREP -vi "prohibited" 2>/dev/null`
		if [ "$bytesfrom" = "" ]
		then
			LINE="$LINE clear "
		else
			LINE="$LINE green "
		fi
		START=`$EXPR $START + 1`
		$RM -f $BBTMP/BBPING.$$
	done
	# echo "LINE IS $LINE"
	$BB $BBDISP "status dialup.${NAME} green `date` $LINE" 
done

#
# Initialize bbcombo.sh, without BBCOMBOID,
#  bb-combo.sh sends the status immediately
#  at least not here :)
#
BBCOMBOID="$$"
export BBCOMBOID

$BBHOME/bin/bb-combo.sh start

$GREP "^[0-9]" $BBNETHOSTS |
while read line
do
	set $line
	HOSTIP=$1			# HOST IP ADDRESS
	FULLNAME=$2
	IPADDR=`echo $1 | $SED "s/\.//g"`
	#
	# SMM - NEW FOR 1.07c
	# IMPLICIT SUPPORT FOR dhcp STATIONS WHEN LISTED AS 0.0.0.0
	#
	if test "$HOSTIP" = "0.0.0.0"
	then
		PINGHOST=$FULLNAME	# SUPPORT PING BY NAME FOR DHCP ONLY
	else
		PINGHOST=$HOSTIP
	fi
	#
	# SMM - NEW FOR 1.04
	# USE FULLY QUALIFIED MACHINE NAMES?
	# DOT -> COMMA -> DOT FOR WEB DISPLAY
	#
	if test "$FQDN" = "TRUE"
	then
		set `echo $FULLNAME | $SED "s/\./,/g"`
	else
		set `echo $FULLNAME | $SED "s/\./ /"`
	fi
	MACHINE=$1

	#
	# SMM 1.09d - SUPPORT FOR ALIAS DISPLAY
	#
	echo "$line" | $GREP "[ 	]testip" > /dev/null 2>&1
	if [ "$?" = "0" ]
	then
		HOSTSTRING=$HOSTIP
	else
		HOSTSTRING=$FULLNAME
	fi

	CONN_TEST_FAILED="FALSE"

	DIALUP=FALSE
	#
	# is the dialup directive defined in the entry
	#
	echo "$line" | $GREP "[^ 	]*[ 	]*[^ 	]*[ 	]*dialup" > /dev/null 2>&1
	if test $? = "0"
	then
		DIALUP=TRUE
	fi

	# Check if we do the connection test
	# Enabled by default
	if [ "$CONNTEST" = "TRUE" ]
	then
		#
		#================================================
		# CONNECTIVITY TEST
		# Added support for non-standard pings. gunnar@bitcon.no
		#
		# SMM: PING BY IP ADDRESS INSTEAD OF BY NAME. (v1.04a)
		# SMM: TRY THREE TIMES BEFORE PAGING (v1.06b)
		# 	BB SHOULD NOT BE A 3AM WAKE UP CALL...
		#================================================

		#
		# SMM 1.07
		# TO PING OR NOT TO PING
		# FIXED FALSE POSITIVES THANKS TO consult@netcom.com
		# SMM ADDED noconn KEYWORD
		#
		echo "$line" | $GREP "[^ 	]*[ 	]*[^ 	]*[ 	]*noconn" > /dev/null 2>&1
		ERR=$?
		NOCONN=$ERR
		if test "$ERR" != "0"
		then
			echo "$line" | $GREP "noping" > /dev/null 2>&1
			ERR=$?
		fi
		if test $ERR = "0"
		then
			COLOR="clear"			# PING TEST DISABLED BY REQUEST
			LINE="Ping test disabled by request (noping)"
		else
			COLOR="green"			# INNOCENT UNTIL PROVEN GUILTY
			LINE=`$BBHOME/bin/bb-ping.sh $PINGHOST $DIALUP`
			ERR="$?"
		fi

		if test $ERR != "0"
		then
			if test "$DIALUP" = "TRUE"
			then
				COLOR="clear"
				LINE="bb-network.sh: $FULLNAME offline (dialup)"
				CONN_TEST_FAILED="TRUE"
			else
				CONN_TEST_FAILED="TRUE"
                        	echo "$NONETPAGE" | $GREP "ping" >/dev/null 2>&1
                        	if test $? = "1"        # NOT FOUND - PAGE
                        	then
					COLOR="red"
                        	else
                        		COLOR="yellow"
                        		LINE="$LINE - configured not to page"
				fi
			fi
		else
			echo "$LINE" | grep "WARNING" > /dev/null 2>&1
			if test "$?" = "0"
			then
				COLOR="yellow"
			fi
		fi
		#
		# SMM 1.2c
		# IF THERE'S A noconn SYMBOL - NO REPORT!
		#
		if test "$NOCONN" != 0 
		then
			# Do we send clear status for noping & 0.0.0.0 ?
			# If so, continue on (we always send message when color != clear)
			if [ "$DIALUP" = "TRUE" -o "$COLOR" = "clear" -a "$NOPINGCLEAR" = "TRUE" -o "$COLOR" != "clear" ]
			then
				#$BB $BBDISP "status ${MACHINE}.conn $COLOR `date` $LINE"
				$BBHOME/bin/bb-combo.sh add "status ${MACHINE}.conn $COLOR `date` $LINE"
			fi
		fi
	fi

	#
	# THIS IS NEW WITH 1.04... TEST FOR OTHER SERVICES HERE...
	# SEND THE RESULTS TO THE USUAL PLACE...
	#
	set $line			# GET ALL THE LINE ARGS
	shift; shift;			# SKIP THE IP-ADDR AND NAME

	if [ "$#" -ne 0 ]
	then
		newline=""
		httparg=""
		# REWRITE THE ARGUMENTS SUCH THAT http DIRECTIVES ARE BUNCHED TOGETHER
		while [ "$#" -ne 0 ]
		do
			case $1
			in
				[hH][tT][tT][pP]://* | [hH][tT][tT][pP][sS]://* )
					# Convert http[s]:// qualifier to lowercase
					httploc1=`echo "$1" | $SED 's![hH][tT][tT][pP][sS]://!https://!1'`
					httploc2=`echo "$httploc1" | $SED 's![hH][tT][tT][pP]://!http://!1'`
					if [ "$httparg" = "" ]
					then
						httparg="$httploc2"
					else
						httparg="${httparg}|${httploc2}"
					fi
					;;
				* )
					newline="$newline $1"
					;;
			esac
		
			shift
		done
		set $newline $httparg
	fi
			
	while test "$1"			# AS LONG AS WE HAVE ARGS
	do
		# No need to do the following
		if [ "$1" = "#" -o "$1" = "noconn" -o "$1" = "noping" -o "$1" = "dialup" -o "$1" = "testip" ]
		then
			shift
			continue
		fi

		line="$*"		# SAVE THIS..

		TESTREVERSED=FALSE
		SVCDIALUP=FALSE
		REVERSE_IP_CLEAR=FALSE
		arg=$1
		currarg=""
		while [ "$arg" != "$currarg" ]
		do
			for prefix in '?' '!' '~'
			do
				currarg=$arg
				case $prefix
				in
					\! )	# Reverse result ?
						arg=`echo "$currarg" | $SED 's/^!//1'`
						if [ "$arg" != "$currarg" ]
						then
							TESTREVERSED=TRUE
						fi
						;;

					\? )	# Any service that has the ? sign in it signifies
						# to consider this service as dialup
						arg=`echo "$currarg" | $SED 's/^?//1'`
						if [ "$arg" != "$currarg" ]
						then
							SVCDIALUP=TRUE
						fi
						;;

					\~ )	#
						arg=`echo "$currarg" | $SED 's/^~//1'`
						if [ "$arg" != "$currarg" ]
						then
							REVERSE_IP_CLEAR=TRUE
						fi
						;;

					* )	# never supposed to reach here
						;;
				esac
			done
		done

		# Is the directive a NET service defined in BBNETSVCS
		tmparg=""
		svc=""
		OLDIFS=$IFS
		IFS=":"
		set $arg
		IFS=$OLDIFS
		echo " $BBNETSVCS " | $GREP "[ 	]${1}[ 	]" >/dev/null 2>&1
		if [ "$?" -eq 0 ]
		then
			tmparg=$arg
			arg=NETSVC
			svc=${1}
			
		fi

		case $arg
		in

		#
		# Add telnet test Tony DeJoie (tony@bellcore.com)
		# Add ssh test Kim Shrier (kim@tinker.com)
		#
		NETSVC )
			#
			# OK... GET THE SERVICE NUMBER OUT OF /etc/services
			# CAN BE SEPERATED BY SPACES/TABS... (v1.04a)
			#
			arg=$tmparg
			OLDIFS=$IFS
			IFS=":"
			set $arg
			IFS=$OLDIFS
			SVCNAME=$1
			USEIP=$2

			# WAS A SERVICE NAME DEFINED
			# CHECK FOR :22 instead of ssh:22
			if [ "$SVCNAME" = "" ]
			then
				continue
			fi

			if [ "$USEIP" != "" ]
			then
				# We could have multiple : entries: i.e.  port:1234:q:s
				# Just keep 1234:q:s for USEIP
				USEIP=`echo $arg | $SED "s/"$SVCNAME"//g"`
			fi
			SVC=""

			bbnetargs=""
			notdone=1
			silent=0
			while [ "$notdone" -eq 1 ]
			do
				case "$USEIP"
				in
					*:s* )	# Silent - just connect to port
						bbnetargs="${bbnetargs} -s "
						silent=1
						USEIP=`echo "$USEIP" | $SED 's/:s//g'`
						;;
					*:q* )	# Don't return timing statistics
						bbnetargs="${bbnetargs} -q "
						USEIP=`echo "$USEIP" | $SED 's/:q//g'`
						;;
					*:Q* )	# Don't report errors
						bbnetargs="${bbnetargs} -Q "
						USEIP=`echo "$USEIP" | $SED 's/:Q//g'`
						;;
					* )
						USEIP=`echo "$USEIP" | $SED 's/://g'`
						notdone=0
						;;
				esac
			done

					
			# ONLY SERVICE NAME WAS SPECIFIED
			if [ "$USEIP" = "" ]
			then
				#
				# SMM 1.07a - 21 JUN 98
					# A LITTLE FRIENDLY CHECK HERE WILL SAVE LOTS OF GRIEF
				#
				SVCLINE=`$GREP "^${SVCNAME}[ 	]" /etc/services | $GREP "/tcp"`
				if test "$SVCLINE" = ""	# HOUSTON, WE HAVE A PROBLEM
				then
					echo "bb-network.sh: ERROR on bb-hosts line: $FULLNAME"
					echo "$SVCNAME NOT in /etc/services (CHECK SPELLING)"
					set $line
					shift
					continue
				fi

				set $SVCLINE

				while test "$SVC" = ""
				do
					echo $1 | $GREP "/tcp" > /dev/null
					if test "$?" = "0"
					then
						SVC=`echo $1 | $SED "s/\/tcp//"`
						#echo "FOUND SERVICE: $SVCNAME: $SVC"
						break
					fi
					shift
				done
			else
				# SERVICE PORT NUMBER SPECIFIED
				# IS IT VALID ?
				USEIPTMP=`echo "$USEIP" | $SED 's/[^0-9]//g'`
				if [ "$USEIP" != "$USEIPTMP" ]
				then
					# NOPE
					continue
				fi
				SVC="$USEIP"
			fi

			# echo "SETTING UP PROTOCOL SPECIFIC DATA"
			# By default bbnet sends "quit"
			case $SVCNAME
			in
				imap* )
					# Added  tag as per RFC-2060, it was "* LOGOUT" but that's invalid
					# thanks to Dave Carrigan <dave@rudedog.org>
					textmsg="ABC123 LOGOUT"
					;;
				ssh*)
					# Make it connect with a recognizable token
					# Suggested by scott@PacketPushers.com
					textmsg="Big-Brother-Monitor-$BBREL"
					;;
				smtp* )
					# To get rid of NOQUEUE messages
					# try this
					# Thanks to Douwe Dijkstra <douwe@douwe.net>
					# uncomment next two lines and comment out the ones below
#					textmsg="MAIL
#QUIT"
					# For now the old way
					textmsg="QUIT"
					;;
				*)
					textmsg="DONTUSEARGS"
					;;
			esac
			# echo "TESTING SERVICE $SVC"
			# if "" don't send any argument, use bbnet default
			RC=0
			if [ "$textmsg" != "DONTUSEARGS" ]
			then
				if [ "$TESTREVERSED" != "TRUE" -a "$SVCDIALUP" != "TRUE" -a "$DIALUP" != "TRUE" ]
				then
					OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTSTRING}:${SVC}" "$textmsg"` 
					RC=$?
				else
					OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTSTRING}:${SVC}" "$textmsg" 2>/dev/null` 
					RC=$?
				fi
			else
				if [ "$TESTREVERSED" != "TRUE" -a "$SVCDIALUP" != "TRUE" -a "$DIALUP" != "TRUE" ]
				then
					OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTSTRING}:${SVC}" ` 
					RC=$?
				else
					OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTSTRING}:${SVC}" 2>/dev/null` 
					RC=$?
				fi
			fi

			#
			# SMM - 1.09d
			# SUPPORT SERVICES EVEN WHEN THEY'RE NOT IN THE DNS
			#
			usedip=0
			if test "$RC" = "1" -a "$HOSTSTRING" = "$FULLNAME"	# HOST NOT FOUND... TRY IP...
			then
				if [ "$textmsg" != "DONTUSEARGS" ]
				then
					if [ "$TESTREVERSED" != "TRUE" -a "$SVCDIALUP" != "TRUE" -a "$DIALUP" != "TRUE" ]
					then
						OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTIP}:${SVC}" "$textmsg" ` 
						RC=$?
					else
						OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTIP}:${SVC}" "$textmsg" 2>/dev/null` 
						RC=$?
					fi
				else
					if [ "$TESTREVERSED" != "TRUE" -a "$SVCDIALUP" != "TRUE" -a "$DIALUP" != "TRUE" ]
					then
						OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTIP}:${SVC}" ` 
						RC=$?
					else
						OUTPUT=`$BBHOME/bin/bbnet $bbnetargs "${HOSTIP}:${SVC}" 2>/dev/null` 
						RC=$?
					fi
				fi
				usedip=1
			fi

			RC2=0

			# Check if service must NOT be running
			if [ "$TESTREVERSED" = "TRUE" ]
			then
				if [ "$RC" -ne 0 ]
				then
					RC=0
				else
					RC=1
				fi
			elif [ "$RC" -eq 0 -a "$silent" -ne 1 ]
			then
				# Check return values of tests

				case $svc in

					ftp )
						case "$OUTPUT" in
							220* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					smtp )
						case "$OUTPUT" in
							220* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					pop3|pop-3|pop2|pop-2 )
						case "$OUTPUT" in
							'+'[Oo][Kk]*|'+ '[Oo][Kk]* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					imap3|imap4 )
						case "$OUTPUT" in
							'* '[Oo][Kk]*|'+ 'Oo][Kk]* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					nntp )
						case "$OUTPUT" in
							200* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					ssh|ssh1|ssh2 )
						case "$OUTPUT" in
							[Ss][Ss][Hh]-* )
								;;
							* )
								# Incorrect greet
								RC2=1
								;;
						esac	
						;;

					* )
						;;
				esac
				if [ "$RC2" -ne 0 ]
				then
					OUTPUT1="Unexpected response
["
					OUTPUT2=`echo "$OUTPUT" | $SED '/^Seconds.*$/d' | $SED '/^$/d'`
					OUTPUT3="${OUTPUT1}${OUTPUT2}]"
					OUTPUT4=`echo "$OUTPUT" | $GREP "^Seconds"`
					OUTPUT="$OUTPUT3

$OUTPUT4"
				fi
			fi

			if [ "$usedip" -eq 1 ]
			then
				OUTPUT="$OUTPUT
*** Note: $FULLNAME not found in DNS... Tested using IP addr directly..."
			fi

			if test "$RC" != "0"
			then
				# echo "SERVICE IS BROKEN"
				#
				# IF IT'S BROKEN, THEN SCREAM IF WE HAVE TO
				#
				if [ "$TESTREVERSED" = "TRUE" ]
				then
					LINE="SERVER - $SVCNAME UP"
				else
					LINE="SERVER - $SVCNAME DOWN"
				fi

				# Set the individual dialup tests (? flag) to clear
				# Fake a failed conn test
				OLD_CONN_TEST_FAILED=$CONN_TEST_FAILED
				if [ "$SVCDIALUP" = "TRUE" ]
				then
					CONN_TEST_FAILED=TRUE
					OFFLINE="(service offline)"
				else
					OFFLINE="(host offline)"
				fi

				#
				# NO MORE RED DOTS FOR DIALUP NETWORK STUFF
				# WHEN THE CONNECTION TEST FAILED
				# TESTREVERSED WILL ALWAYS YIELD YELLOW/RED HAS THE TEST REALLY CONNECTED ...
				#
				SET_TO_CLEAR="FALSE"
				if [ "$IPTEST_2_CLEAR_ON_FAILED_CONN" = "TRUE" -a "$REVERSE_IP_CLEAR" != "TRUE" ]
				then
					SET_TO_CLEAR="TRUE"
				elif [ "$IPTEST_2_CLEAR_ON_FAILED_CONN" = "FALSE" -a "$REVERSE_IP_CLEAR" = "TRUE" ]
				then
					SET_TO_CLEAR="TRUE"
				fi
				if [ "$CONN_TEST_FAILED" = "TRUE" -a "$TESTREVERSED" != "TRUE" -a "$SET_TO_CLEAR" = "TRUE" ]
				then
                                	COLOR="clear"
					LINE="$LINE $OFFLINE"
				else

					#
					# SMM NEW IN 1.07b
					# CORRECT TEST FOR NETWORK SERVICE PAGING
					# THANKS TO: Patrick Hopewell <p.hopewell@utoronto.ca>
					#
					echo "$NONETPAGE" | $GREP "$SVCNAME" > /dev/null 2>&1
					if test $? = "1"	# NOT FOUND - PAGE
                			then
                        			COLOR="red"
					else
                        			COLOR="yellow"
						LINE="$LINE - configured not to page"
					fi
				fi
				CONN_TEST_FAILED=$OLD_CONN_TEST_FAILED
			else
				if [ "$RC2" -eq 0 ]
				then
					COLOR="green"
					if [ "$TESTREVERSED" = "TRUE" ]
					then
						LINE="$SVCNAME OK: SERVICE IS NOT RUNNING"
					else
						LINE="$SVCNAME OK: $OUTPUT"
					fi
				else
					case "$RC2" in
						1 ) # red
							COLOR="red"
							;;

						* ) # others, yellow
							COLOR="yellow"
							;;
					esac
					LINE="$SVCNAME NOT OK: $OUTPUT"
				fi
				# echo $OUTPUT
			fi
			#$BB $BBDISP "status ${MACHINE}.${SVCNAME} $COLOR `date` $LINE" 
			$BBHOME/bin/bb-combo.sh add  "status ${MACHINE}.${SVCNAME} $COLOR `date` $LINE" 
			;;

		# NEW IN 1.6 - A TEST FOR BB ITSELF
		# USEFUL FOR MULTIPLE INSTANCES
		bbd )	# echo "looking for bbd server"
			if test "$HOSTIP" = "0.0.0.0"	# SMM 1.10 DDNS
			then
				$BB ${FULLNAME} "dummy" > /dev/null
			else
				$BB ${HOSTIP} "dummy" > /dev/null
			fi
			if test "$?" != "0"
			then
				LINE="BBD Server on ${FULLNAME} down"
				echo "$NONETPAGE" | $GREP "bbd" > /dev/null 2>&1
				if test $? = "1"	# NOT FOUND - PAGE
				then
					COLOR="red"
				else
					COLOR="yellow"
                                	LINE="$LINE - configured not to page"
				fi
			else
				COLOR="green"
				LINE="BBD Server OK"
			fi

			#$BB $BBDISP "status ${MACHINE}.$arg $COLOR `date` $LINE"
			$BBHOME/bin/bb-combo.sh add  "status ${MACHINE}.$arg $COLOR `date` $LINE"

			;;

		#
		# NEW IN 1.06C 
		# DNS TESTING FROM Frank T. Kujawski <frank@bluegrass.net>
		#
		dns | dig )	# echo "looking for domain server"
			if [ "$arg" = "dns" ]
			then
				if test "$HOSTIP" = "0.0.0.0"	# SMM 1.10 DDNS
				then
					RCSTR=`$NSLOOKUP ${FULLNAME} ${FULLNAME} 2>&1`
				else
					RCSTR=`$NSLOOKUP ${FULLNAME} ${HOSTIP} 2>&1`
				fi
				RC="$?"
				# Sometimes nslookup will return 0 even on failure
				# Mostly in new versions of bind
				if [ "$RC" -eq 0 ]
				then
					echo "$RCSTR" | $GREP -i "can't find" >/dev/null 2>&1
					if [ "$?" -eq 0 ]
					then
						RC=1
					fi
				fi
				
			else
				if test "$HOSTIP" = "0.0.0.0"	# SMM 1.10 DDNS
				then
					RCSTR=`$DIG @${FULLNAME} ${FULLNAME} 2>&1`
				else
					RCSTR=`$DIG @${HOSTIP} ${FULLNAME} 2>&1`
				fi
				RC="$?"
				# Sometimes nslookup will return 0 even on failure
				# Mostly in new versions of bind
				if [ "$RC" -eq 0 ]
				then
					echo "$RCSTR" | $GREP -i "Bad server" >/dev/null 2>&1
					if [ "$?" -eq 0 ]
					then
						RC=1
					fi
					#
					# thanks to Benoit.Schmid@adm.unige.ch
					#
					echo "$RCSTR" | $GREP -i "timed out" >/dev/null 2>&1
					if [ "$?" -eq 0 ]
					then
						RC=1
					fi
				fi
				# Look for the status of the query in the
				# returned string
				if [ "$RC" -eq 0 ]
				then
					# Query was successful only if status = NOERROR
					RC=1
					set $RCSTR
					while [ "$#" -gt 0 ]
					do
						arg1=`echo "$1" | $SED 's/[^a-zA-Z:]//g' 2>/dev/null`
						if [ "$arg1" = "status:" -o "$arg1" = "Status:" ]
						then
							arg2=`echo "$2" | $SED 's/[^a-zA-Z:]//g' 2>/dev/null`
							if [ "$#" -gt 1 -a "$arg2" = "NOERROR" ]
							then
								RC=0
							fi
							break
						fi
						shift
					done
				fi
			fi
			if test "$RC" != "0"
			then
				LINE="DNS Server on ${FULLNAME} down"
				# IT HELPS TO SEARCH FOR THE RIGHT SERVICE!
				# Takahiro Yugawa <yugawa@itjit.ad.jp>
				if [ "$arg" = "dns" ]
				then
					echo "$NONETPAGE" | $GREP "dns" > /dev/null 2>&1
				else
					echo "$NONETPAGE" | $GREP "dig" > /dev/null 2>&1
				fi
				if test $? = "1"	# NOT FOUND - PAGE
				then
					COLOR="red"
				else
					COLOR="yellow"
                                	LINE="$LINE - configured not to page"
				fi
			else
				COLOR="green"
				LINE="DNS Server OK"
			fi

			#$BB $BBDISP "status ${MACHINE}.$arg $COLOR `date` $LINE"
			$BBHOME/bin/bb-combo.sh add  "status ${MACHINE}.$arg $COLOR `date` $LINE"

                        ;;

		#
		# SMM 1.2c - SUPPORT FOR https TESTING (finally)
		#
		http* )	# echo "DOING HTTP/HTTPS TEST..."
			newarg=`echo "$arg" | $SED 's/|http/ http/g'`
			set $newarg
			URLS=$*
			COLOR="green"
			LINE=""
			for URL in $URLS
			do
				echo "$URL" | $GREP "^https" > /dev/null 2>&1
				if test "$?" = "0"	# USE LYNX FOR SECURE TESTING
				then
					HTTP="https"
					# echo "USING LYNX TO TEST $URL "
					$LYNX "$URL" > $BBTMP/HTTP.$$ 2>&1
				else
					HTTP="http"
					# echo "USING BBNET TO TEST $URL "
					$BBHOME/bin/bbnet "$URL" > $BBTMP/HTTP.$$ 
				fi
				if test "$?" != 0
				then
					TMPLINE="$URL - No connection
`cat $BBTMP/HTTP.$$` "
					echo "$NONETPAGE" | $GREP "http" > /dev/null 2>&1
					if test $? = "1"	# NOT FOUND - PAGE
					then
						echo "$line" | $GREP "[^ 	]*[ 	]*[^ 	]*[ 	]*dialup" > /dev/null 2>&1
						if test $? = "0"
						then
							if [ "$COLOR" = "green" ]
							then
								COLOR="yellow"
							fi
        	                        		LINE="${LINE}

&yellow $TMPLINE (no page on dialup)"
						else
							COLOR="red"
        	                        		LINE="${LINE}

&red $TMPLINE"
						fi
					else
						if [ "$COLOR" = "green" ]
						then
							COLOR="yellow"
						fi
                                		LINE="${LINE}
&yellow $TMPLINE (configured not to page)"
					fi
				else
					#
					# CHECK FOR A SERVER ERROR HIDING HERE... CHECK FOR IT
					#

					#
					# THANKS TO: Douwe Dijkstra <D.Dijkstra@Twinfo.nl>
					# Version 1.04b
					#
					read HTTPVER RC STATUSMESSAGE < $BBTMP/HTTP.$$
					# GET RID OF CRAP IN RC JUST IN CASE
					# Thanks to Marc.Pohl@wwf-gruppe.de
					RC=`echo "$RC" | $SED 's/[^0-9]//g'`
					case $RC in
    					'200'|'401'|'301'|'302')
         					TMPCOLOR="green"
						TMPLINE="Server OK"
         					;;
					'400'|'403'|'404')
         					COLOR="red"
         					TMPCOLOR="red"
						TMPLINE="Trouble getting page"
         					;;
					# From Christian.Perrier@onera.fr
    					'500'|'501'|'503')	
         					COLOR="red"
         					TMPCOLOR="red"
						TMPLINE="Server Error"
         					;;
    					*)
						if [ "$COLOR" = "green" ]
						then
         						COLOR="yellow"
						fi
         					TMPCOLOR="yellow"
						TMPLINE="Server **NOT** OK"
         					;;
					esac
					#
					# SMM 1.07c - SEND http HEADERS ALONG
					#
					LINE="${LINE}


&$TMPCOLOR $URL - $TMPLINE
`cat $BBTMP/HTTP.$$` "
				fi
			done
			$RM -f $BBTMP/HTTP.$$
			#$BB $BBDISP "status ${MACHINE}.http $COLOR  `date` $LINE"
			$BBHOME/bin/bb-combo.sh add  "status ${MACHINE}.http $COLOR  `date` $LINE"
			;;
		\# | BBPAGER* | BBDISPLAY* | BBNET | BBRELAY* | dialup | noping  | noconn | testip  )
			# These tags do nothing here
			;;
		* )
			# At one point this message will be enabled
			# NOPE, the directives will probably for external tests
			# echo "Invalid bb-hosts directive: $1"
			;;
		esac
		set $line		# RESTORE...
		shift;			# GET NEXT ARGUMENT
	done
done

$BBHOME/bin/bb-combo.sh end

$RM -f $BBNETHOSTS

exit 0


