#!/bin/sh
#
# bbinc-server.sh
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

BBWWW="${BBHOME}/www"			# WHERE www/ IS LOCATED
BBREP="${BBWWW}/rep"			# WHERE GENERATED REPORTS LIVE
BBHTML="${BBWWW}/html"			# WHERE GENERATED REPORTS LIVE
BBNOTES="${BBWWW}/notes"	           # WHERE THE SYSTEM NOTES LIVE

#
OLDIFS=$IFS
IFS="/" 
set $BBHOME
IFS=$OLDIFS

# Usually the BB saved logs lives in the directory on top the BBHOME
BBTOP=""
while [ "$#" -gt 1 ]
do
	# Don't accept empty args
	if [ "$1" != "" ]
	then
		BBTOP="$BBTOP/$1"
	fi
	shift
done

BBVAR=$BBTOP/bbvar
# If you want a different BBVAR just modify the next line and uncomment
# BBVAR=/some/directory/structure

BBLOGS="${BBVAR}/logs"		# WHERE THE LOG FILES LIVE
BBHISTLOGS="${BBVAR}/histlogs"	# WHERE THE HISTLOG FILES LIVE
BBHIST="${BBVAR}/hist"		# WHERE THE HIST FILES LIVE
BBDATA="${BBVAR}/data"		# WHERE THE DATA FILES LIVE (data message type)
BBACKS="${BBVAR}/acks"		# WHERE THE ACKS/NOTIF LOGS  LIVE
BBDISABLED="${BBVAR}/disabled"	# WHERE THE DISABLE TAG FILES  LIVE
export BBREP BBTOP BBVAR BBLOGS BBHISTLOGS BBHIST BBDATA BBACKS BBDISABLED BBWWW BBNOTES BBHTML

NETERR="7"				# NETWORK ERROR 7 + PORT NUMBER
					# KEEP FOR BACKWARD COMPATABILITY
export NETERR

# --------------------------------------------------
# SMM NEW IN 1.3
# TITLES FOR DISPLAY ELEMENTS USED BY mkbb.sh
# THIS IS TO FACILITATE CHANGES AND TRANSLATION
# --------------------------------------------------
MKBBLOCALCOLS=1
MKBBLOCAL="<B><I>Pages Hosted Locally</I></B>"
MKBBSUBLOCAL="<B><I>Subpages Hosted Locally</I></B>"
MKBBREMOTE="<B><I>Remote Status Display</I></B>"
export MKBBLOCALCOLS MKBBLOCAL MKBBREMOTE MKBBSUBLOCAL

# YOU CAN CHANGE FONT ATTRIBUTES FOR ROWS AND COLUMNS HERE
# THIS IS USED AS TITLES FOR THE TABLES
MKBBTITLE="COLOR=ivory SIZE=+1"

# THIS IS USED FOR THE MACHINE NAMES
MKBBROWFONT="SIZE=+1 COLOR=\"#FFFFCC\" FACE=\"Tahoma, Arial, Helvetica\""

# THIS IS USED FOR COLUMN HEADINGS ACROSS THE TOP
MKBBCOLFONT="COLOR=teal SIZE=-1"

# THIS IS USED FOR THE ACK MESSAGE AT THE BOOTOM OF A STATUS
MKBBACKFONT="COLOR=silver SIZE=-1"

export MKBBROWFONT MKBBCOLFONT MKBBTITLE MKBBACKFONT

MKBBMANAGE="<B><I>Managed Instances</I></B>"
export MKBBMANAGE # 2.0

DAYS="days"
HOURS="hours"
MINS="minutes"
STATUNCHMSG="Status unchanged in"
RECVFROMMSG="Status message received from"
export RECVFROMMSG STATUNCHMSG DAYS HOURS MINS

MKBBEMPTYPAGE="<FONT ${MKBBROWFONT}>There are no hosts defined on this page</FONT>"
export MKBBEMPTYPAGE

# You can change the colored dots HEIGHT and WIDTH here
DOTHEIGHT=16
DOTWIDTH=16
export DOTHEIGHT DOTWIDTH

# You can change the entire look by changing the default gifs
BBSKIN="${BBWEB}/gifs"; export BBSKIN
#BBSKIN="${BBWEB}/gifs-bb13"; export BBSKIN	# OLD 1.3 STYLE GIFS

