#!/bin/sh
#
# BIG BROTHER OVERALL EVENT LOGS HISTORY DISPLAY SCRIPT
# Robert-Andre Croteau
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

#
# Similar to the work of MR NETOPS
# (Todd Jimenez <TJimenez@outpost.com>)
# but his is nicer...
# Thanks Todd for pestering us to include this feature !!!
#
# This script should be called within mkbb.sh or mkbb2.sh
#

# SMM 1 March 2001
# SHOW RECENT EVENTS BASED ON
# Number of events
# Last N hours (max 100 events)
# Today (max 100 events)
# etc...
# For the "old way" comment out LASTMINUTES

NUMEVENTS=25		# MAX NUMBER OF EVENTS
LASTMINUTES=240		# EVENTS IN THE LAST 4 HOURS
if test $LASTMINUTES
then
	TIME=`$BBHOME/bin/touchtime -e -$LASTMINUTES`; export TIME
else
	TIME=0
fi

#
# SMM - THERE HAS GOT TO BE A BETTER WAY OF DOING THIS, EH ROB?
#

$TAIL -$NUMEVENTS $BBHIST/allevents | $AWK '$3 > '${TIME}'  { print } ' | $AWK '{x[NR] = $0} END { for (i = NR; i > 0; i--) print x[i] }' > $BBHOME/tmp/events.$$
EVENTCOUNT=`$CAT $BBHOME/tmp/events.$$ | $WC`
EVENTCOUNT=`echo $EVENTCOUNT`

if test "$EVENTCOUNT" -gt "0"
then
	if test $LASTMINUTES
	then
		if test "$EVENTCOUNT" = "1"
		then
			EVENTSTITLE="1 event received in the last $LASTMINUTES minutes";
		elif test "$EVENTCOUNT" = "$NUMEVENTS"
		then
			TIMENOW=`$BBHOME/bin/touchtime -e 0`; export TIMENOW
			set `$TAIL -1 $BBHOME/tmp/events.$$`
			# DISPLAY HOW LONG IT TOOK TO REACH NUMEVENTS...
			# NEED TIME OF THE LAST ENTRY (THE EARLIEST ONE)
			LM=`$EXPR $TIMENOW - $3`
			LM=`$EXPR $LM / 60`

			EVENTSTITLE="$NUMEVENTS events received in the last $LM minutes";
		else
			EVENTSTITLE="$EVENTCOUNT events received in the last $LASTMINUTES minutes";
		fi
	else
		EVENTSTITLE="Last $NUMEVENTS events received";
	fi

	echo "<BR><BR>
	<TABLE SUMMARY=\"$EVENTSTITLE\" BORDER=0>
	<TR BGCOLOR=\"333333\">
	<TD ALIGN=CENTER COLSPAN=4><FONT SIZE=-1 COLOR=\"teal\">$EVENTSTITLE</FONT></TD></TR>"
	$CAT $BBHOME/tmp/events.$$ |
	while read line
	do
		OUT=""
		case "$BG" in
		000000 )
			BG="000033"
			;;
		* )
			BG="000000"
			;;
		esac
	
		OUT="${OUT}
	<TR BGCOLOR=$BG>"
	
		set $line
		case "$#" in
		8 )
			;;
		* )
			OUT="${OUT}
	<TD COLSPAN=4>Invalid line in 'hist/allevents'</TD>"
			continue
			;;
		esac
	
		HOST=$1
		HOSTDIR=$HOST
		SERVICE=$2
		ATDATE=`$BBHOME/bin/touchtime -c $3`
		FROMDATE=`$BBHOME/bin/touchtime -c $4`
	
		color=$7
		bgcolor=$6
	
		argnum=0
		for color in $6 $7
		do
			case "$color" in
			re )
				color=red
				;;
			pu )
				color=purple
				;;
			ye )
				color=yellow
				;;
			gr )
				color=green
				;;
			bl )
				color=blue
				;;
			cl )
				color=clear
				;;
			* )
				color=clear
				;;
			esac
		
			case "$argnum" in
			0 )	
				tocolor=$color
				argnum=1
				;;
			* )
				fromcolor=$color
				;;
			esac
		done
	
		TOCOLORGIF=$tocolor
		TOCOLRALT=""
		#if [ -f "$BBVAR/acks/ack.${HOST}.${SERVICE}" ]
		#then
		#	case $tocolor in
		#		red | purple | yellow )
		#			TOCOLORGIF="$tocolor-ack"
		#			TOCOLRALT=":acked"
		#			;;
		#	esac
		#fi
	
		OUT="${OUT}
	<TD ALIGN=CENTER>$ATDATE</TD>"
	
		case "$tocolor" in
		clear )
			OUT="${OUT}
	<TD ALIGN=CENTER BGCOLOR=black><FONT COLOR=white>$HOST</FONT></TD>"
			;;
		* )
			OUT="${OUT}
	<TD ALIGN=CENTER BGCOLOR=$tocolor><FONT COLOR=black>$HOST</FONT></TD>"
			;;
		esac
	
		OUT="${OUT}
	<TD ALIGN=LEFT>$SERVICE</TD>"
	
		set $FROMDATE
		OUT="${OUT}
	<TD><A HREF=\"$CGIBINURL/bb-histlog.sh?HOST=$HOSTDIR&SERVICE=$SERVICE&TIMEBUF=${1}_${2}_${3}_${4}_${5}\">
	<IMG SRC=\"$BBSKIN/$fromcolor.gif\"  HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0 ALT=$fromcolor></A>"
	
	
		set $ATDATE
		OUT="${OUT}
	<IMG SRC=\"$BBSKIN/arrow.gif\" BORDER=0 ALT=\"From -&gt; To\">
	<A HREF=\"$CGIBINURL/bb-histlog.sh?HOST=$HOSTDIR&SERVICE=$SERVICE&TIMEBUF=${1}_${2}_${3}_${4}_${5}\">
	<IMG SRC=\"$BBSKIN/${TOCOLORGIF}.gif\"  HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0 ALT=\"${tocolor}${TOCOLORALT}\"></A></TD></TR>"
	
		echo "${OUT}"
	done
	echo "</TABLE>"
else
	EVENTSTITLE="No events received in the last $LASTMINUTES minutes"
	echo "<CENTER><BR>
<TABLE SUMMARY=\"$EVENTSTITLE\" BORDER=0>
<TR BGCOLOR=\"333333\">
<TD ALIGN=CENTER COLSPAN=6><FONT SIZE=-1 COLOR=\"teal\">$EVENTSTITLE</FONT></TD>
</TR>
</TABLE>
</CENTER>"
fi

$RM -f $BBHOME/tmp/events.$$	

exit 0
