/*
 * bb.h 
 * MAIN INCLUDE FILE
 * Sean MacGuire
 *
 * (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
 */

#ifndef BB_H
#define BB_H

#include <stdio.h>
#include <sys/types.h>

#ifdef _HAVE_STDLIB_H_
#include <stdlib.h>
#endif
#ifdef _HAVE_STRING_H_
#include <string.h>
#endif
#ifdef _HAVE_UNISTD_H_
#include <unistd.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/signal.h>                 /* FOR ALARMS */
#include <sys/wait.h>                 	/* FOR STUPID FREEBSD */
#include <syslog.h>                     /* FOR LOGGING */
#include <setjmp.h>                     /* FOR NON-LOCAL GOTO */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN		256
#endif

#ifdef MAXSVCNAMELEN
#undef MAXSVCNAMELEN
#endif
#define MAXSVCNAMELEN		128

#ifdef MAXHOSTSVCNAMELEN
#undef MAXHOSTSVCNAMELEN
#endif
#define MAXHOSTSVCNAMELEN	(MAXHOSTNAMELEN+MAXSVCNAMELEN)


#ifndef PATH_MAX
#define PATH_MAX	1024
#endif

#define MAXLINE  10240			/* Static buffer size for incoming BB message */

#ifndef DEBUG
#define DEBUG	0
#endif


#ifdef BZERO
#define bzero(a,b) memset(a,0,b)
#endif /* BZERO */
#ifdef SYSLOG
#define LOG_DAEMON      (3<<3)
#endif /* SYSLOG */

#define BBREL         "1.9i"
#define BBRELDATE     "Fri, 30 Dec 2005 20:19:58 PST"

#define PAGELEVELSDEFAULT "red purple"	/* Make sure same value is in bbdef.sh */

#define VALIDFILENAMECHARS	"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.,:"


#define REG_FULL        1
#define REG_BOL         2
#define REG_EOL         4
#define REG_IGN_CASE    8
#define REG_PATHEXP	16
 
#define PAGE_DEFAULT            1
#define PAGE_BASIC              2
#define PAGE_ESCALATE           4
#define PAGE_INITDELAY          8
        
#define GETDIR_FILE     1
#define GETDIR_DIR      2
#define GETDIR_OTHER    4
#define GETDIR_ALL      8

#define LINEBBHOSTS_ALL		1
#define LINEBBHOSTS_IPADDR	2
#define LINEBBHOSTS_DIALUP	4

#define BB_DISABLEMSG	1
#define BB_ENABLEMSG	2



#define NORM_COMMAS	1
#define NORM_UCASE	2
#define NORM_LCASE	4

#ifdef __GNUC__
/* GCC on darwin doesn't like function in function */
/* GCC on solaris does not seem to process a function within a function correctly */
#ifndef darwin
#ifndef solaris
#define FUNCINFUNCOK	1
#endif
#endif
#endif


#endif
