/*
 *
 * bbpage.c
 * NOTIFICATION DAEMON PROGRAM
 * Robert-Andre Croteau
 *
 * (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
 *
 */

#include "bb.h"         /* THE MAIN INCLUDE FILE */
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef TIMEH
#include <time.h>       /* FOR TIMING STUFF SMM */
#else
#include <sys/time.h>   /* FOR TIMING STUFF SMM */
#endif
#include <utime.h>      /* SMM NEW */
#include <netdb.h>
#include <dirent.h>
#ifndef ZOMBIE
#include <sys/wait.h>
#endif
#ifdef sco3
#include <unistd.h>
#endif

#ifdef MAIN
char bbprog[] = "bbpage";
#endif


#define MAXRULEARGS	7

#define MAXTRAPMSGSIZE	128

#define	MAXRCPTNAMELEN	128

extern char *bbhome,bbtmpdir[PATH_MAX+1],bbacksdir[PATH_MAX+1],bb_hosts[PATH_MAX+1];
extern int  fqdn;

static char *neterr;

extern char *gettimestr();
extern char *readfile();

static char rcpt_env[1024];				/* Static variable for putenv() of RCPT */
static char bbalphamsg_env[MAXLINE];			/* Static variable for putenv() of BBALPHAMSG */
static char ackcode_env[16];				/* Static variable for putenv() of ACKCODE */
static char bbhostsvc_env[(MAXHOSTSVCNAMELEN+1)*2];	/* Static variable for putenv() of BBHOSTSVC */
static char bbhostname_env[MAXHOSTNAMELEN+1];		/* Static variable for putenv() of BBHOSTSVC */
static char machip_env[MAXHOSTNAMELEN+1];		/* Static variable for putenv() of MACHIP */
static char bbsvcnum_env[32];				/* Static variable for putenv() of BBSVCNUM */
static char bbsvcname_env[MAXSVCNAMELEN+1];		/* Static variable for putenv() of BBSVCNAME */
static char bbnumeric_env[64];				/* Static variable for putenv() of BBNUMERIC */
static char bbcolorlevel_env[32];			/* Static variable for putenv() of BBCOLORLEVEL */
static char bbhostsvcdots_env[(MAXHOSTSVCNAMELEN+1)*2];	/* Static variable for putenv() of BBHOSTSVCDOTS */
static char bbhostsvccommas_env[(MAXHOSTSVCNAMELEN+1)*2];	/* Static variable for putenv() of BBHOSTSVCCOMMAS */
static char downsecsmsg_env[128];			/* Static variable for putenv() of DOWNSECSMSG */
static char downsecs_env[64];				/* Static variable for putenv() of DOWNSECS */
static char recovered_env[2];				/* Static variable for putenv() of RECOVERED */

struct bbpageinfo {
	char	cfgdelim[8];
	char	ignforall[256];
	char	svcerrlist[1024];
	char	pagehelpcode[32];
	char	recoverytagfile[(PATH_MAX+1)+32];
	char	pagemsgfile[PATH_MAX+32];
	int	pagedelay;
};

/*
 * Do pre-exit stuff
 */
static void cleanup(pginfop)
struct bbpageinfo *pginfop;
{

	if( strlen(pginfop->recoverytagfile) > 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"Removing %s\n",pginfop->recoverytagfile);
			fflush(stderr);
		}
		unlink(pginfop->recoverytagfile);
	}

	if( strlen(pginfop->pagemsgfile) > 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"Removing %s\n",pginfop->pagemsgfile);
			fflush(stderr);
		}
		unlink(pginfop->pagemsgfile);
	}

	return;
}

static int getsvccode(svcname,svccode,len,svcerrlist)
char *svcname;
char *svccode;
int len;
char *svcerrlist;
{
char worksvcname[MAXHOSTSVCNAMELEN];
char str_fmt[16];
char *workptr;
struct servent *service;

	sprintf(worksvcname,"%.*s:",sizeof(worksvcname)-2,svcname);

	workptr = strstr(svcerrlist,worksvcname);
	if( workptr ) {
		memset(svccode,0,sizeof(svccode));
		sprintf(str_fmt,"%%%ds",len-1);
		workptr += strlen(worksvcname);
		sscanf(workptr,str_fmt,svccode);
	}
	else if( (service=getservbyname(svcname,"tcp")) != NULL ) {
		sprintf(svccode,"7%d",(int)htons(service->s_port));
	}
	else {
		strcpy(worksvcname,"ERR:");
		workptr = strstr(svcerrlist,worksvcname);
		if( workptr ) {
			memset(svccode,0,sizeof(svccode));
			sprintf(str_fmt,"%%%ds",len-1);
			workptr += strlen(worksvcname);
			sscanf(workptr,str_fmt,svccode);
		}
	}

	return(0);
}

static void usage(msg)
char *msg;
{
	if( msg ) {
		fprintf(stderr,"bbwarn: %s\n",msg);
		fflush(stderr);
	}
}

static void errmsg(type,msg)
char *type;
char *msg;
{
	bb_errmsg(type,msg);
}

/*
 * Exit with cleanup
 */
static int done( rccode,pginfop )
int rccode;
struct bbpageinfo *pginfop;
{
	cleanup(pginfop);
	return(rccode);
}

static int usage_done(msg,code,pginfop)
char *msg;
int code;
struct bbpageinfo *pginfop;
{
	usage(msg);
	return(done(code,pginfop));
}


/* Set up info if message came from pre-1.08b client */
static int getoldinfo(hostsvc,hostinfo,maxlen,svccodes)
char *hostsvc;
char *hostinfo;
int maxlen;
char *svccodes;
{
int rc = 0;
FILE *fp = NULL;
char entry[MAXHOSTNAMELEN+32];
char ipaddr[32],name[MAXHOSTNAMELEN+1],ipmatch[64];
char workhostsvc[(MAXHOSTSVCNAMELEN+1)*2];
int	getlinebbhosts();
struct servent *service;
int	port;
char	svccode[MAXSVCNAMELEN+1],svcnum[32],*workptr,*saveptr,svcmask[MAXHOSTNAMELEN+1];
char	str_fmt[16];

	memset(hostinfo,0,maxlen);

	memset(entry,0,sizeof(entry));
	while( getlinebbhosts(&fp,entry,sizeof(entry)-1,LINEBBHOSTS_IPADDR) == 1 ) {

		if( (strlen(entry) > sizeof(ipaddr)-1) ) {
			entry[sizeof(ipaddr)-1] = '\0';
		}
		memset(ipaddr,0,sizeof(ipaddr));
		memset(name,0,sizeof(name));

		sprintf(str_fmt,"%%%ds %%%ds",sizeof(ipaddr)-1,sizeof(name)-1);
		sscanf(entry,str_fmt,ipaddr,name);
		/* Remove dots in IP addr */
		replacestr(ipaddr,sizeof(ipaddr),".","");

		memset(workhostsvc,0,sizeof(workhostsvc));
		strncpy(workhostsvc,hostsvc,sizeof(workhostsvc)-1);

		sprintf(ipmatch,"[0-9][0-9]*%s",ipaddr);
		if( match(hostsvc,ipmatch,REG_FULL) ) {
			memset(svccode,0,sizeof(svccode));
			memset(svcnum,0,sizeof(svcnum));
			/* Get svc code, hostsvc - ipaddr */
			workhostsvc[strlen(workhostsvc)-strlen(ipaddr)] = '\0';
			/* Is NET err ? (^7) */
			if( strncmp(workhostsvc,neterr,strlen(neterr)) == 0 ) {
				/* get svc name fromn /etc/services */
				port = -1;
				port = atoi(&workhostsvc[strlen(neterr)]);
				if( (service=getservbyport(port,"tcp")) != NULL ) {
					strcpy(svccode,service->s_name);
				}
				else {
					continue;
				}
			}
			else {
				/* get svc name from error codes */
				sprintf(svcmask,":%s",workhostsvc);
				workptr = strstr(svccodes,svcmask);
				if( workptr ) {
					saveptr = workptr;
					while( (workptr-1) >= svccodes && !isspace(*(workptr-1)) ) {
						workptr--;
					}
					/* no name defined as in ...   :100 instead of disk:100 */
					if( workptr == saveptr ) {
						continue;
					}
					*saveptr = ' ';
					sprintf(str_fmt,"%%%ds %%%ds",sizeof(svccode)-1,sizeof(svcnum)-1);
					sscanf(workptr,str_fmt,svccode,svcnum);
					*saveptr = ':';
				}
				else {
					continue;
				}
			}
			/* save info */
			if( fqdn != 1 ) {
				workptr = strchr(name,'.');
				if( workptr ) {
					*workptr = '\0';
				}
			}

			/* Save host (xxx.yyy.com) svc (disk) */
			sprintf(hostinfo,"%s %s",name,svccode);

			rc = 1;
			fclose(fp);

			break;
		}
	}

	return(rc);
}

static int getsetupfromfile(filename,dstval,token,maxlen)
char *filename;
char *dstval;
char *token;
int  maxlen;
{
FILE	*fp;
char	setupfile[(PATH_MAX*2)+16];
char	setupline[2048];
char	worktoken[64];
int	cont,rc;

	rc = 0;

	if( !dstval || !token ) {
		return(1);
	}

	if( *token == '\0' ) {
		return(1);
	}

	memset(dstval,0,maxlen);
	cont = 0;

	sprintf(setupfile,"%.*s/etc/%.*s",PATH_MAX,bbhome,PATH_MAX,filename);
	sprintf(worktoken,"%.*s:",sizeof(worktoken)-1,token);

	rc = 1;
	
	/* Open etc/bbwarnsetup.cfg */
	if( (fp=fopen(setupfile,"r")) != NULL ) {
		while( fgets(setupline,sizeof(setupline)-1,fp) != NULL ) {
			stripleadtrailspaces(setupline);
			if( (cont == 0 && strncmp(setupline,worktoken,strlen(worktoken)) == 0) || (cont == 1) ) {
				if( cont == 0 ) {
					stripleadtrailspaces(&setupline[strlen(worktoken)]);
					strncat(dstval,&setupline[strlen(worktoken)],maxlen-strlen(dstval)-1);
				}
				else {
					strncat(dstval,setupline,maxlen-strlen(dstval)-1);
				}
				rc = 0;
				/* Do we have a line continuation character ? */
				if( dstval[strlen(dstval)-1] != '\\' ) {
					break;		/* nope */
				}
				else {
					/* Remove the continuation character */
					dstval[strlen(dstval)-1] = '\0';
					cont = 1;
				}
			}
		}
		fclose(fp);
	}

	return(rc);

}

getsetup(dstval,token,maxlen)
char *dstval;
char *token;
int  maxlen;
{
	return(getsetupfromfile("bbwarnsetup.cfg",dstval,token,maxlen));
}

/*
 * Extract initial delay and delay from recipient
 * 0 - error
 * 1 - no error
 */
static int getdelay(rcpt,initdelay,delay,type,pagedelay)
char *rcpt;
int *initdelay;
int *delay;
int *type;
int pagedelay;
{
char *pgptr;

	if( (rcpt == NULL) || (initdelay == NULL) || (delay == NULL) || (pagedelay < 0) ) {
		return(0);
	}

	*delay = pagedelay;
	*initdelay = 0;
	
	pgptr = strchr(rcpt,':');
	if( pgptr != NULL ) {
		++pgptr;
		/* Now just get the initial delay value */
		if( *pgptr == '~' ) {
			/*
			 * recipient:~XXX[-YYY]
			 */
			*type = PAGE_INITDELAY;
			pgptr++;
			if( sscanf(pgptr,"%d-%d",initdelay,delay) != 2 ) {
				*initdelay = atoi(pgptr);
				if( DEBUG ) {
			        	fprintf(stderr,"getdelay(): PAGE_INITDELAY:ARGS!=2 - initdelay = %d, delay = %d\n",*initdelay,*delay);
			        	fflush(stderr);
					}
			}
			else {
				if( DEBUG ) {
			        	fprintf(stderr,"getdelay(): PAGE_INITDELAY:ARGS==2 - initdelay = %d, delay = %d\n",*initdelay,*delay);
			        	fflush(stderr);
				}
			}
		}
		else if( *pgptr == '^') {
			/*
			 * recipient:^XXX[-YYY]
			 */
			*type = PAGE_ESCALATE;
			pgptr++;
			if( sscanf(pgptr,"%d-%d",initdelay,delay) != 2 ) {
				*initdelay = atoi(pgptr);
				if( DEBUG ) {
			        	fprintf(stderr,"getdelay(): PAGE_ESCALATE:ARGS!=2 - initdelay = %d, delay = %d\n",*initdelay,*delay);
				        fflush(stderr);
				}
			}
			else {
				if( DEBUG ) {
			        	fprintf(stderr,"getdelay(): PAGE_ESCALATE:ARGS==2 - initdelay = %d, delay = %d\n",*initdelay,*delay);
				        fflush(stderr);
				}
			}
		}
		else {
			/*
			 * recipient:XXX
			 */
			*type = PAGE_BASIC;
			*initdelay = 0;
			*delay = atoi(pgptr);
			if( DEBUG ) {
		        	fprintf(stderr,"getdelay(): PAGE_BASIC:NONDEFAULT - initdelay = %d, delay = %d\n",*initdelay,*delay);
		        	fflush(stderr);
			}
		}
	}
	else {
		*initdelay = 0;
		*delay = pagedelay;
		*type = PAGE_BASIC;
		if( DEBUG ) {
			fprintf(stderr,"getdelay(): PAGE_BASIC:DEFAULT - initdelay = %d, delay = %d\n",*initdelay,*delay);
			fflush(stderr);
		}
	}

	return(1);
}


void expand_briefrcpts(rcptslist,maxlen)
char *rcptslist;
int  maxlen;
{
char *newrcptslist, lastchar, pgrcpts[2048];
char *workptr, *qualptr, *newpgrs;
int  len;
int  errdone = 0;

	if( !rcptslist ) {
		return;
	}

	stripleadtrailspaces(rcptslist);
	if( strlen(rcptslist) == 0 ) {
		return;
	}

	if( (newrcptslist=(char *) calloc(1,maxlen)) == NULL) {
		return;
	}

	workptr = rcptslist;
	while( *workptr != '\0' ) {
		len = strcspn(workptr," \t");
		/* Keep the last char to reset it later */
		lastchar = *(workptr+len);
		/* Terminate recipient */
		*(workptr+len) = '\0';
		/* recipient does not contain qualifier */
		if( (qualptr = strchr(workptr,':')) != NULL ) {
			*qualptr = '\0';
		}
		getsetup(pgrcpts,workptr,sizeof(pgrcpts));
		if( strlen(pgrcpts) > 0 ) {
			/* Remove qualifiers from recipients */
			while( (qualptr = strchr(pgrcpts,':')) != NULL ) {
				while( *qualptr && !isspace(*qualptr) ) {
					*qualptr = ' ';
					qualptr++;
				}
			}
			/* Remove extra spaces generated */
			space_sep(pgrcpts);
			newpgrs = pgrcpts;
		}
		else {
			newpgrs = workptr;
		}
		/* Make sure new list will stay within bounds */
		/* I know, I could go for each rcpt */
		if( (strlen(newrcptslist)+strlen(newpgrs)+2) < (size_t)maxlen ) {
			if(strlen(newrcptslist) > 0) {
				strcat(newrcptslist," ");
			}
			strcat(newrcptslist,newpgrs);
		}
		else {
			/* Only complain once */
			if( errdone == 0 ) {
				bb_errmsg("bbpage","Page group expansion failed - too many recipients");
				errdone = 1;
			}
		}
		/* Go to next recipient */
		workptr += len;
		/* Remember our old last char, put it back */
		*workptr = lastchar;
		while( isspace(*workptr) ) {
			workptr++;
		}
	}

	strcpy(rcptslist,newrcptslist);
	free(newrcptslist);
	return;
}

static int save_notif(hostsvc,machip,rcptentry,svcnum,downsecsmsg,recovered)
char *hostsvc;
char *machip;
char *rcptentry;
char *svcnum;
char *downsecsmsg;
int  recovered;
{
char	*logline;
char	notiflog[PATH_MAX*2];
int	logline_len, rc;

	if( recovered == 1 ) {
		sprintf(notiflog,"%s/recoverymsgs.log",bbacksdir);
	}
	else {
		sprintf(notiflog,"%s/notifications.log",bbacksdir);
	}
	
	if( DEBUG ) {
		fprintf(stderr,"notiflog: <%s>\n",notiflog);
		fflush(stderr);
	}

	logline_len = strlen(gettimestr())
			+ strlen(hostsvc)
			+ strlen(machip)
			+ strlen(rcptentry)
			+ strlen(svcnum)
			+ strlen(downsecsmsg) + 128;

	if( (logline=malloc(logline_len)) == NULL ) {
		rc = 0;
	}
	else {
		sprintf(logline,"%s %s (%s) %s %d %s %s\n",gettimestr()
								,hostsvc
								,machip
								,rcptentry
								,(int)time(NULL)
								,svcnum
								,downsecsmsg);
		rc = appendfile(notiflog,logline);
		free(logline);
	}
	return(rc);
}

static int save_recoveries(host,svc,downsecs)
char *host;
char *svc;
int downsecs;
{
char	logline[MAXHOSTSVCNAMELEN+128];
char	logname[(PATH_MAX+1)*2];
char	str_fmt[32];

	sprintf(logname,"%s/recoveries.log",bbacksdir);

	sprintf(str_fmt,"%%.32s %%.%ds %%.%ds %%d %%d\n",MAXHOSTNAMELEN,MAXSVCNAMELEN);
	sprintf(logline,str_fmt,gettimestr()
						,host
						,svc
						,(int)time(NULL)
						,downsecs);
	return(appendfile(logname,logline));
}

static int save_acklog(np_acknumber,delay,acknumber,np_filename,np_host,np_color,message)
char *np_acknumber;
char *delay;
char *acknumber;
char *np_filename;
char *np_host;
char *np_color;
char *message;
{
char	logline[PATH_MAX+MAXHOSTSVCNAMELEN+2048];
char	logname[(PATH_MAX+1)*2];
time_t	timenow;
char	str_fmt[128];

	timenow = time(NULL);
	sprintf(logname,"%s/acklog",bbacksdir);
	sprintf(str_fmt,"%%d\t%%.31s\t%%.15s\t%%.15s\t%%.%ds\t%%.%ds\t%%.15s\t%%.1023s\n",PATH_MAX,MAXHOSTSVCNAMELEN);
	
	sprintf(logline,str_fmt,timenow
				,np_acknumber
				,delay
				,acknumber
				,np_filename
				,np_host
				,np_color
				,message);
	return(appendfile(logname,logline));
}


static int send_mail(mailmsg,subject,rcpt)
char *mailmsg;
char *subject;
char *rcpt;
{
char *mail;
char mailcmd[PATH_MAX+512];
FILE *pipef;
char recipient[256],str_fmt[32];

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following mail message:\n");
		fprintf(stderr,"Subject: %s\n",subject);
		fprintf(stderr,"Text: %s\n",mailmsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	mail = getenv("MAIL");
	if( !mail ) {
		mail = "";
	}
	if( strlen(mail) == 0 ) {
		fprintf(stderr,"MAIL env variable not set\n");
		fflush(stderr);
		return(0);
	}

	if( match(rcpt,"ep-.*",REG_FULL) == 1 ) {
		strncpy(recipient,rcpt+3,sizeof(recipient)-1);
	}
	else {
		strncpy(recipient,rcpt,sizeof(recipient)-1);
	}

	memset(mailcmd,0,sizeof(mailcmd));

	replacestr(subject,sizeof(subject),"'","");
	replacestr(recipient,sizeof(recipient),"'","");
	sprintf(str_fmt,"%%.%ds '%%.%ds' '%%.%ds'",PATH_MAX,128,sizeof(recipient)-1);
	sprintf(mailcmd,str_fmt,mail,subject,recipient);

	signal(SIGCHLD, SIG_DFL);
	if( (pipef=popen(mailcmd,"w")) != NULL ) {
		fprintf(pipef,"%s",mailmsg);
		pclose(pipef);
		signal(SIGCHLD, SIG_IGN);
	}
	else {
		signal(SIGCHLD, SIG_IGN);
		fprintf(stderr,"Could not popen() to send out mail");
		fflush(stderr);
		return(0);
	}

	return(1);
}

static int send_numeric(nummsg,prefix,suffix,rcpt)
char *nummsg;
char *prefix;
char *suffix;
char *rcpt;
{
#ifdef sco3
pid_t child;
#else
int child;
#endif
int status;
char cmd[PATH_MAX+128];
char cmdarg1[PATH_MAX+128];
char cmdarg2[257];
char cmdarg3[257];

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following numeric message:\n");
		fprintf(stderr,"Numeric code: %s\n",nummsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	if((child = fork()) < 0) {
		fprintf(stderr,"Couldn't fork() to send numeric message\n");
		fflush(stderr);
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		sprintf(cmd,"%.*s/bin/sendmsg",PATH_MAX,bbhome);
		sprintf(cmdarg1,"%.*s/etc/numeric.scr",PATH_MAX,bbhome);
		sprintf(cmdarg2,"%.128s%.128s",prefix,rcpt);
		sprintf(cmdarg3,"%.128s%.128s",nummsg,suffix);
		execlp(cmd,cmd,cmdarg1,cmdarg2,cmdarg3,(char *)NULL);
		fprintf(stderr,"Couldn't execlp() to send numeric message\n");
		fflush(stderr);
		exit(1);
	}

#ifdef ZOMBIE
	wait(&status);
#endif

	return(1);
}

static int send_sms(smsmsg,rcpt)
char *smsmsg;
char *rcpt;
{
#ifdef sco3
pid_t child;
#else
int child;
#endif
int status;
char cmd[PATH_MAX+128];
char cmdarg1[PATH_MAX+128];
char filename[PATH_MAX];
char recipient[257];

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following SMS message:\n");
		fprintf(stderr,"SMS msg: %s\n",smsmsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	strncpy(recipient,rcpt+4,sizeof(recipient)-1);

	if((child = fork()) < 0) {
		fprintf(stderr,"Couldn't fork() to send SMS message\n");
		fflush(stderr);
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		sprintf(filename,"%.*s/sms-%d",PATH_MAX-16,bbtmpdir,getpid());
		if( savefile(filename,smsmsg) != 1 ) {
			fprintf(stderr,"Couldn't create SMS message file for %s\n",recipient);
			fflush(stderr);
			exit(0);
		}
		sprintf(cmd,"%.*s/bin/sendmsg",PATH_MAX,bbhome);
		sprintf(cmdarg1,"%.*s/etc/sms.scr",PATH_MAX,bbhome);
		execlp(cmd,cmd,cmdarg1,filename,recipient,(char *)NULL);
		unlink(filename);
		fprintf(stderr,"Couldn't execlp() to send SMS message\n");
		fflush(stderr);
		exit(1);
	}

#ifdef ZOMBIE
	wait(&status);
#else
	signal(SIGCHLD, SIG_DFL);
	waitpid(child,&status,0);
	signal(SIGCHLD, SIG_IGN);
#endif

	unlink(filename);

	return(1);
}

static int send_alpha(alphamsg,rcpt)
char *alphamsg;
char *rcpt;
{
#ifdef sco3
pid_t child;
#else
int child;
#endif
int status;
char recipient[257];
struct stat statinfo;
char *alphapgr;

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following Alpha message:\n");
		fprintf(stderr,"Alpha msg: %s\n",alphamsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	alphapgr = getenv("ALPHAPGR");
	if( !alphapgr ) {
		alphapgr = "";
	}
	if( strlen(alphapgr) == 0 ) {
		fprintf(stderr,"ALPHAPGR env variable not set\n");
		fflush(stderr);
		return(0);
	}

	if( stat(alphapgr,&statinfo) != 0 ) {
		fprintf(stderr,"Alpha pager program <%s> not found\n",alphapgr);
		fflush(stderr);
		return(0);
	}

	strncpy(recipient,rcpt+6,sizeof(recipient)-1);

	if((child = fork()) < 0) {
		fprintf(stderr,"Couldn't fork() to send Alpha message\n");
		fflush(stderr);
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		execlp(alphapgr,alphapgr,recipient,alphamsg,(char *)NULL);
		fprintf(stderr,"Couldn't execlp() to send Alpha message\n");
		fflush(stderr);
		exit(1);
	}

#ifdef ZOMBIE
	wait(&status);
#endif

	return(1);
}

static int send_qpage(qpagemsg,rcpt)
char *qpagemsg;
char *rcpt;
{
char arguments[512];
char recipient[257];
char qpagecmd[PATH_MAX+1024];		/* 1024: enough to fill arguments+recipient */
struct stat statinfo;
char *qpage, *qpageargs;
FILE *pipef;

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following qpage message:\n");
		fprintf(stderr,"Qpage msg: %s\n",qpagemsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	qpage = getenv("QPAGE");
	if( !qpage ) {
		qpage = "";
	}
	if( strlen(qpage) == 0 ) {
		fprintf(stderr,"QPAGE env variable not set\n");
		fflush(stderr);
		return(0);
	}
	qpageargs = getenv("QPAGEARGS");
	if( !qpageargs ) {
		qpageargs = "";
	}
	if( strlen(qpageargs) == 0 ) {
		fprintf(stderr,"QPAGEARGS env variable not set\n");
		fflush(stderr);
		return(0);
	}

	if( stat(qpage,&statinfo) != 0 ) {
		fprintf(stderr,"Qpage program <%s> not found\n",qpage);
		fflush(stderr);
		return(0);
	}

	strncpy(recipient,rcpt+3,sizeof(recipient)-1);

	memset(arguments,0,sizeof(arguments));
	strncpy(arguments,qpageargs,sizeof(arguments));
	replacestr(arguments,sizeof(arguments),"'","");
	replacestr(recipient,sizeof(recipient),"'","");
	memset(qpagecmd,0,sizeof(qpagecmd));
	sprintf(qpagecmd,"%s '%s' -p '%s'",qpage,arguments,recipient);

	signal(SIGCHLD, SIG_DFL);
	if( (pipef=popen(qpagecmd,"w")) != NULL ) {
		fprintf(pipef,"%s",qpagemsg);
		pclose(pipef);
		signal(SIGCHLD, SIG_IGN);
	}
	else {
		signal(SIGCHLD, SIG_IGN);
		fprintf(stderr,"Could not popen() to use Qpage");
		fflush(stderr);
		return(0);
	}

	return(1);
}

static int send_sendpage(sendpagemsg,rcpt)
char *sendpagemsg;
char *rcpt;
{
char recipient[257];
char arguments[512];
char sendpagecmd[PATH_MAX+1024];
struct stat statinfo;
char *sendpage, *sendpageargs;
FILE *pipef;

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following sendpage message:\n");
		fprintf(stderr,"Sendpage msg: %s\n",sendpagemsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	sendpage = getenv("SENDPAGE");
	if( !sendpage ) {
		sendpage = "";
	}
	if( strlen(sendpage) == 0 ) {
		fprintf(stderr,"SENDPAGE env variable not set\n");
		fflush(stderr);
		return(0);
	}
	sendpageargs = getenv("SENDPAGEARGS");
	if( !sendpageargs ) {
		sendpageargs = "";
	}
	if( strlen(sendpageargs) == 0 ) {
		fprintf(stderr,"SENDPAGEARGS env variable not set\n");
		fflush(stderr);
		return(0);
	}

	if( stat(sendpage,&statinfo) != 0 ) {
		fprintf(stderr,"Sendpage program <%s> not found\n",sendpage);
		fflush(stderr);
		return(0);
	}

	/* It's either sp- or hsp- */
	if( strncmp(rcpt,"sp-",3) == 0 ) {
		strncpy(recipient,rcpt+3,sizeof(recipient)-1);
	}
	else {
		strncpy(recipient,rcpt+4,sizeof(recipient)-1);
	}

	memset(sendpagecmd,0,sizeof(sendpagecmd));
	memset(arguments,0,sizeof(arguments));
	strncpy(arguments,sendpageargs,sizeof(arguments));
	replacestr(arguments,sizeof(arguments),"'","");
	replacestr(recipient,sizeof(recipient),"'","");

	if( strncmp(rcpt,"sp-",3) == 0 ) {
		sprintf(sendpagecmd,"%s '%s' '%s'",sendpage,arguments,recipient);
	}
	else {
		sprintf(sendpagecmd,"%s '%s' '-p%s'",sendpage,arguments,recipient);
	}

	/* RH9 complained about a wait with a SIG_IGN pending */
	/* temporarely disable the SIG_IGN using SIG_DFL */
	signal(SIGCHLD, SIG_DFL);
	if( (pipef=popen(sendpagecmd,"w")) != NULL ) {
		fprintf(pipef,"%s",sendpagemsg);
		pclose(pipef);
		signal(SIGCHLD, SIG_IGN);
	}
	else {
		signal(SIGCHLD, SIG_IGN);
		fprintf(stderr,"Could not popen() to use Sendpage");
		fflush(stderr);
		return(0);
	}

	return(1);
}

static int send_smsclient(smsclientmsg,rcpt)
char *smsclientmsg;
char *rcpt;
{
char smsclient[PATH_MAX+128];
char recipient[257];
char smsmsg[150];
struct stat statinfo;
#ifdef sco3
pid_t child;
#else
int child;
#endif
int status;

	if( DEBUG ) {
		fprintf(stderr,"Sending out the following smsclient message:\n");
		fprintf(stderr,"smsclient msg: %s\n",smsclientmsg);
		fprintf(stderr,"Recipient: %s\n",rcpt);
		fflush(stderr);
	}

	sprintf(smsclient,"%.*s/bin/sendsms",PATH_MAX,bbhome);
	if( stat(smsclient,&statinfo) != 0 ) {
		fprintf(stderr,"smsclient program <%s> not found\n",smsclient);
		fflush(stderr);
		return(0);
	}

	strncpy(recipient,rcpt+10,sizeof(recipient)-1);

	if((child = fork()) < 0) {
		fprintf(stderr,"Couldn't fork() to send smsclient message\n");
		fflush(stderr);
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		memset(smsmsg,0,sizeof(smsmsg));
		strncpy(smsmsg,smsclientmsg,sizeof(smsmsg)-1);
		/* Send the right buffer out Rob ! */
		/* Thanks to Douwe.Dijkstra@I-Pay.com */
		execlp(smsclient,smsclient,recipient,smsmsg,(char *)NULL);
		fprintf(stderr,"Couldn't execlp() to send smsclient message\n");
		fflush(stderr);
		exit(1);
	}

#ifdef ZOMBIE
	wait(&status);
#endif

	return(1);
}

static int send_snmptrap(msg,rcpt,ipaddr,svc,recovered)
char *msg;
char *rcpt;
char *ipaddr;
char *svc;
int recovered;
{
char snmptrap_pgm[PATH_MAX+1],snmptrap_type[32],entoid[512],trapcodes[1024];
char recipient[257],*workptr,*workptr1,workbuf[128];
#ifdef sco3
pid_t child;
#else
int child;
#endif
int status;
struct stat statinfo;
char trapmsg[8192],outtrapmsg[8320];
char arg1[1024],arg2[1024],arg3[1024],arg4[1024],arg5[1024],arg6[1024],arg7[1024];
char specifictype[16],generaltype[16];
int specifictype_int;
char str_fmt[64];

int argc;
char argv[24][256];
char *argvp[24];
char trapcfg[1024];


	getsetup(snmptrap_pgm,"snmptrap_pgm", sizeof(snmptrap_pgm));
	if( strlen(snmptrap_pgm) == 0 ) {
		fprintf(stderr,"SNMP trap program location is undefined in bbwarnsetup.cfg (snmptrap_pgm)\n");
		fflush(stderr);
		return(0);
	}
	if( DEBUG ) {
		fprintf(stderr,"snmptrap program location: <%s>\n",snmptrap_pgm);
		fflush(stderr);
	}

	if( stat(snmptrap_pgm,&statinfo) != 0 ) {
		fprintf(stderr,"SNMP trap program <%s> not found\n",snmptrap_pgm);
		fflush(stderr);
		return(0);
	}

	getsetup(snmptrap_type,"snmptrap_type", sizeof(snmptrap_type));
	if( strlen(snmptrap_type) == 0 ) {
		fprintf(stderr,"SNMP trap type is undefined in bbwarnsetup.cfg (snmptrap_type)\n");
		fflush(stderr);
		return(0);
	}
	if( DEBUG ) {
		fprintf(stderr,"snmptrap type: <%s>\n",snmptrap_type);
		fflush(stderr);
	}
	if( !((strcmp(snmptrap_type,"CMU") == 0)
		|| (strcmp(snmptrap_type,"UCD") == 0)
		|| (strcmp(snmptrap_type,"NET") == 0)
		|| (strcmp(snmptrap_type,"SOLARIS") == 0)
		|| (strcmp(snmptrap_type,"HPOV") == 0)) ) {
		fprintf(stderr,"Unknown SNMP trap type <%s> \n", snmptrap_type);
		fflush(stderr);
		return(0);
	}


	getsetup(entoid,"entoid", sizeof(entoid));
	if( strlen(entoid) == 0 ) {
		fprintf(stderr,"SNMP enterprise OID is undefined in bbwarnsetup.cfg (entoid)\n");
		fflush(stderr);
		return(0);
	}
	if( DEBUG ) {
		fprintf(stderr,"Enterprise OID: <%s>\n",entoid);
		fflush(stderr);
	}

	getsetup(trapcodes,"trapcodes", sizeof(trapcodes));
	if( strlen(trapcodes) == 0 ) {
		fprintf(stderr,"SNMP trap codes are undefined in bbwarnsetup.cfg (trapcodes)\n");
		fflush(stderr);
		return(0);
	}
	if( DEBUG ) {
		fprintf(stderr,"snmptrap trap codes: <%s>\n",trapcodes);
		fflush(stderr);
	}

	strncpy(recipient,rcpt+5,sizeof(recipient)-1);

	memset(arg1,0,sizeof(arg1));
	memset(arg2,0,sizeof(arg2));
	memset(arg3,0,sizeof(arg3));
	memset(arg4,0,sizeof(arg4));
	memset(arg5,0,sizeof(arg5));
	memset(arg6,0,sizeof(arg6));
	memset(arg7,0,sizeof(arg7));

	memset(trapmsg,0,sizeof(trapmsg));

	if( strcmp(svc,"disk") == 0 ) {
		sprintf(str_fmt,"%%%ds %%%ds %%%ds %%%ds %%%ds %%%ds %%%ds",
				sizeof(arg1)-1,sizeof(arg2)-1,sizeof(arg3)-1,
				sizeof(arg4)-1,sizeof(arg5)-1,sizeof(arg6)-1,sizeof(arg7)-1);
		sscanf(msg,str_fmt,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
		sprintf(trapmsg,"%.511s:%.511s %.1023s %.1023s %.1023s %.1023s %.1023s %.1023s %.1023s - ",ipaddr,svc,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
		workptr = msg;
		while( (workptr=strstr(workptr,"&red")) != NULL ) {
			memset(arg2,0,sizeof(arg2));
			memset(arg3,0,sizeof(arg3));
			sprintf(str_fmt,"%%*s %%%ds %%%ds",sizeof(arg2)-1,sizeof(arg3)-1);
			sscanf(workptr,str_fmt,arg2,arg3);
			if( (strlen(arg2) + strlen(arg3) + 4 + strlen(trapmsg)) < (MAXTRAPMSGSIZE) ) {
				strcat(trapmsg,arg2);
				strcat(trapmsg," ");
				strcat(trapmsg,arg3);
				strcat(trapmsg,"  ");
			}
			else {
				break;
			}
			workptr++;
		}
		workptr = msg;
		while( (workptr=strstr(workptr,"&yellow")) != NULL ) {
			memset(arg2,0,sizeof(arg2));
			memset(arg3,0,sizeof(arg3));
			sprintf(str_fmt,"%%*s %%%ds %%%ds",sizeof(arg2)-1,sizeof(arg3)-1);
			sscanf(workptr,str_fmt,arg2,arg3);
			if( (strlen(arg2) + strlen(arg3) + 4 + strlen(trapmsg)) < (MAXTRAPMSGSIZE) ) {
				strcat(trapmsg,arg2);
				strcat(trapmsg," ");
				strcat(trapmsg,arg3);
				strcat(trapmsg,"  ");
			}
			else {
				break;
			}
			workptr++;
		}
	}
	else if( strcmp(svc,"procs") == 0 ) {
		workptr = strchr(msg,'\r');
		workptr1 = strchr(msg,'\n');
		sprintf(trapmsg,"%.511s:%.511s ",ipaddr,svc);
		if( workptr == NULL && workptr1 == NULL ) {
			strncat(trapmsg,msg,MAXTRAPMSGSIZE);
		}
		else if( workptr != NULL && workptr1 == NULL  ) {
			if( (workptr - msg) < MAXTRAPMSGSIZE ) {
				strncat(trapmsg,msg,workptr-msg);
			}
			else {
				strncat(trapmsg,msg,MAXTRAPMSGSIZE);
			}
		}
		else if( workptr == NULL && workptr1 != NULL  ) {
			if( (workptr1 - msg) < MAXTRAPMSGSIZE ) {
				strncat(trapmsg,msg,workptr1-msg);
			}
			else {
				strncat(trapmsg,msg,MAXTRAPMSGSIZE);
			}
		}
		else {
			if( workptr > workptr1 ) {
				workptr = workptr1;
			}
			if( (workptr - msg) < MAXTRAPMSGSIZE ) {
				strncat(trapmsg,msg,workptr-msg);
			}
			else {
				strncat(trapmsg,msg,MAXTRAPMSGSIZE);
			}
		}
	}
	else {
		sprintf(trapmsg,"%.511s:%.511s ",ipaddr,svc);
	}

	if( DEBUG ) {
		fprintf(stderr,"snmptrap message: <%s>\n",trapmsg);
		fflush(stderr);
	}
	strncpy(workbuf,svc,sizeof(workbuf)-2);
	strcat(workbuf,":");
	workptr = strstr(trapcodes,workbuf);
	if( workptr == NULL ) {
		fprintf(stderr,"SNMP trap code for <%s> not defined in bbwarnsetup.cfg (trapcodes)\n",svc);
		fflush(stderr);
		strcpy(specifictype,"999");
	}
	else {
		workptr += strlen(workbuf);
		memset(specifictype,0,sizeof(specifictype));
		sscanf(workptr,"%15s",specifictype);
		if( recovered == 1 ) {
			specifictype_int = atoi(specifictype) + 1;
			sprintf(specifictype,"%d",specifictype_int);
		}
	}
	strcpy(generaltype,"6");



	if((child = fork()) < 0) {
		fprintf(stderr,"Couldn't fork() to send SNMP trap message\n");
		fflush(stderr);
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		if( strcmp(snmptrap_type,"SOLARIS") == 0 ) {
			/* Solaris wants spaces between (%s) */
			/* Thanks to David Balkwill <dbalkwill@hemscott.co.uk> */
			sprintf(outtrapmsg,"%s STRING ( %s )",entoid,trapmsg);
			if( DEBUG ) {
				fprintf(stderr,"Sending out the following SOLARIS SNMP trap message:\n");
				fprintf(stderr,"Trap msg: %s\n",outtrapmsg);
				fprintf(stderr,"Trap server: %s\n",recipient);
				fflush(stderr);
			}
			execlp(snmptrap_pgm,snmptrap_pgm,"-h",recipient,"-c","public","-e",entoid,"-i",ipaddr,"-g",generaltype,"-s",specifictype,"-a",outtrapmsg, (char *)NULL);
		}
		else if( strcmp(snmptrap_type,"CMU") == 0 ) {
			sprintf(outtrapmsg,"%s STRING(%s)",entoid,trapmsg);
			if( DEBUG ) {
				fprintf(stderr,"Sending out the following CMU SNMP trap message:\n");
				fprintf(stderr,"Trap msg: %s\n",outtrapmsg);
				fprintf(stderr,"Trap server: %s\n",recipient);
				fflush(stderr);
			}
			execlp(snmptrap_pgm,snmptrap_pgm,"-a",ipaddr,"-d",recipient,"",generaltype,specifictype,outtrapmsg, (char *)NULL);
		}
		else if( strcmp(snmptrap_type,"UCD") == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Sending out the following NET SNMP trap message:\n");
				fprintf(stderr,"Trap server: %s\n",recipient);
				fprintf(stderr,"Trap msg: %s\n",trapmsg);
				fprintf(stderr,"recipient: %s\n",recipient);
				fprintf(stderr,"entoid: %s\n",entoid);
				fprintf(stderr,"ipaddr: %s\n",ipaddr);
				fprintf(stderr,"generaltype: %s\n",generaltype);
				fprintf(stderr,"specifictype: %s\n",specifictype);
				fflush(stderr);
			}
			execlp(snmptrap_pgm,snmptrap_pgm,"-v","1",recipient,"",entoid,ipaddr,generaltype,specifictype,"0",entoid,"s", trapmsg, (char *)NULL);
		}
		else if( strcmp(snmptrap_type,"NET") == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Sending out the following NET SNMP trap message:\n");
				fprintf(stderr,"Trap server: %s\n",recipient);
				fprintf(stderr,"Trap msg: %s\n",trapmsg);
				fprintf(stderr,"recipient: %s\n",recipient);
				fprintf(stderr,"entoid: %s\n",entoid);
				fprintf(stderr,"ipaddr: %s\n",ipaddr);
				fprintf(stderr,"generaltype: %s\n",generaltype);
				fprintf(stderr,"specifictype: %s\n",specifictype);
				fflush(stderr);
			}
			execlp(snmptrap_pgm,snmptrap_pgm,"-v","1","-c","public",recipient,entoid,"0.0.0.0",generaltype,specifictype,"0",entoid,"s", trapmsg, (char *)NULL);
		}
		else if( strcmp(snmptrap_type,"HPOV") == 0 ) {
			fprintf(stderr,"HP Openview based SNMP trap handling not yet implemented\n");
			fflush(stderr);
			exit(0);
		}
		else {
			fprintf(stderr,"Unknown snmptrap type <%s> defined in bbwarnsetup.cfg\n",snmptrap_type);
			fflush(stderr);
			exit(0);
		}
	}


#ifdef ZOMBIE
	wait(&status);
#endif

	return(1);
}


static int send_extpage(rcptentry)
char *rcptentry;
{
char extpage[(PATH_MAX*2)+16];
char scriptname[PATH_MAX+1];
struct stat statinfo;
#ifdef sco3
pid_t child;
#else
int child;
#endif
int  status;
char *workptr;
char errormsg[PATH_MAX+1];

	if( DEBUG ) {
		fprintf(stderr,"Sending out using an externally defined method \n");
		fprintf(stderr,"Recipient: <%s>\n",rcptentry);
		fflush(stderr);
	}

	if( rcptentry == NULL ) {
		return(0);
	}

	/* A recipient must be at least ext-X- */
	/* where X is any character */
	if( strlen(rcptentry) < 7 ) {
		return(0);
	}

	/* It must start with ext- */
	if( strncmp(rcptentry,"ext-",4) != 0 ) {
		return(0);
	}

	/* it must be in the form ext-XXX- */
	memset(scriptname,0,sizeof(scriptname));
	strncpy(scriptname,rcptentry+4,sizeof(scriptname)-1);
	if( (workptr=strchr(scriptname,'-')) == NULL ) {
		return(0);
	}
	*workptr = '\0';
	workptr++;

	/* Path name of script must fit in extpage */
	/* BBHOME + /ext/pg/ + scriptname + NULL */
	if( strlen(bbhome) + 9 + strlen(scriptname) >= sizeof(extpage) ) {
		return(0);
	}

	sprintf(extpage,"%s/ext/pg/%s",bbhome,scriptname);
	
	memset(errormsg,0,sizeof(errormsg));
	if( stat(extpage,&statinfo) != 0 ) {
		strcpy(errormsg,"Could not find script: ");
		strncat(errormsg,scriptname,sizeof(errormsg)-strlen(errormsg)-1);
		bb_errmsg("bbpage",errormsg);
		return(0);
	}

	if((child = fork()) < 0) {
		bb_errmsg("bbpage","Couldn't fork() for user defined notification script");
		return(0);
	}

	if (child == 0) {	/* THE CHILD */
		bb_putenv("RCPT",workptr,rcpt_env,sizeof(rcpt_env));
		execlp(extpage,extpage,(char *)NULL);
		strcpy(errormsg,"Couldn't execlp() ");
		strncat(errormsg,extpage,sizeof(errormsg)-strlen(errormsg)-1);
		bb_errmsg("bbpage",errormsg);
		exit(1);
	}

#ifdef ZOMBIE
	wait(&status);
#endif

	return(1);
}

int bb_page(argmsg)
char *argmsg;
{
char	*workmsg;
char	hostsvc[MAXHOSTSVCNAMELEN+1],bbhostsvc[(MAXHOSTSVCNAMELEN+1)*2];
char	*msg,*msgptr;
char	pagehelpusernum[MAXHOSTNAMELEN+1];
struct stat	statinfo;
int	recovered;
char	bbwarn[16];
char	workfilename[PATH_MAX];
char	arg2[128];
FILE	*fp;
char	*workptr,*workptr1;
int	oldstylepagemsg;
char	hostinfo[MAXHOSTNAMELEN+1];
char	redhost[MAXHOSTNAMELEN+1],redsvc[MAXSVCNAMELEN+1],tmpredhost[MAXHOSTNAMELEN+1];
char	machip[32],redhostip[MAXHOSTNAMELEN+1];
time_t	timenow;
struct tm	*time_tm;
int	ip1,ip2,ip3,ip4;
char	ruleargs[MAXRULEARGS][2048];
int	i,cont;
int	nowday;
int	nowtime;
char	machsvc[MAXHOSTSVCNAMELEN],svcerr[32];
char    *instr,*fullinstr,*usageline,*workline,*workline1;
int     instr_maxlen,fullinstr_maxlen,usageline_maxlen,workline_maxlen,workline1_maxlen;
char	*pagers,pgrcpts[2048],pgpager[1024],*pgptr;
char	*ignpagers, *ptrpagers, *ignpager;
int	ignpagers_maxlen,pagers_maxlen,*ptrpagers_maxlen;
char	*beginptr,*endptr;
char	dayval[16],timesval[16],startdayval[16],enddayval[16],starttimesval[16],endtimesval[16];
int	startday,endday,starttimes,endtimes;
int	ignore;
char	*hosts,hostentry[MAXHOSTNAMELEN],*exhosts,hghosts[MAXHOSTNAMELEN*10],*svcs,*exsvcs;
int	svcs_maxlen,exsvcs_maxlen;
int	hosts_maxlen, exhosts_maxlen;
char	*dayrange,*timesrange;
char	rcptentry[MAXRCPTNAMELEN],rcptentry1[MAXRCPTNAMELEN],rcptentry2[MAXRCPTNAMELEN];
char	overrideval[32],*overrideptr,*overrideptr1,*overrideptr2;
int	ftype;
char	pagedelayval[32];
int	initdelay1,delay1,type1,initdelay2,delay2,type2;
char	bbnumeric[64];
char	*bbalpha;
int	bbalpha_maxlen;
char	*npfilecontents,npfilename[PATH_MAX+1];
int	rc,rcptnum,randval,tmprandval,np_exists;
char	filemask[PATH_MAX+1];
char	prefix[16],suffix[16],pagelevelsmail[128],pagelevels[128];
char	pagetype[32],pageaddhtmlpath[16];
DIR	*dirinfo;
char	bbgroup[128],color[32];
char	*bblogstatus,*bbwebhtmllogs,*cgibinurl,*bbwebhost,*bbwebhosturl;
char	downsecsmsg[128],downsecsval[64],briefrcpts[4096];
char	randvalstr[16],randvaltag[16],randvalsubjtag[16],htmllink[((PATH_MAX+1)*2)+256],tmprandvalstr[16];
char	mailsubject[MAXHOSTSVCNAMELEN+256];	/* put enough for bbnumeric and others */
char	numcode[128];				/* enough for bbnumeric and randvaltag */
struct bbpageinfo pginfo;
int	save_notification;
char	errormsg[1024],str_fmt[16];
extern	int purpleoffset;

	memset(&pginfo,0,sizeof(pginfo));
	memset(color,0,sizeof(color));

	sprintf(workfilename,"%s/etc/bbwarnrules.cfg",bbhome);
	if( stat(workfilename,&statinfo) != 0 ) {
		return(usage_done("bbwarnrules.cfg not found",1,&pginfo));
	}

	sprintf(workfilename,"%s/etc/bbwarnsetup.cfg",bbhome);
	if( stat(workfilename,&statinfo) != 0 ) {
		usage("bbwarnsetup.cfg not found - using defaults");
	}

	if( DEBUG ) {
		fprintf(stderr,"argmsg: %s\n",argmsg);
		fflush(stderr);
	}

	/* 
	 * Not really needed, released code will be
	 * called withing bbd
	 *
	 * clean_string(argmsg,"`$;|&{}\\");
	 *
	 */

	if( (workmsg=calloc(strlen(argmsg)+1024,1)) == NULL ) {
		bb_errmsg("bbpage","Couldn't allocate memory for workmsg");
		return(done(0,&pginfo));
	}

	strcpy(workmsg,argmsg);
	stripleadtrailspaces(workmsg);

	msgptr = workmsg;
	while( *msgptr && !isspace(*msgptr) ) {
		msgptr++;
	}
	*msgptr = '\0';
	msgptr++;
	while(isspace(*msgptr)) {
		msgptr++;
	}

	if( strlen(msgptr) > 0 ) {
		if( (msg=calloc(strlen(msgptr)+1024,1)) == NULL ) {
			bb_errmsg("bbpage","Couldn't allocate memory for msg");
			return(done(0,&pginfo));
		}

		strcpy(msg,msgptr);
		if( DEBUG ) {
			fprintf(stderr,"msg: %s\n",msg);
			fflush(stderr);
		}
	}
	else {
		return(usage_done("notification message missing",2,&pginfo));
	}

	memset(hostsvc,0,sizeof(hostsvc));
	strncpy(hostsvc,workmsg,sizeof(hostsvc)-1);
	normalize_hostsvc(hostsvc,NORM_COMMAS);
	/* normalize_hostsvc(hostsvc,NORM_COMMAS|NORM_LCASE); */


	/* Don't do notifications on summaries */
	if( !strncmp(hostsvc,"summary.",strlen("summary.")) ) {
		return(done(0,&pginfo));
	}

	if( DEBUG ) {
		fprintf(stderr,"hostsvc: %s\n",hostsvc);
		fflush(stderr);
	}

	/*
	 * if !FQDN then remove domain name
	 */
	if( fqdn != 1 ) {
		workptr = strrchr(hostsvc,'.');   /* Point to service name */
		workptr1 = strchr(hostsvc,',');	  /* Point to domain name */
		if( workptr && workptr1 && (workptr1 > workptr) ) {
			strcpy(workptr,workptr1);
		}
	}

	memset(arg2,0,sizeof(arg2));
	sprintf(str_fmt,"%%%ds",sizeof(arg2)-1);
	sscanf(msg,str_fmt,arg2);

	if( DEBUG ) {
		fprintf(stderr,"2nd word in message is: <%s>\n",arg2);
		fflush(stderr);
	}

	recovered = 0;
	/* Check if notification comes from the paging web page */
	/* host.service tag is notify-admin.pagehelp		*/
	/* or from a special case of notify-admin */
	if( !strncmp(hostsvc,"notify-admin.",strlen("notify-admin.")) ) {
		if( DEBUG ) {
			fprintf(stderr,"We have a \"notify-admin\" request\n");
			fflush(stderr);
		}
		strncpy(pagehelpusernum,arg2,sizeof(pagehelpusernum));
	}
	else {
		/* Should you notify and not create any np_* tag files ? */
		/* used when color has become normal state again */
		if( !strcmp(arg2,"recovered") ) {
			if( DEBUG ) {
				fprintf(stderr,"We have a \"recovered\" message\n");
				fflush(stderr);
			}
			sprintf(pginfo.recoverytagfile,"%.*s/nprec_%.*s",sizeof(bbtmpdir)-1,bbtmpdir,sizeof(hostsvc)-1,hostsvc);
			/* If multiple BBDISPLAY exists then a BBPAGER */
			/* may receive multiple recovery message for the */
			/* same event.  Only handle the 1st request */
			if( stat(pginfo.recoverytagfile,&statinfo)  == 0 ) {
				/* Don't do a done() because that'll remove */
				/* the associated nprec_ file */
				pginfo.recoverytagfile[0] = '\0';
				return(100);
			}
			if( (fp = fopen(pginfo.recoverytagfile,"w")) == NULL ) {
				fprintf(stderr,"Could not create recovery tag file\n");
				return(done(1,&pginfo));
			}
			fclose(fp);
			recovered = 1;
		}
		strncpy(color,arg2,sizeof(color)-1);
		if( DEBUG ) {
			fprintf(stderr,"color of msg: %s\n",color);
			fflush(stderr);
		}
	}

	/* Has this BBPAGER been disabled */
	getsetup(bbwarn, "bbwarn", sizeof(bbwarn));
	setstrtoupper(bbwarn);

	if( DEBUG ) {
		fprintf(stderr,"bbwarn: %s\n",bbwarn);
		fflush(stderr);
	}

	/*
	 * SMM - IF WE'RE IN FAILOVER MODE - OVERRIDE
	 */
	sprintf(workfilename,"%.*s/FAILOVER-BBPAGER",PATH_MAX-strlen("/FAILOVER-BBPAGER")-1,bbtmpdir);
	if( stat(workfilename,&statinfo) == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"bbwarn: %s, reset du to existence of %s\n",bbwarn,workfilename);
			fflush(stderr);
		}
		strcpy(bbwarn,"TRUE");
	}

	/* If BBWARN is disabled, exit */
	if( (strlen(bbwarn) == 0) || strcmp(bbwarn,"TRUE") ) {
		return(done(0,&pginfo));
	}

	getsetup(pagelevels, "pagelevels", sizeof(pagelevels));
	replacestr(pagelevels,sizeof(pagelevels),"\t"," ");
	if( DEBUG ) {
		fprintf(stderr,"The pagelevels is set to <%s>\n",pagelevels);
		fflush(stderr);
	}
	strcat(pagelevels," ");	/* Add " " so we can search using <color > */
	/* In color in pagelevels ? if not, don't notify */
	if( !recovered && strstr(pagelevels,color) == NULL ) {
		return(done(0,&pginfo));
	}

	/*
	 * Get pagedelay value from config file
	 */
	getsetup(pagedelayval,"pagedelay",sizeof(pagedelayval));
	if( isdigit(pagedelayval[0]) ) {
		pginfo.pagedelay = atoi(pagedelayval);
	}
	else {
		pginfo.pagedelay = 15;
	}
	if( DEBUG ) {
		fprintf(stderr,"pagedelay: %s\n",pagedelayval);
		fflush(stderr);
	}

	/*
	 * GET THE BBWARN RULES CONFIGURATION FILE DELIMITER
	 */
	strcpy(pginfo.cfgdelim,";");
	getsetup(pginfo.cfgdelim, "cfgdelim", sizeof(pginfo.cfgdelim));
	if( DEBUG ) {
		fprintf(stderr,"cfgdelim: %s\n",pginfo.cfgdelim);
		fflush(stderr);
	}

	/*
	 * GET THE SERVICE:ERROR TAGS
	 */
	strcpy(pginfo.svcerrlist,"disk:100 cpu:200 procs:300 msgs:400 conn:500 http:600 dns:800 ERR:999");
	getsetup(pginfo.svcerrlist, "svcerrlist", sizeof(pginfo.svcerrlist));
	if( DEBUG ) {
		fprintf(stderr,"svcerrlist: %s\n",pginfo.svcerrlist);
		fflush(stderr);
	}

	/*
	 * Get the code for required help when user uses HTML form
	 *   to page the admin(s)
	 */
	strcpy(pginfo.pagehelpcode ,"911");
	getsetup(pginfo.pagehelpcode, "pagehelpcode", sizeof(pginfo.pagehelpcode));
	if( DEBUG ) {
		fprintf(stderr,"pagehelpcode: %s\n",pginfo.pagehelpcode);
		fflush(stderr);
	}

	memset(redhost,0,sizeof(redhost));
	memset(redsvc,0,sizeof(redsvc));

	workptr = strchr(hostsvc,'.');
	if( !workptr ) {

		if( DEBUG ) {
			fprintf(stderr,"Invalid host in message: %s\n",hostsvc);
			fprintf(stderr,"Is this a pre1.08 message ? if so upgrade your client\n");
			fflush(stderr);
		}
		if ( match(hostsvc,"[0-9]*",REG_FULL) == 0 ) {
			return(usage_done("Invalid host defined in message",1,&pginfo));
		}

		/*
		 * Leave the following code here if we ever decide
		 * to support pre-1.08 clients
		 *
		 */

        	oldstylepagemsg = 1;

		/*
		 * We presume this is old style message
		 * Rebuild into a new BBWARN style message
		 * host.service (host,domain.service) is the 1st argument
		 * We have to rebuild the IP address without '.' and match with
		 * the incoming
		 */

		neterr = getenv("NETERR");
		if( !neterr || strlen(neterr) == 0 ) {
			neterr = "7";
		}

		memset(hostinfo,'\0',sizeof(hostinfo));
		if( getoldinfo(hostsvc,hostinfo,sizeof(hostinfo),pginfo.svcerrlist) ) {
			sprintf(str_fmt,"%%%ds %%%ds",sizeof(redhost)-1,sizeof(redsvc)-1);
			sscanf(hostinfo,str_fmt, redhost,redsvc);
			sprintf(bbhostsvc,"%s.%s",redhost,redsvc);
			if( DEBUG ) {
				fprintf(stderr,"hostinfo: (bbhostsvc:%s) (redhost:%s) (redsvc:%s)\n",bbhostsvc,redhost,redsvc);
				fflush(stderr);
			}
		}
		else {
			/*
			 * An unmatched host may occur when the definition in the
			 * foreign bb-hosts file is not the same as the local one
			 * i.e 10.2.4.5  and 10.2.4.05
			 *  one produces 10245 and the other 102405
			 */
			strcpy(redsvc,"ERR");
			sprintf(redhost,"unmatched-%s",hostsvc);
			sprintf(bbhostsvc,"%s.%s",redhost,redsvc);
			if( DEBUG ) {
				fprintf(stderr,"hostinfo(unmatched): (bbhostsvc:%s) (redhost:%s) (redsvc:%s)\n",bbhostsvc,redhost,redsvc);
				fflush(stderr);
			}
		}
	}
	else {
        	oldstylepagemsg = 0;
		strncpy(redhost,hostsvc,workptr-hostsvc);
		replacestr(redhost,sizeof(redhost),",",".");
		strcpy(redsvc,workptr+1);
		sprintf(bbhostsvc,"%s.%s",redhost,redsvc);
		if( DEBUG ) {
			fprintf(stderr,"hostinfo: (hostsvc:%s) (bbhostsvc:%s) (redhost:%s) (redsvc:%s)\n",hostsvc,bbhostsvc,redhost,redsvc);
			fflush(stderr);
		}
	}


	/*
	 * Get the code for required help when user uses HTML form
	 *   to page the admin(s)
	 */
	memset(pginfo.ignforall,'\0',sizeof(pginfo.ignforall));
	getsetup(pginfo.ignforall, "ignforall", sizeof(pginfo.ignforall));
	if( DEBUG ) {
		fprintf(stderr,"ignforall: %s\n",pginfo.ignforall);
		fflush(stderr);
	}

	/* Does this host match the ignore token ? */
	if( strlen(pginfo.ignforall) && match(hostsvc,pginfo.ignforall,REG_FULL) ) {
		if( DEBUG ) {
			fprintf(stderr,"host: %s matched ignforall regex: %s\n",hostsvc,pginfo.ignforall);
			fflush(stderr);
		}
		return(done(0,&pginfo));
	}

	/*
	 * Get day of week and time of day
	 * day of week, 0-6
	 * time of day  0000-2359
	 */
	time(&timenow);
	time_tm = localtime(&timenow);
	nowday = time_tm->tm_wday;
	nowtime = (time_tm->tm_hour * 100) + time_tm->tm_min;

	/*
	 Get IP address of host (formatted) and service code
	 */
	memset(redhostip,0,sizeof(redhostip));
	memset(machsvc,0,sizeof(machsvc));
	if( getipaddr(redhost,redhostip,sizeof(redhostip),1) == 0 ) {
		ip1 = ip2 = ip3 = ip4 = 0;
		sscanf(redhostip,"%d.%d.%d.%d",&ip1,&ip2,&ip3,&ip4);
		sprintf(machip,"%03d%03d%03d%03d",ip1,ip2,ip3,ip4);
		getsvccode(redsvc,svcerr,sizeof(svcerr),pginfo.svcerrlist);
		sprintf(machsvc,"%s.%s",redhost,redsvc);
		if( DEBUG ) {
			fprintf(stderr,"machip: %s - redsvc: %s - svcerr: %s\n",machip,redsvc,svcerr);
			fflush(stderr);
		}
	}
	else {

		/* They're unmatched */
		/* but could be a message from the help HTML page */
		/* Is it ? */
		if( strcmp(redhost,"notify-admin") != 0 ) {
			/* Nope */
			strcpy(machip,"999999999999");
			/* Old way, obsolete */
			if( oldstylepagemsg == 1 ) {
				strcpy(svcerr,"999");
				if( DEBUG ) {
					fprintf(stderr,"machip: %s - svcerr: %s\n",machip,svcerr);
					fflush(stderr);
				}
			}
			else {
				strcpy(tmpredhost,redhost);
				strcpy(redhost,"unmatched-");
				strcat(redhost,tmpredhost);
				sprintf(machsvc,"%s.%s",redhost,redsvc);
				getsvccode(redsvc,svcerr,sizeof(svcerr),pginfo.svcerrlist);
				if( DEBUG ) {
					fprintf(stderr,"redhost: %s - machsvc: %s - svcerr: %s\n",redhost,machsvc,svcerr);
					fflush(stderr);
				}
			}

		}
		else {
			/* This is a user help request from HTML form */

			strncpy(svcerr,pginfo.pagehelpcode,sizeof(svcerr)-1);
			strncpy(machip,pagehelpusernum,sizeof(machip)-1);
			if( DEBUG ) {
				fprintf(stderr,"machip: %s - svcerr: %s\n",machip,svcerr);
				fflush(stderr);
			}
		}

	}


	sprintf(workfilename,"%s/etc/bbwarnrules.cfg",bbhome);
	if( (fp=fopen(workfilename,"r")) == NULL ) {
		return(usage_done("Can't open bbwarnrules.cfg",1,&pginfo));
	}


	cont = 0;
	instr_maxlen = 2048;
	fullinstr_maxlen = 2048;
	usageline_maxlen = 2048;
	workline_maxlen = 2048;
	workline1_maxlen = 2048;
	ignpagers_maxlen = 2048;
	pagers_maxlen = 2048;
	if( (instr=calloc(instr_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for instr",1,&pginfo));
	}
	if( (fullinstr=calloc(fullinstr_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for fullinstr",1,&pginfo));
	}
	if( (usageline=calloc(usageline_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for usageline",1,&pginfo));
	}
	if( (workline=calloc(workline_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for workline",1,&pginfo));
	}
	if( (workline1=calloc(workline1_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for workline1",1,&pginfo));
	}
	if( (pagers=calloc(pagers_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for pagers",1,&pginfo));
	}
	if( (ignpagers=calloc(ignpagers_maxlen,1)) == NULL ) {
		return(usage_done("Can't allocate memory for ignpagers",1,&pginfo));
	}
	while( fgets(instr,instr_maxlen-1,fp) != NULL ) {
		stripleadtrailspaces(instr);
		/* empty line ? */
		if( instr[0] == '\0' ) {
			continue;
		}
		/* Comment ? */
		if( instr[0] == '#' ) {
			continue;
		}

		if( cont == 0 ) {
			memset(fullinstr,0,fullinstr_maxlen);
		}

		if( (strlen(fullinstr)+strlen(instr)) < fullinstr_maxlen ) {
			strcat(fullinstr,instr);
		}
		else {
			fullinstr_maxlen += instr_maxlen;
			if( (fullinstr=realloc(fullinstr,fullinstr_maxlen)) == NULL ) {
				return(usage_done("Can't reallocate memory for fullinstr",1,&pginfo));
			}
			strcat(fullinstr,instr);
		}
		/* Do we have a continuation tag ? */
		if( instr[strlen(instr)-1] == '\\' ) {
			/* Yup */
			/* Only remove if it's still part of the string */
			/* The instr may not have been completely copied into fullinstr */
			if( fullinstr[strlen(fullinstr)-1] == '\\' ) {
				fullinstr[strlen(fullinstr)-1] = '\0';
			}
			cont = 1;
			continue;
		}

		cont = 0;
		/* If you're wondering why I'm not using fullinstr */
		/* it's because it's new code (the '\') and only instr */
		/* was used in the code further below */
		if( instr_maxlen < fullinstr_maxlen ) {
			instr_maxlen = fullinstr_maxlen;
			if( (instr=realloc(instr,fullinstr_maxlen)) == NULL ) {
				return(usage_done("Can't reallocate memory for instr",1,&pginfo));
			}
		}
		strcpy(instr,fullinstr);
		if( DEBUG ) {
			fprintf(stderr,"rule line: %s\n",instr);
			fflush(stderr);
		}


		/*
		 * For unmatched records and HTML form paging just match on lines
		 * that start with "unmatched-" and "notify-admin" respectively
		 */
		if( strncmp(redhost,"unmatched-*",strlen("unmatched-*")) == 0 ) {
			if( strncmp(instr,"unmatched-*",strlen("unmatched-*")) != 0 ) {
				continue;
			}
		}
		else if( strncmp(redhost,"notify-admin",strlen("notify-admin")) == 0 ) {
			if( strncmp(instr,"notify-admin",strlen("notify-admin")) != 0 ) {
				continue;
			}
		}

		if( workline_maxlen < (instr_maxlen+128) ) {
			workline_maxlen += instr_maxlen + 128;
			if( (workline=realloc(workline,workline_maxlen)) == NULL ) {
				return(usage_done("Can't reallocate memory for workline",1,&pginfo));
			}
		}
		strcpy(workline,instr);
		strcat(workline,";");	/* make sure all columns are handled in the while loop */
		beginptr = workline;
		i = 0;
		while( ((endptr = strchr(beginptr,pginfo.cfgdelim[0])) != NULL) && (i < MAXRULEARGS) ) {
			*endptr = '\0';
			strncpy(ruleargs[i],beginptr,sizeof(ruleargs[0]));
			stripleadtrailspaces(ruleargs[i]);
			space_sep(ruleargs[i]);
			/*
			 * Check if column 1,3,5,6,7 are empty
			 */
			if( (strlen(ruleargs[i]) == 0) && (i != 1) && (i!= 3) ) {
				sprintf(usageline,"Empty column %d",i);
				usage(usageline);
				continue;
			}
			beginptr = ++endptr;
			if( DEBUG ) {
				fprintf(stderr,"Column %d: %s\n",i+1,ruleargs[i]);
				fflush(stderr);
			}
			i++;
		}
		/* Invalid rule line ? missing args ? */
		if( i != MAXRULEARGS ) {
			memset(usageline,0,usageline_maxlen);
			sprintf(usageline,"Invalid rule line: %s",instr);
			usage(usageline);
			continue;
		}
	
		/*
		 * Arg 1: hosts
		 * Arg 2: excluded hosts
		 * Arg 3: services
		 * Arg 4: excluded hosts
		 * Arg 5: Days of week
		 * Arg 6: Time of day
		 * Arg 7: recipients
		 */

		ignore = 0;

		/*
		 * !line indicates recipients to ignore if it matches
		 * remove ! from line and handle like normal rule line
		 */
		if( ruleargs[0][0] == '!' ) {
			ignore = 1;
			strcpy(ruleargs[0],&ruleargs[0][1]);
			if( DEBUG ) {
				fprintf(stderr,"It's an ignore line, don't notify: %s \n",ruleargs[6]);
				fflush(stderr);
			}
			ptrpagers = ignpagers;
			ptrpagers_maxlen = &ignpagers_maxlen;
		}
		else {
			ptrpagers = pagers;
			ptrpagers_maxlen = &pagers_maxlen;
		}

		/*
		 * Get host list to include
		 */
		if( strlen(ruleargs[0]) == 0 ) {
			if( (strlen(instr)+128) > usageline_maxlen ) {
				usageline_maxlen += strlen(instr)+128;
				if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
					return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
				}
			}
			memset(usageline,0,sizeof(usageline));
			sprintf(usageline,"Invalid rule line(hosts undefined): %s",instr);
			usage(usageline);
			continue;
		}

		memset(workline,0,workline_maxlen);
		strncpy(workline,ruleargs[0],workline_maxlen-1);
		workptr = workline;
		if( DEBUG ) {
			fprintf(stderr,"Substituting hg- tags in the rule line\n");
			fprintf(stderr,"Original column 1:       %s\n",ruleargs[0]);
			fflush(stderr);
		}
		/*
		 * Expand host list with hg- entries from bbwarnsetup.cfg
		 */
		hosts_maxlen = 2048;
		if( (hosts=calloc(hosts_maxlen,1)) == NULL ) {
			return(usage_done("Can't allocate memory for hosts",1,&pginfo));
		}
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(hostentry,0,sizeof(hostentry));
			sprintf(str_fmt,"%%%ds",sizeof(hostentry)-1);
			sscanf(workptr,str_fmt,hostentry);
			if( DEBUG ) {
				fprintf(stderr,"Checking host definition: %s\n",hostentry);
				fflush(stderr);
			}
			workptr += strlen(hostentry);
			
			stripleadspaces(workptr);
			if( strncmp(hostentry,"hg-",strlen("hg-")) == 0 ) {
				memset(hghosts,0,sizeof(hghosts));
				getsetup(hghosts,hostentry,sizeof(hghosts));
				if( strlen(hghosts) == 0 ) {
					sprintf(usageline,"%.*s token is empty",usageline_maxlen-32,hostentry);
					usage(usageline);
				}
				else {
					space_sep(hghosts);
					if( (strlen(hghosts)+strlen(hosts)+128) >= hosts_maxlen ) {
						hosts_maxlen += strlen(hghosts) + 128;
						if( (hosts=realloc(hosts,hosts_maxlen)) == NULL ) {
							return(usage_done("Can't allocate memory for hosts",1,&pginfo));
						}
					}
					strcat(hosts," ");
					strcat(hosts,hghosts);
				}
			}
			else {
				if( (strlen(hostentry)+strlen(hosts)+128) >= hosts_maxlen ) {
					hosts_maxlen += strlen(hostentry) + 128;
					if( (hosts=realloc(hosts,hosts_maxlen)) == NULL ) {
						return(usage_done("Can't allocate memory for hosts",1,&pginfo));
					}
				}
				strcat(hosts," ");
				strcat(hosts,hostentry);
			}
		} 
		/*
		 * I know for a fact that it starts with a space
		 */
		stripleadtrailspaces(hosts);
		if( strlen(hosts) == 0 ) {
			strcpy(usageline,"Column 1 is empty");
			usage(usageline);
			continue;
		}
		space_sep(hosts);
		if( DEBUG ) {
			fprintf(stderr,"Included hosts are: <%s>\n",hosts);
			fflush(stderr);
		}
		/*replacestr(hosts,sizeof(hosts),"*",".*");*/
		/* Thanks to Al Rankin for catching the sizeof(hosts) -> hosts_maxlen bug */
		replacestr(hosts,hosts_maxlen," ","|");
		if( DEBUG ) {
			fprintf(stderr,"Column 1 converted to a regex: <%s>\n",hosts);
			fflush(stderr);
		}

		/*
		 * Get host list to exclude
		 */
		strncpy(workline,ruleargs[1],workline_maxlen-1);
		workptr = workline;
		exhosts_maxlen = 2048;
		if( (exhosts=calloc(exhosts_maxlen,1)) == NULL ) {
			return(usage_done("Can't allocate memory for exhosts",1,&pginfo));
		}
		if( DEBUG ) {
			fprintf(stderr,"Original column 2:       %s\n",ruleargs[1]);
			fflush(stderr);
		}
		/* Expand host list with hg- entries from bbwarnsetup.cfg */
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(hostentry,0,sizeof(hostentry));
			sprintf(str_fmt,"%%%ds",sizeof(hostentry)-1);
			sscanf(workptr,str_fmt,hostentry);
			if( DEBUG ) {
				fprintf(stderr,"Checking host definition: %s\n",hostentry);
				fflush(stderr);
			}
			workptr += strlen(hostentry);
			stripleadspaces(workptr);
			if( strncmp(hostentry,"hg-",strlen("hg-")) == 0 ) {
				memset(hghosts,0,sizeof(hghosts));
				getsetup(hghosts,hostentry,sizeof(hghosts));
				if( strlen(hghosts) == 0 ) {
					sprintf(usageline,"%.*s token is empty",usageline_maxlen-1,hostentry);
					usage(usageline);
				}
				else {
					space_sep(hghosts);
					if( (strlen(hghosts)+strlen(exhosts)+128) >= exhosts_maxlen ) {
						exhosts_maxlen += strlen(hghosts) + 128;
						if( (exhosts=realloc(exhosts,exhosts_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for exhosts",1,&pginfo));
						}
					}
					strcat(exhosts," ");
					strcat(exhosts,hghosts);
				}
			}
			else {
				if( (strlen(hostentry)+strlen(exhosts)+128) >= exhosts_maxlen ) {
					exhosts_maxlen += strlen(hostentry) + 128;
					if( (exhosts=realloc(exhosts,exhosts_maxlen)) == NULL ) {
						return(usage_done("Can't reallocate memory for exhosts",1,&pginfo));
					}
				}
				strcat(exhosts," ");
				strcat(exhosts,hostentry);
			}
		}
		/* I know for a fact that it starts with a space */
		stripleadspaces(exhosts);
		space_sep(exhosts);
		if( DEBUG ) {
			fprintf(stderr,"Excluded hosts are: <%s>\n",exhosts);
			fflush(stderr);
		}
		/* Does this host match an exclude token ? */
		if( strlen(exhosts) ) {
			/*replacestr(exhosts,sizeof(exhosts),"*",".*");*/
			replacestr(exhosts,exhosts_maxlen," ","|");
			if( DEBUG ) {
				fprintf(stderr,"Excluded hosts converted to a regex: <%s>\n",exhosts);
				fprintf(stderr,"Trying to match <%s> with exhosts regex: <%s>\n",redhost,exhosts);
				fflush(stderr);
			}
			if( match(redhost,exhosts,REG_FULL|REG_PATHEXP) ) {
				/*
				 * Yup
				 */
				if( DEBUG ) {
					fprintf(stderr,"Ignore this rule as host <%s> matched this excluding regex: <%s>\n",redhost,exhosts);
					fflush(stderr);
				}
				continue;
			}
			if( DEBUG ) {
				fprintf(stderr,"host <%s> did not match with exhosts regex: <%s>\n",redhost,exhosts);
				fflush(stderr);
			}
		}

		if( DEBUG ) {
			fprintf(stderr,"Trying to match host <%s> with hosts regex: <%s>\n",redhost,hosts);
			fflush(stderr);	
		}
		/* Does this host match an include token ? */
		if( !match(redhost,hosts,REG_FULL|REG_PATHEXP) ) {
			/*
			 * Nope
			 */
			if( DEBUG ) {
				fprintf(stderr,"Ignore this rule as host <%s> did not match this regex: <%s>\n",redhost,hosts);
				fflush(stderr);
			}
			continue;
		}
		if( DEBUG ) {
			fprintf(stderr,"Host <%s> matched this regex: <%s>\n",redhost,hosts);
			fflush(stderr);
		}
		/*
		 * Get services list to include
		 */
		if( strlen(ruleargs[2]) == 0 ) {
			if( (strlen(instr)+128) > usageline_maxlen ) {
				usageline_maxlen += strlen(instr)+128;
				if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
					return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
				}
			}
			memset(usageline,0,sizeof(usageline));
			sprintf(usageline,"Invalid rule line(services undefined): %s",instr);
			usage(usageline);
			continue;
		}
		svcs_maxlen = 2048;
		if( (svcs=calloc(svcs_maxlen,1)) == NULL ) {
			return(usage_done("Can't allocate memory for svcs",1,&pginfo));
		}
		strncpy(svcs,ruleargs[2],svcs_maxlen-1);
		space_sep(svcs);
		/*replacestr(svcs,sizeof(svcs),"*",".*");*/
		replacestr(svcs,svcs_maxlen," ","|");
	
		/*
		 * Get services list to exclude
		 */
		exsvcs_maxlen = 2048;
		if( (exsvcs=calloc(exsvcs_maxlen,1)) == NULL ) {
			return(usage_done("Can't allocate memory for exsvcs",1,&pginfo));
		}
		strncpy(exsvcs,ruleargs[3],exsvcs_maxlen-1);
		space_sep(exsvcs);
		/*replacestr(exsvcs,sizeof(exsvcs),"*",".*");*/
		replacestr(exsvcs,exsvcs_maxlen," ","|");
	
		if( DEBUG ) {
			fprintf(stderr,"Trying to match service <%s> with svcs regex: <%s>\n",redsvc,exsvcs);
			fflush(stderr);
		}
		/* Does this service match an exclude token ? */
		if( strlen(exsvcs) && match(redsvc,exsvcs,REG_FULL) ) {
			if( DEBUG ) {
				fprintf(stderr,"Ignore this rule as service <%s> matched this excluding regex: <%s>\n",redsvc,exsvcs);
				fflush(stderr);
			}
			continue;
		}

		/* Does this service match an include token ? */
		if( strlen(svcs) && !match(redsvc,svcs,REG_FULL) ) {
			if( DEBUG ) {
				fprintf(stderr,"Ignore this rule as service <%s> did not match this regex: <%s>\n",redsvc,svcs);
				fflush(stderr);
			}
			continue;
		}

		/*
		 * Is today a match for the days column ?
		 */
		strncpy(workline,ruleargs[4],workline_maxlen-1);
		if( strcmp(workline,"*") == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Day definition in rule line matched all (*)\n");
				fflush(stderr);
			}
			goto dotime;
		}
		setstrtolower(workline);
		workptr = workline;
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(dayval,0,sizeof(dayval));
			sprintf(str_fmt,"%%%ds",sizeof(dayval)-1);
			sscanf(workptr,str_fmt,dayval);
			workptr += strlen(dayval);
			stripleadspaces(workptr);
			dayrange = strchr(dayval,'-');
			if( dayrange ) {
				if( DEBUG ) {
					fprintf(stderr,"We have a day range: %s\n",dayval);
					fflush(stderr);
				}
				*dayrange = '\0';
				dayrange++;
				if( *dayrange && !isspace(*dayrange) ) {
					strcpy(startdayval,dayval);
					strcpy(enddayval,dayrange);
					if( DEBUG ) {
						fprintf(stderr,"Start day range: %s\n",startdayval);
						fprintf(stderr,"End   day range: %s\n",enddayval);
						fflush(stderr);
					}
				}
				else {
					if( (strlen(instr)+128) > usageline_maxlen ) {
						usageline_maxlen += strlen(instr)+128;
						if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
						}
					}
					memset(usageline,0,sizeof(usageline));
					sprintf(usageline,"Invalid rule line(invalid day range): %s",instr);
					usage(usageline);
					continue;
				}
			}
			else {
				strcpy(startdayval,dayval);
				strcpy(enddayval,dayval);
				if( DEBUG ) {
					fprintf(stderr,"Start/End day range: %s\n",startdayval);
					fflush(stderr);
				}
			}
			startday = -1;
			startday = atoi(startdayval);
			endday = -1;
			endday = atoi(enddayval);
			if( startday < 0 || startday > 6 || endday < 0 || endday > 6 ) {
				if( (strlen(instr)+128) > usageline_maxlen ) {
					usageline_maxlen += strlen(instr)+128;
					if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
						return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
					}
				}
				memset(usageline,0,sizeof(usageline));
				sprintf(usageline,"Invalid rule line(invalid day range): %s",instr);
				usage(usageline);
				continue;
			}
			if( (nowday >= startday) && (nowday <= endday) ) {
				if( DEBUG ) {
					fprintf(stderr,"Current day <%d> is within Start/End day range: <%d-%d>\n",nowday,startday,endday);
					fflush(stderr);
				}
				workptr=startdayval;
				break;
			}
		}
		if( strlen(workptr) == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Current day <%d> is not within Start/End day range: <%d-%d>\n",nowday,startday,endday);
				fflush(stderr);
			}
			continue;
		}
dotime:
		/*
		 * Is the current time a match for the time column ?
		 */
		strncpy(workline,ruleargs[5],workline_maxlen-1);
		if( strcmp(workline,"*") == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Time definition in rule line matched all (*)\n");
				fflush(stderr);
			}
			goto dorcpts;
		}
		setstrtolower(workline);
		workptr = workline;
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(timesval,0,sizeof(timesval));
			sprintf(str_fmt,"%%%ds",sizeof(timesval)-1);
			sscanf(workptr,str_fmt,timesval);
			timesrange = strchr(timesval,'-');
			workptr += strlen(timesval);
			stripleadspaces(workptr);
			if( timesrange ) {
				if( DEBUG ) {
					fprintf(stderr,"We have a time range: %s\n",timesval);
					fflush(stderr);
				}
				*timesrange = '\0';
				timesrange++;
				if( *timesrange && !isspace(*timesrange) ) {
					strcpy(starttimesval,timesval);
					strcpy(endtimesval,timesrange);
					if( DEBUG ) {
						fprintf(stderr,"Start time range: %s\n",starttimesval);
						fprintf(stderr,"End   time range: %s\n",endtimesval);
						fflush(stderr);	
					}
				}
				else {
					if( (strlen(instr)+128) > usageline_maxlen ) {
						usageline_maxlen += strlen(instr)+128;
						if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
						}
					}
					memset(usageline,0,sizeof(usageline));
					sprintf(usageline,"Invalid rule line(invalid time range): %s",instr);
					usage(usageline);
					continue;
				}
			}
			else {
				strcpy(starttimesval,timesval);
				strcpy(endtimesval,timesval);
				if( DEBUG ) {
					fprintf(stderr,"Start/End time range: %s\n",starttimesval);
					fflush(stderr);
				}
			}
			starttimes = -1;
			starttimes = atoi(starttimesval);
			endtimes = -1;
			endtimes = atoi(endtimesval);
			if( starttimes < 0 || starttimes > 2400 || endtimes < 0 || endtimes > 2400 ) {
				memset(usageline,0,sizeof(usageline));
				sprintf(usageline,"Invalid rule line(invalid time range): %s",instr);
				usage(usageline);
				continue;
			}
			if( nowtime >= starttimes && nowtime <= endtimes ) {
				if( DEBUG ) {
					fprintf(stderr,"Current time <%04d> is within Start/End time range: <%04d-%04d>\n",nowtime,starttimes,endtimes);
					fflush(stderr);
				}
				workptr=starttimesval;
				break;
			}
		}
		if( strlen(workptr) == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"Current time <%04d> is not within Start/End time range: <%04d-%04d>\n",nowtime,starttimes,endtimes);
				fflush(stderr);
			}
			continue;
		}

dorcpts:
		/*
		 * Get recipients list to notify
		 */
		if( DEBUG ) {
			fprintf(stderr,"Recipients column: <%s>\n",ruleargs[6]);
			fflush(stderr);
		}
		if( strlen(ruleargs[6]) == 0 ) {
			if( (strlen(instr)+128) > usageline_maxlen ) {
				usageline_maxlen += strlen(instr)+128;
				if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
					return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
				}
			}
			memset(usageline,0,sizeof(usageline));
			sprintf(usageline,"Invalid rule line(recipients undefined): %s",instr);
			usage(usageline);
			continue;
		}
		strncpy(workline,ruleargs[6],workline_maxlen-1);
		workptr = workline;
		/* Expand host list with pg- entries from bbwarnsetup.cfg */
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(rcptentry,0,sizeof(rcptentry));
			sprintf(str_fmt,"%%%ds",sizeof(rcptentry)-1);
			sscanf(workptr,str_fmt,rcptentry);
			workptr += strlen(rcptentry);
			stripleadspaces(rcptentry);
			/* Make sure the recipient does not start with one */
			/* of the special qualifier characters */
			if( strspn(rcptentry,":^~-") > 0 ) {
				if( (strlen(rcptentry)+128) > usageline_maxlen ) {
					usageline_maxlen += strlen(rcptentry)+128;
					if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
						return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
					}
				}
				sprintf(usageline,"Invalid recipient: %.*s",sizeof(rcptentry)-1,rcptentry);
				usage(usageline);
				continue;
			}
			if( DEBUG ) {
				fprintf(stderr,"Validate recipient: <%s>\n",rcptentry);
				fflush(stderr);
			}
			/*
			 * Take care of ignore recipients
			 */
			if( (ignore == 1) ) {
				if( DEBUG ) {
					fprintf(stderr,"This recipient <%s> has been defined to be ignored\n",rcptentry);
					fflush(stderr);
				}
				if( *rcptentry == '*' ) {
					if( DEBUG ) {
						fprintf(stderr,"The <*> recipient matches all, don't notify\n");
						fflush(stderr);
					}
					fclose(fp);
					return(done(0,&pginfo));
				}
				/*
				 * We don't care about qualifiers on ignored recipients
				 */
				overrideptr = strchr(rcptentry,':');
				if( overrideptr != NULL ) {
					if( DEBUG ) {
						fprintf(stderr,"This recipient <%s> has been redefined as ",rcptentry);
						fflush(stderr);
					}
					*overrideptr = '\0';
					if( DEBUG ) {
						fprintf(stderr,"<%s>\n",rcptentry);
						fflush(stderr);
					}
				}
			}
			/*
			 * Validate overriding qualifier if any
			 */
			memset(overrideval,'\0',sizeof(overrideval));
			overrideptr = strchr(rcptentry,':');
			if( overrideptr != NULL ) {
				if( DEBUG ) {
					fprintf(stderr,"This recipient <%s> has an overidding qualifier, is it valid ?\n",rcptentry);
					fflush(stderr);
				}
				strcpy(rcptentry1,rcptentry);
				*overrideptr = '\0';
				overrideptr++;
				if( (strlen(rcptentry1)+128) > usageline_maxlen ) {
					usageline_maxlen += strlen(rcptentry1)+128;
					if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
						return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
					}
				}
				/* Don't accept rcpt: */
				if( !(*overrideptr && !isspace(*overrideptr)) ) {
					overrideptr = NULL;
					sprintf(usageline,"Invalid recipient: <%s>, overidding qualifier ignored",rcptentry1);
					usage(usageline);
					continue;
				}
				else {
					/*
					 * Qualifier can only start with [~^0-9]
					 */
#if REGEXEC
					if( match(overrideptr,"[~^]?[0-9]+",REG_FULL) ||
						match(overrideptr,"[~^]?[0-9]+-[0-9]+",REG_FULL) ) {
#else
#if REGEX
					if( match(overrideptr,"[~^]{0,1}[0-9]{1,}",REG_FULL) ||
						match(overrideptr,"[~^]{0,1}[0-9]{1,}-[0-9]{1,}",REG_FULL) ) {
#else
#if RE_EXEC
					if( match(overrideptr,"[0-9][0-9]*",REG_FULL) ||
						match(overrideptr,"[~^][0-9][0-9]*",REG_FULL) ||
						match(overrideptr,"[~^][0-9][0-9]*-[0-9][0-9]*",REG_FULL) ) {
#else
					if( 0 ) {
#endif
#endif
#endif
						strncpy(overrideval,overrideptr,sizeof(overrideval));
						if( DEBUG ) {
							fprintf(stderr,"This recipient <%s> has a valid overidding qualifier\n",rcptentry1);
							fflush(stderr);
						}
					}
					else {
						sprintf(usageline,"Invalid recipient: <%s>, invalid overidding qualifier ",rcptentry1);
						usage(usageline);
						overrideptr = NULL;
						continue;
					}
				}
			}

			/*	
			 * Deal with pager group
			 */
			if( strncmp(rcptentry,"pg-",strlen("pg-")) == 0 ) {
				/*
				 * Do we have an overriding parameter ?
				 * if we do then every recipient in the list must be set with it
				 */
				if( DEBUG ) {
					fprintf(stderr,"This recipient <%s> is a page group\n",rcptentry);
					fflush(stderr);
				}
				getsetup(pgrcpts,rcptentry,sizeof(pgrcpts));
				if( DEBUG ) {
					fprintf(stderr,"The page group <%s> is defined by <%s>\n",rcptentry,pgrcpts);
					fflush(stderr);
				}
				space_sep(pgrcpts);
				if( overrideptr != NULL ) {
					pgptr = pgrcpts;
					pgpager[0] = '\0';
					memset(pgpager,'\0',sizeof(pgpager));
					while( *pgptr ) {
						while( isspace(*pgptr) ) {
							pgptr++;
						}
						if( !*pgptr ) {
							break;
						}
						memset(pgpager,0,sizeof(pgpager));
						sprintf(str_fmt,"%%%ds",sizeof(pgpager)-1);
						sscanf(pgptr,str_fmt,pgpager);
						pgptr += strlen(pgpager);
						overrideptr = strchr(pgpager,':');
						if( overrideptr != NULL ) {
							*overrideptr = '\0';
						}
						if( (strlen(ptrpagers)+strlen(pgpager)+strlen(overrideval)+128) >= *ptrpagers_maxlen ) {
							*ptrpagers_maxlen += strlen(pgpager)+strlen(overrideval)+128;
							if( (ptrpagers=realloc(ptrpagers,*ptrpagers_maxlen)) == NULL ) {
								return(usage_done("Can't reallocate memory for ptrpagers",1,&pginfo));
							}
							if( !ignore ) {
								pagers = ptrpagers;
							}
							else {
								ignpagers = ptrpagers;
							}
						}
						/* Thanks to valankar@ifxcorp.com */
						/* for finding a bug where ignored recipient list */
						/* wasn't built properly (the 2nd ptrpagers arg was previously defined as pagers) */
						strcat(ptrpagers," ");
						strcat(ptrpagers,pgpager);
						strcat(ptrpagers,":");
						strcat(ptrpagers,overrideval);
					}
				}
				else {
					strcat(ptrpagers," ");
					strcat(ptrpagers,pgrcpts);
				}
			}
			else {
				if( overrideptr != NULL ) {
					if( (strlen(ptrpagers)+strlen(rcptentry)+strlen(overrideval)+128) >= *ptrpagers_maxlen ) {
						*ptrpagers_maxlen += strlen(rcptentry)+strlen(overrideval)+128;
						if( (ptrpagers=realloc(ptrpagers,*ptrpagers_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for ptrpagers",1,&pginfo));
						}
						if( !ignore ) {
							pagers = ptrpagers;
						}
						else {
							ignpagers = ptrpagers;
						}
					}
					strcat(ptrpagers," ");
					strcat(ptrpagers,rcptentry);
					strcat(ptrpagers,":");
					strcat(ptrpagers,overrideval);
				}
				else {
					if( DEBUG ) {
						fprintf(stderr,"Not a pg- recipient\n");
						fprintf(stderr,"overrideptr: <%s>\n",overrideptr);
						fprintf(stderr,"rcptentry: <%s>\n",rcptentry);
						fflush(stderr);
					}
					if( (strlen(ptrpagers)+strlen(rcptentry)+128) >= *ptrpagers_maxlen ) {
						*ptrpagers_maxlen += strlen(rcptentry)+128;
						if( (ptrpagers=realloc(ptrpagers,*ptrpagers_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for ptrpagers",1,&pginfo));
						}
						if( !ignore ) {
							pagers = ptrpagers;
						}
						else {
							ignpagers = ptrpagers;
						}
					}
					strcat(ptrpagers," ");
					strcat(ptrpagers,rcptentry);
				}
			}
			if( DEBUG ) {
				fprintf(stderr,"The list of recipients to notify is now: <%s>\n",pagers);
				fprintf(stderr,"The list of recipients to ignore is now: <%s>\n",ignpagers);
				fflush(stderr);
			}
		}

		/* I know for a fact that it starts with a space */
		stripleadspaces(ptrpagers);
		space_sep(ptrpagers);
		if( DEBUG ) {
			fprintf(stderr,"The final list of recipients is: <%s>\n",pagers);
			fflush(stderr);
		}

	} /* Reading bbwarnrules.cfg */

	fclose(fp);

	/*
	 * If we don't have any recipients, we're done
	 */
	if( strlen(pagers) == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"Oh well, no recipients were determined, we're done\n");
			fflush(stderr);
		}
		return(done(0,&pginfo));
	}

	if( DEBUG ) {
		fprintf(stderr,"Preliminary recipients list <%s>\n",pagers);
		fflush(stderr);
	}

	/*
	 * Remove any recipients that were on a !rule
	 */
	if( strlen(ignpagers) > 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"Remove these recipients <%s> from the recipients list <%s>\n",ignpagers,pagers);
			fflush(stderr);
		}
		memset(workline,'\0',workline_maxlen);
		strncpy(workline,ignpagers,workline_maxlen-1);
		workptr = workline;
		while( *workptr ) {
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(rcptentry,0,sizeof(rcptentry));
			sprintf(str_fmt,"%%%ds",sizeof(rcptentry)-1);
			sscanf(workptr,str_fmt,rcptentry);
			workptr += strlen(rcptentry);
			if( DEBUG ) {
				fprintf(stderr,"Remove this recipient <%s> from the recipients list <%s>\n",rcptentry,pagers);
				fflush(stderr);
			}
			stripleadspaces(workptr);
			ignpager = strstr(pagers,rcptentry);
			while( ignpager != NULL ) {
				memset(rcptentry1,0,sizeof(rcptentry1));
				sprintf(str_fmt,"%%%ds",sizeof(rcptentry1)-1);
				sscanf(ignpager,str_fmt,rcptentry1);
				pgptr = ignpager + strlen(rcptentry);
				if( isspace(*pgptr) || (*pgptr == ':') || (*pgptr == '\0') ) {
					pgptr = ignpager + strlen(rcptentry1);
					if( *pgptr != '\0' ) {
						strcpy(ignpager,  pgptr);
					}
					else {
						*ignpager = '\0';
					}
					ignpager = strstr(pagers,rcptentry);
				}
				else {
					ignpager = strstr(ignpager+1,rcptentry);
				}
			}
			if( DEBUG ) {
				fprintf(stderr,"New recipients list <%s>\n",pagers);
				fflush(stderr);
			}
		}
	}
	space_sep(pagers);
	stripleadtrailspaces(pagers);

	if( strlen(pagers) == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"We have no recipients, we're done\n");
			fflush(stderr);
		}
		return(done(0,&pginfo));
	}

	/*
	 * Keep only one recipient definition
	 * The definition with the lowest delay is kept
	 */
	strcat(pagers," ");	/* we'll search on recipient[ :] */
	memset(workline,0,workline_maxlen);
	memset(ignpagers,0,ignpagers_maxlen);
	strncpy(workline,pagers,workline_maxlen-1);
	workptr = workline;
	if( DEBUG ) {
		fprintf(stderr,"Keep only one recipient definition per recipient\n");
		fprintf(stderr,"Our recipients list is <%s>\n",pagers);
		fflush(stderr);
	}
	/*
	 * For each recipient choose the one with the smallest delay
	 */
	while( *workptr ) {
		while( isspace(*workptr) ) {
			workptr++;
		}
		if( !*workptr ) {
			break;
		}
		memset(rcptentry1,0,sizeof(rcptentry1));
		sprintf(str_fmt,"%%%ds",sizeof(rcptentry1)-1);
		sscanf(workptr,str_fmt,rcptentry1);
		workptr += strlen(rcptentry1);
		stripleadspaces(workptr);
		if( DEBUG ) {
			fprintf(stderr,"Working on recipient <%s>\n",rcptentry1);
			fflush(stderr);
		}
		strcpy(rcptentry,rcptentry1);
		getdelay(rcptentry1,&initdelay1,&delay1,&type1,pginfo.pagedelay);
		if( (overrideptr1 = strchr(rcptentry1,':')) != NULL ) {
			*overrideptr1 = '\0';
			if( DEBUG ) {
				fprintf(stderr,"Recipient <%s> has an overriding delay <%s>\n",rcptentry1,overrideptr1+1);
				fflush(stderr);
			}
		}
		/*
		 * Is the recipient been defined more than once
		 */
		pgptr = workptr;
		/* don't reuse str_fmt inside the while loop or brace yourself */
		/* for a nasty surprise */
		sprintf(str_fmt,"%%%ds",sizeof(rcptentry2)-1);
		while( sscanf(pgptr,str_fmt,rcptentry2) > 0 ) {
			/* Is it the same recipient ? */
			if( strncmp(rcptentry2,rcptentry1,strlen(rcptentry1)) == 0 ) {
				/* Is it really the same recipient ? */
				if( (rcptentry2[strlen(rcptentry1)] != ':')
					&& (rcptentry2[strlen(rcptentry1)] != '\0') ) {
					/* nope, keep going */
					pgptr = strstr(pgptr,rcptentry2) + strlen(rcptentry2);
					continue;
				}
			}
			else {
				/* nope, keep going */
				pgptr = strstr(pgptr,rcptentry2) + strlen(rcptentry2);
				continue;
			}
			/* Remove this new recipient from the workline */
			strcpy(pgptr,(char *)(strstr(pgptr,rcptentry2)+strlen(rcptentry2)));
			getdelay(rcptentry2,&initdelay2,&delay2,&type2,pginfo.pagedelay);
			/*
			 * We are dealing with the same recipient
			 *
			 * rcpt:15 has priority of rcpt:~15 or rcpt:^15
			 * rcpt:^15 has priority over rcpt:~15
			 */
			if( DEBUG ) {
				fprintf(stderr,"Comparing recipient <%s> to recipient <%s>\n",rcptentry,rcptentry2);
				fflush(stderr);
			}
			if( type2 < type1 ) {
				initdelay1 = initdelay2;
				delay1 = delay2;
				type1 = type2;
				strcpy(rcptentry,rcptentry2);
			}
			else if ( (type2 == type1) && (initdelay2 < initdelay1) ) {
				initdelay1 = initdelay2;
				delay1 = delay2;
				strcpy(rcptentry,rcptentry2);
			}
			else if ( (type2 == type1) && (initdelay2 == initdelay1) && (delay2 < delay1) ) {
				delay1 = delay2;
				strcpy(rcptentry,rcptentry2);
			}
			if( DEBUG ) {
				fprintf(stderr,"Current recipient definition <%s>\n",rcptentry);
				fflush(stderr);
			}
		}
		strcat(ignpagers," ");
		strcat(ignpagers,rcptentry);
		if( DEBUG ) {
			fprintf(stderr,"Adding recipient <%s> to recipient list\n",rcptentry);
			fflush(stderr);
		}
	}
	strcpy(pagers,ignpagers);
	stripleadtrailspaces(pagers);
	space_sep(pagers);

	if( DEBUG ) {
		fprintf(stderr,"Final recipients list <%s>\n",pagers);
		fflush(stderr);
	}

	sprintf(pginfo.pagemsgfile,"%.*s/pagemsg.%d",sizeof(bbtmpdir)-1,bbtmpdir,getpid());

	sprintf(bbnumeric,"%s%s",svcerr,machip);
	if( DEBUG ) {
		fprintf(stderr,"bbnumeric set to <%s>\n",bbnumeric);
		fflush(stderr);
	}

	getsetup(prefix, "prefix", sizeof(prefix));
	if( DEBUG ) {
		fprintf(stderr,"The prefix is set to <%s>\n",prefix);
		fflush(stderr);
	}

	getsetup(suffix, "suffix", sizeof(suffix));
	if( DEBUG ) {
		fprintf(stderr,"The suffix is set to <%s>\n",suffix);
		fflush(stderr);
	}


	getsetup(pagelevelsmail, "pagelevelsmail", sizeof(pagelevelsmail));
	replacestr(pagelevelsmail,sizeof(pagelevelsmail),"\t"," ");
	if( DEBUG ) {
		fprintf(stderr,"The pagelevelsmail is set to <%s>\n",pagelevelsmail);
		fflush(stderr);
	}
	strcat(pagelevelsmail," ");	/* Add " " so we can search using <color > */

	getsetup(pagetype, "pagetype", sizeof(pagetype));
	if( DEBUG ) {
		fprintf(stderr,"The pagetype is set to <%s>\n",pagetype);
		fflush(stderr);
	}
	
	getsetup(pageaddhtmlpath, "pageaddhtmlpath", sizeof(pageaddhtmlpath));
	if( DEBUG ) {
		fprintf(stderr,"The pageaddhtmlpath is set to <%s>\n",pageaddhtmlpath);
		fflush(stderr);
	}

	getsetup(briefrcpts, "briefrcpt", sizeof(briefrcpts));
	if( DEBUG ) {
		fprintf(stderr,"The briefrcpt token is set to <%s>\n",briefrcpts);
		fflush(stderr);
	}

	expand_briefrcpts(briefrcpts,sizeof(briefrcpts));
	if( DEBUG ) {
		fprintf(stderr,"The briefrcpt token after expansion <%s>\n",briefrcpts);
		fflush(stderr);
	}
	/*
	 * Determine the hosts's group name
	 */
	memset(bbgroup,0,sizeof(bbgroup));
	if( strcmp(pagetype,"GROUP") == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"pagetype=GROUP, determine the hosts's group name\n");
			fflush(stderr);
		}
	}

	/*
	 * Remove recipients that have an np_* file associated with them
	 * but haven't been notified because they are in the state of
	 * an initial delay or the waiting period before been escalated to
	 */
	if( recovered == 1 ) {
		if( DEBUG ) {
			fprintf(stderr,"Recovery message: remove recipients which haven't been notified (in delay)\n");
			fprintf(stderr,"Recipients list: <%s>\n",pagers);
			fflush(stderr);
		}
		memset(ignpagers,0,ignpagers_maxlen);
		memset(workline,0,workline_maxlen);
		strncpy(workline,pagers,workline_maxlen-1);
		workptr = workline;
		while( *workptr ) {
			/* Get recipient */
			while( isspace(*workptr) ) {
				workptr++;
			}
			if( !*workptr ) {
				break;
			}
			memset(rcptentry,0,sizeof(rcptentry));
			sprintf(str_fmt,"%%%ds",sizeof(rcptentry)-1);
			sscanf(workptr,str_fmt,rcptentry);
			workptr += strlen(rcptentry);
			while( isspace(*workptr) ) {
				workptr++;
			}
			/* Remove overriding delay definition if any */
			workptr1 = strchr(rcptentry,':');
			if( workptr1 ) {
				*workptr1 = '\0';
			}

			if( strstr(ignpagers,rcptentry) != NULL ) {
				if( DEBUG ) {
					fprintf(stderr,"Recipient <%s> already in list\n",rcptentry);
					fflush(stderr);
				}
				continue;
			}
			if( DEBUG ) {
				fprintf(stderr,"Checking recipient <%s>\n",rcptentry);
				fflush(stderr);
			}
			/* Get each np_file file that match tmp/np_<recipient>* */
			/* Changed how np_ file is search. Map on all np_ */
			/*  files and match the name.  the match() function doesn't */
			/*  like the + character without a reg exp preceeding it. */
			/*  Thanks to Christian Perrier which fell into this bug */
			strcpy(filemask,"np_*");
			dirinfo = NULL;
			rc = getdirfirst(&dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
			while( rc == 1 ) {
				if( DEBUG ) {
					fprintf(stderr,"Is recipient <%s> associated with <%s> ?\n",rcptentry,npfilename);
					fflush(stderr);
				}
				if( strncmp(npfilename+3,rcptentry,strlen(rcptentry)) == 0 ) {
					/* Get file content */
					sprintf(workfilename,"%s/%s",bbtmpdir,npfilename);
					if( (strlen(workfilename)+128) > usageline_maxlen ) {
						usageline_maxlen += strlen(workfilename)+128;
						if( (usageline=realloc(usageline,usageline_maxlen)) == NULL ) {
							return(usage_done("Can't reallocate memory for usageline",1,&pginfo));
						}
					}
					if( DEBUG ) {
						fprintf(stderr,"<%s> is associated with <%s>\n",rcptentry,workfilename);
						fflush(stderr);
					}
					if( stat(workfilename,&statinfo) == 0 ) {
						if( (npfilecontents=calloc(1,statinfo.st_size+1)) != NULL) {
							if( (fp=fopen(workfilename,"r")) != NULL ) {
								if( fread(npfilecontents,statinfo.st_size,1,fp) > 0 ) {
									/* Is this file related to the recipient ? */
									if( strstr(npfilecontents,rcptentry) != NULL ) {
										/* Is this file related to this event ? */
										if( strstr(npfilecontents,bbhostsvc) != NULL ) {
											/* Has the recipient already notified ? */
											if( strstr(npfilecontents,"000000") == NULL ) {
												if( DEBUG ) {
													fprintf(stderr,"Yes, add recipient <%s>\n",rcptentry);
													fflush(stderr);
												}
												strcat(ignpagers," ");
												strcat(ignpagers,rcptentry);
												fclose(fp);
												free(npfilecontents);
												break;
											}
										}
									}
								}
								else {
									sprintf(usageline,"The contents of <%s> could not be read",workfilename);
									usage(usageline);
								}
								fclose(fp);
							}
							else {
								sprintf(usageline,"The file <%s> could not be opened",workfilename);
								usage(usageline);
							}
							free(npfilecontents);
						}
						else {
							usage("Could not allocate memory");
						}
					}
					else {
						sprintf(usageline,"<%s> has suddenly disappeared ...",workfilename);
						usage(usageline);
					}
				}
				rc = getdirnext(dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
			}
			getdirdone(dirinfo);
		}
		stripleadtrailspaces(ignpagers);
		if( strlen(ignpagers) == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"All recipients had not been notified yet, we're done: <%s>\n",pagers);
				fflush(stderr);
			}
			return(done(0,&pginfo));
		}
		strcpy(pagers,ignpagers);
		if( DEBUG ) {
			fprintf(stderr,"Only <%s> are to be notified about this recovery message\n",pagers);
			fflush(stderr);
		}
	}

	/* Hummm, these are already available in bbd.c */
	bblogstatus = getenv("BBLOGSTATUS");
	if( !bblogstatus ) {
		bblogstatus = "";
	}

	bbwebhtmllogs = getenv("BBWEBHTMLLOGS");
	if( !bbwebhtmllogs ) {
		bbwebhtmllogs = "";
	}

	cgibinurl = getenv("CGIBINURL");
	if( !cgibinurl ) {
		cgibinurl = "";
	}

	bbwebhost = getenv("BBWEBHOST");
	if( !bbwebhost ) {
		bbwebhost = "";
	}

	bbwebhosturl = getenv("BBWEBHOSTURL");
	if( !bbwebhosturl ) {
		bbwebhosturl = "";
	}

	if( DEBUG ) {
		fprintf(stderr,"BBLOGSTATUS: <%s>\n",bblogstatus);
		fprintf(stderr,"BBWEBHTMLLOGS: <%s>\n",bbwebhtmllogs);
		fprintf(stderr,"CGIBINURL: <%s>\n",cgibinurl);
		fprintf(stderr,"BBWEBHOST: <%s>\n",bbwebhost);
		fprintf(stderr,"BBWEBHOSTURL: <%s>\n",bbwebhosturl);
		fflush(stderr);
	}

	rcptnum = 10;	/* no need for leading zeros */
	memset(workline,0,workline_maxlen);
	strncpy(workline,pagers,workline_maxlen-1);
	workptr = workline;
	while( strlen(workptr) > 0 ) {
		while( isspace(*workptr) ) {
			workptr++;
		}
		if( !*workptr ) {
			break;
		}
		memset(rcptentry,0,sizeof(rcptentry)-1);
		sprintf(str_fmt,"%%%ds",sizeof(rcptentry));
		sscanf(workptr,str_fmt,rcptentry);
		randval = -1;
		if( DEBUG ) {
			fprintf(stderr,"Notifying <%s>\n",rcptentry);
			fflush(stderr);
		}
		workptr += strlen(rcptentry);
		stripleadtrailspaces(workptr);
		getdelay(rcptentry,&initdelay1,&delay1,&type1,pginfo.pagedelay);
		if( DEBUG ) {
			fprintf(stderr,"Recipient <%s> initdelay <%d> delay <%d> type <%d>\n",rcptentry,initdelay1,delay1,type1);
			fflush(stderr);
		}
		if( (pgptr=strchr(rcptentry,':')) != NULL ) {
			*pgptr = '\0';
		}

		if( (strncmp(bbnumeric,"911",3) != 0) && recovered != 1 ) {
			if( strstr(pagelevelsmail,color) != NULL ) {
				if( DEBUG ) {
					fprintf(stderr,"Only send to an e-mail recipient: <%s> in <%s>\n",color, pagelevelsmail);
					fflush(stderr);
				}
				if( (match(rcptentry,".*@.*",REG_FULL) == 1) && (match(rcptentry,"ep-.*",REG_FULL) == 0)
					&& (match(rcptentry,"ext-.*",REG_FULL) == 0) ) {
					if( DEBUG ) {
						fprintf(stderr,"<%s> is an e-mail recipient\n",rcptentry);
						fflush(stderr);
					}
				}
				else {
					if( DEBUG ) {
						fprintf(stderr,"<%s> is *not* an e-mail recipient\n",rcptentry);
						fflush(stderr);
					}
					continue;
				}
			}
			time(&timenow);
			memset(workfilename,0,sizeof(workfilename));
			sprintf(workfilename,"%.*s/np_%.*s",PATH_MAX,bbtmpdir,PATH_MAX-strlen(bbtmpdir)-6,rcptentry);
			if( strcmp(pagetype,"EVENT") == 0 ) {
				strcat(workfilename,"_");
				strncat(workfilename,bbhostsvc,PATH_MAX-strlen(bbhostsvc)-1);
			}
			else if( strcmp(pagetype,"GROUP") == 0 ) {
				strcat(workfilename,"_");
				strncat(workfilename,bbgroup,PATH_MAX-strlen(bbgroup)-1);
			}
			else if( strcmp(pagetype,"HOST") == 0 ) {
				strcat(workfilename,"_");
				strncat(workfilename,machip,PATH_MAX-strlen(machip)-1);
			}
			if( DEBUG ) {
				fprintf(stderr,"Notification tag file: <%s>\n",workfilename);
				fflush(stderr);
			}
			/*
			 * Check if a tag file already exists
			 */
			if( stat(workfilename,&statinfo) == 0 ) {
				if( DEBUG ) {
					fprintf(stderr,"Last modification time: <%d>, time now: <%d>\n",statinfo.st_mtime,timenow);
					fflush(stderr);
				}
				if( statinfo.st_mtime > timenow ) {
					if( DEBUG ) {
						fprintf(stderr,"Delay hasn't expired, disregard <%s>\n",rcptentry);
						fflush(stderr);
					}
					continue;
				}
				np_exists = 1;
			}
			else {
				np_exists = 0;
			}
			randval = getpid() % 100000;
			if( randval < 10 ) {
				randval *= 1000000;
			}
			else if( randval < 100 ) {
				randval *= 100000;
			}
			else if( randval < 1000 ) {
				randval *= 10000;
			}
			else if( randval < 10000 ) {
				randval *= 1000;
			}
			else {
				randval *= 100;
			}
			randval += rcptnum;
			if( DEBUG ) {
				fprintf(stderr,"randval <%d>\n",randval);
				fprintf(stderr,"Recipient ID <%d>\n",rcptnum);
				fflush(stderr);
			}
			rcptnum++;

			if( type1 & (PAGE_ESCALATE|PAGE_INITDELAY) ) {
				/*
				 * If the np_ file does not exist
				 * or if an np_ file is older than 10 minutes 
				 * (or the PURPLEDELAY value if it's a purple)
				 * then it is considered inactive and is resetted
				 * (unless pagetype is EVENT, all np_ files are active)
				 */
				if( (np_exists == 0)
					|| ((np_exists == 1) &&
						(statinfo.st_mtime < (timenow - (strcmp(color,"purple") ? 600 : purpleoffset)))
							&& (strcmp(pagetype,"EVENT") != 0)) ) {
					if( type1 & PAGE_INITDELAY) {
						sprintf(workline1,"%7d0000000 %s %s %s\n",randval,bbhostsvc,color,rcptentry);
					}
					else {
						sprintf(workline1,"0000000 %s %s %s\n",bbhostsvc,color,rcptentry);
					}
					savefile(workfilename,workline1);
					touchtime(workfilename,initdelay1);
					if( DEBUG ) {
						fprintf(stderr,"Toggle file <%s> created with a initial delay of <%d> minutes\n",workfilename,initdelay1);
						fprintf(stderr,"Do not notify immediately\n");
						fflush(stderr);
					}
					continue;
				}
			}
			/* When using pagetype EVENT, reuse ACK ids as it is certain */
			/* that it is unique to that recipient/event */

			if( strcmp(pagetype,"EVENT") == 0 ) {
				if( DEBUG ) {
					fprintf(stderr,"Reuse ACK id ? np_file is <%s>\n",workfilename);
					fflush(stderr);
				}
				if( (npfilecontents = readfile(workfilename)) != NULL ) {
					if( DEBUG ) {
						fprintf(stderr,"Contents of <%s>: <%s>\n",workfilename,npfilecontents);
						fflush(stderr);
					}
					replacestr(npfilecontents,strlen(npfilecontents),"0000000","");
					if( match(npfilecontents,"[0-9][0-9][0-9][0-9][0-9][0-9][0-9][ 	]",REG_BOL) == 1 ) {
						memset(tmprandvalstr,0,sizeof(tmprandvalstr));
						strncpy(tmprandvalstr,npfilecontents,7);
						if( DEBUG ) {
							fprintf(stderr,"<%s> has a proper ACK ID: <%s>\n",workfilename,tmprandvalstr);
							fflush(stderr);
						}
						tmprandvalstr[7] = '\0';
						tmprandval = atoi(tmprandvalstr);
						if( DEBUG ) {
							fprintf(stderr,"Current ACK id of <%s> is <%s>\n",workfilename,tmprandvalstr);
							fflush(stderr);
						}
						if( tmprandval > 0 ) {
							if( DEBUG ) {
								fprintf(stderr,"ACK id of <%s> will be used\n",tmprandvalstr);
								fflush(stderr);
							}
							randval = tmprandval;
						}
					}
					free(npfilecontents);
				}
			}

			sprintf(workline1,"%7d %s %s %s\n",randval,bbhostsvc,color,rcptentry);
			savefile(workfilename,workline1);
			touchtime(workfilename,delay1);
			if( DEBUG ) {
				fprintf(stderr,"Toggle file <%s> created with a delay of <%d> minutes\n",workfilename,delay1);
				fprintf(stderr,"Go on and notify immediately\n");
				fflush(stderr);
			}
		} /* Not a 911 notification || a recovery message */

		if( recovered == 1 ) {
			randval = 0;
		}

		memset(randvalstr,0,sizeof(randvalstr));
		memset(randvaltag,0,sizeof(randvaltag));
		memset(randvalsubjtag,0,sizeof(randvalsubjtag));
		if( randval >= 0 ) {
			sprintf(randvalstr,"%07d ",randval);
			sprintf(randvaltag,"[%07d] ",randval);
			sprintf(randvalsubjtag," - %07d",randval);
		}
		if( DEBUG ) {
			fprintf(stderr,"randvaltag: <%s>  randvalsubjtag: <%s>\n",randvaltag,randvalsubjtag);
			fflush(stderr);
		}
		memset(htmllink,0,sizeof(htmllink));
		if( strcmp(pageaddhtmlpath,"TRUE") == 0 ) {
			if( DEBUG ) {
				fprintf(stderr,"pageaddhtmlpath is set to TRUE\n");
				fflush(stderr);
			}
			if( (strncmp(hostsvc,"notify-admin",strlen("notify-admin")) == 0)
				|| (strncmp(hostsvc,"unmatched-",strlen("unmatched-")) == 0) ) {
				/* do nothing */
			}
			else {
				if( strcmp(bblogstatus,"DYNAMIC") == 0 ) {
					/* Does CGIBINURL already have the BBWEBHOST path defined ? */
					if( strncmp(bbwebhost,cgibinurl,strlen(bbwebhost)) != 0 ) {
						/* Nope */
						sprintf(htmllink,"\r\n\r\nPlease see: %s%s/bb-hostsvc.sh?HOSTSVC=%s\r\n",bbwebhost,cgibinurl,hostsvc);
					}
					else {
						/* Yup */
						sprintf(htmllink,"\r\n\r\nPlease see: %s/bb-hostsvc.sh?HOSTSVC=%s\r\n",cgibinurl,hostsvc);
					}
				}
				else if( strcmp(bblogstatus,"TEXT") == 0 ) {
					sprintf(htmllink,"\r\n\r\nPlease see: %s/logs/%s\r\n",bbwebhosturl,hostsvc);
				}
				else {
					/* Default is STATIC */
					sprintf(htmllink,"\r\n\r\nPlease see: %s/%s.html\r\n",bbwebhtmllogs,bbhostsvc);
				}
			}
		}
		else {
			/* Force a <CR><LF> at end of mail message */
			strcpy(htmllink,"\r\n");
		}
		if( DEBUG ) {
			fprintf(stderr,"htmllink: <%s>\n",htmllink);
			fprintf(stderr,"BBWEBHOSTURL: <%s>\n",bbwebhosturl);
			fflush(stderr);
		}
		memset(downsecsmsg,0,sizeof(downsecsmsg));
		memset(downsecsval,0,sizeof(downsecsval));
		if( recovered == 1 ) {
			memset(workline1,0,workline1_maxlen);
			workptr1 = strstr(msg," seconds");
			if( workptr1 ) {
				while( isspace(*workptr1) && workptr1 > msg ) {
					workptr1--;
				}
				while( isdigit(*workptr1) && workptr1 > msg ) {
					workptr1--;
				}
				memset(workline1,0,workline1_maxlen);
				sprintf(str_fmt,"%%%ds",workline1_maxlen-1);
				sscanf(workptr1,str_fmt,workline1);
			}
			sprintf(downsecsmsg,"-- Event Duration: %.15s seconds",workline1);
			strncpy(downsecsval,workline1,sizeof(downsecsval)-1);
			if( DEBUG ) {
				fprintf(stderr,"downsecsmsg: <%s>\n",downsecsmsg);
				fflush(stderr);
			}
		}

		bbalpha_maxlen = strlen(randvaltag)+strlen(bbhostsvc)+strlen(bbnumeric)+strlen(htmllink)+strlen(msg)+1024;
		if( (bbalpha=calloc(bbalpha_maxlen,1)) == NULL ) {
			return(usage_done("Can't allocate memory for bbalpha",1,&pginfo));
		}
		if( strstr(briefrcpts,rcptentry) ) {
			sprintf(bbalpha,"%s - %s - %s\r\n%s\r\n",bbhostsvc,bbnumeric,randvaltag,htmllink);
			if( DEBUG ) {
				fprintf(stderr,"Brief message: <%s>\n",bbalpha);
				fflush(stderr);
			}
		}
		else {
			if( DEBUG ) {
				fprintf(stderr,"randvaltag: <%s>\n",randvaltag);
				fprintf(stderr,"msg: <%s>\n",msg);
				fprintf(stderr,"htmllink: <%s>\n",htmllink);
				fflush(stderr);
			}
			sprintf(bbalpha,"%s %s %s %s\r\n",randvaltag,bbhostsvc,msg,htmllink);
			if( DEBUG ) {
				fprintf(stderr,"Regular message: <%s>\n",bbalpha);
				fflush(stderr);
			}
		}


#ifndef ZOMBIE          
		signal(SIGCHLD, SIG_IGN);
#endif /* NO ZOMBIE */  

		memset(numcode,0,sizeof(numcode));
		sprintf(numcode,"%s%s",bbnumeric,randvalstr);
		save_notification = 0;

		if( match(rcptentry,"ext-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an user defined recipient, trying custom notification in ext/pg/\n",rcptentry);
				fflush(stderr);
			}
			bb_putenv("BBALPHAMSG",bbalpha,bbalphamsg_env,sizeof(bbalphamsg_env));
			bb_putenv("ACKCODE",randvalstr,ackcode_env,sizeof(ackcode_env));
			bb_putenv("BBHOSTSVC",bbhostsvc,bbhostsvc_env,sizeof(bbhostsvc_env));
			bb_putenv("BBHOSTNAME",redhost,bbhostname_env,sizeof(bbhostname_env));
			bb_putenv("MACHIP",machip,machip_env,sizeof(machip_env));
			bb_putenv("BBSVCNUM",svcerr,bbsvcnum_env,sizeof(bbsvcnum_env));
			bb_putenv("BBSVCNAME",redsvc,bbsvcname_env,sizeof(bbsvcname_env));
			bb_putenv("BBNUMERIC",numcode,bbnumeric_env,sizeof(bbnumeric_env));
			bb_putenv("BBCOLORLEVEL",color,bbcolorlevel_env,sizeof(bbcolorlevel_env));
			bb_putenv("BBHOSTSVCDOTS",bbhostsvc,bbhostsvcdots_env,sizeof(bbhostsvcdots_env));
			bb_putenv("BBHOSTSVCCOMMAS",hostsvc,bbhostsvccommas_env,sizeof(bbhostsvccommas_env));
			bb_putenv("DOWNSECSMSG",downsecsmsg,downsecsmsg_env,sizeof(downsecsmsg_env));
			bb_putenv("DOWNSECS",downsecsval,downsecs_env,sizeof(downsecs_env));
			bb_putenv("RECOVERED",(recovered == 1 ? "1" : "0"),recovered_env,sizeof(recovered_env));

			save_notification = send_extpage(rcptentry);
		}
		else if( match(rcptentry,"ep-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an e-page recipient\n",rcptentry);
				fflush(stderr);
			}
			sprintf(bbalpha,"!BB%s! %s - %s\r\n",randvalsubjtag,bbhostsvc,bbnumeric);
			strcpy(mailsubject,"BB");
			save_notification = send_mail(bbalpha,mailsubject,rcptentry);
		}
		else if( match(rcptentry,".*@.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an e-mail recipient\n",rcptentry);
				fflush(stderr);
			}
			sprintf(mailsubject,"!BB%s! %s - %s",randvalsubjtag,bbhostsvc,bbnumeric);
			save_notification = send_mail(bbalpha,mailsubject,rcptentry);
		}
		else if( match(rcptentry,"[0-9]",REG_BOL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is a numeric recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_numeric(numcode,prefix,suffix,rcptentry);
		}
		else if( match(rcptentry,"sms-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an sms recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_sms(bbalpha,rcptentry);
		}
		else if( match(rcptentry,"alpha-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an alpha msg recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_alpha(bbalpha,rcptentry);
		}
		else if( match(rcptentry,"qp-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an qpage recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_qpage(bbalpha,rcptentry);
		}
		else if( (match(rcptentry,"sp-.*",REG_FULL) == 1)
				|| (match(rcptentry,"hsp-.*",REG_FULL) == 1) ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an sendpage recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_sendpage(bbalpha,rcptentry);
		}
		else if( match(rcptentry,"trap-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an SNMP trap recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_snmptrap(bbalpha,rcptentry,redhostip,redsvc,recovered);
		}
		else if( match(rcptentry,"smsclient-.*",REG_FULL) == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"<%s> is an smsclient recipient\n",rcptentry);
				fflush(stderr);
			}
			save_notification = send_smsclient(bbalpha,rcptentry);
		}
		else {
			sprintf(errormsg,"Unknown recipient <%s> - it may need to be prefixed with pg-",rcptentry);
			bb_errmsg("bbpage",errormsg);
		}

		if( save_notification == 1 ) {
			save_notif(bbhostsvc,machip,rcptentry,svcerr,downsecsmsg,recovered);
		}

	} /* For each recipient */

	cleanup(&pginfo);

	return(0);
}

#ifdef MAIN
int main(argc,argv) 
int argc;
char *argv[];
{
	if( argc != 2 ) {
		usage("wrong argument count");
		exit(1);
	}

	bb_page(argv[1]);

	exit(0);
}
#endif

/*
 * Process "ack" message type
 *
 * Format:
 *
 *   ack_event <ack #> <delay> [message]
 *   rm_event <host[.domain].service> <seconds down>
 */

void bb_doack(req)
char *req;
{
char	acktype[32];
char	*workreq = NULL;
char	errormsg[4096];
char	acknumber[32],acknum[32];
char	delay[32],downsecs[32];
int	acknumber_int,delay_int,downsecs_int;
char	*message;
char	*workptr;
char	filemask[PATH_MAX+1],hostsvc[MAXHOSTSVCNAMELEN+1],event[MAXHOSTSVCNAMELEN+PATH_MAX+1];
DIR	*dirinfo;
FILE	*fp;
int	rc,ftype,rcptid;
char	npfilename[PATH_MAX+1],workfilename[PATH_MAX+1],ackfilename[(PATH_MAX+1)*2],ackfilemsg[2048];
char	np_acknumber[32],np_host[512],np_color[16],np_recipient[512];
struct	stat statinfo;
char	*npfilecontents;
char	pagetype[32],pagerecovered[16];
char	taginfo[(MAXHOSTNAMELEN+1)*2],*commaptr,*dotptr;
char	request[PATH_MAX+1024];
char	*rm_npfiles = NULL;
int	rm_npfiles_size = 1000;
struct	stat ackfilestat;
int	statres;
time_t	timenow;
char	timenowbuf[32];
char    bbmsg[2048];
char	str_fmt[32];
extern char bb[],*bbdisp,*bbdisplays;
#ifdef sco3
pid_t child;
#else
int child;
#endif
int	status;

	if( req == NULL ) {
		errmsg("ack","NULL request for bb_doack()");
		return;
	}

	if( strlen(req) == 0 ) {
		errmsg("ack","Empty request for bb_doack()");
		return;
	}

	if( DEBUG ) {
		fprintf(stderr,"Ack request: <%s>\n",req);
		fflush(stderr);
	}

	if( (workreq=calloc(strlen(req)+1024,1)) == NULL ) {
		errmsg("ack","Empty request for bb_doack()");
		return;
	}

	strcpy(workreq,req);
	stripleadtrailspaces(workreq);

	memset(acktype,0,sizeof(acktype));
	sprintf(str_fmt,"%%%ds",sizeof(acktype)-1);
	sscanf(workreq,str_fmt,acktype);

	workptr = strstr(workreq,acktype) + strlen(acktype);
	stripleadspaces(workptr);

	if( strcmp(acktype,"ack_event") == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"Acking event\n");
			fflush(stderr);
		}
		if( strlen(workptr) == 0 ) {
			errmsg("ack:ack_event","ack_event message is missing Ack number and delay");
			goto clean_free;
		}
		memset(acknumber,0,sizeof(acknumber));
		sprintf(str_fmt,"%%%ds",sizeof(acknumber)-1);
		sscanf(workptr,str_fmt,acknumber);
		if( DEBUG ) {
			fprintf(stderr,"Ack number: <%s>\n",acknumber);
			fflush(stderr);
		}
		if( strlen(acknumber) == 0 ) {
			errmsg("ack:ack_event","ack_event message is missing the Ack number");
			goto clean_free;
		}
		acknumber_int = 0;
		acknumber_int = atoi(acknumber);
		if( acknumber_int <= 0 || acknumber_int == 99 ||
			acknumber_int > 9999999 || strlen(acknumber) != 7 ) {
			sprintf(errormsg,"Invalid Ack number <%s>",acknumber);
			errmsg("ack:ack_event",errormsg);
			goto clean_free;
		}

		workptr = strstr(workptr,acknumber) + strlen(acknumber);
		stripleadspaces(workptr);

		if( strlen(workptr) == 0 ) {
			errmsg("ack:ack_event","ack_event message is missing the delay value");
			goto clean_free;
		}

		memset(delay,0,sizeof(delay));
		sprintf(str_fmt,"%%%ds",sizeof(delay)-1);
		sscanf(workptr,str_fmt,delay);

		if( DEBUG ) {
			fprintf(stderr,"Delay <%s>\n",delay);
			fflush(stderr);
		}
		delay_int = calc_offset(delay);
		if( delay_int < 0 ) {
			sprintf(errormsg,"Invalid delay <%s>",delay);
			errmsg("ack:ack_event",errormsg);
			goto clean_free;
		}
		delay_int /= 60;

		/*
		 * Point to message if any
		 */
		workptr = strstr(workptr,delay) + strlen(delay);
		stripleadspaces(workptr);

		message = workptr;
		if( strlen(workptr) != 0 ) {
			replacestr(message,sizeof(message),"+"," ");
		}
		if( DEBUG ) {
			fprintf(stderr,"Message <%s>\n",message);
			fflush(stderr);
		}

		/*
		 * Now go thru the list of pagin tag files
		 * and find out which one is associated with the number
		 * if the ack # ends with 99 then all tagfiles with
		 * the same prefix (without the 99) will be acknowledged
		 */
	
		/*
		 * if the ack # ends with 99 then all tagfiles with
		 * the same prefix (without the 99) will be acknowledged
		 */

		memset(acknum,0,sizeof(acknum));
		rcptid = acknumber_int % 100;
		if( rcptid == 99 ) {
			strncpy(acknum,acknumber,5);
		}
		else {
			strcpy(acknum,acknumber);
		}

		/* Get each np_file file that match tmp/np_* */
		strcpy(filemask,"np_*");
		dirinfo = NULL;
		rc = getdirfirst(&dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
		while( rc == 1 ) {
			if( DEBUG ) {
				fprintf(stderr,"Is acknumber <%s> associated with <%s> ?\n",acknumber,npfilename);
				fflush(stderr);
			}
			/*
			 * Get file contents
			 */
			sprintf(workfilename,"%s/%s",bbtmpdir,npfilename);
			if( stat(workfilename,&statinfo) == 0 ) {
				if( (npfilecontents=calloc(1,statinfo.st_size+1)) != NULL) {
					if( (fp=fopen(workfilename,"r")) != NULL ) {
						if( fread(npfilecontents,statinfo.st_size,1,fp) > 0 ) {
							/*
							 * Is this file related to the acknum ?
							 */
							if( strncmp(npfilecontents,acknum,strlen(acknum)) == 0 ) {
								memset(np_acknumber,0,sizeof(np_acknumber));
								memset(np_host,0,sizeof(np_host));
								memset(np_color,0,sizeof(np_color));
								memset(np_recipient,0,sizeof(np_recipient));
								sprintf(str_fmt,"%%%ds %%%ds %%%ds %%%ds",sizeof(np_acknumber)-1,
														sizeof(np_host)-1,
														sizeof(np_color)-1,
														sizeof(np_recipient)-1);
								sscanf(npfilecontents,str_fmt,np_acknumber,np_host,np_color,np_recipient);
								if( strlen(np_host) == 0 ) {
									strcpy(np_host,"host.not.found.in.tagfile");
								}
								if( strlen(np_color) == 0 ) {
									strcpy(np_color,"color.not.found.in.tagfile");
								}
								if( strlen(np_recipient) == 0 ) {
									strcpy(np_recipient,"recipient.not.found.in.tagfile");
								}
								/*
								 * Adjust for the delay
								 */
								if( DEBUG ) {
									fprintf(stderr,"Ack # <%s> for <%s> delayed for <%s> mins\n",acknumber,np_host,delay);
									fflush(stderr);
								}
								touchtime(workfilename,delay_int);
								convert_web_str(message);
								save_acklog(np_acknumber,delay,acknumber,npfilename,np_host,np_color,message);

								/*
								 * Save an ack tag file to display a different gif
								 */
								timenow = time(NULL);
								sprintf(timenowbuf,"%d",timenow);

								memset(ackfilemsg,0,sizeof(ackfilemsg));
								strncpy(ackfilemsg,np_host,sizeof(ackfilemsg)-1);
								strncat(ackfilemsg," ",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								if( rcptid == 99 ) {
									strncat(ackfilemsg,"global-ack",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								}
								else {
									strncat(ackfilemsg,np_recipient,sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								}
								strncat(ackfilemsg," ",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg,acknumber,sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg," ",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg,delay,sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg," ",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg,timenowbuf,sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg," ",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg,message,sizeof(ackfilemsg)-strlen(ackfilemsg)-1);
								strncat(ackfilemsg,"\n",sizeof(ackfilemsg)-strlen(ackfilemsg)-1);

								/* send addtag_event message here */
								/* To all known BBDISPLAYS ... */
								if ((child = fork()) < 0) bbd_die("fork error");
								if (child == 0) {                       /* THE CHILD */
									/* Build message to send */
									sprintf(bbmsg,"ack addtag_event %s %s ",np_host, delay);
									strncat(bbmsg,ackfilemsg,sizeof(bbmsg)-strlen(bbmsg)-1);
									/* For ZOMBIE prone OSes, use the bb exec instead of bbsend() */
									/* The reason is if bbsend() gets stuck, then the whole bbd */
									/* waits for the child process to end */
#ifdef ZOMBIE
									execlp(bb, bb, bbdisp, bbmsg, (char *)NULL);
#else
									rc = bbsend(bbdisp,bbdisplays,bbmsg);
									exit(rc);
#endif 
								}
								/* Parent continues */
#ifdef ZOMBIE
								wait(&status);
#endif
							}
						}
						else {
							sprintf(errormsg,"The contents of <%s> could not be read",workfilename);
							errmsg("ack:ack_event",errormsg);
						}
						fclose(fp);
					}
					else {
						sprintf(errormsg,"The file <%s> could not be opened",workfilename);
						errmsg("ack:ack_event",errormsg);
					}
					free(npfilecontents);
				}
				else {
					errmsg("ack:ack_event","Could not allocate memory");
				}
			}
			else {
				sprintf(errormsg,"<%s> has suddenly disappeared ...",workfilename);
				errmsg("ack:ack_event",errormsg);
			}
			rc = getdirnext(dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
		}
		getdirdone(dirinfo);
	}
	else if( strcmp(acktype,"rm_event") == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"ack type: <%s>\n",acktype);
			fflush(stderr);
		}
		if( strlen(workptr) == 0 ) {
			errmsg("ack:rm_event","message is missing host.service & event duration");
			goto clean_free;
		}
		memset(hostsvc,0,sizeof(hostsvc));
		sprintf(str_fmt,"%%%ds",sizeof(hostsvc)-1);
		sscanf(workptr,str_fmt,hostsvc);
		if( DEBUG ) {
			fprintf(stderr,"host.service <%s>\n",hostsvc);
			fflush(stderr);
		}
		if( valid_logname(hostsvc) != 1 ) {
			sprintf(errormsg,"Invalid hostname: <%s>\n",hostsvc);
			errmsg("ack:rm_event",errormsg);
			goto clean_free;
		}

		workptr = strstr(workptr,hostsvc) + strlen(hostsvc);
		/* normalize_hostsvc(hostsvc,NORM_LCASE); */
		stripleadspaces(workptr);
		if( strlen(workptr) == 0 ) {
			errmsg("ack:rm_event","message is missing event duration");
			goto clean_free;
		}
		memset(downsecs,0,sizeof(downsecs));
		sprintf(str_fmt,"%%%ds",sizeof(downsecs)-1);
		sscanf(workptr,str_fmt,downsecs);
		if( DEBUG ) {
			fprintf(stderr,"Duration <%s>\n",downsecs);
			fflush(stderr);
		}

		downsecs_int = -1;
		downsecs_int = atoi(downsecs);
		if( downsecs_int < 0) {
			sprintf(errormsg,"Invalid event duration <%s>",downsecs);
			errmsg("ack:rm_event",errormsg);
			goto clean_free;
		}

		workptr = strstr(workptr,downsecs) + strlen(downsecs);
		stripleadspaces(workptr);

		if( strlen(workptr) > 0 ) {
			errmsg("ack:rm_event","Message contains invalid arguments");
			goto clean_free;
		}

		memset(taginfo,0,sizeof(taginfo));
                if( fqdn == 0 ) {
                	strcpy(event,hostsvc);
                        commaptr = strchr(event,',');   
			if( commaptr ) {
				*commaptr = '\0';
				strncpy(taginfo,event,sizeof(taginfo));
				commaptr++;
				dotptr = strrchr(commaptr,'.');
				if( dotptr ) {
					strcat(taginfo,dotptr);
				}
				else {
					/* Error, not supposed to happend */
					/* but just in case */
					sprintf(errormsg,"invalid host.service <%s>\n",hostsvc);
					errmsg("ack:rm_event",errormsg);
					goto clean_free;
				}
			}
			else {
				strcpy(taginfo,hostsvc);
			}
                }
                else {
                        strcpy(taginfo,hostsvc);
			replacestr(taginfo,sizeof(taginfo),",",".");
                }

		getsetup(pagetype,"pagetype", sizeof(pagetype));
		if( strlen(pagetype) == 0 ) {
			errmsg("ack:rm_event","pagetype token is not defined in bbwarnsetup.cfg");
		}
		if( DEBUG ) {
			fprintf(stderr,"pagetype: <%s>\n",pagetype);
			fflush(stderr);
		}
		if( (strcmp(pagetype,"RCPT") != 0) && (strcmp(pagetype,"GROUP") != 0)
			&&  (strcmp(pagetype,"HOST") != 0) &&  (strcmp(pagetype,"EVENT") != 0) ) {
			sprintf(errormsg,"pagetype <%s> is invalid\n",pagetype);
			errmsg("ack:rm_event",errormsg);
		}

		getsetup(pagerecovered,"pagerecovered", sizeof(pagerecovered));
		if( strlen(pagerecovered) == 0 ) {
			errmsg("ack:rm_event","pagerecovered token is not defined in bbwarnsetup.cfg");
		}
		if( DEBUG ) {
			fprintf(stderr,"pagerecovered: <%s>\n",pagerecovered);
			fflush(stderr);
		}
		/*
		 * A recovery msg is to be sent out
		 */
		if( strcmp(pagerecovered,"TRUE") == 0 ) {
			sprintf(request,"%s recovered %s Problem has been resolved after %d seconds",hostsvc,gettimestr(),downsecs_int);
			/*
			 * If not the first one to deal with this
			 * then bb_page() will exit (no need to remove associated np_ files)
			 */
			if( DEBUG ) {
				fprintf(stderr,"bb_page() <%s>\n",request);
				fflush(stderr);
			}
			if( bb_page(request) == 100 ) {
				if( DEBUG ) {
					fprintf(stderr,"bb_page() already doing recovery for <%s>\n",hostsvc);
					fflush(stderr);
				}
				goto clean_free;
			}
		}

		/* send rmtag_event message here */
		/* To all known BBDISPLAYS ... */
		if ((child = fork()) < 0) bbd_die("fork error");
		if (child == 0) {                       /* THE CHILD */
			/* Build message to send */
			sprintf(bbmsg,"ack rmtag_event %.*s",sizeof(bbmsg)-32,taginfo);
			/* For ZOMBIE prone OSes, use the bb exec instead of bbsend() */
			/* The reason is if bbsend() gets stuck, then the whole bbd */
			/* waits for the child process to end */
#ifdef ZOMBIE
			execlp(bb, bb, bbdisp, bbmsg, (char *)NULL);
#else
			rc = bbsend(bbdisp,bbdisplays,bbmsg);
			exit(rc);
#endif 
		}
		/* Parent continues */
#ifdef ZOMBIE
		wait(&status);
#endif

		dotptr = strrchr(taginfo,'.');
		*dotptr = '\0';
		dotptr++;
		save_recoveries(taginfo,dotptr,downsecs_int);
		dotptr--;
		*dotptr = '.';

		/*
		 * Remove associated np_* with recovery
		 * Do only when pagetype == EVENT
		 * Because we know in that case that np_ file is unique
		 * to recovered event
		 */
		if( strcmp(pagetype,"EVENT") == 0 ) {
			/* Get each np_file file that match tmp/np_* */
			if( (rm_npfiles=calloc(rm_npfiles_size,1)) == NULL ) {
				errmsg("ack:ack_event","could not allocate memory for rm_npfiles");
				goto clean_free;
			}
			strcpy(filemask,"np_*");
			dirinfo = NULL;
			rc = getdirfirst(&dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
			while( rc == 1 ) {
				if( DEBUG ) {
					fprintf(stderr,"Is recovery event <%s> associated with <%s> ?\n",taginfo,npfilename);
					fflush(stderr);
				}
				/*
				 * Get file contents
				 */
				sprintf(workfilename,"%s/%s",bbtmpdir,npfilename);
				if( stat(workfilename,&statinfo) == 0 ) {
					if( (npfilecontents=calloc(1,statinfo.st_size+1)) != NULL) {
						if( (fp=fopen(workfilename,"r")) != NULL ) {
							if( fread(npfilecontents,statinfo.st_size,1,fp) > 0 ) {
								/*
								 * Is this file related to the acknum ?
								 */
								fclose(fp);
								if( DEBUG ) {
									fprintf(stderr,"<%s> contents <%s>\n",npfilename,npfilecontents);
									fflush(stderr);
								}
								if( strstr(npfilecontents,taginfo) != NULL ) {
									if( DEBUG ) {
										fprintf(stderr,"<%s> found in <%s>\n",taginfo,npfilecontents);
										fflush(stderr);
									}
									if( (strlen(rm_npfiles)+strlen(workfilename)+1) > rm_npfiles_size ) {
										rm_npfiles_size += sizeof(workfilename)+2;
										if( (rm_npfiles=realloc(rm_npfiles,rm_npfiles_size)) == NULL ) {
											errmsg("ack:ack_event","could not reallocate memory for rm_npfiles");
											goto clean_free;
										}
									}
									strcat(rm_npfiles,workfilename);
									strcat(rm_npfiles," ");
									if( DEBUG ) {
										fprintf(stderr,"rm_npfiles <%s>\n",rm_npfiles);
										fflush(stderr);
									}
								}
								else {
									if( DEBUG ) {
										fprintf(stderr,"<%s> not found in <%s>\n",taginfo,npfilecontents);
										fflush(stderr);
									}
								}
							}
							else {
								sprintf(errormsg,"The contents of <%s> could not be read",workfilename);
								errmsg("ack:rm_event",errormsg);
								fclose(fp);
							}
						}
						else {
							sprintf(errormsg,"The file <%s> could not be opened",workfilename);
							errmsg("ack:rm_event",errormsg);
						}
						free(npfilecontents);
					}
					else {
						errmsg("ack:rm_event","Could not allocate memory");
					}
				}
				else {
					sprintf(errormsg,"<%s> has suddenly disappeared ...",workfilename);
					errmsg("ack:rm_event",errormsg);
				}
				rc = getdirnext(dirinfo,bbtmpdir,filemask,npfilename,GETDIR_FILE,&ftype);
			}
			getdirdone(dirinfo);
			/*
			 * Now remove the matched np_ files
			 */
			stripleadtrailspaces(rm_npfiles);
			workptr = rm_npfiles;
			while( strlen(workptr) > 0 ) {
				memset(workfilename,0,sizeof(workfilename));
				sprintf(str_fmt,"%%%ds",sizeof(workfilename)-1);
				sscanf(workptr,str_fmt,workfilename);
				workptr += strlen(workfilename);
				stripleadspaces(workptr);
				if( DEBUG ) {
					fprintf(stderr,"removing <%s>\n",workfilename);
					fflush(stderr);
				}
				unlink(workfilename);
			}
		}
	}
	else if( strcmp(acktype,"addtag_event") == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"ack type: <%s>\n",acktype);
			fflush(stderr);
		}
		if( strlen(workptr) == 0 ) {
			errmsg("ack:addtag_event","message details are missing");
			goto clean_free;
		}

		/* Create ack file for checkmark display if need be */
		timenow = time(NULL);
		sprintf(timenowbuf,"%d",timenow);

		/* Message should be in the form "host.service delay filecontents" */
		/* Get host.service */
		memset(np_host,0,sizeof(np_host));
		sprintf(str_fmt,"%%%ds",sizeof(np_host)-1);
		sscanf(workptr,str_fmt,np_host);
		workptr = strstr(workptr,np_host);
		workptr += strlen(np_host) + 1;

		/* normalize_hostsvc(np_host,NORM_LCASE); */
		/* Get delay */
		memset(delay,0,sizeof(delay));
		sprintf(str_fmt,"%%%ds",sizeof(delay)-1);
		sscanf(workptr,str_fmt,delay);
		workptr = strstr(workptr,delay);
		workptr += strlen(delay) + 1;
		delay_int = calc_offset(delay);
		delay_int /= 60;

		/* workptr now points to the beginning of the message */
		memset(ackfilename,0,sizeof(ackfilename));
		strncpy(ackfilename,bbacksdir,sizeof(ackfilename)-2);
		strcat(ackfilename,"/ack.");
		strncat(ackfilename,np_host,sizeof(ackfilename)-strlen(ackfilename)-1);
		memset(&ackfilestat,0,sizeof(ackfilestat));
		statres = stat(ackfilename,&ackfilestat);

		/* Multiply delay by 60 */
		/* Thanks to Gerald Werner werner.gerald@marshfieldclinic.org */
		if( statres == -1 || (ackfilestat.st_mtime < (timenow+(delay_int*60))) ) {
			savefile(ackfilename,workptr);
			touchtime(ackfilename,delay_int);
		}
	}
	else if( strcmp(acktype,"rmtag_event") == 0 ) {
		if( DEBUG ) {
			fprintf(stderr,"ack type: <%s>\n",acktype);
			fflush(stderr);
		}
		if( strlen(workptr) == 0 ) {
			errmsg("ack:rmtag_event","message is missing host.service");
			goto clean_free;
		}
		/* Message should be in the form "host.service" */
		memset(hostsvc,0,sizeof(hostsvc));
		sprintf(str_fmt,"%%%ds",sizeof(hostsvc)-1);
		sscanf(workptr,str_fmt,hostsvc);
		if( valid_logname(hostsvc) != 1 ) {
			sprintf(errormsg,"Invalid hostname: <%s>\n",hostsvc);
			errmsg("ack:rmtag_event",errormsg);
			goto clean_free;
		}
		/* normalize_hostsvc(hostsvc,NORM_LCASE); */
		memset(ackfilename,0,sizeof(ackfilename));
		strncpy(ackfilename,bbacksdir,sizeof(ackfilename)-7);
		strcat(ackfilename,"/ack.");
		strncat(ackfilename,hostsvc,sizeof(ackfilename)-strlen(ackfilename)-1);
		unlink(ackfilename);
	}
	else {
		sprintf(errormsg,"Invalid ack type: <%s>\n",acktype);
		errmsg("ack:rm_event",errormsg);
	}

clean_free:

	if( workreq )
		free(workreq);
	if( rm_npfiles )
		free(rm_npfiles);

	return;
}
