/*
 * bbsend.c 
 *
 * CLIENT PROGRAM FUNCTION
 * Sean MacGuire
 *
 * (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
 *
 * FUNCTION THAT SENDS THE INPUT LINE TO THE DAEMON ON THE TCP PORT
 *
 */

#include "bb.h"		/* THE MAIN INCLUDE FILE */
#include <ctype.h>
#include <netdb.h>	/* SMM 1.10 FOR DDNS */


static char *ipaddr;
static int  rc;

#define	BBAGENT	""

#ifdef SIGSETJMP
sigjmp_buf jmpenv; 
#else
jmp_buf jmpenv;
#endif

static void bbsend_timeout()
{
char *errormsg;

	/* +50 for "CONNECTION TO..." */
	if( (errormsg=malloc(strlen(ipaddr)+50)) != NULL ) {
		sprintf(errormsg,"CONNECTION TO %s TIMED OUT...", ipaddr);
		bb_errmsg(NULL,errormsg);
		free(errormsg);
	}
	rc = 1;
	return;
}

int bbsend(machine, machineslist, data)
char *machine;				/* IP ADDRESS */
char *machineslist;			/* LIST OF IP ADDRESSES IF machine = 0.0.0.0 */
char *data;				/* DATA TO SEND ACROSS */
{
 	int n, sockfd, port, newport;
        struct sockaddr_in serv_addr;
	char *machlist,*nextmach,*machlistdone,*portp;
	int  datalen = 0;
	char *errormsg;
	char *outdata = NULL;
	char *portval = NULL;

	struct hostent *ho = 0;		/* SMM 1.10 */
	struct in_addr ip;      /* THE IP ADDRESS WE'RE TESTING */


	rc = 0;

	port = 1984;			/* DEFAULT PORT */

	if( (portval=(char *)getenv("BBPORT")) != NULL ) {
		if( strlen(portval) > 0 ) {
			newport = atoi(portval);
			if( newport > 0 && newport < 65536 ) {
				port = newport;
			}
		}
	}

	/* RAC
	 * Support for multiple BBDISPLAYS/BBPAGERS
	 */
	if( DEBUG ) {
		fprintf(stderr,"BOX: %s\n", machine);
		fprintf(stderr,"BOXES: %s\n", machineslist);
		fflush(stderr);
	}

	/* If machine == 0.0.0.0 then there are more */
	/* than 1 machine, so use machineslist */
	/* process one at a time */
	if ( ! strcmp(machine,"0.0.0.0") ) {
		machlist = machineslist;
	}
	else {
		machlist = machine;
	}

	machlistdone = (char *) calloc(1,strlen(machlist)+1);

	while ( (machlist != NULL) && *machlist ) {

		/* Position to first non-space character */
		while( isspace(*machlist) )
			machlist++;
		/* Are we at end of machlist ? */
		if( !*machlist )
			break;		/* YES */

		machine = machlist;			/* Position at 1st in list */	
		nextmach= (char *) strchr(machlist,' ');/* More than one left in list ? */
		if (nextmach) {				/* Yup */
			*nextmach = '\0';		/* Terminate first one */
			machlist = nextmach + 1;	/* Reposition to next in list */
		}
		else {
			machlist = NULL;		/* No more */
		}

		ipaddr = machine;		/* GLOBAL IP ADDRESS... */

		/* Don't send the same message twice to the same host */
		if( machlistdone ) {
			if( strlen(machlistdone) > 0 ) {
				if(strstr(machlistdone,machlist)) {
					goto nextmach;
				}
			}
		}

		/* Pull out port # from machine if defined:  machine:1985 */
		if( (portp=strchr(machine,':')) != NULL ) {
			*portp = '\0';
			portp++;	/* position at port # */
			newport = atoi(portp);
			if( newport > 0 && newport < 65536 ) {
				port = newport;
			}
		}

		/*
		 * SMM 1.10
		 * TRY TO SUPPORT bb USING A DNS NAME INSTEAD OF IP ADDRESS
		 * FOR MACHINES USING DYNAMIC DNS
		 */
		if((ip.s_addr = inet_addr(machine)) == -1) { /* IS IT IN DOT FMT */
			if (*machine == '\0') {
				if( DEBUG ) {
					fprintf(stderr,"BOX IS LOCAL\n");
					fflush(stderr);
				}
				ho = gethostbyname("localhost");
			}
			else ho = gethostbyname(machine);

			if (ho == (struct hostent *)NULL) {
				/* +25 for "Unknown..." */
				if( (errormsg=malloc(strlen(machine)+25)) != NULL ) {
					sprintf(errormsg,"Unknown host: %s", machine);
					bb_errmsg(NULL,errormsg);
					free(errormsg);
				}
				goto nextmach;	/* NEXT HOST IF ANY */
			}
			/*
			 * IF WE MAKE IT HERE, WE HAVE TO COPY THE HOSTNAME 
			 * INTO THE ADDRESS STRUCTURE
			 */
			memcpy(&ip.s_addr, ho->h_addr, ho->h_length);
		}

		datalen = strlen(data) + strlen(BBAGENT) + 1;
		if( (outdata=(char *)malloc(datalen)) == NULL ) {
			errormsg = "CAN'T ALLOCATE MEMORY IN bbsend()";
			bb_errmsg(NULL,errormsg);
			return(-1);
		}

		strcpy(outdata,BBAGENT);
		strcat(outdata,data);


		bzero((char *) &serv_addr, sizeof(serv_addr));
        	serv_addr.sin_family = AF_INET;
        	serv_addr.sin_addr.s_addr = ip.s_addr;
        	serv_addr.sin_port = htons(port);

		/*
		 * THIS IS A LITTLE NASTY
		 * IF THE SERVER'S NOT UP, THIS WILL WAIT A LONG TIME BEFORE
		 * IT TIMES OUT.  SO HANDLE THAT HERE... IT GETS 3 SECONDS TO ANSWER
		 */
#ifdef SIGSETJMP
	        if (sigsetjmp(jmpenv,1) != 0) {
#else
		if (setjmp(jmpenv) != 0) {
#endif
			if( DEBUG ) {
        	        	fprintf(stderr,"CALLING SETJMP\n");
				fflush(stderr);
			}
        	}
        	signal(SIGALRM, (void *) bbsend_timeout);
        	alarm(5);

        	/* OPEN SOCKET */
        	if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			errormsg = " Can't open stream socket";
			bb_errmsg(NULL,errormsg);
			n = -1;
        	}
        	else if (connect(sockfd, (struct sockaddr *) &serv_addr,
                	        sizeof(serv_addr)) < 0) {
			/* +50 for "CAN'T CONNECT..." */
			if( (errormsg=malloc(strlen(machine)+50)) != NULL ) {
                		sprintf(errormsg,"CAN'T CONNECT TO bbd SERVER @ %s", machine);
				bb_errmsg(NULL,errormsg);
				free(errormsg);
			}
			n = -1;
        	}
		else {
        		n = send(sockfd, outdata, datalen + 1, 0);
		}
		alarm(0);	/* Previous alarm not needed anymore */
		if( DEBUG ) {
			fprintf(stderr,"Send returned: %d\n",n);
			fflush(stderr);
		}
		if( rc == 0 && n < 1 ) {
			rc = 1;
		}
		close(sockfd);

		/* Get next host */
nextmach:

		if ( !machlist ) {
			if( DEBUG ) {
				fprintf(stderr,"Host list done\n");
				fflush(stderr);
			}
			break;
		}
		while ( *machlist && isspace(*machlist) ) {
			machlist++;
		}
		if( DEBUG ) {
			fprintf(stderr,"Next hosts: %s\n",machlist);
			fflush(stderr);
		}
		if( outdata != NULL ) {
			free(outdata);
		}
	}

	if(machlistdone) {
		free(machlistdone);
	}

	if( DEBUG ) {
		fprintf(stderr,"bbsend(): rc = %d\n",rc);
		fflush(stderr);
	}

	if( outdata != NULL ) {
		free(outdata);
	}

	return(rc);
}
