#!/bin/sh

#
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

#
# GENERATE A SIMPLE SYSTEM AVAILABILITY REPORT
# Format ./report "Apr 1 2000" "Apr 10 2000"
#

if [ "$BBHOME" = "" -o ! -d "$BBHOME" ]
then
        echo "BBHOME is not set"
        exit 1
fi

ARGS="$#"

case "$ARGS" in
"2")	# echo "2 args: $1 $2"
	START=`$BBHOME/bin/touchtime -x "$1"`
	END=`$BBHOME/bin/touchtime -x "$2"`
	END=`$EXPR $END + 86399`			# 23:59:59 PM OF THE END DAY...
	;;
"1")	echo "1 args"
	# IF WE ONLY USE ONE ARG TO FROM THEN TO NOW
	echo "ARG1 = $ARG1"
	START=`$BBHOME/bin/touchtime -x "$1"`
	END=`$BBHOME/bin/touchtime -e`		# NOW (MAY BE OFF BY 1 HR DST)
	# echo "START=$START END=$END"
	;;
*)	echo "OTHER"
	START=`$BBHOME/bin/touchtime -x "Jan 1 1990"`
	END=`$BBHOME/bin/touchtime -e`		# NOW (MAY BE OFF BY 1 HR DST)
	# echo "START=$START END=$END"
	;;
esac

# echo "START=$START END=$END"
TOTALTIME=`$EXPR $END - $START`
# echo "TOTAL TIME: $TOTALTIME"

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
         # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

cd $BBLOGS

for file in `$LS | $GREP -v "^summary" | $GREP -v "^dialup"` 
do
	BOX=$file
	echo "Collecting info for $BOX"
	# STATS=`$BBHOME/bin/bb-stat.sh $BOX $START $END`
#
# SMM NEW C VERSION OF STATS PROGRAM...
#
	if [ -r "$BBHIST/$BOX" ]
	then
		STATS=`$BBHOME/bin/bbstat $BOX $START $END`
		# TRY PUTTING ALL THE STATS IN A SINGLE FILE INSTEAD...
		# OF HAVING STAT WRITE A FILE FOR EACH ONE...
		# echo "$BOX $STATS"
		echo "$BOX $STATS" >> $REPDATA
	fi
done

