#!/bin/sh

# mkbb.sh
# SHELL SCRIPT TO MAKE THE NEW DISPLAY
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

OLDIFS=$IFS

#
# IF WE'RE CALLED WITH AN ARGUMENT, WE'RE IN A SUBPAGE
# THE ARGUMENT IS THE BACKGROUND COLOR OF THIS PAGE
# THE USEABLE PORTION OF THE etc/bb-hosts FILE NOW
# LIVES IN $BBTMP
#
if test "$#" -ge "1"
then
	if [ \( "$#" -eq 1 \) -o \( "$2" != "page" -a "$2" != "subpage" \) ]
	then
		echo "mkbb.sh: Called with missing or invalid arguments"
		echo "usage: mkbb.sh <color> <page|subpage>"
		exit 0
	fi
	BBBKG=$1
	# Subpage type: page or subpage
	BBSUBPAGE=$2
	export BBSUBPAGE
	BBHOSTS="$BBTMP/bb-hosts.${BBPAGENAME}.${PARPID}"
	export BBHOSTS
else
	BBSUBPAGE=""
	case "$BBTMP" in
		$BBREP )
			MKBBTYPE="REPORT"
			;;
		* )
			MKBBTYPE="STATIC"
			;;
	esac
	export  MKBBTYPE
	PARPID="$$"
	export PARPID
	ALLCOLS=`${BBHOME}/web/mkbb.cols`	# GET OUR COLUMN HEADINGS
	export ALLCOLS
	set $ALLCOLS >/dev/null 2>&1
	TOTCOL=`$EXPR $# + 1` 
	REALTOTCOL="$#"
	export REALTOTCOL
	export TOTCOL
	REMAINPAGE=0
	export REMAINPAGE
fi

COLMNS="$ALLCOLS"			# THANKS Rob!
export COLMNS

BBDATE=`${DATE}`			# SET THE DATE

BBSKIP2="."

TOP="NOTDONE"


#
# FIND OUT IF WE HAVE ANY OLD DATA FILES LYING AROUND...
# touchtime is a C program that creates a file 30 minutes old
#

if test "$BBSUBPAGE" = "" -a "$MKBBTYPE" != "REPORT"
then
	# NEW WAY - FIND ANY FILES OLDER THAN RIGHT NOW.
	# THE EXPIRATION TIME IS BUILT INTO THE FILE NOW...
	$BBHOME/bin/touchtime 0 ${BBLOGS}/.later	# MAKE THE TOUCH FILE
	sleep 1			# THIS ENSURES THAT ANY NEW STATUS LOG IN THE PROCESS
				# OF BEING CREATED WON'T GENERATE A PURPLE BECAUSE
				# ITS CHANGE TIME HASN'T BEEN SET YET BY bbd
				# THANKS TO John Horne <J.Horne@plymouth.ac.uk>
	# GET RID OF EXPIRED ACKS
	$FIND $BBACKS/. -name "ack.*" -type f ! -newer ${BBLOGS}/.later -exec $RM -f {} \; >/dev/null 2>&1
	# NOW FIND THE EXPIRED STATUS
	# OLD WAY
	#$FIND $BBLOGS/. -name "*.*" -type f ! -name "\.*" ! -newer ${BBLOGS}/.later -print | $GREP -v .later | $GREP -v .bkg > $BBTMP/OLD.$$
	# HUMM, THIS SHOULD REALLY GET RID OF .xxx FILES FROM THE LIST, OR DOES IT ?
	$FIND $BBLOGS/. ! -name "\.*" -type f ! -newer ${BBLOGS}/.later -print | $GREP ".*/[^\.][^/]*\.[^/]*$" > $BBTMP/OLD.$$

	#
	# SMM DEFEND AGAINST MASSIVE PURPLE EXPLOSION
	# FIRST PASS ON BBSTARTUP IS FREE!
	#
	if test -f "$BBLOGS/.bbstartup"
	then
		${RM} -f $BBLOGS/.bbstartup
		> $BBTMP/OLD.$$
	fi

	for file in `${CAT} $BBTMP/OLD.$$`
	do

		set -f			# disable globber
		set `$HEAD -1 $file` >/dev/null 2>&1
		set +f			# reenable globber
		COLOR=$1


		#
		# SMM NEW FOR 1.08b - EVEN PURPLE SENDS MESSAGES VIA bbd
		# IF bbd IS DOWN, THOUGH, REVERT TO THE OLD WAY OF DOING
		# THINGS... THIS WAY THE HISTORY FILE WILL HANDLE PURPLE TOO...
		#
		set `echo $file | $SED "s/\//\ /g"`
		while test "$#" -gt 1		# THE basename COMMAND, IN SHELL...
		do
			shift;
		done
		FNAME=$1
#
# SMM - SUPPORT FOR DIALUPS THAT SEND LOCAL DATA ACROSS
# DIALUPS SHOULD *NEVER* GO PURPLE.
#
		set `echo $FNAME | $SED "s/\./\ /g"`

		PURPLEBOX=`echo $1 | $SED "s/,/\./g"`

		HOSTLINE=`$GREP $PURPLEBOX $BBHOME/etc/bb-hosts`

		if test "$HOSTLINE"
		then
			echo "$HOSTLINE" | $GREP dialup > /dev/null
			if test "$?" != "0"	# NOT A dialup LINE
			then
				${CAT} $file | $SED "s/^${COLOR}/purple/"|$SED "/^Status unchanged/d" | $SED "/${STATUNCHMSG}/d" | $SED "/^Encrypted status message/d" | $SED "/^Status message received from/d" | $SED "/${RECVFROMMSG}/d" >$BBTMP/NEW.$$
			else
				${CAT} $file | $SED "s/^${COLOR}/clear/"| $SED "/^Status unchanged/d" | $SED "/${STATUNCHMSG}/d" | $SED "/^Encrypted status message/d" | $SED "/^Status message received from/d" | $SED "/${RECVFROMMSG}/d" >$BBTMP/NEW.$$
			fi
		else
			${CAT} $file | $SED "s/^${COLOR}/purple/"|$SED "/^Status unchanged/d" | $SED "/${STATUNCHMSG}/d" | $SED "/^Encrypted status message/d" | $SED "/^Status message received from/d" | $SED "/${RECVFROMMSG}/d" >$BBTMP/NEW.$$

		fi

		if [ "$COLOR" != "purple" ]
		then
			if test "$HOSTLINE" = ""
			then
				echo "
$PURPLEBOX $HOSTLINE
This entry is no longer listed in $BBHOME/etc/bb-hosts.  To remove this
purple message, please delete the log files for this host located in
\$BBLOGS, \$BBHIST and \$BBHISTLOGS if this host is no longer monitored
" >> $BBTMP/NEW.$$
			fi
		fi

		# Only send to current BBDISPLAY
		# MACHINEADDR is either the IP address or the host name
		# if the IP in bb-hosts is 0.0.0.0 then it is the host name
		$BB $MACHINEADDR "status+0 $FNAME `${CAT} $BBTMP/NEW.$$`"
		if test $? != 0			# BAD THINGS IN BB LAND...
		then
			$MV $BBTMP/NEW.$$ $file	# THE OLD WAY...
		else
			$RM $BBTMP/NEW.$$
		fi
	
	done
	$RM -f $BBTMP/OLD.$$

	#
	# RAC: NEW IN 1.09b 
	#       IF BBDISPLAY SENDS A SUMMARY MESSAGE TO ITSELF, REMOVE IT
	#	BEFORE THE BACKGROUND COLOR IS CHECKED
	#
	$GREP "^summary" ${BBHOSTS} | \
	while read line
	do
		OLDIFS=$IFS
		IFS=:
		set $BBDISP		# Just get the name/ip of BBDISP, remove port # if any
		IFS=$OLDIFS
		BBDISPVAL=$1

		#set -f
		set $line
		#set +f
		# CHECK AGAINST NAME OR IP ADDRR (BECAUSE BBDISP MIGHT = 0.0.0.0)
		if [ "$3" = "$BBDISPVAL" -o "$3" = "$MACHINE" -o "$3" = "$MACHINEADDR" ]
		then
			$RM -f $BBLOGS/summary.$2
		fi
	done

	# DETERMINE BKG COLOR
	BBBKG=`${BBHOME}/web/mkbb.bkg  2>/dev/null`	# SET THE BACKGROUND COLOR IN ${BBLOGS}/.bkg
	
elif [ "$BBSUBPAGE" = "" ]
then
	case "$MKBBTYPE" in
	REPORT )
		# DETERMINE BKG COLOR
		BBBKG=`${BBHOME}/web/mkbb.bkg 2>/dev/null`	# SET THE BACKGROUND COLOR IN ${BBTMP}/.bkg
		;;
	esac
fi


#
# Thanks to "Alistair K. Birch" <birch@birch.de>
# who reminded me that Explorer needs Height and Width tags!
#
# SMM 1.10 - REMOVED THE PRAGMA BECAUSE IT BREAKS MORE
# THAN IT FIXES.  IT FORCES NETSCAPE 4.5 TO RE-GET EVERY
# LITTLE GIF ON THE PAGE (UGH)... THANKS TO:
# Henrik Olsen <henrik@iaeste.dk>
# <META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\"> 
#

#
# Allow "page" and "subpage" to have their own headers and footers
#
if [ "$BBSUBPAGE" = "page" ]
then
	prename="$BBPAGENAME"
	DISPPAGENAME="$BBPAGENAME"
elif [ "$BBSUBPAGE" = "subpage" ]
then
	prename="${TOPBBPAGENAME}_${BBPAGENAME}"
	DISPPAGENAME="$TOPBBPAGENAME"
	DISPSUBPAGENAME="$BBPAGENAME"
else
	prename="bb"
	DISPPAGENAME=""
	DISPSUBPAGENAME=""
fi

MKBBLOCALCOLSVAL=1
COLSPANVAL=`$EXPR $MKBBLOCALCOLSVAL \* 2`	# Each page has 2 columns: name and color
if [ ${MKBBLOCALCOLS}X != X ]
then
	TMPVAL=`$EXPR ${MKBBLOCALCOLS} + 0`
	if [ ${TMPVAL}X != X -a ${TMPVAL} -gt 0 ]
	then
		MKBBLOCALCOLSVAL=$TMPVAL
		COLSPANVAL=`$EXPR ${MKBBLOCALCOLSVAL} \* 2`
	fi
fi

if [ "$MKBBTYPE" != "REPORT" ]
then
	headfile="$BBHOME/web/${prename}_header"
	if [ ! -r "$headfile" -o ! -s "$headfile" ]
	then
		if [ "$BBSUBPAGE" = "subpage" ]
		then
			# If "subpage" and not found, reset to <page>_header
			headfile="$BBHOME/web/${TOPBBPAGENAME}_header"
			if [ ! -r "$headfile" -o ! -s "$headfile" ]
			then
				#if that's not found then reset to bb_header
				headfile="$BBHOME/web/bb_header"
			fi
		else
			# If anything else and not found, reset to bb_header
			headfile="$BBHOME/web/bb_header"
		fi
	fi

	if [ -r "$headfile" -a -s "$headfile" ]
	then
		$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
			-e "s/&BBREL/$BBREL/g" \
			-e "s/&BBDATE/$BBDATE/g" \
			-e "s!&BBSKIN!$BBSKIN!g" \
			-e "s!&PAGENAME!$DISPPAGENAME!g" \
			-e "s!&SUBPAGENAME!$DISPSUBPAGENAME!g" \
			-e "s!&BBWEB!$BBWEB!g" \
			-e "s!&CGIBINURL!$CGIBINURL!g" \
			-e "s/&BBBACKGROUND/$BBBKG/g" $headfile

		echo "
<CENTER>
"
	else
		# Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
		echo "<HTML><BODY>
<HR size=4>
<BR>$headfile is either missing or invalid, please create this file with your custom header<BR>
<HR size=4>
"
	fi
else
	headfile="$BBHOME/web/${prename}rep_header"
	if [ ! -r "$headfile" -o ! -s "$headfile" ]
	then
		if [ "$BBSUBPAGE" = "subpage" ]
		then
			# If "subpage" and not found, reset to <page>rep_header
			headfile="$BBHOME/web/${TOPBBPAGENAME}rep_header"
			if [ ! -r "$headfile" -o ! -s "$headfile" ]
			then
				#if that's not found then reset to bbrep_header
				headfile="$BBHOME/web/bbrep_header"
			fi
		else
			# If anything else and not found, reset to bbrep_header
			headfile="$BBHOME/web/bbrep_header"
		fi
	fi

	# WE'RE IN REPORTING
	if [ -r "$headfile" -a -s "$headfile" ]
	then    
		$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
			-e "s/&BBREL/$BBREL/g" \
			-e "s/&BBDATE/$RANGE/g" \
			-e "s!&PAGENAME!$DISPPAGENAME!g" \
			-e "s!&SUBPAGENAME!$DISPSUBPAGENAME!g" \
			-e "s!&BBWEB!$BBWEB!g" \
			-e "s!&BBSKIN!$BBSKIN!g" \
			-e "s!&CGIBINURL!$CGIBINURL!g" \
			-e "s/&BBBACKGROUND/$BBBKG/g" $headfile

		echo "
<CENTER>
" 
	else
		# Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
		echo "<HTML><BODY>
<HR size=4>
<BR>$headfile is either missing or invalid, please create this file with your custom header<BR>
<HR size=4>
"
	fi
fi

echo "
<A NAME=begindata>&nbsp;</A>
<A NAME=hosts-blk>&nbsp;</A>
"

TAGLINES="";export TAGLINES

$TOUCH $BBTMP/BBEMPTYPAGE.$$

#
# FOR EACH HOST WE CARE ABOUT...
#
# echo "****  BBHOSTS IS $BBHOSTS"

while read line
do

	TAGLINES="${TAGLINES}."
	case "${TAGLINES}" in
		"$BBSKIP2" )
			:
			;;
		* )
			continue
			;;
	esac
	#if test "$TAGLINES" != "$BBSKIP2"
	#then
	#	continue
	#fi

	# Also update BBSKIP2, we're doing another line
	# in may also be updated in the page case statement
	BBSKIP2="${BBSKIP2}."

	# FIX THIS LINE SOONER OR LATER - THE > /dev/null BREAKS ON
	# DEC ULTRIX.  GREAT EH? STILL VALID ???
	set bogus $line >/dev/null 2>&1
	shift

	#
	# Handle the different directives of the bb-hosts file
	#
	case "$1"
	in
		[0-9]* )
			# BETTER BE AN IP ADDR :)

			echo "${line} " | $GREP "[# 	]nodisp[ 	]" > /dev/null
			if [ $? -eq 0 ]     # Don't display this host
			then
				continue
			fi

			$RM -f $BBTMP/BBEMPTYPAGE.$$	# At least one host is in current page

			#
			# SMM 1.06a
			# WE MAY NOT HAVE A group DIRECTIVE THAT CREATED
			# THE TABLE.  HANDLE IT HERE.
			#
			case "$TOP" in
			NOTDONE )
				OUT="<TABLE SUMMARY=\"Host Line\" BORDER=0><TR><TD></TD>"
				for column in $COLMNS
				do
                	        	OUT="${OUT}<TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=45>"
					if [ -f "$BBHOME/www/help/${column}.html" ]
					then
                        	        	OUT="${OUT}
<A HREF=\"$BBWEB/help/${column}.html\">"
					elif [ -f "$BBHOME/www/notes/${column}.html" ]
					then
                        	        	OUT="${OUT}
<A HREF=\"$BBWEB/notes/${column}.html\">"
					else
                        	        	OUT="${OUT}
<A HREF=\"$BBWEB/help/bb-help.html#${column}\">"
                        		fi
					OUT="${OUT}
<FONT $MKBBCOLFONT><B>$column</B></FONT></A></TD>"
				done
				TOP="DONE"
				echo "${OUT}</TR>"
				;;
			esac
			;;

		page | subpage )
			#
			# SMM 1.10 SUPPORT FOR MULTIPLE DISPLAY PAGES
			# FORMAT page NAME
			#

			# THE ONLY WAY OUT OF A SUBPAGE IS EOF
			# THE mkbb.page SCRIPT ENSURES THIS.
			PAGETYPE="$1"
			export PAGETYPE
			if [ \( "$BBSUBPAGE" = "" -a "$PAGETYPE" = "page" \) -o \( "$BBSUBPAGE" = "page" -a "$PAGETYPE" = "subpage" \) ]
			then
				OUT=""
				BBPAGENAME=`echo "$2" | $SED -e 's/^.*\/\([^\/]*$\)/\1/g' -e 's/\.\.//g'`
				export BBPAGENAME
				if [ "$PAGETYPE" = "page" ]
				then
					TOPBBPAGENAME="$BBPAGENAME"
					export TOPBBPAGENAME
				fi
				shift;shift;
				BBHOSTLINE=`$EXPR "$TAGLINES" : ".*"`
				BK=`$BBHOME/web/mkbb.page $BBHOSTLINE` # 2>/dev/null`

				if test "$NAME" != ""		# CLOSE OFF TABLE
				then
					if [ "$REMAINPAGE" -ne 0 ]
					then
						OUT="${OUT}
	</TR>"
					fi
					OUT="${OUT}
</TABLE><BR><BR>"
					NAME=""
				fi

				#
				# IF THIS IS OUR FIRST PAGE OR SUBPAGE, MAKE THE TABLE
				#
				if [ \( "$PAGETYPE" = "page" -a  "$FIRSTPG" = "" \) -o \( "$PAGETYPE" = "subpage" -a  "$FIRSTSUBPG" = "" \) ]
				then
					$RM -f $BBTMP/BBEMPTYPAGE.$$	# At least one entry is in current page
					if [ "$PAGETYPE" = "page" ]
					then
						FIRSTPG="DONE"
						export FIRSTPG
						MKBBLOCALVAL="$MKBBLOCAL"
					else
						FIRSTSUBPG="DONE"
						export FIRSTSUBPG
						MKBBLOCALVAL="$MKBBSUBLOCAL"
					fi
					NUMPAGE=0
					MAXPAGE=`$EXPR $MKBBLOCALCOLSVAL - 1`
					OUT="${OUT}
<A NAME=\"pages-blk\">&nbsp;</A>
<TABLE SUMMARY=\"Page Block\" BORDER=0>
<TR><TD COLSPAN=$COLSPANVAL><CENTER><FONT $MKBBTITLE>$MKBBLOCALVAL</FONT></CENTER></TD></TR>
<TR><TD COLSPAN=$COLSPANVAL><HR WIDTH=100%></TD></TR>"
				fi
				if [ "$PAGETYPE" = "page" ]
				then
					BBPAGEDIR="$TOPBBPAGENAME"
				else
					# IT'S A SUBPAGE
					BBPAGEDIR="$TOPBBPAGENAME/$BBPAGENAME"
				fi
				if [ "$MKBBTYPE" = "STATIC" ]
				then
					if [ ! -d "$BBHOME/www/$BBPAGEDIR" ]
					then
						mkdir "$BBHOME/www/$BBPAGEDIR"
					fi
					PGNAME="$BBPAGEDIR/$BBPAGENAME"
					BBWEBLOC="$BBWEB"
				else
					if [ ! -d "$BBREP/$BBPAGEDIR" ]
					then
						mkdir "$BBREP/$BBPAGEDIR"
					fi
					# ALWAYS RESET THE PERMS ON DIRECTORY BECAUSE AFTER AN UPGRADE
					# THE PERMS WILL NEED TO BE RESET IF DIRECTORY ALREADY EXISTS
					chmod g+w "$BBREP/$BBPAGEDIR"
					PGNAME="$BBPAGEDIR/$BBPAGENAME-$$"
					BBWEBLOC="$BBREPURL"
				fi
				REMAINPAGE=`$EXPR $NUMPAGE % $MKBBLOCALCOLSVAL`
				if [ $REMAINPAGE -eq 0 ]
				then
					OUT="${OUT}
<TR>"
				fi

				OUT="${OUT}
<TD><FONT $MKBBROWFONT>$*</FONT></TD>
<TD><CENTER><A HREF=\"$BBWEBLOC/$PGNAME.html\"><IMG SRC=\"$BBSKIN/$BK.gif\" WIDTH=\"$DOTWIDTH\" HEIGHT=\"$DOTHEIGHT\" BORDER=0 ALT=\"$BK\"></A></CENTER></TD>"

				OLDTAGLINES=$TAGLINES
				unset TAGLINES

				NUMPAGE=`$EXPR $NUMPAGE + 1`
				REMAINPAGE=`$EXPR $NUMPAGE % $MKBBLOCALCOLSVAL`
				if [ $REMAINPAGE -eq 0 ]
				then
					OUT="${OUT}
</TR>"
				fi

				echo "${OUT}"

				$BBHOME/web/mkbb.sh $BK $PAGETYPE > $BBTMP/$BBPAGENAME.$$
				if [ "$MKBBTYPE" = "STATIC" ]
				then
					$MV $BBTMP/$BBPAGENAME.$$ $BBHOME/www/$BBPAGEDIR/$BBPAGENAME.html
				else
					$MV $BBTMP/$BBPAGENAME.$$ $BBTMP/$BBPAGEDIR/$BBPAGENAME-$$.html
				fi

				TAGLINES=$OLDTAGLINES

				BBSKIP2="${TAGLINES}`$CAT $BBTMP/BBSKIP2.${BBPAGENAME}.${PARPID}`"

				$RM -f $BBTMP/bb-hosts.${BBPAGENAME}.${PARPID}
				$RM -f $BBTMP/BBSKIP2.${BBPAGENAME}.${PARPID}

				BBPAGENAME=""

				continue
			fi
			;;

		group-compress | group-only | group )
			#
			# SMM 1.06a SUPPORT FOR GROUPING THINGS TOGETHER
			# IF THE LINE STARTS WITH THE WORD group THEN
			# A NEW TABLE IS CREATED WITH THE REST OF THE LINE
			# AS THE CENTERED LABEL, i.e.
			# group Web and Mail Servers
			#
			# SMM 1.08 SUPPORT FOR COMPRESSED GROUPINGS
			# IF THERE IS ONLY ONE COLUMN IN THE GROUP, DISPLAY THEM
			# ACROSS THE SCREEN, OTHERWISE JUST ELIMINATE UNNEEDED COLUMNS
			#
			# RAC 1.4f SUPPORT FOR LIMITING COLUMNS
			# IF A LINE STARTS WITH THE WORD group  THEN
			# ONLY THE COLUMNS APPEARING IN THE DIRECTIVES
			# WILL BE SHOWN. THIS DIRECTIVE IS VALID UNTIL
			# THE NEXT group/group-compress/group-only/page DIRECTIVE
			#
			case $1
			in
				group-compress )
					# COMPRESS COLUMNS
					BBHOSTLINE=`$EXPR "$TAGLINES" : ".*"`
					COLMNS=`${BBHOME}/web/mkbb.cols $BBHOSTLINE`
					shift				# GET RID OF group-compress
					OLDARGS=$*
					set bogus $COLMNS >/dev/null 2>&1
					# bogus IS THERE TO COUNT THE HOSTNAME COLUMN
					TOTCOLS="$#"
					shift
					XCOLS="$#"		# REAL NUMBER OF COLS
					set bogus $OLDARGS
					shift
					;;

				group-only )
					# ONLY DISPLAY REQUESTED COLUMNS
					# bogus IS THERE TO COUNT FOR THE HOSTNAME COLUMN
					columns="bogus|$2"
					shift;shift		# GET RID OF group-only + columns
					OLDARGS=$*
					IFS='|'
					set $columns >/dev/null 2>&1
					IFS=$OLDIFS
					TOTCOLS="$#"
					shift			# REMOVE THE bogus column
					XCOLS="$#"		# REAL NUMBER OF COLS
					COLMNS="$*"
					# RESET THE TITLE 
					set bogus $OLDARGS
					shift
					;;

				* )
					# DISPLAY ALL COLUMNS
					COLMNS="$ALLCOLS"
					TOTCOLS="$TOTCOL"
					XCOLS="$REALTOTCOL"	# REAL NUMBER OF COLS
					shift;			# GET RID OF group
					;;
			esac

			OUT=""

			if test "$NAME" != ""		# CLOSE OFF TABLE
			then
				OUT="${OUT}
</TABLE><BR><BR>"
			fi
			OUT="${OUT}
<TABLE SUMMARY=\"Group Block\" BORDER=0><TR><TD VALIGN=MIDDLE ROWSPAN=2 CELLPADDING=2>
<CENTER><FONT $MKBBTITLE>$*</FONT></CENTER></TD>"

			for column in $COLMNS		# REDISPLAY HEADERS
			do
                	        OUT="${OUT}<TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=45>"
				if [ -f "$BBHOME/www/help/${column}.html" ]
				then
                       	        	OUT="${OUT}
<A HREF=\"$BBWEB/help/${column}.html\">"
				elif [ -f "$BBHOME/www/notes/${column}.html" ]
				then
                                	OUT="${OUT}
<A HREF=\"$BBWEB/notes/${column}.html\">"
				else
                       	        	OUT="${OUT}
<A HREF=\"$BBWEB/help/bb-help.html#${column}\">"
                       		fi

				OUT="${OUT}
<FONT $MKBBCOLFONT><B>$column</B></FONT></A></TD>"
			done
			TOP="DONE"
			echo "${OUT}
</TR>
<TR><TD COLSPAN=$XCOLS><HR WIDTH=100%></TD></TR>"
			continue;
			;;


		* )
			continue
			;;
	esac

	#
	# NEW FOR 1.04 - SUPPORT FOR FQDN's
	# NOT CENTERED...
	#
	OUT=""
	FNAME="$2"
	IFS='.'
	set $FNAME
	IFS=$OLDIFS
	NAME=$1
	case "$FQDN" in
		TRUE )
			OUT="${OUT}
<TR><TD NOWRAP>"
			shift
			for arg in $*
			do
				NAME="$NAME,$arg"
			done
			;;
		* )
			OUT="${OUT}
<TR><TD ALIGN=CENTER NOWRAP>"
			FNAME=$NAME
			;;
	esac

	export NAME
	export FNAME

	DISPFONT="<FONT $MKBBROWFONT>"

	#
	# PUT A LINK IN FOR SYSTEM NOTES IF WE HAVE ANY
	# THIS IS A GOOD PLACE TO PUT INVENTORY INFO
	# SMM NEW IN 1.05: SUPPORT FOR .html and .htm EXTENSIONS
	# DON'T ASK FOR UPPERCASE EXTENSIONS.  EVER.
	#
	# Thanks to Luke Moses <Luke_Moses@adc.com> who 
	# made us remember to add .shtml/.php3
	# Added check for directory with host name
	OUT="${OUT}
<A NAME=\"${FNAME}\">&nbsp;</A>"
	NOTESFILES=`echo ${BBNOTES}/${FNAME}*`
	if [ "$NOTESFILES" != "${BBNOTES}/${FNAME}*" ]
	then
		if test -f "${BBNOTES}/${FNAME}.html"
		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.html>${DISPFONT}$FNAME</FONT></A></TD>"
		elif test -f "${BBNOTES}/${FNAME}.htm"
		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.htm>${DISPFONT}$FNAME</FONT></A></TD>"
		elif test -d "${BBNOTES}/${FNAME}"
       		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/$FNAME>${DISPFONT}$FNAME</FONT></A></TD>"
		elif test -f "${BBNOTES}/${FNAME}"
       		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/$FNAME>${DISPFONT}$FNAME</FONT></A></TD>"
		elif test -f "${BBNOTES}/${FNAME}.shtml"
		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.shtml>$FNAME</FONT></A></TD>"
		elif test -f "${BBNOTES}/${FNAME}.php3"
		then
			OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.php3>${DISPFONT}$FNAME</FONT></A></TD>"
		else
			# just in case we had red.html but the hostname was really redhat
			# and no matching files were found.
			OUT="${OUT}
${DISPFONT}$FNAME</FONT></TD>"
		fi
	else
		OUT="${OUT}
${DISPFONT}$FNAME</FONT></TD>"
	fi

	#
	# FOR EACH OF THE THINGS WE MONITOR...
	#


	case "$MKBBTYPE" in
	DYNAMIC|STATIC )


		for column in $COLMNS
		do
			echo "${line} " | $GREP "[# 	]nodisp[^ 	]*:${column}[: 	]" > /dev/null
			# If log exists and nodisp not defined for this column
			if [ -f "${BBLOGS}/${NAME}.${column}" -a $? -ne 0 ]
			then
				ACKNAME="${BBACKS}/ack.${FNAME}.${column}"
				if [ -f "${ACKNAME}" ]
				then
					ACKED="TRUE"
				else
					ACKED="FALSE"
				fi
				set -f
				set `$HEAD -1 ${BBLOGS}/${NAME}.${column}` >/dev/null 2>&1
				set +f
				if [ "$ACKED" = "TRUE" ] && [ "$1" = "red" -o "$1" = "yellow" -o "$1" = "purple" ]
				then
					DOTCOLOR="$1-ack"
					ALTTAG=":acked"
				else
					DOTCOLOR="$1"
					ALTTAG=""
				fi

				case "$BBLOGSTATUS" in
				DYNAMIC )

					OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$CGIBINURL/bb-hostsvc.sh?HOSTSVC=${NAME}.${column}\">
<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\" ALT=\"${column}:$1$ALTTAG\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
					;;

				* )
					if [ "$BBLOGSTATUS" = "STATIC" -a -d "$BBHOME/www/html" ]
					then
						OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$BBWEB/html/${FNAME}.${column}.html\">
<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\" ALT=\"${column}:$1$ALTTAG\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
					else
						OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$BBWEB/logs/${NAME}.${column}\">
<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\" ALT=\"${column}:$1$ALTTAG\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
					fi
					;;
				esac

			else
				OUT="${OUT}
<TD ALIGN=CENTER>-</TD>"
			fi
		done
		;;

	REPORT )
		# WE'RE IN REPORTING MODE
		for column in $COLMNS
		do
			# 
			# SMM USE A TEMP FILE INSTEAD
			#
			REP=`$GREP "^${NAME}.${column}[  ]*" $REPDATA`
  
			if test "$REP"
			then
				set -f
				set $REP >/dev/null 2>&1
				set +f
				shift          # GET RID OF NAME...
				COLOR="$1"
				PCT="$2"
				shift;shift;
				OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$CGIBINURL/bb-replog.sh?HOSTSVC=${NAME}.${column}&COLOR=${COLOR}&PCT=${PCT}&ST=$1&END=$2&RED=$3&YEL=$4&GRE=$5&PUR=$6&CLE=$7&BLU=$8&STYLE=$STYLE&FSTATE=${9}"
				# SMM ADD IN THE INCIDENT COUNTS...
				shift;shift;shift;
				shift;shift;shift;
				shift;shift;shift;
				OUT="${OUT}&REDCNT=$1&YELCNT=$2&GRECNT=$3&PURCNT=$4&CLECNT=$5&BLUCNT=$6\">"
				if test "$PCT" = "100.00"               # WAS 1000
				then
					OUT="${OUT}
<IMG SRC=\"$BBSKIN/$COLOR.gif\" ALT=\"100% available\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
				else
					# PERCENT=`echo $PCT | $AWK '{ print $1 * .1}'`
					PERCENT=$PCT
					OUT="${OUT}
<FONT SIZE=-1 COLOR=$COLOR><B>$PERCENT</B></FONT></A></TD>"
				fi
			else
				OUT="${OUT}
<TD ALIGN=CENTER>-</TD>"
			fi
		done
		;;
	esac

	echo "${OUT}
</TR>"

done < $BBHOSTS

echo "</TABLE><BR><BR>"				# END OF TABLE

# Content of variable is empty if a least one host
# is defined in the page
if [ -f $BBTMP/BBEMPTYPAGE.$$ ]
then
	echo $MKBBEMPTYPAGE
	$RM -f $BBTMP/BBEMPTYPAGE.$$
fi

#
# CLOSE OFF TABLE
#
if test "$FIRSTPG" != ""
then
	: #echo "</TABLE>"  # not required any, well, I think ;)
fi

#
# SMM NEW IN 1.05 - SUPPORT FOR DISPLAY OF SUMMARY INFORMATION
#
if test "$BBSUBPAGE" = "" -a "$MKBBTYPE" != "REPORT"
then
	#
	# SMM: NEW IN 1.05 - SUPPORT FOR SENDING SUMMARY INFORMATION UPSTREAM
	# bb-hosts LINES OF THE FORMAT:
	#
	#	summary row.column	IP-ADDRESS-OF-PARENT	http://bb4.com/
	#	summary quebec.montreal	123.123.123.123 http://bb4.com/bb/
	$GREP "^summary" ${BBHOSTS} | \
	while read line
	do
		#set -f
		set $line
		#set +f
		BBNAME=$2
		BBSUMMARY=$3
		BBHTTP=$4

		# echo "DOING $BBNAME $BBHTTP"
		#
		# IF BBHTTP ENDS IN .html, THEN ASSUME IT'S A LOCAL PAGE
		# AND GET BBBKG FROM HERE (LOCALLY).
		#
		unset PGBKG
		LOCALPG=`echo "$BBHTTP" | $GREP "\.html"`
		if test "$LOCALPG"
		then
			# echo "LOCALPG IS $LOCALPG"
			#set `echo $LOCALPG | $SED 's!\/!\ !g'`

			# Get the structure below the top level of BB
			set bogus `echo $LOCALPG | $SED "s!${BBWEB}/! !g"`
			shift	# remove bogus
			shift	# Remove the http:// heading

			#while test "$#" -gt "1"
			#do
			#	shift;		# SKIP TO THE LAST ARG...
			#done
			# THE ONLY TIME THIS IS INVALID IS FOR OURSELF
			# SINCE WE HAVEN'T CREATED bb.html/index.html YET!
			# THIS MEANS IT WOULD TAKE AN EXTRA ITERATION
			# FOR THE bb.html AKA index.html TO BE SUMMARIZED
			# CORRECTLY...
			if test "$1" != "bb.html" && test "$1" != "index.html"
			then
				PGBKG=`$GREP TITLE $BBHOME/www/$1 | $HEAD -1`
				if test "$PGBKG"
				then
					set $PGBKG
					PGBKG=`echo $1 | $SED 's/<TITLE>//g'`
				fi
			fi
		fi

		if test "$PGBKG"
		then
		$BB $BBSUMMARY "summary summary.${BBNAME} $PGBKG $BBHTTP $BBDATE"
		else
		$BB $BBSUMMARY "summary summary.${BBNAME} $BBBKG $BBHTTP $BBDATE"
		fi

	done

	echo "<A NAME=\"summaries-blk\">&nbsp;</A>"
	cd ${BBLOGS}
	sumfiles=`$LS summary* 2> /dev/null| $SORT`
	cd ${BBHOME}
	if [ -n "$sumfiles" ]
	then
		# echo "**** $sumfiles ****"
		for line in $sumfiles
		do
			if test "$BBSUMHDR" != "TRUE"
			then
				BBSUMHDR="TRUE"
				echo "<TABLE SUMMARY=\"Summary Block\" BORDER=0><TR><TD>
<CENTER><FONT $MKBBTITLE>
$MKBBREMOTE
</FONT></CENTER></TD></TR><TR><TD>
<HR WIDTH=100%></TD></TR>
<TR><TD><TABLE SUMMARY=\"Summary Lines\" BORDER=0>"
			fi

			IFS='.'
			set $line >/dev/null 2>&1
			IFS=$OLDIFS
			ROW=$2
			COL=$3

			#
			# SMM 1.4 - 13 Jan 00
			# IF THE SUMMARY FILE ISN'T IN summary.row.col
			# FORMAT THEN JUST IGNORE IT.
			#
			if test ! -f "${BBLOGS}/summary.${ROW}.${COL}"
			then
				continue;
			fi

			#
			# HANDLE THE ROW DISPLAY 
			#
			if test "$ROW" != "$LASTROW"		# WE HAVE A NEW ROW...
			then
				if test "$LASTROW" != ""
				then
					echo "</TR>"
				fi

				#
				# SMM: NEW IN 1.06a
				# SUPPORT FOR NOTES IN THE SUMMARY LINES
				# VIA: David Fordyce <fordyce@ite1.dseg.ti.com>
				#

				echo "<A NAME=\"${ROW}\">&nbsp;</A>"
				echo "<TR><TD>"
				DISPFONT="<FONT $MKBBROWFONT>"
			
				NOTESFILES=`echo ${BBNOTES}/${ROW}* 2>/dev/null`
				if [ "$NOTESFILES" != "${BBNOTES}/${ROW}*" ]
				then
					if test -f "${BBNOTES}/${ROW}.html"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.html>${DISPFONT}$ROW</FONT></A></TD>"
					elif test -f "${BBNOTES}/${ROW}.htm"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.htm>${DISPFONT}$ROW</FONT></A></TD>"
					elif test -d "${BBNOTES}/${ROW}"
        				then
						echo "<A HREF=$BBWEB/notes/$ROW>${DISPFONT}$ROW</FONT></A></TD>"
					elif test -f "${BBNOTES}/${ROW}"
        				then
						echo "<A HREF=$BBWEB/notes/$ROW>${DISPFONT}$ROW</FONT></A></TD>"
					elif test -f "${BBNOTES}/${ROW}.shtml"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.shtml>${DISPFONT}$ROW</FONT></A></TD>"
					elif test -f "${BBNOTES}/${ROW}.php3"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.php3>${DISPFONT}$ROW</FONT></A></TD>"
					else
						# just in case we had red.html but the hostname was really redhat
						# and no matching files were found.
						echo "${DISPFONT}$ROW</FONT></TD>"
					fi
				else
					echo "${DISPFONT}$ROW</FONT></TD>"
				fi

				LASTROW="$ROW"
			fi
			#
			# HANDLE THE COLUMN DISPLAY
			#
			echo "<TD WIDTH=45 ALIGN=CENTER>$COL<BR>"	# COLUMN TITLE
			#set -f
			set `$CAT ${BBLOGS}/summary.${ROW}.${COL}` >/dev/null 2>&1
			#set +f
			echo "<A HREF=$2><IMG SRC=\"$BBSKIN/$1.gif\" ALT=\"$1\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
		done
		echo "</TR></TABLE>
</TD></TR></TABLE>"
	fi

	#
	# SMM NEW IN 1.05 - SUPPORT FOR MONITORING MODEM BANKS
	#
	echo "<A NAME=\"dialups-blk\">&nbsp;</A>"
	echo "<P><TABLE SUMMARY=\"Dialup Block\" BORDER=0>"
	$GREP "^dialup" ${BBHOSTS} | \
	while read line
	do
		#set -f
		set $line
		#set +f
	
		FNAME=$2
		#
		# PUT IN A LINK...
		#
		# Make a new row
		OUT="<TR><TD><A NAME=\"${FNAME}\">&nbsp;</A>"
		DISPFONT="<FONT $MKBBROWFONT>"
		NOTESFILES=`echo ${BBNOTES}/${FNAME}* 2>/dev/null`
		if [ "$NOTESFILES" != "${BBNOTES}/${FNAME}*" ]
		then
			if test -f "${BBNOTES}/${FNAME}.html"
			then
				OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.html>${DISPFONT}$FNAME</FONT></A></TD>"
			elif test -f "${BBNOTES}/${FNAME}.htm"
			then
				OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.htm>${DISPFONT}$FNAME</FONT></A></TD>"
			elif test -d "${BBNOTES}/${FNAME}"
        		then
				OUT="${OUT}
<A HREF=$BBWEB/notes/$FNAME>${DISPFONT}$FNAME</FONT></A></TD>"
			elif test -f "${BBNOTES}/${FNAME}"
        		then
				OUT="${OUT}
<A HREF=$BBWEB/notes/$FNAME>${DISPFONT}$FNAME</FONT></A></TD>"
			elif test -f "${BBNOTES}/${FNAME}.shtml"
			then
				OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.shtml>$FNAME</FONT></A></TD>"
			elif test -f "${BBNOTES}/${FNAME}.php3"
			then
				OUT="${OUT}
<A HREF=$BBWEB/notes/${FNAME}.php3>${DISPFONT}$FNAME</FONT></A></TD>"
			else
				# just in case we had red.html but the hostname was really redhat
				# and no matching files were found.
				OUT="${OUT}
${DISPFONT}$FNAME</FONT></TD>"
			fi
		else
			OUT="${OUT}
${DISPFONT}$FNAME</FONT></TD>"
		fi
	
		if [ -f "$BBLOGS/dialup.${FNAME}" ]
		then
			set -f
			set `$CAT $BBLOGS/dialup.${FNAME}` >/dev/null 2>&1
			set +f
			while test "$1" != "DATA" -a "$#" != 0
			do
				shift;
			done
			if [  "$#" != 0 ]
			then
				shift;		# GO PAST THE DATA LINE
			fi
			#
			# NOW MAKE NICE PICTURES
			#
			while test "$1" != "Status" -a  "$#" != 0	# SMM 1.08b - STOP AT Status
			do
				if [ "$BBLOGSTATUS" = "DYNAMIC" ]
				then
					OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$CGIBINURL/bb-hostsvc.sh?HOSTSVC=dialup.${FNAME}\">
<IMG SRC=\"$BBSKIN/$1.gif\" ALT=$1 HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A>
</TD>"
				else
					if [ -d "$BBHOME/www/html" -a "$BBLOGSTATUS" = "STATIC" ]
					then
						OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$BBWEB/html/dialup.${FNAME}.html\">
<IMG SRC=\"$BBSKIN/$1.gif\" ALT=$1 HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A>
</TD>"
					else
						OUT="${OUT}
<TD ALIGN=CENTER><A HREF=\"$BBWEB/logs/dialup.${FNAME}\">
<IMG SRC=\"$BBSKIN/$1.gif\" ALT=$1 HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A>
</TD>"
					fi
				fi
				shift;
			done
			OUT="${OUT}
</TR>"
		fi
		echo "${OUT}"
	done
	echo "</TABLE>"
fi

#
# EXECUTE LOCAL SCRIPTS FROM HERE...
# SCRIPTS SHOULD LIVE IN $BBHOME/ext/mkbb DIRECTORY
# BBMKBBEXT CONTAINS THE FILENAMES TO EXECUTE
#       

BBMKBBEXT=`echo "$BBMKBBEXT" | $SED 's!\.\./!\./!g'`
for file in $BBMKBBEXT
do
	if [ -x "$BBHOME/ext/mkbb/$file" ]
	then
		$BBHOME/ext/mkbb/$file
	else  
		echo "<BR><B>mkbb.sh: $BBHOME/ext/mkbb/$file can't be executed</B><BR>"
	fi
done

echo "
</CENTER>
"
    
#
# SMM NEW IN 1.04 - STANDARD FOOTER
#
# prename was set in _footer handling
#
if [ "$MKBBTYPE" != "REPORT" ]
then
	footfile="$BBHOME/web/${prename}_footer"
	if [ ! -r "$footfile" -o ! -s "$footfile" ]
	then
		if [ "$BBSUBPAGE" = "subpage" ]
		then
			# If "subpage" and not found, reset to <page>_footer
			footfile="$BBHOME/web/${TOPBBPAGENAME}_footer"
			if [ ! -r "$footfile" -o ! -s "$footfile" ]
			then
				#if that's not found then reset to bb_footer
				footfile="$BBHOME/web/bb_footer"
			fi
		else
			# If anything else and not found, reset to bb_footer
			footfile="$BBHOME/web/bb_footer"
		fi
	fi

	if [ -r "$footfile" -a -s "$footfile" ]
	then
		$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
			-e "s/&BBREL/$BBREL/g" \
			-e "s/&BBDATE/$BBDATE/g" \
			-e "s!&BBSKIN!$BBSKIN!g" \
			-e "s!&PAGENAME!$DISPPAGENAME!g" \
			-e "s!&SUBPAGENAME!$DISPSUBPAGENAME!g" \
			-e "s!&BBWEB!$BBWEB!g" \
			-e "s!&CGIBINURL!$CGIBINURL!g" \
			-e "s/&BBBACKGROUND/$BBBKG/g" $footfile
	else
		# Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
		echo "<HR size=4><BR>
$footfile was not found, please create this file with your custom footer<BR><HR size=4>
</BODY></HTML>
"
	fi
else
	footfile="$BBHOME/web/${prename}rep_footer"
	if [ ! -r "$footfile" -o ! -s "$footfile" ]
	then
		if [ "$BBSUBPAGE" = "subpage" ]
		then
			# If "subpage" and not found, reset to <page>rep_footer
			footfile="$BBHOME/web/${TOPBBPAGENAME}rep__footer"
			if [ ! -r "$footfile" -o ! -s "$footfile" ]
			then
				#if that's not found then reset to bbrep_footer
				footfile="$BBHOME/web/bbrep_footer"
			fi
		else
			# If anything else and not found, reset to bbrep_footer
			footfile="$BBHOME/web/bbrep_footer"
		fi
	fi


	if [ -r "$footfile" -a -s "$footfile" ]
	then
		$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
			-e "s/&BBREL/$BBREL/g" \
			-e "s/&BBREPWARN/$BBREPWARN/g" \
			-e "s/&BBDATE/$BBDATE/g" \
			-e "s!&BBSKIN!$BBSKIN!g" \
			-e "s!&PAGENAME!$DISPPAGENAME!g" \
			-e "s!&SUBPAGENAME!$DISPSUBPAGENAME!g" \
			-e "s!&BBWEB!$BBWEB!g" \
			-e "s!&CGIBINURL!$CGIBINURL!g" \
			-e "s/&BBBACKGROUND/$BBBKG/g" $footfile
	else
		# Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
		echo "<HR size=4><BR>
$footfile was not found, please create this file with your custom footer<BR><HR size=4>
</BODY></HTML>
" 
	fi
fi

exit 0
