#!/bin/sh

# mkbb2.sh
# SCRIPT TO MAKE THE SUMMARY WEB PAGE
# Sean MacGuire
#
# (c) Copyright Quest Software, Inc.  1997-2003  All rights reserved.
#

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

OLDIFS=$IFS

BBDATE=`${DATE}`				# SET THE DATE
BBBKG=`${BBHOME}/web/mkbb.bkg 2>/dev/null`	# SET THE BACKGROUND COLOR

if [ -r "$BBHOME/web/bb2_header" -a -s "$BBHOME/web/bb2_header" ]
then
	$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
		-e "s/&BBREL/$BBREL/g" \
       		-e "s/&BBDATE/$BBDATE/g" \
       		-e "s!&BBSKIN!$BBSKIN!g" \
       		-e "s!&BBWEB!$BBWEB!g" \
		-e "s!&CGIBINURL!$CGIBINURL!g" \
		-e "s/&BBBACKGROUND/$BBBKG/g" $BBHOME/web/bb2_header
	echo "
<CENTER>
"
else
        # Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
        echo "<HTML><BODY>
<HR size=4>
<BR>$BBHOME/web/bb2_header is either missing or invalid, please create this file with your custom header<BR>
<HR size=4>
"       
fi

echo "  
<A NAME=begindata>&nbsp;</A>
<A NAME=\"hosts-blk\">&nbsp;</A>
" 

if test -s $BBTMP/BB
then

	#
	# SMM - NEW FOR 1.08
	# DISPLAY ONLY NON-GREEN COLUMNS
	#
	COLMNS=`${BBHOME}/web/mkbb.cols 0` 	# GET OUR COLUMN HEADINGS 

	if test "$COLMNS"			# ONLY DO THIS IF WE HAVE TO
	then
		echo "<TABLE SUMMARY=\"Error Block\" BORDER=0><TR><TD COLSPAN=2 ALIGN=CENTER></TD>"

		COLNUM='.'

		for col in $COLMNS
		do
        		echo "<TD ALIGN=CENTER WIDTH=45>"
			if [ -f "$BBHOME/www/help/${col}.html" ]
			then
				echo "<A HREF=\"$BBWEB/help/${col}.html\">"
			elif [ -f "$BBHOME/www/notes/${col}.html" ]
			then
				echo "<A HREF=\"$BBWEB/notes/${col}.html\">"
			else
				echo "<A HREF=\"$BBWEB/help/bb-help.html#${col}\">"
			fi

			echo "<FONT $MKBBCOLFONT><B>$col</B></FONT></A></TD>"
			COLNUM="${COLNUM}."
		done
		COLNUM=`$EXPR "$COLNUM" : ".*"`
		echo "</TR>
<TR><TD></TD><TD></TD><TD COLSPAN=$COLNUM><HR></TD></TR>"

		#
		# FOR EACH UNIQUE HOST WE CARE ABOUT
		# EXCEPT THE SUMMARY FILES...
		#
		$GREP -v "summary" $BBTMP/BB | $SORT |
		while read line
		do
			IFS='/'
			set $line
			IFS=$OLDIFS
			shift `$EXPR $# - 1`		# GET TO LAST ARG
			IFS='.'
			set $1
			IFS=$OLDIFS
			case "$NAME" in
			$1 )
				continue;		# ALREADY DEALT WITH THIS
				;;
			* )
				NAME=$1			# IT'S A NEW ONE...
				;;
			esac
		
			case "$FQDN" in
			TRUE )
				IFS=','
				set $NAME
				IFS=$OLDIFS
				FNAME=$1
				shift
				for arg in $*
				do
					FNAME="$FNAME.$arg"
					shift
				done
				echo "<TR><TD COLSPAN=2 NOWRAP>"
				;;
			* )
				FNAME=$NAME
				echo "<TR><TD COLSPAN=2 ALIGN=CENTER NOWRAP>"
			esac

			echo "<A NAME=\"${FNAME}\">"
			echo "<FONT $MKBBROWFONT>"

			#
			# ADD HOOK FOR CUSTOM FILES HERE
			#
			# Thanks to Luke Moses <Luke_Moses@adc.com> who 
			# made us remember to add .shtml/.php3  

       			NOTESFILES=`echo ${BBNOTES}/${FNAME}* 2>/dev/null`
		        if [ "$NOTESFILES" != "${BBNOTES}/${FNAME}*" ]
		        then
				if test -f "${BBNOTES}/${FNAME}.html"
        			then
					echo "<A HREF=$BBWEB/notes/${FNAME}.html>$FNAME</A></FONT></TD>"
        			elif test -f "${BBNOTES}/${FNAME}.htm"
        			then
					echo "<A HREF=$BBWEB/notes/${FNAME}.htm>$FNAME</A></FONT></TD>"
				elif test -d "${BBNOTES}/${FNAME}"
				then
					echo "<A HREF=$BBWEB/notes/$FNAME>$FNAME</A></FONT></TD>"
				elif test -f "${BBNOTES}/${FNAME}"
				then
					echo "<A HREF=$BBWEB/notes/$FNAME>$FNAME</A></FONT></TD>"
				elif test -f "${BBNOTES}/${FNAME}.shtml"            
				then
					echo "<A HREF=$BBWEB/notes/${FNAME}.shtml>$FNAME</A></FONT></TD>"
				elif test -f "${BBNOTES}/${FNAME}.php3"
				then
					echo "<A HREF=$BBWEB/notes/${FNAME}.php3>$FNAME</A></FONT></TD>"
				else    
					# just in case we had red.html but the hostname was really redhat
					# and no matching files were found.
					echo "$FNAME</FONT></TD>"
				fi
        		else
				echo "$FNAME</FONT></TD>"
        		fi
		
			#
			# FOR EACH OF THE THINGS WE MONITOR...
			#
			for col in $COLMNS
			do
				#FILE=`echo ${BBLOGS}/$NAME.$col* 2>/dev/null`
				#set $FILE
				set bogus ${BBLOGS}/$NAME.$col* >/dev/null 2>&1
				shift
				FILE="$1"
				case "$FILE" in
				${BBLOGS}/$NAME.$col )
					ACKNAME="${BBACKS}/ack.${FNAME}.${col}"
					if [ -f "${ACKNAME}" ]
					then
						ACKED="TRUE"
					else 
						ACKED="FALSE"
					fi
					set -f
					set `${HEAD} -1 ${BBLOGS}/$NAME.$col` >/dev/null 2>&1
					set +f
					if [ "$ACKED" = "TRUE" ] && [ "$1" = "red" -o "$1" = "yellow" -o "$1" = "purple" ]
					then
						DOTCOLOR="$1-ack"
						ALTTAG=":acked"
					else
						DOTCOLOR="$1"
						ALTTAG=""
					fi
					case "$BBLOGSTATUS" in
					DYNAMIC )
						echo "<TD ALIGN=CENTER>
							<A HREF=\"$CGIBINURL/bb-hostsvc.sh?HOSTSVC=${NAME}.${col}\">
							<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\"  ALT=\"${col}:$1$ALTAG\"
							HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
						;;
					* )
						if [ -d "$BBHOME/www/html" -a "$BBLOGSTATUS" = "STATIC" ]
						then
							echo "<TD ALIGN=CENTER>
								<A HREF=\"$BBWEB/html/${FNAME}.${col}.html\">
								<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\"  ALT=\"${col}:$1$ALTTAG\"
								HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
						else
							echo "<TD ALIGN=CENTER>
								<A HREF=\"$BBWEB/logs/$NAME.${col}\">
								<IMG SRC=\"$BBSKIN/$DOTCOLOR.gif\"  ALT=\"${col}:$1$ALTTAG\"
								HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
						fi
						;;
					esac
					;;
				* )
					echo "<TD ALIGN=CENTER>-</TD>"
					;;
			esac
			done
			echo "</TR>"
		done
		#
		# Ruediger Schuetz (Ruediger.Schuetz@Munich.Netsurf.DE)
		# Fixed bad table ending....
		#
		echo "</TABLE>"

	fi
	#
	# NOW HANDLE SUMMARY INFO
	#

	cd ${BBLOGS}
	sumfiles=`$LS summary* 2> /dev/null| $SORT`          
	cd ${BBHOME}
	echo "<A NAME=\"summaries-blk\">"
	if [ -n "$sumfiles" ]
	then
		echo "<BR><BR>"
		# echo "**** $sumfiles ****"
		for line in $sumfiles
		do
			if test "$BBSUMHDR" != "TRUE"
			then
				BBSUMHDR="TRUE"
				echo "<TABLE SUMMARY=\"Summary Block\" BORDER=0>
<TR><TD><TABLE SUMMARY=\"Summary Lines\" BORDER=0>"
			fi
			set -f
			set `echo $line | $SED "s/\./ /g"` >/dev/null 2>&1
			set +f
			ROW=$2
			COL=$3

			#
			# SMM 1.4 - 13 Jan 00
			# IF THE SUMMARY FILE ISN'T IN summary.row.col
			# FORMAT THEN JUST IGNORE IT.
			#
			if test ! -f "${BBLOGS}/summary.${ROW}.${COL}"
			then
				continue;
			fi

			#
			# HANDLE THE ROW DISPLAY 
			#
			if test "$ROW" != "$LASTROW"		# WE HAVE A NEW ROW...
			then
				if test "$LASTROW" != ""
				then
					echo "</TR>"
				fi

				#
				# SMM: NEW IN 1.06a
				# SUPPORT FOR NOTES IN THE SUMMARY LINES
				# VIA: David Fordyce <fordyce@ite1.dseg.ti.com>
				#
				echo "<TR><TD>
<FONT $MKBBROWFONT>"
	
       				NOTESFILES=`echo ${BBNOTES}/${ROW}* 2>/dev/null`
		        	if [ "$NOTESFILES" != "${BBNOTES}/${ROW}*" ]
		        	then
					if test -f "${BBNOTES}/${ROW}.html"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.html>$ROW</A></FONT></TD>"
					elif test -f "${BBNOTES}/${ROW}.htm"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.htm>$ROW</A></FONT></TD>"
					elif test -d "${BBNOTES}/${ROW}"
        				then
						echo "<A HREF=$BBWEB/notes/$ROW>$ROW</A></FONT></TD>"
					elif test -f "${BBNOTES}/${ROW}"
        				then
						echo "<A HREF=$BBWEB/notes/$ROW>$ROW</A></FONT></TD>"
					elif test -f "${BBNOTES}/${FNAME}.shtml"            
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.shtml>$ROW</A></FONT></TD>"
					elif test -f "${BBNOTES}/${ROW}.php3"
					then
						echo "<A HREF=$BBWEB/notes/${ROW}.php3>$ROW</A></FONT></TD>"
					else    
						# just in case we had red.html but the hostname was really redhat
						# and no matching files were found.
						echo "$ROW</FONT></TD>"
					fi
				else
					echo "$ROW</FONT></TD>"
				fi

				LASTROW="$ROW"
			fi
			#
			# HANDLE THE COLUMN DISPLAY
			#
			echo "<TD WIDTH=45 ALIGN=CENTER>$COL<BR>"	# COLUMN TITLE
			set -f
			set `${CAT} ${BBLOGS}/summary.${ROW}.${COL}` >/dev/null 2>&1
			set +f
			echo "<A HREF=$2><IMG SRC=\"$BBSKIN/$1.gif\" ALT=\"$1\" HEIGHT=\"$DOTHEIGHT\" WIDTH=\"$DOTWIDTH\" BORDER=0></A></TD>"
		done
		echo "</TR></TABLE>
</TD></TR></TABLE>"
	fi
else
	echo "<FONT SIZE=+2 FACE=\"Arial, Helvetica\"><BR><BR><I>All Monitored Systems OK</I></FONT><BR><BR>"
fi

#
# EXECUTE LOCAL SCRIPTS FROM HERE... 
# SCRIPTS SHOULD LIVE IN $BBHOME/ext/mkbb DIRECTORY
# BBMKBB2EXT CONTAINS THE FILENAMES TO EXECUTE 
#
BBMKBB2EXT=`echo "$BBMKBB2EXT" | $SED 's!\.\./!\./!g'`
for file in $BBMKBB2EXT
do      
        if [ -x "$BBHOME/ext/mkbb/$file" ]
        then
                $BBHOME/ext/mkbb/$file
        else
                echo "<BR><B>mkbb2.sh: $BBHOME/ext/mkbb/$file can't be executed</B><BR>"   
        fi
done    
 
echo "
</CENTER>
"

#
# SMM NEW IN 1.04 - STANDARD FOOTER
#
if [ -r "$BBHOME/web/bb2_footer" -a -s "$BBHOME/web/bb2_footer" ]
then     
	$SED -e "s/&BBRELDATE/$BBRELDATE/g" \
		-e "s/&BBREL/$BBREL/g" \
		-e "s/&BBDATE/$BBDATE/g" \
		-e "s!&BBSKIN!$BBSKIN!g" \
		-e "s!&BBWEB!$BBWEB!g" \
		-e "s!&CGIBINURL!$CGIBINURL!g" \
		-e "s/&BBBACKGROUND/$BBBKG/g" $BBHOME/web/bb2_footer
else
        # Print proper error message, thanks to Mark Deiss <mcd@crexm.acs-gsg.com>
        echo "<HR size=4><BR>
$BBHOME/web/bb2_footer was not found, please create this file with your custom footer<BR><HR size=4>
</BODY></HTML>"
fi

exit 0
