# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.
"""Catalog of known worker tags and worker tag prefixes."""

from debusine.utils.tag_utils import ProvenanceRestrictions

#: Tags provided in dynamic worker metadata when a worker registers as active
PROVENANCE_WORKER = "worker"
#: Tags provided in static worker metadata by the Debusine admins
PROVENANCE_ADMIN = "admin"
#: Tags from database queries
PROVENANCE_SYSTEM = "system"

#: Prefix for worker build architecture
BUILD_ARCH_PREFIX = "worker:build-arch:"

#: Prefix for worker capability tags
CAP_PREFIX = "worker:cap:"

#: Prefix and tags for worker type tags
WORKER_TYPE_PREFIX = "worker:type:"
WORKER_TYPE_CELERY = WORKER_TYPE_PREFIX + "celery"
WORKER_TYPE_EXTERNAL = WORKER_TYPE_PREFIX + "external"
WORKER_TYPE_SIGNING = WORKER_TYPE_PREFIX + "signing"
WORKER_TYPE_NOT_ASSIGNABLE = WORKER_TYPE_PREFIX + "not-assignable"

#: Prefix for worker executor tags
EXECUTOR_PREFIX = "worker:executor:"

#: Prefix for worker task availability tags
TASK_PREFIX = "worker:task:"

#: Restrictions applied when adding provided tags
restrictions_when_provided = ProvenanceRestrictions("worker-provided")
# There are no restrictions required for the set of tags currently in use

#: Restrictions applied when adding required tags
# Use empty restrictions, since adding required tags is not a security
# sensitive operation, but removing them is
restrictions_when_required = ProvenanceRestrictions("worker-required")
