"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os2UnicodeRangeStat = void 0;
const interface_1 = require("./interface");
///////////////////////////////////////////////////////////////////////////////////////////////////
class Os2UnicodeRangeStat extends interface_1.EmptyStat {
    constructor(os2, external) {
        super(external);
        this.os2 = os2;
        this.mask = [0, 0, 0, 0];
    }
    addEncoding(u) {
        super.addEncoding(u);
        const fm = ensureFastMasks();
        this.mask[0] |= fm[0][u] || 0;
        this.mask[1] |= fm[1][u] || 0;
        this.mask[2] |= fm[2][u] || 0;
        this.mask[3] |= fm[3][u] || 0;
    }
    settle() {
        super.settle();
        this.os2.ulUnicodeRange1 = this.mask[0];
        this.os2.ulUnicodeRange2 = this.mask[1];
        this.os2.ulUnicodeRange3 = this.mask[2];
        this.os2.ulUnicodeRange4 = this.mask[3];
    }
}
exports.Os2UnicodeRangeStat = Os2UnicodeRangeStat;
///////////////////////////////////////////////////////////////////////////////////////////////////
const UnicodeRanges = [
    [0, 0, 0x0000, 0x007f],
    [0, 1, 0x0080, 0x00ff],
    [0, 2, 0x0100, 0x017f],
    [0, 3, 0x0180, 0x024f],
    [0, 4, 0x0250, 0x02af],
    [0, 4, 0x1d00, 0x1d7f],
    [0, 4, 0x1d80, 0x1dbf],
    [0, 5, 0x02b0, 0x02ff],
    [0, 5, 0xa700, 0xa71f],
    [0, 6, 0x0300, 0x036f],
    [0, 6, 0x1dc0, 0x1dff],
    [0, 7, 0x0370, 0x03ff],
    [0, 8, 0x2c80, 0x2cff],
    [0, 9, 0x0400, 0x04ff],
    [0, 9, 0x0500, 0x052f],
    [0, 9, 0x2de0, 0x2dff],
    [0, 9, 0xa640, 0xa69f],
    [0, 10, 0x0530, 0x058f],
    [0, 11, 0x0590, 0x05ff],
    [0, 12, 0xa500, 0xa63f],
    [0, 13, 0x0600, 0x06ff],
    [0, 13, 0x0750, 0x077f],
    [0, 14, 0x07c0, 0x07ff],
    [0, 15, 0x0900, 0x097f],
    [0, 16, 0x0980, 0x09ff],
    [0, 17, 0x0a00, 0x0a7f],
    [0, 18, 0x0a80, 0x0aff],
    [0, 19, 0x0b00, 0x0b7f],
    [0, 20, 0x0b80, 0x0bff],
    [0, 21, 0x0c00, 0x0c7f],
    [0, 22, 0x0c80, 0x0cff],
    [0, 23, 0x0d00, 0x0d7f],
    [0, 24, 0x0e00, 0x0e7f],
    [0, 25, 0x0e80, 0x0eff],
    [0, 26, 0x10a0, 0x10ff],
    [0, 26, 0x2d00, 0x2d2f],
    [0, 27, 0x1b00, 0x1b7f],
    [0, 28, 0x1100, 0x11ff],
    [0, 29, 0x1e00, 0x1eff],
    [0, 29, 0x2c60, 0x2c7f],
    [0, 29, 0xa720, 0xa7ff],
    [0, 30, 0x1f00, 0x1fff],
    [0, 31, 0x2000, 0x206f],
    [0, 31, 0x2e00, 0x2e7f],
    [1, 0, 0x2070, 0x209f],
    [1, 1, 0x20a0, 0x20cf],
    [1, 2, 0x20d0, 0x20ff],
    [1, 3, 0x2100, 0x214f],
    [1, 4, 0x2150, 0x218f],
    [1, 5, 0x2190, 0x21ff],
    [1, 5, 0x27f0, 0x27ff],
    [1, 5, 0x2900, 0x297f],
    [1, 5, 0x2b00, 0x2bff],
    [1, 6, 0x2200, 0x22ff],
    [1, 6, 0x2a00, 0x2aff],
    [1, 6, 0x27c0, 0x27ef],
    [1, 6, 0x2980, 0x29ff],
    [1, 7, 0x2300, 0x23ff],
    [1, 8, 0x2400, 0x243f],
    [1, 9, 0x2440, 0x245f],
    [1, 10, 0x2460, 0x24ff],
    [1, 11, 0x2500, 0x257f],
    [1, 12, 0x2580, 0x259f],
    [1, 13, 0x25a0, 0x25ff],
    [1, 14, 0x2600, 0x26ff],
    [1, 15, 0x2700, 0x27bf],
    [1, 16, 0x3000, 0x303f],
    [1, 17, 0x3040, 0x309f],
    [1, 18, 0x30a0, 0x30ff],
    [1, 18, 0x31f0, 0x31ff],
    [1, 19, 0x3100, 0x312f],
    [1, 19, 0x31a0, 0x31bf],
    [1, 20, 0x3130, 0x318f],
    [1, 21, 0xa840, 0xa87f],
    [1, 22, 0x3200, 0x32ff],
    [1, 23, 0x3300, 0x33ff],
    [1, 24, 0xac00, 0xd7af],
    [1, 25, 0xd800, 0xdfff],
    [1, 26, 0x10900, 0x1091f],
    [1, 27, 0x4e00, 0x9fff],
    [1, 27, 0x2e80, 0x2eff],
    [1, 27, 0x2f00, 0x2fdf],
    [1, 27, 0x2ff0, 0x2fff],
    [1, 27, 0x3400, 0x4dbf],
    [1, 27, 0x20000, 0x2a6df],
    [1, 27, 0x3190, 0x319f],
    [1, 28, 0xe000, 0xf8ff],
    [1, 29, 0x31c0, 0x31ef],
    [1, 29, 0xf900, 0xfaff],
    [1, 29, 0x2f800, 0x2fa1f],
    [1, 30, 0xfb00, 0xfb4f],
    [1, 31, 0xfb50, 0xfdff],
    [2, 0, 0xfe20, 0xfe2f],
    [2, 1, 0xfe10, 0xfe1f],
    [2, 1, 0xfe30, 0xfe4f],
    [2, 2, 0xfe50, 0xfe6f],
    [2, 3, 0xfe70, 0xfeff],
    [2, 4, 0xff00, 0xffef],
    [2, 5, 0xfff0, 0xffff],
    [2, 6, 0x0f00, 0x0fff],
    [2, 7, 0x0700, 0x074f],
    [2, 8, 0x0780, 0x07bf],
    [2, 9, 0x0d80, 0x0dff],
    [2, 10, 0x1000, 0x109f],
    [2, 11, 0x1200, 0x137f],
    [2, 11, 0x1380, 0x139f],
    [2, 11, 0x2d80, 0x2ddf],
    [2, 12, 0x13a0, 0x13ff],
    [2, 13, 0x1400, 0x167f],
    [2, 14, 0x1680, 0x169f],
    [2, 15, 0x16a0, 0x16ff],
    [2, 16, 0x1780, 0x17ff],
    [2, 16, 0x19e0, 0x19ff],
    [2, 17, 0x1800, 0x18af],
    [2, 18, 0x2800, 0x28ff],
    [2, 19, 0xa000, 0xa48f],
    [2, 19, 0xa490, 0xa4cf],
    [2, 20, 0x1700, 0x171f],
    [2, 20, 0x1720, 0x173f],
    [2, 20, 0x1740, 0x175f],
    [2, 20, 0x1760, 0x177f],
    [2, 21, 0x10300, 0x1032f],
    [2, 22, 0x10330, 0x1034f],
    [2, 23, 0x10400, 0x1044f],
    [2, 24, 0x1d000, 0x1d0ff],
    [2, 24, 0x1d100, 0x1d1ff],
    [2, 24, 0x1d200, 0x1d24f],
    [2, 25, 0x1d400, 0x1d7ff],
    [2, 26, 0xf0000, 0xffffd],
    [2, 26, 0x100000, 0x10fffd],
    [2, 27, 0xfe00, 0xfe0f],
    [2, 27, 0xe0100, 0xe01ef],
    [2, 28, 0xe0000, 0xe007f],
    [2, 29, 0x1900, 0x194f],
    [2, 30, 0x1950, 0x197f],
    [2, 31, 0x1980, 0x19df],
    [3, 0, 0x1a00, 0x1a1f],
    [3, 1, 0x2c00, 0x2c5f],
    [3, 2, 0x2d30, 0x2d7f],
    [3, 3, 0x4dc0, 0x4dff],
    [3, 4, 0xa800, 0xa82f],
    [3, 5, 0x10000, 0x1007f],
    [3, 5, 0x10080, 0x100ff],
    [3, 5, 0x10100, 0x1013f],
    [3, 6, 0x10140, 0x1018f],
    [3, 7, 0x10380, 0x1039f],
    [3, 8, 0x103a0, 0x103df],
    [3, 9, 0x10450, 0x1047f],
    [3, 10, 0x10480, 0x104af],
    [3, 11, 0x10800, 0x1083f],
    [3, 12, 0x10a00, 0x10a5f],
    [3, 13, 0x1d300, 0x1d35f],
    [3, 14, 0x12000, 0x123ff],
    [3, 14, 0x12400, 0x1247f],
    [3, 15, 0x1d360, 0x1d37f],
    [3, 16, 0x1b80, 0x1bbf],
    [3, 17, 0x1c00, 0x1c4f],
    [3, 18, 0x1c50, 0x1c7f],
    [3, 19, 0xa880, 0xa8df],
    [3, 20, 0xa900, 0xa92f],
    [3, 21, 0xa930, 0xa95f],
    [3, 22, 0xaa00, 0xaa5f],
    [3, 23, 0x10190, 0x101cf],
    [3, 24, 0x101d0, 0x101ff],
    [3, 25, 0x102a0, 0x102df],
    [3, 25, 0x10280, 0x1029f],
    [3, 25, 0x10920, 0x1093f],
    [3, 26, 0x1f030, 0x1f09f],
    [3, 26, 0x1f000, 0x1f02f] // Mahjong Tiles
];
let FastMasks = null;
function ensureFastMasks() {
    if (FastMasks)
        return FastMasks;
    const masks = [[], [], [], []];
    for (const [item, bit, start, end] of UnicodeRanges) {
        for (let u = start; u <= end; u++) {
            const a = masks[item];
            a[u] = (1 << bit) | (a[u] || 0);
        }
    }
    FastMasks = masks;
    return masks;
}
//# sourceMappingURL=os2-unicode-range.js.map