"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MirKeyProvider = void 0;
const mir_1 = require("../../mir");
exports.MirKeyProvider = {
    getIrKey(ir) {
        switch (ir.type) {
            case mir_1.MirType.Nop:
                return `Z`;
            case mir_1.MirType.Operand:
                return `N[${ir.arg}]`;
            case mir_1.MirType.Operator: {
                let s = `O[${ir.opCode}`;
                if (ir.flags)
                    for (const x of ir.flags)
                        s += `,${x}`;
                s += "]";
                return s;
            }
            case mir_1.MirType.NonTerminal:
                return `I[${ir.id}]`;
        }
    },
    isBarrier(ir) {
        return ir.type === mir_1.MirType.Nop;
    }
};
//# sourceMappingURL=ir-key-provider.js.map