"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtGhFlattener = void 0;
class OtGhFlattener {
    constructor() {
        this.contours = [];
        this.lastContour = [];
    }
    getResult() {
        return this.contours;
    }
    beginContour() {
        this.lastContour = [];
    }
    endContour() {
        if (this.lastContour.length)
            this.contours.push(this.lastContour);
    }
    addControlKnot(knot) {
        this.lastContour.push(knot);
    }
}
exports.OtGhFlattener = OtGhFlattener;
//# sourceMappingURL=flattener.js.map