/*
 * fspy - Linux filesystem activity monitor
 *
 * Copyright (C) 2007  Richard Sammet (e-axe) <richard.sammet@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <stdio.h>
#include <string.h>

#include "fsevents.h"

char *get_event_desc(int event, char *ptr)
{

	char desc[128]= {0};

	switch(event) {
	case FSPY_IN_ACCESS:        /* file content was read */
		sprintf(desc, "READ");
		break;
	case FSPY_IN_MODIFY:        /* file content was written */
		sprintf(desc, "WRITE");
		break;
	case FSPY_IN_ATTRIB:        /* file metadata changed (permissions, timestamps, etc.) */
		sprintf(desc, "ATTRIB");
		break;
	case FSPY_IN_CLOSE_WRITE:   /* file opened for writing was closed */
		sprintf(desc, "CLOSE_W");
		break;
	case FSPY_IN_CLOSE_NOWRITE: /* file opened read-only was closed */
		sprintf(desc, "CLOSE_R");
		break;
	case FSPY_IN_OPEN:          /* file was opened */
		sprintf(desc, "OPEN");
		break;
	case FSPY_IN_MOVED_FROM:    /* file was moved out of watched directory */
		sprintf(desc, "MOVE_FR");
		break;
	case FSPY_IN_MOVED_TO:      /* file was moved into watched directory */
		sprintf(desc, "MOVE_TO");
		break;
	case FSPY_IN_CREATE:        /* file was created in watched directory */
		sprintf(desc, "CREATE");
		break;
	case FSPY_IN_DELETE:        /* file was deleted from watched directory */
		sprintf(desc, "DELETE");
		break;
	case FSPY_IN_DELETE_SELF:   /* watched file/directory itself was deleted */
		sprintf(desc, "DEL_SLF");
		break;
	case FSPY_IN_MOVE_SELF:     /* watched file/directory itself was moved */
		sprintf(desc, "MOV_SLF");
		break;
	case FSPY_IN_UNMOUNT:       /* filesystem containing watched file was unmounted */
		sprintf(desc, "UNMOUNT");
		break;
	case FSPY_IN_Q_OVERFLOW:    /* event queue overflowed (events may be lost) */
		sprintf(desc, "Q_OVRFL");
		break;
	case FSPY_IN_IGNORED:       /* watch was removed (explicitly or automatically) */
		sprintf(desc, "IGNORED");
		break;
	case FSPY_IN_DIR_CREATE:    /* subdirectory was created */
		sprintf(desc, "MKDIR");
		break;
	case FSPY_IN_DIR_ATTRIB:    /* directory metadata changed */
		sprintf(desc, "DATTRIB");
		break;
	case FSPY_IN_DIR_ACCESS_1:  /* directory was accessed (close after read-only open) */
		sprintf(desc, "DREAD");
		break;
	case FSPY_IN_DIR_ACCESS_2:  /* directory was accessed (opened) */
		sprintf(desc, "DREAD");
		break;
	case FSPY_IN_DIR_DELETE:    /* subdirectory was deleted */
		sprintf(desc, "RMDIR");
		break;
	default :
		sprintf(desc, "UNK:%x", event);
	}

	return memcpy(ptr, desc, strlen(desc));
}
