// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists test run test cases.
func (c *Client) ListTestRunTestCases(ctx context.Context, params *ListTestRunTestCasesInput, optFns ...func(*Options)) (*ListTestRunTestCasesOutput, error) {
	if params == nil {
		params = &ListTestRunTestCasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestRunTestCases", params, optFns, c.addOperationListTestRunTestCasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestRunTestCasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestRunTestCasesInput struct {

	// The test run ID of the test cases.
	//
	// This member is required.
	TestRunId *string

	// The maximum number of test run test cases to return in one page of results.
	MaxResults *int32

	// The token from a previous request to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTestRunTestCasesOutput struct {

	// The test run of the test cases.
	//
	// This member is required.
	TestRunTestCases []types.TestCaseRunSummary

	// The token from a previous request to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestRunTestCasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTestRunTestCases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTestRunTestCases{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestRunTestCases"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTestRunTestCasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestRunTestCases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTestRunTestCasesPaginatorOptions is the paginator options for
// ListTestRunTestCases
type ListTestRunTestCasesPaginatorOptions struct {
	// The maximum number of test run test cases to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestRunTestCasesPaginator is a paginator for ListTestRunTestCases
type ListTestRunTestCasesPaginator struct {
	options   ListTestRunTestCasesPaginatorOptions
	client    ListTestRunTestCasesAPIClient
	params    *ListTestRunTestCasesInput
	nextToken *string
	firstPage bool
}

// NewListTestRunTestCasesPaginator returns a new ListTestRunTestCasesPaginator
func NewListTestRunTestCasesPaginator(client ListTestRunTestCasesAPIClient, params *ListTestRunTestCasesInput, optFns ...func(*ListTestRunTestCasesPaginatorOptions)) *ListTestRunTestCasesPaginator {
	if params == nil {
		params = &ListTestRunTestCasesInput{}
	}

	options := ListTestRunTestCasesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestRunTestCasesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestRunTestCasesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestRunTestCases page.
func (p *ListTestRunTestCasesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestRunTestCasesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestRunTestCases(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestRunTestCasesAPIClient is a client that implements the
// ListTestRunTestCases operation.
type ListTestRunTestCasesAPIClient interface {
	ListTestRunTestCases(context.Context, *ListTestRunTestCasesInput, ...func(*Options)) (*ListTestRunTestCasesOutput, error)
}

var _ ListTestRunTestCasesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestRunTestCases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestRunTestCases",
	}
}
