// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Region switch plan. A plan defines the steps required to shift
// traffic from one Amazon Web Services Region to another.
//
// You must specify a name for the plan, the primary Region, and at least one
// additional Region. You can also provide a description, execution role, recovery
// time objective, associated alarms, triggers, and workflows that define the steps
// to execute during a Region switch.
func (c *Client) CreatePlan(ctx context.Context, params *CreatePlanInput, optFns ...func(*Options)) (*CreatePlanOutput, error) {
	if params == nil {
		params = &CreatePlanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePlan", params, optFns, c.addOperationCreatePlanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePlanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePlanInput struct {

	// An execution role is a way to categorize a Region switch plan.
	//
	// This member is required.
	ExecutionRole *string

	// The name of a Region switch plan.
	//
	// This member is required.
	Name *string

	// The recovery approach for a Region switch plan, which can be active/active
	// (activeActive) or active/passive (activePassive).
	//
	// This member is required.
	RecoveryApproach types.RecoveryApproach

	// An array that specifies the Amazon Web Services Regions for a Region switch
	// plan. Specify two Regions.
	//
	// This member is required.
	Regions []string

	// An array of workflows included in a Region switch plan.
	//
	// This member is required.
	Workflows []types.Workflow

	// The alarms associated with a Region switch plan.
	AssociatedAlarms map[string]types.AssociatedAlarm

	// The description of a Region switch plan.
	Description *string

	// The primary Amazon Web Services Region for the application. This is the Region
	// where the application normally runs before any Region switch occurs.
	PrimaryRegion *string

	// Optionally, you can specify an recovery time objective for a Region switch
	// plan, in minutes.
	RecoveryTimeObjectiveMinutes *int32

	// The tags to apply to the Region switch plan.
	Tags map[string]string

	// The triggers associated with a Region switch plan.
	Triggers []types.Trigger

	noSmithyDocumentSerde
}

func (in *CreatePlanInput) bindEndpointParams(p *EndpointParameters) {

	p.UseControlPlaneEndpoint = ptr.Bool(true)
}

type CreatePlanOutput struct {

	// The details of the created Region switch plan.
	Plan *types.Plan

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePlanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&smithyRpcv2cbor_serializeOpCreatePlan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&smithyRpcv2cbor_deserializeOpCreatePlan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePlan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addUserAgentFeatureProtocolRPCV2CBOR(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePlanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePlan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePlan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePlan",
	}
}
