// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Initiates a flow to start a new task contact. For more information about task
// contacts, see [Concepts: Tasks in Amazon Connect]in the Amazon Connect Administrator Guide.
//
// When using PreviousContactId and RelatedContactId input parameters, note the
// following:
//
//   - PreviousContactId
//
//   - Any updates to user-defined task contact attributes on any contact linked
//     through the same PreviousContactId will affect every contact in the chain.
//
//   - There can be a maximum of 12 linked task contacts in a chain. That is, 12
//     task contacts can be created that share the same PreviousContactId .
//
//   - RelatedContactId
//
//   - Copies contact attributes from the related task contact to the new contact.
//
//   - Any update on attributes in a new task contact does not update attributes
//     on previous contact.
//
//   - There’s no limit on the number of task contacts that can be created that
//     use the same RelatedContactId .
//
// In addition, when calling StartTaskContact include only one of these
// parameters: ContactFlowID , QuickConnectID , or TaskTemplateID . Only one
// parameter is required as long as the task template has a flow configured to run
// it. If more than one parameter is specified, or only the TaskTemplateID is
// specified but it does not have a flow configured, the request returns an error
// because Amazon Connect cannot identify the unique flow to run when the task is
// created.
//
// A ServiceQuotaExceededException occurs when the number of open tasks exceeds
// the active tasks quota or there are already 12 tasks referencing the same
// PreviousContactId . For more information about service quotas for task contacts,
// see [Amazon Connect service quotas]in the Amazon Connect Administrator Guide.
//
// [Amazon Connect service quotas]: https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html
// [Concepts: Tasks in Amazon Connect]: https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html
func (c *Client) StartTaskContact(ctx context.Context, params *StartTaskContactInput, optFns ...func(*Options)) (*StartTaskContactOutput, error) {
	if params == nil {
		params = &StartTaskContactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartTaskContact", params, optFns, c.addOperationStartTaskContactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartTaskContactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartTaskContactInput struct {

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// The name of a task that is shown to an agent in the Contact Control Panel (CCP).
	//
	// This member is required.
	Name *string

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in flows just like any other
	// contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact.
	// Attribute keys can include only alphanumeric, dash, and underscore characters.
	Attributes map[string]string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// The identifier of the flow for initiating the tasks. To see the ContactFlowId
	// in the Amazon Connect admin website, on the navigation menu go to Routing,
	// Flows. Choose the flow. On the flow page, under the name of the flow, choose
	// Show additional flow information. The ContactFlowId is the last part of the ARN,
	// shown here in bold:
	//
	// arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/846ec553-a005-41c0-8341-xxxxxxxxxxxx
	ContactFlowId *string

	// A description of the task that is shown to an agent in the Contact Control
	// Panel (CCP).
	Description *string

	// The identifier of the previous chat, voice, or task contact. Any updates to
	// user-defined attributes to task contacts linked using the same PreviousContactID
	// will affect every contact in the chain. There can be a maximum of 12 linked task
	// contacts in a chain.
	PreviousContactId *string

	// The identifier for the quick connect. Tasks that are created by using
	// QuickConnectId will use the flow that is defined on agent or queue quick
	// connect. For more information about quick connects, see [Create quick connects].
	//
	// [Create quick connects]: https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
	QuickConnectId *string

	// A formatted URL that is shown to an agent in the Contact Control Panel (CCP).
	// Tasks can have the following reference types at the time of creation: URL |
	// NUMBER | STRING | DATE | EMAIL . ATTACHMENT is not a supported reference type
	// during task creation.
	References map[string]types.Reference

	// The contactId that is [related] to this contact. Linking tasks together by using
	// RelatedContactID copies over contact attributes from the related task contact to
	// the new task contact. All updates to user-defined attributes in the new task
	// contact are limited to the individual contact ID, unlike what happens when tasks
	// are linked by using PreviousContactID . There are no limits to the number of
	// contacts that can be linked by using RelatedContactId .
	//
	// [related]: https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html#linked-tasks
	RelatedContactId *string

	// The timestamp, in Unix Epoch seconds format, at which to start running the
	// inbound flow. The scheduled time cannot be in the past. It must be within up to
	// 6 days in future.
	ScheduledTime *time.Time

	// A set of system defined key-value pairs stored on individual contact segments
	// (unique contact ID) using an attribute map. The attributes are standard Amazon
	// Connect attributes. They can be accessed in flows.
	//
	// Attribute keys can include only alphanumeric, -, and _.
	//
	// This field can be used to set Contact Expiry as a duration in minutes and set a
	// UserId for the User who created a task.
	//
	// To set contact expiry, a ValueMap must be specified containing the integer
	// number of minutes the contact will be active for before expiring, with
	// SegmentAttributes like {  "connect:ContactExpiry": {"ValueMap" : {
	// "ExpiryDuration": { "ValueInteger": 135}}}} .
	//
	// To set the created by user, a valid AgentResourceId must be supplied, with
	// SegmentAttributes like { "connect:CreatedByUser" { "ValueString":
	// "arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/agent/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"}}}
	// .
	SegmentAttributes map[string]types.SegmentAttributeValue

	// A unique identifier for the task template. For more information about task
	// templates, see [Create task templates]in the Amazon Connect Administrator Guide.
	//
	// [Create task templates]: https://docs.aws.amazon.com/connect/latest/adminguide/task-templates.html
	TaskTemplateId *string

	noSmithyDocumentSerde
}

type StartTaskContactOutput struct {

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartTaskContactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartTaskContact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartTaskContact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartTaskContact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartTaskContactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartTaskContactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartTaskContact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartTaskContact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartTaskContact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartTaskContact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartTaskContactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartTaskContactInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartTaskContactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartTaskContact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartTaskContact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartTaskContact",
	}
}
