// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a gateway capability configuration or defines a new capability
// configuration. Each gateway capability defines data sources for a gateway.
//
// Important workflow notes:
//
// Each gateway capability defines data sources for a gateway. This is the
// namespace of the gateway capability.
//
// . The namespace follows the format service:capability:version , where:
//
//   - service - The service providing the capability, or iotsitewise .
//
//   - capability - The specific capability type. Options include: opcuacollector
//     for the OPC UA data source collector, or publisher for data publisher
//     capability.
//
//   - version - The version number of the capability. Option include 2 for Classic
//     streams, V2 gateways, and 3 for MQTT-enabled, V3 gateways.
//
// After updating a capability configuration, the sync status becomes OUT_OF_SYNC
// until the gateway processes the configuration.Use
// DescribeGatewayCapabilityConfiguration to check the sync status and verify the
// configuration was applied.
//
// A gateway can have multiple capability configurations with different namespaces.
func (c *Client) UpdateGatewayCapabilityConfiguration(ctx context.Context, params *UpdateGatewayCapabilityConfigurationInput, optFns ...func(*Options)) (*UpdateGatewayCapabilityConfigurationOutput, error) {
	if params == nil {
		params = &UpdateGatewayCapabilityConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGatewayCapabilityConfiguration", params, optFns, c.addOperationUpdateGatewayCapabilityConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGatewayCapabilityConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGatewayCapabilityConfigurationInput struct {

	// The JSON document that defines the configuration for the gateway capability.
	// For more information, see [Configuring data sources (CLI)]in the IoT SiteWise User Guide.
	//
	// [Configuring data sources (CLI)]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli
	//
	// This member is required.
	CapabilityConfiguration *string

	// The namespace of the gateway capability configuration to be updated. For
	// example, if you configure OPC UA sources for an MQTT-enabled gateway, your
	// OPC-UA capability configuration has the namespace iotsitewise:opcuacollector:3 .
	//
	// This member is required.
	CapabilityNamespace *string

	// The ID of the gateway to be updated.
	//
	// This member is required.
	GatewayId *string

	noSmithyDocumentSerde
}

type UpdateGatewayCapabilityConfigurationOutput struct {

	// The namespace of the gateway capability.
	//
	// This member is required.
	CapabilityNamespace *string

	// The synchronization status of the gateway capability configuration. The sync
	// status can be one of the following:
	//
	//   - IN_SYNC - The gateway is running with the latest configuration.
	//
	//   - OUT_OF_SYNC - The gateway hasn't received the latest configuration.
	//
	//   - SYNC_FAILED - The gateway rejected the latest configuration.
	//
	//   - UNKNOWN - The gateway hasn't reported its sync status.
	//
	//   - NOT_APPLICABLE - The gateway doesn't support this capability. This is most
	//   common when integrating partner data sources, because the data integration is
	//   handled externally by the partner.
	//
	// After you update a capability configuration, its sync status is OUT_OF_SYNC
	// until the gateway receives and applies or rejects the updated configuration.
	//
	// This member is required.
	CapabilitySyncStatus types.CapabilitySyncStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGatewayCapabilityConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateGatewayCapabilityConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateGatewayCapabilityConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGatewayCapabilityConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateGatewayCapabilityConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGatewayCapabilityConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware struct {
}

func (*endpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opUpdateGatewayCapabilityConfigurationMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opUpdateGatewayCapabilityConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGatewayCapabilityConfiguration",
	}
}
