// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Options that specify the configuration of a persistent buffer. To configure how
// OpenSearch Ingestion encrypts this data, set the EncryptionAtRestOptions . For
// more information, see [Persistent buffering].
//
// [Persistent buffering]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering
type BufferOptions struct {

	// Whether persistent buffering should be enabled.
	//
	// This member is required.
	PersistentBufferEnabled *bool

	noSmithyDocumentSerde
}

// Progress details for a specific stage of a pipeline configuration change.
type ChangeProgressStage struct {

	// A description of the stage.
	Description *string

	// The most recent updated timestamp of the stage.
	LastUpdatedAt *time.Time

	// The name of the stage.
	Name *string

	// The current status of the stage that the change is in.
	Status ChangeProgressStageStatuses

	noSmithyDocumentSerde
}

// The progress details of a pipeline configuration change.
type ChangeProgressStatus struct {

	// Information about the stages that the pipeline is going through to perform the
	// configuration change.
	ChangeProgressStages []ChangeProgressStage

	// The time at which the configuration change is made on the pipeline.
	StartTime *time.Time

	// The overall status of the pipeline configuration change.
	Status ChangeProgressStatuses

	// The total number of stages required for the pipeline configuration change.
	TotalNumberOfStages int32

	noSmithyDocumentSerde
}

// The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch.
type CloudWatchLogDestination struct {

	// The name of the CloudWatch Logs group to send pipeline logs to. You can specify
	// an existing log group or create a new one. For example,
	// /aws/vendedlogs/OpenSearchService/pipelines .
	//
	// This member is required.
	LogGroup *string

	noSmithyDocumentSerde
}

// Options to control how OpenSearch encrypts buffer data.
type EncryptionAtRestOptions struct {

	// The ARN of the KMS key used to encrypt buffer data. By default, data is
	// encrypted using an Amazon Web Services owned key.
	//
	// This member is required.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Container for the values required to configure logging for the pipeline. If you
// don't specify these values, OpenSearch Ingestion will not publish logs from your
// application to CloudWatch Logs.
type LogPublishingOptions struct {

	// The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs.
	// This parameter is required if IsLoggingEnabled is set to true .
	CloudWatchLogDestination *CloudWatchLogDestination

	// Whether logs should be published.
	IsLoggingEnabled *bool

	noSmithyDocumentSerde
}

// Information about an existing OpenSearch Ingestion pipeline.
type Pipeline struct {

	// Options that specify the configuration of a persistent buffer. To configure how
	// OpenSearch Ingestion encrypts this data, set the EncryptionAtRestOptions . For
	// more information, see [Persistent buffering].
	//
	// [Persistent buffering]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering
	BufferOptions *BufferOptions

	// The date and time when the pipeline was created.
	CreatedAt *time.Time

	// Destinations to which the pipeline writes data.
	Destinations []PipelineDestination

	// Options to control how OpenSearch encrypts buffer data.
	EncryptionAtRestOptions *EncryptionAtRestOptions

	// The ingestion endpoints for the pipeline, which you can send data to.
	IngestEndpointUrls []string

	// The date and time when the pipeline was last updated.
	LastUpdatedAt *time.Time

	// Key-value pairs that represent log publishing settings.
	LogPublishingOptions *LogPublishingOptions

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
	MaxUnits int32

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	MinUnits int32

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The Data Prepper pipeline configuration in YAML format.
	PipelineConfigurationBody *string

	// The name of the pipeline.
	PipelineName *string

	// The Amazon Resource Name (ARN) of the IAM role that provides the required
	// permissions for a pipeline to read from the source and write to the sink.
	PipelineRoleArn *string

	// A list of VPC endpoints that OpenSearch Ingestion has created to other Amazon
	// Web Services services.
	ServiceVpcEndpoints []ServiceVpcEndpoint

	// The current status of the pipeline.
	Status PipelineStatus

	// The reason for the current status of the pipeline.
	StatusReason *PipelineStatusReason

	// A list of tags associated with the given pipeline.
	Tags []Tag

	// The VPC endpoint service name for the pipeline.
	VpcEndpointService *string

	// The VPC interface endpoints that have access to the pipeline.
	VpcEndpoints []VpcEndpoint

	noSmithyDocumentSerde
}

// Container for information about an OpenSearch Ingestion blueprint.
type PipelineBlueprint struct {

	// The name of the blueprint.
	BlueprintName *string

	// A description of the blueprint.
	DisplayDescription *string

	// The display name of the blueprint.
	DisplayName *string

	// The YAML configuration of the blueprint.
	PipelineConfigurationBody *string

	// The name of the service that the blueprint is associated with.
	Service *string

	// The use case that the blueprint relates to.
	UseCase *string

	noSmithyDocumentSerde
}

// A summary of an OpenSearch Ingestion blueprint.
type PipelineBlueprintSummary struct {

	// The name of the blueprint.
	BlueprintName *string

	// A description of the blueprint.
	DisplayDescription *string

	// The display name of the blueprint.
	DisplayName *string

	// The name of the service that the blueprint is associated with.
	Service *string

	// The use case that the blueprint relates to.
	UseCase *string

	noSmithyDocumentSerde
}

// An object representing the destination of a pipeline.
type PipelineDestination struct {

	// The endpoint receiving data from the pipeline.
	Endpoint *string

	// The name of the service receiving data from the pipeline.
	ServiceName *string

	noSmithyDocumentSerde
}

// Information about a pipeline's current status.
type PipelineStatusReason struct {

	// A description of why a pipeline has a certain status.
	Description *string

	noSmithyDocumentSerde
}

// Summary information for an OpenSearch Ingestion pipeline.
type PipelineSummary struct {

	// The date and time when the pipeline was created.
	CreatedAt *time.Time

	// A list of destinations to which the pipeline writes data.
	Destinations []PipelineDestination

	// The date and time when the pipeline was last updated.
	LastUpdatedAt *time.Time

	// The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
	MaxUnits *int32

	// The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
	MinUnits *int32

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The name of the pipeline.
	PipelineName *string

	// The current status of the pipeline.
	Status PipelineStatus

	// Information about a pipeline's current status.
	StatusReason *PipelineStatusReason

	// A list of tags associated with the given pipeline.
	Tags []Tag

	noSmithyDocumentSerde
}

// A container for information about VPC endpoints that were created to other
// services
type ServiceVpcEndpoint struct {

	// The name of the service for which a VPC endpoint was created.
	ServiceName VpcEndpointServiceName

	// The unique identifier of the VPC endpoint that was created.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// A tag (key-value pair) for an OpenSearch Ingestion pipeline.
type Tag struct {

	// The tag key. Tag keys must be unique for the pipeline to which they are
	// attached.
	//
	// This member is required.
	Key *string

	// The value assigned to the corresponding tag key. Tag values can be null and
	// don't have to be unique in a tag set. For example, you can have a key value pair
	// in a tag set of project : Trinity and cost-center : Trinity
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A validation message associated with a ValidatePipeline request in OpenSearch
// Ingestion.
type ValidationMessage struct {

	// The validation message.
	Message *string

	noSmithyDocumentSerde
}

// Options for attaching a VPC to pipeline.
type VpcAttachmentOptions struct {

	// Whether a VPC is attached to the pipeline.
	//
	// This member is required.
	AttachToVpc *bool

	// The CIDR block to be reserved for OpenSearch Ingestion to create elastic
	// network interfaces (ENIs).
	CidrBlock *string

	noSmithyDocumentSerde
}

// An OpenSearch Ingestion-managed VPC endpoint that will access one or more
// pipelines.
type VpcEndpoint struct {

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	// The ID for your VPC. Amazon Web Services PrivateLink generates this value when
	// you create a VPC.
	VpcId *string

	// Information about the VPC, including associated subnets and security groups.
	VpcOptions *VpcOptions

	noSmithyDocumentSerde
}

// Options that specify the subnets and security groups for an OpenSearch
// Ingestion VPC endpoint.
type VpcOptions struct {

	// A list of subnet IDs associated with the VPC endpoint.
	//
	// This member is required.
	SubnetIds []string

	// A list of security groups associated with the VPC endpoint.
	SecurityGroupIds []string

	// Options for attaching a VPC to a pipeline.
	VpcAttachmentOptions *VpcAttachmentOptions

	// Defines whether you or Amazon OpenSearch Ingestion service create and manage
	// the VPC endpoint configured for the pipeline.
	VpcEndpointManagement VpcEndpointManagement

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
