// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/qbusiness/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAssociatePermission struct {
}

func (*awsRestjson1_serializeOpAssociatePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociatePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociatePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociatePermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociatePermissionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociatePermissionInput(v *AssociatePermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociatePermissionInput(v *AssociatePermissionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentQIamActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Conditions != nil {
		ok := object.Key("conditions")
		if err := awsRestjson1_serializeDocumentPermissionConditions(v.Conditions, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		ok.String(*v.Principal)
	}

	if v.StatementId != nil {
		ok := object.Key("statementId")
		ok.String(*v.StatementId)
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteDocument struct {
}

func (*awsRestjson1_serializeOpBatchDeleteDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/documents/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteDocumentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteDocumentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteDocumentInput(v *BatchDeleteDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteDocumentInput(v *BatchDeleteDocumentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceSyncId != nil {
		ok := object.Key("dataSourceSyncId")
		ok.String(*v.DataSourceSyncId)
	}

	if v.Documents != nil {
		ok := object.Key("documents")
		if err := awsRestjson1_serializeDocumentDeleteDocuments(v.Documents, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchPutDocument struct {
}

func (*awsRestjson1_serializeOpBatchPutDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/documents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchPutDocumentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutDocumentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutDocumentInput(v *BatchPutDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutDocumentInput(v *BatchPutDocumentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceSyncId != nil {
		ok := object.Key("dataSourceSyncId")
		ok.String(*v.DataSourceSyncId)
	}

	if v.Documents != nil {
		ok := object.Key("documents")
		if err := awsRestjson1_serializeDocumentDocuments(v.Documents, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpCancelSubscription struct {
}

func (*awsRestjson1_serializeOpCancelSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/subscriptions/{subscriptionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelSubscriptionInput(v *CancelSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SubscriptionId == nil || len(*v.SubscriptionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member subscriptionId must not be empty")}
	}
	if v.SubscriptionId != nil {
		if err := encoder.SetURI("subscriptionId").String(*v.SubscriptionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpChat struct {
}

func (*awsRestjson1_serializeOpChat) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpChat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsChatInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/vnd.amazon.eventstream")

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsChatInput(v *ChatInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.ConversationId != nil {
		encoder.SetQuery("conversationId").String(*v.ConversationId)
	}

	if v.ParentMessageId != nil {
		encoder.SetQuery("parentMessageId").String(*v.ParentMessageId)
	}

	if v.UserGroups != nil {
		for i := range v.UserGroups {
			encoder.AddQuery("userGroups").String(v.UserGroups[i])
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpChatSync struct {
}

func (*awsRestjson1_serializeOpChatSync) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpChatSync) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChatSyncInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations?sync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsChatSyncInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentChatSyncInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsChatSyncInput(v *ChatSyncInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserGroups != nil {
		for i := range v.UserGroups {
			encoder.AddQuery("userGroups").String(v.UserGroups[i])
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentChatSyncInput(v *ChatSyncInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionExecution != nil {
		ok := object.Key("actionExecution")
		if err := awsRestjson1_serializeDocumentActionExecution(v.ActionExecution, ok); err != nil {
			return err
		}
	}

	if v.Attachments != nil {
		ok := object.Key("attachments")
		if err := awsRestjson1_serializeDocumentAttachmentsInput(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.AttributeFilter != nil {
		ok := object.Key("attributeFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.AttributeFilter, ok); err != nil {
			return err
		}
	}

	if v.AuthChallengeResponse != nil {
		ok := object.Key("authChallengeResponse")
		if err := awsRestjson1_serializeDocumentAuthChallengeResponse(v.AuthChallengeResponse, ok); err != nil {
			return err
		}
	}

	if len(v.ChatMode) > 0 {
		ok := object.Key("chatMode")
		ok.String(string(v.ChatMode))
	}

	if v.ChatModeConfiguration != nil {
		ok := object.Key("chatModeConfiguration")
		if err := awsRestjson1_serializeDocumentChatModeConfiguration(v.ChatModeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.ConversationId != nil {
		ok := object.Key("conversationId")
		ok.String(*v.ConversationId)
	}

	if v.ParentMessageId != nil {
		ok := object.Key("parentMessageId")
		ok.String(*v.ParentMessageId)
	}

	if v.UserMessage != nil {
		ok := object.Key("userMessage")
		ok.String(*v.UserMessage)
	}

	return nil
}

type awsRestjson1_serializeOpCheckDocumentAccess struct {
}

func (*awsRestjson1_serializeOpCheckDocumentAccess) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCheckDocumentAccess) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CheckDocumentAccessInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/index/{indexId}/users/{userId}/documents/{documentId}/check-document-access")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCheckDocumentAccessInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCheckDocumentAccessInput(v *CheckDocumentAccessInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.DocumentId == nil || len(*v.DocumentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member documentId must not be empty")}
	}
	if v.DocumentId != nil {
		if err := encoder.SetURI("documentId").String(*v.DocumentId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAnonymousWebExperienceUrl struct {
}

func (*awsRestjson1_serializeOpCreateAnonymousWebExperienceUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAnonymousWebExperienceUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAnonymousWebExperienceUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}/anonymous-url")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAnonymousWebExperienceUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAnonymousWebExperienceUrlInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAnonymousWebExperienceUrlInput(v *CreateAnonymousWebExperienceUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAnonymousWebExperienceUrlInput(v *CreateAnonymousWebExperienceUrlInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SessionDurationInMinutes != nil {
		ok := object.Key("sessionDurationInMinutes")
		ok.Integer(*v.SessionDurationInMinutes)
	}

	return nil
}

type awsRestjson1_serializeOpCreateApplication struct {
}

func (*awsRestjson1_serializeOpCreateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApplicationInput(v *CreateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApplicationInput(v *CreateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentsConfiguration != nil {
		ok := object.Key("attachmentsConfiguration")
		if err := awsRestjson1_serializeDocumentAttachmentsConfiguration(v.AttachmentsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientIdsForOIDC != nil {
		ok := object.Key("clientIdsForOIDC")
		if err := awsRestjson1_serializeDocumentClientIdsForOIDC(v.ClientIdsForOIDC, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.IamIdentityProviderArn != nil {
		ok := object.Key("iamIdentityProviderArn")
		ok.String(*v.IamIdentityProviderArn)
	}

	if v.IdentityCenterInstanceArn != nil {
		ok := object.Key("identityCenterInstanceArn")
		ok.String(*v.IdentityCenterInstanceArn)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("identityType")
		ok.String(string(v.IdentityType))
	}

	if v.PersonalizationConfiguration != nil {
		ok := object.Key("personalizationConfiguration")
		if err := awsRestjson1_serializeDocumentPersonalizationConfiguration(v.PersonalizationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.QAppsConfiguration != nil {
		ok := object.Key("qAppsConfiguration")
		if err := awsRestjson1_serializeDocumentQAppsConfiguration(v.QAppsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.QuickSightConfiguration != nil {
		ok := object.Key("quickSightConfiguration")
		if err := awsRestjson1_serializeDocumentQuickSightConfiguration(v.QuickSightConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateChatResponseConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateChatResponseConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChatResponseConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChatResponseConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatresponseconfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChatResponseConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChatResponseConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChatResponseConfigurationInput(v *CreateChatResponseConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChatResponseConfigurationInput(v *CreateChatResponseConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ResponseConfigurations != nil {
		ok := object.Key("responseConfigurations")
		if err := awsRestjson1_serializeDocumentResponseConfigurations(v.ResponseConfigurations, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataAccessor struct {
}

func (*awsRestjson1_serializeOpCreateDataAccessor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataAccessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataAccessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/dataaccessors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataAccessorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataAccessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataAccessorInput(v *CreateDataAccessorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataAccessorInput(v *CreateDataAccessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionConfigurations != nil {
		ok := object.Key("actionConfigurations")
		if err := awsRestjson1_serializeDocumentActionConfigurationList(v.ActionConfigurations, ok); err != nil {
			return err
		}
	}

	if v.AuthenticationDetail != nil {
		ok := object.Key("authenticationDetail")
		if err := awsRestjson1_serializeDocumentDataAccessorAuthenticationDetail(v.AuthenticationDetail, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		ok.String(*v.Principal)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSource struct {
}

func (*awsRestjson1_serializeOpCreateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(v *CreateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSourceInput(v *CreateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MediaExtractionConfiguration != nil {
		ok := object.Key("mediaExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentMediaExtractionConfiguration(v.MediaExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SyncSchedule != nil {
		ok := object.Key("syncSchedule")
		ok.String(*v.SyncSchedule)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("vpcConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIndex struct {
}

func (*awsRestjson1_serializeOpCreateIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIndexInput(v *CreateIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIndexInput(v *CreateIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityConfiguration != nil {
		ok := object.Key("capacityConfiguration")
		if err := awsRestjson1_serializeDocumentIndexCapacityConfiguration(v.CapacityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreatePlugin struct {
}

func (*awsRestjson1_serializeOpCreatePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePluginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePluginInput(v *CreatePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePluginInput(v *CreatePluginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthConfiguration != nil {
		ok := object.Key("authConfiguration")
		if err := awsRestjson1_serializeDocumentPluginAuthConfiguration(v.AuthConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.CustomPluginConfiguration != nil {
		ok := object.Key("customPluginConfiguration")
		if err := awsRestjson1_serializeDocumentCustomPluginConfiguration(v.CustomPluginConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ServerUrl != nil {
		ok := object.Key("serverUrl")
		ok.String(*v.ServerUrl)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateRetriever struct {
}

func (*awsRestjson1_serializeOpCreateRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRetrieverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRetrieverInput(v *CreateRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRetrieverInput(v *CreateRetrieverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRetrieverConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateSubscription struct {
}

func (*awsRestjson1_serializeOpCreateSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/subscriptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSubscriptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSubscriptionInput(v *CreateSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSubscriptionInput(v *CreateSubscriptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsRestjson1_serializeDocumentSubscriptionPrincipal(v.Principal, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateUser struct {
}

func (*awsRestjson1_serializeOpCreateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUserInput(v *CreateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateUserInput(v *CreateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.UserAliases != nil {
		ok := object.Key("userAliases")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliases, ok); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWebExperience struct {
}

func (*awsRestjson1_serializeOpCreateWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWebExperienceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWebExperienceInput(v *CreateWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWebExperienceInput(v *CreateWebExperienceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BrowserExtensionConfiguration != nil {
		ok := object.Key("browserExtensionConfiguration")
		if err := awsRestjson1_serializeDocumentBrowserExtensionConfiguration(v.BrowserExtensionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.CustomizationConfiguration != nil {
		ok := object.Key("customizationConfiguration")
		if err := awsRestjson1_serializeDocumentCustomizationConfiguration(v.CustomizationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.IdentityProviderConfiguration != nil {
		ok := object.Key("identityProviderConfiguration")
		if err := awsRestjson1_serializeDocumentIdentityProviderConfiguration(v.IdentityProviderConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Origins != nil {
		ok := object.Key("origins")
		if err := awsRestjson1_serializeDocumentWebExperienceOrigins(v.Origins, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if len(v.SamplePromptsControlMode) > 0 {
		ok := object.Key("samplePromptsControlMode")
		ok.String(string(v.SamplePromptsControlMode))
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	if v.WelcomeMessage != nil {
		ok := object.Key("welcomeMessage")
		ok.String(*v.WelcomeMessage)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApplication struct {
}

func (*awsRestjson1_serializeOpDeleteApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(v *DeleteApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAttachment struct {
}

func (*awsRestjson1_serializeOpDeleteAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}/attachments/{attachmentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAttachmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAttachmentInput(v *DeleteAttachmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.AttachmentId == nil || len(*v.AttachmentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member attachmentId must not be empty")}
	}
	if v.AttachmentId != nil {
		if err := encoder.SetURI("attachmentId").String(*v.AttachmentId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChatControlsConfigurationInput(v *DeleteChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChatResponseConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteChatResponseConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChatResponseConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChatResponseConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatresponseconfigurations/{chatResponseConfigurationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChatResponseConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChatResponseConfigurationInput(v *DeleteChatResponseConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ChatResponseConfigurationId == nil || len(*v.ChatResponseConfigurationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member chatResponseConfigurationId must not be empty")}
	}
	if v.ChatResponseConfigurationId != nil {
		if err := encoder.SetURI("chatResponseConfigurationId").String(*v.ChatResponseConfigurationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConversation struct {
}

func (*awsRestjson1_serializeOpDeleteConversation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConversation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConversationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConversationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConversationInput(v *DeleteConversationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataAccessor struct {
}

func (*awsRestjson1_serializeOpDeleteDataAccessor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataAccessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataAccessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/dataaccessors/{dataAccessorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataAccessorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataAccessorInput(v *DeleteDataAccessorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataAccessorId == nil || len(*v.DataAccessorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataAccessorId must not be empty")}
	}
	if v.DataAccessorId != nil {
		if err := encoder.SetURI("dataAccessorId").String(*v.DataAccessorId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSource struct {
}

func (*awsRestjson1_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(v *DeleteDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroup struct {
}

func (*awsRestjson1_serializeOpDeleteGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups/{groupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(v *DeleteGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member groupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("groupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIndex struct {
}

func (*awsRestjson1_serializeOpDeleteIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIndexInput(v *DeleteIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePlugin struct {
}

func (*awsRestjson1_serializeOpDeletePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePluginInput(v *DeletePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRetriever struct {
}

func (*awsRestjson1_serializeOpDeleteRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRetrieverInput(v *DeleteRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUser struct {
}

func (*awsRestjson1_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserInput(v *DeleteUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWebExperience struct {
}

func (*awsRestjson1_serializeOpDeleteWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWebExperienceInput(v *DeleteWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociatePermission struct {
}

func (*awsRestjson1_serializeOpDisassociatePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociatePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociatePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/policy/{statementId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociatePermissionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociatePermissionInput(v *DisassociatePermissionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.StatementId == nil || len(*v.StatementId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member statementId must not be empty")}
	}
	if v.StatementId != nil {
		if err := encoder.SetURI("statementId").String(*v.StatementId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApplication struct {
}

func (*awsRestjson1_serializeOpGetApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationInput(v *GetApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpGetChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChatControlsConfigurationInput(v *GetChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetChatResponseConfiguration struct {
}

func (*awsRestjson1_serializeOpGetChatResponseConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChatResponseConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChatResponseConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatresponseconfigurations/{chatResponseConfigurationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChatResponseConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChatResponseConfigurationInput(v *GetChatResponseConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ChatResponseConfigurationId == nil || len(*v.ChatResponseConfigurationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member chatResponseConfigurationId must not be empty")}
	}
	if v.ChatResponseConfigurationId != nil {
		if err := encoder.SetURI("chatResponseConfigurationId").String(*v.ChatResponseConfigurationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataAccessor struct {
}

func (*awsRestjson1_serializeOpGetDataAccessor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataAccessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataAccessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/dataaccessors/{dataAccessorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataAccessorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataAccessorInput(v *GetDataAccessorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataAccessorId == nil || len(*v.DataAccessorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataAccessorId must not be empty")}
	}
	if v.DataAccessorId != nil {
		if err := encoder.SetURI("dataAccessorId").String(*v.DataAccessorId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataSource struct {
}

func (*awsRestjson1_serializeOpGetDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(v *GetDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDocumentContent struct {
}

func (*awsRestjson1_serializeOpGetDocumentContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDocumentContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDocumentContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/index/{indexId}/documents/{documentId}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDocumentContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDocumentContentInput(v *GetDocumentContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.DocumentId == nil || len(*v.DocumentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member documentId must not be empty")}
	}
	if v.DocumentId != nil {
		if err := encoder.SetURI("documentId").String(*v.DocumentId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if len(v.OutputFormat) > 0 {
		encoder.SetQuery("outputFormat").String(string(v.OutputFormat))
	}

	return nil
}

type awsRestjson1_serializeOpGetGroup struct {
}

func (*awsRestjson1_serializeOpGetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups/{groupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGroupInput(v *GetGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member groupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("groupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIndex struct {
}

func (*awsRestjson1_serializeOpGetIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIndexInput(v *GetIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMedia struct {
}

func (*awsRestjson1_serializeOpGetMedia) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMedia) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMediaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}/messages/{messageId}/media/{mediaId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMediaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMediaInput(v *GetMediaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.MediaId == nil || len(*v.MediaId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mediaId must not be empty")}
	}
	if v.MediaId != nil {
		if err := encoder.SetURI("mediaId").String(*v.MediaId); err != nil {
			return err
		}
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member messageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("messageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPlugin struct {
}

func (*awsRestjson1_serializeOpGetPlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPluginInput(v *GetPluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPolicy struct {
}

func (*awsRestjson1_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPolicyInput(v *GetPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRetriever struct {
}

func (*awsRestjson1_serializeOpGetRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRetrieverInput(v *GetRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetUser struct {
}

func (*awsRestjson1_serializeOpGetUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetUserInput(v *GetUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWebExperience struct {
}

func (*awsRestjson1_serializeOpGetWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWebExperienceInput(v *GetWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListApplications struct {
}

func (*awsRestjson1_serializeOpListApplications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApplications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListApplicationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApplicationsInput(v *ListApplicationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAttachments struct {
}

func (*awsRestjson1_serializeOpListAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/attachments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAttachmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAttachmentsInput(v *ListAttachmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId != nil {
		encoder.SetQuery("conversationId").String(*v.ConversationId)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpListChatResponseConfigurations struct {
}

func (*awsRestjson1_serializeOpListChatResponseConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChatResponseConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChatResponseConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatresponseconfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChatResponseConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChatResponseConfigurationsInput(v *ListChatResponseConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConversations struct {
}

func (*awsRestjson1_serializeOpListConversations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConversations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConversationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConversationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConversationsInput(v *ListConversationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpListDataAccessors struct {
}

func (*awsRestjson1_serializeOpListDataAccessors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataAccessors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataAccessorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/dataaccessors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataAccessorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataAccessorsInput(v *ListDataAccessorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSources struct {
}

func (*awsRestjson1_serializeOpListDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(v *ListDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSourceSyncJobs struct {
}

func (*awsRestjson1_serializeOpListDataSourceSyncJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSourceSyncJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourceSyncJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/syncjobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourceSyncJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourceSyncJobsInput(v *ListDataSourceSyncJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if len(v.StatusFilter) > 0 {
		encoder.SetQuery("syncStatus").String(string(v.StatusFilter))
	}

	return nil
}

type awsRestjson1_serializeOpListDocuments struct {
}

func (*awsRestjson1_serializeOpListDocuments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDocuments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDocumentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/index/{indexId}/documents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDocumentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDocumentsInput(v *ListDocumentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceIds != nil {
		for i := range v.DataSourceIds {
			encoder.AddQuery("dataSourceIds").String(v.DataSourceIds[i])
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroups struct {
}

func (*awsRestjson1_serializeOpListGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupsInput(v *ListGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UpdatedEarlierThan != nil {
		encoder.SetQuery("updatedEarlierThan").String(smithytime.FormatDateTime(*v.UpdatedEarlierThan))
	}

	return nil
}

type awsRestjson1_serializeOpListIndices struct {
}

func (*awsRestjson1_serializeOpListIndices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIndices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIndicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIndicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIndicesInput(v *ListIndicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMessages struct {
}

func (*awsRestjson1_serializeOpListMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMessagesInput(v *ListMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpListPluginActions struct {
}

func (*awsRestjson1_serializeOpListPluginActions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPluginActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPluginActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}/actions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPluginActionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPluginActionsInput(v *ListPluginActionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPlugins struct {
}

func (*awsRestjson1_serializeOpListPlugins) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPlugins) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPluginsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPluginsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPluginsInput(v *ListPluginsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPluginTypeActions struct {
}

func (*awsRestjson1_serializeOpListPluginTypeActions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPluginTypeActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPluginTypeActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pluginTypes/{pluginType}/actions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPluginTypeActionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPluginTypeActionsInput(v *ListPluginTypeActionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.PluginType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginType must not be empty")}
	}
	if len(v.PluginType) > 0 {
		if err := encoder.SetURI("pluginType").String(string(v.PluginType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPluginTypeMetadata struct {
}

func (*awsRestjson1_serializeOpListPluginTypeMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPluginTypeMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPluginTypeMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pluginTypeMetadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPluginTypeMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPluginTypeMetadataInput(v *ListPluginTypeMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRetrievers struct {
}

func (*awsRestjson1_serializeOpListRetrievers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRetrievers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRetrieversInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRetrieversInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRetrieversInput(v *ListRetrieversInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSubscriptions struct {
}

func (*awsRestjson1_serializeOpListSubscriptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSubscriptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSubscriptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/subscriptions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSubscriptionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSubscriptionsInput(v *ListSubscriptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWebExperiences struct {
}

func (*awsRestjson1_serializeOpListWebExperiences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWebExperiences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWebExperiencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWebExperiencesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWebExperiencesInput(v *ListWebExperiencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutFeedback struct {
}

func (*awsRestjson1_serializeOpPutFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}/messages/{messageId}/feedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutFeedbackInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFeedbackInput(v *PutFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member messageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("messageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFeedbackInput(v *PutFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageCopiedAt != nil {
		ok := object.Key("messageCopiedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.MessageCopiedAt))
	}

	if v.MessageUsefulness != nil {
		ok := object.Key("messageUsefulness")
		if err := awsRestjson1_serializeDocumentMessageUsefulnessFeedback(v.MessageUsefulness, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutGroup struct {
}

func (*awsRestjson1_serializeOpPutGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutGroupInput(v *PutGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutGroupInput(v *PutGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.GroupMembers != nil {
		ok := object.Key("groupMembers")
		if err := awsRestjson1_serializeDocumentGroupMembers(v.GroupMembers, ok); err != nil {
			return err
		}
	}

	if v.GroupName != nil {
		ok := object.Key("groupName")
		ok.String(*v.GroupName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpSearchRelevantContent struct {
}

func (*awsRestjson1_serializeOpSearchRelevantContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchRelevantContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchRelevantContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/relevant-content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchRelevantContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchRelevantContentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchRelevantContentInput(v *SearchRelevantContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchRelevantContentInput(v *SearchRelevantContentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeFilter != nil {
		ok := object.Key("attributeFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.AttributeFilter, ok); err != nil {
			return err
		}
	}

	if v.ContentSource != nil {
		ok := object.Key("contentSource")
		if err := awsRestjson1_serializeDocumentContentSource(v.ContentSource, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.QueryText != nil {
		ok := object.Key("queryText")
		ok.String(*v.QueryText)
	}

	return nil
}

type awsRestjson1_serializeOpStartDataSourceSyncJob struct {
}

func (*awsRestjson1_serializeOpStartDataSourceSyncJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDataSourceSyncJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDataSourceSyncJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/startsync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartDataSourceSyncJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDataSourceSyncJobInput(v *StartDataSourceSyncJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopDataSourceSyncJob struct {
}

func (*awsRestjson1_serializeOpStopDataSourceSyncJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopDataSourceSyncJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopDataSourceSyncJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/stopsync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopDataSourceSyncJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopDataSourceSyncJobInput(v *StopDataSourceSyncJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApplication struct {
}

func (*awsRestjson1_serializeOpUpdateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(v *UpdateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApplicationInput(v *UpdateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentsConfiguration != nil {
		ok := object.Key("attachmentsConfiguration")
		if err := awsRestjson1_serializeDocumentAttachmentsConfiguration(v.AttachmentsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AutoSubscriptionConfiguration != nil {
		ok := object.Key("autoSubscriptionConfiguration")
		if err := awsRestjson1_serializeDocumentAutoSubscriptionConfiguration(v.AutoSubscriptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.IdentityCenterInstanceArn != nil {
		ok := object.Key("identityCenterInstanceArn")
		ok.String(*v.IdentityCenterInstanceArn)
	}

	if v.PersonalizationConfiguration != nil {
		ok := object.Key("personalizationConfiguration")
		if err := awsRestjson1_serializeDocumentPersonalizationConfiguration(v.PersonalizationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.QAppsConfiguration != nil {
		ok := object.Key("qAppsConfiguration")
		if err := awsRestjson1_serializeDocumentQAppsConfiguration(v.QAppsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChatControlsConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChatControlsConfigurationInput(v *UpdateChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChatControlsConfigurationInput(v *UpdateChatControlsConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedPhrasesConfigurationUpdate != nil {
		ok := object.Key("blockedPhrasesConfigurationUpdate")
		if err := awsRestjson1_serializeDocumentBlockedPhrasesConfigurationUpdate(v.BlockedPhrasesConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.CreatorModeConfiguration != nil {
		ok := object.Key("creatorModeConfiguration")
		if err := awsRestjson1_serializeDocumentCreatorModeConfiguration(v.CreatorModeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HallucinationReductionConfiguration != nil {
		ok := object.Key("hallucinationReductionConfiguration")
		if err := awsRestjson1_serializeDocumentHallucinationReductionConfiguration(v.HallucinationReductionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OrchestrationConfiguration != nil {
		ok := object.Key("orchestrationConfiguration")
		if err := awsRestjson1_serializeDocumentOrchestrationConfiguration(v.OrchestrationConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.ResponseScope) > 0 {
		ok := object.Key("responseScope")
		ok.String(string(v.ResponseScope))
	}

	if v.TopicConfigurationsToCreateOrUpdate != nil {
		ok := object.Key("topicConfigurationsToCreateOrUpdate")
		if err := awsRestjson1_serializeDocumentTopicConfigurations(v.TopicConfigurationsToCreateOrUpdate, ok); err != nil {
			return err
		}
	}

	if v.TopicConfigurationsToDelete != nil {
		ok := object.Key("topicConfigurationsToDelete")
		if err := awsRestjson1_serializeDocumentTopicConfigurations(v.TopicConfigurationsToDelete, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChatResponseConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateChatResponseConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChatResponseConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChatResponseConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatresponseconfigurations/{chatResponseConfigurationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChatResponseConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChatResponseConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChatResponseConfigurationInput(v *UpdateChatResponseConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ChatResponseConfigurationId == nil || len(*v.ChatResponseConfigurationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member chatResponseConfigurationId must not be empty")}
	}
	if v.ChatResponseConfigurationId != nil {
		if err := encoder.SetURI("chatResponseConfigurationId").String(*v.ChatResponseConfigurationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChatResponseConfigurationInput(v *UpdateChatResponseConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ResponseConfigurations != nil {
		ok := object.Key("responseConfigurations")
		if err := awsRestjson1_serializeDocumentResponseConfigurations(v.ResponseConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataAccessor struct {
}

func (*awsRestjson1_serializeOpUpdateDataAccessor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataAccessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataAccessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/dataaccessors/{dataAccessorId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataAccessorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataAccessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataAccessorInput(v *UpdateDataAccessorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataAccessorId == nil || len(*v.DataAccessorId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataAccessorId must not be empty")}
	}
	if v.DataAccessorId != nil {
		if err := encoder.SetURI("dataAccessorId").String(*v.DataAccessorId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataAccessorInput(v *UpdateDataAccessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionConfigurations != nil {
		ok := object.Key("actionConfigurations")
		if err := awsRestjson1_serializeDocumentActionConfigurationList(v.ActionConfigurations, ok); err != nil {
			return err
		}
	}

	if v.AuthenticationDetail != nil {
		ok := object.Key("authenticationDetail")
		if err := awsRestjson1_serializeDocumentDataAccessorAuthenticationDetail(v.AuthenticationDetail, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSource struct {
}

func (*awsRestjson1_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(v *UpdateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MediaExtractionConfiguration != nil {
		ok := object.Key("mediaExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentMediaExtractionConfiguration(v.MediaExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SyncSchedule != nil {
		ok := object.Key("syncSchedule")
		ok.String(*v.SyncSchedule)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("vpcConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIndex struct {
}

func (*awsRestjson1_serializeOpUpdateIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIndexInput(v *UpdateIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIndexInput(v *UpdateIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityConfiguration != nil {
		ok := object.Key("capacityConfiguration")
		if err := awsRestjson1_serializeDocumentIndexCapacityConfiguration(v.CapacityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentAttributeConfigurations != nil {
		ok := object.Key("documentAttributeConfigurations")
		if err := awsRestjson1_serializeDocumentDocumentAttributeConfigurations(v.DocumentAttributeConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePlugin struct {
}

func (*awsRestjson1_serializeOpUpdatePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePluginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePluginInput(v *UpdatePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePluginInput(v *UpdatePluginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthConfiguration != nil {
		ok := object.Key("authConfiguration")
		if err := awsRestjson1_serializeDocumentPluginAuthConfiguration(v.AuthConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomPluginConfiguration != nil {
		ok := object.Key("customPluginConfiguration")
		if err := awsRestjson1_serializeDocumentCustomPluginConfiguration(v.CustomPluginConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ServerUrl != nil {
		ok := object.Key("serverUrl")
		ok.String(*v.ServerUrl)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRetriever struct {
}

func (*awsRestjson1_serializeOpUpdateRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRetrieverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRetrieverInput(v *UpdateRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRetrieverInput(v *UpdateRetrieverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRetrieverConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSubscription struct {
}

func (*awsRestjson1_serializeOpUpdateSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/subscriptions/{subscriptionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSubscriptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSubscriptionInput(v *UpdateSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.SubscriptionId == nil || len(*v.SubscriptionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member subscriptionId must not be empty")}
	}
	if v.SubscriptionId != nil {
		if err := encoder.SetURI("subscriptionId").String(*v.SubscriptionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSubscriptionInput(v *UpdateSubscriptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUser struct {
}

func (*awsRestjson1_serializeOpUpdateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserInput(v *UpdateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserInput(v *UpdateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserAliasesToDelete != nil {
		ok := object.Key("userAliasesToDelete")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliasesToDelete, ok); err != nil {
			return err
		}
	}

	if v.UserAliasesToUpdate != nil {
		ok := object.Key("userAliasesToUpdate")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliasesToUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWebExperience struct {
}

func (*awsRestjson1_serializeOpUpdateWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWebExperienceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWebExperienceInput(v *UpdateWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWebExperienceInput(v *UpdateWebExperienceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("authenticationConfiguration")
		if err := awsRestjson1_serializeDocumentWebExperienceAuthConfiguration(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.BrowserExtensionConfiguration != nil {
		ok := object.Key("browserExtensionConfiguration")
		if err := awsRestjson1_serializeDocumentBrowserExtensionConfiguration(v.BrowserExtensionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CustomizationConfiguration != nil {
		ok := object.Key("customizationConfiguration")
		if err := awsRestjson1_serializeDocumentCustomizationConfiguration(v.CustomizationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.IdentityProviderConfiguration != nil {
		ok := object.Key("identityProviderConfiguration")
		if err := awsRestjson1_serializeDocumentIdentityProviderConfiguration(v.IdentityProviderConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Origins != nil {
		ok := object.Key("origins")
		if err := awsRestjson1_serializeDocumentWebExperienceOrigins(v.Origins, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if len(v.SamplePromptsControlMode) > 0 {
		ok := object.Key("samplePromptsControlMode")
		ok.String(string(v.SamplePromptsControlMode))
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	if v.WelcomeMessage != nil {
		ok := object.Key("welcomeMessage")
		ok.String(*v.WelcomeMessage)
	}

	return nil
}

func awsRestjson1_serializeEventStreamChatInputStream(v types.ChatInputStream, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	switch vv := v.(type) {
	case *types.ChatInputStreamMemberConfigurationEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("configurationEvent"))
		return awsRestjson1_serializeEventMessageConfigurationEvent(&vv.Value, msg)

	case *types.ChatInputStreamMemberTextEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("textEvent"))
		return awsRestjson1_serializeEventMessageTextInputEvent(&vv.Value, msg)

	case *types.ChatInputStreamMemberAttachmentEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("attachmentEvent"))
		return awsRestjson1_serializeEventMessageAttachmentInputEvent(&vv.Value, msg)

	case *types.ChatInputStreamMemberActionExecutionEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("actionExecutionEvent"))
		return awsRestjson1_serializeEventMessageActionExecutionEvent(&vv.Value, msg)

	case *types.ChatInputStreamMemberEndOfInputEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("endOfInputEvent"))
		return awsRestjson1_serializeEventMessageEndOfInputEvent(&vv.Value, msg)

	case *types.ChatInputStreamMemberAuthChallengeResponseEvent:
		msg.Headers.Set(eventstreamapi.EventTypeHeader, eventstream.StringValue("authChallengeResponseEvent"))
		return awsRestjson1_serializeEventMessageAuthChallengeResponseEvent(&vv.Value, msg)

	default:
		return fmt.Errorf("unexpected event message type: %v", v)

	}
}
func awsRestjson1_serializeEventMessageActionExecutionEvent(v *types.ActionExecutionEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentActionExecutionEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageAttachmentInputEvent(v *types.AttachmentInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentAttachmentInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageAuthChallengeResponseEvent(v *types.AuthChallengeResponseEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentAuthChallengeResponseEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageConfigurationEvent(v *types.ConfigurationEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentConfigurationEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageEndOfInputEvent(v *types.EndOfInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentEndOfInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeEventMessageTextInputEvent(v *types.TextInputEvent, msg *eventstream.Message) error {
	if v == nil {
		return fmt.Errorf("unexpected serialization of nil %T", v)
	}

	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	msg.Headers.Set(eventstreamapi.ContentTypeHeader, eventstream.StringValue("application/json"))
	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeDocumentTextInputEvent(v, jsonEncoder.Value); err != nil {
		return err
	}
	msg.Payload = jsonEncoder.Bytes()
	return nil
}

func awsRestjson1_serializeDocumentActionExecutionEvent(v *types.ActionExecutionEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentActionExecutionPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.PayloadFieldNameSeparator != nil {
		ok := object.Key("payloadFieldNameSeparator")
		ok.String(*v.PayloadFieldNameSeparator)
	}

	if v.PluginId != nil {
		ok := object.Key("pluginId")
		ok.String(*v.PluginId)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionExecutionPayload(v map[string]types.ActionExecutionPayloadField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentActionExecutionPayloadField(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActionExecutionPayloadField(v *types.ActionExecutionPayloadField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentActionPayloadFieldValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionPayloadFieldValue(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentAttachmentInput(v *types.AttachmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyFrom != nil {
		ok := object.Key("copyFrom")
		if err := awsRestjson1_serializeDocumentCopyFromSource(v.CopyFrom, ok); err != nil {
			return err
		}
	}

	if v.Data != nil {
		ok := object.Key("data")
		ok.Base64EncodeBytes(v.Data)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttachmentInputEvent(v *types.AttachmentInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachment != nil {
		ok := object.Key("attachment")
		if err := awsRestjson1_serializeDocumentAttachmentInput(v.Attachment, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeFilter(v *types.AttributeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AndAllFilters != nil {
		ok := object.Key("andAllFilters")
		if err := awsRestjson1_serializeDocumentAttributeFilters(v.AndAllFilters, ok); err != nil {
			return err
		}
	}

	if v.ContainsAll != nil {
		ok := object.Key("containsAll")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.ContainsAll, ok); err != nil {
			return err
		}
	}

	if v.ContainsAny != nil {
		ok := object.Key("containsAny")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.ContainsAny, ok); err != nil {
			return err
		}
	}

	if v.EqualsTo != nil {
		ok := object.Key("equalsTo")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.EqualsTo, ok); err != nil {
			return err
		}
	}

	if v.GreaterThan != nil {
		ok := object.Key("greaterThan")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.GreaterThan, ok); err != nil {
			return err
		}
	}

	if v.GreaterThanOrEquals != nil {
		ok := object.Key("greaterThanOrEquals")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.GreaterThanOrEquals, ok); err != nil {
			return err
		}
	}

	if v.LessThan != nil {
		ok := object.Key("lessThan")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.LessThan, ok); err != nil {
			return err
		}
	}

	if v.LessThanOrEquals != nil {
		ok := object.Key("lessThanOrEquals")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.LessThanOrEquals, ok); err != nil {
			return err
		}
	}

	if v.NotFilter != nil {
		ok := object.Key("notFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.NotFilter, ok); err != nil {
			return err
		}
	}

	if v.OrAllFilters != nil {
		ok := object.Key("orAllFilters")
		if err := awsRestjson1_serializeDocumentAttributeFilters(v.OrAllFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeFilters(v []types.AttributeFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttributeFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAuthChallengeResponseEvent(v *types.AuthChallengeResponseEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResponseMap != nil {
		ok := object.Key("responseMap")
		if err := awsRestjson1_serializeDocumentAuthorizationResponseMap(v.ResponseMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthorizationResponseMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentChatModeConfiguration(v types.ChatModeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ChatModeConfigurationMemberPluginConfiguration:
		av := object.Key("pluginConfiguration")
		if err := awsRestjson1_serializeDocumentPluginConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentConfigurationEvent(v *types.ConfigurationEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeFilter != nil {
		ok := object.Key("attributeFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.AttributeFilter, ok); err != nil {
			return err
		}
	}

	if len(v.ChatMode) > 0 {
		ok := object.Key("chatMode")
		ok.String(string(v.ChatMode))
	}

	if v.ChatModeConfiguration != nil {
		ok := object.Key("chatModeConfiguration")
		if err := awsRestjson1_serializeDocumentChatModeConfiguration(v.ChatModeConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConversationSource(v *types.ConversationSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentId != nil {
		ok := object.Key("attachmentId")
		ok.String(*v.AttachmentId)
	}

	if v.ConversationId != nil {
		ok := object.Key("conversationId")
		ok.String(*v.ConversationId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCopyFromSource(v types.CopyFromSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CopyFromSourceMemberConversation:
		av := object.Key("conversation")
		if err := awsRestjson1_serializeDocumentConversationSource(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttribute(v *types.DocumentAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeStringListValue(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeValue(v types.DocumentAttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentAttributeValueMemberDateValue:
		av := object.Key("dateValue")
		av.Double(smithytime.FormatEpochSeconds(uv.Value))

	case *types.DocumentAttributeValueMemberLongValue:
		av := object.Key("longValue")
		av.Long(uv.Value)

	case *types.DocumentAttributeValueMemberStringListValue:
		av := object.Key("stringListValue")
		if err := awsRestjson1_serializeDocumentDocumentAttributeStringListValue(uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeValueMemberStringValue:
		av := object.Key("stringValue")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEndOfInputEvent(v *types.EndOfInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentPluginConfiguration(v *types.PluginConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PluginId != nil {
		ok := object.Key("pluginId")
		ok.String(*v.PluginId)
	}

	return nil
}

func awsRestjson1_serializeDocumentTextInputEvent(v *types.TextInputEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserMessage != nil {
		ok := object.Key("userMessage")
		ok.String(*v.UserMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessConfiguration(v *types.AccessConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessControls != nil {
		ok := object.Key("accessControls")
		if err := awsRestjson1_serializeDocumentAccessControls(v.AccessControls, ok); err != nil {
			return err
		}
	}

	if len(v.MemberRelation) > 0 {
		ok := object.Key("memberRelation")
		ok.String(string(v.MemberRelation))
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControl(v *types.AccessControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MemberRelation) > 0 {
		ok := object.Key("memberRelation")
		ok.String(string(v.MemberRelation))
	}

	if v.Principals != nil {
		ok := object.Key("principals")
		if err := awsRestjson1_serializeDocumentPrincipals(v.Principals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControls(v []types.AccessControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAccessControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActionConfiguration(v *types.ActionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		ok.String(*v.Action)
	}

	if v.FilterConfiguration != nil {
		ok := object.Key("filterConfiguration")
		if err := awsRestjson1_serializeDocumentActionFilterConfiguration(v.FilterConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionConfigurationList(v []types.ActionConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentActionConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActionExecution(v *types.ActionExecution, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentActionExecutionPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.PayloadFieldNameSeparator != nil {
		ok := object.Key("payloadFieldNameSeparator")
		ok.String(*v.PayloadFieldNameSeparator)
	}

	if v.PluginId != nil {
		ok := object.Key("pluginId")
		ok.String(*v.PluginId)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionFilterConfiguration(v *types.ActionFilterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentAttributeFilter != nil {
		ok := object.Key("documentAttributeFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.DocumentAttributeFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAPISchema(v types.APISchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.APISchemaMemberPayload:
		av := object.Key("payload")
		av.String(uv.Value)

	case *types.APISchemaMemberS3:
		av := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAttachmentsConfiguration(v *types.AttachmentsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttachmentsControlMode) > 0 {
		ok := object.Key("attachmentsControlMode")
		ok.String(string(v.AttachmentsControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentAttachmentsInput(v []types.AttachmentInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttachmentInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioExtractionConfiguration(v *types.AudioExtractionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioExtractionStatus) > 0 {
		ok := object.Key("audioExtractionStatus")
		ok.String(string(v.AudioExtractionStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthChallengeResponse(v *types.AuthChallengeResponse, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResponseMap != nil {
		ok := object.Key("responseMap")
		if err := awsRestjson1_serializeDocumentAuthorizationResponseMap(v.ResponseMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutoSubscriptionConfiguration(v *types.AutoSubscriptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutoSubscribe) > 0 {
		ok := object.Key("autoSubscribe")
		ok.String(string(v.AutoSubscribe))
	}

	if len(v.DefaultSubscriptionType) > 0 {
		ok := object.Key("defaultSubscriptionType")
		ok.String(string(v.DefaultSubscriptionType))
	}

	return nil
}

func awsRestjson1_serializeDocumentBasicAuthConfiguration(v *types.BasicAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentBlockedPhrases(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentBlockedPhrasesConfigurationUpdate(v *types.BlockedPhrasesConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedPhrasesToCreateOrUpdate != nil {
		ok := object.Key("blockedPhrasesToCreateOrUpdate")
		if err := awsRestjson1_serializeDocumentBlockedPhrases(v.BlockedPhrasesToCreateOrUpdate, ok); err != nil {
			return err
		}
	}

	if v.BlockedPhrasesToDelete != nil {
		ok := object.Key("blockedPhrasesToDelete")
		if err := awsRestjson1_serializeDocumentBlockedPhrases(v.BlockedPhrasesToDelete, ok); err != nil {
			return err
		}
	}

	if v.SystemMessageOverride != nil {
		ok := object.Key("systemMessageOverride")
		ok.String(*v.SystemMessageOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentBrowserExtensionConfiguration(v *types.BrowserExtensionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnabledBrowserExtensions != nil {
		ok := object.Key("enabledBrowserExtensions")
		if err := awsRestjson1_serializeDocumentBrowserExtensionList(v.EnabledBrowserExtensions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBrowserExtensionList(v []types.BrowserExtension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentClientIdsForOIDC(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentContentBlockerRule(v *types.ContentBlockerRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SystemMessageOverride != nil {
		ok := object.Key("systemMessageOverride")
		ok.String(*v.SystemMessageOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentContentRetrievalRule(v *types.ContentRetrievalRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EligibleDataSources != nil {
		ok := object.Key("eligibleDataSources")
		if err := awsRestjson1_serializeDocumentEligibleDataSources(v.EligibleDataSources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContentSource(v types.ContentSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ContentSourceMemberRetriever:
		av := object.Key("retriever")
		if err := awsRestjson1_serializeDocumentRetrieverContentSource(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCreatorModeConfiguration(v *types.CreatorModeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CreatorModeControl) > 0 {
		ok := object.Key("creatorModeControl")
		ok.String(string(v.CreatorModeControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomizationConfiguration(v *types.CustomizationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomCSSUrl != nil {
		ok := object.Key("customCSSUrl")
		ok.String(*v.CustomCSSUrl)
	}

	if v.FaviconUrl != nil {
		ok := object.Key("faviconUrl")
		ok.String(*v.FaviconUrl)
	}

	if v.FontUrl != nil {
		ok := object.Key("fontUrl")
		ok.String(*v.FontUrl)
	}

	if v.LogoUrl != nil {
		ok := object.Key("logoUrl")
		ok.String(*v.LogoUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomPluginConfiguration(v *types.CustomPluginConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiSchema != nil {
		ok := object.Key("apiSchema")
		if err := awsRestjson1_serializeDocumentAPISchema(v.ApiSchema, ok); err != nil {
			return err
		}
	}

	if len(v.ApiSchemaType) > 0 {
		ok := object.Key("apiSchemaType")
		ok.String(string(v.ApiSchemaType))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataAccessorAuthenticationConfiguration(v types.DataAccessorAuthenticationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DataAccessorAuthenticationConfigurationMemberIdcTrustedTokenIssuerConfiguration:
		av := object.Key("idcTrustedTokenIssuerConfiguration")
		if err := awsRestjson1_serializeDocumentDataAccessorIdcTrustedTokenIssuerConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDataAccessorAuthenticationDetail(v *types.DataAccessorAuthenticationDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("authenticationConfiguration")
		if err := awsRestjson1_serializeDocumentDataAccessorAuthenticationConfiguration(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.ExternalIds != nil {
		ok := object.Key("externalIds")
		if err := awsRestjson1_serializeDocumentDataAccessorExternalIds(v.ExternalIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataAccessorExternalIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataAccessorIdcTrustedTokenIssuerConfiguration(v *types.DataAccessorIdcTrustedTokenIssuerConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdcTrustedTokenIssuerArn != nil {
		ok := object.Key("idcTrustedTokenIssuerArn")
		ok.String(*v.IdcTrustedTokenIssuerArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceConfiguration(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v *types.DataSourceVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateAttributeBoostingConfiguration(v *types.DateAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoostingDurationInSeconds != nil {
		ok := object.Key("boostingDurationInSeconds")
		ok.Long(*v.BoostingDurationInSeconds)
	}

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentDeleteDocument(v *types.DeleteDocument, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentId != nil {
		ok := object.Key("documentId")
		ok.String(*v.DocumentId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeleteDocuments(v []types.DeleteDocument, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDeleteDocument(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocument(v *types.Document, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessConfiguration != nil {
		ok := object.Key("accessConfiguration")
		if err := awsRestjson1_serializeDocumentAccessConfiguration(v.AccessConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentDocumentContent(v.Content, ok); err != nil {
			return err
		}
	}

	if len(v.ContentType) > 0 {
		ok := object.Key("contentType")
		ok.String(string(v.ContentType))
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.MediaExtractionConfiguration != nil {
		ok := object.Key("mediaExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentMediaExtractionConfiguration(v.MediaExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeBoostingConfiguration(v types.DocumentAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentAttributeBoostingConfigurationMemberDateConfiguration:
		av := object.Key("dateConfiguration")
		if err := awsRestjson1_serializeDocumentDateAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberNumberConfiguration:
		av := object.Key("numberConfiguration")
		if err := awsRestjson1_serializeDocumentNumberAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberStringConfiguration:
		av := object.Key("stringConfiguration")
		if err := awsRestjson1_serializeDocumentStringAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberStringListConfiguration:
		av := object.Key("stringListConfiguration")
		if err := awsRestjson1_serializeDocumentStringListAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeBoostingOverrideMap(v map[string]types.DocumentAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDocumentAttributeBoostingConfiguration(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeCondition(v *types.DocumentAttributeCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeConfiguration(v *types.DocumentAttributeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Search) > 0 {
		ok := object.Key("search")
		ok.String(string(v.Search))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeConfigurations(v []types.DocumentAttributeConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocumentAttributeConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributes(v []types.DocumentAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocumentAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeTarget(v *types.DocumentAttributeTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttributeValueOperator) > 0 {
		ok := object.Key("attributeValueOperator")
		ok.String(string(v.AttributeValueOperator))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentContent(v types.DocumentContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentContentMemberBlob:
		av := object.Key("blob")
		av.Base64EncodeBytes(uv.Value)

	case *types.DocumentContentMemberS3:
		av := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v *types.DocumentEnrichmentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InlineConfigurations != nil {
		ok := object.Key("inlineConfigurations")
		if err := awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfigurations(v.InlineConfigurations, ok); err != nil {
			return err
		}
	}

	if v.PostExtractionHookConfiguration != nil {
		ok := object.Key("postExtractionHookConfiguration")
		if err := awsRestjson1_serializeDocumentHookConfiguration(v.PostExtractionHookConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PreExtractionHookConfiguration != nil {
		ok := object.Key("preExtractionHookConfiguration")
		if err := awsRestjson1_serializeDocumentHookConfiguration(v.PreExtractionHookConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocuments(v []types.Document, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocument(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEligibleDataSource(v *types.EligibleDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	return nil
}

func awsRestjson1_serializeDocumentEligibleDataSources(v []types.EligibleDataSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEligibleDataSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentExampleChatMessages(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGroupMembers(v *types.GroupMembers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MemberGroups != nil {
		ok := object.Key("memberGroups")
		if err := awsRestjson1_serializeDocumentMemberGroups(v.MemberGroups, ok); err != nil {
			return err
		}
	}

	if v.MemberUsers != nil {
		ok := object.Key("memberUsers")
		if err := awsRestjson1_serializeDocumentMemberUsers(v.MemberUsers, ok); err != nil {
			return err
		}
	}

	if v.S3PathForGroupMembers != nil {
		ok := object.Key("s3PathForGroupMembers")
		if err := awsRestjson1_serializeDocumentS3(v.S3PathForGroupMembers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHallucinationReductionConfiguration(v *types.HallucinationReductionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.HallucinationReductionControl) > 0 {
		ok := object.Key("hallucinationReductionControl")
		ok.String(string(v.HallucinationReductionControl))
	}

	return nil
}

func awsRestjson1_serializeDocumentHookConfiguration(v *types.HookConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvocationCondition != nil {
		ok := object.Key("invocationCondition")
		if err := awsRestjson1_serializeDocumentDocumentAttributeCondition(v.InvocationCondition, ok); err != nil {
			return err
		}
	}

	if v.LambdaArn != nil {
		ok := object.Key("lambdaArn")
		ok.String(*v.LambdaArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdcAuthConfiguration(v *types.IdcAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdcApplicationArn != nil {
		ok := object.Key("idcApplicationArn")
		ok.String(*v.IdcApplicationArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdentityProviderConfiguration(v types.IdentityProviderConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.IdentityProviderConfigurationMemberOpenIDConnectConfiguration:
		av := object.Key("openIDConnectConfiguration")
		if err := awsRestjson1_serializeDocumentOpenIDConnectProviderConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.IdentityProviderConfigurationMemberSamlConfiguration:
		av := object.Key("samlConfiguration")
		if err := awsRestjson1_serializeDocumentSamlProviderConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentImageExtractionConfiguration(v *types.ImageExtractionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ImageExtractionStatus) > 0 {
		ok := object.Key("imageExtractionStatus")
		ok.String(string(v.ImageExtractionStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentIndexCapacityConfiguration(v *types.IndexCapacityConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Units != nil {
		ok := object.Key("units")
		ok.Integer(*v.Units)
	}

	return nil
}

func awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfiguration(v *types.InlineDocumentEnrichmentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentDocumentAttributeCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if len(v.DocumentContentOperator) > 0 {
		ok := object.Key("documentContentOperator")
		ok.String(string(v.DocumentContentOperator))
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentDocumentAttributeTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfigurations(v []types.InlineDocumentEnrichmentConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentInstructionCollection(v *types.InstructionCollection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomInstructions != nil {
		ok := object.Key("customInstructions")
		ok.String(*v.CustomInstructions)
	}

	if v.Examples != nil {
		ok := object.Key("examples")
		ok.String(*v.Examples)
	}

	if v.Identity != nil {
		ok := object.Key("identity")
		ok.String(*v.Identity)
	}

	if v.OutputStyle != nil {
		ok := object.Key("outputStyle")
		ok.String(*v.OutputStyle)
	}

	if v.Perspective != nil {
		ok := object.Key("perspective")
		ok.String(*v.Perspective)
	}

	if v.ResponseLength != nil {
		ok := object.Key("responseLength")
		ok.String(*v.ResponseLength)
	}

	if v.TargetAudience != nil {
		ok := object.Key("targetAudience")
		ok.String(*v.TargetAudience)
	}

	if v.Tone != nil {
		ok := object.Key("tone")
		ok.String(*v.Tone)
	}

	return nil
}

func awsRestjson1_serializeDocumentKendraIndexConfiguration(v *types.KendraIndexConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMediaExtractionConfiguration(v *types.MediaExtractionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioExtractionConfiguration != nil {
		ok := object.Key("audioExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentAudioExtractionConfiguration(v.AudioExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ImageExtractionConfiguration != nil {
		ok := object.Key("imageExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentImageExtractionConfiguration(v.ImageExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.VideoExtractionConfiguration != nil {
		ok := object.Key("videoExtractionConfiguration")
		if err := awsRestjson1_serializeDocumentVideoExtractionConfiguration(v.VideoExtractionConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberGroup(v *types.MemberGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("groupName")
		ok.String(*v.GroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberGroups(v []types.MemberGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMemberGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMemberUser(v *types.MemberUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberUsers(v []types.MemberUser, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMemberUser(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMessageUsefulnessFeedback(v *types.MessageUsefulnessFeedback, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.Reason) > 0 {
		ok := object.Key("reason")
		ok.String(string(v.Reason))
	}

	if v.SubmittedAt != nil {
		ok := object.Key("submittedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.SubmittedAt))
	}

	if len(v.Usefulness) > 0 {
		ok := object.Key("usefulness")
		ok.String(string(v.Usefulness))
	}

	return nil
}

func awsRestjson1_serializeDocumentNativeIndexConfiguration(v *types.NativeIndexConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoostingOverride != nil {
		ok := object.Key("boostingOverride")
		if err := awsRestjson1_serializeDocumentDocumentAttributeBoostingOverrideMap(v.BoostingOverride, ok); err != nil {
			return err
		}
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.Long(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentNoAuthConfiguration(v *types.NoAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentNumberAttributeBoostingConfiguration(v *types.NumberAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	if len(v.BoostingType) > 0 {
		ok := object.Key("boostingType")
		ok.String(string(v.BoostingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuth2ClientCredentialConfiguration(v *types.OAuth2ClientCredentialConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationUrl != nil {
		ok := object.Key("authorizationUrl")
		ok.String(*v.AuthorizationUrl)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	if v.TokenUrl != nil {
		ok := object.Key("tokenUrl")
		ok.String(*v.TokenUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentOpenIDConnectProviderConfiguration(v *types.OpenIDConnectProviderConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretsArn != nil {
		ok := object.Key("secretsArn")
		ok.String(*v.SecretsArn)
	}

	if v.SecretsRole != nil {
		ok := object.Key("secretsRole")
		ok.String(*v.SecretsRole)
	}

	return nil
}

func awsRestjson1_serializeDocumentOrchestrationConfiguration(v *types.OrchestrationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Control) > 0 {
		ok := object.Key("control")
		ok.String(string(v.Control))
	}

	return nil
}

func awsRestjson1_serializeDocumentPermissionCondition(v *types.PermissionCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionKey != nil {
		ok := object.Key("conditionKey")
		ok.String(*v.ConditionKey)
	}

	if len(v.ConditionOperator) > 0 {
		ok := object.Key("conditionOperator")
		ok.String(string(v.ConditionOperator))
	}

	if v.ConditionValues != nil {
		ok := object.Key("conditionValues")
		if err := awsRestjson1_serializeDocumentPermissionConditionValues(v.ConditionValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPermissionConditions(v []types.PermissionCondition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPermissionCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPermissionConditionValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPersonalizationConfiguration(v *types.PersonalizationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PersonalizationControlMode) > 0 {
		ok := object.Key("personalizationControlMode")
		ok.String(string(v.PersonalizationControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentPluginAuthConfiguration(v types.PluginAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PluginAuthConfigurationMemberBasicAuthConfiguration:
		av := object.Key("basicAuthConfiguration")
		if err := awsRestjson1_serializeDocumentBasicAuthConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.PluginAuthConfigurationMemberIdcAuthConfiguration:
		av := object.Key("idcAuthConfiguration")
		if err := awsRestjson1_serializeDocumentIdcAuthConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.PluginAuthConfigurationMemberNoAuthConfiguration:
		av := object.Key("noAuthConfiguration")
		if err := awsRestjson1_serializeDocumentNoAuthConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.PluginAuthConfigurationMemberOAuth2ClientCredentialConfiguration:
		av := object.Key("oAuth2ClientCredentialConfiguration")
		if err := awsRestjson1_serializeDocumentOAuth2ClientCredentialConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipal(v types.Principal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PrincipalMemberGroup:
		av := object.Key("group")
		if err := awsRestjson1_serializeDocumentPrincipalGroup(&uv.Value, av); err != nil {
			return err
		}

	case *types.PrincipalMemberUser:
		av := object.Key("user")
		if err := awsRestjson1_serializeDocumentPrincipalUser(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipalGroup(v *types.PrincipalGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Access) > 0 {
		ok := object.Key("access")
		ok.String(string(v.Access))
	}

	if len(v.MembershipType) > 0 {
		ok := object.Key("membershipType")
		ok.String(string(v.MembershipType))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipals(v []types.Principal, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPrincipal(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipalUser(v *types.PrincipalUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Access) > 0 {
		ok := object.Key("access")
		ok.String(string(v.Access))
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if len(v.MembershipType) > 0 {
		ok := object.Key("membershipType")
		ok.String(string(v.MembershipType))
	}

	return nil
}

func awsRestjson1_serializeDocumentQAppsConfiguration(v *types.QAppsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.QAppsControlMode) > 0 {
		ok := object.Key("qAppsControlMode")
		ok.String(string(v.QAppsControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentQIamActions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentQuickSightConfiguration(v *types.QuickSightConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientNamespace != nil {
		ok := object.Key("clientNamespace")
		ok.String(*v.ClientNamespace)
	}

	return nil
}

func awsRestjson1_serializeDocumentResponseConfiguration(v *types.ResponseConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstructionCollection != nil {
		ok := object.Key("instructionCollection")
		if err := awsRestjson1_serializeDocumentInstructionCollection(v.InstructionCollection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResponseConfigurations(v map[string]types.ResponseConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentResponseConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRetrieverConfiguration(v types.RetrieverConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RetrieverConfigurationMemberKendraIndexConfiguration:
		av := object.Key("kendraIndexConfiguration")
		if err := awsRestjson1_serializeDocumentKendraIndexConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrieverConfigurationMemberNativeIndexConfiguration:
		av := object.Key("nativeIndexConfiguration")
		if err := awsRestjson1_serializeDocumentNativeIndexConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRetrieverContentSource(v *types.RetrieverContentSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RetrieverId != nil {
		ok := object.Key("retrieverId")
		ok.String(*v.RetrieverId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRule(v *types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExcludedUsersAndGroups != nil {
		ok := object.Key("excludedUsersAndGroups")
		if err := awsRestjson1_serializeDocumentUsersAndGroups(v.ExcludedUsersAndGroups, ok); err != nil {
			return err
		}
	}

	if v.IncludedUsersAndGroups != nil {
		ok := object.Key("includedUsersAndGroups")
		if err := awsRestjson1_serializeDocumentUsersAndGroups(v.IncludedUsersAndGroups, ok); err != nil {
			return err
		}
	}

	if v.RuleConfiguration != nil {
		ok := object.Key("ruleConfiguration")
		if err := awsRestjson1_serializeDocumentRuleConfiguration(v.RuleConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.RuleType) > 0 {
		ok := object.Key("ruleType")
		ok.String(string(v.RuleType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRuleConfiguration(v types.RuleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RuleConfigurationMemberContentBlockerRule:
		av := object.Key("contentBlockerRule")
		if err := awsRestjson1_serializeDocumentContentBlockerRule(&uv.Value, av); err != nil {
			return err
		}

	case *types.RuleConfigurationMemberContentRetrievalRule:
		av := object.Key("contentRetrievalRule")
		if err := awsRestjson1_serializeDocumentContentRetrievalRule(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRules(v []types.Rule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3(v *types.S3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentSamlConfiguration(v *types.SamlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetadataXML != nil {
		ok := object.Key("metadataXML")
		ok.String(*v.MetadataXML)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.UserGroupAttribute != nil {
		ok := object.Key("userGroupAttribute")
		ok.String(*v.UserGroupAttribute)
	}

	if v.UserIdAttribute != nil {
		ok := object.Key("userIdAttribute")
		ok.String(*v.UserIdAttribute)
	}

	return nil
}

func awsRestjson1_serializeDocumentSamlProviderConfiguration(v *types.SamlProviderConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationUrl != nil {
		ok := object.Key("authenticationUrl")
		ok.String(*v.AuthenticationUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringAttributeBoostingConfiguration(v *types.StringAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeValueBoosting != nil {
		ok := object.Key("attributeValueBoosting")
		if err := awsRestjson1_serializeDocumentStringAttributeValueBoosting(v.AttributeValueBoosting, ok); err != nil {
			return err
		}
	}

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentStringAttributeValueBoosting(v map[string]types.StringAttributeValueBoostingLevel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(string(v[key]))
	}
	return nil
}

func awsRestjson1_serializeDocumentStringListAttributeBoostingConfiguration(v *types.StringListAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubscriptionPrincipal(v types.SubscriptionPrincipal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SubscriptionPrincipalMemberGroup:
		av := object.Key("group")
		av.String(uv.Value)

	case *types.SubscriptionPrincipalMemberUser:
		av := object.Key("user")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTopicConfiguration(v *types.TopicConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExampleChatMessages != nil {
		ok := object.Key("exampleChatMessages")
		if err := awsRestjson1_serializeDocumentExampleChatMessages(v.ExampleChatMessages, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Rules != nil {
		ok := object.Key("rules")
		if err := awsRestjson1_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTopicConfigurations(v []types.TopicConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTopicConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUserAlias(v *types.UserAlias, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentUserAliases(v []types.UserAlias, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUserAlias(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUserGroups(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentUserIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentUsersAndGroups(v *types.UsersAndGroups, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserGroups != nil {
		ok := object.Key("userGroups")
		if err := awsRestjson1_serializeDocumentUserGroups(v.UserGroups, ok); err != nil {
			return err
		}
	}

	if v.UserIds != nil {
		ok := object.Key("userIds")
		if err := awsRestjson1_serializeDocumentUserIds(v.UserIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoExtractionConfiguration(v *types.VideoExtractionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.VideoExtractionStatus) > 0 {
		ok := object.Key("videoExtractionStatus")
		ok.String(string(v.VideoExtractionStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentWebExperienceAuthConfiguration(v types.WebExperienceAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.WebExperienceAuthConfigurationMemberSamlConfiguration:
		av := object.Key("samlConfiguration")
		if err := awsRestjson1_serializeDocumentSamlConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentWebExperienceOrigins(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}
