//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// AssessmentsMetadataServer is a fake server for instances of the armsecurity.AssessmentsMetadataClient type.
type AssessmentsMetadataServer struct {
	// CreateInSubscription is the fake for method AssessmentsMetadataClient.CreateInSubscription
	// HTTP status codes to indicate success: http.StatusOK
	CreateInSubscription func(ctx context.Context, assessmentMetadataName string, assessmentMetadata armsecurity.AssessmentMetadataResponse, options *armsecurity.AssessmentsMetadataClientCreateInSubscriptionOptions) (resp azfake.Responder[armsecurity.AssessmentsMetadataClientCreateInSubscriptionResponse], errResp azfake.ErrorResponder)

	// DeleteInSubscription is the fake for method AssessmentsMetadataClient.DeleteInSubscription
	// HTTP status codes to indicate success: http.StatusOK
	DeleteInSubscription func(ctx context.Context, assessmentMetadataName string, options *armsecurity.AssessmentsMetadataClientDeleteInSubscriptionOptions) (resp azfake.Responder[armsecurity.AssessmentsMetadataClientDeleteInSubscriptionResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AssessmentsMetadataClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, assessmentMetadataName string, options *armsecurity.AssessmentsMetadataClientGetOptions) (resp azfake.Responder[armsecurity.AssessmentsMetadataClientGetResponse], errResp azfake.ErrorResponder)

	// GetInSubscription is the fake for method AssessmentsMetadataClient.GetInSubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetInSubscription func(ctx context.Context, assessmentMetadataName string, options *armsecurity.AssessmentsMetadataClientGetInSubscriptionOptions) (resp azfake.Responder[armsecurity.AssessmentsMetadataClientGetInSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AssessmentsMetadataClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.AssessmentsMetadataClientListOptions) (resp azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListResponse])

	// NewListBySubscriptionPager is the fake for method AssessmentsMetadataClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armsecurity.AssessmentsMetadataClientListBySubscriptionOptions) (resp azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListBySubscriptionResponse])
}

// NewAssessmentsMetadataServerTransport creates a new instance of AssessmentsMetadataServerTransport with the provided implementation.
// The returned AssessmentsMetadataServerTransport instance is connected to an instance of armsecurity.AssessmentsMetadataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssessmentsMetadataServerTransport(srv *AssessmentsMetadataServer) *AssessmentsMetadataServerTransport {
	return &AssessmentsMetadataServerTransport{
		srv:                        srv,
		newListPager:               newTracker[azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListResponse]](),
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListBySubscriptionResponse]](),
	}
}

// AssessmentsMetadataServerTransport connects instances of armsecurity.AssessmentsMetadataClient to instances of AssessmentsMetadataServer.
// Don't use this type directly, use NewAssessmentsMetadataServerTransport instead.
type AssessmentsMetadataServerTransport struct {
	srv                        *AssessmentsMetadataServer
	newListPager               *tracker[azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListResponse]]
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armsecurity.AssessmentsMetadataClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for AssessmentsMetadataServerTransport.
func (a *AssessmentsMetadataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssessmentsMetadataClient.CreateInSubscription":
		resp, err = a.dispatchCreateInSubscription(req)
	case "AssessmentsMetadataClient.DeleteInSubscription":
		resp, err = a.dispatchDeleteInSubscription(req)
	case "AssessmentsMetadataClient.Get":
		resp, err = a.dispatchGet(req)
	case "AssessmentsMetadataClient.GetInSubscription":
		resp, err = a.dispatchGetInSubscription(req)
	case "AssessmentsMetadataClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AssessmentsMetadataClient.NewListBySubscriptionPager":
		resp, err = a.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchCreateInSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.CreateInSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateInSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/assessmentMetadata/(?P<assessmentMetadataName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.AssessmentMetadataResponse](req)
	if err != nil {
		return nil, err
	}
	assessmentMetadataNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assessmentMetadataName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateInSubscription(req.Context(), assessmentMetadataNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssessmentMetadataResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchDeleteInSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteInSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteInSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/assessmentMetadata/(?P<assessmentMetadataName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	assessmentMetadataNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assessmentMetadataName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteInSubscription(req.Context(), assessmentMetadataNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Security/assessmentMetadata/(?P<assessmentMetadataName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	assessmentMetadataNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assessmentMetadataName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), assessmentMetadataNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssessmentMetadataResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchGetInSubscription(req *http.Request) (*http.Response, error) {
	if a.srv.GetInSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetInSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/assessmentMetadata/(?P<assessmentMetadataName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	assessmentMetadataNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assessmentMetadataName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetInSubscription(req.Context(), assessmentMetadataNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssessmentMetadataResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.AssessmentsMetadataClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AssessmentsMetadataServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := a.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/assessmentMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		a.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armsecurity.AssessmentsMetadataClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		a.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
