#pragma once
/*
 *  $Id: module-file.h 28779 2025-11-04 17:00:29Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_MODULE_FILE_H__
#define __GWYAPP_MODULE_FILE_H__

#include <libgwyapp/module-loader.h>
#include <libgwyapp/file.h>

G_BEGIN_DECLS

#define GWY_FILE_DETECT_BUFFER_SIZE 4096U

#define GWY_MODULE_FILE_ERROR gwy_module_file_error_quark()

typedef enum {
    GWY_FILE_OPERATION_DETECT = 1 << 0,
    GWY_FILE_OPERATION_LOAD   = 1 << 1,
    GWY_FILE_OPERATION_SAVE   = 1 << 2,
    GWY_FILE_OPERATION_EXPORT = 1 << 3,
    GWY_FILE_OPERATION_MASK   = 0x0f
} GwyFileOperationType;

typedef enum {
    GWY_MODULE_FILE_ERROR_CANCELED,
    GWY_MODULE_FILE_ERROR_CANCELLED = GWY_MODULE_FILE_ERROR_CANCELED,
    GWY_MODULE_FILE_ERROR_UNIMPLEMENTED,
    GWY_MODULE_FILE_ERROR_IO,
    GWY_MODULE_FILE_ERROR_DATA,
    GWY_MODULE_FILE_ERROR_INTERACTIVE,
    GWY_MODULE_FILE_ERROR_SPECIFIC
} GwyModuleFileError;

typedef struct {
    const gchar *name;
    const gchar *name_lowercase;
    gsize file_size;
    guint buffer_len;
    const guchar *head;
    const guchar *tail;
} GwyFileDetectInfo;

typedef gint      (*GwyFileDetectFunc) (const GwyFileDetectInfo *fileinfo,
                                        gboolean only_name);
typedef GwyFile*  (*GwyFileLoadFunc)   (const gchar *filename,
                                        GwyRunModeFlags mode,
                                        GError **error);
typedef gboolean  (*GwyFileSaveFunc)   (GwyFile *file,
                                        const gchar *filename,
                                        GwyRunModeFlags mode,
                                        GError **error);

/* low-level interface */
gboolean             gwy_file_func_register         (const gchar *name,
                                                     const gchar *description,
                                                     GwyFileDetectFunc detect,
                                                     GwyFileLoadFunc load_file,
                                                     GwyFileSaveFunc save_file,
                                                     GwyFileSaveFunc export_file);
gint                 gwy_file_func_run_detect       (const gchar *name,
                                                     const gchar *filename,
                                                     gboolean only_name);
GwyFile*             gwy_file_func_run_load         (const gchar *name,
                                                     const gchar *filename,
                                                     GwyRunModeFlags mode,
                                                     GError **error);
gboolean             gwy_file_func_run_save         (const gchar *name,
                                                     GwyFile *file,
                                                     const gchar *filename,
                                                     GwyRunModeFlags mode,
                                                     GError **error);
gboolean             gwy_file_func_run_export       (const gchar *name,
                                                     GwyFile *file,
                                                     const gchar *filename,
                                                     GwyRunModeFlags mode,
                                                     GError **error);
gboolean             gwy_file_func_exists           (const gchar *name);
GwyFileOperationType gwy_file_func_get_operations   (const gchar *name);
const gchar*         gwy_file_func_get_description  (const gchar *name);
void                 gwy_file_func_foreach          (GwyNameFunc function,
                                                     gpointer user_data);
const gchar*         gwy_file_func_current          (void);
gboolean             gwy_file_func_get_is_detectable(const gchar *name);
void                 gwy_file_func_set_is_detectable(const gchar *name,
                                                     gboolean is_detectable);
gboolean             gwy_file_func_get_is_unfinished(const gchar *name);
void                 gwy_file_func_set_is_unfinished(const gchar *name,
                                                     gboolean is_unfinished);

/* high-level interface
 * TODO: perferably do not make these look like GwyFile methods – use verb naming? */
const gchar*         gwy_file_detect        (const gchar *filename,
                                             gboolean only_name,
                                             GwyFileOperationType operations,
                                             gint *score);
GwyFile*             gwy_file_load          (const gchar *filename,
                                             GwyRunModeFlags mode,
                                             GError **error);
GwyFile*             gwy_file_load_with_func(const gchar *filename,
                                             GwyRunModeFlags mode,
                                             const gchar **name,
                                             GError **error);
GwyFileOperationType gwy_file_save          (GwyFile *file,
                                             const gchar *filename,
                                             GwyRunModeFlags mode,
                                             GError **error);
GwyFileOperationType gwy_file_save_with_func(GwyFile *file,
                                             const gchar *filename,
                                             GwyRunModeFlags mode,
                                             const gchar **name,
                                             GError **error);

GQuark gwy_module_file_error_quark(void);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
