#pragma once
/*
 *  $Id: gradient.h 28293 2025-07-25 18:39:02Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GRADIENT_H__
#define __GWY_GRADIENT_H__

#include <glib-object.h>
#include <libgwyddion/resource.h>
#include <libgwyddion/rgba.h>

G_BEGIN_DECLS

#define GWY_GRADIENT_DEFAULT "Gray"

#define GWY_TYPE_GRADIENT            (gwy_gradient_get_type())
#define GWY_GRADIENT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRADIENT, GwyGradient))
#define GWY_GRADIENT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRADIENT, GwyGradientClass))
#define GWY_IS_GRADIENT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRADIENT))
#define GWY_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRADIENT))
#define GWY_GRADIENT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRADIENT, GwyGradientClass))

typedef struct _GwyGradient        GwyGradient;
typedef struct _GwyGradientClass   GwyGradientClass;
typedef struct _GwyGradientPrivate GwyGradientPrivate;

typedef struct {
    gdouble x;
    GwyRGBA color;
} GwyGradientPoint;

struct _GwyGradient {
    GwyResource parent_instance;
    GwyGradientPrivate *priv;
};

struct _GwyGradientClass {
    GwyResourceClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType                   gwy_gradient_get_type           (void)                            G_GNUC_CONST;
void                    gwy_gradient_get_color          (GwyGradient *gradient,
                                                         gdouble x,
                                                         GwyRGBA *color);
guchar*                 gwy_gradient_sample             (GwyGradient *gradient,
                                                         gint nsamples,
                                                         guchar *samples)                 G_GNUC_MALLOC;
gint                    gwy_gradient_get_npoints        (GwyGradient *gradient);
GwyGradientPoint        gwy_gradient_get_point          (GwyGradient *gradient,
                                                         gint i);
void                    gwy_gradient_set_point          (GwyGradient *gradient,
                                                         gint i,
                                                         const GwyGradientPoint *point);
void                    gwy_gradient_set_point_color    (GwyGradient *gradient,
                                                         gint i,
                                                         const GwyRGBA *color);
void                    gwy_gradient_insert_point       (GwyGradient *gradient,
                                                         gint i,
                                                         const GwyGradientPoint *point);
gint                    gwy_gradient_insert_point_sorted(GwyGradient *gradient,
                                                         const GwyGradientPoint *point);
void                    gwy_gradient_delete_point       (GwyGradient *gradient,
                                                         gint i);
void                    gwy_gradient_reset              (GwyGradient *gradient);
const GwyGradientPoint* gwy_gradient_get_points         (GwyGradient *gradient,
                                                         gint *npoints);
void                    gwy_gradient_set_points         (GwyGradient *gradient,
                                                         gint npoints,
                                                         const GwyGradientPoint *points);
void                    gwy_gradient_set_from_samples   (GwyGradient *gradient,
                                                         gint nsamples,
                                                         const guchar *samples,
                                                         gdouble threshold);

GwyInventory* gwy_gradients             (void)               G_GNUC_PURE;
GwyGradient*  gwy_gradients_get_gradient(const gchar *name);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
