#pragma once
/*
 *  $Id: grains-nield.h 28873 2025-11-18 14:59:29Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GRAINS_NIELD_H__
#define __GWY_GRAINS_NIELD_H__

#include <libgwyddion/nield.h>
#include <libgwyddion/field.h>
#include <libgwyddion/types.h>

#include <libgwyddion/grains.h>

G_BEGIN_DECLS

gboolean  gwy_nield_isolate                    (GwyNield *nield,
                                                gint number);
gboolean  gwy_nield_isolate_at                 (GwyNield *nield,
                                                gint col,
                                                gint row);
gboolean  gwy_nield_clear_at                   (GwyNield *nield,
                                                gint col,
                                                gint row);
void      gwy_nield_clear_by_number            (GwyNield *nield,
                                                gint number,
                                                gboolean compactify);
void      gwy_nield_clear_by_size              (GwyNield *nield,
                                                gint size);
void      gwy_nield_clear_touching_border      (GwyNield *nield,
                                                gboolean completely);
void      gwy_nield_mark_by_threshold          (GwyNield *nield,
                                                GwyField *field,
                                                gdouble lower,
                                                gdouble upper);
void      gwy_nield_union                      (GwyNield *nield,
                                                GwyNield *union_with);
void      gwy_nield_intersect                  (GwyNield *nield,
                                                GwyNield *intersect_with);
void      gwy_nield_invert                     (GwyNield *nield);
gboolean  gwy_nield_autocrop                   (GwyNield *nield,
                                                gboolean symmetrically,
                                                guint *left,
                                                guint *right,
                                                guint *up,
                                                guint *down);
gint      gwy_nield_compactify                 (GwyNield *nield);
void      gwy_nield_flatten                    (GwyNield *nield);
gint      gwy_nield_number_contiguous          (GwyNield *nield);
gint      gwy_nield_number_contiguous_periodic (GwyNield *nield);
gint      gwy_nield_split_noncontiguous        (GwyNield *nield);
gint*     gwy_nield_get_grain_numbers          (GwyNield *nield,
                                                gint *ngrains);
gint*     gwy_nield_get_bounding_boxes         (GwyNield *nield,
                                                gint *maxgno);
gint*     gwy_nield_get_bounding_boxes_periodic(GwyNield *nield,
                                                gint *maxgno);
gint*     gwy_nield_get_sizes                  (GwyNield *nield,
                                                gint *maxgno);
gint*     gwy_nield_get_inscribed_boxes        (GwyNield *nield,
                                                gint *maxgno);
gint*     gwy_nield_find_boundaries            (GwyNield *nield,
                                                gint *bindex,
                                                gboolean from_border);
gboolean  gwy_nield_fill_voids                 (GwyNield *nield,
                                                gboolean nonsimple);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
