/********************************************************************************
 *                                                                              *
 * This file is part of IfcOpenShell.                                           *
 *                                                                              *
 * IfcOpenShell is free software: you can redistribute it and/or modify         *
 * it under the terms of the Lesser GNU General Public License as published by  *
 * the Free Software Foundation, either version 3.0 of the License, or          *
 * (at your option) any later version.                                          *
 *                                                                              *
 * IfcOpenShell is distributed in the hope that it will be useful,              *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                 *
 * Lesser GNU General Public License for more details.                          *
 *                                                                              *
 * You should have received a copy of the Lesser GNU General Public License     *
 * along with this program. If not, see <http://www.gnu.org/licenses/>.         *
 *                                                                              *
 ********************************************************************************/

/********************************************************************************
 *                                                                              *
 * This file has been generated from IFC4x3_RC1.exp. Do not make modifications  *
 * but instead modify the python script that has been used to generate this.    *
 *                                                                              *
 ********************************************************************************/

#ifndef IFC4X3_RC1_H
#define IFC4X3_RC1_H

#include <string>
#include <vector>

#include <boost/optional.hpp>

#include "../ifcparse/ifc_parse_api.h"

#include "../ifcparse/aggregate_of_instance.h"
#include "../ifcparse/IfcBaseClass.h"
#include "../ifcparse/IfcSchema.h"
#include "../ifcparse/IfcException.h"
#include "../ifcparse/Argument.h"

struct Ifc4x3_rc1 {

IFC_PARSE_API static const IfcParse::schema_definition& get_schema();

IFC_PARSE_API static void clear_schema();

static const char* const Identifier;

// Forward definitions
class IfcActionRequest; class IfcActor; class IfcActorRole; class IfcActuator; class IfcActuatorType; class IfcAddress; class IfcAdvancedBrep; class IfcAdvancedBrepWithVoids; class IfcAdvancedFace; class IfcAirTerminal; class IfcAirTerminalBox; class IfcAirTerminalBoxType; class IfcAirTerminalType; class IfcAirToAirHeatRecovery; class IfcAirToAirHeatRecoveryType; class IfcAlarm; class IfcAlarmType; class IfcAlignment; class IfcAlignment2DCant; class IfcAlignment2DCantSegLine; class IfcAlignment2DCantSegTransition; class IfcAlignment2DCantSegment; class IfcAlignment2DHorizontal; class IfcAlignment2DHorizontalSegment; class IfcAlignment2DSegment; class IfcAlignment2DVerSegCircularArc; class IfcAlignment2DVerSegLine; class IfcAlignment2DVerSegParabolicArc; class IfcAlignment2DVerSegTransition; class IfcAlignment2DVertical; class IfcAlignment2DVerticalSegment; class IfcAlignmentCurve; class IfcAnnotation; class IfcAnnotationFillArea; class IfcApplication; class IfcAppliedValue; class IfcApproval; class IfcApprovalRelationship; class IfcArbitraryClosedProfileDef; class IfcArbitraryOpenProfileDef; class IfcArbitraryProfileDefWithVoids; class IfcAsset; class IfcAsymmetricIShapeProfileDef; class IfcAudioVisualAppliance; class IfcAudioVisualApplianceType; class IfcAxis1Placement; class IfcAxis2Placement2D; class IfcAxis2Placement3D; class IfcAxisLateralInclination; class IfcBSplineCurve; class IfcBSplineCurveWithKnots; class IfcBSplineSurface; class IfcBSplineSurfaceWithKnots; class IfcBeam; class IfcBeamStandardCase; class IfcBeamType; class IfcBearing; class IfcBearingType; class IfcBlobTexture; class IfcBlock; class IfcBoiler; class IfcBoilerType; class IfcBooleanClippingResult; class IfcBooleanResult; class IfcBorehole; class IfcBoundaryCondition; class IfcBoundaryCurve; class IfcBoundaryEdgeCondition; class IfcBoundaryFaceCondition; class IfcBoundaryNodeCondition; class IfcBoundaryNodeConditionWarping; class IfcBoundedCurve; class IfcBoundedSurface; class IfcBoundingBox; class IfcBoxedHalfSpace; class IfcBridge; class IfcBridgePart; class IfcBuilding; class IfcBuildingElementPart; class IfcBuildingElementPartType; class IfcBuildingElementProxy; class IfcBuildingElementProxyType; class IfcBuildingStorey; class IfcBuildingSystem; class IfcBuiltElement; class IfcBuiltElementType; class IfcBuiltSystem; class IfcBurner; class IfcBurnerType; class IfcCShapeProfileDef; class IfcCableCarrierFitting; class IfcCableCarrierFittingType; class IfcCableCarrierSegment; class IfcCableCarrierSegmentType; class IfcCableFitting; class IfcCableFittingType; class IfcCableSegment; class IfcCableSegmentType; class IfcCaissonFoundation; class IfcCaissonFoundationType; class IfcCartesianPoint; class IfcCartesianPointList; class IfcCartesianPointList2D; class IfcCartesianPointList3D; class IfcCartesianTransformationOperator; class IfcCartesianTransformationOperator2D; class IfcCartesianTransformationOperator2DnonUniform; class IfcCartesianTransformationOperator3D; class IfcCartesianTransformationOperator3DnonUniform; class IfcCenterLineProfileDef; class IfcChiller; class IfcChillerType; class IfcChimney; class IfcChimneyType; class IfcCircle; class IfcCircleHollowProfileDef; class IfcCircleProfileDef; class IfcCircularArcSegment2D; class IfcCivilElement; class IfcCivilElementType; class IfcClassification; class IfcClassificationReference; class IfcClosedShell; class IfcCoil; class IfcCoilType; class IfcColourRgb; class IfcColourRgbList; class IfcColourSpecification; class IfcColumn; class IfcColumnStandardCase; class IfcColumnType; class IfcCommunicationsAppliance; class IfcCommunicationsApplianceType; class IfcComplexProperty; class IfcComplexPropertyTemplate; class IfcCompositeCurve; class IfcCompositeCurveOnSurface; class IfcCompositeCurveSegment; class IfcCompositeProfileDef; class IfcCompressor; class IfcCompressorType; class IfcCondenser; class IfcCondenserType; class IfcConic; class IfcConnectedFaceSet; class IfcConnectionCurveGeometry; class IfcConnectionGeometry; class IfcConnectionPointEccentricity; class IfcConnectionPointGeometry; class IfcConnectionSurfaceGeometry; class IfcConnectionVolumeGeometry; class IfcConstraint; class IfcConstructionEquipmentResource; class IfcConstructionEquipmentResourceType; class IfcConstructionMaterialResource; class IfcConstructionMaterialResourceType; class IfcConstructionProductResource; class IfcConstructionProductResourceType; class IfcConstructionResource; class IfcConstructionResourceType; class IfcContext; class IfcContextDependentUnit; class IfcControl; class IfcController; class IfcControllerType; class IfcConversionBasedUnit; class IfcConversionBasedUnitWithOffset; class IfcConveyorSegment; class IfcConveyorSegmentType; class IfcCooledBeam; class IfcCooledBeamType; class IfcCoolingTower; class IfcCoolingTowerType; class IfcCoordinateOperation; class IfcCoordinateReferenceSystem; class IfcCostItem; class IfcCostSchedule; class IfcCostValue; class IfcCourse; class IfcCourseType; class IfcCovering; class IfcCoveringType; class IfcCrewResource; class IfcCrewResourceType; class IfcCsgPrimitive3D; class IfcCsgSolid; class IfcCurrencyRelationship; class IfcCurtainWall; class IfcCurtainWallType; class IfcCurve; class IfcCurveBoundedPlane; class IfcCurveBoundedSurface; class IfcCurveSegment2D; class IfcCurveStyle; class IfcCurveStyleFont; class IfcCurveStyleFontAndScaling; class IfcCurveStyleFontPattern; class IfcCylindricalSurface; class IfcDamper; class IfcDamperType; class IfcDeepFoundation; class IfcDeepFoundationType; class IfcDerivedProfileDef; class IfcDerivedUnit; class IfcDerivedUnitElement; class IfcDimensionalExponents; class IfcDirection; class IfcDirectrixCurveSweptAreaSolid; class IfcDirectrixDistanceSweptAreaSolid; class IfcDiscreteAccessory; class IfcDiscreteAccessoryType; class IfcDistanceExpression; class IfcDistributionBoard; class IfcDistributionBoardType; class IfcDistributionChamberElement; class IfcDistributionChamberElementType; class IfcDistributionCircuit; class IfcDistributionControlElement; class IfcDistributionControlElementType; class IfcDistributionElement; class IfcDistributionElementType; class IfcDistributionFlowElement; class IfcDistributionFlowElementType; class IfcDistributionPort; class IfcDistributionSystem; class IfcDocumentInformation; class IfcDocumentInformationRelationship; class IfcDocumentReference; class IfcDoor; class IfcDoorLiningProperties; class IfcDoorPanelProperties; class IfcDoorStandardCase; class IfcDoorStyle; class IfcDoorType; class IfcDraughtingPreDefinedColour; class IfcDraughtingPreDefinedCurveFont; class IfcDuctFitting; class IfcDuctFittingType; class IfcDuctSegment; class IfcDuctSegmentType; class IfcDuctSilencer; class IfcDuctSilencerType; class IfcEarthworksCut; class IfcEarthworksElement; class IfcEarthworksFill; class IfcEdge; class IfcEdgeCurve; class IfcEdgeLoop; class IfcElectricAppliance; class IfcElectricApplianceType; class IfcElectricDistributionBoard; class IfcElectricDistributionBoardType; class IfcElectricFlowStorageDevice; class IfcElectricFlowStorageDeviceType; class IfcElectricFlowTreatmentDevice; class IfcElectricFlowTreatmentDeviceType; class IfcElectricGenerator; class IfcElectricGeneratorType; class IfcElectricMotor; class IfcElectricMotorType; class IfcElectricTimeControl; class IfcElectricTimeControlType; class IfcElement; class IfcElementAssembly; class IfcElementAssemblyType; class IfcElementComponent; class IfcElementComponentType; class IfcElementQuantity; class IfcElementType; class IfcElementarySurface; class IfcEllipse; class IfcEllipseProfileDef; class IfcEnergyConversionDevice; class IfcEnergyConversionDeviceType; class IfcEngine; class IfcEngineType; class IfcEvaporativeCooler; class IfcEvaporativeCoolerType; class IfcEvaporator; class IfcEvaporatorType; class IfcEvent; class IfcEventTime; class IfcEventType; class IfcExtendedProperties; class IfcExternalInformation; class IfcExternalReference; class IfcExternalReferenceRelationship; class IfcExternalSpatialElement; class IfcExternalSpatialStructureElement; class IfcExternallyDefinedHatchStyle; class IfcExternallyDefinedSurfaceStyle; class IfcExternallyDefinedTextFont; class IfcExtrudedAreaSolid; class IfcExtrudedAreaSolidTapered; class IfcFace; class IfcFaceBasedSurfaceModel; class IfcFaceBound; class IfcFaceOuterBound; class IfcFaceSurface; class IfcFacetedBrep; class IfcFacetedBrepWithVoids; class IfcFacility; class IfcFacilityPart; class IfcFailureConnectionCondition; class IfcFan; class IfcFanType; class IfcFastener; class IfcFastenerType; class IfcFeatureElement; class IfcFeatureElementAddition; class IfcFeatureElementSubtraction; class IfcFillAreaStyle; class IfcFillAreaStyleHatching; class IfcFillAreaStyleTiles; class IfcFilter; class IfcFilterType; class IfcFireSuppressionTerminal; class IfcFireSuppressionTerminalType; class IfcFixedReferenceSweptAreaSolid; class IfcFlowController; class IfcFlowControllerType; class IfcFlowFitting; class IfcFlowFittingType; class IfcFlowInstrument; class IfcFlowInstrumentType; class IfcFlowMeter; class IfcFlowMeterType; class IfcFlowMovingDevice; class IfcFlowMovingDeviceType; class IfcFlowSegment; class IfcFlowSegmentType; class IfcFlowStorageDevice; class IfcFlowStorageDeviceType; class IfcFlowTerminal; class IfcFlowTerminalType; class IfcFlowTreatmentDevice; class IfcFlowTreatmentDeviceType; class IfcFooting; class IfcFootingType; class IfcFurnishingElement; class IfcFurnishingElementType; class IfcFurniture; class IfcFurnitureType; class IfcGeographicElement; class IfcGeographicElementType; class IfcGeometricCurveSet; class IfcGeometricRepresentationContext; class IfcGeometricRepresentationItem; class IfcGeometricRepresentationSubContext; class IfcGeometricSet; class IfcGeomodel; class IfcGeoslice; class IfcGeotechnicalAssembly; class IfcGeotechnicalElement; class IfcGeotechnicalStratum; class IfcGrid; class IfcGridAxis; class IfcGridPlacement; class IfcGroup; class IfcHalfSpaceSolid; class IfcHeatExchanger; class IfcHeatExchangerType; class IfcHumidifier; class IfcHumidifierType; class IfcIShapeProfileDef; class IfcImageTexture; class IfcImpactProtectionDevice; class IfcImpactProtectionDeviceType; class IfcInclinedReferenceSweptAreaSolid; class IfcIndexedColourMap; class IfcIndexedPolyCurve; class IfcIndexedPolygonalFace; class IfcIndexedPolygonalFaceWithVoids; class IfcIndexedTextureMap; class IfcIndexedTriangleTextureMap; class IfcInterceptor; class IfcInterceptorType; class IfcIntersectionCurve; class IfcInventory; class IfcIrregularTimeSeries; class IfcIrregularTimeSeriesValue; class IfcJunctionBox; class IfcJunctionBoxType; class IfcKerb; class IfcKerbType; class IfcLShapeProfileDef; class IfcLaborResource; class IfcLaborResourceType; class IfcLagTime; class IfcLamp; class IfcLampType; class IfcLibraryInformation; class IfcLibraryReference; class IfcLightDistributionData; class IfcLightFixture; class IfcLightFixtureType; class IfcLightIntensityDistribution; class IfcLightSource; class IfcLightSourceAmbient; class IfcLightSourceDirectional; class IfcLightSourceGoniometric; class IfcLightSourcePositional; class IfcLightSourceSpot; class IfcLine; class IfcLineSegment2D; class IfcLinearAxisWithInclination; class IfcLinearPlacement; class IfcLinearPlacementWithInclination; class IfcLinearPositioningElement; class IfcLinearSpanPlacement; class IfcLiquidTerminal; class IfcLiquidTerminalType; class IfcLocalPlacement; class IfcLoop; class IfcManifoldSolidBrep; class IfcMapConversion; class IfcMappedItem; class IfcMarineFacility; class IfcMaterial; class IfcMaterialClassificationRelationship; class IfcMaterialConstituent; class IfcMaterialConstituentSet; class IfcMaterialDefinition; class IfcMaterialDefinitionRepresentation; class IfcMaterialLayer; class IfcMaterialLayerSet; class IfcMaterialLayerSetUsage; class IfcMaterialLayerWithOffsets; class IfcMaterialList; class IfcMaterialProfile; class IfcMaterialProfileSet; class IfcMaterialProfileSetUsage; class IfcMaterialProfileSetUsageTapering; class IfcMaterialProfileWithOffsets; class IfcMaterialProperties; class IfcMaterialRelationship; class IfcMaterialUsageDefinition; class IfcMeasureWithUnit; class IfcMechanicalFastener; class IfcMechanicalFastenerType; class IfcMedicalDevice; class IfcMedicalDeviceType; class IfcMember; class IfcMemberStandardCase; class IfcMemberType; class IfcMetric; class IfcMirroredProfileDef; class IfcMobileTelecommunicationsAppliance; class IfcMobileTelecommunicationsApplianceType; class IfcMonetaryUnit; class IfcMooringDevice; class IfcMooringDeviceType; class IfcMotorConnection; class IfcMotorConnectionType; class IfcNamedUnit; class IfcNavigationElement; class IfcNavigationElementType; class IfcObject; class IfcObjectDefinition; class IfcObjectPlacement; class IfcObjective; class IfcOccupant; class IfcOffsetCurve; class IfcOffsetCurve2D; class IfcOffsetCurve3D; class IfcOffsetCurveByDistances; class IfcOpenCrossProfileDef; class IfcOpenShell; class IfcOpeningElement; class IfcOpeningStandardCase; class IfcOrganization; class IfcOrganizationRelationship; class IfcOrientationExpression; class IfcOrientedEdge; class IfcOuterBoundaryCurve; class IfcOutlet; class IfcOutletType; class IfcOwnerHistory; class IfcParameterizedProfileDef; class IfcPath; class IfcPavement; class IfcPavementType; class IfcPcurve; class IfcPerformanceHistory; class IfcPermeableCoveringProperties; class IfcPermit; class IfcPerson; class IfcPersonAndOrganization; class IfcPhysicalComplexQuantity; class IfcPhysicalQuantity; class IfcPhysicalSimpleQuantity; class IfcPile; class IfcPileType; class IfcPipeFitting; class IfcPipeFittingType; class IfcPipeSegment; class IfcPipeSegmentType; class IfcPixelTexture; class IfcPlacement; class IfcPlanarBox; class IfcPlanarExtent; class IfcPlane; class IfcPlant; class IfcPlate; class IfcPlateStandardCase; class IfcPlateType; class IfcPoint; class IfcPointOnCurve; class IfcPointOnSurface; class IfcPolyLoop; class IfcPolygonalBoundedHalfSpace; class IfcPolygonalFaceSet; class IfcPolyline; class IfcPort; class IfcPositioningElement; class IfcPostalAddress; class IfcPreDefinedColour; class IfcPreDefinedCurveFont; class IfcPreDefinedItem; class IfcPreDefinedProperties; class IfcPreDefinedPropertySet; class IfcPreDefinedTextFont; class IfcPresentationItem; class IfcPresentationLayerAssignment; class IfcPresentationLayerWithStyle; class IfcPresentationStyle; class IfcPresentationStyleAssignment; class IfcProcedure; class IfcProcedureType; class IfcProcess; class IfcProduct; class IfcProductDefinitionShape; class IfcProductRepresentation; class IfcProfileDef; class IfcProfileProperties; class IfcProject; class IfcProjectLibrary; class IfcProjectOrder; class IfcProjectedCRS; class IfcProjectionElement; class IfcProperty; class IfcPropertyAbstraction; class IfcPropertyBoundedValue; class IfcPropertyDefinition; class IfcPropertyDependencyRelationship; class IfcPropertyEnumeratedValue; class IfcPropertyEnumeration; class IfcPropertyListValue; class IfcPropertyReferenceValue; class IfcPropertySet; class IfcPropertySetDefinition; class IfcPropertySetTemplate; class IfcPropertySingleValue; class IfcPropertyTableValue; class IfcPropertyTemplate; class IfcPropertyTemplateDefinition; class IfcProtectiveDevice; class IfcProtectiveDeviceTrippingUnit; class IfcProtectiveDeviceTrippingUnitType; class IfcProtectiveDeviceType; class IfcProxy; class IfcPump; class IfcPumpType; class IfcQuantityArea; class IfcQuantityCount; class IfcQuantityLength; class IfcQuantitySet; class IfcQuantityTime; class IfcQuantityVolume; class IfcQuantityWeight; class IfcRail; class IfcRailType; class IfcRailing; class IfcRailingType; class IfcRailway; class IfcRamp; class IfcRampFlight; class IfcRampFlightType; class IfcRampType; class IfcRationalBSplineCurveWithKnots; class IfcRationalBSplineSurfaceWithKnots; class IfcRectangleHollowProfileDef; class IfcRectangleProfileDef; class IfcRectangularPyramid; class IfcRectangularTrimmedSurface; class IfcRecurrencePattern; class IfcReference; class IfcReferent; class IfcRegularTimeSeries; class IfcReinforcedSoil; class IfcReinforcementBarProperties; class IfcReinforcementDefinitionProperties; class IfcReinforcingBar; class IfcReinforcingBarType; class IfcReinforcingElement; class IfcReinforcingElementType; class IfcReinforcingMesh; class IfcReinforcingMeshType; class IfcRelAggregates; class IfcRelAssigns; class IfcRelAssignsToActor; class IfcRelAssignsToControl; class IfcRelAssignsToGroup; class IfcRelAssignsToGroupByFactor; class IfcRelAssignsToProcess; class IfcRelAssignsToProduct; class IfcRelAssignsToResource; class IfcRelAssociates; class IfcRelAssociatesApproval; class IfcRelAssociatesClassification; class IfcRelAssociatesConstraint; class IfcRelAssociatesDocument; class IfcRelAssociatesLibrary; class IfcRelAssociatesMaterial; class IfcRelAssociatesProfileDef; class IfcRelConnects; class IfcRelConnectsElements; class IfcRelConnectsPathElements; class IfcRelConnectsPortToElement; class IfcRelConnectsPorts; class IfcRelConnectsStructuralActivity; class IfcRelConnectsStructuralMember; class IfcRelConnectsWithEccentricity; class IfcRelConnectsWithRealizingElements; class IfcRelContainedInSpatialStructure; class IfcRelCoversBldgElements; class IfcRelCoversSpaces; class IfcRelDeclares; class IfcRelDecomposes; class IfcRelDefines; class IfcRelDefinesByObject; class IfcRelDefinesByProperties; class IfcRelDefinesByTemplate; class IfcRelDefinesByType; class IfcRelFillsElement; class IfcRelFlowControlElements; class IfcRelInterferesElements; class IfcRelNests; class IfcRelPositions; class IfcRelProjectsElement; class IfcRelReferencedInSpatialStructure; class IfcRelSequence; class IfcRelServicesBuildings; class IfcRelSpaceBoundary; class IfcRelSpaceBoundary1stLevel; class IfcRelSpaceBoundary2ndLevel; class IfcRelVoidsElement; class IfcRelationship; class IfcReparametrisedCompositeCurveSegment; class IfcRepresentation; class IfcRepresentationContext; class IfcRepresentationItem; class IfcRepresentationMap; class IfcResource; class IfcResourceApprovalRelationship; class IfcResourceConstraintRelationship; class IfcResourceLevelRelationship; class IfcResourceTime; class IfcRevolvedAreaSolid; class IfcRevolvedAreaSolidTapered; class IfcRightCircularCone; class IfcRightCircularCylinder; class IfcRoad; class IfcRoof; class IfcRoofType; class IfcRoot; class IfcRoundedRectangleProfileDef; class IfcSIUnit; class IfcSanitaryTerminal; class IfcSanitaryTerminalType; class IfcSchedulingTime; class IfcSeamCurve; class IfcSectionProperties; class IfcSectionReinforcementProperties; class IfcSectionedSolid; class IfcSectionedSolidHorizontal; class IfcSectionedSpine; class IfcSectionedSurface; class IfcSensor; class IfcSensorType; class IfcShadingDevice; class IfcShadingDeviceType; class IfcShapeAspect; class IfcShapeModel; class IfcShapeRepresentation; class IfcShellBasedSurfaceModel; class IfcSign; class IfcSignType; class IfcSignal; class IfcSignalType; class IfcSimpleProperty; class IfcSimplePropertyTemplate; class IfcSite; class IfcSlab; class IfcSlabElementedCase; class IfcSlabStandardCase; class IfcSlabType; class IfcSlippageConnectionCondition; class IfcSolarDevice; class IfcSolarDeviceType; class IfcSolidModel; class IfcSolidStratum; class IfcSpace; class IfcSpaceHeater; class IfcSpaceHeaterType; class IfcSpaceType; class IfcSpatialElement; class IfcSpatialElementType; class IfcSpatialStructureElement; class IfcSpatialStructureElementType; class IfcSpatialZone; class IfcSpatialZoneType; class IfcSphere; class IfcSphericalSurface; class IfcStackTerminal; class IfcStackTerminalType; class IfcStair; class IfcStairFlight; class IfcStairFlightType; class IfcStairType; class IfcStructuralAction; class IfcStructuralActivity; class IfcStructuralAnalysisModel; class IfcStructuralConnection; class IfcStructuralConnectionCondition; class IfcStructuralCurveAction; class IfcStructuralCurveConnection; class IfcStructuralCurveMember; class IfcStructuralCurveMemberVarying; class IfcStructuralCurveReaction; class IfcStructuralItem; class IfcStructuralLinearAction; class IfcStructuralLoad; class IfcStructuralLoadCase; class IfcStructuralLoadConfiguration; class IfcStructuralLoadGroup; class IfcStructuralLoadLinearForce; class IfcStructuralLoadOrResult; class IfcStructuralLoadPlanarForce; class IfcStructuralLoadSingleDisplacement; class IfcStructuralLoadSingleDisplacementDistortion; class IfcStructuralLoadSingleForce; class IfcStructuralLoadSingleForceWarping; class IfcStructuralLoadStatic; class IfcStructuralLoadTemperature; class IfcStructuralMember; class IfcStructuralPlanarAction; class IfcStructuralPointAction; class IfcStructuralPointConnection; class IfcStructuralPointReaction; class IfcStructuralReaction; class IfcStructuralResultGroup; class IfcStructuralSurfaceAction; class IfcStructuralSurfaceConnection; class IfcStructuralSurfaceMember; class IfcStructuralSurfaceMemberVarying; class IfcStructuralSurfaceReaction; class IfcStyleModel; class IfcStyledItem; class IfcStyledRepresentation; class IfcSubContractResource; class IfcSubContractResourceType; class IfcSubedge; class IfcSurface; class IfcSurfaceCurve; class IfcSurfaceCurveSweptAreaSolid; class IfcSurfaceFeature; class IfcSurfaceOfLinearExtrusion; class IfcSurfaceOfRevolution; class IfcSurfaceReinforcementArea; class IfcSurfaceStyle; class IfcSurfaceStyleLighting; class IfcSurfaceStyleRefraction; class IfcSurfaceStyleRendering; class IfcSurfaceStyleShading; class IfcSurfaceStyleWithTextures; class IfcSurfaceTexture; class IfcSweptAreaSolid; class IfcSweptDiskSolid; class IfcSweptDiskSolidPolygonal; class IfcSweptSurface; class IfcSwitchingDevice; class IfcSwitchingDeviceType; class IfcSystem; class IfcSystemFurnitureElement; class IfcSystemFurnitureElementType; class IfcTShapeProfileDef; class IfcTable; class IfcTableColumn; class IfcTableRow; class IfcTank; class IfcTankType; class IfcTask; class IfcTaskTime; class IfcTaskTimeRecurring; class IfcTaskType; class IfcTelecomAddress; class IfcTendon; class IfcTendonAnchor; class IfcTendonAnchorType; class IfcTendonConduit; class IfcTendonConduitType; class IfcTendonType; class IfcTessellatedFaceSet; class IfcTessellatedItem; class IfcTextLiteral; class IfcTextLiteralWithExtent; class IfcTextStyle; class IfcTextStyleFontModel; class IfcTextStyleForDefinedFont; class IfcTextStyleTextModel; class IfcTextureCoordinate; class IfcTextureCoordinateGenerator; class IfcTextureMap; class IfcTextureVertex; class IfcTextureVertexList; class IfcTimePeriod; class IfcTimeSeries; class IfcTimeSeriesValue; class IfcTopologicalRepresentationItem; class IfcTopologyRepresentation; class IfcToroidalSurface; class IfcTrackElement; class IfcTrackElementType; class IfcTransformer; class IfcTransformerType; class IfcTransitionCurveSegment2D; class IfcTransportElement; class IfcTransportElementType; class IfcTrapeziumProfileDef; class IfcTriangulatedFaceSet; class IfcTriangulatedIrregularNetwork; class IfcTrimmedCurve; class IfcTubeBundle; class IfcTubeBundleType; class IfcTypeObject; class IfcTypeProcess; class IfcTypeProduct; class IfcTypeResource; class IfcUShapeProfileDef; class IfcUnitAssignment; class IfcUnitaryControlElement; class IfcUnitaryControlElementType; class IfcUnitaryEquipment; class IfcUnitaryEquipmentType; class IfcValve; class IfcValveType; class IfcVector; class IfcVertex; class IfcVertexLoop; class IfcVertexPoint; class IfcVibrationDamper; class IfcVibrationDamperType; class IfcVibrationIsolator; class IfcVibrationIsolatorType; class IfcVirtualElement; class IfcVirtualGridIntersection; class IfcVoidStratum; class IfcVoidingFeature; class IfcWall; class IfcWallElementedCase; class IfcWallStandardCase; class IfcWallType; class IfcWasteTerminal; class IfcWasteTerminalType; class IfcWaterStratum; class IfcWindow; class IfcWindowLiningProperties; class IfcWindowPanelProperties; class IfcWindowStandardCase; class IfcWindowStyle; class IfcWindowType; class IfcWorkCalendar; class IfcWorkControl; class IfcWorkPlan; class IfcWorkSchedule; class IfcWorkTime; class IfcZShapeProfileDef; class IfcZone; class IfcAbsorbedDoseMeasure; class IfcAccelerationMeasure; class IfcAmountOfSubstanceMeasure; class IfcAngularVelocityMeasure; class IfcArcIndex; class IfcAreaDensityMeasure; class IfcAreaMeasure; class IfcBinary; class IfcBoolean; class IfcBoxAlignment; class IfcCardinalPointReference; class IfcComplexNumber; class IfcCompoundPlaneAngleMeasure; class IfcContextDependentMeasure; class IfcCountMeasure; class IfcCurvatureMeasure; class IfcDate; class IfcDateTime; class IfcDayInMonthNumber; class IfcDayInWeekNumber; class IfcDescriptiveMeasure; class IfcDimensionCount; class IfcDoseEquivalentMeasure; class IfcDuration; class IfcDynamicViscosityMeasure; class IfcElectricCapacitanceMeasure; class IfcElectricChargeMeasure; class IfcElectricConductanceMeasure; class IfcElectricCurrentMeasure; class IfcElectricResistanceMeasure; class IfcElectricVoltageMeasure; class IfcEnergyMeasure; class IfcFontStyle; class IfcFontVariant; class IfcFontWeight; class IfcForceMeasure; class IfcFrequencyMeasure; class IfcGloballyUniqueId; class IfcHeatFluxDensityMeasure; class IfcHeatingValueMeasure; class IfcIdentifier; class IfcIlluminanceMeasure; class IfcInductanceMeasure; class IfcInteger; class IfcIntegerCountRateMeasure; class IfcIonConcentrationMeasure; class IfcIsothermalMoistureCapacityMeasure; class IfcKinematicViscosityMeasure; class IfcLabel; class IfcLanguageId; class IfcLengthMeasure; class IfcLineIndex; class IfcLinearForceMeasure; class IfcLinearMomentMeasure; class IfcLinearStiffnessMeasure; class IfcLinearVelocityMeasure; class IfcLogical; class IfcLuminousFluxMeasure; class IfcLuminousIntensityDistributionMeasure; class IfcLuminousIntensityMeasure; class IfcMagneticFluxDensityMeasure; class IfcMagneticFluxMeasure; class IfcMassDensityMeasure; class IfcMassFlowRateMeasure; class IfcMassMeasure; class IfcMassPerLengthMeasure; class IfcModulusOfElasticityMeasure; class IfcModulusOfLinearSubgradeReactionMeasure; class IfcModulusOfRotationalSubgradeReactionMeasure; class IfcModulusOfSubgradeReactionMeasure; class IfcMoistureDiffusivityMeasure; class IfcMolecularWeightMeasure; class IfcMomentOfInertiaMeasure; class IfcMonetaryMeasure; class IfcMonthInYearNumber; class IfcNonNegativeLengthMeasure; class IfcNormalisedRatioMeasure; class IfcNumericMeasure; class IfcPHMeasure; class IfcParameterValue; class IfcPlanarForceMeasure; class IfcPlaneAngleMeasure; class IfcPositiveInteger; class IfcPositiveLengthMeasure; class IfcPositivePlaneAngleMeasure; class IfcPositiveRatioMeasure; class IfcPowerMeasure; class IfcPresentableText; class IfcPressureMeasure; class IfcPropertySetDefinitionSet; class IfcRadioActivityMeasure; class IfcRatioMeasure; class IfcReal; class IfcRotationalFrequencyMeasure; class IfcRotationalMassMeasure; class IfcRotationalStiffnessMeasure; class IfcSectionModulusMeasure; class IfcSectionalAreaIntegralMeasure; class IfcShearModulusMeasure; class IfcSolidAngleMeasure; class IfcSoundPowerLevelMeasure; class IfcSoundPowerMeasure; class IfcSoundPressureLevelMeasure; class IfcSoundPressureMeasure; class IfcSpecificHeatCapacityMeasure; class IfcSpecularExponent; class IfcSpecularRoughness; class IfcTemperatureGradientMeasure; class IfcTemperatureRateOfChangeMeasure; class IfcText; class IfcTextAlignment; class IfcTextDecoration; class IfcTextFontName; class IfcTextTransformation; class IfcThermalAdmittanceMeasure; class IfcThermalConductivityMeasure; class IfcThermalExpansionCoefficientMeasure; class IfcThermalResistanceMeasure; class IfcThermalTransmittanceMeasure; class IfcThermodynamicTemperatureMeasure; class IfcTime; class IfcTimeMeasure; class IfcTimeStamp; class IfcTorqueMeasure; class IfcURIReference; class IfcVaporPermeabilityMeasure; class IfcVolumeMeasure; class IfcVolumetricFlowRateMeasure; class IfcWarpingConstantMeasure; class IfcWarpingMomentMeasure; 

/// The actor select type allows a person, or an organization, or a person associated with an organization to be referenced.
/// 
/// NOTE Corresponds to the following entity in ISO 10303-41: person_organization_select.
/// 
/// HISTORY New entity in IFC Release 1.5.1
/// 
/// SELECT 
/// 
/// IfcOrganization An organization. 
/// IfcPerson A person. 
/// IfcPersonAndOrganization A person related to an organization.
class IFC_PARSE_API IfcActorSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcActorSelect > list;
};
/// IfcAppliedValueSelect defines the selection of whether a value (expressed as a ratio) or an amount should be used as the value for an IfcAppliedValue. 
/// 
/// Select from:  
/// 
/// IfcMeasureWithUnit 
///   IfcMonetaryMeasure 
///   IfcRatioMeasure 
/// 
/// HISTORY: New SELECT type in IFC 2x2.
/// 
/// Use definitions 
/// Selecting IfcMeasureWithUnit allows the specification of both the actual figure for the value together with the currency in which the value is represented. 
/// Selecting IfcMonetaryMeasure allows the specification only of the value, the currency being as set by the global context 
/// Selecting IfcRatioMeasure assumes that the amount is a percentage or other REAL number. Note that if the amount is normally specified as -20%, then this figure will need to be converted to a multiplier of 0.8
class IFC_PARSE_API IfcAppliedValueSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcAppliedValueSelect > list;
};
/// Definition from ISO/CD 10303-42:1992: This select type collects together both versions of the placement as used in two dimensional or in three dimensional Cartesian space. This enables entities requiring this information to reference them without specifying the space dimensionality.  
/// 
/// NOTE: Corresponding STEP type: axis2_placement, please refer to ISO/IS 10303-42:1994, p. 19 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC Release 1.5
class IFC_PARSE_API IfcAxis2Placement : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcAxis2Placement > list;
};
/// Definition from IAI: A select type for selecting between simple measure types for reinforcement bending parameters.
/// 
/// HISTORY New type in IFC Release 2x4
class IFC_PARSE_API IfcBendingParameterSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcBendingParameterSelect > list;
};
/// Definition from ISO/CD 10303-42:1992: This select type identifies
///   all those types of entities which may participate in a Boolean operation to
///   form a CSG solid.  
///   Definition from IAI: CSG primitives are out of scope for the
///   current IFC Release. Only faceted B-reps, swept area solids and half space
///   solids are available as Boolean operands. Boolean results themselves can be used
///   as operands thus enabling nested Boolean operations. 
/// 
/// NOTE Corresponding STEP type:
///   boolean_operand, please refer to ISO/IS 10303-42:1994, p.167 for the final
///   definition of the formal standard. In IFC Release 1.5.1 & 2.0 only Boolean
///   results (IfcBooleanResult), half space solids
///   (IfcHalfSpaceSolid), faceted B-Rep, extruded solids and revolved solids
///   (IfcSolidModel) are defined for being valid Boolean operands.
/// 
/// HISTORY: New Type in IFC Release 1.5.1
class IFC_PARSE_API IfcBooleanOperand : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcBooleanOperand > list;
};
/// IfcClassificationReferenceSelect enables selection of whether a classification reference is a subset of another classification reference or is a top level entry of a classification source. 
/// 
/// HISTORY: New Select Type in IFC2x
/// 
/// Select From: 
/// 
/// IfcClassification (for classification information)  
/// IfcClassificationReference (for reference into a classification source)
class IFC_PARSE_API IfcClassificationReferenceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcClassificationReferenceSelect > list;
};
/// IfcClassificationSelect enables selection of whether a classification reference is to be referenced from an external source, or whether a classification is referenced as such.
/// 
/// NOTE  Generally, it is expected that selection will be by IfcClassificationReference to identify an individual classification notation that classifies an element in the building information model. For example an element, such as IfcTank, might be further classified by assigning an IfcClassificationReference with Identification = "L6814" and a ClassificationSource identifying the appropriate version of Uniclass.  IfcClassification should only be selected in
/// circumstances where there could be a need to indicate the classification system that will be used without associating a notation or reference to an individual object. This may occur for higher level objects such as IfcProject, IfcSystem, or similar. For example an IfcStructuralAnalysisModel might be classified to be applicable to a particular version of EuroCode.
/// 
/// HISTORY  New select type in IFC2x
/// 
/// IFC2x4 CHANGE  Select renamed from IfcClassificationNotationSelect.
/// 
/// Select from:
/// 
/// IfcClassification (for referencing a classification system)
/// IfcClassificationReference (for referencing a classification item (or facet) inside a classification system)
class IFC_PARSE_API IfcClassificationSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcClassificationSelect > list;
};
/// Definition from ISO/CD 10303-46:1992: The colour entity defines a basic appearance of elements which shall be visualized in a picture.
/// 
/// NOTE  Corresponding STEP name: colour. It has been made into a SELECT type in IFC to avoid multiple inheritance for pre defined colour. Please refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcColour : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcColour > list;
};
/// The IfcColourOrFactor enables the selection of either a RGB colour value or a scalar factor value for the use as values of the reflectance components.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcColourOrFactor : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcColourOrFactor > list;
};
/// IfcCoordinateReferenceSystemSelect is a select between either the local engineering coordinate system, represented by the IfcGeometricRepresentationContext, or another coordinate reference system, represented by IfcCoordinateReferenceSystem, to be the source of a coordinate operation.
/// 
/// HISTORY  New select type in IFC2x4.
class IFC_PARSE_API IfcCoordinateReferenceSystemSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCoordinateReferenceSystemSelect > list;
};
/// Definition from ISO/CD 10303-42:1992: This type identifies the types of entity which may be selected as the root of a CSG tree including a single CSG primitive as a special case.
/// Definition from IAI: The IfcBooleanResult, and subtypes of IfcCsgPrimitive3D are defined as potential root tree expression (at IfcCsgSolid). A subtype of IfcCsgPrimitive3D marks the special case of a CSG solid solely expressed by a single primitive.
/// 
/// NOTE Corresponding ISO 10303-42 type: csg_select, please refer to ISO/IS 10303-42:1994, p.168 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5.1.
class IFC_PARSE_API IfcCsgSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCsgSelect > list;
};
/// Definition from ISO/CD 10303-46:1992: The curve font or scaled curve font select is a selection of either a curve font style select (being either a predefined curve font or an explicitly defined curve font) or a curve style font and scaling. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_font_or_scaled_curve_font_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcCurveFontOrScaledCurveFontSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCurveFontOrScaledCurveFontSelect > list;
};

class IFC_PARSE_API IfcCurveOnSurface : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCurveOnSurface > list;
};
/// IfcCurveOrEdgeCurve provides the option to either select a geometric curve (IfcCurve
/// and subtypes) within a geometric model, or a curve with associated geometry and coordinates (IfcEdgeCurve) within a topological model.
/// SELECT 
/// 
/// IfcCurve
///   IfcEdgeCurve
/// 
/// HISTORY  New select type in IFC2x Edition 3.
class IFC_PARSE_API IfcCurveOrEdgeCurve : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCurveOrEdgeCurve > list;
};
/// Definition from ISO/CD 10303-46:1992: The curve style font select is a selection of a curve style font or a predefined curve style font. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_style_font_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFontSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcCurveStyleFontSelect > list;
};
/// IfcDefinitionSelectprovides the option to either select an object or type object IfcObjectDefinition, or a property set template or property set, IfcPropertyDefinition.
/// SELECT
/// 
/// IfcObjectDefinition,
/// IfcPropertyDefinition
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcDefinitionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcDefinitionSelect > list;
};
/// IfcDerivedMeasureValue is a select type for selecting between derived measure types.
/// 
/// SELECT 
/// 
/// IfcAbsorbedDoseMeasure 
///   IfcAccelerationMeasure 
///   IfcAngularVelocityMeasure 
///   IfcCompoundPlaneAngleMeasure 
///   IfcDoseEquivalentMeasure 
///   IfcDynamicViscosityMeasure 
///   IfcElectricCapacitanceMeasure 
///   IfcElectricChargeMeasure 
///   IfcElectricConductanceMeasure 
///   IfcElectricResistanceMeasure 
///   IfcElectricVoltageMeasure 
///   IfcEnergyMeasure 
///   IfcForceMeasure 
///   IfcFrequencyMeasure 
///   IfcHeatFluxDensityMeasure 
///   IfcIlluminanceMeasure 
///   IfcInductanceMeasure 
///   IfcIntegerCountRateMeasure 
///   IfcIsothermalMoisturecapacityMeasure 
///   IfcKinematicViscosityMeasure 
///   IfcLinearForceMeasure 
///   IfcLinearMomentMeasure  
///   IfcLinearStiffnessMeasure 
///   IfcLinearVelocityMeasure 
///   IfcLuminousFluxMeasure 
///   IfcMagneticFluxDensityMeasure 
///   IfcMagneticFluxMeasure 
///   IfcMassDensityMeasure 
///   IfcMassFlowRateMeasure 
///   IfcModulusOfElasticityMeasure 
///   IfcModulusOfSubgradeReactionMeasure 
///   IfcMoistureDiffusivityMeasure 
///   IfcMolecularWeightMeasure 
///   IfcMomentOfInertiaMeasure  
///   IfcMonetaryMeasure 
///   IfcPlanarForceMeasure 
///   IfcPowerMeasure 
///   IfcPressureMeasure 
///   IfcRadioActivityMeasure 
///   IfcRotationalFrequencyMeasure 
///   IfcRotationalStiffnessMeasure 
///   IfcShearModulusMeasure 
///   IfcSpecificHeatCapacityMeasure 
///   IfcThermalAdmittanceMeasure 
///   IfcThermalConductivityMeasure 
///   IfcThermalResistanceMeasure 
///   IfcThermalTransmittanceMeasure 
///   IfcTimeStamp 
///   IfcTorqueMeasure 
///   IfcVaporPermeabilityMeasure 
///   IfcVolumetricFlowRateMeasure 
///   IfcCurvatureMeasure 
///   IfcMassPerLengthMeasure 
///   IfcRotationalMassMeasure 
///   IfcSectionalAreaIntegralMeasure 
///   IfcSectionModulusMeasure 
///   IfcTemperatureGradientMeasure 
///   IfcTemperatureRateOfChangeMeasure 
///   IfcWarpingConstantMeasure 
///   IfcWarpingMomentMeasure 
///   IfcThermalExpansionCoefficientMeasure 
///   IfcModulusOfLinearSubgradeReactionMeasure 
///   IfcModulusOfRotationalSubgradeReactionMeasure 
///   IfcLuminousIntensityDistributionMeasure 
///   IfcSoundPowerMeasure 
///   IfcSoundPressureMeasure 
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// IFC2x4 change: added IfcTemperatureRateOfChangeMeasure.
class IFC_PARSE_API IfcDerivedMeasureValue : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcDerivedMeasureValue > list;
};
/// IfcDocumentSelect enables selection of whether document information is to be contained within an IFC model or is to be referenced from an external source. 
/// 
/// HISTORY: New Select Type in IFC 2x
/// 
/// Select From: 
/// 
/// IfcDocumentInformation (for "metadata" of an external document)  
/// IfcDocumentReference (for reference within a document)
class IFC_PARSE_API IfcDocumentSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcDocumentSelect > list;
};

class IFC_PARSE_API IfcFacilityPartTypeSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcFacilityPartTypeSelect > list;
};
/// Definition from ISO/CD 10303-46:1992: The fill style select is a selection between different fill area styles.
/// 
/// NOTE Corresponding ISO 10303 name: fill_style_select. Please refer to ISO/IS 10303-46:1994 for
/// the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcFillStyleSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcFillStyleSelect > list;
};
/// Definition from ISO/CD 10303-42:1992: This select type identifies the types of entities which can occur in a geometric set. 
/// 
/// NOTE: Corresponding ISO 10303 type: geometric_set_select. Please refer to ISO/IS 10303-42:1994, p. 169 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC Release 2x.
class IFC_PARSE_API IfcGeometricSetSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcGeometricSetSelect > list;
};
/// IfcGridPlacementDirectionSelect enables the choice of defining a grid placement be either an explicit direction, or by referencing a second grid intersection to provide the direction.
/// 
/// SELECT
/// 
/// IfcDirection,
/// IfcVirtualGridIntersection
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcGridPlacementDirectionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcGridPlacementDirectionSelect > list;
};
/// The IfcHatchLineDistanceSelect is a selection between different ways to determine the distance and potentially start point of hatch lines, either by an offset distance length measure or by a vector.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcHatchLineDistanceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcHatchLineDistanceSelect > list;
};

class IFC_PARSE_API IfcImpactProtectionDeviceTypeSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcImpactProtectionDeviceTypeSelect > list;
};

class IFC_PARSE_API IfcInterferenceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcInterferenceSelect > list;
};
/// Definition from ISO/CD 10303-46:1992: The layered things type selects those things, which can be grouped in layers. 
/// 
/// It is the collection of all those items, that are assigned to a single layer. These items are representation items or complete representations (IfcRepresentationItem, IfcRepresentation). If an IfcRepresentation is referenced, all IfcRepresentationItem within its set of Items are assigned to the same layer. 
/// 
/// NOTE: Corresponding ISO 10303 name: layered_item. It was called layered_things in the ISO/CD version and had been renamed to layered_item in the ISO/IS final version. Please refer to ISO/IS 10303-46:1994, p. 13 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcLayeredItem : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcLayeredItem > list;
};
/// IfcLibrarySelect enables selection of whether library information is to be contained within an IFC model or is to be referenced from an external source. 
/// 
/// HISTORY: New Select Type in IFC2x
/// 
/// Select From: 
/// 
/// IfcLibraryInformation (for library information)  
/// IfcLibraryReference (for reference into a library of information by location)  
/// 
/// Generally, it is expected that selection will be IfcLibraryReference and only rarely IfcLibraryInformation. IfcLibraryInformation should only be selected in circumstances where there could be a need to indicate the libraries that will be used without making individual references. This may occur for higher level objects such as a project or building.
class IFC_PARSE_API IfcLibrarySelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcLibrarySelect > list;
};
/// A goniometric light gets its intensity distribution function (how much light goes in any one direction) from one of two sources: (i) an industry-standard file, (ii) from distribution data passed directly via the IfcLightIntensityDistribution. 
/// 
/// The light distribution provides the luminous intensity distribution according to some standardized light distribution curves. 
/// 
/// Select: 
/// 
/// Type 
///   Definition 
/// 
/// IfcExternalReference 
///   Light distribution is represented by a standard photometric data file such as Eulumdat, IES, CIBSE TM14.  
/// 
/// IfcLightIntensityDistribution 
///   For representing a light distribution directly the
///   following values needs to be given in a table like structure with column and
///   row headings. These headings should contain the angles (C/&#947; or B/&#946; )
///   and the table body contains the intensity values, (normally normalized to
///   cd/Klm). The angles can be non- equidistant and the angle steps can be almost
///   any value in the valid range, so a list of all available angles in both
///   directions covers all cases.  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcLightDistributionDataSourceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcLightDistributionDataSourceSelect > list;
};

class IFC_PARSE_API IfcLinearAxisSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcLinearAxisSelect > list;
};
/// IfcMaterialSelect provides selection of either a material
/// definition or a material usage definition that can be assigned to
/// an element, a resource or another entity within IFC.
/// SELECT
/// 
/// IfcMaterialDefinition
/// 
/// IfcMaterial
/// IfcMaterialLayer
/// IfcMaterialLayerSet
/// IfcMaterialProfile
/// IfcMaterialProfileSet
/// IfcMaterialConstituent
/// IfcMaterialConstituentSet
/// 
/// IfcMaterialUsageDefinition
/// 
/// IfcMaterialLayerSetUsage
/// IfcMaterialProfileSetUsage
/// 
/// IfcMaterialList
/// 
/// HISTORY New select in IFC 1.0
/// 
/// IFC2x4 CHANGE The select now includes two new abstract entities IfcMaterialDefinition
/// and IfcMaterialUsageDefinition with upward compatibility.  The use of IfcMaterialList is deprecated from IFC2x4 onwards.
class IFC_PARSE_API IfcMaterialSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcMaterialSelect > list;
};
/// Definition from ISO/CD 10303-41:1992: A measure value is a value as defined in ISO 31-0 (clause 2).
/// 
/// NOTE IfcMeasureValue is a select data type for most basic measure types coming from ISO 10303-41.  Select item IfcNonNegativeLengthMeasure is in addition to ISO 10303-41.
/// 
/// NOTE Corresponding ISO 10303 name: measure_value, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
/// 
/// IFC 2x4 change: added IfcNonNegativeLengthMeasure
class IFC_PARSE_API IfcMeasureValue : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcMeasureValue > list;
};
/// IfcMetricValueSelect is a select type that enables selection of the data type for the value component of an IfcMetric. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// Select 
/// 
/// IfcCostValue
///   IfcDateTime 
///   IfcMeasureWithUnit 
///   IfcTable 
///   IfcText 
///   IfcTimeSeries
class IFC_PARSE_API IfcMetricValueSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcMetricValueSelect > list;
};
/// Definition from IAI: A measure for modulus of rotational subgrade reaction which expresses the rotational bedding of a structural curve item per length.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcModulusOfRotationalSubgradeReactionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcModulusOfRotationalSubgradeReactionSelect > list;
};
/// Definition from IAI: Bedding measure which expresses the bedding of a structural face item per area.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcModulusOfSubgradeReactionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcModulusOfSubgradeReactionSelect > list;
};
/// Definition from IAI: A measure for modulus of translational subgrade reaction which expresses the translational bedding of a structural curve item per length.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcModulusOfTranslationalSubgradeReactionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcModulusOfTranslationalSubgradeReactionSelect > list;
};
/// IfcObjectReferenceSelect is a select type, that holds a list of resource level entities that can be used as properties within a property set. 
/// 
/// HISTORY  New select type in IFC Release 2.0.
class IFC_PARSE_API IfcObjectReferenceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcObjectReferenceSelect > list;
};
/// IfcPointOrVertexPoint provides the option to either select a geometric point (IfcPoint and subtypes) within a geometric model, or a vertex with associated point coordinates (IfcVertexPoint) within a topological model.
/// SELECT 
/// 
/// IfcPoint, 
///   IfcVertexPoint
/// 
/// HISTORY  New select type in IFC2x Edition 3.
class IFC_PARSE_API IfcPointOrVertexPoint : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcPointOrVertexPoint > list;
};
/// Definition from ISO/CD 10303-46:1992: The presentation style select is a selection of one of many kinds of styles, a different one for each kind of geometric representation item to be styled.
/// 
/// NOTE Corresponding ISO 10303 name: presentation_style_Select. Please refer to ISO/IS
/// 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
/// 
/// IFC2x4 CHANGE The select type has been deprecated.
class IFC_PARSE_API IfcPresentationStyleSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcPresentationStyleSelect > list;
};
/// IfcProcessSelectprovides the option to either
///   select a process or activity occurrence, IfcProcess,
///   or a process or activity type, IfcTypeProcess.
///   SELECT
/// 
/// IfcProcess,
/// 
/// IfcTypeProcess
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcProcessSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcProcessSelect > list;
};

class IFC_PARSE_API IfcProductRepresentationSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcProductRepresentationSelect > list;
};
/// IfcProductSelectprovides the option to either select a
/// product occurrence, IfcProduct, or a product type,
/// IfcTypeProduct.
/// SELECT
/// 
/// IfcProduct,
/// IfcTypeProduct
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcProductSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcProductSelect > list;
};

class IFC_PARSE_API IfcPropertySetDefinitionSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcPropertySetDefinitionSelect > list;
};
/// IfcResourceObjectSelect enables selection of resource level objects that are to be related to an resource level relationship object. The use of IfcResourceObjectSelect includes the ability to assign an external reference entity (library, classification, or documentation reference) to entities within the resource level.
/// 
/// HISTORY  New Select type in IFC2x4.
class IFC_PARSE_API IfcResourceObjectSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcResourceObjectSelect > list;
};
/// IfcResourceSelectprovides the option to either select a
/// resource occurrence, IfcResource, or a resource type,
/// IfcTypeResource.
/// SELECT
/// 
/// IfcResource,
/// IfcTypeResource
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcResourceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcResourceSelect > list;
};
/// Definition from IAI: A measure of rotational stiffness.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcRotationalStiffnessSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcRotationalStiffnessSelect > list;
};

class IFC_PARSE_API IfcSegmentIndexSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSegmentIndexSelect > list;
};
/// Definition from ISO/CD 10303-42:1992 This type collects together, for reference when constructing more complex models, the subtypes which have the characteristics of a shell. A shell is a connected object of fixed dimensionality d = 0; 1; or 2, typically used to bound a region. The domain of a shell, if present, includes its bounds and 0 £ X < ¥.  
/// 
/// A shell of dimensionality 0 is represented by a graph consisting of a single vertex. The vertex shall not have any associated edges. 
/// A shell of dimensionality 1 is represented by a connected graph of dimensionality 1. 
/// A shell of dimensionality 2 is a topological entity constructed by joining faces along edges. Its domain, if present, is a connected, orientable 2-manifold with boundary, that is, a connected, oriented, finite, non-self-intersecting surface, which may be closed or open. 
/// 
/// Shells of dimensionality 0 and 1 are not part of the current IFC release. 
/// 
/// NOTE  Corresponding ISO 10303 type: shell. Please refer to ISO/IS 10303-42:1994, p. 127 for the final definition of the formal standard. Only the select items closed_shell (IfcClosedShell) and open_shell (IfcOpenShell) have been incorporated in the current IFC release. 
/// 
/// HISTORY  New type in IFC2x.
class IFC_PARSE_API IfcShell : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcShell > list;
};
/// IfcSimpleValue is a select type for selecting between simple value types.
/// 
/// SELECT 
/// 
/// IfcInteger: Defined type of simple type INTEGER. 
///   IfcReal: Defined type of simple type REAL. 
///   IfcBoolean: Defined type of simple type BOOLEAN. 
///   IfcLogical: Defined type of simple type LOGICAL. 
///   IfcIdentifier: Defined type of simple type STRING for identification purposes. 
///   IfcLabel: Defined type of simple type STRING for naming purposes. 
///   IfcText: Defined type of simple type STRING for descriptive purposes. 
///   IfcDateTime: Defined type of simple type STRING to represent a date and time. 
///   IfcDate: Defined type of simple type STRING to represent a date. 
///   IfcTime: Defined type of simple type STRING to represent a time. 
///   IfcDuration: Defined type of simple type STRING to represent a duration. 
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// IFC2x4 CHANGE Items IfcDateTime, IfcDate, IfcTime, IfcDuration added.
class IFC_PARSE_API IfcSimpleValue : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSimpleValue > list;
};
/// Definition from ISO/CD 10303-46:1992: The size select is a selection of a specific positive length measure.
/// 
/// Definition from ISO: The size (or width) measure value is given in the global drawing length units.
/// 
/// NOTE  global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// NOTE  Corresponding ISO 10303 name: size_select. Please refer to ISO/IS 10303-46:1994 for the final
/// definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The SELECT item IfcMeasureWithUnit has been removed from the IfcSizeSelect, the IfcRatioMeasure and IfcDescriptiveMeasure has been added.
class IFC_PARSE_API IfcSizeSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSizeSelect > list;
};
/// The IfcSolidOrShell provides the option to either select a geometric volume (IfcSolidModel and subtypes) within a geometric model, or a shell (IfcClosedShell) within a topological model.
/// SELECT
/// 
/// IfcSolidModel
/// IfcClosedShell
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcSolidOrShell : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSolidOrShell > list;
};
/// Definition from IAI: The
/// IfcSpaceBoundarySelectselects either an internal space
/// for internal or external space boundaries, or an external spatial
/// element for external space boundaries at the outer envelop of the
/// building.
/// SELECT
/// 
/// IfcSpace,
/// IfcExternalSpatialElement
/// 
/// HISTORY New select type
/// in IFC2x4.
class IFC_PARSE_API IfcSpaceBoundarySelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSpaceBoundarySelect > list;
};

class IFC_PARSE_API IfcSpatialReferenceSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSpatialReferenceSelect > list;
};
/// The IfcSpecularHighlightSelect defines the selectable types of value for specular highlight sharpness. 
/// 
/// NOTE: The two select types relate to the different ways to specifiy the sharpness (or shininess) of the specular part of the reflectance equation. It relates to the attributes: 
/// 
/// in ISO10303-46 the attribute specular_exponent is given 
///   in VRML97 the attribute shininess is given 
/// 
/// For each surface side style only one of the two methods is needed for calculating the specular part of the equation.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcSpecularHighlightSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSpecularHighlightSelect > list;
};
/// Definition from IAI: This type definition shall be used to
///   distinguish between a reference to an instance either of
///   IfcStructuralItem or IfcBuildingElement. The
///   IfcStructuralActivityAssignmentSelect type is referenced by the entity
///   IfcRelConnectsStructuralActivity which defines the connection between
///   activities (IfcStructuralActivity) and the loaded element.  
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
class IFC_PARSE_API IfcStructuralActivityAssignmentSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcStructuralActivityAssignmentSelect > list;
};
/// The style assignment select is a selection of two wasy of assigning presentation styles to an IfcStyledItem.
/// 
/// by directly assigning presentation styles as subtypes of IfcPresentationStyle
/// by assigning presentation stypes via an intermediate collection entity IfcPresentationStyleAssignment
/// 
/// NOTE Using IfcPresentationStyleAssignment is deprecated in IFC2x4 onwards
/// 
/// NOTE The select type has been introduced to provide an upward compatible improvement for assigning styles to a styled items.
/// 
/// HISTORY New select type in IFC2x4.
class IFC_PARSE_API IfcStyleAssignmentSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcStyleAssignmentSelect > list;
};
/// IfcSurfaceOrFaceSurface provides the option to either select a geometric surface (IfcSurface
/// and subtypes) within a geometric model, or a face with associated surface geometry and coordinates (IfcFaceSurface) within a topological model.
/// SELECT 
/// 
/// IfcSurface 
///   IfcFaceSurface
///   IfcFaceBasedSurfaceModel (a connected face set, representing a faceted surface as an approximation of a non planar, non rectangular bounded surface)
/// 
/// HISTORY  New select type in IFC2x3.
class IFC_PARSE_API IfcSurfaceOrFaceSurface : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSurfaceOrFaceSurface > list;
};
/// Definition from ISO/CD 10303-46:1992: The surface style element select is a selection of the different surface styles to use in the presentation of the side of a surface. 
/// 
/// The select type only includes the IfcSurfaceStyleRendering (which is the equivalent to surface_style_rendering) from the select type surface_style_element_select. In addition it has the IfcSurfaceStyleLighting, which holds the exact physically based lighting properties for lighting based calculation algorithms (as the opposite to the rendering based calculation), the IfcSurfaceStyleRefraction (for more advanced refraction indices) and IfcSurfaceStyleWithTextures (to allow for image textures applied to surfaces). In addition an IfcExternallyDefinedSurfaceStyle can be selected that points into an external material library. 
/// 
/// NOTE The IfcSurfaceLightingProperties are needed for exact lighting calculation, because physically based lighting calculation algorithms need exact physically based parameters. The factors in IfcSurfaceStyleRendering lack the physical base, they are intended for rendering calculations, but a lighting calculation based software cannot use these values.
/// 
/// NOTE: Corresponding ISO 10303 type: surface_style_element_select. Please refer to ISO/IS 10303-46:1994, p. 85 for the final definition of the formal standard.
/// 
/// HISTORY: New Select type in IFC2x2.
class IFC_PARSE_API IfcSurfaceStyleElementSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcSurfaceStyleElementSelect > list;
};
/// IfcTextFontSelect allows for either a predefined text font, a text font model or an externally defined text font to be used to describe the font of a text literal. The definition of the text font model is based on W3C TR Cascading Style Sheet Version 1, whereas the definition of predefined text font is based on ISO 10303.
/// 
/// NOTE  IfcTextFontSelect is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation. Corresponding ISO 10303 name: font_select. Please refer to ISO/IS 10303-46:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The select type has been renamed from IfcFontSelect.
class IFC_PARSE_API IfcTextFontSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcTextFontSelect > list;
};
/// IfcTimeOrRatioSelect allows a value to be selected as being either a ratio or a time measure.
/// HISTORY New SELECT in IFC2x4
class IFC_PARSE_API IfcTimeOrRatioSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcTimeOrRatioSelect > list;
};
/// Definition from IAI: A measure of linear stiffness.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcTranslationalStiffnessSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcTranslationalStiffnessSelect > list;
};

class IFC_PARSE_API IfcTransportElementTypeSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcTransportElementTypeSelect > list;
};
/// Definition from ISO/CD 10303-42:1992: This select type identifies the two possible ways of trimming a parametric curve; by a Cartesian point on the curve, or by a REAL number defining a parameter value within the parametric range of the curve. 
/// 
/// NOTE Corresponding ISO 10303 type: trimming_select, please refer to ISO/IS 10303-42:1994, p. 20 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.0
class IFC_PARSE_API IfcTrimmingSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcTrimmingSelect > list;
};
/// Definition from ISO/CD 10303-41:1992: A unit is a physical quantity, with a value of one, which is used as a standard in terms of which other quantities are expressed.
/// 
/// NOTE: Select item IfcMonetaryUnit is an addition to ISO 10303-41.
/// 
/// NOTE: Corresponding ISO 10303 name: unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// SELECT 
/// 
/// IfcNamedUnit: A unit which is identified by a name.
/// IfcDerivedUnit: A unit which is derived from an expression of units. 
/// IfcMonetaryUnit: A unit for defining currencies. 
/// 
/// HISTORY: New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcUnit : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcUnit > list;
};
/// IfcValue is a select type for selecting between more specialised select types IfcSimpleValue,
/// IfcMeasureValue and IfcDerivedMeasureValue.
/// 
/// SELECT 
/// 
/// IfcSimpleValue A select type for basic defined types of simple data type. 
///   IfcMeasureValue A select type for basic measure types of ISO 10303-41. 
///   IfcDerivedMeasureValue A select type for derived measure types.
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcValue : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcValue > list;
};
/// Definition from ISO/CD 10303-42:1992: This type is used to
///   identify the types of entity which can participate in vector computations. 
/// 
/// NOTE Corresponding STEP type:
///   vector_or_direction, please refer to ISO/IS 10303-42:1994, p. 20 for the final
///   definition of the formal standard.  
///   HISTORY New Type in IFC Release
///   1.5
class IFC_PARSE_API IfcVectorOrDirection : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcVectorOrDirection > list;
};
/// Definition from IAI: A measure of warping stiffness.  TRUE denotes infinite stiffness (rigidity).  FALSE denotes no stiffness (a release).  A numeric value denotes finite linear-elastic stiffness.
/// 
/// HISTORY: New type in IFC 2x4.
class IFC_PARSE_API IfcWarpingStiffnessSelect : public virtual IfcUtil::IfcBaseInterface {
public:
    static const IfcParse::select_type& Class();
    typedef aggregate_of< IfcWarpingStiffnessSelect > list;
};
class IFC_PARSE_API IfcActionRequestTypeEnum : public IfcUtil::IfcBaseType {
/// IfcActionRequestTypeEnum defines the types of sources through which a request can be made. 
///   HISTORY: New Enumeration in IFC2x4. 
///   Enumeration: 
/// 
/// EMAIL: Request was made through email. 
/// FAX: Request was made through facsimile. 
/// PHONE: Request was made verbally over a telephone. 
/// POST: Request was made through postal mail. 
/// VERBAL: Request was made verbally in person.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcActionRequestType_EMAIL, IfcActionRequestType_FAX, IfcActionRequestType_PHONE, IfcActionRequestType_POST, IfcActionRequestType_VERBAL, IfcActionRequestType_USERDEFINED, IfcActionRequestType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcActionRequestTypeEnum (IfcEntityInstanceData&& e);
    IfcActionRequestTypeEnum (Value v);
    IfcActionRequestTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcActionSourceTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI:This enumeration type contains possible
///   action sources. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
public:
    typedef enum {IfcActionSourceType_DEAD_LOAD_G, IfcActionSourceType_COMPLETION_G1, IfcActionSourceType_LIVE_LOAD_Q, IfcActionSourceType_SNOW_S, IfcActionSourceType_WIND_W, IfcActionSourceType_PRESTRESSING_P, IfcActionSourceType_SETTLEMENT_U, IfcActionSourceType_TEMPERATURE_T, IfcActionSourceType_EARTHQUAKE_E, IfcActionSourceType_FIRE, IfcActionSourceType_IMPULSE, IfcActionSourceType_IMPACT, IfcActionSourceType_TRANSPORT, IfcActionSourceType_ERECTION, IfcActionSourceType_PROPPING, IfcActionSourceType_SYSTEM_IMPERFECTION, IfcActionSourceType_SHRINKAGE, IfcActionSourceType_CREEP, IfcActionSourceType_LACK_OF_FIT, IfcActionSourceType_BUOYANCY, IfcActionSourceType_ICE, IfcActionSourceType_CURRENT, IfcActionSourceType_WAVE, IfcActionSourceType_RAIN, IfcActionSourceType_BRAKES, IfcActionSourceType_USERDEFINED, IfcActionSourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcActionSourceTypeEnum (IfcEntityInstanceData&& e);
    IfcActionSourceTypeEnum (Value v);
    IfcActionSourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcActionTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration type is used to distinguish
///   between possible action types at a high level. It can be used for an automated
///   definition of load combinations and for dimensioning. The contained items and
///   their acronyms are adopted from the Eurocode standard. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
public:
    typedef enum {IfcActionType_PERMANENT_G, IfcActionType_VARIABLE_Q, IfcActionType_EXTRAORDINARY_A, IfcActionType_USERDEFINED, IfcActionType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcActionTypeEnum (IfcEntityInstanceData&& e);
    IfcActionTypeEnum (Value v);
    IfcActionTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcActuatorTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcActuatorTypeEnum defines the range of different types of actuator that can be specified. 
/// 
/// HISTORY: New type in IFC
///   R2.0  
///   Enumeration 
/// 
/// ELECTRICACTUATOR: A device that electrically actuates a control element.  
/// PNEUMATICACTUATOR<: A device that pneumatically actuates a control element  
/// HYDRAULICACTUATOR: A device that electrically actuates a control element.  
/// HANDOPERATEDACTUATOR: A device that manually actuates a control element. 
/// THERMOSTATICACTUATOR: A device that thermostatically actuates a control element. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type. 
/// 
/// See property set of actuator common attributes for specification of
///   properties for hand operated actuators.
public:
    typedef enum {IfcActuatorType_ELECTRICACTUATOR, IfcActuatorType_HANDOPERATEDACTUATOR, IfcActuatorType_HYDRAULICACTUATOR, IfcActuatorType_PNEUMATICACTUATOR, IfcActuatorType_THERMOSTATICACTUATOR, IfcActuatorType_USERDEFINED, IfcActuatorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcActuatorTypeEnum (IfcEntityInstanceData&& e);
    IfcActuatorTypeEnum (Value v);
    IfcActuatorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAddressTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Identifies the logical location of the address.
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// ENUMERATION 
/// 
/// OFFICE An office address. 
///   SITE A site address.
///   HOME A home address.
///   DISTRIBUTIONPOINT A postal distribution point address.
///   USERDEFINED A user defined address type to be provided.
public:
    typedef enum {IfcAddressType_OFFICE, IfcAddressType_SITE, IfcAddressType_HOME, IfcAddressType_DISTRIBUTIONPOINT, IfcAddressType_USERDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAddressTypeEnum (IfcEntityInstanceData&& e);
    IfcAddressTypeEnum (Value v);
    IfcAddressTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAirTerminalBoxTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration identifies different types of air terminal boxes.   
/// 
/// Valid enumerations are:
/// 
/// CONSTANTFLOW:  Terminal box does not include a means to reset the volume automatically to an outside signal such as thermostat.
///   VARIABLEFLOWPRESSUREDEPENDANT:  terminal box includes a means to reset the volume automatically to a different control point in response to an outside signal such as thermostat: air-flow rate depends on supply pressure.
///   VARIABLEFLOWPRESSUREINDEPENDANT:  terminal box includes a means to reset the volume automatically to a different control point in response to an outside signal such as thermostat: air-flow rate is independant of supply pressure.
///   USERDEFINED:				  User-defined terminal box.
///   NOTDEFINED:					  Undefined terminal box.
/// 
/// HISTORY: New enumeration in IFC R2.0
public:
    typedef enum {IfcAirTerminalBoxType_CONSTANTFLOW, IfcAirTerminalBoxType_VARIABLEFLOWPRESSUREDEPENDANT, IfcAirTerminalBoxType_VARIABLEFLOWPRESSUREINDEPENDANT, IfcAirTerminalBoxType_USERDEFINED, IfcAirTerminalBoxType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAirTerminalBoxTypeEnum (IfcEntityInstanceData&& e);
    IfcAirTerminalBoxTypeEnum (Value v);
    IfcAirTerminalBoxTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAirTerminalTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the functional types of air terminals. 
///   The IfcAirTerminalTypeEnum contains the following:
/// 
/// GRILLE: A covering for any area through which air passes.
///   REGISTER: A grille typically equipped with a damper or control valve.
///   DIFFUSER: An outlet discharging supply air in various directions and planes.
///   LOUVRE: A rectilinear louvre.
///   USERDEFINED: User-defined air terminal type.
///   NOTDEFINED:  Undefined air terminal type.
/// 
/// NOTE: Architectural louvres within doors or windows are defined by IfcPermeableCoveringProperties.
/// 
/// HISTORY: New enumeration in IFC R2x2.  Modified in IFC R2x4 to add LOUVRE and remove EYEBALL, IRIS, LINEARGRILLE, LINEARDIFFUSER
public:
    typedef enum {IfcAirTerminalType_DIFFUSER, IfcAirTerminalType_GRILLE, IfcAirTerminalType_LOUVRE, IfcAirTerminalType_REGISTER, IfcAirTerminalType_USERDEFINED, IfcAirTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAirTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcAirTerminalTypeEnum (Value v);
    IfcAirTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAirToAirHeatRecoveryTypeEnum : public IfcUtil::IfcBaseType {
/// Defines general types of pumps.
///   The IfcPumpTypeEnum contains the following:
/// 
/// FIXEDPLATECOUNTERFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with primary air enters at secondary air outlet location and exits at secondary air inlet location.
///   FIXEDPLATECROSSFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with secondary air flow in the direction perpendicular to primary air flow.
///   FIXEDPLATEPARALLELFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with primary air enters at secondary air inlet location and exits at secondary air outlet location.
///   ROTARYWHEEL: A heat wheel with a revolving cylinder filled with an air-permeable medium having a large internal surface area.
///   RUNAROUNDCOILLOOP: A typical coil energy recovery loop places extended surface, finned tube water coils in the supply and exhaust airstreams of a building.
///   HEATPIPE: A passive energy recovery device with a heat pipe divided into evaporator and condenser sections.
///   TWINTOWERENTHALPYRECOVERYLOOPS: An air-to-liquid, liquid-to-air enthalpy recovery system with a sorbent liquid circulates continuously between supply and exhaust airstreams, alternately contacting both airstreams directly in contactor towers.
///   THERMOSIPHONSEALEDTUBEHEATEXCHANGERS: Sealed systems that consist of an evaporator, a condenser, interconnecting piping, and an intermediate working fluid that is present in both liquid and vapor phases where the evaporator and the condenser are usually at opposite ends of a bundle of straight, individual thermosiphon tubes and the exhaust and supply ducts are adjacent to each other.
///   THERMOSIPHONCOILTYPEHEATEXCHANGERS: Sealed systems that consist of an evaporator, a condenser, interconnecting piping, and an intermediate working fluid that is present in both liquid and vapor phases where the evaporator and condensor coils are installed independently in the ducts and are interconnected by the working fluid piping.
///   USERDEFINED: User-defined air to air heat recovery type.
///   NOTDEFINED:  Undefined air to air heat recovery type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcAirToAirHeatRecoveryType_FIXEDPLATECOUNTERFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_FIXEDPLATECROSSFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_FIXEDPLATEPARALLELFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_ROTARYWHEEL, IfcAirToAirHeatRecoveryType_RUNAROUNDCOILLOOP, IfcAirToAirHeatRecoveryType_HEATPIPE, IfcAirToAirHeatRecoveryType_TWINTOWERENTHALPYRECOVERYLOOPS, IfcAirToAirHeatRecoveryType_THERMOSIPHONSEALEDTUBEHEATEXCHANGERS, IfcAirToAirHeatRecoveryType_THERMOSIPHONCOILTYPEHEATEXCHANGERS, IfcAirToAirHeatRecoveryType_USERDEFINED, IfcAirToAirHeatRecoveryType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAirToAirHeatRecoveryTypeEnum (IfcEntityInstanceData&& e);
    IfcAirToAirHeatRecoveryTypeEnum (Value v);
    IfcAirToAirHeatRecoveryTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAlarmTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcAlarmTypeEnum defines the range of different types of alarm that can be specified. 
/// 
/// HISTORY: New type in IFC 2x2
/// 
/// Enumeration 
/// 
/// BELL: An audible alarm. 
/// BREAKGLASSBUTTON: An alarm activation mechanism in which a protective glass has to be broken to enable a button to be pressed. 
/// LIGHT: A visual alarm. 
/// MANUALPULLBOX: An alarm activation mechanism in which activation is achieved by a pulling action. 
/// SIREN: An audible alarm. 
/// WHISTLE: An audible alarm.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcAlarmType_BELL, IfcAlarmType_BREAKGLASSBUTTON, IfcAlarmType_LIGHT, IfcAlarmType_MANUALPULLBOX, IfcAlarmType_SIREN, IfcAlarmType_WHISTLE, IfcAlarmType_RAILWAYCROCODILE, IfcAlarmType_RAILWAYDETONATOR, IfcAlarmType_USERDEFINED, IfcAlarmType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAlarmTypeEnum (IfcEntityInstanceData&& e);
    IfcAlarmTypeEnum (Value v);
    IfcAlarmTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAlignmentTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcAlignmentType_USERDEFINED, IfcAlignmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAlignmentTypeEnum (IfcEntityInstanceData&& e);
    IfcAlignmentTypeEnum (Value v);
    IfcAlignmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAnalysisModelTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This type definition is used to distinguish
///   between different types of structural analysis models. The analysis models are
///   differentiated by their dimensionality. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
public:
    typedef enum {IfcAnalysisModelType_IN_PLANE_LOADING_2D, IfcAnalysisModelType_OUT_PLANE_LOADING_2D, IfcAnalysisModelType_LOADING_3D, IfcAnalysisModelType_USERDEFINED, IfcAnalysisModelType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAnalysisModelTypeEnum (IfcEntityInstanceData&& e);
    IfcAnalysisModelTypeEnum (Value v);
    IfcAnalysisModelTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAnalysisTheoryTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This type definition is used to distinguish
///   between different types of structural analysis methods, i.e. first order
///   theory, second order theory (small deformations), third order theory (large
///   deformations) and the full nonlinear theory (geometric nonlinearity together with other nonlinearities, e.g. plasticity). 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
public:
    typedef enum {IfcAnalysisTheoryType_FIRST_ORDER_THEORY, IfcAnalysisTheoryType_SECOND_ORDER_THEORY, IfcAnalysisTheoryType_THIRD_ORDER_THEORY, IfcAnalysisTheoryType_FULL_NONLINEAR_THEORY, IfcAnalysisTheoryType_USERDEFINED, IfcAnalysisTheoryType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAnalysisTheoryTypeEnum (IfcEntityInstanceData&& e);
    IfcAnalysisTheoryTypeEnum (Value v);
    IfcAnalysisTheoryTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAnnotationTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcAnnotationType_ASSUMEDPOINT, IfcAnnotationType_ASBUILTAREA, IfcAnnotationType_ASBUILTLINE, IfcAnnotationType_NON_PHYSICAL_SIGNAL, IfcAnnotationType_ASSUMEDLINE, IfcAnnotationType_WIDTHEVENT, IfcAnnotationType_ASSUMEDAREA, IfcAnnotationType_SUPERELEVATIONEVENT, IfcAnnotationType_ASBUILTPOINT, IfcAnnotationType_USERDEFINED, IfcAnnotationType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAnnotationTypeEnum (IfcEntityInstanceData&& e);
    IfcAnnotationTypeEnum (Value v);
    IfcAnnotationTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcArithmeticOperatorEnum : public IfcUtil::IfcBaseType {
/// IfcArithmeticOperatorEnum specifies the form of arithmetical operation implied by the relationship. 
/// Enumeration 
/// 
/// ADD 
///   DIVIDE 
///   MULTIPLY 
///   SUBTRACT 
/// 
/// HISTORY: New enumeration in IFC2x2.
/// 
/// Use definitions 
/// There can be only one arithmetic operator for each applied value relationship. This is to enforce arithmetic consistency. Given this consistency, the cardinality of the IfcAppliedValueRelationship.Components attribute is a set of one to many applied values that are components of an applied value.
public:
    typedef enum {IfcArithmeticOperator_ADD, IfcArithmeticOperator_DIVIDE, IfcArithmeticOperator_MULTIPLY, IfcArithmeticOperator_SUBTRACT} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcArithmeticOperatorEnum (IfcEntityInstanceData&& e);
    IfcArithmeticOperatorEnum (Value v);
    IfcArithmeticOperatorEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAssemblyPlaceEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining where the
///   assembly is intended to take place, either in a factory or
///   on the building site.
/// 
/// HISTORY New enumeration in
///   Release IFC2x Edition 2.
/// 
/// Enumeration
/// 
/// SITE - this assembly is assembled at site
/// 
/// FACTORY - this assembly is assembled in a factory
public:
    typedef enum {IfcAssemblyPlace_SITE, IfcAssemblyPlace_FACTORY, IfcAssemblyPlace_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAssemblyPlaceEnum (IfcEntityInstanceData&& e);
    IfcAssemblyPlaceEnum (Value v);
    IfcAssemblyPlaceEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcAudioVisualApplianceTypeEnum : public IfcUtil::IfcBaseType {
/// Defines the range of different types of audio-video devices that can be specified. 
/// HISTORY: New enumeration in IFC2x4 
/// 
/// AMPLIFIER: A device that receives an audio signal and amplifies it to play through speakers. 
/// CAMERA: A device that records images, either as a still photograph or as moving images known as videos or movies.  Note that a camera may operate with light from the visible spectrum or from other parts of the electromagnetic spectrum such as infrared or ultraviolet. 
/// DISPLAY: An electronic device that represents information in visual form such as a flat-panel display or television. 
/// MICROPHONE: An acoustic-to-electric transducer or sensor that converts sound into an electrical signal.  Microphones types in use include electromagnetic induction (dynamic microphones), capacitance change (condenser microphones) or piezoelectric generation to produce the signal from mechanical vibration. 
/// PLAYER: A device that plays audio and/or video content directly or to another device, having fixed or removable storage media. 
/// PROJECTOR: An apparatus for projecting a picture on a screen. Whether the device is an overhead, slide projector, or a film projector, it is usually referred to as simply a projector. 
/// RECEIVER: A device that receives audio and/or video signals, switches sources, and amplifies signals to play through speakers. 
/// SPEAKER: A loudspeaker, speaker, or speaker system is an electroacoustical transducer that converts an electrical signal to sound. 
/// SWITCHER: A device that receives audio and/or video signals, switches sources, and transmits signals to downstream devices. 
/// TELEPHONE: A telecommunications device that is used to transmit and receive sound, and optionally video. 
/// TUNER: An electronic receiver that detects, demodulates, and amplifies transmitted signals.
public:
    typedef enum {IfcAudioVisualApplianceType_AMPLIFIER, IfcAudioVisualApplianceType_CAMERA, IfcAudioVisualApplianceType_DISPLAY, IfcAudioVisualApplianceType_MICROPHONE, IfcAudioVisualApplianceType_PLAYER, IfcAudioVisualApplianceType_PROJECTOR, IfcAudioVisualApplianceType_RECEIVER, IfcAudioVisualApplianceType_SPEAKER, IfcAudioVisualApplianceType_SWITCHER, IfcAudioVisualApplianceType_TELEPHONE, IfcAudioVisualApplianceType_TUNER, IfcAudioVisualApplianceType_RAILWAY_COMMUNICATION_TERMINAL, IfcAudioVisualApplianceType_USERDEFINED, IfcAudioVisualApplianceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcAudioVisualApplianceTypeEnum (IfcEntityInstanceData&& e);
    IfcAudioVisualApplianceTypeEnum (Value v);
    IfcAudioVisualApplianceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBSplineCurveForm : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-42:1992: This type is used to indicate that the B-spline curve represents a part of a curve of some specific form.
/// 
/// Enumeration
/// 
/// polyline form: A connected sequence of line segments represented by degree 1 B-spline basis functions.
/// circular arc: An arc of a circle, or a complete circle represented by a B-spline curve.
/// elliptic arc: An arc of an ellipse, or a complete ellipse, represented by a B-spline curve.
/// parabolic arc: An arc of finite length of a parabola represented by a B-spline curve.
/// hyperbolic arc: An arc of finite length of one branch of a hyperbola represented by a B-spline curve.
/// unspecified: A B-spline curve for which no particular form is specified.
/// 
/// NOTE Corresponding ISO 10303 type: b_spline_curve_form. Please refer to ISO/IS 10303-42:1994, p. 15 for the final definition of the formal standard.
/// 
/// HISTORY New type in Release IFC2x2.
public:
    typedef enum {IfcBSplineCurveForm_POLYLINE_FORM, IfcBSplineCurveForm_CIRCULAR_ARC, IfcBSplineCurveForm_ELLIPTIC_ARC, IfcBSplineCurveForm_PARABOLIC_ARC, IfcBSplineCurveForm_HYPERBOLIC_ARC, IfcBSplineCurveForm_UNSPECIFIED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBSplineCurveForm (IfcEntityInstanceData&& e);
    IfcBSplineCurveForm (Value v);
    IfcBSplineCurveForm (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBSplineSurfaceForm : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBSplineSurfaceForm_PLANE_SURF, IfcBSplineSurfaceForm_CYLINDRICAL_SURF, IfcBSplineSurfaceForm_CONICAL_SURF, IfcBSplineSurfaceForm_SPHERICAL_SURF, IfcBSplineSurfaceForm_TOROIDAL_SURF, IfcBSplineSurfaceForm_SURF_OF_REVOLUTION, IfcBSplineSurfaceForm_RULED_SURF, IfcBSplineSurfaceForm_GENERALISED_CONE, IfcBSplineSurfaceForm_QUADRIC_SURF, IfcBSplineSurfaceForm_SURF_OF_LINEAR_EXTRUSION, IfcBSplineSurfaceForm_UNSPECIFIED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBSplineSurfaceForm (IfcEntityInstanceData&& e);
    IfcBSplineSurfaceForm (Value v);
    IfcBSplineSurfaceForm (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBeamTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcBeamType object
/// can fulfill:
/// 
/// BEAM: A standard beam usually used horizontally.
/// JOIST: A beam used to support a floor or ceiling.
/// HOLLOWCORE: A wide often prestressed beam with a
/// hollow-core profile that usually serves as a slab component.
/// LINTEL: A beam or horizontal piece of material over an
/// opening (e.g. door, window).
/// SPANDREL: A tall beam placed on the facade of a
/// building. One tall side is usually finished to provide the
/// exterior of the building. Can be used to support joists or slab
/// elements on its interior side.
/// 
/// NOTE They are also referred to as "spandrel
/// panels", which are parts of a facade and sometimes have
/// supporting consoles for floor slabs
/// integrated.
/// 
/// T_BEAM: A beam that forms part of a slab construction
/// and acts together with the slab which its carries. Such beams are
/// often of T-shape (therefore the English name), but may have other
/// shapes as well, e.g. an L-Shape or an Inverted-T-Shape.
/// 
/// NOTE In order to distinguish beams by shape,
/// the assigned IfcProfileDef subtypes provide the shape type
/// and, if using a subtype of
/// IfcParameterizedProfileDef, also the shape
/// parameterization.
/// 
/// USERDEFINED: User-defined linear beam element.
/// NOTDEFINED: Undefined linear beam element
/// 
/// HISTORY New Enumeration
/// in Release IFC2x Edition 2.
/// IFC2x4 CHANGE The enumerators
/// HOLLOWCORE and SPANDREL have been
/// added.
public:
    typedef enum {IfcBeamType_BEAM, IfcBeamType_JOIST, IfcBeamType_HOLLOWCORE, IfcBeamType_LINTEL, IfcBeamType_SPANDREL, IfcBeamType_T_BEAM, IfcBeamType_GIRDER_SEGMENT, IfcBeamType_DIAPHRAGM, IfcBeamType_PIERCAP, IfcBeamType_HATSTONE, IfcBeamType_CORNICE, IfcBeamType_EDGEBEAM, IfcBeamType_USERDEFINED, IfcBeamType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBeamTypeEnum (IfcEntityInstanceData&& e);
    IfcBeamTypeEnum (Value v);
    IfcBeamTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBearingTypeDisplacementEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBearingTypeDisplacement_FIXED_MOVEMENT, IfcBearingTypeDisplacement_GUIDED_LONGITUDINAL, IfcBearingTypeDisplacement_GUIDED_TRANSVERSAL, IfcBearingTypeDisplacement_FREE_MOVEMENT, IfcBearingTypeDisplacement_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBearingTypeDisplacementEnum (IfcEntityInstanceData&& e);
    IfcBearingTypeDisplacementEnum (Value v);
    IfcBearingTypeDisplacementEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBearingTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBearingType_CYLINDRICAL, IfcBearingType_SPHERICAL, IfcBearingType_ELASTOMERIC, IfcBearingType_POT, IfcBearingType_GUIDE, IfcBearingType_ROCKER, IfcBearingType_ROLLER, IfcBearingType_DISK, IfcBearingType_USERDEFINED, IfcBearingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBearingTypeEnum (IfcEntityInstanceData&& e);
    IfcBearingTypeEnum (Value v);
    IfcBearingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBenchmarkEnum : public IfcUtil::IfcBaseType {
/// IfcBenchmarkEnum is an enumeration used to identify the logical comparators that can be applied in conjunction with constraint values. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// IFC2x4 CHANGE: Extended to include comparators for item-set and set-item comparisons: INCLUDES, NOTINCLUDES, INCLUDEDIN and NOTINCLUDEDIN, to test if an individual item is a member of a given aggregation, or if an aggregation has a given individual item as a member.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// GREATERTHAN 
///   Identifies that a value must be greater than that set by the constraint. 
/// 
/// GREATERTHANOREQUALTO 
///   Identifies that a value must be either greater than or equal to that set by the constraint. 
/// 
/// LESSTHAN 
///   Identifies that a value must be less than that set by the constraint. 
/// 
/// LESSTHANOREQUALTO 
///   Identifies that a value must be either less than or equal to that set by the constraint. 
/// 
/// EQUALTO 
///   Identifies that a value must be equal to that set by the constraint. 
/// 
/// NOTEQUALTO 
///   Identifies that a value must be not equal to that set by the constraint. 
/// 
/// INCLUDES 
///   Identifies that an aggregation (set, list or table) must include the value (individual item) set by the constraint. 
/// 
/// NOTINCLUDES 
///   Identifies that an aggregation (set, list or table) must not include (i.e must exclude) the value (individual item) set by the constraint. 
/// 
/// INCLUDEDIN 
///   Identifies that a value (individual item) must be included in the aggregation (set, list or table) set by the constraint. 
/// 
/// NOTINCLUDEDIN 
///   Identifies that a value (individual item) must not be included (i.e. must be excluded) in the aggregation (set, list or table) set by the constraint.
public:
    typedef enum {IfcBenchmark_GREATERTHAN, IfcBenchmark_GREATERTHANOREQUALTO, IfcBenchmark_LESSTHAN, IfcBenchmark_LESSTHANOREQUALTO, IfcBenchmark_EQUALTO, IfcBenchmark_NOTEQUALTO, IfcBenchmark_INCLUDES, IfcBenchmark_NOTINCLUDES, IfcBenchmark_INCLUDEDIN, IfcBenchmark_NOTINCLUDEDIN} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBenchmarkEnum (IfcEntityInstanceData&& e);
    IfcBenchmarkEnum (Value v);
    IfcBenchmarkEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBoilerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of boilers.
///   The IfcBoilerTypeEnum contains the following:
/// 
/// WATER: Water boiler.
///   STEAM: Steam boiler.
///   USERDEFINED: User-defined Boiler type.
///   NOTDEFINED:  Undefined Boiler type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcBoilerType_WATER, IfcBoilerType_STEAM, IfcBoilerType_USERDEFINED, IfcBoilerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBoilerTypeEnum (IfcEntityInstanceData&& e);
    IfcBoilerTypeEnum (Value v);
    IfcBoilerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBooleanOperator : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-42:1992: This type defines the three Boolean operators used in the definition of CSG solids.
/// 
/// UNION: The operation of constructing the regularized set theoretic union of the volumes defined by two solids.
/// INTERSECTION: The operation of constructing the regularised set theoretic intersection of the volumes defined by two solids.
/// DIFFERENCE: The operation of constructing the regularized set theoretic intersection of the volumes defined by two solids.
/// 
/// NOTE Corresponding STEP type: boolean_operator, please refer to ISO/IS 10303-42:1994, p.167 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5.1.
public:
    typedef enum {IfcBooleanOperator_UNION, IfcBooleanOperator_INTERSECTION, IfcBooleanOperator_DIFFERENCE} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBooleanOperator (IfcEntityInstanceData&& e);
    IfcBooleanOperator (Value v);
    IfcBooleanOperator (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBridgePartTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBridgePartType_ABUTMENT, IfcBridgePartType_DECK, IfcBridgePartType_DECK_SEGMENT, IfcBridgePartType_FOUNDATION, IfcBridgePartType_PIER, IfcBridgePartType_PIER_SEGMENT, IfcBridgePartType_PYLON, IfcBridgePartType_SUBSTRUCTURE, IfcBridgePartType_SUPERSTRUCTURE, IfcBridgePartType_SURFACESTRUCTURE, IfcBridgePartType_USERDEFINED, IfcBridgePartType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBridgePartTypeEnum (IfcEntityInstanceData&& e);
    IfcBridgePartTypeEnum (Value v);
    IfcBridgePartTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBridgeTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBridgeType_ARCHED, IfcBridgeType_CABLE_STAYED, IfcBridgeType_CANTILEVER, IfcBridgeType_CULVERT, IfcBridgeType_FRAMEWORK, IfcBridgeType_GIRDER, IfcBridgeType_SUSPENSION, IfcBridgeType_TRUSS, IfcBridgeType_USERDEFINED, IfcBridgeType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBridgeTypeEnum (IfcEntityInstanceData&& e);
    IfcBridgeTypeEnum (Value v);
    IfcBridgeTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBuildingElementPartTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the different types of building element parts:
/// 
/// INSULATION: The part provides thermal insulation, for example as insulation layer between wall panels in sandwich walls or as infill in stud walls.
/// PRECASTPANEL: The part is a precast panel, usually as an internal or external layer in a sandwich wall panel.
/// USERDEFINED: User-defined accessory
/// NOTDEFINED: Undefined accessory
/// 
/// HISTORY New Enumeration in IFC 2x4.
public:
    typedef enum {IfcBuildingElementPartType_INSULATION, IfcBuildingElementPartType_PRECASTPANEL, IfcBuildingElementPartType_APRON, IfcBuildingElementPartType_ARMOURUNIT, IfcBuildingElementPartType_SAFETYCAGE, IfcBuildingElementPartType_USERDEFINED, IfcBuildingElementPartType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBuildingElementPartTypeEnum (IfcEntityInstanceData&& e);
    IfcBuildingElementPartTypeEnum (Value v);
    IfcBuildingElementPartTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBuildingElementProxyTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
///   available generic types for IfcBuildingElementProxyType.
/// 
/// HISTORY New enumeration
///   inRelease IFC2x Edition 3.
/// 
/// Enumeration
/// 
/// USERDEFINED
/// 
/// NOTDEFINED
public:
    typedef enum {IfcBuildingElementProxyType_COMPLEX, IfcBuildingElementProxyType_ELEMENT, IfcBuildingElementProxyType_PARTIAL, IfcBuildingElementProxyType_PROVISIONFORVOID, IfcBuildingElementProxyType_PROVISIONFORSPACE, IfcBuildingElementProxyType_USERDEFINED, IfcBuildingElementProxyType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBuildingElementProxyTypeEnum (IfcEntityInstanceData&& e);
    IfcBuildingElementProxyTypeEnum (Value v);
    IfcBuildingElementProxyTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBuildingSystemTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration identifies
/// different types of distribution systems.
/// HISTORY New enumeration
/// in IFC2x4.
/// Valid enumerations for building systems include:
/// 
/// FENESTRATION: System of doors, windows, and other
/// fillings in opening in a building envelop that are designed to
/// permit the passage of air or light,
/// SHADING: System of shading elements (external or
/// internal) that permits the limitation or control of impact of
/// natural sun light,
/// TRANSPORT: System of all transport elements in a
/// building that enables the transport of people or goods.
public:
    typedef enum {IfcBuildingSystemType_FENESTRATION, IfcBuildingSystemType_FOUNDATION, IfcBuildingSystemType_LOADBEARING, IfcBuildingSystemType_OUTERSHELL, IfcBuildingSystemType_SHADING, IfcBuildingSystemType_TRANSPORT, IfcBuildingSystemType_REINFORCING, IfcBuildingSystemType_PRESTRESSING, IfcBuildingSystemType_EROSIONPREVENTION, IfcBuildingSystemType_USERDEFINED, IfcBuildingSystemType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBuildingSystemTypeEnum (IfcEntityInstanceData&& e);
    IfcBuildingSystemTypeEnum (Value v);
    IfcBuildingSystemTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBuiltSystemTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcBuiltSystemType_REINFORCING, IfcBuiltSystemType_MOORING, IfcBuiltSystemType_OUTERSHELL, IfcBuiltSystemType_TRACKCIRCUIT, IfcBuiltSystemType_EROSIONPREVENTION, IfcBuiltSystemType_FOUNDATION, IfcBuiltSystemType_LOADBEARING, IfcBuiltSystemType_SHADING, IfcBuiltSystemType_FENESTRATION, IfcBuiltSystemType_MOORINGSYSTEM, IfcBuiltSystemType_TRANSPORT, IfcBuiltSystemType_PRESTRESSING, IfcBuiltSystemType_USERDEFINED, IfcBuiltSystemType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBuiltSystemTypeEnum (IfcEntityInstanceData&& e);
    IfcBuiltSystemTypeEnum (Value v);
    IfcBuiltSystemTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcBurnerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the functional type of burner.
///   The IfcBurnerTypeEnum contains the following:
/// 
/// USERDEFINED: User-defined burner type.
///   NOTDEFINED:  Undefined burner type.
/// 
/// HISTORY: New enumeration in IFC R2x4.
public:
    typedef enum {IfcBurnerType_USERDEFINED, IfcBurnerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcBurnerTypeEnum (IfcEntityInstanceData&& e);
    IfcBurnerTypeEnum (Value v);
    IfcBurnerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCableCarrierFittingTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcCableCarrierFittingTypeEnum defines the range of different types of cable carrier fitting that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BEND: A fitting that changes the route of the cable carrier. 
/// CROSS: A fitting at which two branches are taken from the main route of the cable carrier simultaneously. 
/// REDUCER: A fitting that changes the physical size of the main route of the cable carrier. 
/// TEE: A fitting at which a branch is taken from the main route of the cable carrier. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCableCarrierFittingType_BEND, IfcCableCarrierFittingType_CROSS, IfcCableCarrierFittingType_REDUCER, IfcCableCarrierFittingType_TEE, IfcCableCarrierFittingType_USERDEFINED, IfcCableCarrierFittingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCableCarrierFittingTypeEnum (IfcEntityInstanceData&& e);
    IfcCableCarrierFittingTypeEnum (Value v);
    IfcCableCarrierFittingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCableCarrierSegmentTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcCableCarrierSegmentTypeEnum defines the range of different types of cable carrier segment that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// CABLELADDERSEGMENT: An open carrier segment on which cables are carried on a ladder structure.
/// CABLETRAYSEGMENT: A (typically) open carrier segment onto which cables are laid.
/// CABLETRUNKINGSEGMENT: An enclosed carrier segment with one or more compartments into which cables are placed.
/// CONDUITSEGMENT: An enclosed tubular carrier segment through which cables are pulled.
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCableCarrierSegmentType_CABLELADDERSEGMENT, IfcCableCarrierSegmentType_CABLETRAYSEGMENT, IfcCableCarrierSegmentType_CABLETRUNKINGSEGMENT, IfcCableCarrierSegmentType_CONDUITSEGMENT, IfcCableCarrierSegmentType_CABLEBRACKET, IfcCableCarrierSegmentType_CATENARYWIRE, IfcCableCarrierSegmentType_DROPPER, IfcCableCarrierSegmentType_USERDEFINED, IfcCableCarrierSegmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCableCarrierSegmentTypeEnum (IfcEntityInstanceData&& e);
    IfcCableCarrierSegmentTypeEnum (Value v);
    IfcCableCarrierSegmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCableFittingTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcCableFittingTypeEnum defines the range of different types of cable fitting that can be specified. 
///   HISTORY: New type in IFC 2x4  
///   Enumeration 
/// 
/// CONNECTOR: A fitting that joins two cable segments of the same connector type (though potentially different gender). 
/// ENTRY: A fitting that begins a cable segment at a non-electrical element such as a grounding clamp attached to a pipe. 
/// EXIT: A fitting that ends a cable segment at a non-electrical element such as a grounding clamp attached to a pipe or to the ground.  
/// JUNCTION: A fitting that joins three or more segments of arbitrary connector types for signal splitting or multiplexing.  
/// TRANSITION: A fitting that joins two cable segments of different connector types.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCableFittingType_CONNECTOR, IfcCableFittingType_ENTRY, IfcCableFittingType_EXIT, IfcCableFittingType_JUNCTION, IfcCableFittingType_TRANSITION, IfcCableFittingType_FANOUT, IfcCableFittingType_USERDEFINED, IfcCableFittingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCableFittingTypeEnum (IfcEntityInstanceData&& e);
    IfcCableFittingTypeEnum (Value v);
    IfcCableFittingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCableSegmentTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcCableSegmentTypeEnum defines the range of different types of cable segment that can be specified. 
/// 
/// HISTORY: New type in IFC
///   2x2. Core and busbar segment added in IFC 2x4.  
///   Enumeration 
/// 
/// BUSBARSEGMENT: Electrical conductor that makes a common connection between several electrical circuits. Properties of a busbar are the same as those of a cable segment and are captured by the cable segment property set. 
/// CABLESEGMENT: Cable with a specific purpose to lead electric current within a circuit or any other electric construction. Includes all types of electric cables, mainly several core segments or conductor segments wrapped together. 
/// CONDUCTORSEGMENT: A single linear element within a cable or an exposed wire (such as for grounding) with the specific purpose to lead electric current, data, or a telecommunications signal.  
/// CORESEGMENT: A self contained element of a  cable that comprises one or more conductors and sheathing.The core of one lead is normally single wired or multiwired which are intertwined.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCableSegmentType_BUSBARSEGMENT, IfcCableSegmentType_CABLESEGMENT, IfcCableSegmentType_CONDUCTORSEGMENT, IfcCableSegmentType_CORESEGMENT, IfcCableSegmentType_CONTACTWIRESEGMENT, IfcCableSegmentType_FIBERSEGMENT, IfcCableSegmentType_FIBERTUBE, IfcCableSegmentType_OPTICALCABLESEGMENT, IfcCableSegmentType_STITCHWIRE, IfcCableSegmentType_WIREPAIRSEGMENT, IfcCableSegmentType_USERDEFINED, IfcCableSegmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCableSegmentTypeEnum (IfcEntityInstanceData&& e);
    IfcCableSegmentTypeEnum (Value v);
    IfcCableSegmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCaissonFoundationTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcCaissonFoundationType_WELL, IfcCaissonFoundationType_CAISSON, IfcCaissonFoundationType_USERDEFINED, IfcCaissonFoundationType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCaissonFoundationTypeEnum (IfcEntityInstanceData&& e);
    IfcCaissonFoundationTypeEnum (Value v);
    IfcCaissonFoundationTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcChangeActionEnum : public IfcUtil::IfcBaseType {
/// IfcChangeActionEnum identifies the type of change that might have occurred to the object during the last session (for example, added, modified, deleted). This information is required in a partial model exchange scenario so that an application or model server will know how an object might have been affected by the previous application. Valid enumerations are:
/// 
/// NOCHANGE: Object has not been modified.
/// MODIFIED: A modification to the object has been made by the user and application defined by the LastModifyingUser and LastModifyingApplication respectively.
/// ADDED: The object has been created by the user and application defined by the OwningUser and OwningApplication respectively.
/// DELETED: The object has been deleted by the user and application defined by the LastModifyingUser and LastModifyingApplication respectively.
/// NOTDEFINED: The change action is not known or has not been defined.
/// 
/// Consider Application A will create an IFC dataset that it wants to publish to others for modification and have the ability to subsequently merge these changes back into the original model. Before publication, it may want to set the IfcChangeActionEnum to NOCHANGE to establish a baseline so that other application changes can be easily identified. Application B then receives this IFC dataset and adds a new object and sets IfcChangeActionEnum to ADDED with Application B defined as the OwningApplication. Application B then modifies an existing object and (re)defines the LastModifiedDate to the time of the modification, LastModifyingUser to the IfcPersonAndOrganization making the change, and sets the LastModifyingApplication to Application B. When Application A receives this modified dataset, it can determine which objects have been added and modified by Application B and either merge or reject these changes as necessary. Consequently, the intent is that an application only modifies the value of IfcChangeActionEnum when it does something to the object, with the further intent that a model server is responsible for clearing the IfcChangeActionEnum back to NOCHANGE when it is ready to be republished.
/// 
/// HISTORY: New enumeration in IFC R2.0. Modified in IFC2x4.
public:
    typedef enum {IfcChangeAction_NOCHANGE, IfcChangeAction_MODIFIED, IfcChangeAction_ADDED, IfcChangeAction_DELETED, IfcChangeAction_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcChangeActionEnum (IfcEntityInstanceData&& e);
    IfcChangeActionEnum (Value v);
    IfcChangeActionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcChillerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of Chillers classified by their method of heat rejection. 
///   The IfcChillerTypeEnum contains the following:
/// 
/// AIRCOOLED: Air cooled chiller.
///   WATERCOOLED: Water cooled chiller.
///   HEATRECOVERY: Heat recovery chiller.
///   USERDEFINED:	User-defined chiller type.
///   NOTDEFINED: Undefined chiller type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcChillerType_AIRCOOLED, IfcChillerType_WATERCOOLED, IfcChillerType_HEATRECOVERY, IfcChillerType_USERDEFINED, IfcChillerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcChillerTypeEnum (IfcEntityInstanceData&& e);
    IfcChillerTypeEnum (Value v);
    IfcChillerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcChimneyTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the valid
///   types of chimneys that can be predefined using the
///   enumeration values.
/// 
/// HISTORY New Enumeration in
///   ReleaseIFC2x4
/// 
/// NOTE Currently there are no specific enumerators
///   defined, the IfcChimneyTypeEnum has been added
///   for future extensions.
public:
    typedef enum {IfcChimneyType_USERDEFINED, IfcChimneyType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcChimneyTypeEnum (IfcEntityInstanceData&& e);
    IfcChimneyTypeEnum (Value v);
    IfcChimneyTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCoilTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of coils.
/// 
/// The IfcCoilTypeEnum contains the following:
/// 
/// DXCOOLINGCOIL: Cooling coil using a refrigerant to cool the air stream directly.
/// 
/// WATERCOOLINGCOIL: Cooling coil using chilled water. HYDRONICCOIL supercedes this enumerator.
/// 
/// STEAMHEATINGCOIL: Heating coil using steam as heating source.
/// 
/// WATERHEATINGCOIL: Heating coil using hot water as a heating source. HYDRONICCOIL supercedes this enumerator.
/// 
/// ELECTRICHEATINGCOIL: Heating coil using electricity as a heating source.
/// 
/// GASHEATINGCOIL: Heating coil using gas as a heating source.
/// 
/// HYDRONICCOIL: Cooling or Heating coil that uses a hydronic fluid as a cooling or heating source.
///   USERDEFINED: User-defined coil type.
/// 
/// NOTDEFINED:  Undefined coil type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcCoilType_DXCOOLINGCOIL, IfcCoilType_ELECTRICHEATINGCOIL, IfcCoilType_GASHEATINGCOIL, IfcCoilType_HYDRONICCOIL, IfcCoilType_STEAMHEATINGCOIL, IfcCoilType_WATERCOOLINGCOIL, IfcCoilType_WATERHEATINGCOIL, IfcCoilType_USERDEFINED, IfcCoilType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCoilTypeEnum (IfcEntityInstanceData&& e);
    IfcCoilTypeEnum (Value v);
    IfcCoilTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcColumnTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcColumnType object
/// can fulfill:
/// 
/// COLUMN: A standard column element usually used
/// vertically.
/// USERDEFINED: User-defined linear element.
/// NOTDEFINED: Undefined linear element
/// 
/// NOTE: This enumeration has been mainly
/// introduced to allow further detailing of the type information in
/// future releases of IFC.
/// HISTORY New Enumeration
/// in Release IFC2x Edition 2.
public:
    typedef enum {IfcColumnType_COLUMN, IfcColumnType_PILASTER, IfcColumnType_PIERSTEM, IfcColumnType_PIERSTEM_SEGMENT, IfcColumnType_STANDCOLUMN, IfcColumnType_USERDEFINED, IfcColumnType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcColumnTypeEnum (IfcEntityInstanceData&& e);
    IfcColumnTypeEnum (Value v);
    IfcColumnTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCommunicationsApplianceTypeEnum : public IfcUtil::IfcBaseType {
/// Defines the range of different types of communications appliance that can be specified. 
/// 
/// HISTORY: New enumeration in IFC2x4 
/// 
/// ANTENNA: A transducer designed to transmit or receive electromagnetic waves. 
/// COMPUTER: A desktop, laptop, PDA or other type of computer that can be moved from one place to another and connected to an electrical supply via a plugged outlet. 
/// FAX: A machine that has the primary function of transmitting a facsimile copy of printed matter using a telephone line. 
/// GATEWAY: A gateway connects multiple network segments with different protocols at all layers (layers 1-7) of the OSI model 
/// MODEM: A modem (from modulator-demodulator) is a device that modulates an analog carrier signal to encode digital information, and also demodulates such a carrier signal to decode the transmitted information 
/// NETWORKAPPLIANCE: A network appliance performs a dedicated function such as firewall protection, content filtering, load balancing, or equipment management. 
/// NETWORKBRIDGE: A network bridge connects multiple network segments at the data link layer (layer 2) of the OSI model, and the term layer 2 switch is very often used interchangeably with bridge 
/// NETWORKHUB: A network hub connects multiple network segments at the physical layer (layer 1) of the OSI model. 
/// PRINTER: A machine that has the primary function of printing text and/or graphics onto paper or other media. 
/// REPEATER: A repeater is an electronic device that receives a signal and retransmits it at a higher level and/or higher power, or onto the other side of an obstruction, so that the signal can cover longer distances without degradation. 
/// ROUTER: A router is a networking device whose software and hardware are usually tailored to the tasks of routing and forwarding information. For example, on the Internet, information is directed to various paths by routers. 
/// SCANNER: A machine that has the primary function of scanning the content of printed matter and converting it to digital format that can be stored in a computer.
public:
    typedef enum {IfcCommunicationsApplianceType_ANTENNA, IfcCommunicationsApplianceType_COMPUTER, IfcCommunicationsApplianceType_FAX, IfcCommunicationsApplianceType_GATEWAY, IfcCommunicationsApplianceType_MODEM, IfcCommunicationsApplianceType_NETWORKAPPLIANCE, IfcCommunicationsApplianceType_NETWORKBRIDGE, IfcCommunicationsApplianceType_NETWORKHUB, IfcCommunicationsApplianceType_PRINTER, IfcCommunicationsApplianceType_REPEATER, IfcCommunicationsApplianceType_ROUTER, IfcCommunicationsApplianceType_SCANNER, IfcCommunicationsApplianceType_AUTOMATON, IfcCommunicationsApplianceType_INTELLIGENT_PERIPHERAL, IfcCommunicationsApplianceType_IP_NETWORK_EQUIPMENT, IfcCommunicationsApplianceType_OPTICAL_NETWORK_UNIT, IfcCommunicationsApplianceType_TELECOMMAND, IfcCommunicationsApplianceType_TELEPHONYEXCHANGE, IfcCommunicationsApplianceType_TRANSITIONCOMPONENT, IfcCommunicationsApplianceType_TRANSPONDER, IfcCommunicationsApplianceType_TRANSPORTEQUIPMENT, IfcCommunicationsApplianceType_USERDEFINED, IfcCommunicationsApplianceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCommunicationsApplianceTypeEnum (IfcEntityInstanceData&& e);
    IfcCommunicationsApplianceTypeEnum (Value v);
    IfcCommunicationsApplianceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcComplexPropertyTemplateTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the subtype of instances of IfcComplexProperty or IfcPhysicalComplexQuantity that may be created and defined by an IfcComplexPropertyTemplate.
/// 
/// HISTORY New enumeration in IFC2x4.
/// 
/// Enumeration
/// 
/// P_COMPLEX: the properties defined by this IfcComplexPropertyTemplate are of type IfcComplexProperty.
/// Q_COMPLEX: the properties defined by this IfcComplexPropertyTemplate are of type IfcPhysicalComplexQuantity.
public:
    typedef enum {IfcComplexPropertyTemplateType_P_COMPLEX, IfcComplexPropertyTemplateType_Q_COMPLEX} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcComplexPropertyTemplateTypeEnum (IfcEntityInstanceData&& e);
    IfcComplexPropertyTemplateTypeEnum (Value v);
    IfcComplexPropertyTemplateTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCompressorTypeEnum : public IfcUtil::IfcBaseType {
/// Types of compressors.
///   The IfcCompressorTypeEnum contains the following:
/// 
/// DYNAMIC: The pressure of refrigerant vapor is increased by a continuous transfer of angular momentum from a rotating member to the vapor followed by conversion of this momentum into static pressure.
///   RECIPROCATING: Positive-displacement compressor using a piston driven by a connecting rod from a crankshaft.
///   ROTARY: Positive-displacement compressor using a roller or rotor device.
///   SCROLL: Positive-displacement compressor using two inter-fitting, spiral-shaped scroll members.
///   TROCHOIDAL: Positive-displacement compressor using a rolling motion of one circle outside or inside the circumference of a basic circle and produce either epitrochoids or hypotrochoids.
///   SINGLESTAGE: Positive-displacement reciprocating compressor where vapor is compressed in a single stage.
///   BOOSTER: Positive-displacement reciprocating compressor where pressure is increased by a booster.
///   OPENTYPE: Positive-displacement reciprocating compressor where the shaft extends through a seal in the crankcase for an external drive.
///   HERMETIC: Positive-displacement reciprocating compressor where the motor and compressor are contained within the same housing, with the motor shaft integral with the compressor crankshaft and the motor in contact with refrigerant.
///   SEMIHERMETIC: Positive-displacement reciprocating compressor where the hermetic compressors use bolted construction amenable to field repair.
///   WELDEDSHELLHERMETIC: Positive-displacement reciprocating compressor where the motor compressor is mounted inside a steel shell, which, in turn is sealed by welding.
///   ROLLINGPISTON: Positive-displacement rotary compressor using a roller mounted on the eccentric of a shaft with a single vane in the nonrotating cylindrical housing.
///   ROTARYVANE: Positive-displacement rotary compressor using a roller mounted on the eccentric of a shaft with multiple vanes in the nontotating cylindrical housing.
///   SINGLESCREW: Positive-displacement rotary compressor using a single cylindrical main rotor that works with a pair of gate rotors.
///   TWINSCREW: Positive-displacement rotary compressor using two mating helically grooved rotors, male (lobes) and female (flutes) in a stationary housing with inlet and outlet gas ports.
///   USERDEFINED: User-defined compressor type.
///   NOTDEFINED:  Undefined compressor type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcCompressorType_DYNAMIC, IfcCompressorType_RECIPROCATING, IfcCompressorType_ROTARY, IfcCompressorType_SCROLL, IfcCompressorType_TROCHOIDAL, IfcCompressorType_SINGLESTAGE, IfcCompressorType_BOOSTER, IfcCompressorType_OPENTYPE, IfcCompressorType_HERMETIC, IfcCompressorType_SEMIHERMETIC, IfcCompressorType_WELDEDSHELLHERMETIC, IfcCompressorType_ROLLINGPISTON, IfcCompressorType_ROTARYVANE, IfcCompressorType_SINGLESCREW, IfcCompressorType_TWINSCREW, IfcCompressorType_USERDEFINED, IfcCompressorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCompressorTypeEnum (IfcEntityInstanceData&& e);
    IfcCompressorTypeEnum (Value v);
    IfcCompressorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCondenserTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of condensers.  Air is used as the cooling medium for AIRCOOLED; water is used as the cooling medium for all other types.  The IfcCondenserTypeEnum contains the following:
/// 
/// AIRCOOLED: A condenser in which heat is transferred to an air-stream.
///   EVAPORATIVECOOLED: A condenser that is cooled evaporatively.
///   WATERCOOLED: Water-cooled condenser with unspecified operation.
///   WATERCOOLEDSHELLTUBE: Water-cooled condenser with cooling water circulated through one or more tubes contained within the shell.
///   WATERCOOLEDSHELLCOIL: Water-cooled condenser with cooling water circulated through one or more continuous or assembled coils contained within the shell.
///   WATERCOOLEDTUBEINTUBE: Water-cooled condenser consisting of one or more assemblies of two tubes, one within the other.
///   WATERCOOLEDBRAZEDPLATE: Water-cooled condenser condenser with plates brazed together to form an assembly of separate channels.
///   USERDEFINED: User-defined condenser type.
///   NOTDEFINED:  Undefined condenser type.
/// 
/// HISTORY: New enumeration in IFC 2x2.  WATERCOOLED added in IFC 2x4.
public:
    typedef enum {IfcCondenserType_AIRCOOLED, IfcCondenserType_EVAPORATIVECOOLED, IfcCondenserType_WATERCOOLED, IfcCondenserType_WATERCOOLEDBRAZEDPLATE, IfcCondenserType_WATERCOOLEDSHELLCOIL, IfcCondenserType_WATERCOOLEDSHELLTUBE, IfcCondenserType_WATERCOOLEDTUBEINTUBE, IfcCondenserType_USERDEFINED, IfcCondenserType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCondenserTypeEnum (IfcEntityInstanceData&& e);
    IfcCondenserTypeEnum (Value v);
    IfcCondenserTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConnectionTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the different ways how path based elements (such as IfcWallStandardCase) can connect, as shown in Figure 65. 
/// 
/// HISTORY New type in IFC Release 2.0 
/// 
/// L-Shape Connection 
/// 
/// RelatingConnectionType: AtStart 
///   RelatedConnectionType: AtStart 
/// 
/// L-Shape Connection 
/// 
/// RelatingConnectionType: AtEnd 
///   RelatedConnectionType: AtStart 
/// 
/// T-Shape Connection 
/// 
/// RelatingConnectionType: AtPath 
///   RelatedConnectionType: AtStart 
/// 
/// Figure 65 — Connection types</td
public:
    typedef enum {IfcConnectionType_ATPATH, IfcConnectionType_ATSTART, IfcConnectionType_ATEND, IfcConnectionType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConnectionTypeEnum (IfcEntityInstanceData&& e);
    IfcConnectionTypeEnum (Value v);
    IfcConnectionTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConstraintEnum : public IfcUtil::IfcBaseType {
/// IfcConstraintEnum is an enumeration used to qualify a constraint. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// HARD 
///   Qualifies a constraint such that it must be followed rigidly within or at the values set. 
/// 
/// SOFT 
///   Qualifies a constraint such that it should be followed within or at the values set. 
/// 
/// ADVISORY 
///   Qualifies a constraint such that it is advised that it is followed within or at the values set.
public:
    typedef enum {IfcConstraint_HARD, IfcConstraint_SOFT, IfcConstraint_ADVISORY, IfcConstraint_USERDEFINED, IfcConstraint_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConstraintEnum (IfcEntityInstanceData&& e);
    IfcConstraintEnum (Value v);
    IfcConstraintEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConstructionEquipmentResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a construction equipment resource. It is limited to the most common equipment used in construction.  The IfcConstructionEquipmentResourceTypeEnum contains the following:
/// 
/// DEMOLISHING: Removal or destruction of building elements.
/// EARTHMOVING: Excavating, filling, or contouring earth.
/// ERECTING: Lifting, positioning, and placing elements.
/// HEATING: Temporary heat to support construction.
/// LIGHTING: Temporary lighting to support construction.
/// PAVING: Asphalt or concrete roads or walkways.
/// PUMPING: Installing materials through pumps.
/// TRANSPORTING: Transporting products or materials.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcConstructionEquipmentResourceType_DEMOLISHING, IfcConstructionEquipmentResourceType_EARTHMOVING, IfcConstructionEquipmentResourceType_ERECTING, IfcConstructionEquipmentResourceType_HEATING, IfcConstructionEquipmentResourceType_LIGHTING, IfcConstructionEquipmentResourceType_PAVING, IfcConstructionEquipmentResourceType_PUMPING, IfcConstructionEquipmentResourceType_TRANSPORTING, IfcConstructionEquipmentResourceType_USERDEFINED, IfcConstructionEquipmentResourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConstructionEquipmentResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcConstructionEquipmentResourceTypeEnum (Value v);
    IfcConstructionEquipmentResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConstructionMaterialResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a construction material resource. It is limited to the most common raw materials used in construction and excludes materials commonly sold as finished products.  The IfcConstructionMaterialResourceTypeEnum contains the following:
/// 
/// AGGREGATES: Construction aggregate including sand, gravel, and crushed stone.
/// CONCRETE: Cast-in-place concrete.
/// DRYWALL: Wall board, including gypsum board.
/// FUEL: Fuel for running equipment.
/// GYPSUM: Any gypsum material.
/// MASONRY: Masonry including brick, stone, concrete block, glass block, and tile.
/// METAL: Any metallic material.
/// PLASTIC: Any plastic material.
/// WOOD: Any wood material.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcConstructionMaterialResourceType_AGGREGATES, IfcConstructionMaterialResourceType_CONCRETE, IfcConstructionMaterialResourceType_DRYWALL, IfcConstructionMaterialResourceType_FUEL, IfcConstructionMaterialResourceType_GYPSUM, IfcConstructionMaterialResourceType_MASONRY, IfcConstructionMaterialResourceType_METAL, IfcConstructionMaterialResourceType_PLASTIC, IfcConstructionMaterialResourceType_WOOD, IfcConstructionMaterialResourceType_NOTDEFINED, IfcConstructionMaterialResourceType_USERDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConstructionMaterialResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcConstructionMaterialResourceTypeEnum (Value v);
    IfcConstructionMaterialResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConstructionProductResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a construction product resource. It describes use of products created for construction, and excludes products of the finished building model.  The IfcConstructionProductsResourceTypeEnum contains the following:
/// 
/// ASSEMBLY: Construction of assemblies for use as input to the building model or other assemblies.
/// FORMWORK: Construction or placement of forms for placing materials such as concrete.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcConstructionProductResourceType_ASSEMBLY, IfcConstructionProductResourceType_FORMWORK, IfcConstructionProductResourceType_USERDEFINED, IfcConstructionProductResourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConstructionProductResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcConstructionProductResourceTypeEnum (Value v);
    IfcConstructionProductResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcControllerTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcControllerTypeEnum defines the range of different types of controller that can be specified.
/// 
/// HISTORY: New type in IFC R2.0
///   Documentation extended in IFC 2x4. PROPORTIONALINTEGRAL and PROPORTIONALINTEGRALDERIVATIVE values deleted (property set enumeration now used).  MULTIPOSITION added.
/// 
/// Enumeration
/// 
/// FLOATING: Output increases or decreases at a constant or accelerating rate.
/// MULTIPOSITION: Output is discrete value, can be one of three or more values.
/// PROGRAMMABLE: Output is programmable such as Discrete Digital Control (DDC).
/// PROPORTIONAL: Output is proportional to the control error and optionally time integral and derivative.
/// TWOPOSITION: Output can be either on or off
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcControllerType_FLOATING, IfcControllerType_PROGRAMMABLE, IfcControllerType_PROPORTIONAL, IfcControllerType_MULTIPOSITION, IfcControllerType_TWOPOSITION, IfcControllerType_USERDEFINED, IfcControllerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcControllerTypeEnum (IfcEntityInstanceData&& e);
    IfcControllerTypeEnum (Value v);
    IfcControllerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcConveyorSegmentTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcConveyorSegmentType_CHUTECONVEYOR, IfcConveyorSegmentType_BELTCONVEYOR, IfcConveyorSegmentType_SCREWCONVEYOR, IfcConveyorSegmentType_BUCKETCONVEYOR, IfcConveyorSegmentType_USERDEFINED, IfcConveyorSegmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcConveyorSegmentTypeEnum (IfcEntityInstanceData&& e);
    IfcConveyorSegmentTypeEnum (Value v);
    IfcConveyorSegmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCooledBeamTypeEnum : public IfcUtil::IfcBaseType {
/// There are two general types of cooled or chilled beams: passive and active.
/// 
/// An active Cooled Beam uses a fan or other auxilliary device to aid in air recirculation, while a passive
/// 
/// Cooled Beam relies solely on convection to cool the space.
/// 
/// Enumeration defining the typical types of cooled beams.
/// 
/// The IfcCooledBeamTypeEnum contains the following:
/// 
/// ACTIVE: An active or ventilated cooled beam provides cooling (and heating) but can also function as an air terminal in a ventilation system.
/// 
/// PASSIVE: A passive or static cooled beam provides cooling (and heating) to a room or zone.
/// 
/// USERDEFINED: User-defined cooled beam type.
/// 
/// NOTDEFINED:  Undefined cooled beam type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcCooledBeamType_ACTIVE, IfcCooledBeamType_PASSIVE, IfcCooledBeamType_USERDEFINED, IfcCooledBeamType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCooledBeamTypeEnum (IfcEntityInstanceData&& e);
    IfcCooledBeamTypeEnum (Value v);
    IfcCooledBeamTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCoolingTowerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of cooling towers. 
///   The IfcCoolingTowerTypeEnum contains the following:
/// 
/// NATURALDRAFT: Air flow is produced naturally.
///   MECHANICALINDUCEDDRAFT: Air flow is produced by a mechanical device, typically one or more fans, located on 
/// the air outlet side of the cooling tower.
///   MECHANICALFORCEDDRAFT: Air flow is produced by a mechanical device, typically one or more fans, located on 
/// the inlet air side of the cooling tower.
///   USERDEFINED:  User-defined cooling tower type.
///   NOTDEFINED:  Undefined cooling tower type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcCoolingTowerType_NATURALDRAFT, IfcCoolingTowerType_MECHANICALINDUCEDDRAFT, IfcCoolingTowerType_MECHANICALFORCEDDRAFT, IfcCoolingTowerType_USERDEFINED, IfcCoolingTowerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCoolingTowerTypeEnum (IfcEntityInstanceData&& e);
    IfcCoolingTowerTypeEnum (Value v);
    IfcCoolingTowerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCostItemTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcCostItemTypeEnum is a list of the available types of cost items. 
///   HISTORY: New type in IFC2x4  
///   Enumeration 
/// 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCostItemType_USERDEFINED, IfcCostItemType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCostItemTypeEnum (IfcEntityInstanceData&& e);
    IfcCostItemTypeEnum (Value v);
    IfcCostItemTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCostScheduleTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcCostScheduleTypeEnum is a list of the available types of cost schedule from which that required may be selected. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BUDGET: An allocation of money for a particular purpose. 
/// COSTPLAN: An assessment of the amount of money needing to be expended for a defined purpose based on incomplete information about the goods and services required for a construction or installation.  
/// ESTIMATE: An assessment of the amount of money needing to be expended for a defined purpose based on actual information about the goods and services required for a construction or installation. 
/// TENDER: An offer to provide goods and services.  
/// PRICEDBILLOFQUANTITIES: A complete listing of all work items forming construction or installation works in which costs have been allocated to work items.  
/// UNPRICEDBILLOFQUANTITIES: A complete listing of all work items forming construction or installation works in which costs have not yet been allocated to work items. 
/// SCHEDULEOFRATES: A listing of each type of goods forming construction or installation works with the cost of purchase, construction/installation, overheads and profit assigned so that additional items of that type can be costed.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcCostScheduleType_BUDGET, IfcCostScheduleType_COSTPLAN, IfcCostScheduleType_ESTIMATE, IfcCostScheduleType_TENDER, IfcCostScheduleType_PRICEDBILLOFQUANTITIES, IfcCostScheduleType_UNPRICEDBILLOFQUANTITIES, IfcCostScheduleType_SCHEDULEOFRATES, IfcCostScheduleType_USERDEFINED, IfcCostScheduleType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCostScheduleTypeEnum (IfcEntityInstanceData&& e);
    IfcCostScheduleTypeEnum (Value v);
    IfcCostScheduleTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCourseTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcCourseType_ARMOUR, IfcCourseType_FILTER, IfcCourseType_BALLASTBED, IfcCourseType_CORE, IfcCourseType_PAVEMENT, IfcCourseType_PROTECTION, IfcCourseType_USERDEFINED, IfcCourseType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCourseTypeEnum (IfcEntityInstanceData&& e);
    IfcCourseTypeEnum (Value v);
    IfcCourseTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCoveringTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the range
/// of different types of covering that can further specify an
/// IfcCovering or an IfcCoveringType.
/// HISTORY New enumeration
/// in IFC Release 1.0
/// IFC2x4 CHANGE The following
/// enumerators of the IfcCoveringTypeEnum have been
/// deprecated INSULATION, SLEEVING and
/// WRAPPING.
/// Enumeration
/// 
/// CEILING: the covering is used to
/// represent a ceiling
/// FLOORING: the covering is used to
/// represent a flooring
/// CLADDING: the covering is used to
/// represent a cladding
/// ROOFING: the covering is used to
/// represent a roof
/// 
/// INSULATION: the covering is used to
/// insulate an element for thermal or acoustic purposes.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// MEMBRANE: an impervious layer that
/// could be used for e.g. roof covering (below tiling - that may be
/// known as sarking etc.) or as a damp proof course membrane
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// SLEEVING: the covering is used to
/// isolate a distribution element from a space in which it is
/// contained.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// WRAPPING: the covering is used for
/// wrapping particularly of distribution elements using tape.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// 
/// USERDEFINED: user defined type of
/// covering
/// NOTDEFINED: undefined type of
/// covering
public:
    typedef enum {IfcCoveringType_CEILING, IfcCoveringType_FLOORING, IfcCoveringType_CLADDING, IfcCoveringType_ROOFING, IfcCoveringType_MOLDING, IfcCoveringType_SKIRTINGBOARD, IfcCoveringType_INSULATION, IfcCoveringType_MEMBRANE, IfcCoveringType_SLEEVING, IfcCoveringType_WRAPPING, IfcCoveringType_COPING, IfcCoveringType_USERDEFINED, IfcCoveringType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCoveringTypeEnum (IfcEntityInstanceData&& e);
    IfcCoveringTypeEnum (Value v);
    IfcCoveringTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCrewResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a crew resource.  The IfcCrewResourceTypeEnum contains the following:
/// 
/// OFFICE: A composition of resources performing administration work in an office.
/// SITE: A composition of resources performing production work on a construction site.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcCrewResourceType_OFFICE, IfcCrewResourceType_SITE, IfcCrewResourceType_USERDEFINED, IfcCrewResourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCrewResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcCrewResourceTypeEnum (Value v);
    IfcCrewResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCurtainWallTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining
/// the valid types of curtain wall that can be predefined using the
/// enumeration values. 
/// HISTORY 
/// New Enumeration in Release IFC2x Edition 3
/// NOTE  Currently there
/// are no specific enumerators defined, the IfcCurtainWallTypeEnum
/// has
/// been added for future extensions.
public:
    typedef enum {IfcCurtainWallType_USERDEFINED, IfcCurtainWallType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCurtainWallTypeEnum (IfcEntityInstanceData&& e);
    IfcCurtainWallTypeEnum (Value v);
    IfcCurtainWallTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcCurveInterpolationEnum : public IfcUtil::IfcBaseType {
/// IfcCurveInterpolationEnum specifies the possible methods
/// for the interpolation of property values given as a curve.
/// 
/// HISTORY  New type in IFC2x4.
/// 
/// Enumeration
/// 
/// LINEAR: Indicates that values between the defined
/// values are to be found by linear interpolation.
/// LOG_LINEAR: Indicates that values between the defined
/// values are to be found by linear interpolation of the natural
/// logarithm (base e) of the values.
/// LOG_LOG: Indicates that values between the defined
/// values are to be found by linear interpolation of the Briggs'
/// logarithm (base 10) of the values.
/// NOTDEFINED: No interpolation information is
/// provided
public:
    typedef enum {IfcCurveInterpolation_LINEAR, IfcCurveInterpolation_LOG_LINEAR, IfcCurveInterpolation_LOG_LOG, IfcCurveInterpolation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcCurveInterpolationEnum (IfcEntityInstanceData&& e);
    IfcCurveInterpolationEnum (Value v);
    IfcCurveInterpolationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDamperTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the various types of damper:
/// 
/// BALANCINGDAMPER: Damper used for purposes of manually balancing pressure differences.  Commonly operated by mechanical adjustment.
/// BACKDRAFTDAMPER: Backdraft damper used to restrict the movement of air in one direction.  Commonly operated by mechanical spring.
/// BLASTDAMPER: Blast damper use to prevent protect occupants and equipment against overpressures resultant of an explosion.  Commonly operated by mechanical spring.
/// CONTROLDAMPER: Control damper used to modulate the flow of air by adjusting the position of the blades.  Commonly operated by an actuator of a building automation system.
/// FIREDAMPER: Fire damper used to prevent the spread of fire for a specified duration.  Commonly operated by fusable link that melts above a certain temperature.
/// FIRESMOKEDAMPER: Combination fire and smoke damper used to preven the spread of fire and smoke.  Commonly operated by a fusable link and a smoke detector
/// FUMEHOODEXHAUST: Fume hood exhaust damper.  Commonly operated by actuator.
/// GRAVITYDAMPER: Gravity damper closes from the force of gravity.  Commonly operated by gravitational weight.
/// GRAVITYRELIEFDAMPER: Gravity-relief damper used to allow air to move upon a buildup of enough pressure to overcome the gravitational force exerted upon the damper blades.  Commonly operated by gravitational weight.
/// RELIEFDAMPER: Relief damper used to allow air to move upon a buildup of a specified pressure differential.  Commonly operated by mechanical spring.
/// SMOKEDAMPER: Smoke damper used to prevent the spread of smoke.  Commonly operated by a smoke detector of a building automation system.
/// USERDEFINED: User-defined damper.
/// NOTDEFINED: Undefined damper.
/// 
/// HISTORY: New enumeration in IFC R2.0
public:
    typedef enum {IfcDamperType_BACKDRAFTDAMPER, IfcDamperType_BALANCINGDAMPER, IfcDamperType_BLASTDAMPER, IfcDamperType_CONTROLDAMPER, IfcDamperType_FIREDAMPER, IfcDamperType_FIRESMOKEDAMPER, IfcDamperType_FUMEHOODEXHAUST, IfcDamperType_GRAVITYDAMPER, IfcDamperType_GRAVITYRELIEFDAMPER, IfcDamperType_RELIEFDAMPER, IfcDamperType_SMOKEDAMPER, IfcDamperType_USERDEFINED, IfcDamperType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDamperTypeEnum (IfcEntityInstanceData&& e);
    IfcDamperTypeEnum (Value v);
    IfcDamperTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDataOriginEnum : public IfcUtil::IfcBaseType {
/// IfcDataOriginEnum identifies the origin of time data:
/// 
/// MEASURED: The origin of the time data is a measurement device.
///   PREDICTED: The time data are a prediction.
///   SIMULATED: The origin of the time data is a simulation.
///   NOTDEFINED: The origin of the time data is undefined.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcDataOrigin_MEASURED, IfcDataOrigin_PREDICTED, IfcDataOrigin_SIMULATED, IfcDataOrigin_USERDEFINED, IfcDataOrigin_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDataOriginEnum (IfcEntityInstanceData&& e);
    IfcDataOriginEnum (Value v);
    IfcDataOriginEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDerivedUnitEnum : public IfcUtil::IfcBaseType {
/// IfcDerivedUnitEnum is an enumeration type for allowed types of derived units.
/// ENUMERATION 
/// 
/// ACCELERATIONUNIT 
///   ANGULARVELOCITYUNIT 
///   COMPOUNDPLANEANGLEUNIT 
///   DYNAMICVISCOSITYUNIT 
///   HEATFLUXDENSITYUNIT 
///   INTEGERCOUNTRATEUNIT 
///   ISOTHERMALMOISTURECAPACITYUNIT 
///   KINEMATICVISCOSITYUNIT 
///   LINEARFORCEUNIT 
///   LINEARMOMENTUNIT 
///   LINEARSTIFFNESSUNIT 
///   LINEARVELOCITYUNIT 
///   MASSDENSITYUNIT 
///   MASSFLOWRATEUNIT 
///   MODULUSOFELASTICITYUNIT 
///   MODULUSOFSUBGRADEREACTIONUNIT 
///   MOISTUREDIFFUSIVITYUNIT 
///   MOLECULARWEIGHTUNIT 
///   MOMENTORINERTIAUNIT 
///   PLANARFORCEUNIT 
///   ROTATIONALFREQUENCYUNIT 
///   ROTATIONALSTIFFNESSUNIT 
///   SHEARMODULUSUNIT 
///   SPECIFICHEATCAPACITYUNIT 
///   THERMALADMITTANCEUNIT 
///   THERMALCONDUCTANCEUNIT 
///   THERMALRESISTANCEUNIT 
///   THERMALTRANSMITTANCEUNIT 
///   TORQUEUNIT 
///   VAPORPERMEABILITYUNIT 
///   VOLUMETRICFLOWRATEUNIT 
///   CURVATUREUNIT 
///   HEATINGVALUEUNIT 
///   IONCONCENTRATIONUNIT 
///   LUMINOUSINTENSITYDISTRIBUTIONUNIT 
///   MASSPERLENGTHUNIT 
///   MODULUSOFLINEARSUBGRADEREACTIONUNIT 
///   MODULUSOFROTATIONALSUBGRADEREACTIONUNIT 
///   PHUNIT 
///   ROTATIONALMASSUNIT 
///   SECTIONAREAINTEGRALUNIT 
///   SECTIONMODULUSUNIT 
///   SOUNDPOWERUNIT 
///   SOUNDPRESSUREUNIT 
///   TEMPERATUREGRADIENTUNIT 
///   TEMPERATURERATEOFCHANGE 
///   THERMALEXPANSIONCOEFFICIENTUNIT 
///   WARPINGCONSTANTUNIT 
///   WARPINGMOMENTUNIT 
///   USERDEFINED: User defined derived unit. 
/// 
/// HISTORY: New type in IFC Release 2.0.
/// 
/// IFC 2x4 change: added TEMPERATURERATEOFCHANGE.
public:
    typedef enum {IfcDerivedUnit_ANGULARVELOCITYUNIT, IfcDerivedUnit_AREADENSITYUNIT, IfcDerivedUnit_COMPOUNDPLANEANGLEUNIT, IfcDerivedUnit_DYNAMICVISCOSITYUNIT, IfcDerivedUnit_HEATFLUXDENSITYUNIT, IfcDerivedUnit_INTEGERCOUNTRATEUNIT, IfcDerivedUnit_ISOTHERMALMOISTURECAPACITYUNIT, IfcDerivedUnit_KINEMATICVISCOSITYUNIT, IfcDerivedUnit_LINEARVELOCITYUNIT, IfcDerivedUnit_MASSDENSITYUNIT, IfcDerivedUnit_MASSFLOWRATEUNIT, IfcDerivedUnit_MOISTUREDIFFUSIVITYUNIT, IfcDerivedUnit_MOLECULARWEIGHTUNIT, IfcDerivedUnit_SPECIFICHEATCAPACITYUNIT, IfcDerivedUnit_THERMALADMITTANCEUNIT, IfcDerivedUnit_THERMALCONDUCTANCEUNIT, IfcDerivedUnit_THERMALRESISTANCEUNIT, IfcDerivedUnit_THERMALTRANSMITTANCEUNIT, IfcDerivedUnit_VAPORPERMEABILITYUNIT, IfcDerivedUnit_VOLUMETRICFLOWRATEUNIT, IfcDerivedUnit_ROTATIONALFREQUENCYUNIT, IfcDerivedUnit_TORQUEUNIT, IfcDerivedUnit_MOMENTOFINERTIAUNIT, IfcDerivedUnit_LINEARMOMENTUNIT, IfcDerivedUnit_LINEARFORCEUNIT, IfcDerivedUnit_PLANARFORCEUNIT, IfcDerivedUnit_MODULUSOFELASTICITYUNIT, IfcDerivedUnit_SHEARMODULUSUNIT, IfcDerivedUnit_LINEARSTIFFNESSUNIT, IfcDerivedUnit_ROTATIONALSTIFFNESSUNIT, IfcDerivedUnit_MODULUSOFSUBGRADEREACTIONUNIT, IfcDerivedUnit_ACCELERATIONUNIT, IfcDerivedUnit_CURVATUREUNIT, IfcDerivedUnit_HEATINGVALUEUNIT, IfcDerivedUnit_IONCONCENTRATIONUNIT, IfcDerivedUnit_LUMINOUSINTENSITYDISTRIBUTIONUNIT, IfcDerivedUnit_MASSPERLENGTHUNIT, IfcDerivedUnit_MODULUSOFLINEARSUBGRADEREACTIONUNIT, IfcDerivedUnit_MODULUSOFROTATIONALSUBGRADEREACTIONUNIT, IfcDerivedUnit_PHUNIT, IfcDerivedUnit_ROTATIONALMASSUNIT, IfcDerivedUnit_SECTIONAREAINTEGRALUNIT, IfcDerivedUnit_SECTIONMODULUSUNIT, IfcDerivedUnit_SOUNDPOWERLEVELUNIT, IfcDerivedUnit_SOUNDPOWERUNIT, IfcDerivedUnit_SOUNDPRESSURELEVELUNIT, IfcDerivedUnit_SOUNDPRESSUREUNIT, IfcDerivedUnit_TEMPERATUREGRADIENTUNIT, IfcDerivedUnit_TEMPERATURERATEOFCHANGEUNIT, IfcDerivedUnit_THERMALEXPANSIONCOEFFICIENTUNIT, IfcDerivedUnit_WARPINGCONSTANTUNIT, IfcDerivedUnit_WARPINGMOMENTUNIT, IfcDerivedUnit_USERDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDerivedUnitEnum (IfcEntityInstanceData&& e);
    IfcDerivedUnitEnum (Value v);
    IfcDerivedUnitEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDirectionSenseEnum : public IfcUtil::IfcBaseType {
/// IfcDirectionSenseEnum is an enumeration denoting whether sense of direction is positive or negative along the given axis.
/// 
/// ENUMERATION
/// 
/// POSITIVE: Direction defined to be positive.
/// NEGATIVE: Direction defined to be negative.
/// 
/// HISTORY New Type in IFC2x.
public:
    typedef enum {IfcDirectionSense_POSITIVE, IfcDirectionSense_NEGATIVE} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDirectionSenseEnum (IfcEntityInstanceData&& e);
    IfcDirectionSenseEnum (Value v);
    IfcDirectionSenseEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDiscreteAccessoryTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the different types of discrete accessories:
/// 
/// ANCHORPLATE: An accessory consisting of a steel plate, shear stud connectors or welded-on rebar which is embedded into the surface of a concrete element so that other elements can be welded or bolted onto it later.
/// BRACKET: An L-shaped or similarly shaped accessory attached in a corner between elements to hold them together or to carry a secondary element.
/// SHOE: A column shoe or a beam shoe (beam hanger) used to support or secure an element.
/// USERDEFINED: User-defined accessory
/// NOTDEFINED: Undefined accessory
/// 
/// HISTORY New Enumeration in IFC 2x4.
public:
    typedef enum {IfcDiscreteAccessoryType_ANCHORPLATE, IfcDiscreteAccessoryType_BRACKET, IfcDiscreteAccessoryType_SHOE, IfcDiscreteAccessoryType_EXPANSION_JOINT_DEVICE, IfcDiscreteAccessoryType_BIRDPROTECTION, IfcDiscreteAccessoryType_CABLEARRANGER, IfcDiscreteAccessoryType_INSULATOR, IfcDiscreteAccessoryType_LOCK, IfcDiscreteAccessoryType_TENSIONINGEQUIPMENT, IfcDiscreteAccessoryType_RAILPAD, IfcDiscreteAccessoryType_SLIDINGCHAIR, IfcDiscreteAccessoryType_PANEL_STRENGTHENING, IfcDiscreteAccessoryType_RAILBRACE, IfcDiscreteAccessoryType_ELASTIC_CUSHION, IfcDiscreteAccessoryType_SOUNDABSORPTION, IfcDiscreteAccessoryType_RAIL_LUBRICATION, IfcDiscreteAccessoryType_RAIL_MECHANICAL_EQUIPMENT, IfcDiscreteAccessoryType_USERDEFINED, IfcDiscreteAccessoryType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDiscreteAccessoryTypeEnum (IfcEntityInstanceData&& e);
    IfcDiscreteAccessoryTypeEnum (Value v);
    IfcDiscreteAccessoryTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDistributionBoardTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcDistributionBoardType_SWITCHBOARD, IfcDistributionBoardType_CONSUMERUNIT, IfcDistributionBoardType_MOTORCONTROLCENTRE, IfcDistributionBoardType_DISTRIBUTIONFRAME, IfcDistributionBoardType_DISTRIBUTIONBOARD, IfcDistributionBoardType_USERDEFINED, IfcDistributionBoardType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDistributionBoardTypeEnum (IfcEntityInstanceData&& e);
    IfcDistributionBoardTypeEnum (Value v);
    IfcDistributionBoardTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDistributionChamberElementTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration identifies different types of distribution chambers.
/// 
/// Valid enumerations are:
/// 
/// FORMEDDUCT: Space formed in the ground for the passage of pipes, cables, ducts.
/// INSPECTIONCHAMBER: Chamber constructed on a drain, sewer or pipeline with a removable cover that permits visble inspection.
/// INSPECTIONPIT:  Recess or chamber formed to permit access for inspection of substructure and services.
/// MANHOLE: Chamber constructed on a drain, sewer or pipeline with a removable cover that permits the entry of a person.
/// METERCHAMBER: Chamber that houses a meter(s).
/// SUMP: Recessed or small chamber into which liquid is drained to facilitate its collection for removal.
/// TRENCH: Excavated chamber, the length of which typically exceeds the width.
/// VALVECHAMBER: Chamber that houses a valve(s).
/// USERDEFINED: User-defined chamber type.
/// NOTDEFINED: Undefined chamber type.
/// 
/// HISTORY: New enumeration in IFC R2x2
public:
    typedef enum {IfcDistributionChamberElementType_FORMEDDUCT, IfcDistributionChamberElementType_INSPECTIONCHAMBER, IfcDistributionChamberElementType_INSPECTIONPIT, IfcDistributionChamberElementType_MANHOLE, IfcDistributionChamberElementType_METERCHAMBER, IfcDistributionChamberElementType_SUMP, IfcDistributionChamberElementType_TRENCH, IfcDistributionChamberElementType_VALVECHAMBER, IfcDistributionChamberElementType_USERDEFINED, IfcDistributionChamberElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDistributionChamberElementTypeEnum (IfcEntityInstanceData&& e);
    IfcDistributionChamberElementTypeEnum (Value v);
    IfcDistributionChamberElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDistributionPortTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcDistributionPortType_CABLE, IfcDistributionPortType_CABLECARRIER, IfcDistributionPortType_DUCT, IfcDistributionPortType_PIPE, IfcDistributionPortType_WIRELESS, IfcDistributionPortType_USERDEFINED, IfcDistributionPortType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDistributionPortTypeEnum (IfcEntityInstanceData&& e);
    IfcDistributionPortTypeEnum (Value v);
    IfcDistributionPortTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDistributionSystemEnum : public IfcUtil::IfcBaseType {
/// This enumeration identifies different types of distribution systems.
/// 
/// HISTORY: New enumeration in IFC R2x4
/// 
/// Valid enumerations for pipes and related elements include:
/// 
/// CHEMICAL: Arbitrary chemical further qualified by property set, such as for medical or industrial use.
///   CHILLEDWATER: Nonpotable chilled water, such as circulated through an evaporator.
///   COMPRESSEDAIR: Compressed air system.
///   CONDENSERWATER: Nonpotable water, such as circulated through a condensor.
///   DOMESTICCOLDWATER: Unheated potable water distribution system.
///   DOMESTICHOTWATER: Heated potable water distribution system.
///   DRAINAGE: Drainage collection system.
///   FIREPROTECTION: Fire protection sprinkler system.
///   GAS: Methane distribution system.
///   HAZARDOUS: Hazardous material or fluid collection system.
///   HEATING: Heated water distribution system.
///   OIL: Oil distribution system.
///   RAINWATER: Rainwater resulting from precipitation which directly falls on a parcel.
///   REFRIGERATION: Refrigerant distribution system for purposes of fulfilling all or parts of a refrigeration cycle.
///   SEWAGE: Sewage collection system.
///   STORMWATER: Stormwater resulting from precipitation which runs off or travels over the ground surface.
///   VACUUM: Vacuum distribution system.
///   VENT: Vent system for wastewater piping systems.
///   WASTE: Waste collection system.
/// 
/// Valid enumerations for ducts and related elements include:
/// 
/// AIRCONDITIONING:  Conditioned air distribution system for purposes of maintaining a temperature range within one or more spaces.
///   EXHAUST:  Exhaust air collection system for removing stale or noxious air from one or more spaces.
///   VENTILATION:  Ventilation air distribution system involved in either the exchange of air to the outside as well as circulation of air within a building.
/// 
/// Valid enumerations for cables and related elements include:
/// 
/// AUDIOVISUAL:  A transport of a single media source, having audio and/or video streams.
///   CONTROL:  A transport or network dedicated to control system usage.
///   DATA: A network having general-purpose usage.
///   EARTHING: A path for equipotential bonding, conducting current to the ground.
///   ELECTRICAL: A circuit for delivering electrical power.
///   ELECTROACCOUSTIC: An amplified audio signal such as for loudspeakers.
///   LIGHTING: A circuit dedicated for lighting, such as a fixture having sockets for lamps.
///   LIGHTNINGPROTECTION: A path for conducting lightning current to the ground.
///   POWERGENERATION: A path for power generation.
///   SECURITY: A transport or network dedicated to security system usage.
///   SIGNAL: A raw analog signal, such as modulated data or measurements from sensors.
///   TELEPHONE: A transport or network dedicated to telephone system usage.
///   TV: A transport of multiple media sources (e.g. analog cable, satellite, over-the-air).
public:
    typedef enum {IfcDistributionSystem_AIRCONDITIONING, IfcDistributionSystem_AUDIOVISUAL, IfcDistributionSystem_CHEMICAL, IfcDistributionSystem_CHILLEDWATER, IfcDistributionSystem_COMMUNICATION, IfcDistributionSystem_COMPRESSEDAIR, IfcDistributionSystem_CONDENSERWATER, IfcDistributionSystem_CONTROL, IfcDistributionSystem_CONVEYING, IfcDistributionSystem_DATA, IfcDistributionSystem_DISPOSAL, IfcDistributionSystem_DOMESTICCOLDWATER, IfcDistributionSystem_DOMESTICHOTWATER, IfcDistributionSystem_DRAINAGE, IfcDistributionSystem_EARTHING, IfcDistributionSystem_ELECTRICAL, IfcDistributionSystem_ELECTROACOUSTIC, IfcDistributionSystem_EXHAUST, IfcDistributionSystem_FIREPROTECTION, IfcDistributionSystem_FUEL, IfcDistributionSystem_GAS, IfcDistributionSystem_HAZARDOUS, IfcDistributionSystem_HEATING, IfcDistributionSystem_LIGHTING, IfcDistributionSystem_LIGHTNINGPROTECTION, IfcDistributionSystem_MUNICIPALSOLIDWASTE, IfcDistributionSystem_OIL, IfcDistributionSystem_OPERATIONAL, IfcDistributionSystem_POWERGENERATION, IfcDistributionSystem_RAINWATER, IfcDistributionSystem_REFRIGERATION, IfcDistributionSystem_SECURITY, IfcDistributionSystem_SEWAGE, IfcDistributionSystem_SIGNAL, IfcDistributionSystem_STORMWATER, IfcDistributionSystem_TELEPHONE, IfcDistributionSystem_TV, IfcDistributionSystem_VACUUM, IfcDistributionSystem_VENT, IfcDistributionSystem_VENTILATION, IfcDistributionSystem_WASTEWATER, IfcDistributionSystem_WATERSUPPLY, IfcDistributionSystem_CATENARY_SYSTEM, IfcDistributionSystem_OVERHEAD_CONTACTLINE_SYSTEM, IfcDistributionSystem_RETURN_CIRCUIT, IfcDistributionSystem_USERDEFINED, IfcDistributionSystem_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDistributionSystemEnum (IfcEntityInstanceData&& e);
    IfcDistributionSystemEnum (Value v);
    IfcDistributionSystemEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDocumentConfidentialityEnum : public IfcUtil::IfcBaseType {
/// IfcDocumentConfidentialityEnum enables selection of the level of confidentiality of document information from a list of choices. 
/// 
/// HISTORY: New enumeration in IFC 2x
/// 
/// Enumeration 
/// 
/// PUBLIC: Document is publicly available. 
/// RESTRICTED: Document availability is restricted. 
/// CONFIDENTIAL: Document is confidential and its contents should not be revealed without permission. 
/// PERSONAL: Document is personal to the author. 
/// USERDEFINED 
/// NOTDEFINED
public:
    typedef enum {IfcDocumentConfidentiality_PUBLIC, IfcDocumentConfidentiality_RESTRICTED, IfcDocumentConfidentiality_CONFIDENTIAL, IfcDocumentConfidentiality_PERSONAL, IfcDocumentConfidentiality_USERDEFINED, IfcDocumentConfidentiality_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDocumentConfidentialityEnum (IfcEntityInstanceData&& e);
    IfcDocumentConfidentialityEnum (Value v);
    IfcDocumentConfidentialityEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDocumentStatusEnum : public IfcUtil::IfcBaseType {
/// IfcDocumentStatusEnum enables selection of the status of document information from a list of choices.
/// 
/// HISTORY: New enumeration in IFC Release 2x.
public:
    typedef enum {IfcDocumentStatus_DRAFT, IfcDocumentStatus_FINALDRAFT, IfcDocumentStatus_FINAL, IfcDocumentStatus_REVISION, IfcDocumentStatus_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDocumentStatusEnum (IfcEntityInstanceData&& e);
    IfcDocumentStatusEnum (Value v);
    IfcDocumentStatusEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorPanelOperationEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic ways how individual door panels operate as shown in Figure 164.
/// HISTORY New Enumeration in IFC Release 2.0.
/// IFC2x4 CHANGE Enumerator FIXEDPANELadded.
/// 
/// Swinging
/// 
/// DoubleActing
/// 
/// Sliding
/// 
/// Folding
/// 
/// Revolving
/// 
/// Rollingup
/// 
/// FixedPanel
/// 
/// NOTE Enumerator added in IFC2x4.
/// 
/// UserDefined
/// 
/// NotDefined
/// 
/// Figure 164 — Door operations
/// 
/// The opening direction of the door panels is given by the local
/// placement of the IfcDoor. The positive y-axis determines
/// the direction as shown in Figure 165.
/// 
/// Figure 165 — Door panel operations
/// 
/// NOTE  Figures (symbolic representation) depend on the national building code.  These figures are only shown as illustrations
public:
    typedef enum {IfcDoorPanelOperation_SWINGING, IfcDoorPanelOperation_DOUBLE_ACTING, IfcDoorPanelOperation_SLIDING, IfcDoorPanelOperation_FOLDING, IfcDoorPanelOperation_REVOLVING, IfcDoorPanelOperation_ROLLINGUP, IfcDoorPanelOperation_FIXEDPANEL, IfcDoorPanelOperation_USERDEFINED, IfcDoorPanelOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorPanelOperationEnum (IfcEntityInstanceData&& e);
    IfcDoorPanelOperationEnum (Value v);
    IfcDoorPanelOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorPanelPositionEnum : public IfcUtil::IfcBaseType {
/// Definition: This enumeration defines the basic ways to describe the location of a door panel within a door lining.
/// 
/// HISTORY New Enumeration in IFC Release 2.x
/// 
/// Figure 166 shows the designation of a door panel with PanelPosition = LEFT and a door panel with PanelPosition = RIGHT within a door style with OperationType = DOUBLE_DOOR_SINGLE_SWING. The position is given as shown in the XZ plane of the local placement, looking into the direction of the positive Y axis. 
/// 
/// Figure 166 — Door panel positions
public:
    typedef enum {IfcDoorPanelPosition_LEFT, IfcDoorPanelPosition_MIDDLE, IfcDoorPanelPosition_RIGHT, IfcDoorPanelPosition_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorPanelPositionEnum (IfcEntityInstanceData&& e);
    IfcDoorPanelPositionEnum (Value v);
    IfcDoorPanelPositionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorStyleConstructionEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
///   basic types of construction of doors. The construction type
///   relates to the main material (or material combination) used
///   for making the door.
/// 
/// HISTORY New Enumeration in
///   IFC Release 2x .
public:
    typedef enum {IfcDoorStyleConstruction_ALUMINIUM, IfcDoorStyleConstruction_HIGH_GRADE_STEEL, IfcDoorStyleConstruction_STEEL, IfcDoorStyleConstruction_WOOD, IfcDoorStyleConstruction_ALUMINIUM_WOOD, IfcDoorStyleConstruction_ALUMINIUM_PLASTIC, IfcDoorStyleConstruction_PLASTIC, IfcDoorStyleConstruction_USERDEFINED, IfcDoorStyleConstruction_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorStyleConstructionEnum (IfcEntityInstanceData&& e);
    IfcDoorStyleConstructionEnum (Value v);
    IfcDoorStyleConstructionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorStyleOperationEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic ways to describe how doors operate as shown in Figure 167.
/// HISTORY  New Enumeration in Release IFC2x.
/// 
/// Enumerator
///   Description
///   Figure
/// 
/// SINGLE_SWING_LEFT
/// 
/// Door with one
/// panel that opens (swings) to the
/// left. The hinges are on the left side as viewed in the direction of the
/// positive y-axis.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor.
/// 
/// SINGLE_SWING_RIGHT
/// 
/// Door with one
/// panel that opens (swings) to the
/// right. The hinges are on the right side as viewed in the direction of
/// the positive y-axis.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING
/// 
/// Door with two
/// panels, one opens (swings) to the
/// left the other opens (swings) to the right.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor. 
/// 
/// DOUBLE_SWING_LEFT
/// 
/// Door with one
/// panel that swings in both
/// directions and to the left in the main trafic direction. Also called
/// double acting door.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor. 
/// 
/// DOUBLE_SWING_RIGHT
/// 
/// Door with one
/// panel that swings in both
/// directions and to the right in the main trafic direction. Also called
/// double acting door.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// DOUBLE_SWING
/// 
/// Door with two
/// panels, one swings in both
/// directions and to the right in the main trafic direction the other
/// swings also in both directions and to the left in the main trafic
/// direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_LEFT
/// 
/// Door with two
/// panels that both open to the left,
/// one panel swings in one direction and the other panel swings in the
/// opposite direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_RIGHT
///   Door with two
/// panels that both open to the right,
/// one panel swings in one direction and the other panel swings in the
/// opposite direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// SLIDING_TO_LEFT
/// 
/// Door with one
/// panel that is sliding to the left. 
/// 
/// SLIDING_TO_RIGHT
/// 
/// Door with one
/// panel that is sliding to the right. 
/// 
/// DOUBLE_DOOR_SLIDING
/// 
/// Door with two
/// panels, one is sliding to the left
/// the other is sliding to the right. 
/// 
/// FOLDING_TO_LEFT
/// 
/// Door with one
/// panel that is folding to the left. 
/// 
/// FOLDING_TO_RIGHT
///   Door with one
/// panel that is folding to the right. 
/// 
/// DOUBLE_DOOR_FOLDING
/// 
/// Door with two
/// panels, one is folding to the left
/// the other is folding to the right. 
/// 
/// REVOLVING
/// 
/// An entrance door
/// consisting of four leaves set in
/// a form of a cross and revolving around a central vertical axis (the
/// four panels are described by a single IfcDoor panel
/// property). 
/// 
/// ROLLINGUP
/// 
/// Door that opens
/// by rolling up.
///   Note: Whether it rolls up to the
/// inside or
/// outside is determined at the IfcDoor.
/// 
/// USERDEFINED
///   User defined
/// operation type
///    
/// 
/// NOTDEFINED
///   A door with a
/// not defined operation type is
/// considered as a door with a lining, but no panels. It is thereby always
/// open.
///    
/// 
/// Figure 167 — Door style operations
/// 
/// NOTE
/// 
/// Figures are shown in the ground view.
///   Figures (symbolic representation) depend on the national
/// building
/// code.
///   These figures are only shown as illustrations, the actual
/// representation in the ground view might differ. 
///   Open to the outside is declared as open into the direction
/// of the
/// positive y-axis, determined by the ObjectPlacement
/// at IfcDoor
///   The location of the panel relative to the wall thickness is
/// defined by the ObjectPlacement at IfcDoor,
/// and the IfcDoorLiningProperties.LiningOffset
/// parameter.
public:
    typedef enum {IfcDoorStyleOperation_SINGLE_SWING_LEFT, IfcDoorStyleOperation_SINGLE_SWING_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_LEFT, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_RIGHT, IfcDoorStyleOperation_DOUBLE_SWING_LEFT, IfcDoorStyleOperation_DOUBLE_SWING_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_DOUBLE_SWING, IfcDoorStyleOperation_SLIDING_TO_LEFT, IfcDoorStyleOperation_SLIDING_TO_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_SLIDING, IfcDoorStyleOperation_FOLDING_TO_LEFT, IfcDoorStyleOperation_FOLDING_TO_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_FOLDING, IfcDoorStyleOperation_REVOLVING, IfcDoorStyleOperation_ROLLINGUP, IfcDoorStyleOperation_USERDEFINED, IfcDoorStyleOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorStyleOperationEnum (IfcEntityInstanceData&& e);
    IfcDoorStyleOperationEnum (Value v);
    IfcDoorStyleOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different predefined types of an IfcDoorType object can
/// fulfill:
/// 
/// DOOR: A standard door usually within a wall opening,
/// as a door panel in a curtain wall, or as a "free standing"
/// door.
/// GATE: A gate is a point of entry to a property usually
/// within an opening in a fence. Or as a "free standing" gate.
/// TRAPDOOR: A special door that lies horizonally in a
/// slab opening. Often used for accessing cellar or attic.
/// USERDEFINED: User-defined linear beam element.
/// NOTDEFINED: Undefined linear beam element
/// 
/// HISTORY New Enumeration
/// in IFC2x4.
public:
    typedef enum {IfcDoorType_DOOR, IfcDoorType_GATE, IfcDoorType_TRAPDOOR, IfcDoorType_BOOM_BARRIER, IfcDoorType_TURNSTILE, IfcDoorType_USERDEFINED, IfcDoorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorTypeEnum (IfcEntityInstanceData&& e);
    IfcDoorTypeEnum (Value v);
    IfcDoorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDoorTypeOperationEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic ways to describe how doors operate, as shown in Figure 66. It combines the partitioning of the door into a single or multiple door panels and the operation types of that panels.
/// 
/// In the most common case of swinging doors the IfcDoorTypeOperationEnum defined the hinge side (left hing or right hung) and the opening direction (opening to the left, opening to the right). Whether the door opens inwards or outwards is determined by the local coordinate system of the IfcDoor, or IfcDoorStandardCase.
/// 
/// NOTEThere are different definitions in various countries on what a left opening or left hung or left swing door is (same for right). Therefore the IFC definition terms may derivate from the local standard and may need to be mapped appropriately.
/// 
/// HISTORY New Enumeration in IFC2x4.
/// 
/// IFC2x4 CHANGE The new IfcDoorTypeOperationEnum replaces the use of IfcDoorStyleOperationEnum that is deprecated from IFC2x4 onwards.
/// 
/// Enumerator
/// Description
/// Figures
/// 
/// SINGLE_SWING_LEFT
/// 
/// Door with one panel that opens
/// (swings) to the left. The hinges are on the left side as viewed
/// in the direction of the positive y-axis.
/// Note: Direction of swing (whether in or out)
/// is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// SINGLE_SWING_RIGHT
/// 
/// Door with one panel that opens
/// (swings) to the right. The hinges are on the right side as viewed
/// in the direction of the positive y-axis.
/// Note: Direction of swing (whether in or out)
/// is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING
/// 
/// Door with two panels, one opens
/// (swings) to the left the other opens (swings) to the right.
/// Note: Direction of swing (whether in or out)
/// is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_SWING_LEFT
/// 
/// Door with one panel that swings in
/// both directions and to the left in the main trafic direction.
/// Also called double acting door.
/// Note: Direction of main swing (whether in or
/// out) is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_SWING_RIGHT
/// 
/// Door with one panel that swings in
/// both directions and to the right in the main trafic direction.
/// Also called double acting door.
/// Note: Direction of main swing (whether in or
/// out) is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_DOOR_
/// DOUBLE_SWING
/// 
/// Door with two panels, one swings in
/// both directions and to the right in the main trafic direction the
/// other swings also in both directions and to the left in the main
/// trafic direction.
/// Note: Direction of main swing (whether in or
/// out) is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_LEFT
/// 
/// Door with two panels that both open
/// to the left, one panel swings in one direction and the other
/// panel swings in the opposite direction.
/// Note: Direction of main swing (whether in or
/// out) is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_RIGHT
/// Door with two panels that both open
/// to the right, one panel swings in one direction and the other
/// panel swings in the opposite direction.
/// Note: Direction of main swing (whether in or
/// out) is determined at the IfcDoor or
/// IfcDoorStandardCase.
/// 
/// SLIDING_TO_LEFT
/// 
/// Door with one panel that is sliding
/// to the left.
/// 
/// SLIDING_TO_RIGHT
/// 
/// Door with one panel that is sliding
/// to the right.
/// 
/// DOUBLE_DOOR_SLIDING
/// 
/// Door with two panels, one is sliding
/// to the left the other is sliding to the right.
/// 
/// FOLDING_TO_LEFT
/// 
/// Door with one panel that is folding
/// to the left.
/// 
/// FOLDING_TO_RIGHT
/// Door with one panel that is folding
/// to the right.
/// 
/// DOUBLE_DOOR_FOLDING
/// 
/// Door with two panels, one is folding
/// to the left the other is folding to the right.
/// 
/// REVOLVING
/// 
/// An entrance door consisting of four
/// leaves set in a form of a cross and revolving around a central
/// vertical axis (the four panels are described by a single
/// IfcDoor panel property).
/// 
/// ROLLINGUP
/// 
/// Door that opens by rolling up.
/// Note: Whether it rolls up to the inside or
/// outside is determined at the IfcDoor.
/// 
/// SWING_FIXED_LEFT
/// Door with one panel that opens
/// (swings) to the left and one fixed panel. The hinges of the
/// swinging panel are on the left side as viewed in the direction of
/// the positive y-axis.
/// Note: Direction of swing (whether in or out)
/// is determined at the IfcDoor or or
/// IfcDoorStandardCase.
/// IFC2x4 CHANGE This is a new
/// enumerator compared with previous
/// IfcDoorStyleOperationEnum.
/// 
/// SWING_FIXED_RIGHT
/// Door with one panel that opens
/// (swings) to the right and one fixed panel. The hinges of the
/// swinging panel are on the right side as viewed in the direction
/// of the positive y-axis.
/// Note: Direction of swing (whether in or out)
/// is determined at the IfcDoor or or
/// IfcDoorStandardCase.
/// IFC2x4 CHANGE This is a new
/// enumerator compared with previous
/// IfcDoorStyleOperationEnum.
/// 
/// USERDEFINED
/// User defined operation type
/// 
/// NOTDEFINED
/// A door with a not defined operation
/// type is considered as a door with a lining, but no panels. It is
/// thereby always open.
/// 
/// Figure 66 — Door operations
/// 
/// NOTE
/// 
/// Figures are shown in the ground view.
/// Figures (symbolic representation) depend on the national
/// building code.
/// These figures are only shown as illustrations, the actual
/// representation in the ground view might differ.
/// Open to the outside is declared as open into the direction of
/// the positive y-axis, determined by the ObjectPlacement at
/// IfcDoor
/// The location of the panel relative to the wall thickness is
/// defined by theObjectPlacement at IfcDoor, and the
/// IfcDoorLiningProperties.LiningOffset parameter.
public:
    typedef enum {IfcDoorTypeOperation_SINGLE_SWING_LEFT, IfcDoorTypeOperation_SINGLE_SWING_RIGHT, IfcDoorTypeOperation_DOUBLE_DOOR_SINGLE_SWING, IfcDoorTypeOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_LEFT, IfcDoorTypeOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_RIGHT, IfcDoorTypeOperation_DOUBLE_SWING_LEFT, IfcDoorTypeOperation_DOUBLE_SWING_RIGHT, IfcDoorTypeOperation_DOUBLE_DOOR_DOUBLE_SWING, IfcDoorTypeOperation_SLIDING_TO_LEFT, IfcDoorTypeOperation_SLIDING_TO_RIGHT, IfcDoorTypeOperation_DOUBLE_DOOR_SLIDING, IfcDoorTypeOperation_FOLDING_TO_LEFT, IfcDoorTypeOperation_FOLDING_TO_RIGHT, IfcDoorTypeOperation_DOUBLE_DOOR_FOLDING, IfcDoorTypeOperation_REVOLVING, IfcDoorTypeOperation_ROLLINGUP, IfcDoorTypeOperation_SWING_FIXED_LEFT, IfcDoorTypeOperation_SWING_FIXED_RIGHT, IfcDoorTypeOperation_USERDEFINED, IfcDoorTypeOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDoorTypeOperationEnum (IfcEntityInstanceData&& e);
    IfcDoorTypeOperationEnum (Value v);
    IfcDoorTypeOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDuctFittingTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a duct fitting. This is a very basic categorization mechanism
///   to generically identify the duct fitting type. Subcategories
///   of duct fittings are not enumerated. 
///   The IfcDuctFittingTypeEnum contains the following:
/// 
/// BEND:		A fitting with typically two ports used to change 
///   the direction of flow between connected elements.
///   CONNECTOR:   Connector fitting, typically used to join two
///   ports together within a flow distribution system 
///   (e.g., a coupling used to join two duct segments).
///   ENTRY:       Entry fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., an outside air duct system 
///   intake opening).
///   EXIT:        Exit fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., an exhaust air discharge 
///   opening).
///   JUNCTION:	A fitting with typically more than two ports used
///   to redistribute flow among the ports and/or to
///   change the direction of flow between connected
///   elements (e.g, tee, cross, wye, etc.).
///   OBSTRUCTION: A fitting with typically two ports used to 
///   obstruct or restrict flow between the connected
///   elements (e.g., screen, perforated plate, etc.).
///   TRANSITION:	A fitting with typically two ports having
///   different shapes or sizes. Can also be used to
///   change the direction of flow between connected
///   elements.
///   USERDEFINED: User-defined fitting.
///   NOTDEFINED:  Undefined fitting.
/// 
/// HISTORY: New enumeration in IFC 2x2
public:
    typedef enum {IfcDuctFittingType_BEND, IfcDuctFittingType_CONNECTOR, IfcDuctFittingType_ENTRY, IfcDuctFittingType_EXIT, IfcDuctFittingType_JUNCTION, IfcDuctFittingType_OBSTRUCTION, IfcDuctFittingType_TRANSITION, IfcDuctFittingType_USERDEFINED, IfcDuctFittingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDuctFittingTypeEnum (IfcEntityInstanceData&& e);
    IfcDuctFittingTypeEnum (Value v);
    IfcDuctFittingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDuctSegmentTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a
///   duct segment. This is a very basic categorization mechanism
///   to generically identify the duct segment type. Subcategories
///   of duct segments are not enumerated. 
///   The IfcDuctSegmentTypeEnum contains the following:
/// 
/// RIGIDSEGMENT: A rigid segment is continuous linear segment of duct
///   that cannot be deformed.
///   FLEXIBLESEGMENT:  A flexible segment is a continuous non-linear segment
///   of duct that can be deformed and change the direction 
///   of flow.
///   USERDEFINED: User-defined segment.
///   NOTDEFINED:  Undefined segment.
/// 
/// HISTORY: New enumeration in IFC 2x2
public:
    typedef enum {IfcDuctSegmentType_RIGIDSEGMENT, IfcDuctSegmentType_FLEXIBLESEGMENT, IfcDuctSegmentType_USERDEFINED, IfcDuctSegmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDuctSegmentTypeEnum (IfcEntityInstanceData&& e);
    IfcDuctSegmentTypeEnum (Value v);
    IfcDuctSegmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcDuctSilencerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of duct silencers. 
///   The IfcDuctSilencerTypeEnum contains the following:
/// 
/// FLATOVAL:  Flat-oval shaped duct silencer type.
///   RECTANGULAR:  Rectangular shaped duct silencer type.
///   ROUND:  Round duct silencer type.
///   USERDEFINED:  User-defined duct silencer type.
///   NOTDEFINED:  Undefined duct silencer type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcDuctSilencerType_FLATOVAL, IfcDuctSilencerType_RECTANGULAR, IfcDuctSilencerType_ROUND, IfcDuctSilencerType_USERDEFINED, IfcDuctSilencerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcDuctSilencerTypeEnum (IfcEntityInstanceData&& e);
    IfcDuctSilencerTypeEnum (Value v);
    IfcDuctSilencerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEarthworksCutTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcEarthworksCutType_TRENCH, IfcEarthworksCutType_DREDGING, IfcEarthworksCutType_EXCAVATION, IfcEarthworksCutType_OVEREXCAVATION, IfcEarthworksCutType_TOPSOILREMOVAL, IfcEarthworksCutType_STEPEXCAVATION, IfcEarthworksCutType_PAVEMENTMILLING, IfcEarthworksCutType_CUT, IfcEarthworksCutType_BASE_EXCAVATION, IfcEarthworksCutType_USERDEFINED, IfcEarthworksCutType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEarthworksCutTypeEnum (IfcEntityInstanceData&& e);
    IfcEarthworksCutTypeEnum (Value v);
    IfcEarthworksCutTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEarthworksFillTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcEarthworksFillType_BACKFILL, IfcEarthworksFillType_COUNTERWEIGHT, IfcEarthworksFillType_SUBGRADE, IfcEarthworksFillType_EMBANKMENT, IfcEarthworksFillType_TRANSITIONSECTION, IfcEarthworksFillType_SUBGRADEBED, IfcEarthworksFillType_SLOPEFILL, IfcEarthworksFillType_USERDEFINED, IfcEarthworksFillType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEarthworksFillTypeEnum (IfcEntityInstanceData&& e);
    IfcEarthworksFillTypeEnum (Value v);
    IfcEarthworksFillTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricApplianceTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricApplianceTypeEnum defines the range of different types of electrical appliance that can be specified. 
/// 
/// HISTORY: New type in IFC R2.0.
///   Renamed from IfcElectricalApplianceTypeEnum if IFC 2x2.IFC 2x2 Addendum 1:
///   Missing enumeration values added (ELECTRICHEATER, TUMBLEDRYER and
///   WATERHEATER)
///   IFC 2x4: ELECTRICHEATER changed to FREESTANDINGELECTRICHEATER and noted as being for occasional use. RADIANTHEATER removed as part of general 'heater consolidation'. WATERHEATER, DIRECTWATERHEATER and INDIRECTWATERHEATER rationalized to FREESTANDINGWATERHEATER. WATERCOOLER changed to FREESTANDINGWATERCOOLER.
///   COMPUTER, FACSIMILE (FAX), PRINTER, SCANNER, TELEPHONE, TV (TELEVISION) moved to IfcAudioVisualApplianceTypeEnum and IfcCommunicationsApplianceTypeEnum. KITCHENMACHINE added.
/// 
/// Enumeration 
/// 
/// DISHWASHER: An appliance that has the primary function of washing dishes. 
/// ELECTRICCOOKER: An electrical appliance that has the primary function of cooking food (including oven, hob, grill). 
/// FREESTANDINGELECTRICHEATER: An electrical appliance that is used occasionally to provide heat. A freestanding electric heater is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGFAN: An electrical appliance that is used occasionally to provide ventilation. A freestanding fan is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGWATERHEATER: A small, local electrical appliance for heating water. A freestanding water heater is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGWATERCOOLER: A small, local electrical appliance for cooling water. A freestanding water cooler is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREEZER: An electrical appliance that has the primary function of storing food at temperatures below the freezing point of water. 
/// FRIDGE_FREEZER: An electrical appliance that combines the functions of a freezer and a refrigerator through the provision of separate compartments. 
/// KITCHENMACHINE: A specialized appliance used in commercial kitchens such as a mixer. 
/// HANDDRYER: An electrical appliance that has the primary function of drying hands. 
/// MICROWAVE: An electrical appliance that has the primary function of cooking food using microwaves. 
/// PHOTOCOPIER: A machine that has the primary function of reproduction of printed matter. 
/// REFRIGERATOR: An electrical appliance that has the primary function of storing food at low temperature but above the freezing point of water. 
/// TUMBLEDRYER: An electrical appliance that has the primary function of drying clothes. 
/// VENDINGMACHINE: An appliance that stores and vends goods including food, drink and goods of various types. 
/// WASHINGMACHINE: An appliance that has the primary function of washing clothes. 	  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricApplianceType_DISHWASHER, IfcElectricApplianceType_ELECTRICCOOKER, IfcElectricApplianceType_FREESTANDINGELECTRICHEATER, IfcElectricApplianceType_FREESTANDINGFAN, IfcElectricApplianceType_FREESTANDINGWATERHEATER, IfcElectricApplianceType_FREESTANDINGWATERCOOLER, IfcElectricApplianceType_FREEZER, IfcElectricApplianceType_FRIDGE_FREEZER, IfcElectricApplianceType_HANDDRYER, IfcElectricApplianceType_KITCHENMACHINE, IfcElectricApplianceType_MICROWAVE, IfcElectricApplianceType_PHOTOCOPIER, IfcElectricApplianceType_REFRIGERATOR, IfcElectricApplianceType_TUMBLEDRYER, IfcElectricApplianceType_VENDINGMACHINE, IfcElectricApplianceType_WASHINGMACHINE, IfcElectricApplianceType_USERDEFINED, IfcElectricApplianceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricApplianceTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricApplianceTypeEnum (Value v);
    IfcElectricApplianceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricDistributionBoardTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricDistributionBoardTypeEnum defines the range of different types and/or functions of electric distribution board possible. 
///   HISTORY: New type in IFC 2x4. Replaces IfcElectricDistributionPointTypeEnum  
///   Enumeration 
/// 
/// CONSUMERUNIT: A distribution point on the incoming electrical supply, typically in domestic premises, at which protective devices are located. 
/// DISTRIBUTIONBOARD: A distribution point at which connections are made for distribution of electrical circuits usually through protective devices. 
/// MOTORCONTROLCENTRE: A distribution point at which starting and control devices for major plant items are located. 
/// SWITCHBOARD: A distribution point at which switching devices are located. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricDistributionBoardType_CONSUMERUNIT, IfcElectricDistributionBoardType_DISTRIBUTIONBOARD, IfcElectricDistributionBoardType_MOTORCONTROLCENTRE, IfcElectricDistributionBoardType_SWITCHBOARD, IfcElectricDistributionBoardType_USERDEFINED, IfcElectricDistributionBoardType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricDistributionBoardTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricDistributionBoardTypeEnum (Value v);
    IfcElectricDistributionBoardTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricFlowStorageDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricFlowStorageDeviceTypeEnum defines the range of different types of electrical flow storage device available. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BATTERY: A device for storing energy in chemical form so that it can be released as electrical energy. 
/// CAPACITORBANK: A device that stores electrical energy when an external power supply is present using the electrical property of capacitance 
/// HARMONICFILTER: A device that constantly injects currents that precisely correspond to the harmonic components drawn by the load. 
/// UPS: A device that provides a time limited alternative source of power supply in the event of failure of the main supply.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricFlowStorageDeviceType_BATTERY, IfcElectricFlowStorageDeviceType_CAPACITORBANK, IfcElectricFlowStorageDeviceType_HARMONICFILTER, IfcElectricFlowStorageDeviceType_INDUCTORBANK, IfcElectricFlowStorageDeviceType_UPS, IfcElectricFlowStorageDeviceType_CAPACITOR, IfcElectricFlowStorageDeviceType_COMPENSATOR, IfcElectricFlowStorageDeviceType_INDUCTOR, IfcElectricFlowStorageDeviceType_RECHARGER, IfcElectricFlowStorageDeviceType_USERDEFINED, IfcElectricFlowStorageDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricFlowStorageDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricFlowStorageDeviceTypeEnum (Value v);
    IfcElectricFlowStorageDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricFlowTreatmentDeviceTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcElectricFlowTreatmentDeviceType_ELECTRONICFILTER, IfcElectricFlowTreatmentDeviceType_USERDEFINED, IfcElectricFlowTreatmentDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricFlowTreatmentDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricFlowTreatmentDeviceTypeEnum (Value v);
    IfcElectricFlowTreatmentDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricGeneratorTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricGeneratorTypeEnum defines the range of types of electric generators available.
///   HISTORY: New type in IFC 2x2.  Values added in IFC 2x4. 
/// 
/// Enumeration 
/// 
/// CHP: Combined heat and power supply, used not only as a source of electric energy but also as a heating source for the building. It may therefore be not only part of an electrical system but also of a heating system. 
/// ENGINEGENERATOR: Electrical generator with a fuel-driven engine, for example a diesel-driven emergency power supply. 
/// STANDALONE: Electrical generator which does not include its source of kinetic energy, that is, a motor, engine, or turbine is modeled by a separate object. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricGeneratorType_CHP, IfcElectricGeneratorType_ENGINEGENERATOR, IfcElectricGeneratorType_STANDALONE, IfcElectricGeneratorType_USERDEFINED, IfcElectricGeneratorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricGeneratorTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricGeneratorTypeEnum (Value v);
    IfcElectricGeneratorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricMotorTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricMotorTypeEnum defines the range of different types of electric motor that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// DC: A motor using either generated or rectified D.C. power. 
/// INDUCTION: An alternating current motor in which the primary winding on one member (usually the stator) is connected to the power source and a secondary winding or a squirrel-cage secondary winding on the other member (usually the rotor) carries the induced current. There is no physical electrical connection to the secondary winding, its current is induced. 
/// POLYPHASE: A two or three-phase induction motor in which the windings, one for each phase, are evenly divided by the same number of electrical degrees.  
/// RELUCTANCESYNCHRONOUS: A synchronous motor with a special rotor design which directly lines the rotor up with the rotating magnetic field of the stator, allowing for no slip under load.  
/// SYNCHRONOUS: A motor that operates at a constant speed up to full load. The rotor speed is equal to the speed of the rotating magnetic field of the stator; there is no slip. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricMotorType_DC, IfcElectricMotorType_INDUCTION, IfcElectricMotorType_POLYPHASE, IfcElectricMotorType_RELUCTANCESYNCHRONOUS, IfcElectricMotorType_SYNCHRONOUS, IfcElectricMotorType_USERDEFINED, IfcElectricMotorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricMotorTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricMotorTypeEnum (Value v);
    IfcElectricMotorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElectricTimeControlTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcElectricTimeControlTypeEnum defines the range of types of electrical time control available. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// TIMECLOCK: A control that causes action to occur at set times. 
/// TIMEDELAY: A control that causes action to occur following a set duration. 
/// RELAY: Electromagnetically operated contactor for making or breaking a control circuit. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcElectricTimeControlType_TIMECLOCK, IfcElectricTimeControlType_TIMEDELAY, IfcElectricTimeControlType_RELAY, IfcElectricTimeControlType_USERDEFINED, IfcElectricTimeControlType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElectricTimeControlTypeEnum (IfcEntityInstanceData&& e);
    IfcElectricTimeControlTypeEnum (Value v);
    IfcElectricTimeControlTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElementAssemblyTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: An enumeration defining the
///   basic configuration types for element assemblies.
/// 
/// HISTORY New enumeration type
///   in Release IFC2x Edition 2.
/// 
/// Enumeration
/// 
/// ACCESSORY_ASSEMBLY: Assembled accessories or components
///   ARCH: A curved structure
///   BEAM_GRID: Interconnected beams, located in one (typically horizontal) plane
///   BRACED_FRAME: A rigid frame with additional bracing members
///   GIRDER: A beam-like superstructure
///   REINFORCEMENT_UNIT: Assembled reinforcement elements
///   RIGID_FRAME: A structure built up of beams, columns, etc. with moment-resisting joints
///   SLAB_FIELD: Slabs, laid out in one plane
///   TRUSS: A structure built up of members with (quasi) pinned joints
///   USERDEFINED: User-defined element assembly
///   NOTDEFINED: Undefined element assembly
public:
    typedef enum {IfcElementAssemblyType_ACCESSORY_ASSEMBLY, IfcElementAssemblyType_ARCH, IfcElementAssemblyType_BEAM_GRID, IfcElementAssemblyType_BRACED_FRAME, IfcElementAssemblyType_GIRDER, IfcElementAssemblyType_REINFORCEMENT_UNIT, IfcElementAssemblyType_RIGID_FRAME, IfcElementAssemblyType_SLAB_FIELD, IfcElementAssemblyType_TRUSS, IfcElementAssemblyType_ABUTMENT, IfcElementAssemblyType_PIER, IfcElementAssemblyType_PYLON, IfcElementAssemblyType_CROSS_BRACING, IfcElementAssemblyType_DECK, IfcElementAssemblyType_MAST, IfcElementAssemblyType_SIGNALASSEMBLY, IfcElementAssemblyType_GRID, IfcElementAssemblyType_SHELTER, IfcElementAssemblyType_SUPPORTINGASSEMBLY, IfcElementAssemblyType_SUSPENSIONASSEMBLY, IfcElementAssemblyType_TRACTION_SWITCHING_ASSEMBLY, IfcElementAssemblyType_TRACKPANEL, IfcElementAssemblyType_TURNOUTPANEL, IfcElementAssemblyType_DILATATIONPANEL, IfcElementAssemblyType_RAIL_MECHANICAL_EQUIPMENT_ASSEMBLY, IfcElementAssemblyType_ENTRANCEWORKS, IfcElementAssemblyType_SUMPBUSTER, IfcElementAssemblyType_TRAFFIC_CALMING_DEVICE, IfcElementAssemblyType_USERDEFINED, IfcElementAssemblyType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElementAssemblyTypeEnum (IfcEntityInstanceData&& e);
    IfcElementAssemblyTypeEnum (Value v);
    IfcElementAssemblyTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcElementCompositionEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration that provides an
///   indication, whether the spatial structure element or proxy
///   represents a:
/// 
/// COMPLEX - a group or aggregation of similar elements
/// 
/// ELEMENT - a (undivided) element itself
/// 
/// PARTIAL - a subelement or part
/// 
/// HISTORY New enumeration in
///   IFC Release 2.x
public:
    typedef enum {IfcElementComposition_COMPLEX, IfcElementComposition_ELEMENT, IfcElementComposition_PARTIAL} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcElementCompositionEnum (IfcEntityInstanceData&& e);
    IfcElementCompositionEnum (Value v);
    IfcElementCompositionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEngineTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of engines.  The IfcEngineTypeEnum contains the following:
/// 
/// EXTERNALCOMBUSTION: Combustion is external.
///   INTERNALCOMBUSTION: Combustion is internal.
///   USERDEFINED: User-defined engine type.
///   NOTDEFINED:  Undefined engine type.
/// 
/// HISTORY: New enumeration in IFC 2x4.
public:
    typedef enum {IfcEngineType_EXTERNALCOMBUSTION, IfcEngineType_INTERNALCOMBUSTION, IfcEngineType_USERDEFINED, IfcEngineType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEngineTypeEnum (IfcEntityInstanceData&& e);
    IfcEngineTypeEnum (Value v);
    IfcEngineTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEvaporativeCoolerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of evaporative coolers. 
///   The IfcEvaporativeCoolerTypeEnum contains the following:
/// 
/// DIRECTEVAPORATIVERANDOMMEDIAAIRCOOLER: Direct evaporative random media air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with evaporative pads, usually of aspen wood or plastic fiber/foam.
///   DIRECTEVAPORATIVERIGIDMEDIAAIRCOOLER: Direct evaporative rigid media air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with sheets of rigid, corrugated material as the wetted surface.
///   DIRECTEVAPORATIVESLINGERSPACKAGEDAIRCOOLER: Direct evaporative slingers packaged air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with a water slinger in an evaporative cooling section and a fan section.
///   DIRECTEVAPORATIVEPACKAGEDROTARYAIRCOOLER: Direct evaporative packaged rotary air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers that wet and wash the evaporative pad by rotating it through a water bath.
///   DIRECTEVAPORATIVEAIRWASHER: Direct evaporative air washer: Cools the air stream by evaporating water dircectly into the air stream using coolers with spray-type air washer consist of a chamber or casing containing spray nozzles, and tank for collecting spray water, and an eliminator section for removing entrained drops of water from the air.
///   INDIRECTEVAPORATIVEPACKAGEAIRCOOLER: Indirect evaporative package air cooler: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream. On one side of the heat exchanger, the secondary air stream is cooled by evaporation, while on the other side of heat exchanger, the primary air stream (conditioned air to be supplied to the room) is sensibly cooled by the heat exchanger surfaces.
///   INDIRECTEVAPORATIVEWETCOIL: Indirect evaporative wet coil: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream. Water is sprayed directly on the tubes of the heat exchanger where latent cooling takes place and the vaporization of the water on the outside of the heat exchanger tubes allows the simultaneous heat and mass transfer which removes heat from the supply air on the tube side.
///   INDIRECTEVAPORATIVECOOLINGTOWERORCOILCOOLER: Indirect evaporative cooling tower or coil cooler: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream using a combination of a cooling tower or other evaporative water cooler with a water-to-air heat exchanger coil and water circulating pump.
///   INDIRECTDIRECTCOMBINATION: Indirect/Direct combination: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream using a two-stage cooler with a first-stage indirect evaporative cooler and second-stage direct evaporative cooler.
///   USERDEFINED:  User-defined evaporative cooler type.
///   NOTDEFINED:  Undefined evaporative cooler type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcEvaporativeCoolerType_DIRECTEVAPORATIVERANDOMMEDIAAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVERIGIDMEDIAAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVESLINGERSPACKAGEDAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVEPACKAGEDROTARYAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVEAIRWASHER, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVEPACKAGEAIRCOOLER, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVEWETCOIL, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVECOOLINGTOWERORCOILCOOLER, IfcEvaporativeCoolerType_INDIRECTDIRECTCOMBINATION, IfcEvaporativeCoolerType_USERDEFINED, IfcEvaporativeCoolerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEvaporativeCoolerTypeEnum (IfcEntityInstanceData&& e);
    IfcEvaporativeCoolerTypeEnum (Value v);
    IfcEvaporativeCoolerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEvaporatorTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of evaporators. 
///   The IfcEvaporatorTypeEnum contains the following:
/// 
/// DIRECTEXPANSION: Direct-expansion evaporator.
///   DIRECTEXPANSIONSHELLANDTUBE: Direct-expansion evaporator where a refrigerant evaporates inside a series of baffles that channel the fluid throughout the shell side.
///   DIRECTEXPANSIONTUBEINTUBE: Direct-expansion evaporator where a refrigerant evaporates inside one or more pairs of coaxial tubes.
///   DIRECTEXPANSIONBRAZEDPLATE: Direct-expansion evaporator where a refrigerant evaporates inside plates brazed or welded together to make up an assembly of separate channels.
///   FLOODEDSHELLANDTUBE: Evaporator in which refrigerant evaporates outside tubes.
///   SHELLANDCOIL: Evaporator in which refrigerant evaporates inside a simple coiled tube immersed in the fluid to be cooled.
///   USERDEFINED:  User-defined evaporator type.
///   NOTDEFINED:  Undefined evaporator type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcEvaporatorType_DIRECTEXPANSION, IfcEvaporatorType_DIRECTEXPANSIONSHELLANDTUBE, IfcEvaporatorType_DIRECTEXPANSIONTUBEINTUBE, IfcEvaporatorType_DIRECTEXPANSIONBRAZEDPLATE, IfcEvaporatorType_FLOODEDSHELLANDTUBE, IfcEvaporatorType_SHELLANDCOIL, IfcEvaporatorType_USERDEFINED, IfcEvaporatorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEvaporatorTypeEnum (IfcEntityInstanceData&& e);
    IfcEvaporatorTypeEnum (Value v);
    IfcEvaporatorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEventTriggerTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcEventTriggerTypeEnum defines the range of different types of event trigger that can be specified.
/// 
/// HISTORY: New type in IFC2x4
/// 
/// Enumeration: The definition of event trigger types has been adopted from the Business Process Modeling Notation (BPMN), which is also used in the Information Delivery Manual (IDM) for defining business processes. More detailed information about the use of event trigger types can be found in these specifications.
/// 
/// EVENTRULE: An event trigger that is a rule or constraint
/// EVENTMESSAGE: An event trigger that is a message or set of information
/// EVENTTIME: An event trigger that is at, or occurs after, a particular point in or period of time
/// EVENTCOMPLEX: An event trigger that is a complex combination of things
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcEventTriggerType_EVENTRULE, IfcEventTriggerType_EVENTMESSAGE, IfcEventTriggerType_EVENTTIME, IfcEventTriggerType_EVENTCOMPLEX, IfcEventTriggerType_USERDEFINED, IfcEventTriggerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEventTriggerTypeEnum (IfcEntityInstanceData&& e);
    IfcEventTriggerTypeEnum (Value v);
    IfcEventTriggerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcEventTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcEventTypeEnum defines the range of different types of event that can be specified.
/// 
/// HISTORY  New type in IFC2x4
/// 
/// Enumeration:
/// 
/// STARTEVENT: An initiating event of a process
/// ENDEVENT: A terminating event of a process
/// INTERMEDIATEEVENT: An event that occurs at an intermediate stage of a process
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcEventType_STARTEVENT, IfcEventType_ENDEVENT, IfcEventType_INTERMEDIATEEVENT, IfcEventType_USERDEFINED, IfcEventType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcEventTypeEnum (IfcEntityInstanceData&& e);
    IfcEventTypeEnum (Value v);
    IfcEventTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcExternalSpatialElementTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of external spatial elements.
/// Enumeration:
/// 
/// EXTERNAL - External air space around the building.
/// EXTERNAL_EARTH - External volume covered by earth around the
/// building.
/// EXTERNAL_WATER - External volume covered with water around
/// the building.
/// EXTERNAL_FIRE - Space occupied by a neightboring
/// building.
/// USERDEFINED
/// NOTDEFINED
/// 
/// HISTORY New enumeration
/// in IFC2x4.
public:
    typedef enum {IfcExternalSpatialElementType_EXTERNAL, IfcExternalSpatialElementType_EXTERNAL_EARTH, IfcExternalSpatialElementType_EXTERNAL_WATER, IfcExternalSpatialElementType_EXTERNAL_FIRE, IfcExternalSpatialElementType_USERDEFINED, IfcExternalSpatialElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcExternalSpatialElementTypeEnum (IfcEntityInstanceData&& e);
    IfcExternalSpatialElementTypeEnum (Value v);
    IfcExternalSpatialElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFacilityPartCommonTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcFacilityPartCommonType_SEGMENT, IfcFacilityPartCommonType_ABOVEGROUND, IfcFacilityPartCommonType_JUNCTION, IfcFacilityPartCommonType_LEVELCROSSING, IfcFacilityPartCommonType_BELOWGROUND, IfcFacilityPartCommonType_SUBSTRUCTURE, IfcFacilityPartCommonType_TERMINAL, IfcFacilityPartCommonType_SUPERSTRUCTURE, IfcFacilityPartCommonType_USERDEFINED, IfcFacilityPartCommonType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFacilityPartCommonTypeEnum (IfcEntityInstanceData&& e);
    IfcFacilityPartCommonTypeEnum (Value v);
    IfcFacilityPartCommonTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFacilityUsageEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcFacilityUsage_LATERAL, IfcFacilityUsage_REGION, IfcFacilityUsage_VERTICAL, IfcFacilityUsage_LONGITUDINAL, IfcFacilityUsage_USERDEFINED, IfcFacilityUsage_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFacilityUsageEnum (IfcEntityInstanceData&& e);
    IfcFacilityUsageEnum (Value v);
    IfcFacilityUsageEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFanTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of fans.
///   The IfcFanTypeEnum contains the following:
/// 
/// CENTRIFUGALFORWARDCURVED: Air flows through the impeller radially using blades that are forward curved.
///   CENTRIFUGALRADIAL: Air flows through the impeller radially using blades that are uncurved or slightl forward curved.
///   CENTRIFUGALBACKWARDINCLINEDCURVED: Air flows through the impeller radially using blades that are backward curved.
///   CENTRIFUGALAIRFOIL: Air flows through the impeller radially using blades are airfoil shaped.
///   TUBEAXIAL: Air flows through the impeller axially with reduced tip clearance and operating at higher tip speeds.
///   VANEAXIAL: Air flows through the impeller axially with guide vanes and reduced running blade tip clearance.
///   PROPELLORAXIAL: Air flows through the impeller axially and small hub-to-tip ratio impeller mounted in an orifice plate or inlet ring.
///   USERDEFINED:	User-defined fan type.
///   NOTDEFINED: Undefined fan type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcFanType_CENTRIFUGALFORWARDCURVED, IfcFanType_CENTRIFUGALRADIAL, IfcFanType_CENTRIFUGALBACKWARDINCLINEDCURVED, IfcFanType_CENTRIFUGALAIRFOIL, IfcFanType_TUBEAXIAL, IfcFanType_VANEAXIAL, IfcFanType_PROPELLORAXIAL, IfcFanType_USERDEFINED, IfcFanType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFanTypeEnum (IfcEntityInstanceData&& e);
    IfcFanTypeEnum (Value v);
    IfcFanTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFastenerTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the different types of fasteners, except for mechanical fasteners:
/// 
/// GLUE: A fastening connection where glue is used to join together elements.
/// MORTAR: A composition of mineralic or other materials used to fill jointing gaps and possibly fulfilling a load carrying role.
/// WELD: A weld seam between parts of metallic material or other suitable materials.
/// USERDEFINED: User-defined fastener
/// NOTDEFINED: Undefined fastener
/// 
/// HISTORY New Enumeration in IFC 2x4.
public:
    typedef enum {IfcFastenerType_GLUE, IfcFastenerType_MORTAR, IfcFastenerType_WELD, IfcFastenerType_USERDEFINED, IfcFastenerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFastenerTypeEnum (IfcEntityInstanceData&& e);
    IfcFastenerTypeEnum (Value v);
    IfcFastenerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFilterTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the various types of filter typically used
///   within building services distribution systems:
/// 
/// AIRPARTICLEFILTER: A filter used to remove particulates from air.
///   COMPRESSEDAIRFILTER: A filter used to remove particulates from compressed air.
///   ODORFILTER: A filter used to remove odors from air.
///   OILFILTER: A filter used to remove particulates from oil.
///   STRAINER: A filter used to remove particulates from a fluid.
///   WATERFILTER: A filter used to remove particulates from water.
///   USERDEFINED:	User-defined filter type.
///   NOTDEFINED:	Undefined filter type.
/// 
/// HISTORY: New enumeration in IFC R2x.  COMPRESSEDAIRFILTER added in IFC2x4.
public:
    typedef enum {IfcFilterType_AIRPARTICLEFILTER, IfcFilterType_COMPRESSEDAIRFILTER, IfcFilterType_ODORFILTER, IfcFilterType_OILFILTER, IfcFilterType_STRAINER, IfcFilterType_WATERFILTER, IfcFilterType_USERDEFINED, IfcFilterType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFilterTypeEnum (IfcEntityInstanceData&& e);
    IfcFilterTypeEnum (Value v);
    IfcFilterTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFireSuppressionTerminalTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcFireSuppressionTerminalTypeEnum defines the range of different types of fire suppression terminal that can be specified. 
/// 
/// HISTORY: New type in IFC 2x2
/// 
/// Enumeration
/// 
/// BREECHINGINLET: Symmetrical pipe fitting that unites two or more inlets into a single pipe (BS6100 330 114 adapted). A breeching inlet may be used on either a wet or dry riser. Used by fire services personnel for fast connection of fire appliance hose reels. May also be used for foam. 
/// FIREHYDRANT: Device, fitted to a pipe, through which a temporary supply of water may be provided (BS6100 330 6107).  May also be termed a stand pipe. 
/// HOSEREEL: A supporting framework on which a hose may be wound (BS6100 155 8201). 
/// SPRINKLER: Device for sprinkling water from a pipe under pressure over an area (BS6100 100 3432). 
/// SPRINKLERDEFLECTOR: Device attached to a sprinkler to deflect the water flow into a spread pattern to cover the required area. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Underined type.
public:
    typedef enum {IfcFireSuppressionTerminalType_BREECHINGINLET, IfcFireSuppressionTerminalType_FIREHYDRANT, IfcFireSuppressionTerminalType_HOSEREEL, IfcFireSuppressionTerminalType_SPRINKLER, IfcFireSuppressionTerminalType_SPRINKLERDEFLECTOR, IfcFireSuppressionTerminalType_USERDEFINED, IfcFireSuppressionTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFireSuppressionTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcFireSuppressionTerminalTypeEnum (Value v);
    IfcFireSuppressionTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFlowDirectionEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the flow direction at a port as either a SOURCE, SINK, or SOURCEANDSINK.  For solids, liquids, or gas, the direction is the physical flow direction.  For electric power (circuits containing hot, neutral, ground), the direction is from the origination of power (from a distribution board to protective devices to switches to fixtures).  For communication signals, the direction originates from where the signal is shaped, such as a sensor.  For communicaton networks, the direction originates from the up-level network host, such as a router (having SOURCE ports) hosting multiple computers (having SINK ports).
/// 
/// SOURCE:        A flow source, where a substance flows out of the connection.
///   SINK:          A flow sink, where a substance flows into the connection.
///   SOURCEANDSINK: Both a source and sink, where a substance flows both into and out of the connection simultaneously.
///   NOTDEFINED:    Undefined flow direction.
/// 
/// HISTORY: New enumeration in IFC R2.0
public:
    typedef enum {IfcFlowDirection_SOURCE, IfcFlowDirection_SINK, IfcFlowDirection_SOURCEANDSINK, IfcFlowDirection_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFlowDirectionEnum (IfcEntityInstanceData&& e);
    IfcFlowDirectionEnum (Value v);
    IfcFlowDirectionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFlowInstrumentTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcFlowInstrumentTypeEnum defines the range of different types of flow instrument that can be specified. 
/// 
/// HISTORY: New type in IFC
///   2x2  
///   Enumeration 
/// 
/// PRESSUREGAUGE: A device that reads and displays a pressure value at a point or the pressure difference between two points. 
/// THERMOMETER: A device that reads and displays a temperature value at a point. 
/// AMMETER: A device that reads and displays the current flow in a circuit. 
/// FREQUENCYMETER: A device that reads and displays the electrical frequency of an alternating current circuit. 
/// PHASEANGLEMETER: A device that reads and displays the phase angle of a phase in a polyphase electrical circuit. 
/// POWERFACTORMETER: A device that reads and displays the power factor of an electrical circuit. 
/// VOLTMETER_PEAK: A device that reads and displays the peak voltage in an electrical circuit. 
/// VOLTMETER_RMS: A device that reads and displays the RMS (mean) voltage in an electrical circuit. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcFlowInstrumentType_PRESSUREGAUGE, IfcFlowInstrumentType_THERMOMETER, IfcFlowInstrumentType_AMMETER, IfcFlowInstrumentType_FREQUENCYMETER, IfcFlowInstrumentType_POWERFACTORMETER, IfcFlowInstrumentType_PHASEANGLEMETER, IfcFlowInstrumentType_VOLTMETER_PEAK, IfcFlowInstrumentType_VOLTMETER_RMS, IfcFlowInstrumentType_COMBINED, IfcFlowInstrumentType_VOLTMETER, IfcFlowInstrumentType_USERDEFINED, IfcFlowInstrumentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFlowInstrumentTypeEnum (IfcEntityInstanceData&& e);
    IfcFlowInstrumentTypeEnum (Value v);
    IfcFlowInstrumentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFlowMeterTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines various types of flow meter:
/// 
/// ENERGYMETER:   An electric meter or energy meter is a device that measures the amount of electrical energy supplied to or produced by a residence, business or machine.
/// 
/// GASMETER:   A device that measures the quantity of a gas or fuel.
/// 
/// OILMETER:   A device that measures the quantity of oil.
/// 
/// WATERMETER:   A device that measures the quantity of water.
/// 
/// USERDEFINED:   User-defined meter type
/// 
/// NOTDEFINED:    Undefined meter type
/// 
/// HISTORY: New enumeration in IFC 2x2
public:
    typedef enum {IfcFlowMeterType_ENERGYMETER, IfcFlowMeterType_GASMETER, IfcFlowMeterType_OILMETER, IfcFlowMeterType_WATERMETER, IfcFlowMeterType_USERDEFINED, IfcFlowMeterType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFlowMeterTypeEnum (IfcEntityInstanceData&& e);
    IfcFlowMeterTypeEnum (Value v);
    IfcFlowMeterTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFootingTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the generic footing type.
/// 
/// HISTORY New type in IFC Release 2x2
/// IFC 2x4 change:  Item CAISSON_FOUNDATION added
/// 
/// ENUMERATION 
/// 
/// CAISSON_FOUNDATION A foundation construction type used in underwater construction.
///   FOOTING_BEAM Footing elements that are in bending and are supported clear of the ground. They will normally span between piers, piles or pile caps. They are distinguished from beams in the building superstructure since they will normally require a lower grade of finish. They are distinguished from STRIP_FOOTING since they are clear of the ground surface and hence require support to the lower face while the concrete is curing.
///   PAD_FOOTING An element that transfers the load of a single column (possibly two) to the ground.
///   PILE_CAP An element that transfers the load from a column or group of columns to a pier or pile or group of piers or piles.
///   STRIP_FOOTING A linear element that transfers loads into the ground from either a continuous element, such as a wall, or from a series of elements, such as columns.
///   USERDEFINED Special types of footings which meet specific local requirements.
///   NOTDEFINED The type of footing is not defined.
public:
    typedef enum {IfcFootingType_CAISSON_FOUNDATION, IfcFootingType_FOOTING_BEAM, IfcFootingType_PAD_FOOTING, IfcFootingType_PILE_CAP, IfcFootingType_STRIP_FOOTING, IfcFootingType_USERDEFINED, IfcFootingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFootingTypeEnum (IfcEntityInstanceData&& e);
    IfcFootingTypeEnum (Value v);
    IfcFootingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcFurnitureTypeEnum : public IfcUtil::IfcBaseType {
/// IfcFurnitureTypeEnum defines the types of furniture from which the type required can be selected. 
///   HISTORY: New Enumeration in IFC 2x4. 
///   Enumeration: 
/// 
/// CHAIR: Furniture for seating a single person.  
/// TABLE: Furniture with a countertop for multiple people.  
/// DESK: Furniture with a countertop and optional drawers for a single person.  
/// BED: Furniture for sleeping.  
/// FILECABINET: Furniture with sliding drawers for storing files.  
/// SHELF: Furniture for storing books or other items.  
/// SOFA: Furniture for seating multiple people.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcFurnitureType_CHAIR, IfcFurnitureType_TABLE, IfcFurnitureType_DESK, IfcFurnitureType_BED, IfcFurnitureType_FILECABINET, IfcFurnitureType_SHELF, IfcFurnitureType_SOFA, IfcFurnitureType_TECHNICALCABINET, IfcFurnitureType_USERDEFINED, IfcFurnitureType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcFurnitureTypeEnum (IfcEntityInstanceData&& e);
    IfcFurnitureTypeEnum (Value v);
    IfcFurnitureTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcGeographicElementTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcGeographicElementType_TERRAIN, IfcGeographicElementType_SOIL_BORING_POINT, IfcGeographicElementType_USERDEFINED, IfcGeographicElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcGeographicElementTypeEnum (IfcEntityInstanceData&& e);
    IfcGeographicElementTypeEnum (Value v);
    IfcGeographicElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcGeometricProjectionEnum : public IfcUtil::IfcBaseType {
/// IfcGeometricProjectionEnum defines the various representation types that can be semantically distinguished. Often different levels of detail of the shape representation are controlled by the representation type.
/// 
/// GRAPH_VIEW:
/// Geometric display representation that shows an abstract, often 1D
/// element representation, e.g. representing a wall by its axis line.
///   SKETCH_VIEW:
/// Geometric display representation that shows an abstract, often 2D
/// element representation, e.g. representing a wall by its two foot print
/// edges, surpressing any inner layer representation.
///   MODEL_VIEW:
/// Geometric display representation that shows a full 3D element
/// representation, e.g. representing a wall by its volumetric body.
///   PLAN_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two foot print edges and the edges of
/// all inner layers. The projection is shown in ground view as seen from
/// above.
///   REFLECTED_PLAN_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two foot print edges and the edges of
/// all inner layers. The projection is shown in ground view as seen from
/// below.
///   SECTION_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two inner/outer edges and the edges of
/// all inner layers, if the element is cut by the section line.
///   ELEVATION_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its bounding edges if the element is within
/// an elevation view.
///   USERDEFINED:
/// A user defined specification is given by the value of the UserDefinedTargetView
/// attribute.
///   NOTDEFINED:
/// No specification given.
/// 
/// HISTORY: New Type in Release IFC2x2.
public:
    typedef enum {IfcGeometricProjection_GRAPH_VIEW, IfcGeometricProjection_SKETCH_VIEW, IfcGeometricProjection_MODEL_VIEW, IfcGeometricProjection_PLAN_VIEW, IfcGeometricProjection_REFLECTED_PLAN_VIEW, IfcGeometricProjection_SECTION_VIEW, IfcGeometricProjection_ELEVATION_VIEW, IfcGeometricProjection_USERDEFINED, IfcGeometricProjection_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcGeometricProjectionEnum (IfcEntityInstanceData&& e);
    IfcGeometricProjectionEnum (Value v);
    IfcGeometricProjectionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcGlobalOrLocalEnum : public IfcUtil::IfcBaseType {
/// This enumeration type defines if the local object coordinate system or the global world coordinate system for the project is used to describe the measure values of entities which have a reference to this type.
/// 
/// NOTE  The world coordinate system is given by the IfcGeometricRepresentationContext.WorldCoordinateSystem
/// and is unique within the project. The local (or object) coordinate system is given by IfcProduct.ObjectPlacement and is used by all IfcRepresentation's within the IfcProduct.Representation.
/// 
/// HISTORY: New type in IFC2x2.
public:
    typedef enum {IfcGlobalOrLocal_GLOBAL_COORDS, IfcGlobalOrLocal_LOCAL_COORDS} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcGlobalOrLocalEnum (IfcEntityInstanceData&& e);
    IfcGlobalOrLocalEnum (Value v);
    IfcGlobalOrLocalEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcGridTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcGridType_RECTANGULAR, IfcGridType_RADIAL, IfcGridType_TRIANGULAR, IfcGridType_IRREGULAR, IfcGridType_USERDEFINED, IfcGridType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcGridTypeEnum (IfcEntityInstanceData&& e);
    IfcGridTypeEnum (Value v);
    IfcGridTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcHeatExchangerTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of heat exchangers. 
///   The IfcHeatExchangerTypeEnum contains the following:
/// 
/// PLATE: Plate heat exchanger.
///   SHELLANDTUBE: Shell and Tube heat exchanger.
///   USERDEFINED:  User-defined heat exchanger type.
///   NOTDEFINED:  Undefined heat exchanger type.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcHeatExchangerType_PLATE, IfcHeatExchangerType_SHELLANDTUBE, IfcHeatExchangerType_TURNOUTHEATING, IfcHeatExchangerType_USERDEFINED, IfcHeatExchangerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcHeatExchangerTypeEnum (IfcEntityInstanceData&& e);
    IfcHeatExchangerTypeEnum (Value v);
    IfcHeatExchangerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcHumidifierTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of humidifiers. 
///   The IfcHumidifierTypeEnum contains the following:
/// 
/// STEAMINJECTION: Water vapor is added into the airstream through direction steam injection.
///   ADIABATICAIRWASHER: Water vapor is added into the airstream through adiabatic evaporation using an air washing element.
///   ADIABATICPAN:  Water vapor is added into the airstream through adiabatic evaporation using a pan.
///   ADIABATICWETTEDELEMENT: Water vapor is added into the airstream through adiabatic evaporation using a wetted element.
///   ADIABATICATOMIZING: Water vapor is added into the airstream through adiabatic evaporation using an atomizing element.
///   ADIABATICULTRASONIC: Water vapor is added into the airstream through adiabatic evaporation using an ultrasonic element.
///   ADIABATICRIGIDMEDIA: Water vapor is added into the airstream through adiabatic evaporation using a rigid media.
///   ADIABATICCOMPRESSEDAIRNOZZLE: Water vapor is added into the airstream through adiabatic evaporation using a compressed air nozzle.
///   ASSISTEDELECTRIC: Water vapor is added into the airstream through water heated evaporation using an electric heater.
///   ASSISTEDNATURALGAS: Water vapor is added into the airstream through water heated evaporation using a natural gas heater.
///   ASSISTEDPROPANE: Water vapor is added into the airstream through water heated evaporation using a propane heater.
///   ASSISTEDBUTANE: Water vapor is added into the airstream through water heated evaporation using a butane heater.
///   ASSISTEDSTEAM: Water vapor is added into the airstream through water heated evaporation using a steam heater.
///   USERDEFINED:  User-defined humidifier type.
///   NOTDEFINED:  Undefined humidifier type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcHumidifierType_STEAMINJECTION, IfcHumidifierType_ADIABATICAIRWASHER, IfcHumidifierType_ADIABATICPAN, IfcHumidifierType_ADIABATICWETTEDELEMENT, IfcHumidifierType_ADIABATICATOMIZING, IfcHumidifierType_ADIABATICULTRASONIC, IfcHumidifierType_ADIABATICRIGIDMEDIA, IfcHumidifierType_ADIABATICCOMPRESSEDAIRNOZZLE, IfcHumidifierType_ASSISTEDELECTRIC, IfcHumidifierType_ASSISTEDNATURALGAS, IfcHumidifierType_ASSISTEDPROPANE, IfcHumidifierType_ASSISTEDBUTANE, IfcHumidifierType_ASSISTEDSTEAM, IfcHumidifierType_USERDEFINED, IfcHumidifierType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcHumidifierTypeEnum (IfcEntityInstanceData&& e);
    IfcHumidifierTypeEnum (Value v);
    IfcHumidifierTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcImpactProtectionDeviceTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcImpactProtectionDeviceType_CRASHCUSHION, IfcImpactProtectionDeviceType_DAMPINGSYSTEM, IfcImpactProtectionDeviceType_FENDER, IfcImpactProtectionDeviceType_BUMPER, IfcImpactProtectionDeviceType_USERDEFINED, IfcImpactProtectionDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcImpactProtectionDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcImpactProtectionDeviceTypeEnum (Value v);
    IfcImpactProtectionDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcInterceptorTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcInterceptorTypeEnum defines the range of different types of interceptor that can be specified. 
///   HISTORY: New type in IFC 2x4 
///   Enumeration 
/// 
/// CYCLONIC: Removes larger liquid drops or larger solid particles. 
/// GREASE: Chamber, on the line of a drain or discharge pipe, that prevents grease passing into a drainage system (BS6100 330 6205). 
/// OIL: One or more chambers arranged to prevent the ingress of oil to a drain or sewer, that retain the oil for later removal (BS6100 330 67316). 
/// PETROL: Two or more chambers with inlet and outlet pipes arranged to allow petrol/gasoline collected on the surface of water drained into them to evaporate through ventilating pipes. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcInterceptorType_CYCLONIC, IfcInterceptorType_GREASE, IfcInterceptorType_OIL, IfcInterceptorType_PETROL, IfcInterceptorType_USERDEFINED, IfcInterceptorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcInterceptorTypeEnum (IfcEntityInstanceData&& e);
    IfcInterceptorTypeEnum (Value v);
    IfcInterceptorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcInternalOrExternalEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of space boundaries in terms of either being
/// inside the building or outside the building.
/// Enumeration:
/// 
/// INTERNAL
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is an internal space on the other
/// side.
/// 
/// EXTERNAL
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is an external space on the other
/// side (i.e. air). Or it is the space boundary of that external
/// space against the building.
/// 
/// EXTERNAL_EARTH
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is earth (or terrain) on the other
/// side. Or it is the space boundary of that earth (or terrain
/// object) external space against the building.
/// 
/// EXTERNAL_WATER
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is water (water component of
/// terrain) on the other side. Or it is the space boundary of that
/// object representing water external space against the
/// building.
/// 
/// EXTERNAL_FIRE
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is another building on the other
/// side. Or it is the space boundary of that other neighbor building
/// against the building in question.
/// 
/// NOTDEFINED
/// 
/// No information available.
/// 
/// HISTORY: New enumeration
/// in IFC Release 2.0
/// IFC2x4 CHANGE: Enumeration no longer
/// applicable to IfcSpace. The following enumerators are
/// added: EXTERNAL_EARTH, EXTERNAL_WATER,
/// EXTERNAL_FIRE.
public:
    typedef enum {IfcInternalOrExternal_INTERNAL, IfcInternalOrExternal_EXTERNAL, IfcInternalOrExternal_EXTERNAL_EARTH, IfcInternalOrExternal_EXTERNAL_WATER, IfcInternalOrExternal_EXTERNAL_FIRE, IfcInternalOrExternal_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcInternalOrExternalEnum (IfcEntityInstanceData&& e);
    IfcInternalOrExternalEnum (Value v);
    IfcInternalOrExternalEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcInventoryTypeEnum : public IfcUtil::IfcBaseType {
/// IfcInventoryTypeEnum defines the types of inventory that can be defined. 
///   HISTORY: New Enumeration in IFC Release 2.0  
///   Enumeration: 
/// 
/// ASSETINVENTORY: A collection of asset instances of type IfcAsset 
/// SPACEINVENTORY: A collection of space instances of type IfcSpace 
/// FURNITUREINVENTORY: A collection of furniture instances of type IfcFurnishingElement 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcInventoryType_ASSETINVENTORY, IfcInventoryType_SPACEINVENTORY, IfcInventoryType_FURNITUREINVENTORY, IfcInventoryType_USERDEFINED, IfcInventoryType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcInventoryTypeEnum (IfcEntityInstanceData&& e);
    IfcInventoryTypeEnum (Value v);
    IfcInventoryTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcJunctionBoxTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcJunctionBoxTypeEnum defines the range of types of junction boxes available.
///   HISTORY: New type in IFC 2x2.  Values added in IFC 2x4. 
/// 
/// POWER: Contains cables, outlets, and/or switches for electrical power.
/// DATA: Contains cables, outlets, and/or switches for communications use.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcJunctionBoxType_DATA, IfcJunctionBoxType_POWER, IfcJunctionBoxType_USERDEFINED, IfcJunctionBoxType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcJunctionBoxTypeEnum (IfcEntityInstanceData&& e);
    IfcJunctionBoxTypeEnum (Value v);
    IfcJunctionBoxTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcKnotType : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcKnotType_UNIFORM_KNOTS, IfcKnotType_QUASI_UNIFORM_KNOTS, IfcKnotType_PIECEWISE_BEZIER_KNOTS, IfcKnotType_UNSPECIFIED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcKnotType (IfcEntityInstanceData&& e);
    IfcKnotType (Value v);
    IfcKnotType (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLaborResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a labor resource, and is limited to high-level categories based upon common skillsets.  The IfcLaborResourceTypeEnum contains the following:
/// 
/// ADMINISTRATION: Coordination of work.
/// CARPENTRY: Rough carpentry including framing.
/// CLEANING: Removal of dust and debris.
/// DRYWALL: Gypsum wallboard placement and taping.
/// ELECTRIC: Electrical fixtures, equipment, and cables.
/// FINISHING: Finish carpentry including custom cabinetry.
/// FLOORING: Carpet, tile, terazzo, wood, or other flooring.
/// HVAC: Heating and ventilation fixtures, equipment, and ducts.
/// GENERAL: General labor not requiring specific skill.
/// LANDSCAPING: Grass, plants, trees, or irrigation.
/// MASONRY: Laying bricks or blocks with mortar.
/// PAINTING: Applying decorative coatings or coverings.
/// PAVING: Asphalt or concrete roads and walkways.
/// PLUMBING: Plumbing fixtures, equipment, and pipes.
/// ROOFING: Membranes, shingles, tile, or other roofing.
/// SITEGRADING: Excavating, filling, or contouring earth.
/// STEELWORK: Erecting and attaching steel elements.
/// SURVEYING: Determining positions, distances, and angles.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcLaborResourceType_ADMINISTRATION, IfcLaborResourceType_CARPENTRY, IfcLaborResourceType_CLEANING, IfcLaborResourceType_CONCRETE, IfcLaborResourceType_DRYWALL, IfcLaborResourceType_ELECTRIC, IfcLaborResourceType_FINISHING, IfcLaborResourceType_FLOORING, IfcLaborResourceType_GENERAL, IfcLaborResourceType_HVAC, IfcLaborResourceType_LANDSCAPING, IfcLaborResourceType_MASONRY, IfcLaborResourceType_PAINTING, IfcLaborResourceType_PAVING, IfcLaborResourceType_PLUMBING, IfcLaborResourceType_ROOFING, IfcLaborResourceType_SITEGRADING, IfcLaborResourceType_STEELWORK, IfcLaborResourceType_SURVEYING, IfcLaborResourceType_USERDEFINED, IfcLaborResourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLaborResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcLaborResourceTypeEnum (Value v);
    IfcLaborResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLampTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcLampTypeEnum defines the range of different types of lamp available. 
/// 
/// HISTORY: New type in IFC 2x2 Addendum
///   1  
///   Enumeration 
/// 
/// COMPACTFLUORESCENT: A fluorescent lamp having a compact form factor produced by shaping the tube. 
/// FLUORESCENT: A typically tubular discharge lamp in which most of the light is emitted by one or several layers of phosphors excited by ultraviolet radiation from the discharge.
/// HALOGEN: an incandescent lamp in which a tungsten filament is sealed into a compact transport envelope filled with an inert gas and a small amount of halogen such as iodine or bromine.
/// HIGHPRESSUREMERCURY: A discharge lamp in which most of the light is emitted by exciting mercury at high pressure.
/// HIGHPRESSURESODIUM: A discharge lamp in which most of the light is emitted by exciting sodium at high pressure.
/// LED: a solid state lamp that uses light-emitting diodes as the source of light.
/// METALHALIDE: A discharge lamp in which most of the light is emitted by exciting a metal halide.
/// OLED: a solid state lamp that uses light-emitting diodes as the source of light whose emissive electroluminescent layer is composed of a film of organic compounds.
/// TUNGSTENFILAMENT: A lamp that emits light by passing an electrical current through a tungsten wire filament in a near vacuum.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcLampType_COMPACTFLUORESCENT, IfcLampType_FLUORESCENT, IfcLampType_HALOGEN, IfcLampType_HIGHPRESSUREMERCURY, IfcLampType_HIGHPRESSURESODIUM, IfcLampType_LED, IfcLampType_METALHALIDE, IfcLampType_OLED, IfcLampType_TUNGSTENFILAMENT, IfcLampType_USERDEFINED, IfcLampType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLampTypeEnum (IfcEntityInstanceData&& e);
    IfcLampTypeEnum (Value v);
    IfcLampTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLayerSetDirectionEnum : public IfcUtil::IfcBaseType {
/// IfcLayerSetDirectionEnum provides identification of the axis of element geometry, denoting the layer set thickness direction, or direction of layer offsets.
/// 
/// ENUMERATION
/// 
/// AXIS1: Usually x-axis.
/// AXIS2: Usually y-axis.
/// AXIS3: Usually z-axis.
/// 
/// HISTORY: New Type in IFC2x.
public:
    typedef enum {IfcLayerSetDirection_AXIS1, IfcLayerSetDirection_AXIS2, IfcLayerSetDirection_AXIS3} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLayerSetDirectionEnum (IfcEntityInstanceData&& e);
    IfcLayerSetDirectionEnum (Value v);
    IfcLayerSetDirectionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLightDistributionCurveEnum : public IfcUtil::IfcBaseType {
/// There are three kinds of light distribution curves, according to Standard CEN TC 169, prEN 13032-1, CIE 121: 
/// 
/// TYPE_A: Type A is basically not used. For completeness the Type A Photometry equals the Type B rotated 90° around the Z-Axis counter clockwise. 
/// TYPE_B: Type B is sometimes used for floodlights. The B-Plane System has a horizontal axis. B-Angles are valid from -180° to +180° with B 0° at the bottom and B180°/B-180° at the top, &#946;-Angles are valid from -90° to +90°. (See Figure 302.)
/// TYPE_C: Type C is the recommended standard system. The C-Plane system equals a globe with a vertical axis. C-Angles are valid from 0° to 360°, &#947;-Angles are valid from 0° (south pole) to 180° (north pole). (See Figure 302.) 
/// 
/// <table
/// 
/// B-Type System 
///   C-Type System 
/// 
/// Figure 302 — Light distribution curves
/// 
/// HISTORY  This is a new enumeration in IFC2x2.
public:
    typedef enum {IfcLightDistributionCurve_TYPE_A, IfcLightDistributionCurve_TYPE_B, IfcLightDistributionCurve_TYPE_C, IfcLightDistributionCurve_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLightDistributionCurveEnum (IfcEntityInstanceData&& e);
    IfcLightDistributionCurveEnum (Value v);
    IfcLightDistributionCurveEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLightEmissionSourceEnum : public IfcUtil::IfcBaseType {
/// IfcLightEmissionSourceEnum defines the range of different types of light emitter available. 
/// 
/// HISTORY: New type in IFC2x2.
/// 
/// Enumeration 
/// 
/// COMPACTFLUORESCENT
/// FLUORESCENT
/// HIGHPRESSUREMERCURY
/// HIGHPRESSURESODIUM
/// LIGHTEMITTINGDIODE
/// LOWPRESSURESODIUM
/// LOWVOLTAGEHALOGEN
/// MAINVOLTAGEHALOGEN
/// METALHALIDE 
/// TUNGSTENFILAMENT 
/// NOTDEFINED
public:
    typedef enum {IfcLightEmissionSource_COMPACTFLUORESCENT, IfcLightEmissionSource_FLUORESCENT, IfcLightEmissionSource_HIGHPRESSUREMERCURY, IfcLightEmissionSource_HIGHPRESSURESODIUM, IfcLightEmissionSource_LIGHTEMITTINGDIODE, IfcLightEmissionSource_LOWPRESSURESODIUM, IfcLightEmissionSource_LOWVOLTAGEHALOGEN, IfcLightEmissionSource_MAINVOLTAGEHALOGEN, IfcLightEmissionSource_METALHALIDE, IfcLightEmissionSource_TUNGSTENFILAMENT, IfcLightEmissionSource_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLightEmissionSourceEnum (IfcEntityInstanceData&& e);
    IfcLightEmissionSourceEnum (Value v);
    IfcLightEmissionSourceEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLightFixtureTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcLightFixtureTypeEnum defines the range of different types of light fixture available.
/// 
/// HISTORY: New type in IFC 2x Edition 2IFC 2x4: SECURITYLIGHTING added
/// 
/// Enumeration
/// 
/// POINTSOURCE: A light fixture that is considered to have negligible area and that emit light with approximately equal intensity in all directions.  A light fixture containing a tungsten, halogen or similar bulb is an example of a point source.
/// DIRECTIONSOURCE: A light fixture that is considered to have a length or surface area from which it emits light in a direction. A light fixture containing one or more fluorescent lamps is an example of a direction source. 
/// SECURITYLIGHTING: A light fixture having specific purpose of directing occupants in an emergency, such as an illuminated exit sign or emergency flood light. 
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcLightFixtureType_POINTSOURCE, IfcLightFixtureType_DIRECTIONSOURCE, IfcLightFixtureType_SECURITYLIGHTING, IfcLightFixtureType_USERDEFINED, IfcLightFixtureType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLightFixtureTypeEnum (IfcEntityInstanceData&& e);
    IfcLightFixtureTypeEnum (Value v);
    IfcLightFixtureTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLiquidTerminalTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcLiquidTerminalType_LOADINGARM, IfcLiquidTerminalType_HOSEREEL, IfcLiquidTerminalType_USERDEFINED, IfcLiquidTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLiquidTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcLiquidTerminalTypeEnum (Value v);
    IfcLiquidTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLoadGroupTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This type definition is used to distinguish between different levels
/// of load grouping.  It allows to differentiate between load groups, load cases, and load combinations.
/// Normally, these enumeration types shall be used in the following context:
/// 
/// LOAD_GROUP groups instances of subtypes of IfcStructuralAction.  It shall be used as a
///   container for loads grouped together for specific purposes, e.g. loads which are part of a
///   special load pattern.
///   LOAD_CASE groups LOAD_GROUPs and instances of subtypes of IfcStructuralAction.
///   It should be used as a container for loads with the same origin.
///   LOAD_COMBINATION_GROUP is an intermediate level between LOAD_CASE and LOAD_COMBINATION.
///   The purpose of this level is to provide a factor with which one or more LOAD_CASEs occur in a
///   LOAD_COMBINATION.  This factor cannot be specified directly at the load case if the load case
///   is meant to occur in more than one combination with different factors.
///   This intermediate level is obsolete.  Instead, 
///   LOAD_COMBINATION is used to group load cases which act together into a load combination.
///   USERDEFINED:  A grouping level which does not follow the standard hierarchy of load group types.
///   NOTDEFINED:  The grouping level is not yet known.
/// 
/// HISTORY: New type in IFC 2x2.
/// 
/// IFC 2x4 change:  Obsolete item LOAD_COMBINATION_GROUP removed.  Load cases are directly assigned to load combinations with different factors for each load case—load combination pair by means of IfcRelAssignsToGroupByFactor.
public:
    typedef enum {IfcLoadGroupType_LOAD_GROUP, IfcLoadGroupType_LOAD_CASE, IfcLoadGroupType_LOAD_COMBINATION, IfcLoadGroupType_USERDEFINED, IfcLoadGroupType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLoadGroupTypeEnum (IfcEntityInstanceData&& e);
    IfcLoadGroupTypeEnum (Value v);
    IfcLoadGroupTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcLogicalOperatorEnum : public IfcUtil::IfcBaseType {
/// Definition: IfcLogicalOperatorEnum is an enumeration that defines the logical operators that may be applied for the satisfaction of one or more operands (IfcConstraint) at a time. 
/// 
/// HISTORY  New type in IFC Release 2.0.  Renamed from IfcConstraintAggregatorEnum in IFC 2x2
/// 
/// IFC2x4 CHANGE: Extended to include LOGICALXOR, LOGICALNOTAND and LOGICALNOTOR.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// LOGICALAND 
///   Defines a relationship between operands whereby the result is true if all operands are true, i.e. false if at least 
/// one operand is false. 
/// 
/// LOGICALOR 
///   Defines a relationship between operands whereby the result is true if at least one operand is true, i.e false if 
/// all operands are false. 
/// 
/// LOGICALXOR 
///   Defines a relationship between operands whereby the result is true if exactly one operand is true (exclusive or). 
/// 
/// LOGICALNOTAND 
///   Defines a relationship between operands whereby the result is true if at least one operand is false, i.e false if 
/// all operands are true. 
/// 
/// LOGICALNOTOR 
///   Defines a relationship between operands whereby the result is true if all operands are false, i.e false if at least 
/// one operand is true. 
/// 
/// Use Definition 
/// 
/// The IfcLogicalOperatorEnum, when applied in a case of three operands, A, B and C, evaluates for each operator as 
/// follows:
/// 
/// TRUTH TABLE: LOGICALAND(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// AND
/// F
/// F
/// F
/// F
/// F
/// F
/// F
/// T
/// 
/// TRUTH TABLE: LOGICALOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// OR
/// F
/// T
/// T
/// T
/// T
/// T
/// T
/// T
/// 
/// TRUTH TABLE: LOGICALXOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// XOR
/// F
/// T
/// T
/// T
/// F
/// F
/// F
/// F
/// 
/// TRUTH TABLE: LOGICALNOTAND(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// NOTAND
/// T
/// T
/// T
/// T
/// T
/// T
/// T
/// F
/// 
/// TRUTH TABLE: LOGICALNOTOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// NOTOR
/// T
/// F
/// F
/// F
/// F
/// F
/// F
/// F
public:
    typedef enum {IfcLogicalOperator_LOGICALAND, IfcLogicalOperator_LOGICALOR, IfcLogicalOperator_LOGICALXOR, IfcLogicalOperator_LOGICALNOTAND, IfcLogicalOperator_LOGICALNOTOR} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcLogicalOperatorEnum (IfcEntityInstanceData&& e);
    IfcLogicalOperatorEnum (Value v);
    IfcLogicalOperatorEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMarineFacilityTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcMarineFacilityType_CANAL, IfcMarineFacilityType_WATERWAYSHIPLIFT, IfcMarineFacilityType_EMBANKMENT, IfcMarineFacilityType_LAUNCHRECOVERY, IfcMarineFacilityType_MARINEDEFENCE, IfcMarineFacilityType_HYDROLIFT, IfcMarineFacilityType_SHIPYARD, IfcMarineFacilityType_SHIPLIFT, IfcMarineFacilityType_PORT, IfcMarineFacilityType_QUAY, IfcMarineFacilityType_FLOATINGDOCK, IfcMarineFacilityType_NAVIGATIONALCHANNEL, IfcMarineFacilityType_BREAKWATER, IfcMarineFacilityType_DRYDOCK, IfcMarineFacilityType_JETTY, IfcMarineFacilityType_SHIPLOCK, IfcMarineFacilityType_BARRIERBEACH, IfcMarineFacilityType_SLIPWAY, IfcMarineFacilityType_WATERWAY, IfcMarineFacilityType_USERDEFINED, IfcMarineFacilityType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMarineFacilityTypeEnum (IfcEntityInstanceData&& e);
    IfcMarineFacilityTypeEnum (Value v);
    IfcMarineFacilityTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMarinePartTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcMarinePartType_CREST, IfcMarinePartType_MANUFACTURING, IfcMarinePartType_LOWWATERLINE, IfcMarinePartType_CORE, IfcMarinePartType_WATERFIELD, IfcMarinePartType_CILL_LEVEL, IfcMarinePartType_BERTHINGSTRUCTURE, IfcMarinePartType_COPELEVEL, IfcMarinePartType_CHAMBER, IfcMarinePartType_STORAGE, IfcMarinePartType_APPROACHCHANNEL, IfcMarinePartType_VEHICLESERVICING, IfcMarinePartType_SHIPTRANSFER, IfcMarinePartType_GATEHEAD, IfcMarinePartType_GUDINGSTRUCTURE, IfcMarinePartType_BELOWWATERLINE, IfcMarinePartType_WEATHERSIDE, IfcMarinePartType_LANDFIELD, IfcMarinePartType_PROTECTION, IfcMarinePartType_LEEWARDSIDE, IfcMarinePartType_ABOVEWATERLINE, IfcMarinePartType_ANCHORAGE, IfcMarinePartType_NAVIGATIONALAREA, IfcMarinePartType_HIGHWATERLINE, IfcMarinePartType_USERDEFINED, IfcMarinePartType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMarinePartTypeEnum (IfcEntityInstanceData&& e);
    IfcMarinePartTypeEnum (Value v);
    IfcMarinePartTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMechanicalFastenerTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of mechanical fasteners:
/// 
/// ANCHORBOLT: A special bolt which is anchored into conrete, stone, or brickwork.
/// BOLT: A threaded cylindrical rod that engages with a similarly threaded hole in a nut or any other part to form a fastener. The mechanical fastener often also includes one or more washers and one or more nuts.
/// DOWEL: A cylindrical rod that is driven into holes of the connected pieces.
/// NAIL: A thin pointed piece of metal that is hammered into materials as a fastener.
/// NAILPLATE: A piece of sheet metal with punched points that overlaps the connected pieces and is pressed into their material.
/// RIVET: A fastening part having a head at one end and the other end being hammered flat after being passed through holes in the pieces that are fastened together.
/// SCREW: A fastener with a tapered threaded shank and a slotted head.
/// SHEARCONNECTOR: A ring connector that is accepted by ring keyways in the connected pieces; or a toothed circular or square connector that is pressed into the connected pieces.
/// STAPLE: A doubly pointed piece of metal that is hammered into materials as a fastener.
/// STUDSHEARCONNECTOR: Stud shear connectors are cylindrical fastening parts with a head on one side. On the other side they are welded on steel members for the use in composite steel and concrete structures.
/// USERDEFINED: User-defined mechanical fastener
/// NOTDEFINED: Undefined mechanical fastener
/// 
/// HISTORY New Enumeration in IFC 2x4.
public:
    typedef enum {IfcMechanicalFastenerType_ANCHORBOLT, IfcMechanicalFastenerType_BOLT, IfcMechanicalFastenerType_DOWEL, IfcMechanicalFastenerType_NAIL, IfcMechanicalFastenerType_NAILPLATE, IfcMechanicalFastenerType_RIVET, IfcMechanicalFastenerType_SCREW, IfcMechanicalFastenerType_SHEARCONNECTOR, IfcMechanicalFastenerType_STAPLE, IfcMechanicalFastenerType_STUDSHEARCONNECTOR, IfcMechanicalFastenerType_COUPLER, IfcMechanicalFastenerType_RAILJOINT, IfcMechanicalFastenerType_RAILFASTENING, IfcMechanicalFastenerType_CHAIN, IfcMechanicalFastenerType_ROPE, IfcMechanicalFastenerType_USERDEFINED, IfcMechanicalFastenerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMechanicalFastenerTypeEnum (IfcEntityInstanceData&& e);
    IfcMechanicalFastenerTypeEnum (Value v);
    IfcMechanicalFastenerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMedicalDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the functional type of medical device.
/// 
/// The IfcMedicalDeviceTypeEnum contains the following:
/// 
/// AIRSTATION: Device that provides purified medical air, composed of an air compressor and air treatment line.
/// FEEDERUNIT: Device that feeds air to an oxygen generator, composed of an air compressor, air treatment line, and an air receiver.
/// OXYGENGENERATOR: Device that generates oxygen from air.
/// OXYGENPLANT: Device that combines a feed air unit, oxygen generator, and backup oxygen cylinders.
/// VACUUMSTATION: Device that provides suction, composed of a vacuum pump and bacterial filtration line.
/// USERDEFINED: User-defined medical device type.
/// NOTDEFINED:  Undefined medical device type.
/// 
/// HISTORY: New enumeration in IFC 2x4.
public:
    typedef enum {IfcMedicalDeviceType_AIRSTATION, IfcMedicalDeviceType_FEEDAIRUNIT, IfcMedicalDeviceType_OXYGENGENERATOR, IfcMedicalDeviceType_OXYGENPLANT, IfcMedicalDeviceType_VACUUMSTATION, IfcMedicalDeviceType_USERDEFINED, IfcMedicalDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMedicalDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcMedicalDeviceTypeEnum (Value v);
    IfcMedicalDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMemberTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcMemberType object
/// can fulfill:
/// 
/// BRACE: A linear element (usually sloped) often used
/// for bracing of a girder or truss.
/// CHORD: Upper or lower longitudinal member of a truss,
/// used horizontally or sloped.
/// COLLAR: A linear element (usually used horizontally)
/// within a roof structure to connect rafters and posts.
/// MEMBER: A linear element within a girder or truss with
/// no further meaning.
/// MULLION: A linear element within a curtain wall system
/// to connect two (or more) panels.
/// PLATE: Alinear continuous horizontal element in wall
/// framing, e.g. a head piece or a sole plate.
/// 
/// NOTE This head piece or sole plate shall not
/// be mixed up with planar elements, such as sheets and panels, that
/// are handled as IfcPlate (and
/// IfcPlateType).
/// 
/// POST: A linear member (usually used vertically) within
/// a roof structure to support purlins.
/// PURLIN: A linear element (usually used horizontally)
/// within a roof structure to support rafters
/// RAFTER: A linear elements used to support roof slabs
/// or roof covering, usually used with slope.
/// STRINGER: A linear element used to support stair or
/// ramp flights, usually used with slope.
/// STRUT: A linear element often used within a girder or
/// truss.
/// STUD: Vertical element in wall framing.
/// USERDEFINED: User-defined linear element.
/// NOTDEFINED: Undefined linear element
/// 
/// HISTORY: New
/// Enumeration in Release IFC2x Edition 2.
/// IFC2x Edition 2
/// Addendum 1 CHANGE The additional identifiers CHORD, PLATE, STUD
/// are added.
/// IFC2x Edition 3 CHANGE The additional identifier MULLION has
/// been added.
public:
    typedef enum {IfcMemberType_BRACE, IfcMemberType_CHORD, IfcMemberType_COLLAR, IfcMemberType_MEMBER, IfcMemberType_MULLION, IfcMemberType_PLATE, IfcMemberType_POST, IfcMemberType_PURLIN, IfcMemberType_RAFTER, IfcMemberType_STRINGER, IfcMemberType_STRUT, IfcMemberType_STUD, IfcMemberType_STIFFENING_RIB, IfcMemberType_ARCH_SEGMENT, IfcMemberType_SUSPENSION_CABLE, IfcMemberType_SUSPENDER, IfcMemberType_STAY_CABLE, IfcMemberType_STRUCTURALCABLE, IfcMemberType_TIEBAR, IfcMemberType_USERDEFINED, IfcMemberType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMemberTypeEnum (IfcEntityInstanceData&& e);
    IfcMemberTypeEnum (Value v);
    IfcMemberTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMobileTelecommunicationsApplianceTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcMobileTelecommunicationsApplianceType_E_UTRAN_NODE_B, IfcMobileTelecommunicationsApplianceType_REMOTE_RADIO_UNIT, IfcMobileTelecommunicationsApplianceType_ACCESSPOINT, IfcMobileTelecommunicationsApplianceType_BASETRANSCEIVERSTATION, IfcMobileTelecommunicationsApplianceType_REMOTEUNIT, IfcMobileTelecommunicationsApplianceType_BASEBANDUNIT, IfcMobileTelecommunicationsApplianceType_MASTERUNIT, IfcMobileTelecommunicationsApplianceType_USERDEFINED, IfcMobileTelecommunicationsApplianceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMobileTelecommunicationsApplianceTypeEnum (IfcEntityInstanceData&& e);
    IfcMobileTelecommunicationsApplianceTypeEnum (Value v);
    IfcMobileTelecommunicationsApplianceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMooringDeviceTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcMooringDeviceType_LINETENSIONER, IfcMooringDeviceType_MAGNETICDEVICE, IfcMooringDeviceType_MOORINGHOOKS, IfcMooringDeviceType_VACUUMDEVICE, IfcMooringDeviceType_BOLLARD, IfcMooringDeviceType_USERDEFINED, IfcMooringDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMooringDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcMooringDeviceTypeEnum (Value v);
    IfcMooringDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcMotorConnectionTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcMotorConnectionTypeEnum defines the range of different types of motor connection that can be specified. 
///   HISTORY: New type in IFC 2x.  
///   Enumeration 
/// 
/// BELTDRIVE: An indirect connection made through the medium of a shaped, flexible continuous loop. 
/// COUPLING: An indirect connection made through the medium of the viscosity of a fluid. 
/// DIRECTDRIVE: A direct, physical connection made between the motor and the driven device. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcMotorConnectionType_BELTDRIVE, IfcMotorConnectionType_COUPLING, IfcMotorConnectionType_DIRECTDRIVE, IfcMotorConnectionType_USERDEFINED, IfcMotorConnectionType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcMotorConnectionTypeEnum (IfcEntityInstanceData&& e);
    IfcMotorConnectionTypeEnum (Value v);
    IfcMotorConnectionTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcNavigationElementTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcNavigationElementType_BEACON, IfcNavigationElementType_BUOY, IfcNavigationElementType_USERDEFINED, IfcNavigationElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcNavigationElementTypeEnum (IfcEntityInstanceData&& e);
    IfcNavigationElementTypeEnum (Value v);
    IfcNavigationElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcNullStyle : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-46:1992: The null style type specifies, that a representation item is not styled.
/// 
/// NOTE  Corresponding ISO 10303 name: null_style. Please refer to ISO/IS 10303-46:1994 for the final
/// definition of the formal standard.
/// 
/// HISTORY  New enumeration in IFC2x2.
/// 
/// IFC2x4 CHANGE  The enumeration is deprecated.
public:
    typedef enum {IfcNullStyle_NULL} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcNullStyle (IfcEntityInstanceData&& e);
    IfcNullStyle (Value v);
    IfcNullStyle (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcObjectTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the applicable object categories, that is, the subtypes at the 2nd level of the IFC inheritance tree. Attached to an object, it indicates to which subtype of IfcObject the entity referencing it would otherwise comply with. 
/// 
/// HISTORY New entity in IFC Release 1.0, has been renamed from IfcProxyEnum in IFC 2x.
public:
    typedef enum {IfcObjectType_PRODUCT, IfcObjectType_PROCESS, IfcObjectType_CONTROL, IfcObjectType_RESOURCE, IfcObjectType_ACTOR, IfcObjectType_GROUP, IfcObjectType_PROJECT, IfcObjectType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcObjectTypeEnum (IfcEntityInstanceData&& e);
    IfcObjectTypeEnum (Value v);
    IfcObjectTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcObjectiveEnum : public IfcUtil::IfcBaseType {
/// IfcObjectiveEnum is an enumeration used to determine the objective for which purpose the constraint needs to be satisfied. 
/// 
/// HISTORY: IFC2x4 CHANGE: Extended to include CODEWAIVER.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// CODECOMPLIANCE 
///   A constraint whose objective is to ensure satisfaction of a code compliance provision. 
/// 
/// CODEWAIVER 
///   A constraint whose objective is to identify an agreement that code compliance requirements (the waiver) will not be enforced. 
/// 
/// DESIGNINTENT 
///   A constraint whose objective is to ensure satisfaction of a design intent provision. 
/// 
/// HEALTHANDSAFETY 
///   A constraint whose objective is to ensure satisfaction of a health and safety provision. 
/// 
/// REQUIREMENT 
///   A constraint whose objective is to ensure satisfaction of a project requirement provision. 
/// 
/// SPECIFICATION 
///   A constraint whose objective is to ensure satisfaction of a specification provision. 
/// 
/// TRIGGERCONDITION 
///   A constraint whose objective is to indicate a limiting value beyond which the condition of an object requires a particular form of attention.
public:
    typedef enum {IfcObjective_CODECOMPLIANCE, IfcObjective_CODEWAIVER, IfcObjective_DESIGNINTENT, IfcObjective_EXTERNAL, IfcObjective_HEALTHANDSAFETY, IfcObjective_MERGECONFLICT, IfcObjective_MODELVIEW, IfcObjective_PARAMETER, IfcObjective_REQUIREMENT, IfcObjective_SPECIFICATION, IfcObjective_TRIGGERCONDITION, IfcObjective_USERDEFINED, IfcObjective_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcObjectiveEnum (IfcEntityInstanceData&& e);
    IfcObjectiveEnum (Value v);
    IfcObjectiveEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcOccupantTypeEnum : public IfcUtil::IfcBaseType {
/// IfcOccupantTypeEnum defines the types of occupant from which the type required can be selected. 
///   HISTORY: New Enumeration in IFC Release 2.0 Modified in IFC 2x2 
///   Enumeration: 
/// 
/// ASSIGNEE: Actor receiving the assignment of a property agreement from an assignor  
/// ASSIGNOR: Actor assigning a property agreement to an assignor  
/// LESSEE: Actor receiving the lease of a property from a lessor  
/// LESSOR: Actor leasing a property to a lessee  
/// LETTINGAGENT: Actor participating in a property agreement on behalf of an owner, lessor or assignor  
/// OWNER: Actor that owns a property  
/// TENANT: Actor renting the use of a property fro a period of time  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcOccupantType_ASSIGNEE, IfcOccupantType_ASSIGNOR, IfcOccupantType_LESSEE, IfcOccupantType_LESSOR, IfcOccupantType_LETTINGAGENT, IfcOccupantType_OWNER, IfcOccupantType_TENANT, IfcOccupantType_USERDEFINED, IfcOccupantType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcOccupantTypeEnum (IfcEntityInstanceData&& e);
    IfcOccupantTypeEnum (Value v);
    IfcOccupantTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcOpeningElementTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: An enumeration defining the basic
/// types for opening elements.
/// 
/// HISTORY New enumeration type in
/// IFC2x4.
/// 
/// Enumeration
/// 
/// OPENING: An opening as subtraction
/// feature that cuts through the element it voids. It thereby
/// creates a hole. An opening in addiion have a particular meaning
/// for either providing a void for doors or windows, or an opening
/// to permit flow of air and passing of light,
/// RECESS: A opening as subtraction
/// feature that does not cut through the element it voids. It
/// creates a niche or similar voiding pattern.
/// USERDEFINED: User-defined opening
/// element
/// NOTDEFINED: Undefined opening
/// element
public:
    typedef enum {IfcOpeningElementType_OPENING, IfcOpeningElementType_RECESS, IfcOpeningElementType_USERDEFINED, IfcOpeningElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcOpeningElementTypeEnum (IfcEntityInstanceData&& e);
    IfcOpeningElementTypeEnum (Value v);
    IfcOpeningElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcOutletTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcOutletTypeEnum defines the range of different types of outlet that can be specified. 
/// 
/// HISTORY: New type in IFC 2x. Telephone and Data outlets added in IFC 2x4
/// 
/// Enumeration 
/// 
/// AUDIOVISUALOUTLET: An outlet used for an audio or visual device. 
/// COMMUNICATIONSOUTLET: An outlet used for connecting communications equipment. 
/// POWEROUTLET: An outlet used for connecting electrical devices requiring power.  
/// DATAOUTLET: An outlet used for connecting data communications equipment. 
/// TELEPHONEOUTLET: An outlet used for connecting telephone communications equipment.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcOutletType_AUDIOVISUALOUTLET, IfcOutletType_COMMUNICATIONSOUTLET, IfcOutletType_POWEROUTLET, IfcOutletType_DATAOUTLET, IfcOutletType_TELEPHONEOUTLET, IfcOutletType_USERDEFINED, IfcOutletType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcOutletTypeEnum (IfcEntityInstanceData&& e);
    IfcOutletTypeEnum (Value v);
    IfcOutletTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPerformanceHistoryTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of performance history.  The IfcPerformanceHistoryTypeEnum contains the following:
/// 
/// USERDEFINED: User-defined.
/// NOTDEFINED: Undefined.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcPerformanceHistoryType_USERDEFINED, IfcPerformanceHistoryType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPerformanceHistoryTypeEnum (IfcEntityInstanceData&& e);
    IfcPerformanceHistoryTypeEnum (Value v);
    IfcPerformanceHistoryTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPermeableCoveringOperationEnum : public IfcUtil::IfcBaseType {
/// Definition: Enumeration defining the valid types of permeable coverings. 
/// 
/// Enumeration:
/// 
/// GRILL 
///   protective screen of metal bars or wires
/// 
/// LOUVER 
///   set of fixed or movable strips of wood, metal, etc. arranged to let
///   air in while keeping light or rain out
/// 
/// SCREEN 
///   upright, fixed or movable, sometimes folding framework used for
///   protection against heat, light, access or similar
/// 
/// USERDEFINED 
///   user defined permeable covering type
/// 
/// NOTDEFINED 
///   no information available
/// 
/// HISTORY: New Enumeration in IFC Release 2.0
public:
    typedef enum {IfcPermeableCoveringOperation_GRILL, IfcPermeableCoveringOperation_LOUVER, IfcPermeableCoveringOperation_SCREEN, IfcPermeableCoveringOperation_USERDEFINED, IfcPermeableCoveringOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPermeableCoveringOperationEnum (IfcEntityInstanceData&& e);
    IfcPermeableCoveringOperationEnum (Value v);
    IfcPermeableCoveringOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPermitTypeEnum : public IfcUtil::IfcBaseType {
/// IfcPermitTypeEnum defines the types of permits that can be granted. 
///   HISTORY: New Enumeration in IFC2x4. 
///   Enumeration: 
/// 
/// ACCESS: Enables access to an identified area. 
/// BUILDING: Enables work to proceed by getting regulatory permissions. 
/// WORK: Enables work to be carried out in an identified area. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcPermitType_ACCESS, IfcPermitType_BUILDING, IfcPermitType_WORK, IfcPermitType_USERDEFINED, IfcPermitType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPermitTypeEnum (IfcEntityInstanceData&& e);
    IfcPermitTypeEnum (Value v);
    IfcPermitTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPhysicalOrVirtualEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
///   different types of space boundaries in terms of its
///   physical manifestation. A space boundary can either be
///   physically dividing or can be a virtual divider.
/// 
/// Enumeration:
/// 
/// PHYSICAL
/// 
/// The space boundary is provided physically, i.e. by an
///   physical element.
/// 
/// VIRTUAL
/// 
/// The space boundary is provided virtually, i.e. by a
///   logical divider that has no physical manifestation.
/// 
/// NOTDEFINED
/// 
/// No information available.
/// 
/// HISTORY: New enumeration in
///   IFC Release 2.0
public:
    typedef enum {IfcPhysicalOrVirtual_PHYSICAL, IfcPhysicalOrVirtual_VIRTUAL, IfcPhysicalOrVirtual_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPhysicalOrVirtualEnum (IfcEntityInstanceData&& e);
    IfcPhysicalOrVirtualEnum (Value v);
    IfcPhysicalOrVirtualEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPileConstructionEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the construction type
///   for piles. The type is mainly based on how the piles are used and manufactured.
///   Some material information is mixed in because this affects the way the piles
///   are used.  
/// 
/// HISTORY New type in IFC Release 2x2
/// 
/// ENUMERATION 
/// 
/// CAST_IN_PLACE Piles and piers that are excavated and poured in
///   place. 
///   COMPOSITE Piles that are a mix of components, such as a steel
///   outer casing which is driven into the ground with a cast-in-place concrete
///   core. 
///   PRECAST_CONCRETE Piles that are entirely of precast concrete
///   (possibly with some steel or other fixtures). 
///   PREFAB_STEEL Prefabricated piles made entirely out of steel.
///   It will also include steel sheet piles where these are not part of another
///   construction element. 
///   USERDEFINED Special types of pile construction which meet
///   specific local requirements. 
///   NOTDEFINED The type of pile construction is not defined.
public:
    typedef enum {IfcPileConstruction_CAST_IN_PLACE, IfcPileConstruction_COMPOSITE, IfcPileConstruction_PRECAST_CONCRETE, IfcPileConstruction_PREFAB_STEEL, IfcPileConstruction_USERDEFINED, IfcPileConstruction_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPileConstructionEnum (IfcEntityInstanceData&& e);
    IfcPileConstructionEnum (Value v);
    IfcPileConstructionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPileTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the pile type. 
/// 
/// HISTORY New type in IFC Release 2x2
/// IFC 2x4 change:  Items BORED, DRIVEN, JETGROUTING added
/// 
/// BORED A bore pile.
///   DRIVEN A rammed, vibrated, or otherwise driven pile.
///   JETGROUTING An injected pile-like construction.
///   COHESION A cohesion pile.
///   FRICTION A friction pile.
///   SUPPORT A support pile.
///   USERDEFINED The type of pile function is user defined.
///   NOTDEFINED The type of pile function is not defined.
public:
    typedef enum {IfcPileType_BORED, IfcPileType_DRIVEN, IfcPileType_JETGROUTING, IfcPileType_COHESION, IfcPileType_FRICTION, IfcPileType_SUPPORT, IfcPileType_USERDEFINED, IfcPileType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPileTypeEnum (IfcEntityInstanceData&& e);
    IfcPileTypeEnum (Value v);
    IfcPileTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPipeFittingTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a pipe fitting. This is a very basic categorization mechanism
///   to generically identify the pipe fitting type. Subcategories
///   of pipe fittings are not enumerated. 
///   The IfcpipeFittingTypeEnum contains the following:
/// 
/// BEND:		A fitting with typically two ports used to change 
///   the direction of flow between connected elements.
///   CONNECTOR:   Connector fitting, typically used to join two
///   ports together within a flow distribution system 
///   (e.g., a coupling used to join two pipe segments).
///   ENTRY:       Entry fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., a breeching inlet).
///   EXIT:        Exit fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., a hose bibb).
///   JUNCTION:	A fitting with typically more than two ports used
///   to redistribute flow among the ports and/or to
///   change the direction of flow between connected
///   elements (e.g, tee, cross, wye, etc.).
///   OBSTRUCTION: A fitting with typically two ports used to 
///   obstruct or restrict flow between the connected
///   elements (e.g., screen, perforated plate, etc.).
///   TRANSITION:	A fitting with typically two ports having
///   different shapes or sizes. Can also be used to
///   change the direction of flow between connected
///   elements.
///   USERDEFINED: User-defined fitting.
///   NOTDEFINED:  Undefined fitting.
/// 
/// HISTORY: New enumeration in IFC 2x2
public:
    typedef enum {IfcPipeFittingType_BEND, IfcPipeFittingType_CONNECTOR, IfcPipeFittingType_ENTRY, IfcPipeFittingType_EXIT, IfcPipeFittingType_JUNCTION, IfcPipeFittingType_OBSTRUCTION, IfcPipeFittingType_TRANSITION, IfcPipeFittingType_USERDEFINED, IfcPipeFittingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPipeFittingTypeEnum (IfcEntityInstanceData&& e);
    IfcPipeFittingTypeEnum (Value v);
    IfcPipeFittingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPipeSegmentTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a
///   pipe segment. This is a very basic categorization mechanism
///   to generically identify the pipe segment type. Subcategories
///   of pipe segments are not enumerated. 
///   The IfcPipeSegmentTypeEnum contains the following:
/// 
/// CULVERT: A covered channel or large pipe that forms a watercourse below ground level, usually under a road or railway.
///   RIGIDSEGMENT: A rigid segment is continuous linear segment of pipe that cannot be deformed.
///   FLEXIBLESEGMENT:  A flexible segment is a continuous non-linear segment of pipe that can be deformed and change the direction of flow.
///   GUTTER: A gutter segment is a continuous open-channel segment of pipe.
///   SPOOL: A type of rigid segment that is typically shorter and used for providing connectivity within a piping network.
///   USERDEFINED: User-defined segment.
///   NOTDEFINED:  Undefined segment.
/// 
/// HISTORY: New enumeration in IFC 2x2
public:
    typedef enum {IfcPipeSegmentType_CULVERT, IfcPipeSegmentType_FLEXIBLESEGMENT, IfcPipeSegmentType_RIGIDSEGMENT, IfcPipeSegmentType_GUTTER, IfcPipeSegmentType_SPOOL, IfcPipeSegmentType_USERDEFINED, IfcPipeSegmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPipeSegmentTypeEnum (IfcEntityInstanceData&& e);
    IfcPipeSegmentTypeEnum (Value v);
    IfcPipeSegmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPlateTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration
/// defines the different types of planar elements an IfcPlateType
/// object can fulfill:
/// 
/// CURTAIN_PANEL: A planar element within a
/// curtain wall, often consisting of a frame with fixed glazing.
///   SHEET: A planar, flat and thin element,
/// comes usually as metal sheet, and is often used as an additonal part
/// within an assembly.
///   USERDEFINED: User-defined linear element.
///   NOTDEFINED: Undefined linear element
/// 
/// HISTORY  New Enumeration in Release IFC2x Edition 2. 
/// IFC2x
/// Edition 3
/// CHANGE  The additional identifiers CURTAIN_PANEL, SHEET have
/// been
/// added.
public:
    typedef enum {IfcPlateType_CURTAIN_PANEL, IfcPlateType_SHEET, IfcPlateType_FLANGE_PLATE, IfcPlateType_WEB_PLATE, IfcPlateType_STIFFENER_PLATE, IfcPlateType_GUSSET_PLATE, IfcPlateType_COVER_PLATE, IfcPlateType_SPLICE_PLATE, IfcPlateType_BASE_PLATE, IfcPlateType_USERDEFINED, IfcPlateType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPlateTypeEnum (IfcEntityInstanceData&& e);
    IfcPlateTypeEnum (Value v);
    IfcPlateTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPreferredSurfaceCurveRepresentation : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcPreferredSurfaceCurveRepresentation_CURVE3D, IfcPreferredSurfaceCurveRepresentation_PCURVE_S1, IfcPreferredSurfaceCurveRepresentation_PCURVE_S2} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPreferredSurfaceCurveRepresentation (IfcEntityInstanceData&& e);
    IfcPreferredSurfaceCurveRepresentation (Value v);
    IfcPreferredSurfaceCurveRepresentation (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProcedureTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcProcedureTypeEnum defines the range of different types of procedure that can be specified.
/// 
/// HISTORY: New type in IFC2x2
/// 
/// Enumeration:
/// 
/// ADVICE_CAUTION: A caution that should be taken note of as a procedure or when carrying out a procedure
/// ADVICE_NOTE: Additional information or advice that should be taken note of as a procedure or when carrying out a procedure
/// ADVICE_WARNING: A warning of potential danger that should be taken note of as a procedure or when carrying out a procedure
/// CALIBRATION: A procedure undertaken to calibrate an artifact
/// SHUTDOWN: A procedure undertaken to shutdown the operation an artifact
/// STARTUP: A procedure undertaken to start up the operation an artifact
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcProcedureType_ADVICE_CAUTION, IfcProcedureType_ADVICE_NOTE, IfcProcedureType_ADVICE_WARNING, IfcProcedureType_CALIBRATION, IfcProcedureType_DIAGNOSTIC, IfcProcedureType_SHUTDOWN, IfcProcedureType_STARTUP, IfcProcedureType_USERDEFINED, IfcProcedureType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProcedureTypeEnum (IfcEntityInstanceData&& e);
    IfcProcedureTypeEnum (Value v);
    IfcProcedureTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProfileTypeEnum : public IfcUtil::IfcBaseType {
/// The enumeration defines whether the definition of a profile shape shall be geometrically resolved into a curve or into a surface.
/// 
/// HISTORY: New type in IFC 1.5.
/// 
/// Enumeration values:
/// 
/// CURVE: The resulting geometric item is of type curve and closed (with the only exception of the curve created by the IfcArbitraryOpenProfileDef which resolves into an open curve). The resulting geometry after applying a sweeping operation is a swept surface. This can be used to define shapes with thin sheets, such as ducts, where the thickness is not appropriate for geometric representation.
/// AREA: The resulting geometric item is of type surface. The resulting geometry after applying a sweeping operation is a swept solid with defined volume.
public:
    typedef enum {IfcProfileType_CURVE, IfcProfileType_AREA} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProfileTypeEnum (IfcEntityInstanceData&& e);
    IfcProfileTypeEnum (Value v);
    IfcProfileTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProjectOrderTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcProjectOrderTypeEnum is a list of the types of project order that may be identified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// CHANGEORDER: An instruction to make a change to a product or work being undertaken and a description of the work that is to be performed. 
/// MAINTENANCEWORKORDER: An instruction to carry out maintenance work and a description of the work that is to be performed. 
/// MOVEORDER: An instruction to move persons and artefacts and a description of the move locations, objects to be moved, etc.  
/// PURCHASEORDER: An instruction to purchase goods and/or services and a description of the goods and/or services to be purchased that is to be performed. 
/// WORKORDER: A general instruction to carry out work and a description of the work to be done. Note the difference between a work order generally and a maintenance work order. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcProjectOrderType_CHANGEORDER, IfcProjectOrderType_MAINTENANCEWORKORDER, IfcProjectOrderType_MOVEORDER, IfcProjectOrderType_PURCHASEORDER, IfcProjectOrderType_WORKORDER, IfcProjectOrderType_USERDEFINED, IfcProjectOrderType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProjectOrderTypeEnum (IfcEntityInstanceData&& e);
    IfcProjectOrderTypeEnum (Value v);
    IfcProjectOrderTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProjectedOrTrueLengthEnum : public IfcUtil::IfcBaseType {
/// This enumeration type is needed for load definition and is only considered if the load values are given as global actions and if they define linear or planar loads (that is, one- or two-dimensionally distributed loads).
/// Figure 234 illustrates the interpretation of a load definition depending on the enumeration types IfcGlobalOrLocalEnum and IfcProjectedOrTrueLengthEnum.
/// 
/// HISTORY  New type in IFC2x2. 
/// 
/// Figure 234 — Projected or true length
public:
    typedef enum {IfcProjectedOrTrueLength_PROJECTED_LENGTH, IfcProjectedOrTrueLength_TRUE_LENGTH} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProjectedOrTrueLengthEnum (IfcEntityInstanceData&& e);
    IfcProjectedOrTrueLengthEnum (Value v);
    IfcProjectedOrTrueLengthEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProjectionElementTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: An enumeration defining the basic
/// types for projection elements.
/// 
/// HISTORY New enumeration type in
/// IFC2x4.
/// 
/// Enumeration
/// 
/// USERDEFINED: User-defined projection
/// element
/// NOTDEFINED: Undefined projection
/// element
public:
    typedef enum {IfcProjectionElementType_BLISTER, IfcProjectionElementType_DEVIATOR, IfcProjectionElementType_USERDEFINED, IfcProjectionElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProjectionElementTypeEnum (IfcEntityInstanceData&& e);
    IfcProjectionElementTypeEnum (Value v);
    IfcProjectionElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPropertySetTemplateTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the general
/// applicability of instances of IfcPropertySet, or
/// IfcElementQuantity defined by this
/// IfcPropertySetTemplate, to subtypes of
/// IfcObjectDefinition.
/// 
/// HISTORY New enumeration in IFC2x4.
/// 
/// Enumeration
/// 
/// PSET_TYPEDRIVENONLY: the property sets
/// defined by this IfcPropertySetTemplate can only be assigned
/// to subtypes of IfcTypeObject.
/// PSET_TYPEDRIVENOVERRIDE: the property
/// sets defined by this IfcPropertySetTemplate can be assigned
/// to subtypes of IfcTypeObject and can be overridden by a
/// property set with same name at subtypes of IfcObject.
/// PSET_OCCURRENCEDRIVEN: the property sets
/// defined by this IfcPropertySetTemplate can only be assigned
/// to subtypes of IfcObject.
/// PSET_PERFORMANCEDRIVEN: the property sets
/// defined by this IfcPropertySetTemplate can only be assigned
/// to IfcPerformanceHistory,
/// QTO_TYPEDRIVENONLY: the element quantity
/// defined by this IfcPropertySetTemplate can only be assigned
/// to subtypes of IfcTypeObject.
/// QTO_TYPEDRIVENOVERRIDE: the element
/// quantity defined by this IfcPropertySetTemplate can be
/// assigned to subtypes of IfcTypeObject and can be overridden
/// by an element quantity with same name at subtypes of
/// IfcObject.
/// QTO_OCCURRENCEDRIVEN: the element
/// quantity defined by this IfcPropertySetTemplate can only be
/// assigned to subtypes of IfcObject.
/// NOTDEFINED: No
/// restriction provided, the property sets defined by this
/// IfcPropertySetTemplate can be assigned to any entity, if not
/// otherwise restricted by the ApplicableEntity attribute.
public:
    typedef enum {IfcPropertySetTemplateType_PSET_TYPEDRIVENONLY, IfcPropertySetTemplateType_PSET_TYPEDRIVENOVERRIDE, IfcPropertySetTemplateType_PSET_OCCURRENCEDRIVEN, IfcPropertySetTemplateType_PSET_PERFORMANCEDRIVEN, IfcPropertySetTemplateType_QTO_TYPEDRIVENONLY, IfcPropertySetTemplateType_QTO_TYPEDRIVENOVERRIDE, IfcPropertySetTemplateType_QTO_OCCURRENCEDRIVEN, IfcPropertySetTemplateType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPropertySetTemplateTypeEnum (IfcEntityInstanceData&& e);
    IfcPropertySetTemplateTypeEnum (Value v);
    IfcPropertySetTemplateTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProtectiveDeviceTrippingUnitTypeEnum : public IfcUtil::IfcBaseType {
/// Defines the range of different tripping unit types that can be used in conjunction with a protective device. 
/// HISTORY: New enumeration in IFC2x4 
/// 
/// ELECTRONIC: A tripping unit activated by electronic action. 
/// ELECTROMAGNETIC: A tripping unit activated by electromagnetic action. 
/// RESIDUALCURRENT: A tripping unit activated by residual current detection. 
/// THERMAL: A tripping unit activated by thermal action.
public:
    typedef enum {IfcProtectiveDeviceTrippingUnitType_ELECTRONIC, IfcProtectiveDeviceTrippingUnitType_ELECTROMAGNETIC, IfcProtectiveDeviceTrippingUnitType_RESIDUALCURRENT, IfcProtectiveDeviceTrippingUnitType_THERMAL, IfcProtectiveDeviceTrippingUnitType_USERDEFINED, IfcProtectiveDeviceTrippingUnitType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProtectiveDeviceTrippingUnitTypeEnum (IfcEntityInstanceData&& e);
    IfcProtectiveDeviceTrippingUnitTypeEnum (Value v);
    IfcProtectiveDeviceTrippingUnitTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcProtectiveDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcProtectiveDeviceTypeEnum specifically defines the range of different breaker unit types that can be used in conjunction with protective device. Types may also be used as a reference to a complete protective device in circumstances where tripping units are not separately identified (typically expected to be the case during earlier stages of design). 
/// 
/// HISTORY: New type in IFC 2x2. Modified definition and usage in IFC 2x4 
/// 
/// Enumeration
/// 
/// FUSEDISCONNECTOR: A device that will electrically open the circuit after a period of prolonged, abnormal current flow.
/// CIRCUITBREAKER: A mechanical switching device capable of making, carrying, and breaking currents under normal circuit conditions and also making, carrying for a specified time and breaking, current under specified abnormal circuit conditions such as those of short circuit.
/// EARTHINGSWITCH: A safety device used to open or close a circuit when there is no current. Used to isolate a part of a circuit, a machine, a part of an overhead line or an underground line so that maintenance can be safely conducted.
/// EARTHLEAKAGECIRCUITBREAKER: A device that opens, closes, or isolates a circuit and has short circuit protection but no overload protection.  It attempts to break the circuit when there is a leakage of current from phase to earth, by measuring voltage on the earth conductor.
/// RESIDUALCURRENTCIRCUITBREAKER: A device that opens, closes, or isolates a circuit and has short circuit and overload protection.  It attempts to break the circuit when there is a difference in current between any two phases.  May also be referred to as 'Ground Fault Interupter (GFI)' or 'Ground Fault Circuit Interuptor (GFCI)'
/// RESIDUALCURRENTSWITCH: A device that opens, closes or isolates a circuit and has no short circuit or overload protection.  May also be identified as a 'ground fault switch'.
/// VARISTOR: A high voltage surge protection device.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcProtectiveDeviceType_CIRCUITBREAKER, IfcProtectiveDeviceType_EARTHLEAKAGECIRCUITBREAKER, IfcProtectiveDeviceType_EARTHINGSWITCH, IfcProtectiveDeviceType_FUSEDISCONNECTOR, IfcProtectiveDeviceType_RESIDUALCURRENTCIRCUITBREAKER, IfcProtectiveDeviceType_RESIDUALCURRENTSWITCH, IfcProtectiveDeviceType_VARISTOR, IfcProtectiveDeviceType_ANTI_ARCING_DEVICE, IfcProtectiveDeviceType_SPARKGAP, IfcProtectiveDeviceType_VOLTAGELIMITER, IfcProtectiveDeviceType_USERDEFINED, IfcProtectiveDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcProtectiveDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcProtectiveDeviceTypeEnum (Value v);
    IfcProtectiveDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcPumpTypeEnum : public IfcUtil::IfcBaseType {
/// Defines general types of pumps.
/// 
/// The IfcPumpTypeEnum contains the following:
/// 
/// CIRCULATOR: A Circulator pump is a generic low-pressure, low-capacity pump. It may have a wet rotor and
///   may be driven by a flexible-coupled motor.
/// 
/// ENDSUCTION: An End Suction pump, when mounted horizontally, has a single horizontal inlet on the impeller suction side
///   and a vertical discharge. It may have a direct or close-coupled motor.
/// 
/// SPLITCASE: A Split Case pump, when mounted horizontally, has an inlet and outlet on each side of the impeller.
///   The impeller can be easily accessed by removing the front of the impeller casing. It may have a direct or close-coupled motor.
/// 
/// SUBMERSIBLEPUMP: A pump designed to be immersed in a fluid, typically a collection tank.
/// 
/// SUMPPUMP: A pump designed to sit above a collection tank with a suction inlet extending into the tank.
/// 
/// VERTICALINLINE: A Vertical Inline pump has the pump and motor close-coupled on the pump casing.
///   The pump depends on the connected, horizontal piping for support, with the suction and discharge along the piping axis.
/// 
/// VERTICALTURBINE: A Vertical Turbine pump has a motor mounted vertically on the pump casing for either
///   wet-pit sump mounting or dry-well mounting.
/// 
/// USERDEFINED: User-defined pump type.
/// 
/// NOTDEFINED:  Pump type has not been defined.
/// 
/// HISTORY: New enumeration in IFC R2x.  SUBMERSIBLEPUMP and SUMPPUMP added in IFC2x4.
public:
    typedef enum {IfcPumpType_CIRCULATOR, IfcPumpType_ENDSUCTION, IfcPumpType_SPLITCASE, IfcPumpType_SUBMERSIBLEPUMP, IfcPumpType_SUMPPUMP, IfcPumpType_VERTICALINLINE, IfcPumpType_VERTICALTURBINE, IfcPumpType_USERDEFINED, IfcPumpType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcPumpTypeEnum (IfcEntityInstanceData&& e);
    IfcPumpTypeEnum (Value v);
    IfcPumpTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRailTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcRailType_RACKRAIL, IfcRailType_BLADE, IfcRailType_GUARDRAIL, IfcRailType_STOCKRAIL, IfcRailType_CHECKRAIL, IfcRailType_RAIL, IfcRailType_USERDEFINED, IfcRailType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRailTypeEnum (IfcEntityInstanceData&& e);
    IfcRailTypeEnum (Value v);
    IfcRailTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRailingTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the valid types of
///   railings that can be predefined using the enumeration values.  
///   HISTORY: New Enumeration in IFC
///   Release 2.0  
///   Enumeration 
/// 
/// HANDRAIL: A type of railing designed to serve as an optional
///   structural support for loads applied by human occupants (at hand height).
///   Generally located adjacent to ramps and stairs. Generally floor or wall
///   mounted. 
///   GUARDRAIL: A type of railing designed to guard human occupants
///   from falling off a stair, ramp or landing where there is a vertical drop at the
///   edge of such floors/landings. 
///   BALUSTRADE: Similar to the definitions of a guardrail except
///   the location is at the edge of a floor, rather then a stair or ramp. Examples
///   are balustrates at roof-tops or balconies. 
///   USERDEFINED: User-defined railing element, a term to identify
///   the user type is given by the attribute IfcRailing.ObjectType. 
///   NOTDEFINED: Undefined railing element, no type information
///   available.
public:
    typedef enum {IfcRailingType_HANDRAIL, IfcRailingType_GUARDRAIL, IfcRailingType_BALUSTRADE, IfcRailingType_FENCE, IfcRailingType_USERDEFINED, IfcRailingType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRailingTypeEnum (IfcEntityInstanceData&& e);
    IfcRailingTypeEnum (Value v);
    IfcRailingTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRailwayPartTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcRailwayPartType_TRACKSTRUCTURE, IfcRailwayPartType_TRACKSTRUCTUREPART, IfcRailwayPartType_LINESIDESTRUCTUREPART, IfcRailwayPartType_DILATATIONSUPERSTRUCTURE, IfcRailwayPartType_PLAINTRACKSUPESTRUCTURE, IfcRailwayPartType_LINESIDESTRUCTURE, IfcRailwayPartType_SUPERSTRUCTURE, IfcRailwayPartType_TURNOUTSUPERSTRUCTURE, IfcRailwayPartType_USERDEFINED, IfcRailwayPartType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRailwayPartTypeEnum (IfcEntityInstanceData&& e);
    IfcRailwayPartTypeEnum (Value v);
    IfcRailwayPartTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRampFlightTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the different types
///   of linear elements an IfcRampFlightType object can fulfill: 
/// 
/// STRAIGHT: A ramp flight with a straight walking line.  
///   SPIRAL: A ramp flight with a circular or elliptic walking
///   line. 
///   USERDEFINED: User-defined ramp flight. 
///   NOTDEFINED: Undefined ramp flight. 
/// 
/// HISTORY: New Enumeration in
///   Release IFC2x Edition 2.
public:
    typedef enum {IfcRampFlightType_STRAIGHT, IfcRampFlightType_SPIRAL, IfcRampFlightType_USERDEFINED, IfcRampFlightType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRampFlightTypeEnum (IfcEntityInstanceData&& e);
    IfcRampFlightTypeEnum (Value v);
    IfcRampFlightTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRampTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic configuration of the ramp type in terms of the number and shape of ramp flights, as shown in Figure 67. The type also distinguished turns by landings. In addition the subdivision of the straight and changing direction ramps is included. The ramp configurations are given for ramps without and with one and two landings. 
/// 
/// Ramps which are subdivided into more than two landings have to be defined by the geometry only. Also ramps with non-regular shapes have to be defined by the geometry only. The type of such ramps is USERDEFINED. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// StraightRunRamp 
///   A ramp - which is a sloping
///   floor, walk, or roadway - connecting two levels. The straight ramp consists of
///   one straight flight without turns or winders.  
/// 
/// TwoStraightRunRamp 
///   A straight ramp consisting of
///   two straight flights without turns but with one landing. 
/// 
/// QuarterTurnRamp 
///   A ramp making a 90° turn,
///   consisting of two straight flights connected by a quarterspace landing. The
///   direction of the turn is determined by the walking line. 
/// 
/// TwoQuarterTurnRamp 
///   A ramp making a 180°
///   turn, consisting of three straight flights connected by two quarterspace
///   landings. The direction of the turn is determined by the walking line. 
/// 
/// HalfTurnRamp 
///   A ramp making a 180°
///   turn, consisting of two straight flights connected by a halfspace landing. The
///   orientation of the turn is determined by the walking line. 
/// 
/// SpiralRamp 
///   A ramp constructed around a
///   circular or elliptical well without newels and landings. 
/// 
/// UserDefined 
///   Free form ramp (user defined
///   operation type) 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 67 — Ramp types
public:
    typedef enum {IfcRampType_STRAIGHT_RUN_RAMP, IfcRampType_TWO_STRAIGHT_RUN_RAMP, IfcRampType_QUARTER_TURN_RAMP, IfcRampType_TWO_QUARTER_TURN_RAMP, IfcRampType_HALF_TURN_RAMP, IfcRampType_SPIRAL_RAMP, IfcRampType_USERDEFINED, IfcRampType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRampTypeEnum (IfcEntityInstanceData&& e);
    IfcRampTypeEnum (Value v);
    IfcRampTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRecurrenceTypeEnum : public IfcUtil::IfcBaseType {
/// IfcRecurrenceTypeEnum enumerates the recurring pattern type. The following
///   combinations are valid:
/// 
/// DAILY: Interval, Occurrences
/// 
/// WEEKLY: WeekdayComponent, Interval, Occurrences
/// 
/// MONTHLY_BY_DAY_OF_MONTH: DayComponent, Interval, Occurrences
/// 
/// MONTHLY_BY_POSITION: WeekdayComponent, Position, Interval, Occurrences
/// 
/// BY_DAY_COUNT: Interval, Occurrences
/// 
/// BY_WEEKDAY_COUNT: WeekdayComponent, Interval, Occurrences
/// 
/// YEARLY_BY_DAY_OF_MONTH: DayComponent, MonthComponent, Interval, Occurrences
/// 
/// YEARLY_BY_POSITION: WeekdayComponent, MonthComponent, Position, Interval, Occurrences
/// 
/// HISTORY: New enumeration in IFC
///   Release 2x4.
public:
    typedef enum {IfcRecurrenceType_DAILY, IfcRecurrenceType_WEEKLY, IfcRecurrenceType_MONTHLY_BY_DAY_OF_MONTH, IfcRecurrenceType_MONTHLY_BY_POSITION, IfcRecurrenceType_BY_DAY_COUNT, IfcRecurrenceType_BY_WEEKDAY_COUNT, IfcRecurrenceType_YEARLY_BY_DAY_OF_MONTH, IfcRecurrenceType_YEARLY_BY_POSITION} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRecurrenceTypeEnum (IfcEntityInstanceData&& e);
    IfcRecurrenceTypeEnum (Value v);
    IfcRecurrenceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReferentTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcReferentType_KILOPOINT, IfcReferentType_MILEPOINT, IfcReferentType_STATION, IfcReferentType_REFERENCEMARKER, IfcReferentType_USERDEFINED, IfcReferentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReferentTypeEnum (IfcEntityInstanceData&& e);
    IfcReferentTypeEnum (Value v);
    IfcReferentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReflectanceMethodEnum : public IfcUtil::IfcBaseType {
/// The IfcReflectanceMethodEnum defines the range of different reflectance methods available. 
/// 
/// HISTORY: New type in IFC 2x2.
/// 
/// Enumeration 
/// 
/// BLINN: A reflectance model providing a smooth, slightly shiny appearance.
/// FLAT: A reflectance model providing a constant colour. This model ignores the effect of all light sources. 
/// GLASS: A reflectance model that supports an approximation of glass-like materials that have both reflective and transmissive properties. 
/// MATT: A reflectance model providing a dull matte appearance. 
/// METAL: A reflectance model providing a specular metallic appearance. 
/// MIRROR: A reflectance model that supports secondary mirrored views through ray tracing. 
/// PHONG: A reflectance model conforming with the Phong model in which reflections are greatest in the `mirror' direction of a surface opposite the viewing direction with respect to the surface normal. 
/// PLASTIC: A reflectance model providing a specular effect which is similar to the Phong model. 
/// STRAUSS: A reflectance model for metallic and non-metallic appearance based on a limited set of control parameter.
/// NOTDEFINED
public:
    typedef enum {IfcReflectanceMethod_BLINN, IfcReflectanceMethod_FLAT, IfcReflectanceMethod_GLASS, IfcReflectanceMethod_MATT, IfcReflectanceMethod_METAL, IfcReflectanceMethod_MIRROR, IfcReflectanceMethod_PHONG, IfcReflectanceMethod_PLASTIC, IfcReflectanceMethod_STRAUSS, IfcReflectanceMethod_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReflectanceMethodEnum (IfcEntityInstanceData&& e);
    IfcReflectanceMethodEnum (Value v);
    IfcReflectanceMethodEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReinforcedSoilTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcReinforcedSoilType_SURCHARGEPRELOADED, IfcReinforcedSoilType_VERTICALLYDRAINED, IfcReinforcedSoilType_DYNAMICALLYCOMPACTED, IfcReinforcedSoilType_REPLACED, IfcReinforcedSoilType_ROLLERCOMPACTED, IfcReinforcedSoilType_GROUTED, IfcReinforcedSoilType_USERDEFINED, IfcReinforcedSoilType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReinforcedSoilTypeEnum (IfcEntityInstanceData&& e);
    IfcReinforcedSoilTypeEnum (Value v);
    IfcReinforcedSoilTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReinforcingBarRoleEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining standard types for the
///   role, purpose or usage of the bar, i.e. the kind of loads and stresses they are
///   intended to carry.  
/// 
/// HISTORY New type in IFC Release 2x2.
///   Item ANCHORING (documented since IFC 2x2) added to the EXPRESS definition in IFC 2x4.
/// 
/// ENUMERATION 
/// 
/// MAIN The reinforcing bar is a main bar. 
///   SHEAR The reinforcing bar is a shear bar. 
///   LIGATURE The reinforcing bar is a ligature (link, stirrup). 
///   STUD The reinforcing bar is a stud. 
///   PUNCHING Punching reinforcement. 
///   EDGE Edge reinforcement. 
///   RING Ring reinforcement. 
///   ANCHORING Anchoring reinforcement. 
///   USERDEFINED The type of reinforcement is user defined. 
///   NOTDEFINED The type of reinforcement is not defined.
public:
    typedef enum {IfcReinforcingBarRole_MAIN, IfcReinforcingBarRole_SHEAR, IfcReinforcingBarRole_LIGATURE, IfcReinforcingBarRole_STUD, IfcReinforcingBarRole_PUNCHING, IfcReinforcingBarRole_EDGE, IfcReinforcingBarRole_RING, IfcReinforcingBarRole_ANCHORING, IfcReinforcingBarRole_USERDEFINED, IfcReinforcingBarRole_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReinforcingBarRoleEnum (IfcEntityInstanceData&& e);
    IfcReinforcingBarRoleEnum (Value v);
    IfcReinforcingBarRoleEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReinforcingBarSurfaceEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration indicating whether the bar has a
///   plain or textured (ribbed) surface.  
/// 
/// HISTORY New type in IFC Release 2x2
/// 
/// ENUMERATION 
/// 
/// PLAIN The reinforcing bar surface is plain. 
///   TEXTURED The reinforcing bar surface is textured (ribbed).
public:
    typedef enum {IfcReinforcingBarSurface_PLAIN, IfcReinforcingBarSurface_TEXTURED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReinforcingBarSurfaceEnum (IfcEntityInstanceData&& e);
    IfcReinforcingBarSurfaceEnum (Value v);
    IfcReinforcingBarSurfaceEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReinforcingBarTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcReinforcingBarType_ANCHORING, IfcReinforcingBarType_EDGE, IfcReinforcingBarType_LIGATURE, IfcReinforcingBarType_MAIN, IfcReinforcingBarType_PUNCHING, IfcReinforcingBarType_RING, IfcReinforcingBarType_SHEAR, IfcReinforcingBarType_STUD, IfcReinforcingBarType_SPACEBAR, IfcReinforcingBarType_USERDEFINED, IfcReinforcingBarType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReinforcingBarTypeEnum (IfcEntityInstanceData&& e);
    IfcReinforcingBarTypeEnum (Value v);
    IfcReinforcingBarTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcReinforcingMeshTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcReinforcingMeshType_USERDEFINED, IfcReinforcingMeshType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcReinforcingMeshTypeEnum (IfcEntityInstanceData&& e);
    IfcReinforcingMeshTypeEnum (Value v);
    IfcReinforcingMeshTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRoadPartTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcRoadPartType_ROADSIDEPART, IfcRoadPartType_BUS_STOP, IfcRoadPartType_HARDSHOULDER, IfcRoadPartType_INTERSECTION, IfcRoadPartType_PASSINGBAY, IfcRoadPartType_ROADWAYPLATEAU, IfcRoadPartType_ROADSIDE, IfcRoadPartType_REFUGEISLAND, IfcRoadPartType_TOLLPLAZA, IfcRoadPartType_CENTRALRESERVE, IfcRoadPartType_SIDEWALK, IfcRoadPartType_PARKINGBAY, IfcRoadPartType_RAILWAYCROSSING, IfcRoadPartType_PEDESTRIAN_CROSSING, IfcRoadPartType_SOFTSHOULDER, IfcRoadPartType_BICYCLECROSSING, IfcRoadPartType_CENTRALISLAND, IfcRoadPartType_SHOULDER, IfcRoadPartType_TRAFFICLANE, IfcRoadPartType_ROADSEGMENT, IfcRoadPartType_ROUNDABOUT, IfcRoadPartType_LAYBY, IfcRoadPartType_CARRIAGEWAY, IfcRoadPartType_TRAFFICISLAND, IfcRoadPartType_USERDEFINED, IfcRoadPartType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRoadPartTypeEnum (IfcEntityInstanceData&& e);
    IfcRoadPartTypeEnum (Value v);
    IfcRoadPartTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRoleEnum : public IfcUtil::IfcBaseType {
/// Definition: Roles which may be played by an actor.
/// 
/// HISTORY This type has changes after IFC Release 2.0.  Spelling of COMMISSIONINGENGINEER fixed in IFC 2x4.
/// 
/// ENUMERATION 
/// 
/// SUPPLIER
///   MANUFACTURER
///   CONTRACTOR 
///   SUBCONTRACTOR
///   ARCHITECT
///   STRUCTURALENGINEER
///   COSTENGINEER 
///   CLIENT
///   BUILDINGOWNER
///   BUILDINGOPERATOR
///   MECHANICALENGINEER 
///   ELECTRICALENGINEER
///   PROJECTMANAGER
///   FACILITIESMANAGER
///   CIVILENGINEER
///   COMMISSIONINGENGINEER 
///   ENGINEER
///   OWNER
///   CONSULTANT
///   CONSTRUCTIONMANAGER
///   FIELDCONSTRUCTIONMANAGER 
///   RESELLER
///   USERDEFINED User defined value to be provided.
public:
    typedef enum {IfcRole_SUPPLIER, IfcRole_MANUFACTURER, IfcRole_CONTRACTOR, IfcRole_SUBCONTRACTOR, IfcRole_ARCHITECT, IfcRole_STRUCTURALENGINEER, IfcRole_COSTENGINEER, IfcRole_CLIENT, IfcRole_BUILDINGOWNER, IfcRole_BUILDINGOPERATOR, IfcRole_MECHANICALENGINEER, IfcRole_ELECTRICALENGINEER, IfcRole_PROJECTMANAGER, IfcRole_FACILITIESMANAGER, IfcRole_CIVILENGINEER, IfcRole_COMMISSIONINGENGINEER, IfcRole_ENGINEER, IfcRole_OWNER, IfcRole_CONSULTANT, IfcRole_CONSTRUCTIONMANAGER, IfcRole_FIELDCONSTRUCTIONMANAGER, IfcRole_RESELLER, IfcRole_USERDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRoleEnum (IfcEntityInstanceData&& e);
    IfcRoleEnum (Value v);
    IfcRoleEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcRoofTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic configuration of the roof in terms of the different roof shapes, as illustrated in Figure 68.
/// 
/// Roofs which are subdivided into more than these basic shapes have to be defined by the geometry only. Also roofs with non-regular shapes (free form roof) have to be defined by the geometry only. The type of such roofs is FREEFORM. 
/// 
/// HISTORY New Enumeration in IFC Release 2x. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// FLAT_ROOF 
///   A roof having no slope, or
///   one with only a slight pitch so as to drain rainwater. 
/// 
/// SHED_ROOF 
///   A roof having a single
///   slope. 
/// 
/// GABLE_ROOF 
///   A roof sloping downward in
///   two parts from a central ridge, so as to form a gable at each end. 
/// 
/// HIP_ROOF 
///   A roof having sloping ends
///   and sides meeting at an inclined projecting angle. 
/// 
/// HIPPED_GABLE_ROOF 
///   A roof having a hipped end
///   truncating a gable. 
/// 
/// GAMBREL_ROOF 
///   A ridged roof divided on each
///   side into a shallower slope above a steeper one. 
/// 
/// MANSARD_ROOF 
///   A roof having on each side a
///   steeper lower part and a shallower upper part. 
/// 
/// BARREL_ROOF 
///   A roof or ceiling having a
///   semicylindrical form. 
/// 
/// RAINBOW_ROOF 
///   A gable roof in the form of a
///   broad Gothic arch, with gently sloping convex surfaces. 
/// 
/// BUTTERFLY_ROOF 
///   A roof having two slopes,
///   each descending inward from the eaves. 
/// 
/// PAVILION_ROOF 
///   A pyramidal hip roof. 
/// 
/// DOME_ROOF 
///   A hemispherical hip
///   roof. 
/// 
/// FREEFORM 
///   Free form roof  
///     
/// 
/// NOTDEFINED 
///   No specification given 
///     
/// 
/// Figure 68 — Roof types
public:
    typedef enum {IfcRoofType_FLAT_ROOF, IfcRoofType_SHED_ROOF, IfcRoofType_GABLE_ROOF, IfcRoofType_HIP_ROOF, IfcRoofType_HIPPED_GABLE_ROOF, IfcRoofType_GAMBREL_ROOF, IfcRoofType_MANSARD_ROOF, IfcRoofType_BARREL_ROOF, IfcRoofType_RAINBOW_ROOF, IfcRoofType_BUTTERFLY_ROOF, IfcRoofType_PAVILION_ROOF, IfcRoofType_DOME_ROOF, IfcRoofType_FREEFORM, IfcRoofType_USERDEFINED, IfcRoofType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcRoofTypeEnum (IfcEntityInstanceData&& e);
    IfcRoofTypeEnum (Value v);
    IfcRoofTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSIPrefix : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-41:1992: An SI prefix is the name of a prefix that may be associated 
/// with an SI unit. The definitions of SI prefixes are specified in ISO 1000 (clause 3).
/// 
/// NOTE The prefix defines multiples and submultiples of the SI units.
/// 
/// NOTE Corresponding ISO 10303 name: SI_prefix, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// ENUMERATION 
/// 
/// EXA: 10^18. 
///   PETA: 10^15. 
///   TERA: 10^12. 
///   GIGA: 10^9. 
///   MEGA: 10^6. 
///   KILO: 10^3. 
///   HECTO: 10^2.  
///   DECA: 10. 
///   DECI: 10^-1. 
///   CENTI: 10^-2. 
///   MILLI: 10^-3. 
///   MICRO: 10^-6. 
///   NANO: 10^-9. 
///   PICO: 10^-12. 
///   FEMTO: 10^-15. 
///   ATTO: 10^-18. 
/// 
/// HISTORY New entity in IFC Release 1.5.1.
public:
    typedef enum {IfcSIPrefix_EXA, IfcSIPrefix_PETA, IfcSIPrefix_TERA, IfcSIPrefix_GIGA, IfcSIPrefix_MEGA, IfcSIPrefix_KILO, IfcSIPrefix_HECTO, IfcSIPrefix_DECA, IfcSIPrefix_DECI, IfcSIPrefix_CENTI, IfcSIPrefix_MILLI, IfcSIPrefix_MICRO, IfcSIPrefix_NANO, IfcSIPrefix_PICO, IfcSIPrefix_FEMTO, IfcSIPrefix_ATTO} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSIPrefix (IfcEntityInstanceData&& e);
    IfcSIPrefix (Value v);
    IfcSIPrefix (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSIUnitName : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-41:1992: An SI unit name is the name of an SI unit. The definitions of the 
/// names of SI units are specified in ISO 1000 (clause 2).
/// 
/// NOTE Corresponding STEP name: SI_unit_name, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// ENUMERATION 
/// 
/// AMPERE: Unit for electric current. 
///   BECQUEREL: Unit for radioactivity. 
///   CANDELA: Unit for luminousintensity. 
///   COULOMB: Unit for electric charge. 
///   CUBIC_METRE: Unit for volume. 
///   DEGREE_CELSIUS: Unit for thermodynamic temperature. 
///   FARAD: Unit for electric capacitance. 
///   GRAM: Unit for mass. 
///   GRAY: Unit for absorbed radioactive dose. 
///   HENRY: Unit for inductance. 
///   HERTZ: Unit for frequency. 
///   JOULE: Unit for energy. 
///   KELVIN: Unit for thermodynamic temperature. 
///   LUMEN: Unit for luminous flux. 
///   LUX: Unit for illuminance. 
///   METRE: Unit for length. 
///   MOLE: Unit for amount of substance. 
///   NEWTON: Unit for force. 
///   OHM: Unit for electric resistance. 
///   PASCAL: Unit for pressure. 
///   RADIAN: Unit for plane angle. 
///   SECOND: Unit for time. 
///   SIEMENS: Unit for electric conductance. 
///   SIEVERT: Unit for radioactive dose equivalent. 
///   SQUARE_METRE: Unit for area. 
///   STERADIAN: Unit for solid angle. 
///   TESLA: Unit for magnetic flux density. 
///   VOLT: Unit for electric voltage. 
///   WATT: Unit for power. 
///   WEBER: Unit for magnetic flux. 
/// 
/// HISTORY New entity in IFC Release 1.5.1.
public:
    typedef enum {IfcSIUnitName_AMPERE, IfcSIUnitName_BECQUEREL, IfcSIUnitName_CANDELA, IfcSIUnitName_COULOMB, IfcSIUnitName_CUBIC_METRE, IfcSIUnitName_DEGREE_CELSIUS, IfcSIUnitName_FARAD, IfcSIUnitName_GRAM, IfcSIUnitName_GRAY, IfcSIUnitName_HENRY, IfcSIUnitName_HERTZ, IfcSIUnitName_JOULE, IfcSIUnitName_KELVIN, IfcSIUnitName_LUMEN, IfcSIUnitName_LUX, IfcSIUnitName_METRE, IfcSIUnitName_MOLE, IfcSIUnitName_NEWTON, IfcSIUnitName_OHM, IfcSIUnitName_PASCAL, IfcSIUnitName_RADIAN, IfcSIUnitName_SECOND, IfcSIUnitName_SIEMENS, IfcSIUnitName_SIEVERT, IfcSIUnitName_SQUARE_METRE, IfcSIUnitName_STERADIAN, IfcSIUnitName_TESLA, IfcSIUnitName_VOLT, IfcSIUnitName_WATT, IfcSIUnitName_WEBER} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSIUnitName (IfcEntityInstanceData&& e);
    IfcSIUnitName (Value v);
    IfcSIUnitName (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSanitaryTerminalTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcSanitaryTerminalTypeEnum defines the range of different types of sanitary terminal that can be specified. 
/// 
/// NOTE: The value WCSEAT has been deprecated and should no longer be used; toilet seats should be represented by IfcDiscreteAccessory with ObjectType 'WC Seat'. 
///   HISTORY: New type in IFC 2x2 
/// 
/// Enumeration 
/// 
/// BATH: Sanitary appliance for immersion of the human body or parts of it. 
/// BIDET: Waste water appliance for washing the excretory organs while sitting astride the bowl. 
/// CISTERN: A water storage unit attached to a sanitary terminal that is fitted with a device, operated automatically or by the user, that discharges water to cleanse a water closet (toilet) pan, urinal or slop hopper. 
/// SHOWER: Installation or waste water appliance that emits a spray of water to wash the human body. 
/// SINK: Waste water appliance for receiving, retaining or disposing of domestic, culinary, laboratory or industrial process liquids. 
/// SANITARYFOUNTAIN: A sanitary terminal that provides a low pressure jet of water for a specific purpose. 
/// TOILETPAN: Soil appliance for the disposal of excrement. 
/// URINAL: Soil appliance that receives urine and directs it to a waste outlet (BS6100). 
/// WASHHANDBASIN: Waste water appliance for washing the upper parts of the body. 
/// WCSEAT: [Deprecated] Hinged seat that fits on the top of a water closet (WC) pan. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcSanitaryTerminalType_BATH, IfcSanitaryTerminalType_BIDET, IfcSanitaryTerminalType_CISTERN, IfcSanitaryTerminalType_SHOWER, IfcSanitaryTerminalType_SINK, IfcSanitaryTerminalType_SANITARYFOUNTAIN, IfcSanitaryTerminalType_TOILETPAN, IfcSanitaryTerminalType_URINAL, IfcSanitaryTerminalType_WASHHANDBASIN, IfcSanitaryTerminalType_WCSEAT, IfcSanitaryTerminalType_USERDEFINED, IfcSanitaryTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSanitaryTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcSanitaryTerminalTypeEnum (Value v);
    IfcSanitaryTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSectionTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: An enumeration indicating whether a
///   specific piece of a cross section is uniform or tapered in longitudinal
///   direction.  
///   HISTORY New type in IFC
///   Release 2x2  
///   ENUMERATION 
/// 
/// UNIFORM The section is uniform in longitudinal direction.
/// 
/// TAPERED The section is tapered in longitudinal direction.
public:
    typedef enum {IfcSectionType_UNIFORM, IfcSectionType_TAPERED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSectionTypeEnum (IfcEntityInstanceData&& e);
    IfcSectionTypeEnum (Value v);
    IfcSectionTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSensorTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcSensorTypeEnum defines the range of different types of sensor that can be specified. 
/// 
/// HISTORY: New type in IFC R2.0.  Added missing enumerations in IFC2x4
/// 
/// Enumeration 
/// 
/// CONDUCTANCESENSOR: A device that senses or detects electrical conductance. 
/// CONTACTSENSOR: A device that senses or detects contact, such as for detecting if a door is closed. 
/// FIRESENSOR: A device that senses or detects fire. 
/// FLOWSENSOR: A device that senses or detects flow in a fluid. 
/// GASSENSOR: A device that senses or detects gas concentration. 
/// HEATSENSOR: A device that senses or detects heat. 
/// IONCONCENTRATIONSENSOR: A device that senses or detects ion concentration, such as for water hardness. 
/// LEVELSENSOR: A device that senses or detects fill level, such as for a tank. 
/// HUMIDITYSENSOR: A device that senses or detects humidity. 
/// LIGHTSENSOR: A device that senses or detects light. 
/// MOISTURESENSOR: A device that senses or detects moisture. 
/// MOVEMENTSENSOR: A device that senses or detects movement.  
/// PHSENSOR: A device that senses or detects acidity. 
/// PRESSURESENSOR: A device that senses or detects pressure. 
/// RADIATIONSENSOR: A device that senses or detects electromagnetic radiation. 
/// RADIOACTIVITYSENSOR: A device that senses or detects atomic decay. 
/// SMOKESENSOR: A device that senses or detects smoke. 
/// SOUNDSENSOR: A device that senses or detects sound.  
/// TEMPERATURESENSOR: A device that senses or detects temperature. 
/// WINDSENSOR: A device that senses or detects airflow speed and direction. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcSensorType_COSENSOR, IfcSensorType_CO2SENSOR, IfcSensorType_CONDUCTANCESENSOR, IfcSensorType_CONTACTSENSOR, IfcSensorType_FIRESENSOR, IfcSensorType_FLOWSENSOR, IfcSensorType_FROSTSENSOR, IfcSensorType_GASSENSOR, IfcSensorType_HEATSENSOR, IfcSensorType_HUMIDITYSENSOR, IfcSensorType_IDENTIFIERSENSOR, IfcSensorType_IONCONCENTRATIONSENSOR, IfcSensorType_LEVELSENSOR, IfcSensorType_LIGHTSENSOR, IfcSensorType_MOISTURESENSOR, IfcSensorType_MOVEMENTSENSOR, IfcSensorType_PHSENSOR, IfcSensorType_PRESSURESENSOR, IfcSensorType_RADIATIONSENSOR, IfcSensorType_RADIOACTIVITYSENSOR, IfcSensorType_SMOKESENSOR, IfcSensorType_SOUNDSENSOR, IfcSensorType_TEMPERATURESENSOR, IfcSensorType_WINDSENSOR, IfcSensorType_EARTHQUAKESENSOR, IfcSensorType_FOREIGNOBJECTDETECTIONSENSOR, IfcSensorType_OBSTACLESENSOR, IfcSensorType_RAINSENSOR, IfcSensorType_SNOWDEPTHSENSOR, IfcSensorType_TRAINSENSOR, IfcSensorType_TURNOUTCLOSURESENSOR, IfcSensorType_WHEELSENSOR, IfcSensorType_USERDEFINED, IfcSensorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSensorTypeEnum (IfcEntityInstanceData&& e);
    IfcSensorTypeEnum (Value v);
    IfcSensorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSequenceEnum : public IfcUtil::IfcBaseType {
/// IfcSequenceEnum is an
///   enumeration that defines the different ways in which a
///   time lag is applied to a sequence between two processes.
/// 
/// HISTORY  New entity in IFC 1.0
public:
    typedef enum {IfcSequence_START_START, IfcSequence_START_FINISH, IfcSequence_FINISH_START, IfcSequence_FINISH_FINISH, IfcSequence_USERDEFINED, IfcSequence_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSequenceEnum (IfcEntityInstanceData&& e);
    IfcSequenceEnum (Value v);
    IfcSequenceEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcShadingDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the valid
/// types of shading devices that can be predefined using the
/// enumeration values.
/// 
/// JALOUSIE
/// SHUTTER
/// AWNING
/// 
/// HISTORY New Enumeration
/// in ReleaseIFC2x4
public:
    typedef enum {IfcShadingDeviceType_JALOUSIE, IfcShadingDeviceType_SHUTTER, IfcShadingDeviceType_AWNING, IfcShadingDeviceType_USERDEFINED, IfcShadingDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcShadingDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcShadingDeviceTypeEnum (Value v);
    IfcShadingDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSignTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcSignType_MARKER, IfcSignType_PICTORAL, IfcSignType_MIRROR, IfcSignType_USERDEFINED, IfcSignType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSignTypeEnum (IfcEntityInstanceData&& e);
    IfcSignTypeEnum (Value v);
    IfcSignTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSignalTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcSignalType_VISUAL, IfcSignalType_AUDIO, IfcSignalType_MIXED, IfcSignalType_USERDEFINED, IfcSignalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSignalTypeEnum (IfcEntityInstanceData&& e);
    IfcSignalTypeEnum (Value v);
    IfcSignalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSimplePropertyTemplateTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the correct subtype of instances of IfcSimpleProperty or IfcPhysicalSimpleQuantity that are created and are assigned to this IfcSimplePropertyTemplate. It also determines how the attributes of IfcPropertyTemplate, PrimaryUnit, SecondaryUnit, PrimaryDataType, SecondaryDataType, should be used.
/// 
/// HISTORY New enumeration in IFC2x4.
/// 
/// Enumeration
/// 
/// P_SINGLEVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertySingleValue.
/// P_ENUMERATEDVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertyEnumeratedValue.
/// P_BOUNDEDVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertyBoundedValue.
/// P_LISTVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertyListValue.
/// P_TABLEVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertyTableValue.
/// P_REFERENCEVALUE: the properties defined by this IfcPropertyTemplate are of type IfcPropertyReferenceValue.
/// Q_LENGTH: the properties defined by this IfcPropertyTemplate are of type IfcQuantityLength.
/// Q_AREA: the properties defined by this IfcPropertyTemplate are of type IfcQuantityArea.
/// Q_VOLUME: the properties defined by this IfcPropertyTemplate are of type IfcQuantityVolume.
/// Q_COUNT: the properties defined by this IfcPropertyTemplate are of type IfcQuantityCount.
/// Q_WEIGHT: the properties defined by this IfcPropertyTemplate are of type IfcQuantityWeight.
/// Q_TIME: the properties defined by this IfcPropertyTemplate are of type IfcQuantityTime.
public:
    typedef enum {IfcSimplePropertyTemplateType_P_SINGLEVALUE, IfcSimplePropertyTemplateType_P_ENUMERATEDVALUE, IfcSimplePropertyTemplateType_P_BOUNDEDVALUE, IfcSimplePropertyTemplateType_P_LISTVALUE, IfcSimplePropertyTemplateType_P_TABLEVALUE, IfcSimplePropertyTemplateType_P_REFERENCEVALUE, IfcSimplePropertyTemplateType_Q_LENGTH, IfcSimplePropertyTemplateType_Q_AREA, IfcSimplePropertyTemplateType_Q_VOLUME, IfcSimplePropertyTemplateType_Q_COUNT, IfcSimplePropertyTemplateType_Q_WEIGHT, IfcSimplePropertyTemplateType_Q_TIME} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSimplePropertyTemplateTypeEnum (IfcEntityInstanceData&& e);
    IfcSimplePropertyTemplateTypeEnum (Value v);
    IfcSimplePropertyTemplateTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSlabTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
///   available predefined types of a slab. The
///   IfcSlabTypeEnum can be used for slab occurrences,
///   IfcSlab, and slab types, IfcSlabType. A
///   special property set definition may be provided for each
///   predefined type.
/// 
/// HISTORY New type in IFC
///   Release 2.0
/// 
/// Floor
/// 
/// The slab is used to represent a floor slab.
/// 
/// Roof
/// 
/// The slab is used to represent a roof slab (either
///   flat or sloped).
/// 
/// Landing
/// 
/// The slab is used to represent a landing within a
///   stair or ramp.
/// 
/// BaseSlab
/// 
/// The slab is used to represent a floor slab against
///   the ground (and thereby being a part of the
///   foundation). Another name is mat foundation.
/// 
/// IFC2x3 CHANGE
///   new enumerator added.
public:
    typedef enum {IfcSlabType_FLOOR, IfcSlabType_ROOF, IfcSlabType_LANDING, IfcSlabType_BASESLAB, IfcSlabType_APPROACH_SLAB, IfcSlabType_PAVING, IfcSlabType_WEARING, IfcSlabType_SIDEWALK, IfcSlabType_TRACKSLAB, IfcSlabType_USERDEFINED, IfcSlabType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSlabTypeEnum (IfcEntityInstanceData&& e);
    IfcSlabTypeEnum (Value v);
    IfcSlabTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSolarDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcSolarDeviceTypeEnum defines the range of types of solar devices available.
///   HISTORY: New type in IFC 2x4. 
/// 
/// Enumeration 
/// 
/// SOLARCOLLECTOR: A device that converts solar radiation into thermal energy (heating water, etc.). 
/// SOLARPANEL: A device that converts solar radiation into electric current. 
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcSolarDeviceType_SOLARCOLLECTOR, IfcSolarDeviceType_SOLARPANEL, IfcSolarDeviceType_USERDEFINED, IfcSolarDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSolarDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcSolarDeviceTypeEnum (Value v);
    IfcSolarDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSpaceHeaterTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the functional type of space heater.
/// 
/// The IfcSpaceHeaterTypeEnum contains the following:
/// 
/// CONVECTOR: A heat-distributing unit that operates with gravity-circulated air.
/// RADIATOR: A heat-distributing unit that operates with thermal radiation.
/// USERDEFINED: User-defined space heater type.
/// NOTDEFINED:  Undefined space heater type.
/// 
/// NOTE: This enumeration was revised in IFC 2x4 and was renamed from IfcHydronicHeaterTypeEnum in IFC R2x.
/// 
/// HISTORY: New enumeration in IFC R2x.
public:
    typedef enum {IfcSpaceHeaterType_CONVECTOR, IfcSpaceHeaterType_RADIATOR, IfcSpaceHeaterType_USERDEFINED, IfcSpaceHeaterType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSpaceHeaterTypeEnum (IfcEntityInstanceData&& e);
    IfcSpaceHeaterTypeEnum (Value v);
    IfcSpaceHeaterTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSpaceTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// available generic types for IfcSpace and
/// IfcSpaceType.
/// HISTORY New enumeration
/// in IFC2x3.
/// IFC2x4 CHANGE The enumerators
/// INTERNAL and EXTERNAL have been added for upward compatibility to
/// replace InteriorOrExteriorSpace
/// usage.
/// Enumeration
/// 
/// SPACE Any space not falling into another category.
/// 
/// NOTE For classification of spaces according to its
/// function that is often determined by national classification
/// systems use IfcClassificationReference via the
/// relationship IfcRelAssociatesClassification.
/// 
/// PARKING A space dedication for use as a parking spot
/// for vehicles, including access, such as a parking aisle
/// GFA Gross Floor Area - a specific kind of space for
/// each building story that includes all net area and construction
/// area (also the external envelop). Provision of such a specific
/// space is often required by regulations.
/// INTERNAL
/// 
/// NOTE the use is deprecated and
/// only provided for backward compatibility
/// purposes.
/// 
/// EXTERNAL
/// 
/// NOTE the use is deprecated and
/// only provided for backward compatibility
/// purposes.
public:
    typedef enum {IfcSpaceType_SPACE, IfcSpaceType_PARKING, IfcSpaceType_GFA, IfcSpaceType_INTERNAL, IfcSpaceType_EXTERNAL, IfcSpaceType_USERDEFINED, IfcSpaceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSpaceTypeEnum (IfcEntityInstanceData&& e);
    IfcSpaceTypeEnum (Value v);
    IfcSpaceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSpatialZoneTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the range
/// of different types of spatial zones that can further specify an
/// IfcSpatialZoneTypeEnum.
/// HISTORY New enumeration
/// in IFC Release 2x Edition 4.
/// Enumeration
/// 
/// CONSTRUCTION: the spatial zone is used
/// to represent a construction zone for the production process
/// FIRESAFETY: the spatial zone is used to
/// represent a fire safety zone, or fire compartment
/// LIGHTING: the spatial zone is used to
/// represent a lighting zone, e.g. a daylight zone, or a artificial
/// lighting zone
/// OCCUPANCY: the spatial zone is used to
/// represent a zone of particular occupancy
/// SECURITY: the spatial zone is used to
/// represent a zone for security planning and maintainance
/// work.
/// THERMAL: the spatial zone is used to
/// represent a thermal zone
/// USERDEFINED: user defined type spatial
/// zone
/// NOTDEFINED: undefined type spatial
/// zone
public:
    typedef enum {IfcSpatialZoneType_CONSTRUCTION, IfcSpatialZoneType_FIRESAFETY, IfcSpatialZoneType_LIGHTING, IfcSpatialZoneType_OCCUPANCY, IfcSpatialZoneType_SECURITY, IfcSpatialZoneType_THERMAL, IfcSpatialZoneType_TRANSPORT, IfcSpatialZoneType_VENTILATION, IfcSpatialZoneType_RESERVATION, IfcSpatialZoneType_USERDEFINED, IfcSpatialZoneType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSpatialZoneTypeEnum (IfcEntityInstanceData&& e);
    IfcSpatialZoneTypeEnum (Value v);
    IfcSpatialZoneTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStackTerminalTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcStackTerminalTypeEnum defines the range of different types of stack terminal that can be specified for use at the top of a vertical stack subsystem. 
///   HISTORY: New type in IFC 2x  
///   Enumeration 
/// 
/// BIRDCAGE: Guard cage, typically wire mesh, at the top of the stack preventing access by birds. 
/// COWL: A cowling placed at the top of a stack to eliminate downdraft. 
/// RAINWATERHOPPER: A box placed at the top of a rainwater downpipe to catch rainwater from guttering. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcStackTerminalType_BIRDCAGE, IfcStackTerminalType_COWL, IfcStackTerminalType_RAINWATERHOPPER, IfcStackTerminalType_USERDEFINED, IfcStackTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStackTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcStackTerminalTypeEnum (Value v);
    IfcStackTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStairFlightTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the different types
///   of stair flights an IfcStairFlightType object can fulfill: 
/// 
/// STRAIGHT: A stair flight with a straight walking line.  
///   WINDER: A stair flight with a straight walking line. 
///   SPIRAL: A stair flight with a circular or elliptic walking
///   line. 
///   CURVED: A stair flight with a curved walking line. 
///   FREEFORM: A stair flight with a free form walking line (and
///   outer boundaries). 
///   USERDEFINED: User-defined stair flight . 
///   NOTDEFINED: Undefined stair flight . 
/// 
/// HISTORY: New Enumeration in
///   Release IFC2x Edition 2.
public:
    typedef enum {IfcStairFlightType_STRAIGHT, IfcStairFlightType_WINDER, IfcStairFlightType_SPIRAL, IfcStairFlightType_CURVED, IfcStairFlightType_FREEFORM, IfcStairFlightType_USERDEFINED, IfcStairFlightType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStairFlightTypeEnum (IfcEntityInstanceData&& e);
    IfcStairFlightTypeEnum (Value v);
    IfcStairFlightTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStairTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic configuration of the stair type in terms of the number of stair flights and the number of landings, as illustrated in Figure 69. The type also distinguished turns by windings or by landings. In addition the subdivision of the straight and changing direction stairs is included. The stair configurations are given for stairs without and with one, two or three landings. 
/// 
/// Stairs which are subdivided into more than three landings have to be defined by the geometry only. Also stairs with non-regular shapes have to be defined by the geometry only. The type of such stairs is OTHEROPERATION. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// StraightRunStair 
///   A stair extending from
///   one level to another without turns or winders. The stair consists of one
///   straight flight. 
/// 
/// TwoStraightRunStair 
///   A straight stair
///   consisting of two straight flights without turns but with one landing. 
/// 
/// QuarterWindingStair 
///   A stair consisting of one
///   flight with a quarter winder, which is making a 90° turn. The direction of
///   the turn is determined by the walking line. 
/// 
/// QuarterTurnStair 
///   A stair making a 90°
///   turn, consisting of two straight flights connected by a quarterspace landing.
///   The direction of the turn is determined by the walking line. 
/// 
/// HalfWindingStair 
///   A stair consisting of one
///   flight with one half winder, which makes a 180° turn. The orientation of
///   the turn is determined by the walking line. 
/// 
/// HalfTurnStair 
///   A stair making a 180°
///   turn, consisting of two straight flights connected by a halfspace landing. The
///   orientation of the turn is determined by the walking line. 
/// 
/// TwoQuarterWindingStair 
///   A stair consisting of one
///   flight with two quarter winders, which make a 90° turn. The stair makes a
///   180° turn. The direction of the turns is determined by the walking
///   line. 
/// 
/// TwoQuarterTurnStair 
///   A stair making a 180°
///   turn, consisting of three straight flights connected by two quarterspace
///   landings. The direction of the turns is determined by the walking line. 
/// 
/// ThreeQuarterWindingStair
/// 
/// A stair consisting of one
///   flight with three quarter winders, which make a 90° turn. The stair makes a
///   270° turn. The direction of the turns is determined by the walking
///   line. 
/// 
/// ThreeQuarterTurnStair 
///   A stair making a 270°
///   turn, consisting of four straight flights connected by three quarterspace
///   landings. The direction of the turns is determined by the walking line. 
/// 
/// SpiralStair 
///   A stair constructed with
///   winders around a circular newel often without landings. Depending on outer
///   boundary it can be either a circular, elliptical or rectangular spiral stair.
///   The orientation of the winding stairs is determined by the walking line. 
/// 
/// DoubleReturnStair 
///   A stair having one
///   straight flight to a wide quarterspace landing, and two side flights from that
///   landing into opposite directions. The stair is making a 90° turn. The
///   direction of traffic is determined by the walking line. 
/// 
/// CurvedRunStair 
///   A stair extending from one
///   level to another without turns or winders. The stair is consisting of one
///   curved flight. 
/// 
/// TwoCurvedRunStair 
///   A curved stair consisting of
///   two curved flights without turns but with one landing. 
/// 
/// OtherOperation 
///   Free form stair (user defined
///   operation type) 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 69 — Stair types
public:
    typedef enum {IfcStairType_STRAIGHT_RUN_STAIR, IfcStairType_TWO_STRAIGHT_RUN_STAIR, IfcStairType_QUARTER_WINDING_STAIR, IfcStairType_QUARTER_TURN_STAIR, IfcStairType_HALF_WINDING_STAIR, IfcStairType_HALF_TURN_STAIR, IfcStairType_TWO_QUARTER_WINDING_STAIR, IfcStairType_TWO_QUARTER_TURN_STAIR, IfcStairType_THREE_QUARTER_WINDING_STAIR, IfcStairType_THREE_QUARTER_TURN_STAIR, IfcStairType_SPIRAL_STAIR, IfcStairType_DOUBLE_RETURN_STAIR, IfcStairType_CURVED_RUN_STAIR, IfcStairType_TWO_CURVED_RUN_STAIR, IfcStairType_LADDER, IfcStairType_USERDEFINED, IfcStairType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStairTypeEnum (IfcEntityInstanceData&& e);
    IfcStairTypeEnum (Value v);
    IfcStairTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStateEnum : public IfcUtil::IfcBaseType {
/// The IfcStateEnum enumeration identifies the state or accessibility of the object (for example, read/write, locked).
/// 
/// Valid enumerations are:
/// 
/// READWRITE: Object is in a Read-Write state. It may be modified by an application.
/// READONLY: Object is in a Read-Only state. It may be viewed but not modified by an application.
/// LOCKED: Object is in a Locked state. It may not be accessed by an application.
/// READWRITELOCKED: Object is in a Read-Write-Locked state. It may not be accessed by an application.
/// READONLYLOCKED: Object is in a Read-Only-Locked state. It may not be accessed by an application.
/// 
/// HISTORY  New enumeration in IFC R2.0.
/// 
/// IFC2x3 CHANGE  This concept was initially introduced in IFC 2.0 as IfcModifiedFlag of type BINARY(3) FIXED and has been modified in R2x to an enumeration. It was initially introduced as a first step towards providing facilities for partial model exchange from a server as requested by the IFC implementers. It is intended for use primarily by a model server so that an application can identify the state of the object.
public:
    typedef enum {IfcState_READWRITE, IfcState_READONLY, IfcState_LOCKED, IfcState_READWRITELOCKED, IfcState_READONLYLOCKED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStateEnum (IfcEntityInstanceData&& e);
    IfcStateEnum (Value v);
    IfcStateEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStructuralCurveActivityTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the distribution of load values in a curve action or reaction.
/// 
/// HISTORY New type in IFC 2x4
/// 
/// ENUMERATION 
/// 
/// CONST The load has a constant value over its entire extent.
///   LINEAR The load value is linearly distributed over the load's extent.
///   POLYGONAL The load consists of several consecutive linear sections.
///   EQUIDISTANT The load consists of n consecutive sections of same length and is specified by n+1 load samples.  The interpolation type over the segments is not defined by this distribution type but may be qualified in IfcObject.ObjectType based on additional agreements.
///   SINUS The load value is distributed as a sinus half wave.
///   PARABOLA The load value is distributed as a half wave described by a symmetric quadratic parabola.
///   DISCRETE The load is specified as a series of discrete load points.
///   USERDEFINED The load distribution is user-defined.
///   NOTDEFINED The load distribution is undefined.
public:
    typedef enum {IfcStructuralCurveActivityType_CONST, IfcStructuralCurveActivityType_LINEAR, IfcStructuralCurveActivityType_POLYGONAL, IfcStructuralCurveActivityType_EQUIDISTANT, IfcStructuralCurveActivityType_SINUS, IfcStructuralCurveActivityType_PARABOLA, IfcStructuralCurveActivityType_DISCRETE, IfcStructuralCurveActivityType_USERDEFINED, IfcStructuralCurveActivityType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStructuralCurveActivityTypeEnum (IfcEntityInstanceData&& e);
    IfcStructuralCurveActivityTypeEnum (Value v);
    IfcStructuralCurveActivityTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStructuralCurveMemberTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This type definition shall be used to
/// 
/// distinguish between different types of structural 'curve' members, such as
/// 
/// cables. The IfcStructuralCurveTypeEnum type is referenced by the entity
/// 
/// IfcStructuralCurveMember. 
/// 
/// RIGID_JOINED_MEMBER:  A member with capacity to carry transverse and axial loads, i.e. a beam. Its actual joints may be rigid or pinned. Typically used in rigid frames.
/// PIN_JOINED_MEMBER:    A member with capacity to carry axial loads only, i.e. a link. Typically used in trusses.
/// CABLE:                A tension member which is able to carry transverse loads only under large deflection.
/// TENSION_MEMBER:       A member without compressional stiffness.
/// COMPRESSION_MEMBER:   A member without tensional stiffness.
/// USERDEFINED:          A specially defined member.
/// NOTDEFINED:           A member without further categorization.
/// 
/// HISTORY New type in IFC 2x2.
/// IFC 2x4 change:  Renamed from IfcStructuralCurveTypeEnum.
public:
    typedef enum {IfcStructuralCurveMemberType_RIGID_JOINED_MEMBER, IfcStructuralCurveMemberType_PIN_JOINED_MEMBER, IfcStructuralCurveMemberType_CABLE, IfcStructuralCurveMemberType_TENSION_MEMBER, IfcStructuralCurveMemberType_COMPRESSION_MEMBER, IfcStructuralCurveMemberType_USERDEFINED, IfcStructuralCurveMemberType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStructuralCurveMemberTypeEnum (IfcEntityInstanceData&& e);
    IfcStructuralCurveMemberTypeEnum (Value v);
    IfcStructuralCurveMemberTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStructuralSurfaceActivityTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: Enumeration defining the distribution of load values in a surface action or reaction.
/// 
/// HISTORY New type in IFC 2x4
/// 
/// ENUMERATION 
/// 
/// CONST The load has a constant value over its entire extent.
///   BILINEAR The load value is bilinearly distributed over the load's extent.
///   DISCRETE The load is specified as a series of discrete load points.
///   ISOCONTOUR The load is specified by a series of iso-curves (level sets), i.e. curves at which the load value is constant.  These curves run perpendicularly to the load gradient.
///   USERDEFINED The load distribution is user-defined.
///   NOTDEFINED The load distribution is undefined.
public:
    typedef enum {IfcStructuralSurfaceActivityType_CONST, IfcStructuralSurfaceActivityType_BILINEAR, IfcStructuralSurfaceActivityType_DISCRETE, IfcStructuralSurfaceActivityType_ISOCONTOUR, IfcStructuralSurfaceActivityType_USERDEFINED, IfcStructuralSurfaceActivityType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStructuralSurfaceActivityTypeEnum (IfcEntityInstanceData&& e);
    IfcStructuralSurfaceActivityTypeEnum (Value v);
    IfcStructuralSurfaceActivityTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcStructuralSurfaceMemberTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This type definition shall be used to
/// 
/// distinguish between different types of structural surface members, such as the
/// 
/// typical mechanical function of walls, slabs and shells.
/// 
/// BENDING_ELEMENT:   A member with capacity to carry out-of-plane loads, i.e. a plate.
/// MEMBRANE_ELEMENT:  A member with capacity to carry in-plane loads, for example a shear wall.
/// SHELL:             A member with capacity to carry in-plane and out-of-plane loads, i.e. a combination of bending element and membrane element.
/// USERDEFINED:       A specially defined member.
/// NOTDEFINED:        A member without further categorization.
/// 
/// HISTORY New type in IFC 2x2.
/// IFC 2x4 change:  Renamed from IfcStructuralSurfaceTypeEnum.
public:
    typedef enum {IfcStructuralSurfaceMemberType_BENDING_ELEMENT, IfcStructuralSurfaceMemberType_MEMBRANE_ELEMENT, IfcStructuralSurfaceMemberType_SHELL, IfcStructuralSurfaceMemberType_USERDEFINED, IfcStructuralSurfaceMemberType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcStructuralSurfaceMemberTypeEnum (IfcEntityInstanceData&& e);
    IfcStructuralSurfaceMemberTypeEnum (Value v);
    IfcStructuralSurfaceMemberTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSubContractResourceTypeEnum : public IfcUtil::IfcBaseType {
/// This enumeration is used to identify the primary purpose of a subcontract resource.  The IfcSubContractResourceTypeEnum contains the following:
/// 
/// PURCHASE: Furnishing or supplying products.
/// WORK: Performing work onsite.
/// USERDEFINED: User-defined resource.
/// NOTDEFINED: Undefined resource.
/// 
/// HISTORY: New enumeration in IFC2x4
public:
    typedef enum {IfcSubContractResourceType_PURCHASE, IfcSubContractResourceType_WORK, IfcSubContractResourceType_USERDEFINED, IfcSubContractResourceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSubContractResourceTypeEnum (IfcEntityInstanceData&& e);
    IfcSubContractResourceTypeEnum (Value v);
    IfcSubContractResourceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSurfaceFeatureTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration indicates the type of a surface feature.
/// 
/// HISTORY New type in IFC 2x4.
/// 
/// ENUMERATION
/// 
/// MARK A point, line, cross, or other mark, applied for example for easier adjustment of elements during assembly.
///   TAG A name tag, which allows to identify an element during production, delivery and assembly.  May be manufactured in different ways, e.g. by printing or punching the tracking code onto the element or by attaching an actual tag.
///   TREATMENT A subtractive surface feature, e.g. grinding, or an additive surface feature, e.g. coating, or an impregnating treatment, or a series of any of these kinds of treatments.
///   USERDEFINED A user-defined type of surface feature.
///   NOTDEFINED An undefined type of surface feature.
public:
    typedef enum {IfcSurfaceFeatureType_MARK, IfcSurfaceFeatureType_TAG, IfcSurfaceFeatureType_TREATMENT, IfcSurfaceFeatureType_DEFECT, IfcSurfaceFeatureType_HATCHMARKING, IfcSurfaceFeatureType_LINEMARKING, IfcSurfaceFeatureType_PAVEMENTSURFACEMARKING, IfcSurfaceFeatureType_SYMBOLMARKING, IfcSurfaceFeatureType_NONSKIDSURFACING, IfcSurfaceFeatureType_RUMBLESTRIP, IfcSurfaceFeatureType_TRANSVERSERUMBLESTRIP, IfcSurfaceFeatureType_USERDEFINED, IfcSurfaceFeatureType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSurfaceFeatureTypeEnum (IfcEntityInstanceData&& e);
    IfcSurfaceFeatureTypeEnum (Value v);
    IfcSurfaceFeatureTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSurfaceSide : public IfcUtil::IfcBaseType {
/// IfcSurfaceSide is a denotion of whether negative, positive or both sides of a surface are being referenced. 
/// 
/// ENUMERATION Definition from ISO/CD 10303-46:1992: 
/// 
/// POSITIVE: The side of a surface which is in the same direction as the surface normal derived from the mathematical definition.  
/// NEGATIVE: The side of a surface which is in the opposite direction than the surface normal derived from the mathematical definition. 
/// BOTH: Both, positive and negative side. 
/// 
/// NOTE Corresponding ISO 10303 type: surface_side. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY: New Enumeration in IFC 2.0
public:
    typedef enum {IfcSurfaceSide_POSITIVE, IfcSurfaceSide_NEGATIVE, IfcSurfaceSide_BOTH} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSurfaceSide (IfcEntityInstanceData&& e);
    IfcSurfaceSide (Value v);
    IfcSurfaceSide (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSwitchingDeviceTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcSwitchingDeviceTypeEnum defines the range of different types of switch that can be specified. 
///   HISTORY: New type in IFC 2x2 
///   Enumeration 
/// 
/// CONTACTOR: An electrical device used to control the flow of power in a circuit on or off. 
/// DIMMERSWITCH: A dimmer switch has variable positions, and may adjust electrical power or other setting (according to the switched port type). 
/// EMERGENCYSTOP: An emergency stop device acts to remove as quickly as possible any danger that may have arisen unexpectedly. 
/// KEYPAD: A set of buttons or switches, each potentially applicable to a different device.  
/// MOMENTARYSWITCH: A momentary switch has no position, and may trigger some action to occur.  
/// SELECTORSWITCH: A selector switch has multiple positions, and may switch connectivity or other setting.  
/// STARTER: A starter is a switch which in the closed position controls the application of power to an electrical device. 
/// SWITCHDISCONNECTOR: A switch disconnector is a switch which in the open position satisfies the isolating requirements specified for a disconnector. 
/// SELECTORSWITCH: A selector switch has multiple positions, and may change the source or level of power or other setting (according to the switched port type). 
/// TOGGLESWITCH: A toggle switch has two positions, and may enable or isolate electrical power or other setting (according to the switched port type). 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcSwitchingDeviceType_CONTACTOR, IfcSwitchingDeviceType_DIMMERSWITCH, IfcSwitchingDeviceType_EMERGENCYSTOP, IfcSwitchingDeviceType_KEYPAD, IfcSwitchingDeviceType_MOMENTARYSWITCH, IfcSwitchingDeviceType_SELECTORSWITCH, IfcSwitchingDeviceType_STARTER, IfcSwitchingDeviceType_SWITCHDISCONNECTOR, IfcSwitchingDeviceType_TOGGLESWITCH, IfcSwitchingDeviceType_RELAY, IfcSwitchingDeviceType_START_AND_STOP_EQUIPMENT, IfcSwitchingDeviceType_USERDEFINED, IfcSwitchingDeviceType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSwitchingDeviceTypeEnum (IfcEntityInstanceData&& e);
    IfcSwitchingDeviceTypeEnum (Value v);
    IfcSwitchingDeviceTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcSystemFurnitureElementTypeEnum : public IfcUtil::IfcBaseType {
/// IfcSystemFurnitureTypeEnum defines the types of system furniture from which the type required can be selected. 
///   HISTORY: New Enumeration in IFC 2x4 
///   Enumeration: 
/// 
/// PANEL: Vertical panel used to divide work spaces.  
/// WORKSURFACE: Workstation countertop.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcSystemFurnitureElementType_PANEL, IfcSystemFurnitureElementType_WORKSURFACE, IfcSystemFurnitureElementType_SUBRACK, IfcSystemFurnitureElementType_USERDEFINED, IfcSystemFurnitureElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcSystemFurnitureElementTypeEnum (IfcEntityInstanceData&& e);
    IfcSystemFurnitureElementTypeEnum (Value v);
    IfcSystemFurnitureElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTankTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of tanks.
/// 
/// The IfcTankTypeEnum contains the following:
/// 
/// BASIN:  An arbitrary open tank type.
/// 
/// BREAKPRESSURE:  An open container that breaks the hydraulic pressure in a distribution system, typically located between the fluid reservoir and the fluid supply points. A typical break pressure tank allows the flow to discharge into the atmosphere, thereby reducing its hydrostatic pressure to zero.
/// 
/// EXPANSION:  A closed container used in a closed fluid distribution system to mitigate the effects of thermal expansion or water hammer. The tank is typically constructed with a diaphragm dividing the tank into two sections, with fluid on one side of the diaphragm and air on the other. One example application is when connected to the primary circuit of a hot water system to accommodate the increase in volume of the water when it is heated.
/// 
/// FEEDANDEXPANSION:  An open tank that is used for both storage and thermal expansion. A typical example is a tank used to store make-up water at ambient pressure for supply to a hot water system, simultaneously accommodating increases in volume of the water when heated.
/// 
/// PRESSUREVESSEL:  A closed container used for storing fluids or gases at a pressure different from the ambient pressure. A pressure vessel is typically rated by an authority having jurisdiction for the operational pressure.
/// 
/// STORAGE:  An open or closed containter used for storing a fluid at ambient pressure and from which it can be supplied to the fluid distribution system. There are many examples of storage tanks, such as potable water storage tanks, fuel storage tanks, etc.
/// 
/// VESSEL:  An arbitrary closed tank type.
/// 
/// USERDEFINED:  User-defined tank type.
/// 
/// NOTDEFINED:  Undefined tank type.
/// 
/// HISTORY: New enumeration in IFC 2x2.  BASIN and VESSEL added in IFC2x4.
public:
    typedef enum {IfcTankType_BASIN, IfcTankType_BREAKPRESSURE, IfcTankType_EXPANSION, IfcTankType_FEEDANDEXPANSION, IfcTankType_PRESSUREVESSEL, IfcTankType_STORAGE, IfcTankType_VESSEL, IfcTankType_OILRETENTIONTRAY, IfcTankType_USERDEFINED, IfcTankType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTankTypeEnum (IfcEntityInstanceData&& e);
    IfcTankTypeEnum (Value v);
    IfcTankTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTaskDurationEnum : public IfcUtil::IfcBaseType {
/// IfcTaskDurationEnum identifies how a time duration is measured:
/// 
/// ELAPSEDTIME: The time duration is based on elapsed time (24 hours per day, independent of calendar).
///   WORKTIME: The time duration is based on work time (calendar-dependent).
///   NOTDEFINED: The time duration is undefined.
/// 
/// HISTORY: New enumeration in IFC2x4.
public:
    typedef enum {IfcTaskDuration_ELAPSEDTIME, IfcTaskDuration_WORKTIME, IfcTaskDuration_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTaskDurationEnum (IfcEntityInstanceData&& e);
    IfcTaskDurationEnum (Value v);
    IfcTaskDurationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTaskTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcTaskTypeEnum defines the range of different types of task that can be specified.
/// 
/// HISTORY  New type in IFC2x4
/// 
/// Enumeration:
/// 
/// ATTENDANCE: Attendance or waiting on other things happening
/// CONSTRUCTION: Constructing or building something
/// DEMOLITION: Demolishing or breaking down something
/// DISMANTLE: Taking something apart carefully so that it can be recycled or reused
/// DISPOSAL: Disposing or getting rid of something
/// INSTALLATION: Installing something (equivalent to construction but more commonly used for engineering tasks)
/// LOGISTIC: Transporation or delivery of something
/// MAINTENANCE: Keeping something in good working order
/// MOVE: Moving things from one place to another
/// OPERATION: A procedure undertaken to start up the operation an artifact
/// REMOVAL: Removal of an item from use and taking it from its place of use
/// RENOVATION: Bringing something to an 'as-new' state
public:
    typedef enum {IfcTaskType_ATTENDANCE, IfcTaskType_CONSTRUCTION, IfcTaskType_DEMOLITION, IfcTaskType_DISMANTLE, IfcTaskType_DISPOSAL, IfcTaskType_INSTALLATION, IfcTaskType_LOGISTIC, IfcTaskType_MAINTENANCE, IfcTaskType_MOVE, IfcTaskType_OPERATION, IfcTaskType_REMOVAL, IfcTaskType_RENOVATION, IfcTaskType_USERDEFINED, IfcTaskType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTaskTypeEnum (IfcEntityInstanceData&& e);
    IfcTaskTypeEnum (Value v);
    IfcTaskTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTendonAnchorTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTendonAnchorType_COUPLER, IfcTendonAnchorType_FIXED_END, IfcTendonAnchorType_TENSIONING_END, IfcTendonAnchorType_USERDEFINED, IfcTendonAnchorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTendonAnchorTypeEnum (IfcEntityInstanceData&& e);
    IfcTendonAnchorTypeEnum (Value v);
    IfcTendonAnchorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTendonConduitTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTendonConduitType_DUCT, IfcTendonConduitType_COUPLER, IfcTendonConduitType_GROUTING_DUCT, IfcTendonConduitType_TRUMPET, IfcTendonConduitType_DIABOLO, IfcTendonConduitType_USERDEFINED, IfcTendonConduitType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTendonConduitTypeEnum (IfcEntityInstanceData&& e);
    IfcTendonConduitTypeEnum (Value v);
    IfcTendonConduitTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTendonTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTendonType_BAR, IfcTendonType_COATED, IfcTendonType_STRAND, IfcTendonType_WIRE, IfcTendonType_USERDEFINED, IfcTendonType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTendonTypeEnum (IfcEntityInstanceData&& e);
    IfcTendonTypeEnum (Value v);
    IfcTendonTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTextPath : public IfcUtil::IfcBaseType {
/// The text path determines the direction of the text characters in respect to each other.
/// 
/// NOTE: The IfcTextPath is an entity that had been adopted from ISO 10303, Industrial automation systems and integration&#151;Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE Corresponding ISO 10303 name:text_path . Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
public:
    typedef enum {IfcTextPath_LEFT, IfcTextPath_RIGHT, IfcTextPath_UP, IfcTextPath_DOWN} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTextPath (IfcEntityInstanceData&& e);
    IfcTextPath (Value v);
    IfcTextPath (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTimeSeriesDataTypeEnum : public IfcUtil::IfcBaseType {
/// IfcTimeSeriesDataTypeEnum describes a type of time series data and is used to determine a value during the time series which is not explicitly specified: 
/// 
/// CONTINUOUS: The time series data is continuous. 
///   DISCRETE: The time series data is discrete. 
///   DISCRETEBINARY: The time series data is discrete binary. 
///   PIECEWISEBINARY: The time series data is piecewise binary. 
///   PIECEWISECONSTANT: The time series data is piecewise constant. 
///   PIECEWISECONTINUOUS: The time series data is piecewise continuous. 
///   NOTDEFINED: The time series data is not defined. 
/// 
/// HISTORY: New enumeration in IFC2x2.
public:
    typedef enum {IfcTimeSeriesDataType_CONTINUOUS, IfcTimeSeriesDataType_DISCRETE, IfcTimeSeriesDataType_DISCRETEBINARY, IfcTimeSeriesDataType_PIECEWISEBINARY, IfcTimeSeriesDataType_PIECEWISECONSTANT, IfcTimeSeriesDataType_PIECEWISECONTINUOUS, IfcTimeSeriesDataType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTimeSeriesDataTypeEnum (IfcEntityInstanceData&& e);
    IfcTimeSeriesDataTypeEnum (Value v);
    IfcTimeSeriesDataTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTrackElementTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTrackElementType_TRACKENDOFALIGNMENT, IfcTrackElementType_BLOCKINGDEVICE, IfcTrackElementType_VEHICLESTOP, IfcTrackElementType_SLEEPER, IfcTrackElementType_HALF_SET_OF_BLADES, IfcTrackElementType_SPEEDREGULATOR, IfcTrackElementType_DERAILER, IfcTrackElementType_FROG, IfcTrackElementType_USERDEFINED, IfcTrackElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTrackElementTypeEnum (IfcEntityInstanceData&& e);
    IfcTrackElementTypeEnum (Value v);
    IfcTrackElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTransformerTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcTransformerTypeEnum defines the range of different types of transformer that can be specified. 
///   HISTORY: New type in IFC 2x2 
///   Enumeration 
/// 
/// CURRENT: A transformer that changes the current between circuits. 
/// FREQUENCY: A transformer that changes the frequency between circuits. 
/// INVERTER: A transformer that converts from direct current (DC) to alternating current (AC). 
/// RECTIFIER: A transformer that converts from alternating current (AC) to direct current (DC).  
/// VOLTAGE: A transformer that changes the voltage between circuits.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcTransformerType_CURRENT, IfcTransformerType_FREQUENCY, IfcTransformerType_INVERTER, IfcTransformerType_RECTIFIER, IfcTransformerType_VOLTAGE, IfcTransformerType_CHOPPER, IfcTransformerType_COMBINED, IfcTransformerType_USERDEFINED, IfcTransformerType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTransformerTypeEnum (IfcEntityInstanceData&& e);
    IfcTransformerTypeEnum (Value v);
    IfcTransformerTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTransitionCode : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-42:1992: This type conveys the continuity properties of a composite curve or surface. The continuity referred to is geometric, not parametric continuity. For example, in ContSameGradient the tangent vectors of successive segments will have the same direction, but may have different magnitude.  
/// 
/// NOTE  Corresponding ISO 10303 type: transition_code, please refer to ISO/IS 10303-42:1994, p. 14 for the final definition of the formal standard.
/// 
/// HISTORY  New Type in IFC Release 1.0
/// 
/// Figure 273 (quoted from ISO/CD 10303-42:1992, p.55) illustrates transition types.
/// 
/// Figure 273 — Transition code
/// 
/// ENUMERATION 
/// 
/// DISCONTINUOUS: The segments do not join. This is permitted only at the boundary of the curve or surface to indicate that it is not closed.
/// CONTINUOUS: The segments join but no condition on their tangents is implied. 
/// CONTSAMEGRADIENT: The segments join and their tangent vectors or tangent planes are parallel and have the same direction at the joint: equality of derivatives is not required. 
/// CONTSAMEGRADIENTSAMECURVATURE: For a curve, the segments join, their tangent vectors are parallel and in the same direction and their curvatures are equal at the joint: equality of derivatives is not required. For a surface this implies that the principle curvatures are the same and the principle directions are coincident along the common boundary.
public:
    typedef enum {IfcTransitionCode_DISCONTINUOUS, IfcTransitionCode_CONTINUOUS, IfcTransitionCode_CONTSAMEGRADIENT, IfcTransitionCode_CONTSAMEGRADIENTSAMECURVATURE} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTransitionCode (IfcEntityInstanceData&& e);
    IfcTransitionCode (Value v);
    IfcTransitionCode (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTransitionCurveType : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTransitionCurveType_BIQUADRATICPARABOLA, IfcTransitionCurveType_BLOSSCURVE, IfcTransitionCurveType_CLOTHOIDCURVE, IfcTransitionCurveType_COSINECURVE, IfcTransitionCurveType_CUBICPARABOLA, IfcTransitionCurveType_SINECURVE} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTransitionCurveType (IfcEntityInstanceData&& e);
    IfcTransitionCurveType (Value v);
    IfcTransitionCurveType (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTransportElementFixedTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTransportElementFixedType_ELEVATOR, IfcTransportElementFixedType_ESCALATOR, IfcTransportElementFixedType_MOVINGWALKWAY, IfcTransportElementFixedType_CRANEWAY, IfcTransportElementFixedType_LIFTINGGEAR, IfcTransportElementFixedType_USERDEFINED, IfcTransportElementFixedType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTransportElementFixedTypeEnum (IfcEntityInstanceData&& e);
    IfcTransportElementFixedTypeEnum (Value v);
    IfcTransportElementFixedTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTransportElementNonFixedTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcTransportElementNonFixedType_VEHICLE, IfcTransportElementNonFixedType_VEHICLETRACKED, IfcTransportElementNonFixedType_ROLLINGSTOCK, IfcTransportElementNonFixedType_VEHICLEWHEELED, IfcTransportElementNonFixedType_VEHICLEAIR, IfcTransportElementNonFixedType_CARGO, IfcTransportElementNonFixedType_VEHICLEMARINE, IfcTransportElementNonFixedType_USERDEFINED, IfcTransportElementNonFixedType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTransportElementNonFixedTypeEnum (IfcEntityInstanceData&& e);
    IfcTransportElementNonFixedTypeEnum (Value v);
    IfcTransportElementNonFixedTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTrimmingPreference : public IfcUtil::IfcBaseType {
/// Definition from ISO/CD 10303-42:1992: This type is used to describe the preferred way of trimming a parametric curve where the trimming is multiply defined. 
/// 
/// NOTE Corresponding ISO 10303 type: trimming_preference, please refer to ISO/IS 10303-42:1994, p. 18 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.0
/// 
/// ENUMERATION 
/// 
/// CARTESIAN: Indicates that trimming by Cartesian point is preferred. 
/// PARAMETER: Indicates the preference for the parameter value. 
/// UNSPECIFIED: Indicates that no preference is communicated.
public:
    typedef enum {IfcTrimmingPreference_CARTESIAN, IfcTrimmingPreference_PARAMETER, IfcTrimmingPreference_UNSPECIFIED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTrimmingPreference (IfcEntityInstanceData&& e);
    IfcTrimmingPreference (Value v);
    IfcTrimmingPreference (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcTubeBundleTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of tube bundles. 
///   The IfcTubeBundleTypeEnum contains the following:
/// 
/// FINNED:  Finned tube bundle type.
///   USERDEFINED:  User-defined tube bundle type.
///   NOTDEFINED:  Undefined tube bundle type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcTubeBundleType_FINNED, IfcTubeBundleType_USERDEFINED, IfcTubeBundleType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcTubeBundleTypeEnum (IfcEntityInstanceData&& e);
    IfcTubeBundleTypeEnum (Value v);
    IfcTubeBundleTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcUnitEnum : public IfcUtil::IfcBaseType {
/// IfcUnitEnum is an enumeration type for allowed unit types of IfcNamedUnit.
/// 
/// ENUMERATION 
/// 
/// ABSORBEDDOSEUNIT
///   AMOUNTOFSUBSTANCEUNIT
///   AREAUNIT
///   DOSEEQUIVALENTUNIT
///   ELECTRICCAPACITANCEUNIT
///   ELECTRICCHARGEUNIT
///   ELECTRICCONDUCTANCEUNIT
///   ELECTRICCURRENTUNIT
///   ELECTRICRESISTANCEUNIT
///   ELECTRICVOLTAGEUNIT
///   ENERGYUNIT
///   FORCEUNIT
///   FREQUENCYUNIT
///   ILLUMINANCEUNIT
///   INDUCTANCEUNIT
///   LENGTHUNIT
///   LUMINOUSFLUXUNIT
///   LUMINOUSINTENSITYUNIT
///   MAGNETICFLUXDENSITYUNIT
///   MAGNETICFLUXUNIT
///   MASSUNIT
///   PLANEANGLEUNIT
///   POWERUNIT
///   PRESSUREUNIT
///   RADIOACTIVITYUNIT
///   SOLIDANGLEUNIT
///   THERMODYNAMICTEMPERATUREUNIT
///   TIMEUNIT
///   VOLUMEUNIT
///   USERDEFINED: User defined unit type. The type of unit is only implied by its name or the usage context.
/// 
/// HISTORY New type in IFC Release 1.5.1.
public:
    typedef enum {IfcUnit_ABSORBEDDOSEUNIT, IfcUnit_AMOUNTOFSUBSTANCEUNIT, IfcUnit_AREAUNIT, IfcUnit_DOSEEQUIVALENTUNIT, IfcUnit_ELECTRICCAPACITANCEUNIT, IfcUnit_ELECTRICCHARGEUNIT, IfcUnit_ELECTRICCONDUCTANCEUNIT, IfcUnit_ELECTRICCURRENTUNIT, IfcUnit_ELECTRICRESISTANCEUNIT, IfcUnit_ELECTRICVOLTAGEUNIT, IfcUnit_ENERGYUNIT, IfcUnit_FORCEUNIT, IfcUnit_FREQUENCYUNIT, IfcUnit_ILLUMINANCEUNIT, IfcUnit_INDUCTANCEUNIT, IfcUnit_LENGTHUNIT, IfcUnit_LUMINOUSFLUXUNIT, IfcUnit_LUMINOUSINTENSITYUNIT, IfcUnit_MAGNETICFLUXDENSITYUNIT, IfcUnit_MAGNETICFLUXUNIT, IfcUnit_MASSUNIT, IfcUnit_PLANEANGLEUNIT, IfcUnit_POWERUNIT, IfcUnit_PRESSUREUNIT, IfcUnit_RADIOACTIVITYUNIT, IfcUnit_SOLIDANGLEUNIT, IfcUnit_THERMODYNAMICTEMPERATUREUNIT, IfcUnit_TIMEUNIT, IfcUnit_VOLUMEUNIT, IfcUnit_USERDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcUnitEnum (IfcEntityInstanceData&& e);
    IfcUnitEnum (Value v);
    IfcUnitEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcUnitaryControlElementTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcUnitaryControlElementTypeEnum defines the range of different types and/or functions of unitary control elements possible. 
/// 
/// HISTORY: New type in IFC 2x4. 
/// 
/// Enumeration 
/// 
/// ALARMPANEL: A control element at which alarms are annunciated. 
/// CONTROLPANEL: A control element at which devices that control or monitor the operation of a site, building or part of a building are located. 
/// GASDETECTORPANEL: A control element at which the detection of gas is annunciated. 
/// INDICATORPANEL: A control element at which equipment operational status, condition, safety state or other required parameters are indicated. 
/// MIMICPANEL: A control element at which information that is available elsewhere is repeated or 'mimicked'. 
/// HUMIDISTAT: A control element that senses and regulates the humidity of a system or space so that the humidity is maintained near a desired setpoint. 
/// THERMOSTAT: A control element that senses and regulates the temperature of an element, system or space so that the temperature is maintained near a desired setpoint. 
/// WEATHERSTATION: A control element that senses multiple climate properties such as temperature, humidity, pressure, wind, and rain. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcUnitaryControlElementType_ALARMPANEL, IfcUnitaryControlElementType_CONTROLPANEL, IfcUnitaryControlElementType_GASDETECTIONPANEL, IfcUnitaryControlElementType_INDICATORPANEL, IfcUnitaryControlElementType_MIMICPANEL, IfcUnitaryControlElementType_HUMIDISTAT, IfcUnitaryControlElementType_THERMOSTAT, IfcUnitaryControlElementType_WEATHERSTATION, IfcUnitaryControlElementType_COMBINED, IfcUnitaryControlElementType_USERDEFINED, IfcUnitaryControlElementType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcUnitaryControlElementTypeEnum (IfcEntityInstanceData&& e);
    IfcUnitaryControlElementTypeEnum (Value v);
    IfcUnitaryControlElementTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcUnitaryEquipmentTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the functional type of unitary equipment. 
///   The IfcUnitaryEquipmentTypeEnum contains the following:
/// 
/// AIRHANDLER: A unitary air handling unit typically containing a fan, economizer, and coils.
///   AIRCONDITIONINGUNIT: A unitary packaged air-conditioning unit typically used in residential or light commercial applications.
///   DEHUMIDIFIER: A unitary packaged dehumidification unit.  Note: units supporting multiple modes (dehumidification, cooling, and/or heating) should use AIRCONDITIONINGUNIT.
///   SPLITSYSTEM: A system which separates the compressor from the evaporator, but acts as a unitary component typically within residential or light commercial applications.
///   ROOFTOPUNIT: A packaged assembly that is either field-erected or manufactured atop the roof of a large residential or commercial building and acts as a unitary component.
///   USERDEFINED: User-defined unitary equipment type.
///   NOTDEFINED:  Undefined unitary equipment type.
/// 
/// HISTORY: New enumeration in IFC R2x.  DEHUMIDIFIER added in IFC 2x4
public:
    typedef enum {IfcUnitaryEquipmentType_AIRHANDLER, IfcUnitaryEquipmentType_AIRCONDITIONINGUNIT, IfcUnitaryEquipmentType_DEHUMIDIFIER, IfcUnitaryEquipmentType_SPLITSYSTEM, IfcUnitaryEquipmentType_ROOFTOPUNIT, IfcUnitaryEquipmentType_USERDEFINED, IfcUnitaryEquipmentType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcUnitaryEquipmentTypeEnum (IfcEntityInstanceData&& e);
    IfcUnitaryEquipmentTypeEnum (Value v);
    IfcUnitaryEquipmentTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcValveTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcValveTypeEnum defines the
///   range of different types of valve that can be specified. These are typically
///   used in conjunction with Pset_ValveTypeCommon, which contains common
///   properties for all valve types. The IfcValveTypeEnum contains:
/// 
/// AIRRELEASE: Valve used to release air from a pipe or fitting.  
///   ANTIVACUUM: Valve that opens to admit air if the pressure falls below
///   atmospheric pressure (BS6100 330 4104) 
///   CHANGEOVER: Valve that enables flow to be switched between pipelines (3 or 4
///   port). 
///   CHECK: Valve that permits water to flow in one direction only and is
///   enclosed when there is no flow (2 port). 
///   COMMISSIONING: Valve used to facilitate commissioning of a system (2 port). 
///   DIVERTING: Valve that enables flow to be diverted from one branch of a
///   pipeline to another (3 port). 
///   DOUBLECHECK: An assembly that incorporates two valves used to prevent backflow
///   (BS6100 330 4106). 
///   DOUBLEREGULATING: Valve used to facilitate regulation of fluid flow in a system.
///   DRAWOFFCOCK: A valve used to remove fluid from a piping system.
///   FAUCET: Faucet valve typically used as a flow discharge.
///   FLUSHING: Valve that flushes a predetermined quantity of water to cleanse a
///   toilet, urinal, etc.
///   GASCOCK: Valve that is used for controlling the flow of gas. 
///   GASTAP: Gas tap typically used for venting or discharging gas from a system.
///   ISOLATING: Valve that closes off flow in a pipeline. 
///   MIXING: Valve that enables flow from two branches of a pipeline to be mixed
///   together (3 port). 
///   PRESSUREREDUCING: Valve that reduces the pressure of a fluid immediately downstream
///   of its position in a pipeline to a preselected value or by a predetermined
///   ratio. 
///   PRESSURERELIEF: Spring or weight loaded valve that automatically discharges to a
///   safe place fluid that has built up to excessive pressure in pipes or
///   fittings 
///   REGULATING: Valve used to facilitate regulation of fluid flow in a system.
///   SAFETYCUTOFF: Valve that closes under the action of a safety mechanism such as a
///   drop weight, solenoid etc. 
///   STEAMTRAP: Valve that restricts flow of steam while allowing condensate to 
///   pass through. 
///   STOPCOCK: An isolating valve used on a domestic water service. 
///   USERDEFINED: User-defined valve type. 
///   NOTDEFINED: Undefined valve type. 
/// 
/// HISTORY: New type in IFC R2.0
public:
    typedef enum {IfcValveType_AIRRELEASE, IfcValveType_ANTIVACUUM, IfcValveType_CHANGEOVER, IfcValveType_CHECK, IfcValveType_COMMISSIONING, IfcValveType_DIVERTING, IfcValveType_DRAWOFFCOCK, IfcValveType_DOUBLECHECK, IfcValveType_DOUBLEREGULATING, IfcValveType_FAUCET, IfcValveType_FLUSHING, IfcValveType_GASCOCK, IfcValveType_GASTAP, IfcValveType_ISOLATING, IfcValveType_MIXING, IfcValveType_PRESSUREREDUCING, IfcValveType_PRESSURERELIEF, IfcValveType_REGULATING, IfcValveType_SAFETYCUTOFF, IfcValveType_STEAMTRAP, IfcValveType_STOPCOCK, IfcValveType_USERDEFINED, IfcValveType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcValveTypeEnum (IfcEntityInstanceData&& e);
    IfcValveTypeEnum (Value v);
    IfcValveTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcVibrationDamperTypeEnum : public IfcUtil::IfcBaseType {

public:
    typedef enum {IfcVibrationDamperType_BENDING_YIELD, IfcVibrationDamperType_SHEAR_YIELD, IfcVibrationDamperType_AXIAL_YIELD, IfcVibrationDamperType_FRICTION, IfcVibrationDamperType_VISCOUS, IfcVibrationDamperType_RUBBER, IfcVibrationDamperType_USERDEFINED, IfcVibrationDamperType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcVibrationDamperTypeEnum (IfcEntityInstanceData&& e);
    IfcVibrationDamperTypeEnum (Value v);
    IfcVibrationDamperTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcVibrationIsolatorTypeEnum : public IfcUtil::IfcBaseType {
/// Enumeration defining the typical types of vibration isolators. 
///   The IfcVibrationIsolatorTypeEnum contains the following:
/// 
/// COMPRESSION:  Compression type vibration isolator.
///   SPRING:  Spring type vibration isolator.
///   USERDEFINED:  User-defined vibration isolator type.
///   NOTDEFINED:  Undefined vibration isolator type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
public:
    typedef enum {IfcVibrationIsolatorType_COMPRESSION, IfcVibrationIsolatorType_SPRING, IfcVibrationIsolatorType_BASE, IfcVibrationIsolatorType_USERDEFINED, IfcVibrationIsolatorType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcVibrationIsolatorTypeEnum (IfcEntityInstanceData&& e);
    IfcVibrationIsolatorTypeEnum (Value v);
    IfcVibrationIsolatorTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcVoidingFeatureTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration qualifies a voiding feature regarding its shape and configuration relative to the voided element.
/// 
/// HISTORY New type in IFC 2x4.
/// 
/// ENUMERATION
/// 
/// CUTOUT An internal cutout (creating an opening) or external cutout (creating a recess) of arbitrary shape.  The edges between cutting planes may be overcut or undercut, i.e. rounded.
///   NOTCH An external cutout of with a mostly rectangular cutting profile.  The edges between cutting planes may be overcut or undercut, i.e. rounded.
///   HOLE A circular or slotted or threaded hole, typically but not necessarily of smaller dimension than what would be considered a cutout.
///   MITER A skewed plane end cut, removing material across the entire profile of the voided element.
///   CHAMFER A skewed plane end cut, removing material only across a part of the profile of the voided element.
///   EDGE A shape modification along an edge of the element with the edge length as the predominant dimension of the feature, and feature profile dimensions which are typically much smaller than the edge length.  Can for example be a chamfer edge (differentiated from a chamfer by its ratio of dimensions and thus usually manufactured differently), rounded edge (a convex edge feature), or fillet edge (a concave edge feature).
///   USERDEFINED A user-defined type of voiding feature.
///   NOTDEFINED An undefined type of voiding feature.
public:
    typedef enum {IfcVoidingFeatureType_CUTOUT, IfcVoidingFeatureType_NOTCH, IfcVoidingFeatureType_HOLE, IfcVoidingFeatureType_MITER, IfcVoidingFeatureType_CHAMFER, IfcVoidingFeatureType_EDGE, IfcVoidingFeatureType_USERDEFINED, IfcVoidingFeatureType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcVoidingFeatureTypeEnum (IfcEntityInstanceData&& e);
    IfcVoidingFeatureTypeEnum (Value v);
    IfcVoidingFeatureTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWallTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different types of walls an IfcWallType object can
/// fulfill:
/// 
/// STANDARD: A standard wall, extruded vertically with a
/// constant thickness along the wall path.
/// POLYGONAL: A polygonal wall, extruded vertically,
/// where the wall thickness varies along the wall path.
/// SHEAR: A wall having a non-rectangular cross section
/// along the wall path.
/// 
/// NOTE The potentially misleading term shall not impose
/// a particular resistance against shear forces, but a particular
/// shape.
/// 
/// ELEMENTEDWALL: A stud wall framed with studs and faced
/// with sheatings, sidings, wallboard, or plasterwork.
/// PLUMBINGWALL: A pier, or enclosure, or encasement,
/// normally used to enclose plumbing in sanitary rooms.
/// MOVABLE: A movable wall that is either movable, e.g. a
/// folding wall, or a sliding wall, or can be easily removed as a
/// removable partitioning or mounting wall. Movable walls do
/// normally not define space boundaries and often belong to the
/// furnishing system.
/// USERDEFINED: User-defined wall element.
/// NOTDEFINED: Undefined wall element
/// 
/// HISTORY New
/// Enumeration in Release IFC2x Edition 2.
/// IFC2x2 ADDENDUM CHANGE
/// The enumerator POLYGON has been changed to
/// POLYGONAL.
/// IFC2x3 CHANGE The enumerators
/// ELEMENTEDWALL and PLUMBINGWALL have been
/// added.
/// IFC2x4 CHANGE New enumerator
/// MOVABLE has been added.
public:
    typedef enum {IfcWallType_MOVABLE, IfcWallType_PARAPET, IfcWallType_PARTITIONING, IfcWallType_PLUMBINGWALL, IfcWallType_SHEAR, IfcWallType_SOLIDWALL, IfcWallType_STANDARD, IfcWallType_POLYGONAL, IfcWallType_ELEMENTEDWALL, IfcWallType_RETAININGWALL, IfcWallType_WAVEWALL, IfcWallType_USERDEFINED, IfcWallType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWallTypeEnum (IfcEntityInstanceData&& e);
    IfcWallTypeEnum (Value v);
    IfcWallTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWasteTerminalTypeEnum : public IfcUtil::IfcBaseType {
/// The IfcWasteTerminalTypeEnum defines the range of different types of waste terminal that can be specified. 
///   HISTORY: New type in IFC 2x2.  GREASEINTERCEPTOR, OILINTERCEPTOR, PETROLINTERCEPTOR moved to IfcInterceptorTypeEnum in IFC2x4.
/// 
/// Enumeration 	 
/// 
/// FLOORTRAP: Pipe fitting, set into the floor, that retains liquid to prevent the passage of foul air 
/// FLOOORWASTE: Pipe fitting, set into the floor, that collects waste water and discharges it to a separate trap. 
/// GULLYSUMP: Pipe fitting or assembly of fittings to receive surface water or waste water, fitted with a grating or sealed cover. 
/// GULLYTRAP: Pipe fitting or assembly of fittings to receive surface water or waste water, fitted with a grating or sealed cover and discharging through a trap (BS6100 330 3504 modified). 
/// ROOFDRAIN: Pipe fitting, set into the roof, that collects rainwater for discharge into the rainwater system.  
/// WASTEDISPOSALUNIT: Electrically operated device that reduces kitchen or other waste into fragments small enough to be flushed into a drainage system. 
/// WASTETRAP: Pipe fitting, set adjacent to a sanitary terminal, that retains liquid to prevent the passage of foul air. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
public:
    typedef enum {IfcWasteTerminalType_FLOORTRAP, IfcWasteTerminalType_FLOORWASTE, IfcWasteTerminalType_GULLYSUMP, IfcWasteTerminalType_GULLYTRAP, IfcWasteTerminalType_ROOFDRAIN, IfcWasteTerminalType_WASTEDISPOSALUNIT, IfcWasteTerminalType_WASTETRAP, IfcWasteTerminalType_USERDEFINED, IfcWasteTerminalType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWasteTerminalTypeEnum (IfcEntityInstanceData&& e);
    IfcWasteTerminalTypeEnum (Value v);
    IfcWasteTerminalTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowPanelOperationEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic ways to describe how window panels operate, as shown in Figure 168. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// SideHungRightHand 
///   panel that opens to the right
///   when viewed from the outside 
///     
/// 
/// SideHungLeftHand 
///   panel that opens to the left
///   when viewed from the outside 
///     
/// 
/// TiltAndTurnRightHand 
///   panel that opens to the right
///   and is bottom hung 
///     
/// 
/// TiltAndTurnLeftHand 
///   panel that opens to the left
///   and is bottom hung 
///     
/// 
/// TopHung 
///   panel is top hung 
///     
/// 
/// BottomHung 
///   panel is bottom hung 
///     
/// 
/// PivotHorizontal 
///   panel is swinging
///   horizontally (hinges are in the middle) 
///     
/// 
/// PivotVertical 
///   panel is swinging vertically
///   (hinges are in the middle) 
///     
/// 
/// SlidingHorizontal 
///   panel is sliding horizontally
/// 
///   
/// 
/// SlidingVertical 
///   panel is sliding
///   vertically 
///     
/// 
/// RemovableCasement 
///   panel is removable 
///     
/// 
/// FixedCasement 
///   panel is fixed 
///     
/// 
/// OtherOperation 
///   user defined operation type 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 168 — Window panel operations
/// 
/// The opening direction of the window panels is given by the local placement of the IfcWindow. The positive y-axis determines the direction as shown in Figure 169.
///   NOTE 
/// 
/// Figures are shown as viewed from the outside (in direction of the
///   positive y-axis). 
///   Figures (symbolic representation) depend on the national building
///   code 
///   These figures are only shown as illustrations 
/// 
/// Figure 169 — Window panel directions
public:
    typedef enum {IfcWindowPanelOperation_SIDEHUNGRIGHTHAND, IfcWindowPanelOperation_SIDEHUNGLEFTHAND, IfcWindowPanelOperation_TILTANDTURNRIGHTHAND, IfcWindowPanelOperation_TILTANDTURNLEFTHAND, IfcWindowPanelOperation_TOPHUNG, IfcWindowPanelOperation_BOTTOMHUNG, IfcWindowPanelOperation_PIVOTHORIZONTAL, IfcWindowPanelOperation_PIVOTVERTICAL, IfcWindowPanelOperation_SLIDINGHORIZONTAL, IfcWindowPanelOperation_SLIDINGVERTICAL, IfcWindowPanelOperation_REMOVABLECASEMENT, IfcWindowPanelOperation_FIXEDCASEMENT, IfcWindowPanelOperation_OTHEROPERATION, IfcWindowPanelOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowPanelOperationEnum (IfcEntityInstanceData&& e);
    IfcWindowPanelOperationEnum (Value v);
    IfcWindowPanelOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowPanelPositionEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic configuration of the window type in terms of the location of window panels. The window configurations are given for windows with one, two or three panels (including fixed panels) as shown in Figure 170. It corresponds to the OperationType of the IfcWindowStyle definition, which references the IfcWindowPanelProperties. 
/// 
/// Windows which are subdivided into more than three panels have to be defined by the geometry only. The type of such windows is given by an IfcWindowStyle.OperationType = USERDEFINED or NOTDEFINED (see IfcWindowStyleOperationEnum for details). 
/// 
/// HISTORY New Enumeration in IFC Release 2.0.
/// 
/// Enumerator from IfcWindowStyleOperationEnum 
///   Use of enumerators from IfcWindowPanelPositionEnum 
///   Figure 
/// 
/// DoublePanelVertical 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// DoublePanelHorizontal 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelVertical 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = MIDDLEthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// TriplePanelHorizontal  
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = MIDDLEthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelBottom 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = RIGHTthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelTop 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = LEFTthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// TriplePanelLeft 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = TOPthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelRight 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = BOTTOMthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// Figure 170 — Window panel positions
/// 
/// NOTE 
/// 
/// The figures are shown as elevations in the XZ plane of the local
///   placement of the window, looking into the direction of the positive Y
///   axis. 
///   These figures are only shown as illustrations.
public:
    typedef enum {IfcWindowPanelPosition_LEFT, IfcWindowPanelPosition_MIDDLE, IfcWindowPanelPosition_RIGHT, IfcWindowPanelPosition_BOTTOM, IfcWindowPanelPosition_TOP, IfcWindowPanelPosition_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowPanelPositionEnum (IfcEntityInstanceData&& e);
    IfcWindowPanelPositionEnum (Value v);
    IfcWindowPanelPositionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowStyleConstructionEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
///   basic types of construction of windows. The construction
///   type relates to the main material (or material combination)
///   used for making the window.
/// 
/// HISTORY New Enumeration in
///   IFC Release 2x .
public:
    typedef enum {IfcWindowStyleConstruction_ALUMINIUM, IfcWindowStyleConstruction_HIGH_GRADE_STEEL, IfcWindowStyleConstruction_STEEL, IfcWindowStyleConstruction_WOOD, IfcWindowStyleConstruction_ALUMINIUM_WOOD, IfcWindowStyleConstruction_PLASTIC, IfcWindowStyleConstruction_OTHER_CONSTRUCTION, IfcWindowStyleConstruction_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowStyleConstructionEnum (IfcEntityInstanceData&& e);
    IfcWindowStyleConstructionEnum (Value v);
    IfcWindowStyleConstructionEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowStyleOperationEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic
///   configuration of the window type in terms of the number of window panels and
///   the subdivision of the total window. The window configurations are given for
///   windows with one, two or three panels (including fixed panels) as shown in Figure 171. 
///   Windows which are subdivided into more than three panels have to be
///   defined by the geometry only. The type of such windows is USERDEFINED. 
///   HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// SinglePanel 
///   Window with one
///   panel. 
/// 
/// DoublePanelVertical 
///   Window with two panels. The
///   configuration of the panels is vertically. 
/// 
/// DoublePanelHorizontal 
///   Window with two panels. The
///   configuration of the panels is horizontally. 
/// 
/// TriplePanelVertical 
///   Window with three panels. The
///   configuration of the panels is vertically. 
/// 
/// TriplePanelHorizontal  
///   Window with three panels. The
///   configuration of the panels is horizontally. 
/// 
/// TriplePanelBottom 
///   Window with three panels. The
///   configuration of two panels is vertically and the third one is horizontally at
///   the bottom. 
/// 
/// TriplePanelTop 
///   Window with three panels. The
///   configuration of two panels is vertically and the third one is horizontally at
///   the top. 
/// 
/// TriplePanelLeft 
///   Window with three panels. The
///   configuration of two panels is horizontally and the third one is vertically at
///   the left hand side. 
/// 
/// TriplePanelRight 
///   Window with three panels. The
///   configuration of two panels is horizontally and the third one is vertically at
///   the right hand side. 
/// 
/// UserDefined 
///   user defined operation
///   type 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 171 — Window style operations
/// 
/// NOTE 
/// 
/// The way how each panel operates is defined at the
///   IfcWindowPanelProperties.OperationType. 
///   The reference from the window panel to the location of that panel in
///   the window style configuration is handled by the
///   IfcWindowPanelProperties.PanelPosition. 
///   The figures are shown as elevations in the XZ plane of the local
///   placement of the window, looking into the direction of the positive Y
///   axis. 
///   These figures are only shown as illustrations
public:
    typedef enum {IfcWindowStyleOperation_SINGLE_PANEL, IfcWindowStyleOperation_DOUBLE_PANEL_VERTICAL, IfcWindowStyleOperation_DOUBLE_PANEL_HORIZONTAL, IfcWindowStyleOperation_TRIPLE_PANEL_VERTICAL, IfcWindowStyleOperation_TRIPLE_PANEL_BOTTOM, IfcWindowStyleOperation_TRIPLE_PANEL_TOP, IfcWindowStyleOperation_TRIPLE_PANEL_LEFT, IfcWindowStyleOperation_TRIPLE_PANEL_RIGHT, IfcWindowStyleOperation_TRIPLE_PANEL_HORIZONTAL, IfcWindowStyleOperation_USERDEFINED, IfcWindowStyleOperation_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowStyleOperationEnum (IfcEntityInstanceData&& e);
    IfcWindowStyleOperationEnum (Value v);
    IfcWindowStyleOperationEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowTypeEnum : public IfcUtil::IfcBaseType {
/// Definition from IAI: This enumeration defines the
/// different predefined types of an IfcWindowType object can
/// fulfill:
/// 
/// WINDOW: A standard window usually within a wall
/// opening, as a window panel in a curtain wall, or as a "free
/// standing" window.
/// SKYLIGHT: A window within a sloped building element,
/// usually a roof slab.
/// LIGHTDOME: A special window that lies horizonally in a
/// roof slab opening.
/// USERDEFINED: User-defined window element.
/// NOTDEFINED: Undefined window element
/// 
/// HISTORY New Enumeration
/// in IFC2x4.
public:
    typedef enum {IfcWindowType_WINDOW, IfcWindowType_SKYLIGHT, IfcWindowType_LIGHTDOME, IfcWindowType_USERDEFINED, IfcWindowType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowTypeEnum (IfcEntityInstanceData&& e);
    IfcWindowTypeEnum (Value v);
    IfcWindowTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWindowTypePartitioningEnum : public IfcUtil::IfcBaseType {
/// This enumeration defines the basic configuration of the window type in terms of the number of window panels and the subdivision of the total window as shown in Figure 70. The window configurations are given for windows with one, two or three panels (including fixed panels).
/// 
/// Windows which are subdivided into more than three panels have to be defined by the geometry only. The type of such windows is USERDEFINED.
/// 
/// HISTORY New Enumeration in IFC2x4.
/// NOTE The new IfcWindowTypePartitioningEnum replaces the use of
/// IfcWindowStyleOperationEnum that is deprecated from IFC2x4 onwards.
/// 
/// Enumerator
/// Description
/// Figure
/// 
/// SinglePanel
/// Window with one
/// panel.
/// 
/// DoublePanelVertical
/// Window with two panels.
/// The configuration of the panels is vertically.
/// 
/// DoublePanelHorizontal
/// Window with two panels.
/// The configuration of the panels is horizontally.
/// 
/// TriplePanelVertical
/// Window with three
/// panels. The configuration of the panels is vertically.
/// 
/// TriplePanelHorizontal
/// Window with three
/// panels. The configuration of the panels is horizontally.
/// 
/// TriplePanelBottom
/// Window with three
/// panels. The configuration of two panels is vertically and the
/// third one is horizontally at the bottom.
/// 
/// TriplePanelTop
/// Window with three
/// panels. The configuration of two panels is vertically and the
/// third one is horizontally at the top.
/// 
/// TriplePanelLeft
/// Window with three
/// panels. The configuration of two panels is horizontally and the
/// third one is vertically at the left hand side.
/// 
/// TriplePanelRight
/// Window with three
/// panels. The configuration of two panels is horizontally and the
/// third one is vertically at the right hand side.
/// 
/// UserDefined
/// user defined operation
/// type
/// 
/// NotDefined
/// 
/// Figure 70 — Window partitioning
/// 
/// NOTE
/// 
/// The way how each panel operates is defined at the
/// IfcWindowPanelProperties.OperationType.
/// The reference from the window panel to the location of that
/// panel in the window style configuration is handled by the
/// IfcWindowPanelProperties.PanelPosition.
/// The figures are shown as elevations in the XZ plane of the
/// local placement of the window, looking into the direction of the
/// positive Y axis.
/// These figures are only shown as illustrations
public:
    typedef enum {IfcWindowTypePartitioning_SINGLE_PANEL, IfcWindowTypePartitioning_DOUBLE_PANEL_VERTICAL, IfcWindowTypePartitioning_DOUBLE_PANEL_HORIZONTAL, IfcWindowTypePartitioning_TRIPLE_PANEL_VERTICAL, IfcWindowTypePartitioning_TRIPLE_PANEL_BOTTOM, IfcWindowTypePartitioning_TRIPLE_PANEL_TOP, IfcWindowTypePartitioning_TRIPLE_PANEL_LEFT, IfcWindowTypePartitioning_TRIPLE_PANEL_RIGHT, IfcWindowTypePartitioning_TRIPLE_PANEL_HORIZONTAL, IfcWindowTypePartitioning_USERDEFINED, IfcWindowTypePartitioning_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWindowTypePartitioningEnum (IfcEntityInstanceData&& e);
    IfcWindowTypePartitioningEnum (Value v);
    IfcWindowTypePartitioningEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWorkCalendarTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcWorkCalendarTypeEnum is an enumeration data type that specifies the types of work calendar from which the relevant control can be selected. If given it should help to identify base calendars.
/// 
/// HISTORY: Introduced in IFC2x4.
/// 
/// Enumeration:
/// 
/// FIRSTSHIFT: Belongs to the first shift
/// SECONDSHIFT: Belongs to the second shift
/// THIRDSHIFT: Belongs to the third shift
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcWorkCalendarType_FIRSTSHIFT, IfcWorkCalendarType_SECONDSHIFT, IfcWorkCalendarType_THIRDSHIFT, IfcWorkCalendarType_USERDEFINED, IfcWorkCalendarType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWorkCalendarTypeEnum (IfcEntityInstanceData&& e);
    IfcWorkCalendarTypeEnum (Value v);
    IfcWorkCalendarTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWorkPlanTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcWorkPlanTypeEnum is an enumeration data type that specifies the types of work plan from which the relevant control can be selected.
/// 
/// HISTORY  Introduced in IFC2x4. Derived from IfcWorkControlTypeEnum that was introduced in IFC Release 2.0.
/// 
/// Enumeration:
/// 
/// ACTUAL: A control in which actual items undertaken are indicated.
/// BASELINE: A control that is a baseline from which changes that are made later can be recognized.
/// PLANNED: A control showing planned items.
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcWorkPlanType_ACTUAL, IfcWorkPlanType_BASELINE, IfcWorkPlanType_PLANNED, IfcWorkPlanType_USERDEFINED, IfcWorkPlanType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWorkPlanTypeEnum (IfcEntityInstanceData&& e);
    IfcWorkPlanTypeEnum (Value v);
    IfcWorkPlanTypeEnum (const std::string& v);
    operator Value() const;
};
class IFC_PARSE_API IfcWorkScheduleTypeEnum : public IfcUtil::IfcBaseType {
/// An IfcWorkScheduleTypeEnum is an enumeration data type that specifies the types of work schedule from which the relevant control can be selected.
/// 
/// HISTORY  Introduced in IFC2x4. Derived from IfcWorkControlTypeEnum that was introduced in IFC Release 2.0.
/// 
/// Enumeration:
/// 
/// ACTUAL: A control in which actual items undertaken are indicated
/// BASELINE: A control that is a baseline from which changes that are made later can be recognized
/// PLANNED: A control showing planned items
/// USERDEFINED
/// NOTDEFINED
public:
    typedef enum {IfcWorkScheduleType_ACTUAL, IfcWorkScheduleType_BASELINE, IfcWorkScheduleType_PLANNED, IfcWorkScheduleType_USERDEFINED, IfcWorkScheduleType_NOTDEFINED} Value;
    static const char* ToString(Value v);
    static Value FromString(const std::string& s);

    virtual const IfcParse::enumeration_type& declaration() const;
    static const IfcParse::enumeration_type& Class();
    IfcWorkScheduleTypeEnum (IfcEntityInstanceData&& e);
    IfcWorkScheduleTypeEnum (Value v);
    IfcWorkScheduleTypeEnum (const std::string& v);
    operator Value() const;
};
/// IfcAbsorbedDoseMeasure is a measure of the absorbed radioactivity dose.
/// Usually measured in Gray (Gy, J/kg).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcAbsorbedDoseMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAbsorbedDoseMeasure (IfcEntityInstanceData&& e);
    IfcAbsorbedDoseMeasure (double v);
    operator double() const;
};
/// IfcAccelerationMeasure is a measure of acceleration.
/// Usually measured in m/s2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcAccelerationMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAccelerationMeasure (IfcEntityInstanceData&& e);
    IfcAccelerationMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: An amount of substance measure is the value for the quantity  of a substance when compared with the number of atoms in 0.012kilogram of carbon 12.
/// 
/// Usually measure in mole (mol).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: amount_of_substance_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcAmountOfSubstanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAmountOfSubstanceMeasure (IfcEntityInstanceData&& e);
    IfcAmountOfSubstanceMeasure (double v);
    operator double() const;
};
/// IfcAngularVelocityMeasure is a measure of the velocity of a body measured in terms of angle subtended per unit time.
/// Usually measured in radians/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcAngularVelocityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAngularVelocityMeasure (IfcEntityInstanceData&& e);
    IfcAngularVelocityMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcArcIndex : public  IfcUtil::IfcBaseType, public  IfcSegmentIndexSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcArcIndex (IfcEntityInstanceData&& e);
    IfcArcIndex (std::vector< int > /*[3:3]*/ v);
    operator std::vector< int > /*[3:3]*/() const;
};

class IFC_PARSE_API IfcAreaDensityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAreaDensityMeasure (IfcEntityInstanceData&& e);
    IfcAreaDensityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: An area measure is the value of the extent of a surface.
/// Usually measured in square metre (m2).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: area_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcAreaMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAreaMeasure (IfcEntityInstanceData&& e);
    IfcAreaMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcBinary : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcBinary (IfcEntityInstanceData&& e);
    IfcBinary (boost::dynamic_bitset<> v);
    operator boost::dynamic_bitset<>() const;
};
/// IfcBoolean is a defined data type of simple data type Boolean. It is required since a select type (IfcSimpleValue) cannot directly include simple types in its select list.  A boolean type can have value TRUE or FALSE.
/// 
/// Type: BOOLEAN
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcBoolean : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcModulusOfRotationalSubgradeReactionSelect, public  IfcModulusOfSubgradeReactionSelect, public  IfcModulusOfTranslationalSubgradeReactionSelect, public  IfcRotationalStiffnessSelect, public  IfcSimpleValue, public  IfcTranslationalStiffnessSelect, public  IfcValue, public  IfcWarpingStiffnessSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcBoolean (IfcEntityInstanceData&& e);
    IfcBoolean (bool v);
    operator bool() const;
};
/// An IfcCardinalPointReference is an index reference to
/// significant points of a section profile. This index is used to
/// describe the spatial relationship between the section of a member
/// and a reference axis of the same member.
/// 
/// HISTORY New Type in IFC2x4.
/// 
/// Indexes 1...9 refer to points at the bounding box of a
/// profile. Indexes 10...19 refer to points defined by geometric
/// centroid (usually centre of gravity) and shear centre, and their
/// combinations with bounding box coordinates. In particular, the
/// following index values are specified in this IFC Release:
/// 
/// bottom left
/// bottom centre
/// bottom right
/// mid-depth left
/// mid-depth centre
/// mid-depth right
/// top left
/// top centre
/// top right
/// geometric centroid
/// bottom in line with the geometric centroid
/// left in line with the geometric centroid
/// right in line with the geometric centroid
/// top in line with the geometric centroid
/// shear centre
/// bottom in line with the shear centre
/// left in line with the shear centre
/// right in line with the shear centre
/// top in line with the shear centre
/// 
/// Other index values are possible but outside the scope of this
/// specification.
/// 
/// Figure 283 illustrates cardinal point values.
/// 
/// Figure 283 — Cardinal point values
/// 
/// Figure 284 illustrates an example extrusion shape with arbitrary profile (IfcArbitraryClosedProfileDef), aligned "mid-depth right" on the member axis. The line of sight follows the extrusion direction Z which points into the drawing plane of above illustration. Hence, "left" is in the positive X direction of the IfcProfileDef. "Top" is in the positive Y direction of the IfcProfileDef.
/// 
/// Figure 284 — Cardinal point extrusion
class IFC_PARSE_API IfcCardinalPointReference : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCardinalPointReference (IfcEntityInstanceData&& e);
    IfcCardinalPointReference (int v);
    operator int() const;
};
/// IfcComplexNumber is a representation of a complex number expressed as an array with two elements.
///   The first element (index 1) denotes the real component which is the numerical
///   component of a complex number whose square roots can be calculated explicitly.
///   The second element (index 2) denotes the imaginary component which is the numerical
///   component of a complex number whose square roots cannot be determined other
///   than through the provision of the square of the imaginary number j where j^2 = -1.
///   Note that the imaginary component may be referred to as i in certain references.
/// 
/// Type: ARRAY [1:2] OF REAL
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcComplexNumber : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcComplexNumber (IfcEntityInstanceData&& e);
    IfcComplexNumber (std::vector< double > /*[1:2]*/ v);
    operator std::vector< double > /*[1:2]*/() const;
};
/// IfcCompoundPlaneAngleMeasure is a compound measure of plane angle in degrees, minutes, seconds, and optionally millionth-seconds of arc.
/// 
/// NOTE: IfcCompoundPlaneAngleMeasure is used where angles need to be described to an accuracy as fine as one millionth of a degree and expressed as parts of an arc. It may be used for angular measurement by surveyors or for other angular measurements where precision is required. Another usage is exact or approximate global positioning against a geographic coordinate systems using longitude and latitude.
/// 
/// NOTE: While the unit of measurement of the type IfcPlaneAngleMeasure depends on unit assignment (radian or degree or other derived units; globally at the IfcPoject or locally at an IfcMeasureWithUnit), the units of IfcCompoundPlaneAngleMeasure are always degrees, minutes, seconds, and millionth-seconds irrespective of unit assignments.
/// 
/// HISTORY New type in IFC Release 1.5.1.
/// 
/// Type: LIST [3:4] OF INTEGER
/// 
/// Value restrictions
/// 
/// The first integer measure is the number of degrees and is generally not range-restricted.  However, when IfcCompoundPlaneAngleMeasure is used to express geographic coordinates, only latitudes of [-90, 90] and longitudes of [-180, 180] are used in practice.
/// The second integer measure is the number of minutes and shall be in the range (-60, 60).
/// The third integer measure is the number of seconds and shall be in the range (-60, 60).
/// The optional fourth integer measure is the number of millionth-seconds and shall be in the range (-1 000 000, 1 000 000).
/// 
/// Signedness
/// 
/// All measure components have the same sign (positive or negative).  It is therefore trivial to convert between floating point representation (decimal degrees) and compound representation regardless whether the angle is greater or smaller than zero.  Example:
/// 
/// LOCAL
///   a : IfcPlaneAngleMeasure := -50.975864;  (* decimal degrees, -50° 58' 33" 110400 *)
///   b : IfcPlaneAngleMeasure;
///   c : IfcCompoundPlaneAngleMeasure;
///   s : IfcText;
/// END_LOCAL;
/// 
/// (* convert from float to compound *)
///   c[1] :=    a;                                           -- -50
///   c[2] :=   (a - c[1]) * 60;                              -- -58
///   c[3] :=  ((a - c[1]) * 60 - c[2]) * 60;                 -- -33
///   c[4] := (((a - c[1]) * 60 - c[2]) * 60 - c[3]) * 1.e6;  -- -110400
/// 
/// (* convert from compound to float *)
///   b := c[1] + c[2]/60. + c[3]/3600. + c[4]/3600.e6;       -- -50.975864
/// 
/// Use in string representations
/// 
/// When a compound plane angle measure is formatted for display or printout, the signs of the fractional components will usually be discarded because, to a human reader, the sign of the first component alone already indicates the sense of the angle:
/// 
/// (* convert from compound to human-readable string *)
///   s := FORMAT(c[1], '+##')     + "000000B0"
///      + FORMAT(ABS(c[2]), '##') + ''''
///      + FORMAT(ABS(c[3]), '##') + '"'
///      + FORMAT(ABS(c[4]), '##');  -- -50° 58' 33" 110400
/// 
/// Another often encountered display format of latitudes and longitudes is to omit the signs and print N, S, E, W indicators instead, for example, 50°58'33"S.  When stored as IfcCompoundPlaneAngleMeasure however, a compound plane angle measure is always signed, with same sign of all components.
class IFC_PARSE_API IfcCompoundPlaneAngleMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCompoundPlaneAngleMeasure (IfcEntityInstanceData&& e);
    IfcCompoundPlaneAngleMeasure (std::vector< int > /*[3:4]*/ v);
    operator std::vector< int > /*[3:4]*/() const;
};
/// Definition from ISO/CD 10303-41:1992: Is the value of a physical quantity as defined by an application context.
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: context_dependent_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcContextDependentMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcContextDependentMeasure (IfcEntityInstanceData&& e);
    IfcContextDependentMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A count measure is the value of a count.
/// Type: NUMBER
/// 
/// NOTE Corresponding ISO 10303 name: count_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcCountMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCountMeasure (IfcEntityInstanceData&& e);
    IfcCountMeasure (double v);
    operator double() const;
};
/// IfcCurvatureMeasure is a measure for curvature, which is defined as the change of slope per length.
///   This is typically a computed value in structural analysis.
///   It is usually measured in rad/m.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcCurvatureMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCurvatureMeasure (IfcEntityInstanceData&& e);
    IfcCurvatureMeasure (double v);
    operator double() const;
};
/// The lexical representation for date is the reduced (right truncated) lexical representation for dateTime: CCYY-MM-DD. No left truncation is allowed. An optional following time zone qualifier is allowed as for dateTime. To accommodate year values outside the range from 0001 to 9999, additional digits can be added to the left of this representation and a preceding "-" sign is allowed.
/// 
/// HISTORY: New type in IFC2x4
/// 
/// Use definitions
/// All given values should be provided in context and converted into a Gregorian date context and be shall be processable by a receiving application.
class IFC_PARSE_API IfcDate : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDate (IfcEntityInstanceData&& e);
    IfcDate (std::string v);
    operator std::string() const;
};
/// This lexical representation is the [ISO 8601] extended
///   format CCYY-MM-DDThh:mm:ss where "CC" represents the
///   century, "YY" the year, "MM" the month and "DD" the day,
///   preceded by an optional leading "-" sign to indicate a
///   negative number. If the sign is omitted, "+" is assumed.
///   The letter "T" is the date/time separator and "hh", "mm",
///   "ss" represent hour, minute and second respectively.
///   Additional digits can be used to increase the precision of
///   fractional seconds if desired i.e the format ss.ss... with
///   any number of digits after the decimal point is supported.
///   The fractional seconds part is optional; other parts of the
///   lexical form are not optional. To accommodate year values
///   greater than 9999 additional digits can be added to the
///   left of this representation. Leading zeros are required if
///   the year value would otherwise have fewer than four digits;
///   otherwise they are forbidden. The year 0000 is prohibited.
/// 
/// HISTORY: New type in IFC2x4
class IFC_PARSE_API IfcDateTime : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDateTime (IfcEntityInstanceData&& e);
    IfcDateTime (std::string v);
    operator std::string() const;
};
/// Definition from IAI: The IfcDayInMonthNumber is
/// an integer that defines the position of the specified day in a
/// month.
/// Type: INTEGER
/// NOTE Corresponding STEP
/// name: day_in_month_number, please refer to ISO/IS 10303-41:1994
/// for the final definition of the formal
/// standard.
/// HISTORY New type in IFC
/// Release 1.5.1.
/// IFC2x4 CHANGE Where rule
/// ValidRange added.
class IFC_PARSE_API IfcDayInMonthNumber : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDayInMonthNumber (IfcEntityInstanceData&& e);
    IfcDayInMonthNumber (int v);
    operator int() const;
};
/// Definition from IAI: The IfcDayInWeekNumber is
/// an integer that defines the position of the specified day in a
/// week. The positions have the following meaning (according to
/// ISO8601 "the calendar week") that assigns the ordinal day number
/// in the week to the Calender day name.
/// 
/// Ordinal day number
/// Calendar day
/// name
/// 
/// 01
/// Monday
/// 
/// 02
/// Tuesday
/// 
/// 03
/// Wednesday
/// 
/// 04
/// Thursday
/// 
/// 05
/// Friday
/// 
/// 06
/// Saturday
/// 
/// 07
/// Sunday
/// 
/// Type: INTEGER
/// HISTORY New type in
/// IFC2x4.
class IFC_PARSE_API IfcDayInWeekNumber : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDayInWeekNumber (IfcEntityInstanceData&& e);
    IfcDayInWeekNumber (int v);
    operator int() const;
};
/// Definition from ISO/CD 10303-41:1992: A descriptive measure is a human interpretable definition of a quantifiable value.
/// Type: STRING
/// 
/// NOTE Corresponding ISO 10303 name:descriptive_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcDescriptiveMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcSizeSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDescriptiveMeasure (IfcEntityInstanceData&& e);
    IfcDescriptiveMeasure (std::string v);
    operator std::string() const;
};
/// Definition from ISO/CD 10303-42:1992: A dimension count is a positive integer used to define the coordinate space dimensionality.  
/// 
/// The IfcDimensionCount is restricted to have the dimensionality of either 1, 2, or 3 - the WR1 had been added as an addition to the ISO 10303:42 entity dimension_count. In contrary to the ISO 10303:42 constraint, that all geometric representation items within a geometric representation context are forced to have the same dimension count, the IFC geometry allows mixed dimensions, particularly when defining the boundary of planar surfaces.  
/// 
/// NOTE Corresponding ISO 10303 type: dimension_count, please refer to ISO/IS 10303-42:1994, p. 14 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5
class IFC_PARSE_API IfcDimensionCount : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDimensionCount (IfcEntityInstanceData&& e);
    IfcDimensionCount (int v);
    operator int() const;
};
/// IfcDoseEquivalentMeasure is a measure of the radioactive dose equivalent.
/// Usually measured in Sievert (Sv, J/kg).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcDoseEquivalentMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDoseEquivalentMeasure (IfcEntityInstanceData&& e);
    IfcDoseEquivalentMeasure (double v);
    operator double() const;
};
/// String representation of a time duration according to ISO8601:2000 "Data elements and interchange formats - Information interchange - Representation of dates and times" as defined in section 5.5.3 "Representation of duration".
/// It is recommended to use the alternative format (section 5.5.4.2.2) in its extended version: PYYYY-MM-DDThh:mm:ss.
/// EXAMPLE: P0002-10-15T10:30:20 (duration of two years, 10 months, 15 days, 10 hours, 30 minutes and 20 seconds).
/// 
/// HISTORY: New type in IFC2x4
class IFC_PARSE_API IfcDuration : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcTimeOrRatioSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDuration (IfcEntityInstanceData&& e);
    IfcDuration (std::string v);
    operator std::string() const;
};
/// IfcDynamicViscosityMeasure is a measure of the viscous resistance of a medium.
/// 
/// Usually measured in Pascal second (Pa s).
/// Type: REAL 
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcDynamicViscosityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDynamicViscosityMeasure (IfcEntityInstanceData&& e);
    IfcDynamicViscosityMeasure (double v);
    operator double() const;
};
/// IfcElectricCapacitanceMeasure is a measure of the electric capacitance.
/// Usually measured in Farad (F, C/V = A s/V).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricCapacitanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricCapacitanceMeasure (IfcEntityInstanceData&& e);
    IfcElectricCapacitanceMeasure (double v);
    operator double() const;
};
/// IfcElectricChargeMeasure is a measure of the electric charge.
/// Usually measured in Coulomb (C, A s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricChargeMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricChargeMeasure (IfcEntityInstanceData&& e);
    IfcElectricChargeMeasure (double v);
    operator double() const;
};
/// IfcElectricConductanceMeasure is a measure of the electric conductance.
/// Usually measured in Siemens (S, 1/Ohm = A/V).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricConductanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricConductanceMeasure (IfcEntityInstanceData&& e);
    IfcElectricConductanceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: The value for the movement of electrically charged particles.
/// Usually measured in Ampere (A).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: electric_current_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcElectricCurrentMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricCurrentMeasure (IfcEntityInstanceData&& e);
    IfcElectricCurrentMeasure (double v);
    operator double() const;
};
/// IfcElectricResistanceMeasure is a measure of the electric resistance.
/// Usually measured in Ohm (V/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricResistanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricResistanceMeasure (IfcEntityInstanceData&& e);
    IfcElectricResistanceMeasure (double v);
    operator double() const;
};
/// IfcElectricVoltageMeasure is a measure of electromotive force.
/// Usually measured in Volts (V, W/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcElectricVoltageMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricVoltageMeasure (IfcEntityInstanceData&& e);
    IfcElectricVoltageMeasure (double v);
    operator double() const;
};
/// IfcEnergyMeasure is a measure of energy required or used.
/// Usually measured in Joules, (J, Nm).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcEnergyMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcEnergyMeasure (IfcEntityInstanceData&& e);
    IfcEnergyMeasure (double v);
    operator double() const;
};
/// Definition from CSS1 (W3C Recommendation): The font-style property selects between normal (sometimes
/// referred to as "roman" or "upright"), italic and oblique faces within a font family. Values are:
/// 
/// normal 
///   italic 
///   oblique
/// 
/// A value of 'normal' selects a font that is classified as 'normal' in the user agents font database, while 'oblique' selects a font that is labeled 'oblique'. A value of 'italic' selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'. The font that is labeled 'oblique' in the user agents font database may actually have been generated by electronically slanting a normal font.
/// 
/// Fonts with Oblique, Slanted or Incline in their names will typically be labeled 'oblique' in the user agents font database. Fonts with Italic, Cursive or Kursiv in their names will typically be labeled 'italic'.
/// 
/// NOTE  Corresponding CSS1 definitions is font-style.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcFontStyle : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontStyle (IfcEntityInstanceData&& e);
    IfcFontStyle (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The font-style property selects between normal and small-caps within a font family. Values are:
/// 
/// normal 
///   small-caps 
/// 
/// Another type of variation within a font family is the small-caps. In a small-caps font the lower case letters look similar to the uppercase ones, but in a smaller size and with slightly different proportions. The 'font-variant' property selects that font.
/// 
/// A value of 'normal' selects a font that is not a small-caps font, 'small-caps' selects a small-caps font. It is acceptable (but not required) in CSS1 if the small-caps font is a created by taking a normal font and replacing the lower case letters by scaled uppercase characters. As a last resort, uppercase letters will be used as replacement for a small-caps font.
/// 
/// NOTE  Corresponding CSS1 definitions is font-variant.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcFontVariant : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontVariant (IfcEntityInstanceData&& e);
    IfcFontVariant (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The 'font-weight' property selects the weight of the font. The values '100' to '900' form an ordered sequence, where each number indicates a weight that is at least as dark as its predecessor. The keyword 'normal' is synonymous with '400', and 'bold' is synonymous with '700'. Keywords other than 'normal' and 'bold' have been shown to be often confused with font names and a numerical scale was therefore chosen for the 9-value list. Values are:
/// 
/// normal 
///   bold 
///   100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900
/// 
/// Fonts (the font data) typically have one or more properties whose values are names that are descriptive of the "weight" of a font. There is no accepted, universal meaning to these weight names. Their primary role is to distinguish faces of differing darkness within a single font family. Usage across font families is quite variant; for example a font that you might think of as being bold might be described as being Regular, Roman, Book, Medium, Semi- or DemiBold, Bold, or Black, depending on how black the "normal" face of the font is within the design. Because there is no standard usage of names, the weight property values in CSS1 are given on a numerical scale in which the value '400' (or 'normal') corresponds to the "normal" text face for that family. The weight name associated with that face will typically be Book, Regular, Roman, Normal or sometimes Medium.
/// 
/// The association of other weights within a family to the numerical weight values is intended only to preserve the ordering of darkness within that family. However, the following heuristics tell how the assignment is done in typical cases:
/// 
/// If the font family already uses a numerical scale with nine values (such as with OpenType), the font weights should be mapped directly. 
///   If there is both a face labeled Medium and one labeled Book, Regular, Roman or Normal, then the Medium is normally assigned to the '500'. 
///   The font labeled "Bold" will often correspond to the weight value '700'. 
///   If there are fewer then 9 weights in the family, the default algorithm for filling the "holes" is as follows. If '500' is unassigned, it will be assigned the same font as '400'. If any of the values '600', '700', '800' or '900' remains unassigned, they are assigned to the same face as the next darker assigned keyword, if any, or the next lighter one otherwise. If any of '300', '200' or '100' remains unassigned, it is assigned to the next lighter assigned keyword, if any, or the next darker otherwise. 
/// 
/// The following two examples illustrate the process. Assume four weights in the "Example1" family, from lightest to darkest: Regular, Medium, Bold, Heavy. And assume six weights in the "Example2" family: Book, Medium, Bold, Heavy, Black, ExtraBlack. Note how in the second example it has been decided not to assign "Example2 ExtraBlack" to anything.
/// 
/// Available faces       | Assignments   | Filling the holes----------------------+---------------+-------------------"Example1 Regular"    | 400           | 100, 200, 300"Example1 Medium"     | 500           |"Example1 Bold"       | 700           | 600"Example1 Heavy"      | 800           | 900
/// Available faces       | Assignments   | Filling the holes----------------------+---------------+-------------------"Example2 Book"       | 400           | 100, 200, 300"Example2 Medium"     | 500           |"Example2 Bold"       | 700           | 600 "Example2 Heavy"      | 800           |"Example2 Black"      | 900           |"Example2 ExtraBlack" | (none)        |
/// 
/// NOTE  Corresponding CSS1 definitions is font-weight.
/// 
/// HISTORY  New type in IFC2x2 Addendum 2.
class IFC_PARSE_API IfcFontWeight : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontWeight (IfcEntityInstanceData&& e);
    IfcFontWeight (std::string v);
    operator std::string() const;
};
/// IfcForceMeasure is a measure of the force.
/// Usually measured in Newton (N, kg m/s2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcForceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcForceMeasure (IfcEntityInstanceData&& e);
    IfcForceMeasure (double v);
    operator double() const;
};
/// IfcFrequencyMeasure is a measure of the number of times that an item vibrates in unit time.
/// Usually measured in cycles/s or Herz (Hz).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcFrequencyMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFrequencyMeasure (IfcEntityInstanceData&& e);
    IfcFrequencyMeasure (double v);
    operator double() const;
};
/// An IfcGloballyUniqueId holds an encoded string identifier that is used to uniquely identify an IFC object. An IfcGloballyUniqueId is a Globally
///   Unique Identifier (GUID) which is an auto-generated 128-bit number. Since this identifier is
///   required for all IFC object instances, it is desirable to compress it to reduce overhead. The encoding of the base 64 character set is shown below:
/// 
///            1         2         3         4         5         6
///    0123456789012345678901234567890123456789012345678901234567890123
///   "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_$";
/// 
/// The resulting string is a fixed 22 character length string to be exchanged within the IFC exchange file structure.
/// 
/// Refer to the BuildingSMART website (www.buildingsmart-tech.org) for more information and sample encoding algorithms.
/// 
/// HISTORY  New type in IFC R1.5.1.
class IFC_PARSE_API IfcGloballyUniqueId : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcGloballyUniqueId (IfcEntityInstanceData&& e);
    IfcGloballyUniqueId (std::string v);
    operator std::string() const;
};
/// IfcHeatFluxDensityMeasure is a measure of the density of heat flux within a body.
/// Usually measured in W/m2 (J/s m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcHeatFluxDensityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcHeatFluxDensityMeasure (IfcEntityInstanceData&& e);
    IfcHeatFluxDensityMeasure (double v);
    operator double() const;
};
/// IfcHeatingValueMeasure defines the amount of energy released (usually in MJ/kg) when a fuel is burned.
/// 
/// HISTORY: This is new type in IFC2x2.
class IFC_PARSE_API IfcHeatingValueMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcHeatingValueMeasure (IfcEntityInstanceData&& e);
    IfcHeatingValueMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: An identifier is an alphanumeric string which allows an individual thing to be identified. It may not provide natural-language meaning.
/// 
/// Type: STRING of up to 255 characters
/// 
/// NOTE Corresponding STEP name: identifier, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// IFC 2x4 CHANGE: Previously recommended size restriction of 255 characters is now mandatory.
/// 
/// As a merely machine-readable string for identification purposes, an identifier is usually machine-generated and locale-independent (in contrast to human-readable labels, IfcLabel).
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcIdentifier is restricted to 255 characters, the size in exchange files after encoding may be considerably larger than 255 octets, depending on the particular encoding and on the contents of the identifier.
class IFC_PARSE_API IfcIdentifier : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIdentifier (IfcEntityInstanceData&& e);
    IfcIdentifier (std::string v);
    operator std::string() const;
};
/// IfcIlluminanceMeasure is a measure of the illuminance.
/// Usually measured in Lux (lx, Lumen/m2 = Candela Steradian/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcIlluminanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIlluminanceMeasure (IfcEntityInstanceData&& e);
    IfcIlluminanceMeasure (double v);
    operator double() const;
};
/// IfcInductanceMeasure is a measure of the inductance.
/// Usually measure in Henry (H, Weber/A = V s/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcInductanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcInductanceMeasure (IfcEntityInstanceData&& e);
    IfcInductanceMeasure (double v);
    operator double() const;
};
/// IfcInteger is a defined type of simple data type Integer. It is required since a select type (IfcSimpleValue) cannot include directly simple types in its select list.
/// 
/// In principle, the domain of IfcInteger (being an Integer) is all integer numbers. Here the number of bits used for the IfcInteger representation is unconstrained, but in practice it is implementation specific.
/// 
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcInteger : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcInteger (IfcEntityInstanceData&& e);
    IfcInteger (int v);
    operator int() const;
};
/// IfcIntegerCountRateMeasure is a measure of the integer number of units flowing per unit time.
/// 
/// EXAMPLE: This measure may be used for measuring integer units per second or per hour. For example, it may be used to measure the number of books per hour passing along a part of a mechanical book handling system, the number of people per hour travelling along a moving walkway or the number of vehicles per hour travelling along a section of road.
/// 
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcIntegerCountRateMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIntegerCountRateMeasure (IfcEntityInstanceData&& e);
    IfcIntegerCountRateMeasure (int v);
    operator int() const;
};
/// IfcIonConcentrationMeasure is a measure of particular ion concentration in a liquid, given in mg/L.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcIonConcentrationMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIonConcentrationMeasure (IfcEntityInstanceData&& e);
    IfcIonConcentrationMeasure (double v);
    operator double() const;
};
/// IfcIsothermalMoistureCapacityMeasure is a measure of isothermal moisture capacity.
/// Usually measured in m3/kg.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcIsothermalMoistureCapacityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIsothermalMoistureCapacityMeasure (IfcEntityInstanceData&& e);
    IfcIsothermalMoistureCapacityMeasure (double v);
    operator double() const;
};
/// IfcKinematicViscosityMeasure is a measure of the viscous resistance of a medium to a moving body.
/// Usually measured in m2/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcKinematicViscosityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcKinematicViscosityMeasure (IfcEntityInstanceData&& e);
    IfcKinematicViscosityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A label is the term by which something may be referred to.  It is a string which represents the human-interpretable name of something and shall have a natural-language meaning.
/// 
/// Type: STRING of up to 255 characters
/// 
/// NOTE Corresponding STEP name: label, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// IFC 2x4 CHANGE: Previously recommended size restriction of 255 characters is now mandatory.
/// 
/// As a human-readable string for naming purposes, a label is usually human-specified and locale-dependent (in contrast to purely machine-readable identifiers, IfcIdentifier).
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcLabel is restricted to 255 characters, the size in exchange files after encoding may be considerably larger than 255 octets, depending on the particular encoding and on the contents of the label.
class IFC_PARSE_API IfcLabel : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLabel (IfcEntityInstanceData&& e);
    IfcLabel (std::string v);
    operator std::string() const;
};
/// IfcLanguageId identifies the language in which a natural language text is expressed. It uses a language tag to identify the language.
/// The tag shall comply to the Internet Engineering Task Force (IETF) language tag as expressed in RFC 5646. A conforming program shall support the "simple language" subtag and the "language-region" tag format.
/// 
/// EXAMPLE  for simple language tags en (English), de (German), fr (France), or ja (Japanese), and for language-region tags en-US (English as used in United States), de-CH (German as used in German speaking part of Switzerland).
/// 
/// Type: IfcIdentifier
/// 
/// NOTE  The use of IfcLanguageId should conform to the use of language tags in HTML and XML as published by the W3C consortium.
/// 
/// HISTORY  New defined datatype in IFC2x4.
class IFC_PARSE_API IfcLanguageId : public  IfcIdentifier {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLanguageId (IfcEntityInstanceData&& e);
    IfcLanguageId (std::string v);
    operator std::string() const;
};
/// Definition from ISO/CD 10303-41:1992: A length measure is the value of a distance.
/// Usually measured in millimeters (mm).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: length_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcLengthMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcBendingParameterSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcSizeSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLengthMeasure (IfcEntityInstanceData&& e);
    IfcLengthMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcLineIndex : public  IfcUtil::IfcBaseType, public  IfcSegmentIndexSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLineIndex (IfcEntityInstanceData&& e);
    IfcLineIndex (std::vector< int > /*[2:?]*/ v);
    operator std::vector< int > /*[2:?]*/() const;
};
/// IfcLinearForceMeasure is a measure of linear force.
/// Usually measured in N/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearForceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearForceMeasure (IfcEntityInstanceData&& e);
    IfcLinearForceMeasure (double v);
    operator double() const;
};
/// IfcLinearMomentMeasure is a measure of linear moment.
/// Usually measured in Nm/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearMomentMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearMomentMeasure (IfcEntityInstanceData&& e);
    IfcLinearMomentMeasure (double v);
    operator double() const;
};
/// IfcLinearStiffnessMeasureA measure of linear stiffness.
/// Usually measured in N/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearStiffnessMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcTranslationalStiffnessSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearStiffnessMeasure (IfcEntityInstanceData&& e);
    IfcLinearStiffnessMeasure (double v);
    operator double() const;
};
/// IfcLinearVelocityMeasure is a measure of the velocity of a body measured in terms of distance moved per unit time.
/// Usually measured in m/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcLinearVelocityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearVelocityMeasure (IfcEntityInstanceData&& e);
    IfcLinearVelocityMeasure (double v);
    operator double() const;
};
/// IfcLogical</iL is a defined type of simple type Logical. It is required since a select type (IfcSimpleValue) cannot directly include simple types in its select list). Logical datatype can have values TRUE, FALSE or UNKNOWN.
/// 
/// Type: LOGICAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLogical : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLogical (IfcEntityInstanceData&& e);
    IfcLogical (boost::logic::tribool v);
    operator boost::logic::tribool() const;
};
/// IfcLuminousFluxMeasure is a measure of the luminous flux.
/// Usually measured in Lumen (lm, Candela Steradian).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLuminousFluxMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousFluxMeasure (IfcEntityInstanceData&& e);
    IfcLuminousFluxMeasure (double v);
    operator double() const;
};
/// IfcLuminousIntensityDistributionMeasure is a measure of the luminous intensity of a light source that changes according to the direction of the ray. It is normally based on some standardized distribution light distribution curves. 
/// 
/// Usually measured in Candela/Lumen (cd/lm) or (cd/klm).  
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcLuminousIntensityDistributionMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousIntensityDistributionMeasure (IfcEntityInstanceData&& e);
    IfcLuminousIntensityDistributionMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A luminous intensity measure is the value for the brightness of a body.
/// Usually measured in candela (cd).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: luminous_intensity_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcLuminousIntensityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousIntensityMeasure (IfcEntityInstanceData&& e);
    IfcLuminousIntensityMeasure (double v);
    operator double() const;
};
/// IfcMagneticFluxDensityMeasure is a measure of the magnetic flux density.
/// Usually measured in Tesla (T, Weber/m2 = V s/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMagneticFluxDensityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMagneticFluxDensityMeasure (IfcEntityInstanceData&& e);
    IfcMagneticFluxDensityMeasure (double v);
    operator double() const;
};
/// IfcMagneticFluxMeasure is a measure of the magnetic flux.
/// Usually measured in Weber (Wb, V s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMagneticFluxMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMagneticFluxMeasure (IfcEntityInstanceData&& e);
    IfcMagneticFluxMeasure (double v);
    operator double() const;
};
/// IfcMassDensityMeasure is a measure of the density of a medium.
/// Usually measured in kg/m3.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMassDensityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassDensityMeasure (IfcEntityInstanceData&& e);
    IfcMassDensityMeasure (double v);
    operator double() const;
};
/// IfcMassFlowRateMeasure is a measure of the mass of a medium flowing per unit time.
/// Usually measured in kg/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMassFlowRateMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassFlowRateMeasure (IfcEntityInstanceData&& e);
    IfcMassFlowRateMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A mass measure is the value of the amount of matter that a body contains.
/// Usually measured in kilograms (kg) or grams (g).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: mass_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcMassMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassMeasure (IfcEntityInstanceData&& e);
    IfcMassMeasure (double v);
    operator double() const;
};
/// IfcMassPerLengthMeasure is a measure for mass per length. For example for rolled steel profiles the weight of
///   an imaginary beam is usually expressed by kg/m length for cost calculation and
///   structural analysis purposes.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcMassPerLengthMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassPerLengthMeasure (IfcEntityInstanceData&& e);
    IfcMassPerLengthMeasure (double v);
    operator double() const;
};
/// IfcModulusOfElasticityMeasure is a measure of modulus of elasticity.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcModulusOfElasticityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfElasticityMeasure (IfcEntityInstanceData&& e);
    IfcModulusOfElasticityMeasure (double v);
    operator double() const;
};
/// IfcModulusOfLinearSubgradeReactionMeasure is a measure for modulus of linear subgrade reaction, which expresses the elastic bedding of a linear structural element per length, such as for a beam. It is typically measured in N/m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcModulusOfLinearSubgradeReactionMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcModulusOfTranslationalSubgradeReactionSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfLinearSubgradeReactionMeasure (IfcEntityInstanceData&& e);
    IfcModulusOfLinearSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcModulusOfRotationalSubgradeReactionMeasure is a measure for modulus of rotational subgrade reaction, which expresses the rotational elastic bedding of a linear structural element per length, such as for a beam. It is typically measured in Nm/(m*rad). 
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcModulusOfRotationalSubgradeReactionMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcModulusOfRotationalSubgradeReactionSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfRotationalSubgradeReactionMeasure (IfcEntityInstanceData&& e);
    IfcModulusOfRotationalSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcModulusOfSubgradeReactionMeasure is a geotechnical measure describing interaction between foundation structures and the soil. May also be known as bedding measure. 
///   Usually measured in N/m3.  
///   Type: REAL  
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// Figure 290 illustrates elastic support of a planar member.
/// 
/// Figure 290 — Modulus of subgrade reaction measure
class IFC_PARSE_API IfcModulusOfSubgradeReactionMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcModulusOfSubgradeReactionSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfSubgradeReactionMeasure (IfcEntityInstanceData&& e);
    IfcModulusOfSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcMoistureDiffusivityMeasure is a measure of moisture diffusivity.
/// Usually measured in m3/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMoistureDiffusivityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMoistureDiffusivityMeasure (IfcEntityInstanceData&& e);
    IfcMoistureDiffusivityMeasure (double v);
    operator double() const;
};
/// IfcMolecularWeightMeasure is a measure of molecular weight of material (typically gas).
/// Usually measured in g/mole.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMolecularWeightMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMolecularWeightMeasure (IfcEntityInstanceData&& e);
    IfcMolecularWeightMeasure (double v);
    operator double() const;
};
/// IfcMomentOfInertiaMeasure is a measure of moment of inertia.
/// Usually measured in m4.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMomentOfInertiaMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMomentOfInertiaMeasure (IfcEntityInstanceData&& e);
    IfcMomentOfInertiaMeasure (double v);
    operator double() const;
};
/// A monetary measure is the value of an amount of money without regard to its currency.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMonetaryMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMonetaryMeasure (IfcEntityInstanceData&& e);
    IfcMonetaryMeasure (double v);
    operator double() const;
};
/// Definition from IAI: The IfcDayInMonthNumber is
/// an integer that defines the position of the specified month in a
/// year. The positions have the following meaning (according to
/// ISO8601 "calendar month") that assigns the Calendar month number
/// to the Calender month name.
/// NOTE Refer to ISO 8601 for the definitions for
/// using the Gregorian calendar as the standard for the
/// identification of calendar days.
/// 
/// Calendar month number
/// Calendar month
/// name
/// 
/// 01
/// January
/// 
/// 02
/// February
/// 
/// 03
/// March
/// 
/// 04
/// April
/// 
/// 05
/// May
/// 
/// 06
/// June
/// 
/// 07
/// July
/// 
/// 08
/// August
/// 
/// 09
/// September
/// 
/// 10
/// October
/// 
/// 11
/// November
/// 
/// 12
/// December
/// 
/// Type: INTEGER
/// NOTE Corresponding STEP
/// name: month_in_year_number, please refer to ISO/IS 10303-41:1994
/// for the final definition of the formal
/// standard.
/// HISTORY New type in IFC
/// Release 1.5.1.
class IFC_PARSE_API IfcMonthInYearNumber : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMonthInYearNumber (IfcEntityInstanceData&& e);
    IfcMonthInYearNumber (int v);
    operator int() const;
};
/// A non-negative length measure is a length measure that is greater than or equal to zero.
/// 
/// Type: IfcLengthMeasure
/// 
/// HISTORY New type in IFC Release 2x4.
class IFC_PARSE_API IfcNonNegativeLengthMeasure : public  IfcLengthMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcNonNegativeLengthMeasure (IfcEntityInstanceData&& e);
    IfcNonNegativeLengthMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A numeric measure is the numeric value of a physical quantity.
/// Type: NUMBER
/// 
/// NOTE Corresponding ISO 10303 name: numeric_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcNumericMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcNumericMeasure (IfcEntityInstanceData&& e);
    IfcNumericMeasure (double v);
    operator double() const;
};
/// IfcPHMeasure is a measure of the molar hydrogen ion concentration in a liquid (usually defined as the measure of acidity) in a range from 0 to 14.
/// 
/// HISTORY: New type in IFC 2x2.
class IFC_PARSE_API IfcPHMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPHMeasure (IfcEntityInstanceData&& e);
    IfcPHMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A parameter value is the value which specifies the amount of a 
/// parameter in some parameter space.
/// Type: REAL
/// 
/// NOTE Corresponding STEP name: parameter_value, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcParameterValue : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcTrimmingSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcParameterValue (IfcEntityInstanceData&& e);
    IfcParameterValue (double v);
    operator double() const;
};
/// IfcPlanarForceMeasure is a measure of force on an area.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcPlanarForceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPlanarForceMeasure (IfcEntityInstanceData&& e);
    IfcPlanarForceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A plane angle measure is the value of an angle in a plane.
/// 
/// Usually measured in radian (rad, m/m = 1), but also grads may be used. The grad unit may be declared as a conversion based unit based on radian unit.
/// 
/// NOTE IfcPlaneAngleMeasure is used where angles need to be described to an accuracy of less than one degree and expressed as decimal parts of an angle. It is widely used for angular measurement except for situations where accuracy needs to be defined using arc measurement; for which purpose the IfcCompoundPlaneAngleMeasure is provided.
/// 
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: plane_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPlaneAngleMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcBendingParameterSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPlaneAngleMeasure (IfcEntityInstanceData&& e);
    IfcPlaneAngleMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcPositiveInteger : public  IfcInteger {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositiveInteger (IfcEntityInstanceData&& e);
    IfcPositiveInteger (int v);
    operator int() const;
};
/// Definition from ISO/CD 10303-41:1992: A positive length measure is a length measure that is greater than zero.
/// Type: IfcLengthMeasure
/// 
/// NOTE Corresponding ISO 10303 name: positive_length_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositiveLengthMeasure : public  IfcLengthMeasure, public  IfcHatchLineDistanceSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositiveLengthMeasure (IfcEntityInstanceData&& e);
    IfcPositiveLengthMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: Positive plane angle measure is a plane angle measure that is greater than zero.
/// Type: IfcPlaneAngleMeasure 
/// 
/// NOTE Corresponding STEP name: positive_plane_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositivePlaneAngleMeasure : public  IfcPlaneAngleMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositivePlaneAngleMeasure (IfcEntityInstanceData&& e);
    IfcPositivePlaneAngleMeasure (double v);
    operator double() const;
};
/// IfcPowerMeasure is a measure of power required or used.
/// Usually measured in Watts (W, J/s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcPowerMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPowerMeasure (IfcEntityInstanceData&& e);
    IfcPowerMeasure (double v);
    operator double() const;
};
/// IfcPresentableText is a text string used to capture the content of a text literal for the purpose of presentation. The IfcPresentableText can include multiple lines of text, for which the line feed character LF, 0x0A, should be used to separate lines.
/// 
/// NOTE  The non printable characters are converted within the standard exchange format ISO 10303-21 (STEP physical file format), commonly the \X\09 represents the TAB, and \X\0A the LF character.
/// 
/// NOTE  The IfcPresentableText is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE  Corresponding ISO 10303 name: presentable_text. Please refer to ISO/IS 10303-46:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
class IFC_PARSE_API IfcPresentableText : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPresentableText (IfcEntityInstanceData&& e);
    IfcPresentableText (std::string v);
    operator std::string() const;
};
/// IfcPressureMeasure is a measure of the quantity of a medium acting on a unit area.
/// Usually measured in Pascals (Pa, N/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcPressureMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPressureMeasure (IfcEntityInstanceData&& e);
    IfcPressureMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcPropertySetDefinitionSet : public  IfcUtil::IfcBaseType, public  IfcPropertySetDefinitionSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPropertySetDefinitionSet (IfcEntityInstanceData&& e);
    IfcPropertySetDefinitionSet (aggregate_of< ::Ifc4x3_rc1::IfcPropertySetDefinition >::ptr v);
    operator aggregate_of< ::Ifc4x3_rc1::IfcPropertySetDefinition >::ptr() const;
};
/// IfcRadioActivityMeasure is a measure of activity of radionuclide.
/// Usually measured in Becquerel (Bq, 1/s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRadioActivityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRadioActivityMeasure (IfcEntityInstanceData&& e);
    IfcRadioActivityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A ratio measure is the value of the relation between two 
/// physical quantities that are of the same kind.
/// 
/// NOTE: Input given in percent is to be divided by 100% when stored as an IfcRatioMeasure. For example, 25% becomes 0.25.
/// 
/// Type: REAL
/// 
/// NOTE Corresponding STEP name: ratio_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcRatioMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcSizeSelect, public  IfcTimeOrRatioSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRatioMeasure (IfcEntityInstanceData&& e);
    IfcRatioMeasure (double v);
    operator double() const;
};
/// IfcReal is a defined type of simple data type REAL.  It is required since a select type (IfcSimpleValue), cannot directly include simple types in its select list.
/// 
/// In principle, the domain of IfcReal (being a Real) is all rational, irrational and scientific real numbers. Here the precision is unconstrained, but in practice it is implementation specific.
/// 
/// Type: REAL
/// 
/// HISTORY: New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcReal : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcReal (IfcEntityInstanceData&& e);
    IfcReal (double v);
    operator double() const;
};
/// IfcRotationalFrequencyMeasure is a measure of the number of cycles that an item revolves in unit time.
/// Usually measured in cycles/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRotationalFrequencyMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalFrequencyMeasure (IfcEntityInstanceData&& e);
    IfcRotationalFrequencyMeasure (double v);
    operator double() const;
};
/// The rotational mass measure denotes the inertia of a body with respect to angular acceleration.
/// It is usually measured in kg*m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcRotationalMassMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalMassMeasure (IfcEntityInstanceData&& e);
    IfcRotationalMassMeasure (double v);
    operator double() const;
};
/// IfcRotationalStiffnessMeasure is a measure of rotational stiffness.
/// Usually measured in Nm/rad.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRotationalStiffnessMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcRotationalStiffnessSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalStiffnessMeasure (IfcEntityInstanceData&& e);
    IfcRotationalStiffnessMeasure (double v);
    operator double() const;
};
/// IfcSectionModulusMeasure is a measure for the resistance of a cross section against bending or torsional moment.  It is usually measured in m^3.
/// 
/// Type: REAL 
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcSectionModulusMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSectionModulusMeasure (IfcEntityInstanceData&& e);
    IfcSectionModulusMeasure (double v);
    operator double() const;
};
/// The sectional area integral measure is typically used in torsional analysis. It is usually measured in m^5.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSectionalAreaIntegralMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSectionalAreaIntegralMeasure (IfcEntityInstanceData&& e);
    IfcSectionalAreaIntegralMeasure (double v);
    operator double() const;
};
/// IfcShearModulusMeasure is a measure of shear modulus.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcShearModulusMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcShearModulusMeasure (IfcEntityInstanceData&& e);
    IfcShearModulusMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A solid angle measure is the value of an angle in a solid.
/// Usually measured in Steradians, (sr, m2/m2).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: solid_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcSolidAngleMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSolidAngleMeasure (IfcEntityInstanceData&& e);
    IfcSolidAngleMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcSoundPowerLevelMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPowerLevelMeasure (IfcEntityInstanceData&& e);
    IfcSoundPowerLevelMeasure (double v);
    operator double() const;
};
/// A sound power measure is a measure of total radiated noise with units of decibels with a reference value of picowatts.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSoundPowerMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPowerMeasure (IfcEntityInstanceData&& e);
    IfcSoundPowerMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcSoundPressureLevelMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPressureLevelMeasure (IfcEntityInstanceData&& e);
    IfcSoundPressureLevelMeasure (double v);
    operator double() const;
};
/// A sound pressure measure is a measure of the pressure fluctuations superimposed over the ambient pressure level with units of decibels with a reference value of micropascals. 
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSoundPressureMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPressureMeasure (IfcEntityInstanceData&& e);
    IfcSoundPressureMeasure (double v);
    operator double() const;
};
/// IfcSpecificHeatCapacityMeasure defines the specific heat of material: The heat energy absorbed per temperature unit.
/// Usually measured in J / kg Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcSpecificHeatCapacityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecificHeatCapacityMeasure (IfcEntityInstanceData&& e);
    IfcSpecificHeatCapacityMeasure (double v);
    operator double() const;
};
/// The IfcSpecularExponent defines the datatype for exponent determining the sharpness of the 'reflection'. reflection is made sharper with large values of the exponent, such as 10.0. Small values, such as 1.0, decrease the specular fall-off. 
/// 
/// IfcSpecularExponent is of type REAL.
/// 
/// NOTE: The datatype relates to the definition of specular_exponent in ISO 10303-46 entity surface_style_reflectance_ambient_diffuse_specular.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcSpecularExponent : public  IfcUtil::IfcBaseType, public  IfcSpecularHighlightSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecularExponent (IfcEntityInstanceData&& e);
    IfcSpecularExponent (double v);
    operator double() const;
};
/// The IfcSpecularRoughness defines the datatype for the reflection resulting from the roughness of a surface through the height of surface impurities where the specular highlight is made sharper with small values for the roughness, such as 0.1.  
/// 
/// Applies to "glass", "metal", "mirror" and "plastic" reflection models. Larger values, close to 1.0 decrease the specular fall-off. 
/// 
/// IfcSpecularRoughness is of type REAL. It is constraint to values between (and including) 0 and 1.
/// 
/// NOTE: The datatype relates to the definition of "shiness" in VRML97, which is the reciprocate value to the specular roughness.
/// 
/// HISTORY: New type in Release IFC2x2.
class IFC_PARSE_API IfcSpecularRoughness : public  IfcUtil::IfcBaseType, public  IfcSpecularHighlightSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecularRoughness (IfcEntityInstanceData&& e);
    IfcSpecularRoughness (double v);
    operator double() const;
};
/// The temperature gradient measures the difference of a temperature per lenght, as for instance used in an external wall or its layers.  It is usually measured in K/m.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcTemperatureGradientMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTemperatureGradientMeasure (IfcEntityInstanceData&& e);
    IfcTemperatureGradientMeasure (double v);
    operator double() const;
};
/// The temperature rate of change measures the difference of a temperature per time (positive: rise, negative: fall), as for instance used with heat sensors. It is for example measured in K/s (Kelvin per second).
/// 
/// Type: REAL 
/// 
/// HISTORY  New type in IFC2x4.
class IFC_PARSE_API IfcTemperatureRateOfChangeMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTemperatureRateOfChangeMeasure (IfcEntityInstanceData&& e);
    IfcTemperatureRateOfChangeMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A text is an alphanumeric string of characters which is intended to be read and understood by a human being. It is for information purposes only.
/// 
/// Type: STRING
/// 
/// NOTE Corresponding STEP name: text, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcText is not formally restricted in length, the size of a string in ISO 10303-21:2002 conforming exchange files must not exceed 32767 octets after encoding and escaping.
class IFC_PARSE_API IfcText : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcText (IfcEntityInstanceData&& e);
    IfcText (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes how text is aligned within the element. The actual justification algorithm used is user agent and human language dependent. If 'justify' is not supported, the user agent will supply a replacement. Typically, this will be 'left' for western languages. Values are:
/// 
/// left
///   right
///   center
///   justify
/// 
/// NOTE  Corresponding CSS1 definition is text-align.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextAlignment : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextAlignment (IfcEntityInstanceData&& e);
    IfcTextAlignment (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes decorations that are added to the text of an element. A value of 'blink' causes the text to blink.. Values are:
/// 
/// none
///   underline
///   overline
///   line-through
///   blink
/// 
/// User agents must recognize the keyword 'blink', but are not required to support the blink effect.
/// 
/// NOTE  Corresponding CSS1 definition is text-decoration.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextDecoration : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextDecoration (IfcEntityInstanceData&& e);
    IfcTextDecoration (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The value is a font family name and/or generic family name. Values are:
/// 
/// The name of a font family of choice. For example, "gill" and "helvetica" are font families.
/// 
/// In the example above, the last value is a generic family name. The following generic families are defined:
/// 
/// 'serif' (Example: Times)
///   'sans-serif' (Example: Helvetica)
///   'cursive' (Example: Zapf-Chancery)
///   'fantasy' (Example: Western)
///   'monospace' (Example: Courier)
/// 
/// It is encouraged to offer a generic font family as a last alternative.
/// 
/// NOTE  Corresponding CSS1 definitions are font-family.
/// 
/// HISTORY  New type in IFC2x2 Addendum 2.
/// 
/// IFC2x2 Addendum 2 CHANGE: The IfcFontFamily has been added.
class IFC_PARSE_API IfcTextFontName : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextFontName (IfcEntityInstanceData&& e);
    IfcTextFontName (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes how the cases of characters are handled. Values are:
/// 
/// capitalize: uppercases the first character of each word
///   uppercase: uppercases all letters of the element
///   lowercase: lowercases all letters of the element
///   none
/// 
/// NOTE  Corresponding CSS1 definition is text-transform.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextTransformation : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextTransformation (IfcEntityInstanceData&& e);
    IfcTextTransformation (std::string v);
    operator std::string() const;
};
/// IfcThermalAdmittanceMeasure is the measure of the ability of a surface to smooth out temperature variations.
/// Usually measured in Watt / m2 Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalAdmittanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalAdmittanceMeasure (IfcEntityInstanceData&& e);
    IfcThermalAdmittanceMeasure (double v);
    operator double() const;
};
/// IfcThermalConductivityMeasure is a measure of thermal conductivity.
/// Usually measured in Watt / m Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcThermalConductivityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalConductivityMeasure (IfcEntityInstanceData&& e);
    IfcThermalConductivityMeasure (double v);
    operator double() const;
};
/// IfcThermalExpansionCoeffientMeasure is a measure of the thermal expansion coefficient of a material, which expresses its elongation (as a ratio) per temperature difference. It is usually measured in 1/K. A positive elongation per (positive) rise of temperature is expressed by a positive value.
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcThermalExpansionCoefficientMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalExpansionCoefficientMeasure (IfcEntityInstanceData&& e);
    IfcThermalExpansionCoefficientMeasure (double v);
    operator double() const;
};
/// IfcThermalResistanceMeasure is a measure of the resistance offered by a body to the flow of energy.
/// Usually measured in m2 Kelvin/Watt.
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalResistanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalResistanceMeasure (IfcEntityInstanceData&& e);
    IfcThermalResistanceMeasure (double v);
    operator double() const;
};
/// IfcThermalTransmittanceMeasure is a measure of the rate at which energy is transmitted through a body.
/// Usually measured in Watts/m2 Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalTransmittanceMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalTransmittanceMeasure (IfcEntityInstanceData&& e);
    IfcThermalTransmittanceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A thermodynamic temperature measure is the value for the degree of heat of a body.
/// Usually measured in degrees Kelvin (K).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: thermodynamic_temperature_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcThermodynamicTemperatureMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermodynamicTemperatureMeasure (IfcEntityInstanceData&& e);
    IfcThermodynamicTemperatureMeasure (double v);
    operator double() const;
};
/// The lexical representation for time is the left truncated
///   lexical representation for dateTime: hh:mm:ss.sss with
///   optional following time zone indicator. For example, to
///   indicate 1:20 pm for Eastern Standard Time which is 5 hours
///   behind Coordinated Universal Time (UTC), one would write:
///   13:20:00-05:00.
/// 
/// HISTORY: New type in IFC2x4
class IFC_PARSE_API IfcTime : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTime (IfcEntityInstanceData&& e);
    IfcTime (std::string v);
    operator std::string() const;
};
/// Definition from ISO/CD 10303-41:1992: A time measure is the value of the duration of periods.
/// Measured in seconds (s) or days (d) or other units of time.
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: time_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcTimeMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTimeMeasure (IfcEntityInstanceData&& e);
    IfcTimeMeasure (double v);
    operator double() const;
};
/// IfcTimeStamp is an indication of date and time by measuring the number of seconds which have elapsed since the beginning of the year 1970.
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcTimeStamp : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMetricValueSelect, public  IfcSimpleValue, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTimeStamp (IfcEntityInstanceData&& e);
    IfcTimeStamp (int v);
    operator int() const;
};
/// IfcTorqueMeasure is a measure of the torque or moment of a couple.
/// Usually measured in N m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcTorqueMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTorqueMeasure (IfcEntityInstanceData&& e);
    IfcTorqueMeasure (double v);
    operator double() const;
};
/// IfcURIReference provides for identifying a Uniform Resource Identifier, URI, as defined by the RFC3986 of the Network Working Group. A URI can be classified as a locator or a name or both, that is it may comprise a Uniform Resource Locator (URL) and/or a Uniform Resource Name (URN).
/// 
/// A Uniform Resource Locator, URL, is a string conforming to a standardized format, which refers to a resource on the internet (such as a document or an image) by its location.
/// A Uniform Resource Name, URN, is intended to serve as persistent, location-independent resource identifier and is
/// designed to make it easy to map other namespaces (that share the properties of URNs) into URN-space.
/// 
/// HISTORY New defined datatype in IFC 2x4.
class IFC_PARSE_API IfcURIReference : public  IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcURIReference (IfcEntityInstanceData&& e);
    IfcURIReference (std::string v);
    operator std::string() const;
};
/// IfcVaporPermeabilityMeasure is a measure of vapor permeability.
/// Usually measured in kg / s m Pascal.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcVaporPermeabilityMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVaporPermeabilityMeasure (IfcEntityInstanceData&& e);
    IfcVaporPermeabilityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A volume measure is the value of the solid content of a body.
/// Usually measured in cubic metre (m3).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: volume_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcVolumeMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVolumeMeasure (IfcEntityInstanceData&& e);
    IfcVolumeMeasure (double v);
    operator double() const;
};
/// IfcVolumetricFlowRateMeasure is a measure of the volume of a medium flowing per unit time.
/// Usually measured in m3/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcVolumetricFlowRateMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVolumetricFlowRateMeasure (IfcEntityInstanceData&& e);
    IfcVolumetricFlowRateMeasure (double v);
    operator double() const;
};
/// IfcWarpingConstantMeasure is a measure for the warping constant or warping resistance of a cross section under torsional loading. It is usually measured in m^6.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcWarpingConstantMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcWarpingConstantMeasure (IfcEntityInstanceData&& e);
    IfcWarpingConstantMeasure (double v);
    operator double() const;
};
/// The warping moment measure is a measure for the warping moment, which occurs in warping torsional analysis. It is usually measured in kN*m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcWarpingMomentMeasure : public  IfcUtil::IfcBaseType, public  IfcAppliedValueSelect, public  IfcDerivedMeasureValue, public  IfcMetricValueSelect, public  IfcValue, public  IfcWarpingStiffnessSelect {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcWarpingMomentMeasure (IfcEntityInstanceData&& e);
    IfcWarpingMomentMeasure (double v);
    operator double() const;
};
/// The box alignment specifies the alignment of the text box relative to its position. The following string values shall be used:
/// 
/// top-left
///   top-middle
///   top-right
///   middle-left
///   center
///   middle-right
///   bottom-left
///   bottom-middle
///   bottom-right
/// 
/// NOTE  The top-left is the default value.
/// 
/// Figure 298 illustrates alignment values.
/// 
/// Figure 298 — Box alignment values
/// 
/// Figure 299 illustrates use of alignment values together with the placement and planar extent.
/// 
/// Figure 299 — Box alignment examples
/// 
/// HISTORY  New type in IFC2x2 Addendum2.
/// 
/// IFC2x3 CHANGE  The IfcBoxAlignment has been added.
class IFC_PARSE_API IfcBoxAlignment : public  IfcLabel {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcBoxAlignment (IfcEntityInstanceData&& e);
    IfcBoxAlignment (std::string v);
    operator std::string() const;
};
/// IfcNormalisedRatioMeasure is a dimensionless measure to express ratio values ranging from 0.0 to 1.0.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcNormalisedRatioMeasure : public  IfcRatioMeasure, public  IfcColourOrFactor {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcNormalisedRatioMeasure (IfcEntityInstanceData&& e);
    IfcNormalisedRatioMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A positive ratio measure is a ratio measure that is greater than zero.
/// Type: IfcRatioMeasure
/// 
/// NOTE Corresponding ISO 10303 name: positive_ratio_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositiveRatioMeasure : public  IfcRatioMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositiveRatioMeasure (IfcEntityInstanceData&& e);
    IfcPositiveRatioMeasure (double v);
    operator double() const;
};


/// Definition: A role which is performed by an actor, either a person, an organization or a 
/// person related to an organization.
/// 
/// NOTE: The list of roles of the enumeration values of the Role attribute can never
/// be complete. Therefore using enumeration value USERDEFINED, the user can provide his/her own role as a value 
/// of the attribute UserDefinedRole.
/// 
/// Corresponds to the following entity in ISO-10303-41: organization_role and person_role.
/// 
/// HISTORY New entity in IFC Release 1.5.1
class IFC_PARSE_API IfcActorRole : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// The name of the role played by an actor. If the Role has value USERDEFINED, then
    /// the user defined role shall be provided as a value of the attribute UserDefinedRole.
    ::Ifc4x3_rc1::IfcRoleEnum::Value Role() const;
    void setRole(::Ifc4x3_rc1::IfcRoleEnum::Value v);
    /// Allows for specification of user defined roles beyond the 
    /// enumeration values provided by Role attribute of type IfcRoleEnum. 
    /// When a value is provided for attribute UserDefinedRole in parallel 
    /// the attribute Role shall have enumeration value USERDEFINED.
    boost::optional< std::string > UserDefinedRole() const;
    void setUserDefinedRole(boost::optional< std::string > v);
    /// A textual description relating the nature of the role played by an actor.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcActorRole (IfcEntityInstanceData&& e);
    IfcActorRole (::Ifc4x3_rc1::IfcRoleEnum::Value v1_Role, boost::optional< std::string > v2_UserDefinedRole, boost::optional< std::string > v3_Description);
    typedef aggregate_of< IfcActorRole > list;
};
/// Definition: An abstract entity type for various kinds of postal and telecom addresses.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: address.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcAddress : public  IfcUtil::IfcBaseEntity, public  IfcObjectReferenceSelect {
public:
    /// Identifies the logical location of the address.
    boost::optional< ::Ifc4x3_rc1::IfcAddressTypeEnum::Value > Purpose() const;
    void setPurpose(boost::optional< ::Ifc4x3_rc1::IfcAddressTypeEnum::Value > v);
    /// Text that relates the nature of the address.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Allows for specification of user specific purpose of the address beyond the 
    /// enumeration values provided by Purpose attribute of type IfcAddressTypeEnum. 
    /// When a value is provided for attribute UserDefinedPurpose, in parallel the 
    /// attribute Purpose shall have enumeration value USERDEFINED.
    boost::optional< std::string > UserDefinedPurpose() const;
    void setUserDefinedPurpose(boost::optional< std::string > v);
        aggregate_of< IfcPerson >::ptr OfPerson() const; // INVERSE IfcPerson::Addresses
    aggregate_of< IfcOrganization >::ptr OfOrganization() const; // INVERSE IfcOrganization::Addresses
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAddress (IfcEntityInstanceData&& e);
    IfcAddress (boost::optional< ::Ifc4x3_rc1::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose);
    typedef aggregate_of< IfcAddress > list;
};
/// IfcApplication holds the information about an IFC compliant application developed by an application developer. The IfcApplication utilizes a short identifying name as provided by the application developer.
/// 
/// HISTORY  New entity in IFC R1.5.
class IFC_PARSE_API IfcApplication : public  IfcUtil::IfcBaseEntity {
public:
    /// Name of the application developer, being requested to be member of the IAI.
    ::Ifc4x3_rc1::IfcOrganization* ApplicationDeveloper() const;
    void setApplicationDeveloper(::Ifc4x3_rc1::IfcOrganization* v);
    /// The version number of this software as specified by the developer of the application.
    std::string Version() const;
    void setVersion(std::string v);
    /// The full name of the application as specified by the application developer.
    std::string ApplicationFullName() const;
    void setApplicationFullName(std::string v);
    /// Short identifying name for the application.
    std::string ApplicationIdentifier() const;
    void setApplicationIdentifier(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApplication (IfcEntityInstanceData&& e);
    IfcApplication (::Ifc4x3_rc1::IfcOrganization* v1_ApplicationDeveloper, std::string v2_Version, std::string v3_ApplicationFullName, std::string v4_ApplicationIdentifier);
    typedef aggregate_of< IfcApplication > list;
};
/// IfcAppliedValue is an abstract supertype that specifies the common attributes for cost values. 
/// 
/// HISTORY: New Entity in IFC2x2.  Modifed in IFC2x4 to use IfcDate for date values.
/// 
/// Use definitions 
/// The extent of the IfcAppliedValue is determined by the AppliedValue attribute which may be defined either as an IfcMeasureWithUnit or as an IfcMonetaryMeasure or as an IfcRatioMeasure via the IfcAppliedValueSelect type.  
/// 
/// Optionally, an IfcAppliedValue may have an applicable date. This is intended to fix the date on which the value became relevant for use. It may be the date on which the value was set in the model or it may be a prior or future date when the value becomes operable.
/// 
/// Similarly, an IfcAppliedValue may have a 'fixed until' date. This is intended to fix the date on which the value ceases to be relevant for use. 
/// 
/// An instance of IfcAppliedValue may have a unit basis asserted.  This is defined as an IfcMeasureWithUnit that determines the extent of the unit value for application purposes. It is assumed that when this attribute is asserted, then the value given to IfcAppliedValue is that for unit quantity. This is not enforced within the IFC schema and thus needs to be controlled within an application.
/// 
/// Applied values may be referenced from a document (such as a price list). The relationship between one or more occurrences of IfcAppliedValue (or its subtypes) is achieved through the use of the IfcExternalReferenceRelationship in which the document provides the IfcExternalReferenceRelationship.RelatingExtReference and the value occurrences are the IfcExternalReferenceRelationship.RelatedResourceObjects.
class IFC_PARSE_API IfcAppliedValue : public  IfcUtil::IfcBaseEntity, public  IfcMetricValueSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// A name or additional clarification given to a cost value.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// The description that may apply additional information about a cost value.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The extent or quantity or amount of an applied value.
    ::Ifc4x3_rc1::IfcAppliedValueSelect* AppliedValue() const;
    void setAppliedValue(::Ifc4x3_rc1::IfcAppliedValueSelect* v);
    /// The number and unit of measure on which the unit cost is based.
    /// 
    /// Note: As well as the normally expected units of measure such as length, area, volume etc., costs may be based on units of measure which need to be defined e.g. sack, drum, pallet, item etc. Unit costs may be based on quantities greater (or lesser) than a unitary value of the basis measure. For instance, timber may have a unit cost rate per X meters where X > 1; similarly for cable, piping and many other items. The basis number may be either an integer or a real value.
    /// 
    /// Note: This attribute should be asserted for all circumstances where the cost to be applied is per unit quantity. It may be asserted even for circumstances where an item price is used, in which case the unit cost basis should be by item (or equivalent definition).
    ::Ifc4x3_rc1::IfcMeasureWithUnit* UnitBasis() const;
    void setUnitBasis(::Ifc4x3_rc1::IfcMeasureWithUnit* v);
    /// The date on or from which an applied value is applicable.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect.
    boost::optional< std::string > ApplicableDate() const;
    void setApplicableDate(boost::optional< std::string > v);
    /// The date until which applied value is applicable.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect.
    boost::optional< std::string > FixedUntilDate() const;
    void setFixedUntilDate(boost::optional< std::string > v);
    boost::optional< std::string > Category() const;
    void setCategory(boost::optional< std::string > v);
    boost::optional< std::string > Condition() const;
    void setCondition(boost::optional< std::string > v);
    boost::optional< ::Ifc4x3_rc1::IfcArithmeticOperatorEnum::Value > ArithmeticOperator() const;
    void setArithmeticOperator(boost::optional< ::Ifc4x3_rc1::IfcArithmeticOperatorEnum::Value > v);
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAppliedValue >::ptr > Components() const;
    void setComponents(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAppliedValue >::ptr > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAppliedValue (IfcEntityInstanceData&& e);
    IfcAppliedValue (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcAppliedValueSelect* v3_AppliedValue, ::Ifc4x3_rc1::IfcMeasureWithUnit* v4_UnitBasis, boost::optional< std::string > v5_ApplicableDate, boost::optional< std::string > v6_FixedUntilDate, boost::optional< std::string > v7_Category, boost::optional< std::string > v8_Condition, boost::optional< ::Ifc4x3_rc1::IfcArithmeticOperatorEnum::Value > v9_ArithmeticOperator, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAppliedValue >::ptr > v10_Components);
    typedef aggregate_of< IfcAppliedValue > list;
};
/// Definition: An IfcApproval represents information about approval processes such as for a plan, a design, a proposal, or a change order in a construction or facilities management project. IfcApproval is referenced by IfcRelAssociatesApproval in IfcControlExtension schema, and thereby can be related to all subtypes of IfcRoot. An approval may also be given to resource objects using IfcResourceApprovalRelationship
/// 
/// HISTORY New Entity in IFC Release 2.0
/// 
/// IFC2x Edition 4 CHANGE  Attributes Identifier and Name made optional, where rule added to require at least one of them being asserted. Inverse attributes ApprovedObjects, ApprovedResources and HasExternalReferences added. Inverse attribute Properties deleted (more general relationship via inverse ApprovedResources to be used instead).
class IFC_PARSE_API IfcApproval : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// A computer interpretable identifier by which the approval is known.
    boost::optional< std::string > Identifier() const;
    void setIdentifier(boost::optional< std::string > v);
    /// A human readable name given to an approval.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// A general textual description of a design, work task, plan, etc. that is being approved for.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Date and time when the result of the approval process is produced.
    /// 
    /// IFC2x4 CHANGE  Attribute data type changed to IfcDateTime using ISO 8601 representation, renamed from ApprovalDateTime and made OPTIONAL.
    boost::optional< std::string > TimeOfApproval() const;
    void setTimeOfApproval(boost::optional< std::string > v);
    /// The result or current status of the approval, e.g. Requested, Processed, Approved, Not Approved.
    boost::optional< std::string > Status() const;
    void setStatus(boost::optional< std::string > v);
    /// Level of the approval e.g. Draft v.s. Completed design.
    boost::optional< std::string > Level() const;
    void setLevel(boost::optional< std::string > v);
    /// Textual description of special constraints or conditions for the approval.
    boost::optional< std::string > Qualifier() const;
    void setQualifier(boost::optional< std::string > v);
    /// The actor that is acting in the role specified at IfcOrganization or individually at IfcPerson and requesting an approval.
    /// 
    /// IFC2x4 CHANGE  New attribute for approval request replacing IfcApprovalActorRelationship (being deleted).
    ::Ifc4x3_rc1::IfcActorSelect* RequestingApproval() const;
    void setRequestingApproval(::Ifc4x3_rc1::IfcActorSelect* v);
    /// The actor that is acting in the role specified at IfcOrganization or individually at IfcPerson and giving an approval.
    /// 
    /// IFC2x4 CHANGE  New attribute for approval provision replacing IfcApprovalActorRelationship (being deleted).
    ::Ifc4x3_rc1::IfcActorSelect* GivingApproval() const;
    void setGivingApproval(::Ifc4x3_rc1::IfcActorSelect* v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    aggregate_of< IfcRelAssociatesApproval >::ptr ApprovedObjects() const; // INVERSE IfcRelAssociatesApproval::RelatingApproval
    aggregate_of< IfcResourceApprovalRelationship >::ptr ApprovedResources() const; // INVERSE IfcResourceApprovalRelationship::RelatingApproval
    aggregate_of< IfcApprovalRelationship >::ptr IsRelatedWith() const; // INVERSE IfcApprovalRelationship::RelatedApprovals
    aggregate_of< IfcApprovalRelationship >::ptr Relates() const; // INVERSE IfcApprovalRelationship::RelatingApproval
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApproval (IfcEntityInstanceData&& e);
    IfcApproval (boost::optional< std::string > v1_Identifier, boost::optional< std::string > v2_Name, boost::optional< std::string > v3_Description, boost::optional< std::string > v4_TimeOfApproval, boost::optional< std::string > v5_Status, boost::optional< std::string > v6_Level, boost::optional< std::string > v7_Qualifier, ::Ifc4x3_rc1::IfcActorSelect* v8_RequestingApproval, ::Ifc4x3_rc1::IfcActorSelect* v9_GivingApproval);
    typedef aggregate_of< IfcApproval > list;
};
/// Definition
/// from IAI: The abstract entity IfcBoundaryCondition
/// is the supertype of all boundary conditions that can be applied to
/// structural connection definitions, either directly for the connection
/// (e.g. the joint) or for the relation between a structural member and
/// the connection.
/// NOTE: The boundary conditions are used
/// within other parts, mainly by instances of IfcStructuralConnection
/// (for the definition of supports) and instances of IfcRelConnectsStructuralMember
/// (for the definition of connections between structural members and
/// structural connections). 
/// 
/// HISTORY: New entity
/// in Release IFC2x Edition
/// 2.
class IFC_PARSE_API IfcBoundaryCondition : public  IfcUtil::IfcBaseEntity {
public:
    /// Optionally defines a name for this boundary condition.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryCondition (IfcEntityInstanceData&& e);
    IfcBoundaryCondition (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcBoundaryCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Curve supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryEdgeCondition : public  IfcBoundaryCondition {
public:
    /// Translational stiffness value in x-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* TranslationalStiffnessByLengthX() const;
    void setTranslationalStiffnessByLengthX(::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v);
    /// Translational stiffness value in y-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* TranslationalStiffnessByLengthY() const;
    void setTranslationalStiffnessByLengthY(::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v);
    /// Translational stiffness value in z-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* TranslationalStiffnessByLengthZ() const;
    void setTranslationalStiffnessByLengthZ(::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v);
    /// Rotational stiffness value about the x-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* RotationalStiffnessByLengthX() const;
    void setRotationalStiffnessByLengthX(::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v);
    /// Rotational stiffness value about the y-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* RotationalStiffnessByLengthY() const;
    void setRotationalStiffnessByLengthY(::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v);
    /// Rotational stiffness value about the z-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* RotationalStiffnessByLengthZ() const;
    void setRotationalStiffnessByLengthZ(::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryEdgeCondition (IfcEntityInstanceData&& e);
    IfcBoundaryEdgeCondition (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v2_TranslationalStiffnessByLengthX, ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v3_TranslationalStiffnessByLengthY, ::Ifc4x3_rc1::IfcModulusOfTranslationalSubgradeReactionSelect* v4_TranslationalStiffnessByLengthZ, ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v5_RotationalStiffnessByLengthX, ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v6_RotationalStiffnessByLengthY, ::Ifc4x3_rc1::IfcModulusOfRotationalSubgradeReactionSelect* v7_RotationalStiffnessByLengthZ);
    typedef aggregate_of< IfcBoundaryEdgeCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Surface supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryFaceCondition : public  IfcBoundaryCondition {
public:
    /// Translational stiffness value in x-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* TranslationalStiffnessByAreaX() const;
    void setTranslationalStiffnessByAreaX(::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v);
    /// Translational stiffness value in y-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* TranslationalStiffnessByAreaY() const;
    void setTranslationalStiffnessByAreaY(::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v);
    /// Translational stiffness value in z-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* TranslationalStiffnessByAreaZ() const;
    void setTranslationalStiffnessByAreaZ(::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryFaceCondition (IfcEntityInstanceData&& e);
    IfcBoundaryFaceCondition (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v2_TranslationalStiffnessByAreaX, ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v3_TranslationalStiffnessByAreaY, ::Ifc4x3_rc1::IfcModulusOfSubgradeReactionSelect* v4_TranslationalStiffnessByAreaZ);
    typedef aggregate_of< IfcBoundaryFaceCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryNodeCondition : public  IfcBoundaryCondition {
public:
    /// Translational stiffness value in x-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* TranslationalStiffnessX() const;
    void setTranslationalStiffnessX(::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v);
    /// Translational stiffness value in y-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* TranslationalStiffnessY() const;
    void setTranslationalStiffnessY(::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v);
    /// Translational stiffness value in z-direction of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* TranslationalStiffnessZ() const;
    void setTranslationalStiffnessZ(::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v);
    /// Rotational stiffness value about the x-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* RotationalStiffnessX() const;
    void setRotationalStiffnessX(::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v);
    /// Rotational stiffness value about the y-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* RotationalStiffnessY() const;
    void setRotationalStiffnessY(::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v);
    /// Rotational stiffness value about the z-axis of the coordinate system defined by the instance which uses this resource object.
    ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* RotationalStiffnessZ() const;
    void setRotationalStiffnessZ(::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryNodeCondition (IfcEntityInstanceData&& e);
    IfcBoundaryNodeCondition (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v2_TranslationalStiffnessX, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v3_TranslationalStiffnessY, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v4_TranslationalStiffnessZ, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v5_RotationalStiffnessX, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v6_RotationalStiffnessY, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v7_RotationalStiffnessZ);
    typedef aggregate_of< IfcBoundaryNodeCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions, including linearly elastic warping restraints.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2. 
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryNodeConditionWarping : public  IfcBoundaryNodeCondition {
public:
    /// Defines the warping stiffness value.
    ::Ifc4x3_rc1::IfcWarpingStiffnessSelect* WarpingStiffness() const;
    void setWarpingStiffness(::Ifc4x3_rc1::IfcWarpingStiffnessSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryNodeConditionWarping (IfcEntityInstanceData&& e);
    IfcBoundaryNodeConditionWarping (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v2_TranslationalStiffnessX, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v3_TranslationalStiffnessY, ::Ifc4x3_rc1::IfcTranslationalStiffnessSelect* v4_TranslationalStiffnessZ, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v5_RotationalStiffnessX, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v6_RotationalStiffnessY, ::Ifc4x3_rc1::IfcRotationalStiffnessSelect* v7_RotationalStiffnessZ, ::Ifc4x3_rc1::IfcWarpingStiffnessSelect* v8_WarpingStiffness);
    typedef aggregate_of< IfcBoundaryNodeConditionWarping > list;
};
/// IfcConnectionGeometry is used to describe the geometric and topological constraints that facilitate the physical connection of two objects. It is envisioned as a control that applies to the element connection relationships.
/// 
/// NOTE  The element connection relationship normally provides for a logical connection information, by referencing the relating and related elements. If in addition an IfcConnectionGeometry is provided, physical connection information is given by specifying exactly where at the relating and related element the element connection occurs. 
/// Using the eccentricity subtypes, the connection can also be described when there is a physical distance (or eccentricity) between the connection elements.
/// 
/// The IfcConnectionGeometry allows for the provision of connection constraints between geometric and topological elements, the following connection geometry/topology types are in scope:
/// 
/// point | vertex point,
///   curve | edge curve,
///   surface | face surface,
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x Edition 3 CHANGE  The definition of the subtypes has been enhanced by allowing either geometric representation items (point | curve | surface) or topological representation items with associated geometry (vertex point | edge curve | face  surface).
class IFC_PARSE_API IfcConnectionGeometry : public  IfcUtil::IfcBaseEntity {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionGeometry (IfcEntityInstanceData&& e);
    IfcConnectionGeometry ();
    typedef aggregate_of< IfcConnectionGeometry > list;
};
/// IfcConnectionPointGeometry
/// is used to describe the geometric constraints that facilitate the
/// physical connection of two objects at a point (here IfcCartesianPoint) or at an vertex with point
/// coordinates associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// EXAMPLE  The connection relationship between two path based elements (like a column and a beam) has a geometric constraint which describes the connection points by a PointOnRelatingElement for the column and a PointOnRelatedElement for the beam. The exact usage of the IfcConnectionPointGeometry is further defined in the geometry use sections of the elements that use it.
/// 
/// NOTE  If the point connection has an offset (if the two points or vertex points at the relating and related element do not physically match), the subtype IfcConnectionPointEccentricity shall be used.
/// 
/// HISTORY  New entity in IFC Release 1.5, has been renamed from IfcPointConnectionGeometry in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcVertexPoint, is
/// enabled by using the IfcPointOrVertexPoint.
/// 
/// Geometry use definitions
/// The IfcPoint (or the IfcVertexPoint with an associated IfcPoint) at the PointOnRelatingElement attribute defines the point where the basic geometry items of the connected elements connect. The point coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnectsSubtype that utilizes the IfcConnectionPointGeometry. Optionally, the same point coordinates can also be provided within the local coordinate system of the RelatedElement by using the PointOnRelatedElement attribute. If both point coordinates are not identical within a common parent coordinate system (ultimately within the world coordinate system), the subtype IfcConnectionPointEccentricity shall be used.
class IFC_PARSE_API IfcConnectionPointGeometry : public  IfcConnectionGeometry {
public:
    /// Point at which the connected object is aligned at the relating element, given in the LCS of the relating element.
    ::Ifc4x3_rc1::IfcPointOrVertexPoint* PointOnRelatingElement() const;
    void setPointOnRelatingElement(::Ifc4x3_rc1::IfcPointOrVertexPoint* v);
    /// Point at which connected objects are aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc4x3_rc1::IfcPointOrVertexPoint* PointOnRelatedElement() const;
    void setPointOnRelatedElement(::Ifc4x3_rc1::IfcPointOrVertexPoint* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionPointGeometry (IfcEntityInstanceData&& e);
    IfcConnectionPointGeometry (::Ifc4x3_rc1::IfcPointOrVertexPoint* v1_PointOnRelatingElement, ::Ifc4x3_rc1::IfcPointOrVertexPoint* v2_PointOnRelatedElement);
    typedef aggregate_of< IfcConnectionPointGeometry > list;
};
/// IfcConnectionSurfaceGeometry is used to describe the geometric constraints that facilitate the physical connection of two objects at a surface or at a face with surface geometry associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// HISTORY  New entity in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcFaceSurface, is enabled by using the IfcSurfaceOrFaceSurface.
/// 
/// Geometry use definitions 
/// The IfcSurface (or the IfcFaceSurface with an associated IfcSurface) at the SurfaceOnRelatingElement attribute defines the surface where the basic geometry items of the connected elements connects. The surface geometry and coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnectsSubtype that utilizes the IfcConnectionSurfaceGeometry. Optionally, the same surface geometry and coordinates can also be provided within the local coordinate system of the RelatedElement by using the SurfaceOnRelatedElement attribute.
class IFC_PARSE_API IfcConnectionSurfaceGeometry : public  IfcConnectionGeometry {
public:
    /// Surface at which related object is aligned at the relating element, given in the LCS of the relating element.
    ::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* SurfaceOnRelatingElement() const;
    void setSurfaceOnRelatingElement(::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* v);
    /// Surface at which the relating element is aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* SurfaceOnRelatedElement() const;
    void setSurfaceOnRelatedElement(::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionSurfaceGeometry (IfcEntityInstanceData&& e);
    IfcConnectionSurfaceGeometry (::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* v1_SurfaceOnRelatingElement, ::Ifc4x3_rc1::IfcSurfaceOrFaceSurface* v2_SurfaceOnRelatedElement);
    typedef aggregate_of< IfcConnectionSurfaceGeometry > list;
};
/// IfcConnectionVolumeGeometry is used to describe the geometric constraints that facilitate the physical connection (or overlap) of two objects at a volume defined by a solid or closed shell. It is envisioned as a control that applies to the element connection or interference relationships.
/// 
/// HISTORY New entity in IFC2x4.
/// 
/// Geometry use definitions 
/// The IfcSolidModel (or the IfcClosedShell) at the VolumeOnRelatingElement attribute defines the volume where the basic geometry items of the interfering elements overlap. The volume geometry and coordinates are provided within the local coordinate system of the RelatingElement, as specified at the subtypes of the relationship IfcRelConnects that utilizes the IfcConnectionSurfaceGeometry. Optionally, the samevolume geometry and coordinates can also be provided within the local coordinate system of the RelatedElement by using the VolumeOnRelatedElement attribute.
class IFC_PARSE_API IfcConnectionVolumeGeometry : public  IfcConnectionGeometry {
public:
    /// Volume at which related object overlaps with the relating element, given in the LCS of the relating element.
    ::Ifc4x3_rc1::IfcSolidOrShell* VolumeOnRelatingElement() const;
    void setVolumeOnRelatingElement(::Ifc4x3_rc1::IfcSolidOrShell* v);
    /// Volume at which related object overlaps with the relating element, given in the LCS of the related element.
    ::Ifc4x3_rc1::IfcSolidOrShell* VolumeOnRelatedElement() const;
    void setVolumeOnRelatedElement(::Ifc4x3_rc1::IfcSolidOrShell* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionVolumeGeometry (IfcEntityInstanceData&& e);
    IfcConnectionVolumeGeometry (::Ifc4x3_rc1::IfcSolidOrShell* v1_VolumeOnRelatingElement, ::Ifc4x3_rc1::IfcSolidOrShell* v2_VolumeOnRelatedElement);
    typedef aggregate_of< IfcConnectionVolumeGeometry > list;
};
/// An IfcConstraint is used to define a constraint or limiting value or boundary condition that may be applied to an object or to the value of a property.  
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use Definition 
/// IfcConstraint may be associated with any subtype of IfcRoot (unless restricted in specific subtypes) through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship. 
/// 
/// A constraint may aggregate other constraints through the IfcConstraintAggregationRelationship through which a logical association between constraints may be applied, or constraints may have other defined relationship to other constraints via IfcConstraintRelationship. 
/// 
/// A constraint must have a name applied through the IfcConstraint.Name attribute and optionally, a description through IfcConstraint.Description. The grade of the constraint (hard, soft, advisory) must be specified through IfcConstraint.ConstraintGrade or IfcConstraint.UserDefinedGrade whilst the source, creating actor and time at which the constraint is created may be optionally asserted through IfcConstraint.ConstraintSource, IfcConstraint.CreatingActor and IfcConstraint.CreationTime. 
/// 
/// A constraint may also have additional external information (such as classification or document information) associated to it by IfcExternalReferenceRelationship, accessible through inverse attribute IfcConstraint.HasExternalReferences
class IFC_PARSE_API IfcConstraint : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// A name to be used for the constraint (e.g., ChillerCoefficientOfPerformance).
    std::string Name() const;
    void setName(std::string v);
    /// A description that may apply additional information about a constraint.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Enumeration that qualifies the type of constraint.
    ::Ifc4x3_rc1::IfcConstraintEnum::Value ConstraintGrade() const;
    void setConstraintGrade(::Ifc4x3_rc1::IfcConstraintEnum::Value v);
    /// Any source material, such as a code or standard, from which the constraint originated.
    boost::optional< std::string > ConstraintSource() const;
    void setConstraintSource(boost::optional< std::string > v);
    /// Person and/or organization that has created the constraint.
    ::Ifc4x3_rc1::IfcActorSelect* CreatingActor() const;
    void setCreatingActor(::Ifc4x3_rc1::IfcActorSelect* v);
    /// Time when information specifying the constraint instance was created.
    /// 
    /// Note IFC2x4 CHANGE: Attribute data type changed to IfcDateTime using ISO 8601 representation
    boost::optional< std::string > CreationTime() const;
    void setCreationTime(boost::optional< std::string > v);
    /// Allows for specification of user defined grade of the constraint  beyond the enumeration values (hard, soft, advisory) provided by ConstraintGrade attribute of type IfcConstraintEnum. 
    /// When a value is provided for attribute UserDefinedGrade in parallel the attribute ConstraintGrade shall have enumeration value USERDEFINED.
    boost::optional< std::string > UserDefinedGrade() const;
    void setUserDefinedGrade(boost::optional< std::string > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    aggregate_of< IfcResourceConstraintRelationship >::ptr PropertiesForConstraint() const; // INVERSE IfcResourceConstraintRelationship::RelatingConstraint
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConstraint (IfcEntityInstanceData&& e);
    IfcConstraint (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc4x3_rc1::IfcActorSelect* v5_CreatingActor, boost::optional< std::string > v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade);
    typedef aggregate_of< IfcConstraint > list;
};
/// Definition from OpenGIS® Abstract Specification,
///   Topic 2: If the relationship between any two coordinate
///   reference systems is known, coordinates can be transformed
///   or converted to another coordinate reference system.
///   Coordinate operations are divided into two subtypes:
/// 
/// Coordinate conversion – mathematical
///   operation on coordinates that does not include any change
///   of datum. The best-known example of a coordinate
///   conversion is a map projection. The parameters describing
///   coordinate conversions are defined rather than
///   empirically derived. Note that some conversions have no
///   parameters.
/// 
/// Coordinate transformation – mathematical
///   operation on coordinates that usually includes a change
///   of datum. The parameters of a coordinate transformation
///   are empirically derived from data containing the
///   coordinates of a series of points in both coordinate
///   reference systems. This computational process is usually
///   ‘over-determined’, allowing derivation of
///   error (or accuracy) estimates for the transformation.
///   Also, the stochastic nature of the parameters may result
///   in multiple (different) versions of the same coordinate
///   transformation. Because of this several transformations
///   may exist for a given pair of coordinate reference
///   systems, differing in their transformation method,
///   parameter values and accuracy characteristics.
/// 
/// The coordinate operation is an
///   abstract supertype to handle any operation (transformation
///   or conversion) between two coordinate reference systems. It
///   is meant to provide expandability for future versions,
///   since currently only the conversion of a local engineering
///   coordinate system into a map coordinate reference system is
///   dealt with by the subtype IfcMapConversion.
/// 
/// By convention, a coordinate operation is given between the
///   SourceCRS being the more local, or child coordinate
///   reference system, and the TargetCRS being the more
///   remote or parent coordinate reference system, in
///   thespecial case the coordinate operation between the local
///   engineering coordinate system of the construction project
///   and any map or other coordinate reference system.
/// 
/// HISTORY  New entity in IFC2x4.
class IFC_PARSE_API IfcCoordinateOperation : public  IfcUtil::IfcBaseEntity {
public:
    /// Source coordinate reference system for the operation.
    ::Ifc4x3_rc1::IfcCoordinateReferenceSystemSelect* SourceCRS() const;
    void setSourceCRS(::Ifc4x3_rc1::IfcCoordinateReferenceSystemSelect* v);
    /// Target coordinate reference system for the operation.
    ::Ifc4x3_rc1::IfcCoordinateReferenceSystem* TargetCRS() const;
    void setTargetCRS(::Ifc4x3_rc1::IfcCoordinateReferenceSystem* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCoordinateOperation (IfcEntityInstanceData&& e);
    IfcCoordinateOperation (::Ifc4x3_rc1::IfcCoordinateReferenceSystemSelect* v1_SourceCRS, ::Ifc4x3_rc1::IfcCoordinateReferenceSystem* v2_TargetCRS);
    typedef aggregate_of< IfcCoordinateOperation > list;
};
/// Definition from OpenGIS® Abstract Specification, Topic
/// 2: A coordinate reference system is a coordinate system which
/// is related to the real world by a datum. The coordinate system is
/// composed of a set of coordinate axes with specified units of
/// measure. The datum specifies the relationship of a coordinate
/// system to the earth. The resulting combination of coordinate
/// system and datum is a coordinate reference system.
/// 
/// IfcCoordinateReferenceSystem is a definition of a coordinate
/// reference system by means of qualified identifiers only. The
/// interpretation of the identifier is expected to be well-known to
/// the receiving software.
/// 
/// NOTE  One widely-used, publicly-available
/// authority is the European Petroleum Survey Group (EPSG), and use
/// of this authority is currently specified in several OGC
/// Implementation Specifications. Software used to transport IFC
/// engineering models into GIS applications (and vice versa) is
/// expected to have knowledge about the OGC Implementation
/// Specifications.
/// 
/// HISTORY  New entity in IFC2x4.
class IFC_PARSE_API IfcCoordinateReferenceSystem : public  IfcUtil::IfcBaseEntity, public  IfcCoordinateReferenceSystemSelect {
public:
    /// Name by which the coordinate reference system is identified.
    /// Note  The name shall be taken from the list recognized by the European Petroleum Survey Group EPSG.
    std::string Name() const;
    void setName(std::string v);
    /// Informal description of this coordinate reference system.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Name by which this datum is identified. The geodetic datum is associated with the coordinate reference system and indicates the shape and size of the rotation ellipsoid and this ellipsoid's connection and orientation to the actual globe/earth. Examples for geodetic datums include:
    /// 
    /// ED50
    ///   EUREF89
    ///   WSG84
    boost::optional< std::string > GeodeticDatum() const;
    void setGeodeticDatum(boost::optional< std::string > v);
    /// Name by which the vertical datum is identified. The vertical datum is associated with the height axis of the coordinate reference system and indicates the reference plane and fundamental point defining the origin of a height system. Examples for vertical datums include:
    /// 
    /// height above mean sea level at Dover in 1952
    ///   other sea levels
    boost::optional< std::string > VerticalDatum() const;
    void setVerticalDatum(boost::optional< std::string > v);
        aggregate_of< IfcCoordinateOperation >::ptr HasCoordinateOperation() const; // INVERSE IfcCoordinateOperation::SourceCRS
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCoordinateReferenceSystem (IfcEntityInstanceData&& e);
    IfcCoordinateReferenceSystem (std::string v1_Name, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_GeodeticDatum, boost::optional< std::string > v4_VerticalDatum);
    typedef aggregate_of< IfcCoordinateReferenceSystem > list;
};
/// IfcCostValue is an amount of money or a value that affects an amount of money. 
/// 
/// HISTORY: New Entity in IFC Release 1.0
/// 
/// Use definitions 
/// Each instance of IfcCostValue may also have a CostType. There are many possible types of cost value that may be identified. While there is a broad understanding of the meaning of names that may be assigned to different types of costs, there is no general standard for naming cost types nor are there any broadly defined classifications. To allow for any type of cost value, the IfcLabel datatype is assigned.
/// 
/// The following defines some cost types that might be applied:  
/// 
/// Annual rate of return
/// Bonus
/// Bulk purchase rebate
/// Contract
/// Consultancy
/// Delivery
/// Estimated cost
/// Hire
/// Installation
/// Interest rate
/// Labor
/// Lease
/// List price
/// Maintenance
/// Material
/// Overhead
/// Postage and packing
/// Profit
/// Purchase 
/// Rental
/// Repair
/// Replacement
/// Sale
/// Small quantity surcharge
/// Spares
/// Storage
/// Sub-Contract
/// Trade discount
/// Transportation
/// Waste allowance
/// Whole life
/// 
/// In the absence of any well-defined standard, it is recommended that local agreements should be made to define allowable and understandable cost value types within a project or region.
class IFC_PARSE_API IfcCostValue : public  IfcAppliedValue {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCostValue (IfcEntityInstanceData&& e);
    IfcCostValue (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcAppliedValueSelect* v3_AppliedValue, ::Ifc4x3_rc1::IfcMeasureWithUnit* v4_UnitBasis, boost::optional< std::string > v5_ApplicableDate, boost::optional< std::string > v6_FixedUntilDate, boost::optional< std::string > v7_Category, boost::optional< std::string > v8_Condition, boost::optional< ::Ifc4x3_rc1::IfcArithmeticOperatorEnum::Value > v9_ArithmeticOperator, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAppliedValue >::ptr > v10_Components);
    typedef aggregate_of< IfcCostValue > list;
};
/// Definition from ISO/CD 10303-41:1992: A derived unit is an expression of units.
/// 
/// EXAMPLE: Newton per square millimetre is a derived unit.
/// 
/// NOTE: Corresponding ISO 10303 name: derived_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDerivedUnit : public  IfcUtil::IfcBaseEntity, public  IfcUnit {
public:
    /// The group of units and their exponents that define the derived unit.
    aggregate_of< ::Ifc4x3_rc1::IfcDerivedUnitElement >::ptr Elements() const;
    void setElements(aggregate_of< ::Ifc4x3_rc1::IfcDerivedUnitElement >::ptr v);
    /// Name of the derived unit chosen from an enumeration of derived unit types for use in IFC models.
    ::Ifc4x3_rc1::IfcDerivedUnitEnum::Value UnitType() const;
    void setUnitType(::Ifc4x3_rc1::IfcDerivedUnitEnum::Value v);
    boost::optional< std::string > UserDefinedType() const;
    void setUserDefinedType(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedUnit (IfcEntityInstanceData&& e);
    IfcDerivedUnit (aggregate_of< ::Ifc4x3_rc1::IfcDerivedUnitElement >::ptr v1_Elements, ::Ifc4x3_rc1::IfcDerivedUnitEnum::Value v2_UnitType, boost::optional< std::string > v3_UserDefinedType);
    typedef aggregate_of< IfcDerivedUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A derived unit element is one of the unit quantities 
/// which makes up a derived unit.
/// 
/// EXAMPLE: Newtons per square millimetre is a derived unit. 
/// It has two elements, Newton whose exponent has a value of 1 and millimetre whose exponent is -2.
/// 
/// NOTE: Corresponding ISO 10303 name: derived_unit_element, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDerivedUnitElement : public  IfcUtil::IfcBaseEntity {
public:
    /// The fixed quantity which is used as the mathematical factor.
    ::Ifc4x3_rc1::IfcNamedUnit* Unit() const;
    void setUnit(::Ifc4x3_rc1::IfcNamedUnit* v);
    /// The power that is applied to the unit attribute.
    int Exponent() const;
    void setExponent(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedUnitElement (IfcEntityInstanceData&& e);
    IfcDerivedUnitElement (::Ifc4x3_rc1::IfcNamedUnit* v1_Unit, int v2_Exponent);
    typedef aggregate_of< IfcDerivedUnitElement > list;
};
/// Definition from ISO/CD 10303-41:1992: The dimensionality of any quantity can be expressed as a product of powers of the dimensions of base quantities. 
/// The dimensional exponents entity defines the powers of the dimensions of the base quantities. All the physical 
/// quantities are founded on seven base quantities (ISO 31 (clause 2)).
/// 
/// NOTE: Length, mass, time, electric current, thermodynamic temperature, amount of substance, 
/// and luminous intensity are the seven base quantities.
/// 
/// EXAMPLE: A length of 2 millimetres has a length exponent of 1. The remaining exponents 
/// are equal to 0.
/// 
/// EXAMPLE: A velocity of 2 millimetres per second has a length exponent of 1 and 
/// a time exponent of -1. The remaining exponents are equal to 0.
/// 
/// NOTE Corresponding STEP name: dimensional_exponents, please refer to ISO/IS 10303-41
///   for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDimensionalExponents : public  IfcUtil::IfcBaseEntity {
public:
    /// The power of the length base quantity.
    int LengthExponent() const;
    void setLengthExponent(int v);
    /// The power of the mass base quantity.
    int MassExponent() const;
    void setMassExponent(int v);
    /// The power of the time base quantity.
    int TimeExponent() const;
    void setTimeExponent(int v);
    /// The power of the electric current base quantity.
    int ElectricCurrentExponent() const;
    void setElectricCurrentExponent(int v);
    /// The power of the thermodynamic temperature base quantity.
    int ThermodynamicTemperatureExponent() const;
    void setThermodynamicTemperatureExponent(int v);
    /// The power of the amount of substance base quantity.
    int AmountOfSubstanceExponent() const;
    void setAmountOfSubstanceExponent(int v);
    /// The power of the luminous intensity base quantity.
    int LuminousIntensityExponent() const;
    void setLuminousIntensityExponent(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDimensionalExponents (IfcEntityInstanceData&& e);
    IfcDimensionalExponents (int v1_LengthExponent, int v2_MassExponent, int v3_TimeExponent, int v4_ElectricCurrentExponent, int v5_ThermodynamicTemperatureExponent, int v6_AmountOfSubstanceExponent, int v7_LuminousIntensityExponent);
    typedef aggregate_of< IfcDimensionalExponents > list;
};
/// An IfcExternalInformation is the identification of an information source that is not explicitly represented in the current model or in the project database (as an implementation of the current model). The IfcExternalInformation identifies the external source (classification, document, or library), but not the particular items such as a dictionary entry, a classification notation, or a document reference within the external source
/// 
/// The IfcExternalInformation is an abstract supertype of
/// all external information entities.
/// 
/// HISTORY New entity in IFC2x4.
class IFC_PARSE_API IfcExternalInformation : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternalInformation (IfcEntityInstanceData&& e);
    IfcExternalInformation ();
    typedef aggregate_of< IfcExternalInformation > list;
};
/// An IfcExternalReference is the identification of information that is not explicitly represented in the current model or in the project database (as an implementation of the current model). Such information may be contained in classifications, documents or libraries. The IfcExternalReference identifies a particular item, such as a
/// dictionary entry, a classification notation, or a document reference within the external source.
/// 
/// Only the Location (as a URL) is given to describe the place where the information can be found. Also an optional
/// Identification as a key to allow more specific references (as to sections or tables) is provided. The Identification defines a system interpretable method to identify the relevant part of information at the source. In addition a human interpretable Name can be assigned to identify the information subject, such as a classification code.
/// 
/// IfcExternalReference is an abstract supertype of all external reference entities.
/// 
/// HISTORY New entity in IFC2x.
class IFC_PARSE_API IfcExternalReference : public  IfcUtil::IfcBaseEntity, public  IfcLightDistributionDataSourceSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// Location, where the external source (classification, document or library) can be accessed by electronic means. The electronic location is provided as an URI, and would normally be given as an URL location string.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed from IfcLabel to IfcURIReference.
    boost::optional< std::string > Location() const;
    void setLocation(boost::optional< std::string > v);
    /// The Identification provides a unique identifier of the referenced item within the external source (classification, document or library). It may be provided as 
    /// 
    /// a key, e.g. a classification notation, like NF2.3
    ///   a handle
    ///   a uuid or guid
    /// 
    /// It may be human readable (such as a key) or not (such as a handle or uuid) depending on the context of its usage (which has to be determined by local agreement).
    /// 
    /// IFC2x4 CHANGE  Attribute renamed from ItemReference for consistency.
    boost::optional< std::string > Identification() const;
    void setIdentification(boost::optional< std::string > v);
    /// Optional name to further specify the reference. It can provide a human readable identifier (which does not necessarily need to have a counterpart in the internal structure of the document).
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr ExternalReferenceForResources() const; // INVERSE IfcExternalReferenceRelationship::RelatingReference
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternalReference (IfcEntityInstanceData&& e);
    IfcExternalReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name);
    typedef aggregate_of< IfcExternalReference > list;
};
/// Definition from ISO/CD 10303-46:1992: The externally defined hatch style is an entity which makes an external reference to a hatching style.
/// 
/// NOTE: The allowable values for the name source and item reference, by which the externally defined hatch style is identified, need to be determined by implementer agreements.
/// 
/// NOTE: Corresponding ISO 10303 name: fill_style_select. Please refer to ISO/IS 10303-46:1994 for
/// the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcExternallyDefinedHatchStyle : public  IfcExternalReference, public  IfcFillStyleSelect {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedHatchStyle (IfcEntityInstanceData&& e);
    IfcExternallyDefinedHatchStyle (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name);
    typedef aggregate_of< IfcExternallyDefinedHatchStyle > list;
};
/// IfcExternallyDefinedSurfaceStyle is a definition of a surface style through referencing an external source, such as a material library for rendering information.
/// 
/// NOTE  In order to achieve expected results, the externally defined surface style should normally only be given in addition to an explicitly defined surface styles.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The spelling has been corrected from IfcExternallyDefinedSufaceStyle with no upward compatibility.
class IFC_PARSE_API IfcExternallyDefinedSurfaceStyle : public  IfcExternalReference, public  IfcSurfaceStyleElementSelect {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedSurfaceStyle (IfcEntityInstanceData&& e);
    IfcExternallyDefinedSurfaceStyle (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name);
    typedef aggregate_of< IfcExternallyDefinedSurfaceStyle > list;
};
/// Definition from ISO/CD 10303-46:1992: The externally defined text font is an external reference to a text font 
/// 
/// NOTE  Restrictions of the font source and font names to be used may be exposed by implementation guidelines.
/// 
/// NOTE  Corresponding ISO 10303 name: externally_defined_text_font. Please refer to ISO/IS 10303-46:1994, p. 137 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcExternallyDefinedTextFont : public  IfcExternalReference, public  IfcTextFontSelect {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedTextFont (IfcEntityInstanceData&& e);
    IfcExternallyDefinedTextFont (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name);
    typedef aggregate_of< IfcExternallyDefinedTextFont > list;
};
/// An individual axis, IfcGridAxis, is defined in the context of a design grid.  The axis definition is based on a curve of dimensionality 2. The grid axis is positioned within the XY plane of the position coordinate system defined by the IfcDesignGrid.
/// 
/// HISTORY  New entity in IFC Release 1.0
/// 
/// Geometry use definitions
/// The standard geometric representation of IfcGridAxis is
/// defined using a 2D curve entity. Grid axes are normally defined
/// by an offset to another axis. The IfcOffsetCurve2D
/// supports this concept.
/// Each grid axis has a sense given by the parameterization of
/// the curve. The attribute SameSense is an indicator of
/// whether or not the sense of the grid axis agrees with, or
/// opposes, that of the underlying curve.
/// As shown in Figure 242, the grid axis is defined as a 2D curve within
/// the xy plane of the position coordinate system. Any curve can be
/// used to define a grid axis, most common is the use of IfcLine for
/// linear grids and IfcCircle for radial grids.
/// Most grids are defined by a pair of axis
/// lists, each defined by a base grid axis and axes given by an
/// offset to the base axis. The use of IfcOffsetCurve2D as
/// underlying AxisCurve supports this concept.
/// 
/// Figure 242 — Grid axis
class IFC_PARSE_API IfcGridAxis : public  IfcUtil::IfcBaseEntity {
public:
    /// The tag or name for this grid axis.
    boost::optional< std::string > AxisTag() const;
    void setAxisTag(boost::optional< std::string > v);
    /// Underlying curve which provides the geometry for this grid axis.
    ::Ifc4x3_rc1::IfcCurve* AxisCurve() const;
    void setAxisCurve(::Ifc4x3_rc1::IfcCurve* v);
    /// Defines whether the original sense of curve is used or whether it is reversed in the context of the grid axis.
    bool SameSense() const;
    void setSameSense(bool v);
        aggregate_of< IfcGrid >::ptr PartOfW() const; // INVERSE IfcGrid::WAxes
    aggregate_of< IfcGrid >::ptr PartOfV() const; // INVERSE IfcGrid::VAxes
    aggregate_of< IfcGrid >::ptr PartOfU() const; // INVERSE IfcGrid::UAxes
    aggregate_of< IfcVirtualGridIntersection >::ptr HasIntersections() const; // INVERSE IfcVirtualGridIntersection::IntersectingAxes
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGridAxis (IfcEntityInstanceData&& e);
    IfcGridAxis (boost::optional< std::string > v1_AxisTag, ::Ifc4x3_rc1::IfcCurve* v2_AxisCurve, bool v3_SameSense);
    typedef aggregate_of< IfcGridAxis > list;
};
/// The IfcIrregularTimeSeriesValue describes a value (or set of values) at a particular time point. 
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcIrregularTimeSeriesValue : public  IfcUtil::IfcBaseEntity {
public:
    /// The specification of the time point.
    std::string TimeStamp() const;
    void setTimeStamp(std::string v);
    /// A list of time-series values. At least one value is required.
    aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr ListValues() const;
    void setListValues(aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIrregularTimeSeriesValue (IfcEntityInstanceData&& e);
    IfcIrregularTimeSeriesValue (std::string v1_TimeStamp, aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v2_ListValues);
    typedef aggregate_of< IfcIrregularTimeSeriesValue > list;
};
/// An IfcLibraryInformation describes a library where a library is a structured store of information, normally organized in a manner which allows information lookup through an index or reference value. IfcLibraryInformation provides the library Name and optional Version, VersionDate and Publisher attributes. A Location may be added for electronic access to the library.
/// 
/// NOTE  The complete definition of the information in an external library is out of scope in this IFC release.
/// 
/// HISTORY  New
/// Entity in IFC2x.
/// 
/// IFC2x4 CHANGE  Location attribute added, HasLibraryReferences inverse attribute added (previous LibraryReference changed to inverse).
class IFC_PARSE_API IfcLibraryInformation : public  IfcExternalInformation, public  IfcLibrarySelect {
public:
    /// The name which is used to identify the library.
    std::string Name() const;
    void setName(std::string v);
    /// Identifier for the library version used for reference.
    boost::optional< std::string > Version() const;
    void setVersion(boost::optional< std::string > v);
    /// Information of the organization that acts as the library publisher.
    ::Ifc4x3_rc1::IfcActorSelect* Publisher() const;
    void setPublisher(::Ifc4x3_rc1::IfcActorSelect* v);
    /// Date of the referenced version of the library.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed to IfcDate, the date string according to ISO8601.
    boost::optional< std::string > VersionDate() const;
    void setVersionDate(boost::optional< std::string > v);
    /// Resource identifier or locator, provided as URI, URN or URL, of the library information for online references.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Location() const;
    void setLocation(boost::optional< std::string > v);
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        aggregate_of< IfcRelAssociatesLibrary >::ptr LibraryInfoForObjects() const; // INVERSE IfcRelAssociatesLibrary::RelatingLibrary
    aggregate_of< IfcLibraryReference >::ptr HasLibraryReferences() const; // INVERSE IfcLibraryReference::ReferencedLibrary
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLibraryInformation (IfcEntityInstanceData&& e);
    IfcLibraryInformation (std::string v1_Name, boost::optional< std::string > v2_Version, ::Ifc4x3_rc1::IfcActorSelect* v3_Publisher, boost::optional< std::string > v4_VersionDate, boost::optional< std::string > v5_Location, boost::optional< std::string > v6_Description);
    typedef aggregate_of< IfcLibraryInformation > list;
};
/// An IfcLibraryReference is a reference into a library of information by Location (provided as a URI). It also provides an optional inherited Identification key to allow more specific references to library sections or tables. The inherited Name attribute allows for a human interpretable identification of the library item. Also, general information on the library from which the reference is taken, is given by the ReferencedLibrary relation which identifies the relevant occurrence of IfcLibraryInformation.
/// 
/// The ifcLibraryReference additionally provides the capability to handle multilingual library entries. The Language attribute then holds the language tag for the language used by the strings kept in the Name and the Description attribute.
/// 
/// HISTORY  New Entity in IFC2.0.
/// 
/// IFC2x4 CHANGE  Description and Language attribute added; ReferencedLibrary attribute added (reversing previous ReferenceIntoLibrary inverse relationship).
class IFC_PARSE_API IfcLibraryReference : public  IfcExternalReference, public  IfcLibrarySelect {
public:
    /// Additional description provided for the library reference.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The language in which a library reference is expressed.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Language() const;
    void setLanguage(boost::optional< std::string > v);
    /// The library information that is being referenced.
    ::Ifc4x3_rc1::IfcLibraryInformation* ReferencedLibrary() const;
    void setReferencedLibrary(::Ifc4x3_rc1::IfcLibraryInformation* v);
        aggregate_of< IfcRelAssociatesLibrary >::ptr LibraryRefForObjects() const; // INVERSE IfcRelAssociatesLibrary::RelatingLibrary
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLibraryReference (IfcEntityInstanceData&& e);
    IfcLibraryReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_Language, ::Ifc4x3_rc1::IfcLibraryInformation* v6_ReferencedLibrary);
    typedef aggregate_of< IfcLibraryReference > list;
};
/// IfcLightDistributionData defines the luminous intensity of a light source given at a particular main plane angle. It is based on some standardized light distribution curves; the MainPlaneAngle is either the 
/// 
/// A angle; if the IfcLightDistributionCurveEnum is set to TYPE_A 
/// B angle; if the IfcLightDistributionCurveEnum is set to TYPE_B 
/// C angle; if the IfcLightDistributionCurveEnum is set to TYPE_C 
/// 
/// For each MainPlaneAngle (considered as being the row of a table) a list of SecondaryPlaneAngle's are given (considered to be the columns of a table). They are either the: 
/// 
/// &#945; angle; if the IfcLightDistributionCurveEnum is set to TYPE_A 
/// &#946; angle; if the IfcLightDistributionCurveEnum is set to TYPE_B 
/// &#947; angle; if the IfcLightDistributionCurveEnum is set to TYPE_C 
/// 
/// For each pair of MainPlaneAngle and SecondaryPlaneAngle the LuminousIntensity is provided (the unit is given by the IfcUnitAssignment referring to the LuminousIntensityDistributionUnit, normally cd/klm). 
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcLightDistributionData : public  IfcUtil::IfcBaseEntity {
public:
    /// The main plane angle (A, B or C angles, according to the light distribution curve chosen).
    double MainPlaneAngle() const;
    void setMainPlaneAngle(double v);
    /// The list of secondary plane angles (the &#945;, &#946; or &#947; angles) according to the light distribution curve chosen.
    /// 
    /// NOTE: The SecondaryPlaneAngle and LuminousIntensity lists are corresponding lists.
    std::vector< double > /*[1:?]*/ SecondaryPlaneAngle() const;
    void setSecondaryPlaneAngle(std::vector< double > /*[1:?]*/ v);
    /// The luminous intensity distribution measure for this pair of main and secondary plane angles according to the light distribution curve chosen.
    std::vector< double > /*[1:?]*/ LuminousIntensity() const;
    void setLuminousIntensity(std::vector< double > /*[1:?]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightDistributionData (IfcEntityInstanceData&& e);
    IfcLightDistributionData (double v1_MainPlaneAngle, std::vector< double > /*[1:?]*/ v2_SecondaryPlaneAngle, std::vector< double > /*[1:?]*/ v3_LuminousIntensity);
    typedef aggregate_of< IfcLightDistributionData > list;
};
/// IfcLightIntensityDistribution defines the the luminous intensity of a light source that changes according to the direction of the ray. It is based on some standardized light distribution curves, which are defined by the LightDistributionCurve attribute. 
/// 
/// New entity in IFC2x2.
class IFC_PARSE_API IfcLightIntensityDistribution : public  IfcUtil::IfcBaseEntity, public  IfcLightDistributionDataSourceSelect {
public:
    /// Standardized  light distribution curve used to define the luminous intensity of the light in all directions.
    ::Ifc4x3_rc1::IfcLightDistributionCurveEnum::Value LightDistributionCurve() const;
    void setLightDistributionCurve(::Ifc4x3_rc1::IfcLightDistributionCurveEnum::Value v);
    /// Light distribution data applied to the light source. It is defined by a list of main plane angles (B or C according to the light distribution curve chosen) that includes (for each B or C angle) a second list of secondary plane angles (the &#946; or &#947; angles) and the according luminous intensity distribution measures.
    aggregate_of< ::Ifc4x3_rc1::IfcLightDistributionData >::ptr DistributionData() const;
    void setDistributionData(aggregate_of< ::Ifc4x3_rc1::IfcLightDistributionData >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightIntensityDistribution (IfcEntityInstanceData&& e);
    IfcLightIntensityDistribution (::Ifc4x3_rc1::IfcLightDistributionCurveEnum::Value v1_LightDistributionCurve, aggregate_of< ::Ifc4x3_rc1::IfcLightDistributionData >::ptr v2_DistributionData);
    typedef aggregate_of< IfcLightIntensityDistribution > list;
};
/// The map conversion deals with transforming the local engineering coordinate system, often called world coordinate system, into the coordinate reference system of the underlying map.
/// 
/// NOTE  The IfcMapConversion does not handle the projection of a map from the geodetic coordinate reference system.
/// 
/// The map conversion allows to convert the local origin of the local engineering coordinate system to its place within a map (easting, northing, orthogonal height) and to rotate the x-axis of the local engineering coordinate system within the horizontal (easting/westing) plane of the map.
/// 
/// NOTE  The z axis of the local engineering coordinate system is always parallel to the z axis of the map coordinate system.
/// 
/// The scale factor can be used when the length unit for the 3 axes of the map coordinate system are not identical with the length unit established for this project (seeIfcProject.UnitsInContext), if omitted, the scale factor 1.0 is assumed.
/// 
/// HISTORY  New entity in IFC2x4.
class IFC_PARSE_API IfcMapConversion : public  IfcCoordinateOperation {
public:
    /// Specifies the location along the easting of the coordinate system of the target map coordinate reference system.
    /// NOTE  for right-handed Cartesian coordinate systems this would establish the location along the x axis
    double Eastings() const;
    void setEastings(double v);
    /// Specifies the location along the northing of the coordinate system of the target map coordinate reference system.
    /// NOTE  for right-handed Cartesian coordinate systems this would establish the location along the y axis
    double Northings() const;
    void setNorthings(double v);
    /// Orthogonal height relativ to the vertical datum specified.
    /// NOTE  for right-handed Cartesian coordinate systems this would establish the location along the z axis
    double OrthogonalHeight() const;
    void setOrthogonalHeight(double v);
    /// Specifies the value along the easing axis of the end point of a vector indicating the position of the local x axis of the engineering coordinate reference system.
    /// NOTE  for right-handed Cartesian coordinate systems this would establish the location along the x axis
    /// NOTE  together with the XAxisOrdinate it provides the direction of the local x axis within the horizontal plane of the map coordinate system
    boost::optional< double > XAxisAbscissa() const;
    void setXAxisAbscissa(boost::optional< double > v);
    /// Specifies the value along the northing axis of the end point of a vector indicating the position of the local x axis of the engineering coordinate reference system.
    /// NOTE  for right-handed Cartesian coordinate systems this would establish the location along the y axis
    /// NOTE  together with the XAxisAbscissa it provides the direction of the local x axis within the horizontal plane of the map coordinate system
    boost::optional< double > XAxisOrdinate() const;
    void setXAxisOrdinate(boost::optional< double > v);
    /// Scale to be used, when the units of the CRS are not identical to the units of the engineering coordinate system. If omited, the value of 1.0 is assumed.
    boost::optional< double > Scale() const;
    void setScale(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMapConversion (IfcEntityInstanceData&& e);
    IfcMapConversion (::Ifc4x3_rc1::IfcCoordinateReferenceSystemSelect* v1_SourceCRS, ::Ifc4x3_rc1::IfcCoordinateReferenceSystem* v2_TargetCRS, double v3_Eastings, double v4_Northings, double v5_OrthogonalHeight, boost::optional< double > v6_XAxisAbscissa, boost::optional< double > v7_XAxisOrdinate, boost::optional< double > v8_Scale);
    typedef aggregate_of< IfcMapConversion > list;
};
/// IfcMaterialClassificationRelationship is a relationship assigning classifications to materials.
/// 
/// HISTORY New entity in IFC2x.
/// 
/// IFC2x4 CHANGE The entity IfcMaterialClassificationRelationship is deprecated since IFC2x4 and shall no longer be used. Use IfcExternalReferenceRelationship instead.
class IFC_PARSE_API IfcMaterialClassificationRelationship : public  IfcUtil::IfcBaseEntity {
public:
    /// The material classifications identifying the type of material.
    aggregate_of< ::Ifc4x3_rc1::IfcClassificationSelect >::ptr MaterialClassifications() const;
    void setMaterialClassifications(aggregate_of< ::Ifc4x3_rc1::IfcClassificationSelect >::ptr v);
    /// Material being classified.
    ::Ifc4x3_rc1::IfcMaterial* ClassifiedMaterial() const;
    void setClassifiedMaterial(::Ifc4x3_rc1::IfcMaterial* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialClassificationRelationship (IfcEntityInstanceData&& e);
    IfcMaterialClassificationRelationship (aggregate_of< ::Ifc4x3_rc1::IfcClassificationSelect >::ptr v1_MaterialClassifications, ::Ifc4x3_rc1::IfcMaterial* v2_ClassifiedMaterial);
    typedef aggregate_of< IfcMaterialClassificationRelationship > list;
};
/// IfcMaterialDefinition is a general supertype for all
/// material related information items in IFC that have common
/// material related properties that may include association of
/// material with some shape parameters or assignments to identified
/// parts of a component.
/// There are three ways of assigning materials to a single component or
/// multiple components; they are characterized as:
/// 
/// by layer - assigning a material to a layer with constant
/// thickness
/// by profile - assigning a material to a profile with a
/// constant of varying shape along an extrusion
/// by constituents - assigning a material to an identified part
/// of a component shape; the identification is by a keyword rather than 
/// by a shape parameter
/// 
/// Each instantiable subtype of IfcMaterialDefinition may
/// have material properties assigned, or have an external
/// classification of its definition. It can be assigned to either a
/// subtype of IfcElement, or a subtype of
/// IfcElementType by using the objectified relationship
/// IfcRelAssociatesMaterial.
/// 
/// HISTORY New entity in IFC2x4
class IFC_PARSE_API IfcMaterialDefinition : public  IfcUtil::IfcBaseEntity, public  IfcMaterialSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
        aggregate_of< IfcRelAssociatesMaterial >::ptr AssociatedTo() const; // INVERSE IfcRelAssociatesMaterial::RelatingMaterial
    aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    aggregate_of< IfcMaterialProperties >::ptr HasProperties() const; // INVERSE IfcMaterialProperties::Material
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialDefinition (IfcEntityInstanceData&& e);
    IfcMaterialDefinition ();
    typedef aggregate_of< IfcMaterialDefinition > list;
};
/// IfcMaterialLayer is a single and identifiable part of an element which is constructed of a number of layers (one or more). Each IfcMaterialLayer has a constant thickness and is located relative to the referencing IfcMaterialLayerSet along the MlsBase.
/// 
/// EXAMPLE  A cavity wall with brick masonry used with
/// an air gap in between would be modeled using three
/// IfcMaterialLayer's: [1] Brick, [2] Air gap, [3] Brick. The
/// inner layer "Brick" would have a Name = "Brick", an
/// individual LayerThickness, and potentially a
/// Category indicating it as "load bearing", and a
/// Priority that controls how this material layer interacts
/// with other material layers in wall connections.
/// 
/// The IfcMaterialLayer may have a material layer name,
/// that might be different to the IfcMaterial name
/// referenced.
/// 
/// EXAMPLE  The IfcMaterialLayer name of an
/// insulation layer can be "Insulation", whereas the
/// IfcMaterial name is "polystyrene insulating
/// boards".
/// 
/// HISTORY  New entity in IFC 1.5
/// 
/// IFC2x4 CHANGE  The attributes Name, Description, Category, Priority have been added at the end of attribute list. Data type of LayerThickness relaxed to IfcNonNegativeLengthMeasure.
class IFC_PARSE_API IfcMaterialLayer : public  IfcMaterialDefinition {
public:
    /// Optional reference to the material from which the layer is constructed. Note that if this value is not given, it does not denote a layer with no material (an air gap), it only means that the material is not specified at that point.
    ::Ifc4x3_rc1::IfcMaterial* Material() const;
    void setMaterial(::Ifc4x3_rc1::IfcMaterial* v);
    /// The thickness of the material layer. The dimension is measured along the positive MlsDirection as specified in IfcMaterialLayerSet (that is mapped to AXIS-2, as specified in IfcMaterialLayerSetUsage for element occurrences supporting IfcMaterialLayerSetUsage.
    /// 
    /// NOTE  The attribute value can be 0. for material thicknesses very close to zero, such as for a membrane. Material layers with thickess 0. shall not be rendered in the geometric representation.
    /// 
    /// IFC2x4 CHANGE  The attribute datatype has been changed to IfcNonNegativeLengthMeasure allowing for 0. as thickness.
    double LayerThickness() const;
    void setLayerThickness(double v);
    /// Indication of whether the material layer represents an air layer (or cavity). 
    /// 
    /// set to TRUE if the material layer is an air gap and provides air exchange from the layer to the outside air.
    ///   set to UNKNOWN if the material layer is an air gap and does not provide air exchange (or when this information about air exchange of the air gap is not available).
    ///   set to FALSE if the material layer is a solid material layer (the default).
    boost::optional< boost::logic::tribool > IsVentilated() const;
    void setIsVentilated(boost::optional< boost::logic::tribool > v);
    /// The name by which the material layer is known.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Definition of the material layer in more descriptive terms than given by attributes Name or Category.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Category of the material layer, e.g. the role it has in the layer set it belongs to (such as 'load bearing', 'thermal insulation' etc.).
    boost::optional< std::string > Category() const;
    void setCategory(boost::optional< std::string > v);
    /// The relative priority of the layer, expressed as ratio measure, normalised to 0..1. Controls how layers intersect in connections and corners of building elements: a layer from one element protrudes into (i.e. displaces) a layer from another element in a joint of these elements if the former element's layer has higher priority than the latter. The priorty value for a material layer in an element has to be set and maintained by software applications, in relation to the material layers in connected elements. The usage has to be further specified for each element, especially to avoid simultanious use with IfcLayerOffset.
    boost::optional< int > Priority() const;
    void setPriority(boost::optional< int > v);
        aggregate_of< IfcMaterialLayerSet >::ptr ToMaterialLayerSet() const; // INVERSE IfcMaterialLayerSet::MaterialLayers
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayer (IfcEntityInstanceData&& e);
    IfcMaterialLayer (::Ifc4x3_rc1::IfcMaterial* v1_Material, double v2_LayerThickness, boost::optional< boost::logic::tribool > v3_IsVentilated, boost::optional< std::string > v4_Name, boost::optional< std::string > v5_Description, boost::optional< std::string > v6_Category, boost::optional< int > v7_Priority);
    typedef aggregate_of< IfcMaterialLayer > list;
};
/// IfcMaterialLayerSet is a designation by which materials of an element constructed of a number of material layers is known and through which the relative positioning of individual layers can be expressed.
/// 
/// The Material Layer Set Base (MlsBase) describes the axis along
/// which the material layers are positioned. The MlsBase is positioned
/// along the reference axis or reference plane of the element
/// supporting the IfcMaterialLayerSetUsage concept with a
/// potential offset (see here). The positive Material Layer Set
/// Direction (MlsDirection) describes the direction by which the
/// individual material layers, with their material layer thicknesses
/// are stacked. IfcMaterialLayer's are stacked with no gap,
/// gaps within a material layer set are expresses as layers by
/// themselves.
/// 
/// EXAMPLE A cavity brick wall would be modeled as
/// IfcMaterialLayerSet consisting of three
/// IfcMaterialLayer's: brick, air cavity and brick. The air
/// gap is identified, using the IsVentilated flag at
/// IfcMaterialLayer.
/// 
/// HISTORY  New entity in IFC 1.0
/// 
/// IFC2x4 CHANGE  Subtyped from IfcMaterialDefinition, the attribute Description
/// has been added at the end of attribute list.
/// 
/// Attribute use definition
/// As shown in Figure 285, each IfcMaterialLayerSet implicitly defines a material
/// layer set base line (MlsBase), to which the start of the first
/// IfcMaterialLayer is aligned. The total thickness of a
/// layer set is calculated from the individual layer thicknesses, the
/// first layer starting from the MlsBase and following layers being
/// placed on top of the previous (no gaps or overlaps).
/// 
/// Figure 285 — Material layer set
class IFC_PARSE_API IfcMaterialLayerSet : public  IfcMaterialDefinition {
public:
    /// Identification of the layers from which the material layer set is composed.
    aggregate_of< ::Ifc4x3_rc1::IfcMaterialLayer >::ptr MaterialLayers() const;
    void setMaterialLayers(aggregate_of< ::Ifc4x3_rc1::IfcMaterialLayer >::ptr v);
    /// The name by which the material layer set is known.
    boost::optional< std::string > LayerSetName() const;
    void setLayerSetName(boost::optional< std::string > v);
    /// Definition of the material layer set in descriptive terms.
    /// 
    /// IFC2x4 CHANGE  The attribute has been added at the end of attribute list.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayerSet (IfcEntityInstanceData&& e);
    IfcMaterialLayerSet (aggregate_of< ::Ifc4x3_rc1::IfcMaterialLayer >::ptr v1_MaterialLayers, boost::optional< std::string > v2_LayerSetName, boost::optional< std::string > v3_Description);
    typedef aggregate_of< IfcMaterialLayerSet > list;
};
/// IfcMaterialLayerWithOffsets is a specialization of IfcMaterialLayer enabling definition
/// of offset values along edges (within the material layer set usage in parent layer set).
/// 
/// It defines the assignment of two offset values for a material
/// layer in its intended use within a material layer set. Offsets are
/// applied to the edges of layered elements (that is, in directions
/// perpendicular to the layer set direction). Offsets shall not be
/// used in layer set direction, that is, for modelling gaps (or overlaps)
/// between layers; gaps shall be modeled as layers with appropriate
/// material assignment for the void.
/// 
/// EXAMPLE   At the top of a standard wall,
/// with shape representation SweptSolid, offset of a given layer can
/// be specified in the direction of the extrusion (positive Z axis),
/// applied at the start or end (extruded from bottom to top), and with
/// a positive (extending above extrusion) or negative (ending below
/// extrusion).
/// 
/// Take a standard wall with the outer material layer for the
/// external isolation extending above extrusion by 100mm, but starting
/// at the same base height. In this case the following values are
/// set:
/// 
/// OffsetDirection = .AXIS3.
/// OffsetValues[1] = 0.0
/// OffsetValues[2] = 100.0 (default unit assumed to
/// be mm)
/// 
/// HISTORY  New Entity in IFC2x4.
/// 
/// Informal propositions
/// 
/// The OffestDirection shall not be identical to the
/// LayerSetDirection of the corresponding
/// IfcMaterialLayerSetUsage
/// The attribute ReferenceExtent shall be asserted at the
/// corresponding IfcMaterialLayerSetUsage
/// 
/// Attribute use definition
/// The OffsetValues and OffsetDirection correspond to the definitions ReferenceExtent and LayerSetDirection at the IfcMaterialLayerSetUsage.
/// Figure 289 shows an example of applying the OffsetValues to the material layers of a standard wall.
/// 
/// Figure 289 — Material layer with offsets
class IFC_PARSE_API IfcMaterialLayerWithOffsets : public  IfcMaterialLayer {
public:
    /// Orientation of the offset; shall be perpendicular to the parent layer set direction.
    ::Ifc4x3_rc1::IfcLayerSetDirectionEnum::Value OffsetDirection() const;
    void setOffsetDirection(::Ifc4x3_rc1::IfcLayerSetDirectionEnum::Value v);
    /// The numerical value of layer offset, in the direction of the axis assigned by the attribute OffsetDirection. The OffsetValues[1] identifies the offset from the lower position along the axis direction (normally the start of the standard extrusion), the OffsetValues[2] identifies the offset from the upper position along the axis direction (normally the end of the standard extrusion),
    std::vector< double > /*[1:2]*/ OffsetValues() const;
    void setOffsetValues(std::vector< double > /*[1:2]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayerWithOffsets (IfcEntityInstanceData&& e);
    IfcMaterialLayerWithOffsets (::Ifc4x3_rc1::IfcMaterial* v1_Material, double v2_LayerThickness, boost::optional< boost::logic::tribool > v3_IsVentilated, boost::optional< std::string > v4_Name, boost::optional< std::string > v5_Description, boost::optional< std::string > v6_Category, boost::optional< int > v7_Priority, ::Ifc4x3_rc1::IfcLayerSetDirectionEnum::Value v8_OffsetDirection, std::vector< double > /*[1:2]*/ v9_OffsetValues);
    typedef aggregate_of< IfcMaterialLayerWithOffsets > list;
};
/// IfcMaterialList is a list of the different materials
/// that are used in an element.
/// 
/// NOTE: The class IfcMaterialList will
/// normally be used where an element is described at a more abstract
/// level. For example, for an architectural specification writer,
/// the only information that may be needed about a concrete column
/// is that it contains concrete, reinforcing steel and mild steel
/// ligatures. It shall not be used for elements consisting of
/// material layers when the different layers can be defined and the
/// class IfcMaterialLayerSet can be used. Also,
/// IfcMaterialList shall not be used for elements consisting
/// of a single identifiable material (for example, to represent anisotropic
/// material).
/// 
/// IFC2x4 CHANGE The entity IfcMaterialList is deprecated and shall no longer
/// be used. Use IfcMaterialConstituentSet instead.
class IFC_PARSE_API IfcMaterialList : public  IfcUtil::IfcBaseEntity, public  IfcMaterialSelect {
public:
    /// Materials used in a composition of substances.
    aggregate_of< ::Ifc4x3_rc1::IfcMaterial >::ptr Materials() const;
    void setMaterials(aggregate_of< ::Ifc4x3_rc1::IfcMaterial >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialList (IfcEntityInstanceData&& e);
    IfcMaterialList (aggregate_of< ::Ifc4x3_rc1::IfcMaterial >::ptr v1_Materials);
    typedef aggregate_of< IfcMaterialList > list;
};
/// IfcMaterialProfile is a single and identifiable part of an element which is constructed of a number of profiles (one or more).
/// 
/// NOTE  In case of multiple MaterialProfiles, the relative positioning of individual profiles in IfcMaterialProfileSet are defined using the concept of IfcCompositeProfileDef in IfcProfileResource schema; otherwise, only one MaterialProfile is given and defined by an individual IfcProfileDef (subtype).
/// 
/// HISTORYNew Entity in IFC2x4
class IFC_PARSE_API IfcMaterialProfile : public  IfcMaterialDefinition {
public:
    /// The name by which the material profile is known.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Definition of the material profile in descriptive terms.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Optional reference to the material from which the profile is constructed.
    ::Ifc4x3_rc1::IfcMaterial* Material() const;
    void setMaterial(::Ifc4x3_rc1::IfcMaterial* v);
    /// Identification of the profile for which this material profile is associating material.
    ::Ifc4x3_rc1::IfcProfileDef* Profile() const;
    void setProfile(::Ifc4x3_rc1::IfcProfileDef* v);
    /// The relative priority of the profile, expressed as ratio measure, normalised to 0..1. Controls how profiles intersect in connections and corners of building elements: a profile from one element protrudes into (i.e. displaces) a profile from another element in a joint of these elements if the former element's profile has higher priority than the latter. The priorty value for a material profile in an element has to be set and maintained by software applications, in relation to the material profiles in connected elements.
    boost::optional< int > Priority() const;
    void setPriority(boost::optional< int > v);
    /// Category of the material profile, e.g. the role it has in the profile set it belongs to.
    boost::optional< std::string > Category() const;
    void setCategory(boost::optional< std::string > v);
        aggregate_of< IfcMaterialProfileSet >::ptr ToMaterialProfileSet() const; // INVERSE IfcMaterialProfileSet::MaterialProfiles
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialProfile (IfcEntityInstanceData&& e);
    IfcMaterialProfile (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcMaterial* v3_Material, ::Ifc4x3_rc1::IfcProfileDef* v4_Profile, boost::optional< int > v5_Priority, boost::optional< std::string > v6_Category);
    typedef aggregate_of< IfcMaterialProfile > list;
};
/// IfcMaterialProfileSet is a designation by which individual material(s) of a prismatic element (for example, beam or column) constructed of a single or multiple material profiles is known. If only a single material profile is used (the most typical case) then no CompositeProfile is asserted.
/// 
/// NOTE  In case of multiple MaterialProfiles, the relative positioning of individual profiles in IfcMaterialProfileSet are defined using the concept of IfcCompositeProfileDef in IfcProfileResource schema; otherwise, only one MaterialProfile is given and defined by an individual IfcProfileDef (subtype).
/// 
/// HISTORYNew Entity in IFC2x4.
class IFC_PARSE_API IfcMaterialProfileSet : public  IfcMaterialDefinition {
public:
    /// The name by which the material profile set is known.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Definition of the material profile set in descriptive terms.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Identification of the profiles from which the material profile set is composed.
    aggregate_of< ::Ifc4x3_rc1::IfcMaterialProfile >::ptr MaterialProfiles() const;
    void setMaterialProfiles(aggregate_of< ::Ifc4x3_rc1::IfcMaterialProfile >::ptr v);
    /// Reference to the composite profile definition for which this material profile set associates material to each of its individual profile. 
    /// 
    /// NOTE   
    /// The referenced IfcCompositeProfileDef instance shall be composed of all of the IfcProfileDef instances which are used via the MaterialProfiles list in the current IfcMaterialProfileSet .
    ::Ifc4x3_rc1::IfcCompositeProfileDef* CompositeProfile() const;
    void setCompositeProfile(::Ifc4x3_rc1::IfcCompositeProfileDef* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialProfileSet (IfcEntityInstanceData&& e);
    IfcMaterialProfileSet (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, aggregate_of< ::Ifc4x3_rc1::IfcMaterialProfile >::ptr v3_MaterialProfiles, ::Ifc4x3_rc1::IfcCompositeProfileDef* v4_CompositeProfile);
    typedef aggregate_of< IfcMaterialProfileSet > list;
};
/// IfcMaterialProfileWithOffsets is a specialization of IfcMaterialProfile enabling definition offset values for profile start or end in its use in parent material profile set usage.
/// 
/// Relative positions of IfcMaterialProfileWithOffsets in the longitudinal direction of an element can be defined giving offsets at the start and end. This shall not be used for relative positions of individual profiles in the plane of profile definition, which is given in composite profile definition itself. Also, care should be taken especially when used with IfcMaterialProfileSetUsageTapering for correct start and end offset assignement.
/// 
/// HISTORY New Entity in IFC2x4.
class IFC_PARSE_API IfcMaterialProfileWithOffsets : public  IfcMaterialProfile {
public:
    /// The numerical value of profile offset, in the direction of the axis direction - always AXIS1 i.e. the axis along the extrusion path. The OffsetValues[1] identifies the offset from the lower position along the axis direction (normally the start of the standard extrusion), the OffsetValues[2] identifies the offset from the upper position along the axis direction (normally the end of the standard extrusion),
    std::vector< double > /*[1:2]*/ OffsetValues() const;
    void setOffsetValues(std::vector< double > /*[1:2]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialProfileWithOffsets (IfcEntityInstanceData&& e);
    IfcMaterialProfileWithOffsets (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcMaterial* v3_Material, ::Ifc4x3_rc1::IfcProfileDef* v4_Profile, boost::optional< int > v5_Priority, boost::optional< std::string > v6_Category, std::vector< double > /*[1:2]*/ v7_OffsetValues);
    typedef aggregate_of< IfcMaterialProfileWithOffsets > list;
};
/// IfcMaterialUsageDefinition is a general supertype for all
/// material related information items in IFC that have occurrence
/// specific assignment parameters to assign a set of materials with
/// shape parameters to a reference geometry item of that
/// component.
/// There are two ways of assigning a set of materials with shape
/// parameters:
/// 
/// a layer set to a reference curve - assigning a material layer
/// set with material layers having a sequence and thickness
/// parameter to a reference curve of an element - represented by the
/// 'Axis' shape representation of that element
/// a profile set to a cardinal point - assigning a material
/// profile set with assigned profile geometry and insertion points
/// to a reference curve by an offset, called "cardinal point" - the
/// reference curve is represented by the 'Axis' shape representation
/// of that element
/// 
/// Each instantiable subtype of IfcMaterialUsageDefinition
/// has to be assigned to a subtype of IfcElement by using the
/// objectified relationship IfcRelAssociatesMaterial; it is
/// only valid in conjunction with an element occurrence.
/// 
/// HISTORY New entity in IFC2x4
/// 
/// Informal proposition
/// 
/// It is illegal to assign a subtype of
/// IfcMaterialUsageDefinition to a subtype of
/// IfcElementType, it shall only be assigned to an element
/// occurrence.
class IFC_PARSE_API IfcMaterialUsageDefinition : public  IfcUtil::IfcBaseEntity, public  IfcMaterialSelect {
public:
        aggregate_of< IfcRelAssociatesMaterial >::ptr AssociatedTo() const; // INVERSE IfcRelAssociatesMaterial::RelatingMaterial
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialUsageDefinition (IfcEntityInstanceData&& e);
    IfcMaterialUsageDefinition ();
    typedef aggregate_of< IfcMaterialUsageDefinition > list;
};
/// Definition from ISO/CD 10303-41:1992: A measure with unit is the specification of a physical quantity  as defined in ISO 31 (clause 2).
/// 
/// IfcMeasureWithUnit has two usages:
/// 1. For representing measure value together with its unit on the entity type attribute level; thus
///   overriding the IFC model global unit assignments.
/// 2. For conversion based unit to give the conversion rate and its base.
/// 
/// NOTE Corresponding ISO 10303 name: measure_with_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcMeasureWithUnit : public  IfcUtil::IfcBaseEntity, public  IfcAppliedValueSelect, public  IfcMetricValueSelect {
public:
    /// The value of the physical quantity when expressed in the specified units.
    ::Ifc4x3_rc1::IfcValue* ValueComponent() const;
    void setValueComponent(::Ifc4x3_rc1::IfcValue* v);
    /// The unit in which the physical quantity is expressed.
    ::Ifc4x3_rc1::IfcUnit* UnitComponent() const;
    void setUnitComponent(::Ifc4x3_rc1::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMeasureWithUnit (IfcEntityInstanceData&& e);
    IfcMeasureWithUnit (::Ifc4x3_rc1::IfcValue* v1_ValueComponent, ::Ifc4x3_rc1::IfcUnit* v2_UnitComponent);
    typedef aggregate_of< IfcMeasureWithUnit > list;
};
/// An IfcMetric is used to capture quantitative resultant metrics that can be applied to objectives. 
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use Definition 
/// IfcMetric is a subtype of IfcConstraint and may be associated with any subtype of IfcRoot through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship. 
/// 
/// The aim of IfcMetric is to capture the quantitative aspects of a constraint. 
/// 
/// For instance, when undertaking a move (instantiated through the IfcTask class), a constraint is instantiated as the class IfcMetric and may be named as a 'Move Start Constraint' or 'Move End Constraint' and described using one of a possible range of move constraints as shown in the table below. 
/// 
/// Constraint 
///   Description 
///   Benchmark 
///   Grade 
/// 
/// ASSOONASPOSSIBLE 
///   Action should commence at the earliest possible opportunity. 
///   GREATERTHANOREQUALTO 
///   SOFT 
/// 
/// MUSTSTARTON 
///   Action must start at a prescribed date/time. 
///   EQUALTO 
///   HARD 
/// 
/// MUSTSTARTBEFORE 
///   Action must start before a prescribed date/time. 
///   LESSTHANOREQUALTO 
///   HARD 
/// 
/// MUSTSTARTAFTER 
///   Action must not start before a prescribed date/time. 
///   GREATERTHANOREQUALTO 
///   HARD 
/// 
/// MAYSTARTAFTER 
///   Action may start at any time following a prescribed date/time. 
///   GREATERTHANOREQUALTO 
///   SOFT 
/// 
/// MUSTFINISHON 
///   Action must be complete at or by a prescribed date/time. 
///   EQUALTO 
///   HARD 
/// 
/// MUSTFINISHBEFORE 
///   Action must be complete before a prescribed date/time. 
///   LESSTHANOREQUALTO 
///   HARD 
/// 
/// This constraint (instantiated as IfcMetric) uses a Date/Time value in IfcMetric.DataValue through IfcMetricValueSelect. An appropriate benchmark is applied according to the requirement of the constraint (as indicated) by IfcMetric.Benchmark. The grade of the constraint (hard, soft, advisory) must be specified through		IfcConstraint.ConstraintGrade whilst the time at which the constraint is	created may be optionally asserted through IfcConstraint.CreationTime.
class IFC_PARSE_API IfcMetric : public  IfcConstraint {
public:
    /// Enumeration that identifies the type of benchmark data.
    ::Ifc4x3_rc1::IfcBenchmarkEnum::Value Benchmark() const;
    void setBenchmark(::Ifc4x3_rc1::IfcBenchmarkEnum::Value v);
    /// Reference source for data values.
    boost::optional< std::string > ValueSource() const;
    void setValueSource(boost::optional< std::string > v);
    /// The value with data type defined by the underlying type accesses via IfcMetricValueSelect.
    ::Ifc4x3_rc1::IfcMetricValueSelect* DataValue() const;
    void setDataValue(::Ifc4x3_rc1::IfcMetricValueSelect* v);
    ::Ifc4x3_rc1::IfcReference* ReferencePath() const;
    void setReferencePath(::Ifc4x3_rc1::IfcReference* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMetric (IfcEntityInstanceData&& e);
    IfcMetric (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc4x3_rc1::IfcActorSelect* v5_CreatingActor, boost::optional< std::string > v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade, ::Ifc4x3_rc1::IfcBenchmarkEnum::Value v8_Benchmark, boost::optional< std::string > v9_ValueSource, ::Ifc4x3_rc1::IfcMetricValueSelect* v10_DataValue, ::Ifc4x3_rc1::IfcReference* v11_ReferencePath);
    typedef aggregate_of< IfcMetric > list;
};
/// IfcMonetaryUnit is a unit to define currency for money.
/// 
/// HISTORY: New entity in IFC Release 2x.
/// 
/// IFC2x4 CHANGE: Type of the attribute Currency changed.
class IFC_PARSE_API IfcMonetaryUnit : public  IfcUtil::IfcBaseEntity, public  IfcUnit {
public:
    /// Code or name of the currency.  Permissible values are the three-letter alphabetic currency codes as per ISO 4217, for example CNY, EUR, GBP, JPY, USD.
    std::string Currency() const;
    void setCurrency(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMonetaryUnit (IfcEntityInstanceData&& e);
    IfcMonetaryUnit (std::string v1_Currency);
    typedef aggregate_of< IfcMonetaryUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A named unit is a unit quantity associated with the word, or group of words, by which the unit is identified.
/// 
/// NOTE Corresponding ISO 10303 name: named_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcNamedUnit : public  IfcUtil::IfcBaseEntity, public  IfcUnit {
public:
    /// The dimensional exponents of the SI base units by which the named unit is defined.
    ::Ifc4x3_rc1::IfcDimensionalExponents* Dimensions() const;
    void setDimensions(::Ifc4x3_rc1::IfcDimensionalExponents* v);
    /// The type of the unit.
    ::Ifc4x3_rc1::IfcUnitEnum::Value UnitType() const;
    void setUnitType(::Ifc4x3_rc1::IfcUnitEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcNamedUnit (IfcEntityInstanceData&& e);
    IfcNamedUnit (::Ifc4x3_rc1::IfcDimensionalExponents* v1_Dimensions, ::Ifc4x3_rc1::IfcUnitEnum::Value v2_UnitType);
    typedef aggregate_of< IfcNamedUnit > list;
};
/// IfcObjectPlacement is an abstract supertype for the special types defining the object coordinate system. The
/// IfcObjectPlacement has to be provided for each product that has a shape representation.
/// The object placement can be given:
/// 
/// absolute: by an axis2 placement, relative to the world coordinate system,
/// relative: by an axis2 placement, relative to the object placement of another product,
/// by grid reference: by the virtual intersection and reference direction given by two axes of a design grid.
/// 
/// In any case the object placement has to unambiguously define the object coordinate system as either two-dimensional axis placement (IfcAxis2Placement2D) or three-dimensional axis placement (IfcAxis2Placement3D). The axis placement may have to be calculated.
/// 
/// HISTORY New entity in IFC Release 2x.
class IFC_PARSE_API IfcObjectPlacement : public  IfcUtil::IfcBaseEntity {
public:
    ::Ifc4x3_rc1::IfcObjectPlacement* PlacementRelTo() const;
    void setPlacementRelTo(::Ifc4x3_rc1::IfcObjectPlacement* v);
        aggregate_of< IfcProduct >::ptr PlacesObject() const; // INVERSE IfcProduct::ObjectPlacement
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcObjectPlacement (IfcEntityInstanceData&& e);
    IfcObjectPlacement (::Ifc4x3_rc1::IfcObjectPlacement* v1_PlacementRelTo);
    typedef aggregate_of< IfcObjectPlacement > list;
};
/// An IfcObjective captures qualitative information for an objective-based constraint. 
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use definition 
/// 
/// IfcObjective is a subtype of IfcConstraint and may be associated with any subtype of IfcRoot through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship.
/// 
/// The aim of IfcObjective is to specify the purpose for which the constraint is applied and to capture the values of the constraint. These may be both the benchmark values that are intended to indicate the constraint extent and the resulting values in use that enable performance comparisons to be applied.
class IFC_PARSE_API IfcObjective : public  IfcConstraint {
public:
    /// A list of any benchmark values used for comparison purposes.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcConstraint >::ptr > BenchmarkValues() const;
    void setBenchmarkValues(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcConstraint >::ptr > v);
    boost::optional< ::Ifc4x3_rc1::IfcLogicalOperatorEnum::Value > LogicalAggregator() const;
    void setLogicalAggregator(boost::optional< ::Ifc4x3_rc1::IfcLogicalOperatorEnum::Value > v);
    /// Enumeration that qualifies the type of objective constraint.
    ::Ifc4x3_rc1::IfcObjectiveEnum::Value ObjectiveQualifier() const;
    void setObjectiveQualifier(::Ifc4x3_rc1::IfcObjectiveEnum::Value v);
    /// A user defined value that qualifies the type of objective constraint when ObjectiveQualifier attribute of type IfcObjectiveEnum has value USERDEFINED.
    boost::optional< std::string > UserDefinedQualifier() const;
    void setUserDefinedQualifier(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcObjective (IfcEntityInstanceData&& e);
    IfcObjective (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc4x3_rc1::IfcActorSelect* v5_CreatingActor, boost::optional< std::string > v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcConstraint >::ptr > v8_BenchmarkValues, boost::optional< ::Ifc4x3_rc1::IfcLogicalOperatorEnum::Value > v9_LogicalAggregator, ::Ifc4x3_rc1::IfcObjectiveEnum::Value v10_ObjectiveQualifier, boost::optional< std::string > v11_UserDefinedQualifier);
    typedef aggregate_of< IfcObjective > list;
};
/// A named and structured grouping with a corporate identity.
/// 
/// NOTE: The relationships between IfcOrganizations, like a Department within a Company, can be expressed using IfcOrganizationRelationship.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: organization.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// IFC 2x4 change: attribute Id renamed to Identification.
class IFC_PARSE_API IfcOrganization : public  IfcUtil::IfcBaseEntity, public  IfcActorSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// Identification of the organization.
    boost::optional< std::string > Identification() const;
    void setIdentification(boost::optional< std::string > v);
    /// The word, or group of words, by which the organization is referred to.
    std::string Name() const;
    void setName(std::string v);
    /// Text that relates the nature of the organization.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Roles played by the organization.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > Roles() const;
    void setRoles(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v);
    /// Postal and telecom addresses of an organization.
    /// NOTE: There may be several addresses related to an organization.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > Addresses() const;
    void setAddresses(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > v);
        aggregate_of< IfcOrganizationRelationship >::ptr IsRelatedBy() const; // INVERSE IfcOrganizationRelationship::RelatedOrganizations
    aggregate_of< IfcOrganizationRelationship >::ptr Relates() const; // INVERSE IfcOrganizationRelationship::RelatingOrganization
    aggregate_of< IfcPersonAndOrganization >::ptr Engages() const; // INVERSE IfcPersonAndOrganization::TheOrganization
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOrganization (IfcEntityInstanceData&& e);
    IfcOrganization (boost::optional< std::string > v1_Identification, std::string v2_Name, boost::optional< std::string > v3_Description, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v4_Roles, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > v5_Addresses);
    typedef aggregate_of< IfcOrganization > list;
};
/// IfcOwnerHistory defines all history and identification related information. In order to provide fast access it is directly attached to all independent objects, relationships and properties.
/// 
/// IfcOwnerHistory is used to identify the creating and owning application and user for the associated object, as well as capture the last modifying application and user.
/// 
/// HISTORY  New entity in IFC R1.0. Modified in IFC R2x4.
/// 
/// Informal propositions
/// 
/// If LastModifiedDate is defined but ChangeAction is not asserted, then the state of ChangeAction is assumed to be UNDEFINED.	  
/// If both LastModifiedDate and ChangeAction are asserted, then the state of ChangeAction applies to the value asserted in LastModifiedDate.
class IFC_PARSE_API IfcOwnerHistory : public  IfcUtil::IfcBaseEntity {
public:
    /// Direct reference to the end user who currently "owns" this object. Note that IFC includes the concept of ownership transfer from one user to another and therefore distinguishes between the Owning User and Creating User.
    ::Ifc4x3_rc1::IfcPersonAndOrganization* OwningUser() const;
    void setOwningUser(::Ifc4x3_rc1::IfcPersonAndOrganization* v);
    /// Direct reference to the application which currently "Owns" this object on behalf of the owning user, who uses this application. Note that IFC includes the concept of ownership transfer from one application to another and therefore distinguishes between the Owning Application and Creating Application.
    ::Ifc4x3_rc1::IfcApplication* OwningApplication() const;
    void setOwningApplication(::Ifc4x3_rc1::IfcApplication* v);
    /// Enumeration that defines the current access state of the object.
    boost::optional< ::Ifc4x3_rc1::IfcStateEnum::Value > State() const;
    void setState(boost::optional< ::Ifc4x3_rc1::IfcStateEnum::Value > v);
    /// Enumeration that defines the actions associated with changes made to the object.
    boost::optional< ::Ifc4x3_rc1::IfcChangeActionEnum::Value > ChangeAction() const;
    void setChangeAction(boost::optional< ::Ifc4x3_rc1::IfcChangeActionEnum::Value > v);
    /// Date and Time expressed in UTC (Universal Time Coordinated, formerly Greenwich Mean Time or GMT) at which the last modification was made by LastModifyingUser and LastModifyingApplication.
    boost::optional< int > LastModifiedDate() const;
    void setLastModifiedDate(boost::optional< int > v);
    /// User who carried out the last modification using LastModifyingApplication.
    ::Ifc4x3_rc1::IfcPersonAndOrganization* LastModifyingUser() const;
    void setLastModifyingUser(::Ifc4x3_rc1::IfcPersonAndOrganization* v);
    /// Application used to make the last modification.
    ::Ifc4x3_rc1::IfcApplication* LastModifyingApplication() const;
    void setLastModifyingApplication(::Ifc4x3_rc1::IfcApplication* v);
    /// The date and time expressed in UTC (Universal Time Coordinated, formerly Greenwich Mean Time or GMT) when first created by the original OwningApplication. Once defined this value remains unchanged through the lifetime of the entity.
    int CreationDate() const;
    void setCreationDate(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOwnerHistory (IfcEntityInstanceData&& e);
    IfcOwnerHistory (::Ifc4x3_rc1::IfcPersonAndOrganization* v1_OwningUser, ::Ifc4x3_rc1::IfcApplication* v2_OwningApplication, boost::optional< ::Ifc4x3_rc1::IfcStateEnum::Value > v3_State, boost::optional< ::Ifc4x3_rc1::IfcChangeActionEnum::Value > v4_ChangeAction, boost::optional< int > v5_LastModifiedDate, ::Ifc4x3_rc1::IfcPersonAndOrganization* v6_LastModifyingUser, ::Ifc4x3_rc1::IfcApplication* v7_LastModifyingApplication, int v8_CreationDate);
    typedef aggregate_of< IfcOwnerHistory > list;
};
/// Definition: an individual human being.
/// 
/// NOTE Many countries have legislation concerning the identification of individual persons within databases. Although the intent of the IFC Model is to act as a specification for data exchange 
/// and sharing, an IFC file might in some situations be considered to be a database that enables identification of a particular person under the terms of such legislation. Users should be aware of the constraints of legislation that might apply in the places where IFC files are used.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: person.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// IFC 2x4 change: attribute Id renamed to Identification.  WHERE rule relaxed to allow omission of names if Identification is provided.
class IFC_PARSE_API IfcPerson : public  IfcUtil::IfcBaseEntity, public  IfcActorSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// Identification of the person.
    boost::optional< std::string > Identification() const;
    void setIdentification(boost::optional< std::string > v);
    /// The name by which the family identity of the person may be recognized.
    /// NOTE: Depending on geographical location and culture, family name may appear either as the first or last component of a name.
    boost::optional< std::string > FamilyName() const;
    void setFamilyName(boost::optional< std::string > v);
    /// The name by which a person is known within a family and by which he or she may be familiarly recognized.
    /// NOTE: Depending on geographical location and culture, given name may appear either as the first or last component of a name.
    boost::optional< std::string > GivenName() const;
    void setGivenName(boost::optional< std::string > v);
    /// Additional names given to a person that enable their identification apart from others who may have the same or similar family and given names.
    /// NOTE: Middle names are not normally used in familiar communication but may be asserted to provide additional 
    /// identification of a particular person if necessary. They may be particularly useful in situations where the person concerned has a 
    /// family name that occurs commonly in the geographical region.
    boost::optional< std::vector< std::string > /*[1:?]*/ > MiddleNames() const;
    void setMiddleNames(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// The word, or group of words, which specify the person's social and/or professional standing and appear before his/her names.
    boost::optional< std::vector< std::string > /*[1:?]*/ > PrefixTitles() const;
    void setPrefixTitles(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// The word, or group of words, which specify the person's social and/or professional standing and appear after his/her names.
    boost::optional< std::vector< std::string > /*[1:?]*/ > SuffixTitles() const;
    void setSuffixTitles(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// Roles played by the person.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > Roles() const;
    void setRoles(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v);
    /// Postal and telecommunication addresses of a person.
    /// NOTE - A person may have several addresses.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > Addresses() const;
    void setAddresses(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > v);
        aggregate_of< IfcPersonAndOrganization >::ptr EngagedIn() const; // INVERSE IfcPersonAndOrganization::ThePerson
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPerson (IfcEntityInstanceData&& e);
    IfcPerson (boost::optional< std::string > v1_Identification, boost::optional< std::string > v2_FamilyName, boost::optional< std::string > v3_GivenName, boost::optional< std::vector< std::string > /*[1:?]*/ > v4_MiddleNames, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_PrefixTitles, boost::optional< std::vector< std::string > /*[1:?]*/ > v6_SuffixTitles, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v7_Roles, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcAddress >::ptr > v8_Addresses);
    typedef aggregate_of< IfcPerson > list;
};
/// Definition: Identification of a person within an organization.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: person_and_organization.
/// 
/// HISTORY New entity in IFC Release 1.5.1
class IFC_PARSE_API IfcPersonAndOrganization : public  IfcUtil::IfcBaseEntity, public  IfcActorSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// The person who is related to the organization.
    ::Ifc4x3_rc1::IfcPerson* ThePerson() const;
    void setThePerson(::Ifc4x3_rc1::IfcPerson* v);
    /// The organization to which the person is related.
    ::Ifc4x3_rc1::IfcOrganization* TheOrganization() const;
    void setTheOrganization(::Ifc4x3_rc1::IfcOrganization* v);
    /// Roles played by the person within the context of an organization.  These may differ from the roles in ThePerson.Roles which may be asserted without organizational context.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > Roles() const;
    void setRoles(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPersonAndOrganization (IfcEntityInstanceData&& e);
    IfcPersonAndOrganization (::Ifc4x3_rc1::IfcPerson* v1_ThePerson, ::Ifc4x3_rc1::IfcOrganization* v2_TheOrganization, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorRole >::ptr > v3_Roles);
    typedef aggregate_of< IfcPersonAndOrganization > list;
};
/// The physical quantity, IfcPhysicalQuantity, is an abstract entity that holds a complex or simple quantity measure together with a semantic definition of the usage for the single or several measure value. 
/// 
/// The Name attribute defines the actual usage or kind of measure. The interpretation of the name label has to be established within the actual exchange context. In addition an informative text may be associated to each quantity by the Description attribute. 
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcPhysicalQuantity : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// Name of the element quantity or measure. The name attribute has to be made recognizable by further agreements.
    std::string Name() const;
    void setName(std::string v);
    /// Further explanation that might be given to the quantity.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    aggregate_of< IfcPhysicalComplexQuantity >::ptr PartOfComplex() const; // INVERSE IfcPhysicalComplexQuantity::HasQuantities
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPhysicalQuantity (IfcEntityInstanceData&& e);
    IfcPhysicalQuantity (std::string v1_Name, boost::optional< std::string > v2_Description);
    typedef aggregate_of< IfcPhysicalQuantity > list;
};
/// The physical quantity, IfcPhysicalSimpleQuantity, is an entity that holds a single quantity measure value (as defined at the subtypes of IfcPhysicalSimpleQuantity) together with a semantic definition of the usage for the measure value. 
/// 
/// EXAMPLE  An element, like a wall, may have several area measures, like footprint area, left wall face area, right wall face area. These areas would be given by three instances of the area quantity subtype, with different Name string values.
/// 
/// A section "Quantity Use Definition" at individual entities as subtypes of IfcBuildingElement gives guidance to the usage of the Name attribute to characterize the individual quantities. If the Unit attribute is given, the value attribute (introduced at the level of subtypes of IfcPhysicalSimpleQuantity) are given as quantities of this unit, otherwise the global unit definitions (given by IfcUnitAssignment) are used.
/// 
/// HISTORY New entity in IFC2x2 Addendum 1.
/// 
/// IFC2x2 ADDENDUM 1 CHANGE  The abstract entity IfcPhysicalSimpleQuantity has been added. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcPhysicalSimpleQuantity : public  IfcPhysicalQuantity {
public:
    /// Optional assignment of a unit. If no unit is given, then the global unit assignment, as established at the IfcProject, applies to the quantity measures.
    ::Ifc4x3_rc1::IfcNamedUnit* Unit() const;
    void setUnit(::Ifc4x3_rc1::IfcNamedUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPhysicalSimpleQuantity (IfcEntityInstanceData&& e);
    IfcPhysicalSimpleQuantity (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit);
    typedef aggregate_of< IfcPhysicalSimpleQuantity > list;
};
/// Definition: The address for delivery of paper based mail.
/// 
/// HISTORY New entity in IFC Release 2x.
class IFC_PARSE_API IfcPostalAddress : public  IfcAddress {
public:
    /// An organization defined address for internal mail delivery.
    boost::optional< std::string > InternalLocation() const;
    void setInternalLocation(boost::optional< std::string > v);
    /// The postal address.
    /// NOTE: A postal address may occupy several lines (or elements) when recorded. 
    /// It is expected that normal usage will incorporate relevant elements of the following address concepts: 
    /// A location within a building (e.g. 3rd Floor) Building name (e.g. Interoperability House) Street number 
    /// (e.g. 6400) Street name (e.g. Alliance Boulevard). Typical content of address lines may vary in different 
    /// countries.
    boost::optional< std::vector< std::string > /*[1:?]*/ > AddressLines() const;
    void setAddressLines(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// An address that is implied by an identifiable mail drop.
    boost::optional< std::string > PostalBox() const;
    void setPostalBox(boost::optional< std::string > v);
    /// The name of a town.
    boost::optional< std::string > Town() const;
    void setTown(boost::optional< std::string > v);
    /// The name of a region.
    /// NOTE: The counties of the United Kingdom and the states of North America are examples of regions.
    boost::optional< std::string > Region() const;
    void setRegion(boost::optional< std::string > v);
    /// The code that is used by the country's postal service.
    boost::optional< std::string > PostalCode() const;
    void setPostalCode(boost::optional< std::string > v);
    /// The name of a country.
    boost::optional< std::string > Country() const;
    void setCountry(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPostalAddress (IfcEntityInstanceData&& e);
    IfcPostalAddress (boost::optional< ::Ifc4x3_rc1::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose, boost::optional< std::string > v4_InternalLocation, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_AddressLines, boost::optional< std::string > v6_PostalBox, boost::optional< std::string > v7_Town, boost::optional< std::string > v8_Region, boost::optional< std::string > v9_PostalCode, boost::optional< std::string > v10_Country);
    typedef aggregate_of< IfcPostalAddress > list;
};

class IFC_PARSE_API IfcPresentationItem : public  IfcUtil::IfcBaseEntity {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationItem (IfcEntityInstanceData&& e);
    IfcPresentationItem ();
    typedef aggregate_of< IfcPresentationItem > list;
};
/// The presentation layer assignment provides the layer name (and optionally a description and an identifier) for a collection of geometric representation items. The IfcPresentationLayerAssignment corresponds to the term "CAD Layer" and is used mainly for grouping and visibility control.
/// 
/// NOTE  The use of presentation layer shall be restricted to simple grouping and displaying purposes.
/// 
/// Visibility and access control and layer style assignment (colour, line style, line width) is handled by the subtype IfcPresentationLayerAssignmentWithStyle.
/// 
/// NOTE  Corresponding ISO 10303 name: presentation layer assignment. Please refer to ISO/IS 10303-46:1994, p. 36 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// Attribute use definition
/// 
/// Figure 305 illustrates assignment of items by shape representation or representation item. The set of AssignedItems can either include a whole shape representation, or individual geometric representation items. If both, the IfcShapeRepresentation has a layer assignment, and an individual geometric representation item in the set of IfcShapeRepresentation.Items, then the layer assignment of the IfcGeometricRepresentationItem overides the layer assignment of the IfcShapeRepresentation.
/// 
/// Figure 305 — Presentation layer assignment
class IFC_PARSE_API IfcPresentationLayerAssignment : public  IfcUtil::IfcBaseEntity {
public:
    /// Name of the layer.
    std::string Name() const;
    void setName(std::string v);
    /// Additional description of the layer.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The set of layered items, which are assigned to this layer.
    aggregate_of< ::Ifc4x3_rc1::IfcLayeredItem >::ptr AssignedItems() const;
    void setAssignedItems(aggregate_of< ::Ifc4x3_rc1::IfcLayeredItem >::ptr v);
    /// An (internal) identifier assigned to the layer.
    boost::optional< std::string > Identifier() const;
    void setIdentifier(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationLayerAssignment (IfcEntityInstanceData&& e);
    IfcPresentationLayerAssignment (std::string v1_Name, boost::optional< std::string > v2_Description, aggregate_of< ::Ifc4x3_rc1::IfcLayeredItem >::ptr v3_AssignedItems, boost::optional< std::string > v4_Identifier);
    typedef aggregate_of< IfcPresentationLayerAssignment > list;
};
/// An IfcPresentationLayerAssignmentWithStyle extends the presentation layer assignment with capabilities to define visibility control, access control and common style information.
/// 
/// The visibility control allows to define a layer to be either 'on' or 'off', and/or 'frozen' or 'not frozen'. The access control allows to block graphical entities from manipulations by setting a layer to be either 'blocked' or 'not blocked'. Common style information can be given to the layer.
/// 
/// NOTE  Style information assigned to layers is often restricted to 'layer colour', 'curve font', and/or 'curve width'. These styles are assigned by using the IfcCurveStyle within the LayerStyles.
/// 
/// NOTE: If a styled item is assigned to a layer using the IfcPresentationLayerAssignmentWithStyle, it inherits the style information from the layer. In this case, it should omit its own style information. If the styled item has style information assigned (such as by IfcCurveStyle, IfcFillAreaStyle, IfcTextStyle, IfcSurfaceStyle, IfcSymbolStyle), then it overrides the style provided by the IfcPresentationLayerAssignmentWithStyle.
/// 
/// NOTE  The IfcPresentationLayerAssignmentWithStyle extends the presentation_layer_assignment entity as defined in ISO/IS 10303-46:1994, p. 36.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attributes have been modified without upward compatibility.
class IFC_PARSE_API IfcPresentationLayerWithStyle : public  IfcPresentationLayerAssignment {
public:
    /// A logical setting, TRUE indicates that the layer is set to 'On', FALSE that the layer is set to 'Off', UNKNOWN that such information is not available.
    boost::logic::tribool LayerOn() const;
    void setLayerOn(boost::logic::tribool v);
    /// A logical setting, TRUE indicates that the layer is set to 'Frozen', FALSE that the layer is set to 'Not frozen', UNKNOWN that such information is not available.
    boost::logic::tribool LayerFrozen() const;
    void setLayerFrozen(boost::logic::tribool v);
    /// A logical setting, TRUE indicates that the layer is set to 'Blocked', FALSE that the layer is set to 'Not blocked', UNKNOWN that such information is not available.
    boost::logic::tribool LayerBlocked() const;
    void setLayerBlocked(boost::logic::tribool v);
    /// Assignment of presentation styles to the layer to provide a default style for representation items.
    /// 
    /// NOTE  In most cases the assignment of styles to a layer is restricted to an IfcCurveStyle representing the layer curve colour, layer curve thickness, and layer curve type.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed from IfcPresentationStyleSelect (now deprecated) to IfcPresentationStyle.
    aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyle >::ptr LayerStyles() const;
    void setLayerStyles(aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyle >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationLayerWithStyle (IfcEntityInstanceData&& e);
    IfcPresentationLayerWithStyle (std::string v1_Name, boost::optional< std::string > v2_Description, aggregate_of< ::Ifc4x3_rc1::IfcLayeredItem >::ptr v3_AssignedItems, boost::optional< std::string > v4_Identifier, boost::logic::tribool v5_LayerOn, boost::logic::tribool v6_LayerFrozen, boost::logic::tribool v7_LayerBlocked, aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyle >::ptr v8_LayerStyles);
    typedef aggregate_of< IfcPresentationLayerWithStyle > list;
};
/// IfcPresentationStyle is an abstract generalization of style table for presentation information assigned to geometric representation items. It includes styles for curves, areas, surfaces, text and symbols. Style information may include colour, hatching, rendering, and text fonts.
/// 
/// Each subtype of  IfcPresentationStyle can be assigned to IfcGeometricRepresentationItem's via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or one of its subtypes.
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcPresentationStyle : public  IfcUtil::IfcBaseEntity, public  IfcStyleAssignmentSelect {
public:
    /// Name of the presentation style.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationStyle (IfcEntityInstanceData&& e);
    IfcPresentationStyle (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcPresentationStyle > list;
};
/// Definition from ISO/CD 10303-46:1992: The presentation style assignment is a set of styles which are assigned to styled items for the purpose of presenting these styled items. 
/// 
/// NOTE Corresponding ISO 10303 name: presentation_style_assignment. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in Release IFC2x2.
class IFC_PARSE_API IfcPresentationStyleAssignment : public  IfcUtil::IfcBaseEntity, public  IfcStyleAssignmentSelect {
public:
    /// A set of presentation styles that are assigned to styled items.
    aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyleSelect >::ptr Styles() const;
    void setStyles(aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyleSelect >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationStyleAssignment (IfcEntityInstanceData&& e);
    IfcPresentationStyleAssignment (aggregate_of< ::Ifc4x3_rc1::IfcPresentationStyleSelect >::ptr v1_Styles);
    typedef aggregate_of< IfcPresentationStyleAssignment > list;
};
/// IfcProductRepresentation defines a representation of a
/// product, including its (geometric or topological) representation.
/// A product can have zero, one or many geometric representations,
/// and a single geometric representation can be shared among various
/// products using mapped representations.
/// 
/// NOTE: The definition
/// of this entity relates to the ISO 10303 entity property_definition.
/// The use of the term ‘property’ was avoided since it
/// conflicts with the property, property type, and property set
/// definitions elsewhere in the IFC model.
/// 
/// HISTORY New entity in IFC Release 2.0
/// 
/// IFC2x3 NOTE Users should not instantiate the entity from IFC2x Edition 3 onwards.
/// 
/// IFC2x4 CHANGE  Entity made abstract.
class IFC_PARSE_API IfcProductRepresentation : public  IfcUtil::IfcBaseEntity {
public:
    /// The word or group of words by which the product representation is known.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// The word or group of words that characterize the product representation. It can be used to add additional meaning to the name of the product representation.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Contained list of representations (including shape representations). Each member defines a valid representation of a particular type within a particular representation context.
    aggregate_of< ::Ifc4x3_rc1::IfcRepresentation >::ptr Representations() const;
    void setRepresentations(aggregate_of< ::Ifc4x3_rc1::IfcRepresentation >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProductRepresentation (IfcEntityInstanceData&& e);
    IfcProductRepresentation (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, aggregate_of< ::Ifc4x3_rc1::IfcRepresentation >::ptr v3_Representations);
    typedef aggregate_of< IfcProductRepresentation > list;
};
/// IfcProfileDef
/// is the supertype of all definitions of standard and arbitrary profiles
/// within IFC. It is used to define a standard set of commonly used
/// section profiles by their parameters or by their explicit curve geometry.
/// 
/// Parameterized profiles are 2D primitives, which are used within the industry to describe cross
///   sections by a description of its parameters.
///   Arbitrary profiles are cross
///   sections defined by an outer boundary as bounded curve, which may also
///   include holes, defined by inner boundaries.
///   Derived profiles, based on a
///   transformation of a parent profile, are also part of the profile
///   definitions available.
///   In addition composite
///   profiles can be defined, which include two or more profile definitions
///   to define the resulting profile.
/// 
/// HISTORY  New class in IFC Release 1.5, the capabilities have been extended in IFC Release 2x.
/// Profiles can now support swept surfaces and swept area solids with
/// inner boundaries. It had been renamed from IfcAttDrivenProfileDef.
/// 
/// IFC2x4 CHANGE  Changed from ABSTRACT to non-abstract for uses which do not
/// require an explicitly defined geometry.  Added inverse attributes HasProperties and HasExternalReference.
/// 
/// Use in material association
/// 
/// Beams, columns, and similarly shaped building elements and their type objects may
/// be associated with a section profile definition, combined with material definition,
/// by means of IfcRelAssociatesMaterial together with IfcMaterialProfileSet
/// and IfcMaterialProfileSetUsage. This way, building elements and element types
/// with same section and material can share a common section profile definition and
/// association.
/// 
/// The profile definition in material association is required to be consistent with
/// shape representations of the respective building elements.
/// 
/// A higher-level description of spatial aligment of the section profile of a member
/// (such as centered, bottom-left, in the geometric centroid, and more) can be provided
/// within IfcMaterialProfileSetUsage by means of a cardinal point reference.
/// This can be used redundant to geometric data in order to convey design intent.
/// 
/// Use in shape models
/// 
/// Profile definitions are used within the geometry and geometric model
/// resource to create either swept surfaces, swept area solids, or
/// sectioned spines.
/// 
/// The purpose of the profile
/// definition within the swept surfaces or swept area solids is to define
/// a uniform cross section being swept:
/// 
/// along a line (extrusion) using IfcSurfaceOfLinearExtrusion or IfcExtrudedAreaSolid
///   along a circular arc (revolution) using IfcSurfaceOfRevolution or IfcRevolvedAreaSolid
///   along a directrix lying on a reference surface using IfcSurfaceCurveSweptAreaSolid
/// 
/// The purpose fo the profile
/// definition within the sectioned spine is to define a varying cross
/// sections at several positions along a spine curve. The subtype IfcDerivedProfileDef
/// is particularly suited to provide the consecutive profiles to be based
/// on transformations of the start profile and thus maintaining the
/// identity of vertices and edges.
/// 
/// NOTE  Subtypes of the IfcProfileDef
/// contain parameterized profiles (as subtypes of IfcParameterizedProfileDef)
/// which establish their own 2D position coordinate system, profiles given
/// by explicit curve geometry (either open or closed profiles) and two
/// special types for composite profiles and derived profiles, based on a
/// 2D Cartesian transformation.
/// 
/// An IfcProfileDef
/// is treated as bounded area if it is used within swept area solids. In
/// this case, the inside of the profile is part of the profile. The
/// attribute ProfileType is set to AREA. An IfcProfileDef
/// is treated as a curve if it is used within swept surfaces. In this
/// case, the inside of the profile (if the curve is closed) is not part of
/// the profile. The attribute ProfileType
/// is set to CURVE.
/// 
/// Figure 320 illustrates use of parameterized profiles within a swept area solid.
/// 
/// Position
/// The IfcProfileDef is defined within the underlying
/// coordinate system which is defined by the swept surface or swept area solid
/// that uses the profile definition. It is the xy plane
/// 
/// of IfcSweptSurface.Position or
///   of IfcSweptAreaSolid.Position or
///   of each list member of IfcSectionedSpine.CrossSectionPositions.
/// 
/// In the figure to the left, the z axis of the position coordinate system points outwards of the drawing plane.
/// 
/// Note: The subtype IfcParameterizedProfileDef optionally provides an additional 2D position coordinate system relative to the underlying coordinate system of the IfcProfileDef.
/// 
/// Sweeping
/// 
/// In the later use of the IfcProfileDef
/// within the swept surface or swept area solid,  e.g. the IfcExtrudedAreaSolid
/// (here used as an example), the profile boundaries (here based on the 2D
/// position coordinate system of IfcParameterizedProfileDef)
/// are placed within the xy plane of the 3D position coordinate system of
/// the swept surface or swept area solid.
/// 
/// The profile is inserted into the underlying coordinate system either:
/// 
/// directly in case of using IfcArbitraryClosedProfileDef
///   and IfcArbitraryOpenProfileDef,
/// 
/// through an intermediate position coordinate system in case of
///   using IfcParameterizedProfileDef.
/// 
/// through an 2D Cartesian transformation operator (applied directly
///   to the curve position when using arbitrary profile definitions,
///   or applied to the position coordinate system when using parameterized
///   profile definitions) in case of using IfcDerivedProfileDef.
/// 
/// when using IfcCompositeProfileDef the insertion depends on
///   the subtype of the included sub-profiles.
/// 
/// Figure 320 — Profile sweeping
/// 
/// Profile types
/// 
/// Results of the different usage of the ProfileType attribute are demonstrated here. The ProfileType defines whether the inside (the bounded area) is part of the profile definition (Area) or not (Curve). Figure 321 illustrates the resulting area or curve depending on ProfileType.
/// 
/// ProfileType = AREA
/// 
/// ProfileType = CURVE
/// 
/// Figure 321 — Profile types
/// 
/// Profile specification by external reference
/// 
/// If the profile is standardized by a norm or a catalogue, a reference
/// to this norm or catalogue should be provided by means of HasExternalReference.
/// This inverse relationship is used to associate an IfcExternalReference (notably
/// IfcClassificationReference or IfcLibraryReference) with the
/// profile.
/// 
/// IfcClassificationReference is used to refer to a profile norm (a common standard or
/// manufacturer's standard).  In this case,
/// 
/// IfcClassificationReference.ItemReference
/// contains the formal profile designation from the norm.
/// (On the other hand, IfcProfileDef.ProfileName contains a displayable name which may
/// not necessarily be the same as the formal designation.)
/// IfcClassificationReference.Name carries the short name of the profile norm.
/// Optionally, the norm can be further described by
/// IfcClassificationReference.ReferencedSource.
/// 
/// IfcLibraryReference is used to refer to a library which contains profile
/// definitions. In this case,
/// 
/// IfcLibraryReference.ItemReference contains the identifier of the
/// profile within the library and is meant to be machine-readable (in contrast to
/// IfcProfileDef.ProfileName which should be human-readable).
/// IfcLibraryReference.Location and .Name or .ReferencedLibrary
/// further describe the library.
/// 
/// If an external reference is provided, sending systems shall ensure that
/// the shape of the profile definition object agrees with the definitions in the
/// referenced classification or library.
/// 
/// Direct instances of IfcProfileDef
/// 
/// Usually, only subtypes of IfcProfileDef should be instantiated.
/// In some special cases, e.g. if the profile object is used for purposes
/// other than geometric models (e.g. for structural analysis models), it may be
/// possible to directly instantiate IfcProfileDef and further specify
/// the profile only by external reference or by profile properties. The latter
/// are tracked by the inverse attribute HasProperties.
class IFC_PARSE_API IfcProfileDef : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// Defines the type of geometry into which this profile definition shall be resolved, either a curve or a surface area. In case of curve the profile should be referenced by a swept surface, in case of area the profile should be referenced by a swept area solid.
    ::Ifc4x3_rc1::IfcProfileTypeEnum::Value ProfileType() const;
    void setProfileType(::Ifc4x3_rc1::IfcProfileTypeEnum::Value v);
    /// Human-readable name of the profile, for example according to a standard profile table. As noted above, machine-readable standardized profile designations should be provided in IfcExternalReference.ItemReference.
    boost::optional< std::string > ProfileName() const;
    void setProfileName(boost::optional< std::string > v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    aggregate_of< IfcProfileProperties >::ptr HasProperties() const; // INVERSE IfcProfileProperties::ProfileDefinition
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProfileDef (IfcEntityInstanceData&& e);
    IfcProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName);
    typedef aggregate_of< IfcProfileDef > list;
};
/// Definition from OpenGIS® Abstract Specification,
///   Topic 2: A 2D (or with vertical coordinate axis 3D)
///   coordinate reference system used to approximate the shape
///   of the earth on a planar surface, but in such a way that
///   the distortion that is inherent to the approximation is
///   carefully controlled and known. Distortion correction is
///   commonly applied to calculated bearings and distances to
///   produce values that are a close match to actual field
///   values.
///   IfcProjectedCRS is a coordinate reference system of
///   the map to which the map translation of the local
///   engineering coordinate system of the construction or
///   facility engineering project relates. The
///   MapProjection and MapZone attributes uniquely
///   identify the projection to the underlying geographic
///   coordinate reference system, provided that they are
///   well-known in the receiving application.
///   The projected coordinate reference system is assumed to be
///   a 2D or 3D right-handed Cartesian coordinate system, the
///   optional MapUnit attribute can be used determine the
///   length unit used by the map.
/// 
/// HISTORY  New entity in IFC2x4.
class IFC_PARSE_API IfcProjectedCRS : public  IfcCoordinateReferenceSystem {
public:
    /// Name by which the map projection is identified.
    /// 
    /// UTM
    ///   Gaus-Krueger
    boost::optional< std::string > MapProjection() const;
    void setMapProjection(boost::optional< std::string > v);
    /// Name by which the map zone, relating to the MapProjection, is identified. Examples are
    /// 
    /// for UTM, the zone number, like 32 for UTM32
    ///   for Gaus-Krueger, the zones of longitudinal width, like 3'
    boost::optional< std::string > MapZone() const;
    void setMapZone(boost::optional< std::string > v);
    /// Unit of the coordinate axes composing the map coordinate system.
    /// NOTE  Only length measures are in scope and all two or three axes of the map coordinate system shall have the same length unit.
    ::Ifc4x3_rc1::IfcNamedUnit* MapUnit() const;
    void setMapUnit(::Ifc4x3_rc1::IfcNamedUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProjectedCRS (IfcEntityInstanceData&& e);
    IfcProjectedCRS (std::string v1_Name, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_GeodeticDatum, boost::optional< std::string > v4_VerticalDatum, boost::optional< std::string > v5_MapProjection, boost::optional< std::string > v6_MapZone, ::Ifc4x3_rc1::IfcNamedUnit* v7_MapUnit);
    typedef aggregate_of< IfcProjectedCRS > list;
};

class IFC_PARSE_API IfcPropertyAbstraction : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyAbstraction (IfcEntityInstanceData&& e);
    IfcPropertyAbstraction ();
    typedef aggregate_of< IfcPropertyAbstraction > list;
};
/// IfcPropertyEnumeration is a collection of simple
/// or measure values that define a prescribed set of alternatives from
/// which 'enumeration values' are selected. This enables inclusion of
/// enumeration values in property sets. IfcPropertyEnumeration
/// provides a name for the enumeration as well as a list of unique
/// (numeric or descriptive) values (that may have a measure type
/// assigned). The entity defines the list of potential enumerators to be
/// exchanged together (or separately) with properties of type IfcPropertyEnumeratedValue
/// that selects their actual property values from this enumeration. 
/// The unit is handled by the Unit attribute:
/// 
/// If the Unit attribute is not given,
/// than the unit is already implied by the type of IfcMeasureValue
/// or IfcDerivedMeasureValue. The associated unit can
/// be found at the IfcUnitAssignment globally defined
/// at the project level (IfcProject.UnitsInContext).
///   If the Unit attribute is given, the
/// unit assigned by the unit attribute overrides the globally assigned
/// unit.
/// 
/// Name
///   EnumerationValues
///   Type (through IfcValue)
///   Unit
/// 
/// PEnum_DamperBladeAction
///   Parallel
///   IfcString
///   -
/// 
///  
///   Opposed
///   IfcString
///    
/// 
///  
///   Other
///   IfcString
///    
/// 
///  
///   Unset
///   IfcString
///    
/// 
/// HISTORY  New Entity in IFC Release 2.0, capabilities enhanced in IFC Release 2x. Entity has been renamed from IfcEnumeration in IFC Release 2x.
class IFC_PARSE_API IfcPropertyEnumeration : public  IfcPropertyAbstraction {
public:
    /// Name of this enumeration.
    std::string Name() const;
    void setName(std::string v);
    /// List of values that form the enumeration.
    aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr EnumerationValues() const;
    void setEnumerationValues(aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v);
    /// Unit for the enumerator values, if not given, the default value for the measure type (given by the TYPE of nominal value) is used as defined by the global unit assignment at IfcProject.
    ::Ifc4x3_rc1::IfcUnit* Unit() const;
    void setUnit(::Ifc4x3_rc1::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyEnumeration (IfcEntityInstanceData&& e);
    IfcPropertyEnumeration (std::string v1_Name, aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v2_EnumerationValues, ::Ifc4x3_rc1::IfcUnit* v3_Unit);
    typedef aggregate_of< IfcPropertyEnumeration > list;
};
/// IfcQuantityArea is a physical quantity that defines a derived area measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  An opening may have an opening area used to deduct it from the wall surface area. The actual size of the area depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityArea : public  IfcPhysicalSimpleQuantity {
public:
    /// Area measure value of this quantity.
    double AreaValue() const;
    void setAreaValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityArea (IfcEntityInstanceData&& e);
    IfcQuantityArea (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_AreaValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityArea > list;
};
/// IfcQuantityCount is a physical quantity that defines a derived count measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  An radiator may be measured according to its number of coils. The actual counting method depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityCount : public  IfcPhysicalSimpleQuantity {
public:
    /// Count measure value of this quantity.
    double CountValue() const;
    void setCountValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityCount (IfcEntityInstanceData&& e);
    IfcQuantityCount (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_CountValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityCount > list;
};
/// IfcQuantityLength is a physical quantity that defines a derived length measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  A rafter within a roof construction may be measured according to its length (taking a common cross section into account). The actual size of the length depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC Release 2.x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityLength : public  IfcPhysicalSimpleQuantity {
public:
    /// Length measure value of this quantity.
    double LengthValue() const;
    void setLengthValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityLength (IfcEntityInstanceData&& e);
    IfcQuantityLength (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_LengthValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityLength > list;
};
/// IfcQuantityTime is an element quantity that defines a time measure to provide an property of time related to an element. It is normally given by the recipe information of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  The amount of time needed to pour concrete for a wall is given as a time quantity for the labor part of the recipe information.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcQuantityTime : public  IfcPhysicalSimpleQuantity {
public:
    /// Time measure value of this quantity.
    double TimeValue() const;
    void setTimeValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityTime (IfcEntityInstanceData&& e);
    IfcQuantityTime (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_TimeValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityTime > list;
};
/// IfcQuantityVolume is a physical quantity that defines a derived volume measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  A thick brick wall may be measured according to its volume. The actual size of the volume depends on the method of measurement used.
/// 
/// HISTORY New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityVolume : public  IfcPhysicalSimpleQuantity {
public:
    /// Volume measure value of this quantity.
    double VolumeValue() const;
    void setVolumeValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityVolume (IfcEntityInstanceData&& e);
    IfcQuantityVolume (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_VolumeValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityVolume > list;
};
/// IfcQuantityWeight is a physical element quantity that defines a derived weight measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  The amount of reinforcement used within a building element may be measured according to its weight. The actual size of the weight depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityWeight : public  IfcPhysicalSimpleQuantity {
public:
    /// Mass measure value of this quantity.
    double WeightValue() const;
    void setWeightValue(double v);
    /// A formula by which the quantity has been calculated. It can be assigned in addition to the actual value of the quantity. Formulas could be mathematic calculations (like width x height), database links, or a combination. The formula is for informational purposes only.
    /// 
    /// IFC2x4 CHANGE  Attribute added to the end of the attribute list.
    boost::optional< std::string > Formula() const;
    void setFormula(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityWeight (IfcEntityInstanceData&& e);
    IfcQuantityWeight (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcNamedUnit* v3_Unit, double v4_WeightValue, boost::optional< std::string > v5_Formula);
    typedef aggregate_of< IfcQuantityWeight > list;
};
/// IfcRecurrencePattern defines repetitive time periods on the basis of regular recurrences such as each Monday in a week, or every third Tuesday in a month.  The population of the remaining attributes such as DayComponent, Position, and Interval depend on the specified recurrence type.
/// 
/// HISTORY: New entity in IFC2x4.
/// 
/// Use definitions
/// IfcRecurrencePattern supports various recurrence patterns that are differentiated by a type definition (IfcRecurrencePattern.RecurrenceType), which is required to provide the meaning of the given values. It can be further constrained by applicable times through specified IfcTimePeriod instances, thus enabling time periods such as between 7:00 and 12:00 and between 13:00 and 17:00 for each of the applicable days, weeks or months.
class IFC_PARSE_API IfcRecurrencePattern : public  IfcUtil::IfcBaseEntity {
public:
    /// Defines the recurrence type that gives meaning to the used
    ///   attributes and decides about possible attribute
    ///   combinations, i.e. what attributes are needed to fully
    ///   describe the pattern type.
    ::Ifc4x3_rc1::IfcRecurrenceTypeEnum::Value RecurrenceType() const;
    void setRecurrenceType(::Ifc4x3_rc1::IfcRecurrenceTypeEnum::Value v);
    /// The position of the specified day in a month.
    boost::optional< std::vector< int > /*[1:?]*/ > DayComponent() const;
    void setDayComponent(boost::optional< std::vector< int > /*[1:?]*/ > v);
    /// The weekday name of the specified day in a week.
    boost::optional< std::vector< int > /*[1:?]*/ > WeekdayComponent() const;
    void setWeekdayComponent(boost::optional< std::vector< int > /*[1:?]*/ > v);
    /// The position of the specified month in a year.
    boost::optional< std::vector< int > /*[1:?]*/ > MonthComponent() const;
    void setMonthComponent(boost::optional< std::vector< int > /*[1:?]*/ > v);
    /// The position of the specified component, e.g. the 3rd
    ///   (position=3) Tuesday (weekday component) in a month. A
    ///   negative position value is used to define the last position 
    ///   of the component (-1), the next to last position (-2) etc.
    boost::optional< int > Position() const;
    void setPosition(boost::optional< int > v);
    /// An interval can be given according to the pattern type. An
    ///   interval value of 2 can for instance every two days, weeks,
    ///   months, years. An empty interval value is regarded as 1. The
    ///   used interval values should be in a reasonable range, e.g.
    ///   not 0 or <0.
    boost::optional< int > Interval() const;
    void setInterval(boost::optional< int > v);
    /// Defines the number of occurrences of this pattern, e.g. a weekly 
    ///   event might be defined to occur 5 times before it stops.
    boost::optional< int > Occurrences() const;
    void setOccurrences(boost::optional< int > v);
    /// List of time periods that are defined by a start and end time
    ///   of the recurring element (day). The order of the list should
    ///   reflect the sequence of the time periods.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTimePeriod >::ptr > TimePeriods() const;
    void setTimePeriods(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTimePeriod >::ptr > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRecurrencePattern (IfcEntityInstanceData&& e);
    IfcRecurrencePattern (::Ifc4x3_rc1::IfcRecurrenceTypeEnum::Value v1_RecurrenceType, boost::optional< std::vector< int > /*[1:?]*/ > v2_DayComponent, boost::optional< std::vector< int > /*[1:?]*/ > v3_WeekdayComponent, boost::optional< std::vector< int > /*[1:?]*/ > v4_MonthComponent, boost::optional< int > v5_Position, boost::optional< int > v6_Interval, boost::optional< int > v7_Occurrences, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTimePeriod >::ptr > v8_TimePeriods);
    typedef aggregate_of< IfcRecurrencePattern > list;
};

class IFC_PARSE_API IfcReference : public  IfcUtil::IfcBaseEntity, public  IfcAppliedValueSelect, public  IfcMetricValueSelect {
public:
    boost::optional< std::string > TypeIdentifier() const;
    void setTypeIdentifier(boost::optional< std::string > v);
    boost::optional< std::string > AttributeIdentifier() const;
    void setAttributeIdentifier(boost::optional< std::string > v);
    boost::optional< std::string > InstanceName() const;
    void setInstanceName(boost::optional< std::string > v);
    boost::optional< std::vector< int > /*[1:?]*/ > ListPositions() const;
    void setListPositions(boost::optional< std::vector< int > /*[1:?]*/ > v);
    ::Ifc4x3_rc1::IfcReference* InnerReference() const;
    void setInnerReference(::Ifc4x3_rc1::IfcReference* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcReference (IfcEntityInstanceData&& e);
    IfcReference (boost::optional< std::string > v1_TypeIdentifier, boost::optional< std::string > v2_AttributeIdentifier, boost::optional< std::string > v3_InstanceName, boost::optional< std::vector< int > /*[1:?]*/ > v4_ListPositions, ::Ifc4x3_rc1::IfcReference* v5_InnerReference);
    typedef aggregate_of< IfcReference > list;
};
/// Definition from ISO/CD 10303-43:1992: A
///   representation is one or more representation items that are
///   related in a specified representation context as the
///   representation of some concept.
/// 
/// IfcRepresentation
///   defines the general concept of representing product
///   properties.
/// 
/// Representation Use Definition
/// 
/// Each representation, either IfcShapeRepresentation, or
///   IfcTopologyRepresentation shall have a well defined:
/// 
/// ContextOfItems: Reference to an
///   IfcGeometricRepresentationContext as agreed for 
///   this representation.
/// 
/// RepresentationIdentifier: Name of the
///   representation, for example, 'Body' for 3D shape, 'FootPrint' for
///   2D ground view, 'Axis' for reference axis.
/// 
/// RepresentationType: Name for the geometric, or
///   topological representation type, for example, 'SweptSolid' for 3D
///   swept solids, 'Brep' for boundary representation.
/// 
/// Values and guidelines for these three items are provided in
///   the geometry use definition section at each subtype of
///   IfcElement, or in view definitions / implementer
///   agreements.
/// 
/// NOTE The definition of this
///   entity relates to the ISO 10303 entity representation. Please
///   refer to ISO/IS 10303-43:1994 for the final definition of
///   the formal standard.
/// 
/// HISTORY  New entity in IFC Release 2.0
/// 
/// IFC2x3 CHANGE  The
///   inverse attributes LayerAssignments
///   andRepresentationMap have been added with upward
///   compatibility.
/// 
/// IFC2x4 CHANGE  Entity
///   IfcRepresentation has been changed into an ABSTRACT
///   supertype.
class IFC_PARSE_API IfcRepresentation : public  IfcUtil::IfcBaseEntity, public  IfcLayeredItem {
public:
    /// Definition of the representation context for which the different subtypes of representation are valid.
    ::Ifc4x3_rc1::IfcRepresentationContext* ContextOfItems() const;
    void setContextOfItems(::Ifc4x3_rc1::IfcRepresentationContext* v);
    /// The optional identifier of the representation as used within a project.
    boost::optional< std::string > RepresentationIdentifier() const;
    void setRepresentationIdentifier(boost::optional< std::string > v);
    /// The description of the type of a representation context. The representation type defines the type of geometry or topology used for representing the product representation. More information is given at the subtypes IfcShapeRepresentation and IfcTopologyRepresentation.
    /// The supported values for context type are to be specified by implementers agreements.
    boost::optional< std::string > RepresentationType() const;
    void setRepresentationType(boost::optional< std::string > v);
    /// Set of geometric representation items that are defined for this representation.
    aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr Items() const;
    void setItems(aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v);
        aggregate_of< IfcRepresentationMap >::ptr RepresentationMap() const; // INVERSE IfcRepresentationMap::MappedRepresentation
    aggregate_of< IfcPresentationLayerAssignment >::ptr LayerAssignments() const; // INVERSE IfcPresentationLayerAssignment::AssignedItems
    aggregate_of< IfcProductRepresentation >::ptr OfProductRepresentation() const; // INVERSE IfcProductRepresentation::Representations
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentation (IfcEntityInstanceData&& e);
    IfcRepresentation (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcRepresentation > list;
};
/// Definition from ISO/CD 10303-42:1992: A representation context is a context in which a set of representation items are related.
/// 
/// The IfcRepresentationContext defines the context to which the IfcRepresentation of a product is related.
/// 
/// NOTE  The definition of this class relates to the ISO 10303 entity representation_context. Please refer to ISO/IS 10303-43:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x4 CHANGE Entity made abstract, had been deprecated from instantiation since
/// IFC2x2.
class IFC_PARSE_API IfcRepresentationContext : public  IfcUtil::IfcBaseEntity {
public:
    /// The optional identifier of the representation context as used within a project.
    boost::optional< std::string > ContextIdentifier() const;
    void setContextIdentifier(boost::optional< std::string > v);
    /// The description of the type of a representation context. The supported values for context type are to be specified by implementers agreements.
    boost::optional< std::string > ContextType() const;
    void setContextType(boost::optional< std::string > v);
        aggregate_of< IfcRepresentation >::ptr RepresentationsInContext() const; // INVERSE IfcRepresentation::ContextOfItems
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationContext (IfcEntityInstanceData&& e);
    IfcRepresentationContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType);
    typedef aggregate_of< IfcRepresentationContext > list;
};
/// Definition from ISO/CD
/// 10303-43:1992: A representation item is an element of
/// product data that participates in one or more representations or
/// contributes to the definition of another representation item. A
/// representation item contributes to the definition of another
/// representation item when it is referenced by that representation
/// item.
/// 
/// NOTE  Corresponding entity in ISO 10303-43:1994: representation_item. Please refer to ISO/IS 10303-43:1994, for the final definition of the formal standard. The following changes have been made: The attribute 'name' and the WR1 have not been incorporated.
/// 
/// The IfcRepresentationItem is used within an IfcRepresentation (directly or indirectly through other IfcRepresentationItem's) to represent an IfcProductRepresentation. Most commonly these IfcRepresentationItem's are geometric or topological representation items, that can (but not need to) have presentation style infomation assigned.
/// 
/// NOTE  The assignment of a style is only applicable
/// to the subtypes IfcGeometricRepresentationItem, IfcMappedItem and some selected subtypes of IfcTopologicalRepresentationItem (IfcVertexPoint, IfcEdgeCurve, IfcFaceSurface).
/// 
/// In case that presentation style information is applied, it can be either applied by an IfcStyledItem, or by an assignment to an IfcPresentationLayerWithStyle. If both are present, and both style assignments include the same subtype of IfcPresentationStyle, then the style assigned by IfcStyledItem takes priority.
/// 
/// Figure 281 shows an instance diagram explaining the use of IfcStyledItem and IfcPresentationLayerWithStyle to apply presentation styles.
/// 
/// EXAMPLE  The assignment of style information by a styled item and a presentation layer with style. Since the presentation styles are different, IfcCurveStyle and IfcSurfaceStyle, both are applied to the geometric representation item.
/// 
/// Figure 281 — Representation item style
/// 
/// Figure 282 shows in instance diagram explaining the override of IfcPresentationLayerWithStyle by IfcStyledItem to apply presentation styles.
/// 
/// EXAMPLE  The assignment of style information by a styled item and a presentation layer with style. Since the presentation styles for curve style are aprovided by both, the IfcCurveStyle provided by the IfcStyledItem overrides the IfcCurveStyle provided by the IfcPresentationLayerWithStyle
/// 
/// Figure 282 — Representation item style override
/// 
/// HISTORY  New entity in IFC Release 2x.
/// 
/// IFC2x3 CHANGE  The inverse attributes StyledByItem and LayerAssignments have been added. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcRepresentationItem : public  IfcUtil::IfcBaseEntity, public  IfcLayeredItem {
public:
        aggregate_of< IfcPresentationLayerAssignment >::ptr LayerAssignment() const; // INVERSE IfcPresentationLayerAssignment::AssignedItems
    aggregate_of< IfcStyledItem >::ptr StyledByItem() const; // INVERSE IfcStyledItem::Item
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationItem (IfcEntityInstanceData&& e);
    IfcRepresentationItem ();
    typedef aggregate_of< IfcRepresentationItem > list;
};
/// Definition from ISO/CD 10303-43:1992: A representation map is the identification of a representation and a representation item in that representation for the purpose of mapping. The representation item defines the origin of the mapping. The representation map is used as the source of a mapping by a mapped item.
/// 
/// NOTE  Corresponding ISO 10303 entity: representation_map. Please refer to ISO/IS 10303-43:1994, for the final definition of the formal standard. The following changes have been made: The mapping_origin (MappingOrigin) is constrained to be of type axis2_placement (IfcAxis2Placement).
/// 
/// An IfcRepresentationMap defines the base definition (also referred to as block, cell or macro) called MappedRepresentation within the MappingOrigin. The MappingOrigin defines the coordinate system in which the MappedRepresentation is defined.
/// 
/// The RepresentationMap is used through an IfcMappeditem in one or several IfcShapeRepresentation's. An Cartesian transformation operator can be applied to transform the MappedRepresentation into the placement coordinate system of the shape representation. The transformation of the representation map is restricted to be a Cartesian transformation mapping (translation, rotation, mirroring and scaling).
/// 
/// NOTE  The definition of a mapping which is used to specify a new representation item comprises a representation map and a mapped item entity. Without both entities, the mapping is not fully defined. Two entities are specified to allow the same source representation to be mapped into multiple new representations.
/// 
/// HISTORY  New entity in IFC Release 2x.
class IFC_PARSE_API IfcRepresentationMap : public  IfcUtil::IfcBaseEntity, public  IfcProductRepresentationSelect {
public:
    /// An axis2 placement that defines the position about which the mapped
    /// representation is mapped.
    ::Ifc4x3_rc1::IfcAxis2Placement* MappingOrigin() const;
    void setMappingOrigin(::Ifc4x3_rc1::IfcAxis2Placement* v);
    /// A representation that is mapped to at least one mapped item.
    ::Ifc4x3_rc1::IfcRepresentation* MappedRepresentation() const;
    void setMappedRepresentation(::Ifc4x3_rc1::IfcRepresentation* v);
        aggregate_of< IfcShapeAspect >::ptr HasShapeAspects() const; // INVERSE IfcShapeAspect::PartOfProductDefinitionShape
    aggregate_of< IfcMappedItem >::ptr MapUsage() const; // INVERSE IfcMappedItem::MappingSource
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationMap (IfcEntityInstanceData&& e);
    IfcRepresentationMap (::Ifc4x3_rc1::IfcAxis2Placement* v1_MappingOrigin, ::Ifc4x3_rc1::IfcRepresentation* v2_MappedRepresentation);
    typedef aggregate_of< IfcRepresentationMap > list;
};
/// IfcResourceLevelRelationship is an abstract base class for relationships between resource-level entities.
/// 
/// HISTORY New Entity in IFC 2x4
class IFC_PARSE_API IfcResourceLevelRelationship : public  IfcUtil::IfcBaseEntity {
public:
    /// A name used to identify or qualify the relationship.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// A description that may apply additional information about the relationship.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcResourceLevelRelationship (IfcEntityInstanceData&& e);
    IfcResourceLevelRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description);
    typedef aggregate_of< IfcResourceLevelRelationship > list;
};
/// IfcRoot is the most abstract and root class for all IFC entity definitions that roots in the kernel or in subsequent layers of the IFC object model. It is therefore the common supertype of all IFC entities, beside those defined in an IFC resource schema. All entities that are subtypes of IfcRoot can be used independently, whereas resource schema entities, that are not subtypes of IfcRoot, are not supposed to be independent entities.
/// 
/// IfcRoot assigns the globally unique ID, and the ownership and history information to the entity. In addition it may provide for a name and a description about the concept.
/// 
/// NOTE View definitions and implementation agreement may impose additional restrictions on the use of the OwnerHistory to handle object versioning.
/// 
/// HISTORY New entity in IFC Release 1.0
/// 
/// IFC2x4 CHANGE The attribute OwnerHistory has been made OPTIONAL.
class IFC_PARSE_API IfcRoot : public  IfcUtil::IfcBaseEntity {
public:
    /// Assignment of a globally unique identifier within the entire software world.
    std::string GlobalId() const;
    void setGlobalId(std::string v);
    /// Assignment of the information about the current ownership of that object, including owning actor, application, local identification and information captured about the recent changes of the object, 
    /// 
    /// NOTE only the last modification in stored - either as addition, deletion or modification.
    /// 
    /// IFC2x4 CHANGE  The attribute has been changed to be OPTIONAL.
    ::Ifc4x3_rc1::IfcOwnerHistory* OwnerHistory() const;
    void setOwnerHistory(::Ifc4x3_rc1::IfcOwnerHistory* v);
    /// Optional name for use by the participating software systems or users. For some subtypes of IfcRoot the insertion of the Name attribute may be required. This would be enforced by a where rule.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Optional description, provided for exchanging informative comments.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRoot (IfcEntityInstanceData&& e);
    IfcRoot (std::string v1_GlobalId, ::Ifc4x3_rc1::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef aggregate_of< IfcRoot > list;
};
/// Definition from ISO/CD 10303-41:1992: An SI unit is the fixed quantity used as a standard in terms of which items are measured as defined by ISO 1000 (clause 2).
/// 
/// IfcSIUnit covers both standard base SI units such as meter and second, and derived SI units such as Pascal, square meter and cubic meter.
/// 
/// NOTE Corresponding ISO 10303 name: si_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcSIUnit : public  IfcNamedUnit {
public:
    /// The SI Prefix for defining decimal multiples and submultiples of the unit.
    boost::optional< ::Ifc4x3_rc1::IfcSIPrefix::Value > Prefix() const;
    void setPrefix(boost::optional< ::Ifc4x3_rc1::IfcSIPrefix::Value > v);
    /// The word, or group of words, by which the SI unit is referred to.
    /// 
    /// NOTE  Even though the SI system's base unit for mass is kilogram, the IfcSIUnit for mass is gram if no Prefix is asserted.
    ::Ifc4x3_rc1::IfcSIUnitName::Value Name() const;
    void setName(::Ifc4x3_rc1::IfcSIUnitName::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSIUnit (IfcEntityInstanceData&& e);
    IfcSIUnit (::Ifc4x3_rc1::IfcUnitEnum::Value v2_UnitType, boost::optional< ::Ifc4x3_rc1::IfcSIPrefix::Value > v3_Prefix, ::Ifc4x3_rc1::IfcSIUnitName::Value v4_Name);
    typedef aggregate_of< IfcSIUnit > list;
};
/// IfcSchedulingTime is the abstract supertype of entities that capture time-related information of processes.
/// 
/// HISTORY: New entity in IFC2x4.
class IFC_PARSE_API IfcSchedulingTime : public  IfcUtil::IfcBaseEntity {
public:
    /// Optional name for the time definition.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Specifies the origin of the scheduling time entity. It currently
    ///   differentiates between predicted, simulated, measured, and user defined values.
    boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > DataOrigin() const;
    void setDataOrigin(boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v);
    /// Value of the data origin if DataOrigin attribute is USERDEFINED.
    boost::optional< std::string > UserDefinedDataOrigin() const;
    void setUserDefinedDataOrigin(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSchedulingTime (IfcEntityInstanceData&& e);
    IfcSchedulingTime (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin);
    typedef aggregate_of< IfcSchedulingTime > list;
};
/// Definition from ISO/CD 10303-41:1992: The shape
///   aspect is an identifiable element of the shape of a
///   product.
/// 
/// IfcShapeAspect
///   allows for grouping of shape representation items that
///   represent aspects (or components) of the shape of a
///   product. Thereby shape representations of components of the
///   product shape represent a distinctive part to a product
///   that can be explicitly addressed.
/// 
/// NOTE The definition of
///   this class relates to the ISO 10303 entity shape_aspect. Please
///   refer to ISO/IS 10303-41:1994 for the final definition of
///   the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// IFC 2x4 CHANGE  Attribute
///   PartOfProductDefinitionShape declared OPTIONAL with 
///   upward compatibility for file based exchange.
/// 
/// Informal propositions:
/// 
/// If ShapeRepresentations points to shape
///   representations that are part of an
///   IfcProductDefinitionShape,
///   PartOfProductDefinitionShape must refer to this
///   instance of IfcProductDefinitionShape.
/// 
/// NOTE PartOfProductDefinitionShape is
///   only to be omitted if the shape representations are
///   attached to an IfcRepresentationMap. This
///   enables the use of IfcShapeAspect with
///   IfcRepresentationMap's that are used by an
///   IfcTypeProduct through the
///   RepresentationMaps attribute.
class IFC_PARSE_API IfcShapeAspect : public  IfcUtil::IfcBaseEntity, public  IfcResourceObjectSelect {
public:
    /// List of shape representations. Each member defines a valid representation of a particular type within a particular representation context as being an aspect (or part) of a product definition.
    /// IFC2x Edition 3 CHANGE  The data type has been changed from IfcShapeRepresentation to IfcShapeModel with upward compatibility
    aggregate_of< ::Ifc4x3_rc1::IfcShapeModel >::ptr ShapeRepresentations() const;
    void setShapeRepresentations(aggregate_of< ::Ifc4x3_rc1::IfcShapeModel >::ptr v);
    /// The word or group of words by which the shape aspect is known. It is a tag to indicate the particular semantic of a component within the product definition shape, used to provide meaning. Example: use the tag "Glazing" to define which component of a window shape defines the glazing area.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// The word or group of words that characterize the shape aspect. It can be used to add additional meaning to the name of the aspect.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// An indication that the shape aspect is on the physical boundary of the product definition shape. If the value of this attribute is TRUE, it shall be asserted that the shape aspect being identified is on such a boundary. If the value is FALSE, it shall be asserted that the shape aspect being identified is not on such a boundary. If the value is UNKNOWN, it shall be asserted that it is not known whether or not the shape aspect being identified is on such a boundary. 
    /// ---
    /// EXAMPLE: Would be FALSE for a center line, identified as shape aspect; would be TRUE for a cantilever.
    /// ---
    boost::logic::tribool ProductDefinitional() const;
    void setProductDefinitional(boost::logic::tribool v);
    /// Reference to the product definition shape of which this class is an aspect.
    ::Ifc4x3_rc1::IfcProductRepresentationSelect* PartOfProductDefinitionShape() const;
    void setPartOfProductDefinitionShape(::Ifc4x3_rc1::IfcProductRepresentationSelect* v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReferences() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeAspect (IfcEntityInstanceData&& e);
    IfcShapeAspect (aggregate_of< ::Ifc4x3_rc1::IfcShapeModel >::ptr v1_ShapeRepresentations, boost::optional< std::string > v2_Name, boost::optional< std::string > v3_Description, boost::logic::tribool v4_ProductDefinitional, ::Ifc4x3_rc1::IfcProductRepresentationSelect* v5_PartOfProductDefinitionShape);
    typedef aggregate_of< IfcShapeAspect > list;
};
/// IfcShapeModel represents
/// the concept of a particular geometric and/or topological
/// representation of a product's shape or a product component's shape
/// within a representation context. This representation context has to
/// be a geometric representation context (with the exception of
/// topology representations without associated geometry). The two
/// subtypes are IfcShapeRepresentation to cover geometric
/// models that represent a shape, and IfcTopologyRepresentation
/// to cover the conectivity of a product or product component. The
/// topology may or may not have geometry associated.
/// 
/// The IfcShapeModel can be a shape representation
/// (geometric and/or topologogical) of a product (via
/// IfcProductDefinitionShape), or a shape representation
/// (geometric and/or topologogical)  of a component of a product
/// shape (via IfcShapeAspect).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcShapeModel : public  IfcRepresentation {
public:
        aggregate_of< IfcShapeAspect >::ptr OfShapeAspect() const; // INVERSE IfcShapeAspect::ShapeRepresentations
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeModel (IfcEntityInstanceData&& e);
    IfcShapeModel (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcShapeModel > list;
};
/// The IfcShapeRepresentation represents the concept of a
/// particular geometric representation of a product or a product
/// component within a specific geometric representation context. The
/// inherited attribute RepresentationType is used to define
/// the geometric model used for the shape representation (for example, 
/// 'SweptSolid', or 'Brep'), the inherited attribute
/// RepresentationIdentifier is used to denote the part of the
/// representation captured by the IfcShapeRepresentation
/// (for example, 'Axis', 'Body').
/// 
/// Several representation identifiers for shape representation are
/// included as predefined values for RepresentationIdentifier:
/// 
/// Box
/// Bounding box as simplified 3D box
/// geometry of an element
/// 
/// Annotation
/// 2D annotations not representing
/// elements
/// 
/// Axis
/// 2D or 3D Axis, or single line,
/// representation of an element
/// 
/// FootPrint
/// 2D Foot print, or double line,
/// representation of an element, projected to ground view
/// 
/// Surface
/// 3D Surface representation, e.g. of an
/// analytical surface, of an elementplane)
/// 
/// Body
/// 3D Body representation, e.g. as
/// wireframe, surface, or solid model, of an element
/// 
/// Lighting
/// Representation of emitting light as a
/// light source within a shape representation
/// 
/// Several representation types for shape representation are
/// included as predefined values for RepresentationType:
/// 
/// Curve2D
/// 2 dimensional curve
/// 
/// Curve3D
/// 3 dimensional curve
/// 
/// Surface2D
/// 2 dimensional surface (a region on
/// ground view)
/// 
/// Surface3D
/// 3 dimensional surface
/// 
/// GeometricSet
/// points, curves, surfaces (2 or 3
/// dimensional)
/// 
/// GeometricCurveSet
/// points, curves (2 or 3
/// dimensional)
/// 
/// Annotation2D
/// points, curves (2 or 3 dimensional), hatches and text (2
/// dimensional)
/// 
/// SurfaceModel
/// face based and shell based surface
/// model
/// 
/// SolidModel
/// including swept solid, Boolean
/// results and Brep bodies
/// more specific types are:
/// 
/// SweptSolid
/// swept area solids, by extrusion and
/// revolution, excluding tapered sweeps
/// 
/// AdvancedSweptSolid
/// swept area solids created by sweeping
/// a profile along a directrix, and tapered sweeps
/// 
/// Brep
/// faceted Brep's with and without
/// voids
/// 
/// AdvancedBrep
/// Brep's based on advanced faces, with
/// b-spline surface geometry, with and without voids
/// 
/// CSG
/// Boolean results of operations between
/// solid models, half spaces and Boolean results
/// 
/// Clipping
/// Boolean differences between swept
/// area solids, half spaces and Boolean results
/// 
/// additional types
/// 
/// some additional representation types are provided:
/// 
/// BoundingBox
/// simplistic 3D representation by a
/// bounding box
/// 
/// SectionedSpine
/// cross section based representation of
/// a spine curve and planar cross sections. It can represent a surface
/// or a solid and the interpolations of the between the cross sections
/// is not defined
/// 
/// LightSource
/// light source with (depending on type)
/// position, orientation, light colour, intensity and attenuation
/// 
/// MappedRepresentation
/// representation based on mapped
/// item(s), referring to a representation map. Note: it can be seen as
/// an inserted block reference. The shape representation of the mapped
/// item has a representation type declaring the type of its
/// representation items.
/// 
/// Table 1: string values for the inherited attribute
/// 'RepresentationType'.
/// 
/// NOTE  The definition of this entity relates to the ISO 10303 entity shape_representation. Please refer to ISO/IS 10303-41:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x4 CHANGE  The RepresentationType's 'Curve3D', 'Surface2D', 'Surface3D', 'AdvancedBrep', 'LightSource', and the RepresentationIdentifier 'Lighting' have been added.
class IFC_PARSE_API IfcShapeRepresentation : public  IfcShapeModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeRepresentation (IfcEntityInstanceData&& e);
    IfcShapeRepresentation (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcShapeRepresentation > list;
};
/// Definition from IAI: Describe more rarely needed connection properties.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralConnectionCondition : public  IfcUtil::IfcBaseEntity {
public:
    /// Optionally defines a name for this connection condition.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralConnectionCondition (IfcEntityInstanceData&& e);
    IfcStructuralConnectionCondition (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcStructuralConnectionCondition > list;
};
/// Definition from IAI: The abstract entity IfcStructuralLoadOrResult is the supertype of all loads (actions or reactions) or of certain requirements resulting from structural analysis, or certain provisions which influence structural analysis.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralLoad : public  IfcUtil::IfcBaseEntity {
public:
    /// Optionally defines a name for this load.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoad (IfcEntityInstanceData&& e);
    IfcStructuralLoad (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcStructuralLoad > list;
};
/// Definition from IAI: This class combines one or more load or result values in a 1- or 2-dimensional configuration.
/// 
/// HISTORY: New entity in IFC 2x4.
/// 
/// Informal propositions:
/// 
/// All items in Values shall be of the same type.
///   If the loads or results comprise a curve activity, 1-dimensional locations shall be given, measured locally along the curve.  The location shall not exceed the bounds of the curve actvity.  The load samples and corresponding locations shall be given in ascending order of locations.
///   If the loads or results comprise a surface activity, 2-dimensional locations shall be given, measured in the surface activity's local x and y directions.  The location shall not exceed the bounds of the surface activity.
/// 
/// NOTE  There are no ordering requirements in the 2-dimensional case, but the 1-dimensional case shall be spatially ordered for simplicity.
class IFC_PARSE_API IfcStructuralLoadConfiguration : public  IfcStructuralLoad {
public:
    /// List of load or result values.
    aggregate_of< ::Ifc4x3_rc1::IfcStructuralLoadOrResult >::ptr Values() const;
    void setValues(aggregate_of< ::Ifc4x3_rc1::IfcStructuralLoadOrResult >::ptr v);
    /// Locations of the load samples or result samples, given within the local coordinate system defined by the instance which uses this resource object.  Each item in the list of locations pertains to the values list item at the same list index.  This attribute is optional for configurations in which the locations are implicitly known from higher-level definitions.
    boost::optional< std::vector< std::vector< double > > > Locations() const;
    void setLocations(boost::optional< std::vector< std::vector< double > > > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadConfiguration (IfcEntityInstanceData&& e);
    IfcStructuralLoadConfiguration (boost::optional< std::string > v1_Name, aggregate_of< ::Ifc4x3_rc1::IfcStructuralLoadOrResult >::ptr v2_Values, boost::optional< std::vector< std::vector< double > > > v3_Locations);
    typedef aggregate_of< IfcStructuralLoadConfiguration > list;
};
/// Definition from IAI: Abstract superclass of simple load or result classes.
/// 
/// HISTORY: New abstract superclass in IFC 2x4, upwards compatibility of all subtypes is preserved.
class IFC_PARSE_API IfcStructuralLoadOrResult : public  IfcStructuralLoad {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadOrResult (IfcEntityInstanceData&& e);
    IfcStructuralLoadOrResult (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcStructuralLoadOrResult > list;
};
/// Definition from IAI: The abstract entity IfcStructuralLoadStatic is the supertype of all static loads (actions or reactions) which can be defined.  Within scope are single i.e. concentrated forces and moments, linear i.e. one-dimensionally distributed forces and moments, planar i.e. two-dimensionally distributed forces, furthermore displacements and temperature loads.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralLoadStatic : public  IfcStructuralLoadOrResult {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadStatic (IfcEntityInstanceData&& e);
    IfcStructuralLoadStatic (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcStructuralLoadStatic > list;
};
/// An instance of the entity IfcStructuralLoadTemperature shall be used to define actions which are caused by a temperature change. As shown in Figure 332, the change of temperature is given with a constant value which is applied to the complete section and values for temperature differences between outer fibres of the section.
/// 
/// HISTORY  New entity in IFC2x2. 
/// 
/// Figure 332 — Structural load temperature
class IFC_PARSE_API IfcStructuralLoadTemperature : public  IfcStructuralLoadStatic {
public:
    /// Temperature change which affects the complete section of the structural member, or the uniform portion of a non-uniform temperature change.
    /// 
    /// A positive value describes an increase in temperature.  I.e. a positive constant temperature change causes elongation of a member, or compression in the member if there are respective restraints.
    boost::optional< double > DeltaTConstant() const;
    void setDeltaTConstant(boost::optional< double > v);
    /// Non-uniform temperature change, specified as the difference of the temperature change at the outer fibre of the positive y direction minus the temperature change at the outer fibre of the negative y direction of the analysis member.
    /// 
    /// I.e. a positive non-uniform temperature change in y induces a negative curvature of the member about z, or a positive bending moment about z if there are respective restraints.  y and z are local member axes.
    boost::optional< double > DeltaTY() const;
    void setDeltaTY(boost::optional< double > v);
    /// Non-uniform temperature change, specified as the difference of the temperature change at the outer fibre of the positive z direction minus the temperature change at the outer fibre of the negative z direction of the analysis member.
    /// 
    /// I.e. a positive non-uniform temperature change in z induces a positive curvature of the member about y, or a negative bending moment about y if there are respective restraints.  y and z are local member axes.
    boost::optional< double > DeltaTZ() const;
    void setDeltaTZ(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadTemperature (IfcEntityInstanceData&& e);
    IfcStructuralLoadTemperature (boost::optional< std::string > v1_Name, boost::optional< double > v2_DeltaTConstant, boost::optional< double > v3_DeltaTY, boost::optional< double > v4_DeltaTZ);
    typedef aggregate_of< IfcStructuralLoadTemperature > list;
};
/// IfcStyleModel represents the concept of a particular presentation style defined for a material (or other characteristic) of a product or a product component within a representation context. This representation context may (but has not to be) a geometric representation context.
/// 
/// IfcStyleModel can be a style representation (presentation style) of a material (via IfcMaterialDefinitionRepresentation), potentially differentiated for different representation contexts (for example, different material hatching depending on the scale of the target representation context).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcStyleModel : public  IfcRepresentation {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyleModel (IfcEntityInstanceData&& e);
    IfcStyleModel (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcStyleModel > list;
};
/// Definition from ISO/CD 10303-46:1992: The styled item is an assignment of style for presentation to a geometric representation item as it is used in a representation.
/// 
/// NOTE  Corresponding ISO 10303 name: styled_item. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// The IfcStyledItem holds presentation style information for products, either explicitly for an IfcGeometricRepresentationItem being part of an IfcShapeRepresentation assigned to a product, or by assigning presentation information to IfcMaterial being assigned as other representation for a product.
/// 
/// If the IfcStyledItem is used within a reference from an IfcProductDefinitionShape then one Item shall be provided.
/// If the IfcStyledItem is used within a reference from an IfcMaterialDefinitionRepresentation then no Item shall be provided.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x2 Addendum 1 CHANGE  The entity IfcStyledItem has been made non abstract and the attribute Name added.
/// 
/// IFC2x3 CHANGE The attribute Item has been made optional, upward compatibility for file
/// based exchange is guaranteed.
/// 
/// IFC2x4 CHANGE The subtype IfcAnnotationOccurrence and its subtypes are deleted. Use IfcStyledItem for all instantiations. The data type of Styles has been changed to IfcStyleAssignmentSelect
/// 
/// Use Definition
/// 
/// Figure 293 illustrates use of IfcStyledItem for the two usage examples:
/// 
/// As a presentation for a geometric representation item
/// As a presentation for a material definition
/// 
/// NOTE  The new IfcStyleAssignmentSelect allows the direct assignment styles, such as IfcCurveStyle, IfcSurfaceStyle without using the intermediate IfcPresentationStyleAssignment
/// 
/// Figure 293 — Styled item
class IFC_PARSE_API IfcStyledItem : public  IfcRepresentationItem {
public:
    /// A geometric representation item to which the style is assigned.
    /// 
    /// IFC2x Edition 2 Addendum 2 CHANGE The attribute Item has been made optional. Upward compatibility for file based exchange is guaranteed.
    ::Ifc4x3_rc1::IfcRepresentationItem* Item() const;
    void setItem(::Ifc4x3_rc1::IfcRepresentationItem* v);
    /// Representation styles which are assigned, either to an geometric representation item, or to a material definition.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed to IfcStyleAssignmentSelect with upward compatibility 
    /// for file based exchange.
    /// 
    /// NOTE  Only the select item IfcPresentationStyle shall be used from IFC2x4 onwards, the IfcPresentationStyleAssignment has been deprecated.
    aggregate_of< ::Ifc4x3_rc1::IfcStyleAssignmentSelect >::ptr Styles() const;
    void setStyles(aggregate_of< ::Ifc4x3_rc1::IfcStyleAssignmentSelect >::ptr v);
    /// The word, or group of words, by which the styled item is referred to.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyledItem (IfcEntityInstanceData&& e);
    IfcStyledItem (::Ifc4x3_rc1::IfcRepresentationItem* v1_Item, aggregate_of< ::Ifc4x3_rc1::IfcStyleAssignmentSelect >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef aggregate_of< IfcStyledItem > list;
};
/// The IfcStyledRepresentation represents the concept of a styled presentation being a representation of a product or a product component, like material. within a representation context. This representation context does not need to be (but may be) a geometric representation context.
/// 
/// NOTE  Current usage of IfcStyledRepresentation is restricted to the assignment of presentation information to an material. The IfcStyledRepresentation includes only presentation styles (IfcCurveStyle, FillAreaStyle, IfcSurfaceStyle) that define how a material should be presented within a particular (eventually view and scale dependent) representation context. All instances of IfcStyledRepresentation are referenced by IfcMaterialDefinitionRepresentation, and assigned to IfcMaterial by IfcMaterialDefinitionRepresentation.RepresentedMaterial.
/// 
/// A styled representation has to include one or several styled items with the associated style information (curve, symbol, text, fill area, or surface styles). It shall not contain the geometric representation items that are styled.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcStyledRepresentation : public  IfcStyleModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyledRepresentation (IfcEntityInstanceData&& e);
    IfcStyledRepresentation (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcStyledRepresentation > list;
};
/// Definition from IAI: Describes required or provided reinforcement area of surface members.
/// 
/// NOTE  Member design parameters like concrete cover, effective depth, orientation of meshes or rebars (two, optionally three directions) etc. are not specified in IfcStructuralLoadResource schema.  They shall be specified at the level of structural members.
/// 
/// HISTORY: New entity in IFC 2x4.
class IFC_PARSE_API IfcSurfaceReinforcementArea : public  IfcStructuralLoadOrResult {
public:
    /// Reinforcement at the face of the member which is located at the side of the positive local z direction of the surface member.  Specified as area per length, e.g. square metre per metre (hence length measure, e.g. metre).  The reinforcement area may be specified for two or three directions of reinforcement bars.
    boost::optional< std::vector< double > /*[2:3]*/ > SurfaceReinforcement1() const;
    void setSurfaceReinforcement1(boost::optional< std::vector< double > /*[2:3]*/ > v);
    /// Reinforcement at the face of the member which is located at the side of the negative local z direction of the surface member.  Specified as area per length, e.g. square metre per metre (hence length measure, e.g. metre).  The reinforcement area may be specified for two or three directions of reinforcement bars.
    boost::optional< std::vector< double > /*[2:3]*/ > SurfaceReinforcement2() const;
    void setSurfaceReinforcement2(boost::optional< std::vector< double > /*[2:3]*/ > v);
    /// Shear reinforcement.  Specified as area per area, e.g. square metre per square metre (hence ratio measure, i.e. unitless).
    boost::optional< double > ShearReinforcement() const;
    void setShearReinforcement(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceReinforcementArea (IfcEntityInstanceData&& e);
    IfcSurfaceReinforcementArea (boost::optional< std::string > v1_Name, boost::optional< std::vector< double > /*[2:3]*/ > v2_SurfaceReinforcement1, boost::optional< std::vector< double > /*[2:3]*/ > v3_SurfaceReinforcement2, boost::optional< double > v4_ShearReinforcement);
    typedef aggregate_of< IfcSurfaceReinforcementArea > list;
};
/// IfcSurfaceStyle is an assignment of one or many surface style elements to a surface, defined by subtypes of IfcSurface, IfcFaceBasedSurfaceModel, IfcShellBasedSurfaceModel, or by subtypes of IfcSolidModel. The positive direction of the surface normal relates to the positive side. In case of solids the outside of the solid is to be taken as positive side. 
/// 
/// NOTE: The surface style is often referred to as material definition in rendering applications.
/// 
/// NOTE Corresponding ISO 10303 entity: surface_style_usage and surface_side_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. The surface style definition in regard to support of rendering has been greatly expanded beyond the scope of ISO/IS 10303-46.
/// 
/// HISTORY New Entity in IFC 2.x.
class IFC_PARSE_API IfcSurfaceStyle : public  IfcPresentationStyle, public  IfcPresentationStyleSelect {
public:
    /// An indication of which side of the surface to apply the style.
    ::Ifc4x3_rc1::IfcSurfaceSide::Value Side() const;
    void setSide(::Ifc4x3_rc1::IfcSurfaceSide::Value v);
    /// A collection of different surface styles.
    aggregate_of< ::Ifc4x3_rc1::IfcSurfaceStyleElementSelect >::ptr Styles() const;
    void setStyles(aggregate_of< ::Ifc4x3_rc1::IfcSurfaceStyleElementSelect >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyle (IfcEntityInstanceData&& e);
    IfcSurfaceStyle (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcSurfaceSide::Value v2_Side, aggregate_of< ::Ifc4x3_rc1::IfcSurfaceStyleElementSelect >::ptr v3_Styles);
    typedef aggregate_of< IfcSurfaceStyle > list;
};
/// IfcSurfaceStyleLighting is a container class for properties for calculation of physically exact illuminance related to a particular surface style.
/// 
/// Figure 294 shows the reflection and transmission components from an incident ray. The sum of the components for reflection and transmission is a value of 1.0 denoting that the incident ray is completely decomposed into reflection and transmission components. Each value of reflection and transmission is therefore within the range 0.0 to 1.0. 
/// 
/// Figure 294 — Surface style lighting
/// 
/// All these factors can be measured physically and are ratios for the red, green and blue part of the light. These properties are defined in the model as Type IfcColorRGB with a factor for each colour. 
/// 
/// EXAMPLE  A green glass transmits only green light, so its transmission factor is 0.0 for red, between 0.0 and 1.0 for green and 0.0 for blue. A green surface reflects only green light, so the reflectance factor is 0.0 for red, between 0.0 and 1.0 for green and 0.0 for blue.
/// 
/// HISTORY  New entity in IFC 2x2.
class IFC_PARSE_API IfcSurfaceStyleLighting : public  IfcPresentationItem, public  IfcSurfaceStyleElementSelect {
public:
    /// The degree of diffusion of the transmitted light. In the case of completely transparent materials there is no diffusion. The greater the diffusing power, the smaller the direct component of the transmitted light, up to the point where only diffuse light is produced.A value of 1 means totally diffuse for that colour part of the light.
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc4x3_rc1::IfcColourRgb* DiffuseTransmissionColour() const;
    void setDiffuseTransmissionColour(::Ifc4x3_rc1::IfcColourRgb* v);
    /// The degree of diffusion of the reflected light. In the case of specular surfaces there is no diffusion. The greater the diffusing power of the reflecting surface, the smaller the specular component of the reflected light, up to the point where only diffuse light is produced. A value of 1 means totally diffuse for that colour part of the light. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc4x3_rc1::IfcColourRgb* DiffuseReflectionColour() const;
    void setDiffuseReflectionColour(::Ifc4x3_rc1::IfcColourRgb* v);
    /// Describes how the light falling on a body is totally or partially transmitted. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc4x3_rc1::IfcColourRgb* TransmissionColour() const;
    void setTransmissionColour(::Ifc4x3_rc1::IfcColourRgb* v);
    /// A coefficient that determines the extent that the light falling onto a surface is fully or partially reflected. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc4x3_rc1::IfcColourRgb* ReflectanceColour() const;
    void setReflectanceColour(::Ifc4x3_rc1::IfcColourRgb* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleLighting (IfcEntityInstanceData&& e);
    IfcSurfaceStyleLighting (::Ifc4x3_rc1::IfcColourRgb* v1_DiffuseTransmissionColour, ::Ifc4x3_rc1::IfcColourRgb* v2_DiffuseReflectionColour, ::Ifc4x3_rc1::IfcColourRgb* v3_TransmissionColour, ::Ifc4x3_rc1::IfcColourRgb* v4_ReflectanceColour);
    typedef aggregate_of< IfcSurfaceStyleLighting > list;
};
/// IfcSurfaceStyleRefraction extends the surface style lighting, or the surface style rendering definition for properties for calculation of physically exact illuminance by adding seldomly used properties. Currently this includes the refraction index (by which the light ray refracts when passing through a prism) and the dispersion factor (or Abbe constant) which takes into account the wavelength dependency of the refraction.
/// 
/// NOTE: If such refraction properties are used, the IfcSurfaceStyle should include within its set of Styles (depending on whether rendering or lighting is used) an instance of IfcSurfaceStyleLighting and IfcSurfaceStyleRefraction, or an instance of IfcSurfaceStyleRendering and IfcSurfaceStyleRefraction.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcSurfaceStyleRefraction : public  IfcPresentationItem, public  IfcSurfaceStyleElementSelect {
public:
    /// The index of refraction for all wave lengths of light. The refraction index is the ratio between the speed of light in a vacuum and the speed of light in the medium. E.g. glass has a refraction index of 1.5, whereas water has an index of 1.33
    boost::optional< double > RefractionIndex() const;
    void setRefractionIndex(boost::optional< double > v);
    /// The Abbe constant given as a fixed ratio between the refractive indices of the material at different wavelengths. A low Abbe number means a high dispersive power. In general this translates to a greater angular spread of the emergent spectrum.
    boost::optional< double > DispersionFactor() const;
    void setDispersionFactor(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleRefraction (IfcEntityInstanceData&& e);
    IfcSurfaceStyleRefraction (boost::optional< double > v1_RefractionIndex, boost::optional< double > v2_DispersionFactor);
    typedef aggregate_of< IfcSurfaceStyleRefraction > list;
};
/// Definition from ISO/CD 10303-46:1992: The surface style rendering allows the realistic visualization of surfaces referring to rendering techniques based on the laws of physics and mathematics. 
/// 
/// The entity IfcSurfaceStyleShading allows for colour information used for shading, whereas subtypes provide data for more sophisticated rendering techniques. The surface colour is used for colouring or simple shading of the assigned surfaces. 
/// 
/// NOTE Corresponding ISO 10303 entity: surface_style_rendering. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. No rendering method is defined for each surface style (such as constant, colour, dot or normal shading), therefore the attribute rendering_method has been omitted.
/// 
/// HISTORY: New entity in IFC 2x.
class IFC_PARSE_API IfcSurfaceStyleShading : public  IfcPresentationItem, public  IfcSurfaceStyleElementSelect {
public:
    /// The colour used to render the surface. The surface colour for visualisation is defined by specifying the intensity of red, green and blue.
    ::Ifc4x3_rc1::IfcColourRgb* SurfaceColour() const;
    void setSurfaceColour(::Ifc4x3_rc1::IfcColourRgb* v);
    boost::optional< double > Transparency() const;
    void setTransparency(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleShading (IfcEntityInstanceData&& e);
    IfcSurfaceStyleShading (::Ifc4x3_rc1::IfcColourRgb* v1_SurfaceColour, boost::optional< double > v2_Transparency);
    typedef aggregate_of< IfcSurfaceStyleShading > list;
};
/// The entity IfcSurfaceStyleWithTextures allows to include image textures in surface styles. These image textures can be applied repeating across the surface or mapped with a particular scale upon the surface.
/// 
/// The entity IfcSurfaceStyleWithTextures is part of the surface style table for presentation information assigned to surfaces for shading, rendering and lighting with textures. The mapping of the texture onto the surface or the solid is determined by the texture coordinates, in absense of an IfcTextureCoordinate assigned to each surface texture, a default mapping of the texture to the geometric face or surface applies.
/// 
/// Surface textures included in the IfcSurfaceStyleWithTextures are two dimensional map formats. They define 2D images that contain an array of colour values describing the texture. Depending on the number of IfcSurfaceTextures being included in the list of Textures the IfcSurfaceStyleWithTextures either describes a single texture, or a multi texture.
/// 
/// single texture: a single surface texture is applied to the styled geometric item (entirely or partly) with optional repetition and texture transformation
/// multi texture: two or more surface textures are applied to the styled geometric item (entirely or partly) with optional repetition, texture transformation or texture coordinate mapping being specific for each texture.
/// 
/// Informal proposition
/// 
/// Only one instance of IfcSurfaceStyleWithTextures shall be referenced by an IfcStyledItem and be assigned to an IfcGeometricRepresentationItem
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  inverse attribute HasTextureCoordinates deleted.
class IFC_PARSE_API IfcSurfaceStyleWithTextures : public  IfcPresentationItem, public  IfcSurfaceStyleElementSelect {
public:
    /// The textures applied to the surface. In case of more than one surface texture is included, the IfcSurfaceStyleWithTexture defines a multi texture.
    aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr Textures() const;
    void setTextures(aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleWithTextures (IfcEntityInstanceData&& e);
    IfcSurfaceStyleWithTextures (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Textures);
    typedef aggregate_of< IfcSurfaceStyleWithTextures > list;
};
/// An IfcSurfaceTexture provides a 2-dimensional
/// image-based texture map. It can either be given by referencing an
/// external image file through an URL reference
/// (IfcImageTexture), including the image file as a blob
/// (long binary) into the data set (IfcBlobTexture), or by
/// explicitly including an array of pixels
/// (IfcPixelTexture).
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// Texture: An image
/// used in a texture map to create visual appearance effects when
/// applied to geometry nodes.
/// Texture map: A
/// texture plus the general parameters necessary for mapping the
/// texture to geometry.
/// 
/// Texture are defined by 2D images that contain an array of colour
/// values describing the texture. The texture values are interpreted
/// differently depending on the number of components in the texture
/// and the specifics of the image format. In general, texture may be
/// described using one of the following forms:
/// 
/// Intensity textures (one-component)
/// Intensity plus alpha opacity textures (two-component)
/// Full RGB textures (three-component)
/// Full RGB plus alpha opacity textures (four-component)
/// 
/// NOTE  Image formats specify an alpha opacity, not transparency (where alpha = 1 - transparency).
/// 
/// Figure 295 illustrates the texture coordinate system.
/// 
/// Figure 295 — Surface texture coordinates
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) on texture coordinates apply:
/// 
/// Texture maps are defined in a 2D coordinate system (s, t) that ranges from [0.0, 1.0] in both directions. The bottom edge of the image corresponds to the S-axis of the texture map, and left edge of the image corresponds to the T-axis of the texture map. The lower-left pixel of the image corresponds to s=0, t=0, and the top-right pixel of the image corresponds to s=1, t=1. Texture maps may be viewed as two dimensional colour functions that, given an (s, t) coordinate, return a colour value colour(s, t).
/// 
/// If multiple surface textures are included in the
/// IfcSurfaceStyleWithTextures applying them to a geometric
/// item, a mode and optional parameters can be included that blending
/// operations.
/// The RepeatS and RepeatT Boolean flags control
/// whether the texture map is repeated outside the [0.0, 1.0] texture
/// coordinate range, when applied to a geometric surface, or clamped
/// to lie within the [0.0, 1.0] range. The TextureTransform
/// applies a 2D non-uniform transformation to the texture before it is
/// applied to a geometric surface.
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// These parameters
/// support changes to the size, orientation, and position of textures
/// on shapes. Note that these operations appear reversed when viewed
/// on the surface of geometry. For example, a scale value of (2
/// 2) will scale the texture coordinates and have the net effect of
/// shrinking the texture size by a factor of 2 (texture coordinates
/// are twice as large and thus cause the texture to repeat). A
/// translation of (0.5 0.0) translates the texture coordinates +.5
/// units along the S-axis and has the net effect of translating the
/// texture −0.5 along the S-axis on the geometry's surface. A
/// rotation of π/2 of the texture coordinates results in a
/// −π/2 rotation of the texture on the geometry.
/// The center
/// field specifies a translation offset in texture coordinate space
/// about which the rotation and scale fields are
/// applied. The scale field specifies a scaling factor in S and
/// T of the texture coordinates about the center point.
/// scale values shall be in the range (−∞,∞).
/// The rotation field specifies a rotation in radians of the
/// texture coordinates about the center point after the scale
/// has been applied. A positive rotation value makes the texture
/// coordinates rotate counterclockwise about the centre, thereby
/// rotating the appearance of the texture itself clockwise. The
/// translation field specifies a translation of the texture
/// coordinates.
/// The following conventions
/// apply:
/// 
/// center =
/// TextureTransform.LocalOrigin;
/// rotation = TextureTransform.Axis1
/// scale S = TextureTransform.Scale
/// scale T = TextureTransform.Scale2
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC 2x2.
/// 
/// IFC2x4 CHANGE  Attribute TextureType replaces by Mode, attributes Parameter and MapsTo aded, new inverse attribute UsedInStyle.
class IFC_PARSE_API IfcSurfaceTexture : public  IfcPresentationItem {
public:
    /// The RepeatS field specifies how the texture wraps in the S direction. If RepeatS is TRUE (the default), the texture map is repeated outside the [0.0, 1.0] texture coordinate range in the S direction so that it fills the shape. If RepeatS is FALSE, the texture coordinates are clamped in the S direction to lie within the [0.0, 1.0] range.
    bool RepeatS() const;
    void setRepeatS(bool v);
    /// The RepeatT field specifies how the texture wraps in the T direction. If RepeatT is TRUE (the default), the texture map is repeated outside the [0.0, 1.0] texture coordinate range in the T direction so that it fills the shape. If RepeatT is FALSE, the texture coordinates are clamped in the T direction to lie within the [0.0, 1.0] range.
    bool RepeatT() const;
    void setRepeatT(bool v);
    /// The Mode attribute is provided to control the appearance of a multi textures. The mode then controls the type of blending operation. The mode includes a MODULATE for a lit appearance, a REPLACE for a unlit appearance, and variations of the two.
    /// 
    /// NOTE  The applicable values for the Mode attribute are determined by view definitions or implementer agreements. It is recommended to use the modes described in ISO/IES 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1. See 18.4.3 MultiTexture for recommended values.
    /// 
    /// IFC2x4 CHANGE  New attribute replacing previous TextureType.
    boost::optional< std::string > Mode() const;
    void setMode(boost::optional< std::string > v);
    /// The TextureTransform defines a 2D transformation that is applied to the texture coordinates. It affects the way texture coordinates are applied to the surfaces of geometric representation itesm. The 2D transformation supports changes to the size, orientation, and position of textures on shapes. 
    /// 
    /// Mirroring is not allowed to be used in the IfcCarteesianTransformationOperator
    ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* TextureTransform() const;
    void setTextureTransform(::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v);
    /// The Parameter attribute is provided to control the appearance of a multi textures. The applicable parameters depend on the value of the Mode attribute.
    /// 
    /// NOTE  The applicable values for the list of Parameter attributes are determined by view definitions or implementer agreements. It is recommended to use the source and the function fields described in ISO/IES 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1. See 18.4.3 MultiTexture for recommended values.
    /// By convention, Parameter[1] shall then hold the source value, Parameter[2] the function value, Parameter[3] the base RGB color for select operations, and Parameter[4] the alpha value for select operations.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::vector< std::string > /*[1:?]*/ > Parameter() const;
    void setParameter(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
        aggregate_of< IfcTextureCoordinate >::ptr IsMappedBy() const; // INVERSE IfcTextureCoordinate::Maps
    aggregate_of< IfcSurfaceStyleWithTextures >::ptr UsedInStyles() const; // INVERSE IfcSurfaceStyleWithTextures::Textures
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceTexture (IfcEntityInstanceData&& e);
    IfcSurfaceTexture (bool v1_RepeatS, bool v2_RepeatT, boost::optional< std::string > v3_Mode, ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v4_TextureTransform, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_Parameter);
    typedef aggregate_of< IfcSurfaceTexture > list;
};
/// An IfcTable is a data structure for the provision of information in the form of rows and columns. Each instance may have IfcTableColumn instances that define the name, description and units for each column. The rows of information are stored as a list of IfcTableRow objects. 
/// 
/// Limitation: For backwards compatibility, the rows of an IfcTable object are constrained to have the same number of cells. The first Row of the table provides the number of cells. All other rows are forced to include the same number of cells. This is enforced by the WR2. 
/// 
/// Figure 335 illustrates table use.
/// 
/// Figure 335 — Table use
/// 
/// Figure 336 depicts how tables were structured prior to IFC2x4.
/// 
/// Figure 336 — Table use alternative
/// 
/// HISTORY  New entity in IFC R1.5.
/// 
/// IFC2x4 CHANGE  Columns attribute added.
class IFC_PARSE_API IfcTable : public  IfcUtil::IfcBaseEntity, public  IfcMetricValueSelect, public  IfcObjectReferenceSelect {
public:
    /// A unique name which is intended to describe the usage of the Table.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Reference to information content of rows.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableRow >::ptr > Rows() const;
    void setRows(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableRow >::ptr > v);
    /// The column information associated with this table.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableColumn >::ptr > Columns() const;
    void setColumns(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableColumn >::ptr > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTable (IfcEntityInstanceData&& e);
    IfcTable (boost::optional< std::string > v1_Name, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableRow >::ptr > v2_Rows, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcTableColumn >::ptr > v3_Columns);
    typedef aggregate_of< IfcTable > list;
};
/// An IfcTableColumn is a data structure that captures column information for use in an IfcTable. Each instance defines the name, description, identifier, and units of measure that are applicable to the columnar data associated with the IfcTableRow objects. 
/// 
/// The use of IfcTableColumn supercedes the IsHeading flag associated with IfcTableRow. 
/// 
/// HISTORY  New entity in IFC2x4.
class IFC_PARSE_API IfcTableColumn : public  IfcUtil::IfcBaseEntity {
public:
    /// Table column identifier.
    boost::optional< std::string > Identifier() const;
    void setIdentifier(boost::optional< std::string > v);
    /// The table column display name.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Descriptive text for the table column.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The unit of measure to be used for this column's data.
    ::Ifc4x3_rc1::IfcUnit* Unit() const;
    void setUnit(::Ifc4x3_rc1::IfcUnit* v);
    ::Ifc4x3_rc1::IfcReference* ReferencePath() const;
    void setReferencePath(::Ifc4x3_rc1::IfcReference* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTableColumn (IfcEntityInstanceData&& e);
    IfcTableColumn (boost::optional< std::string > v1_Identifier, boost::optional< std::string > v2_Name, boost::optional< std::string > v3_Description, ::Ifc4x3_rc1::IfcUnit* v4_Unit, ::Ifc4x3_rc1::IfcReference* v5_ReferencePath);
    typedef aggregate_of< IfcTableColumn > list;
};
/// IfcTableRow contains data for a single row within an IfcTable. 
/// 
/// Limitation: For backward compatibility, all IfcTableRow objects referenced by an IfcTable shall have the same number of Row Cells. The actual number of Cells shall be taken from the number of cells of the first IfcTableRow for that table. The number of Cells is calculated by the derived attribute NumberOfCellsInRow in the associated IfcTable. 
/// 
/// Figure 337 illustrates table row use.
/// 
/// Figure 337 — Table row use
/// 
/// Figure 338 depicts how table rows were structured prior to IFC2x4 with the use of the IsHeading flag. Note that the use of the IfcTableColumn constructs should be used instead of the IsHeading flag (which remains for backward compatibility only): 
/// 
/// Figure 338 — Table row use alternative
/// 
/// HISTORY  New entity in IFC R1.5.
class IFC_PARSE_API IfcTableRow : public  IfcUtil::IfcBaseEntity {
public:
    /// The data value of the table cell..
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr > RowCells() const;
    void setRowCells(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr > v);
    /// Flag which identifies if the row is a heading row or a row which contains row values. NOTE - If the row is a heading, the flag takes the value = TRUE.
    boost::optional< bool > IsHeading() const;
    void setIsHeading(boost::optional< bool > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTableRow (IfcEntityInstanceData&& e);
    IfcTableRow (boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr > v1_RowCells, boost::optional< bool > v2_IsHeading);
    typedef aggregate_of< IfcTableRow > list;
};
/// IfcTaskTime captures the time-related information about a task including the different types (actual or scheduled) of starting and ending times.
/// 
/// HISTORY: New entity in IFC2x4, adapted from IfcScheduleTimeControl.  Differently to IfcScheduleTimeControl it is also possible to differentiate duration time measures between the two possible types; (1) work time and (2) elapsed time.
/// 
/// Use definitions
/// All given values should be provided by the application; the IFC schema does not deal with dependencies between task time values. There is also no consistency check through where rules that guarantee a meaningful population of time values. Thus, an application is responsible to provide reasonable values and, if an application receives task times, has to make consistency checks by their own.
/// 
/// IfcTaskTime furthermore provides a generic mechanism to differentiate between user given time values and time values derived from user given time values and other constraints such as work calendars and assigned resources.
class IFC_PARSE_API IfcTaskTime : public  IfcSchedulingTime {
public:
    /// Enables to specify the type of duration values for ScheduleDuration,        ActualDuration and RemainingTime. The duration type is either
    ///   work time or elapsed time.
    boost::optional< ::Ifc4x3_rc1::IfcTaskDurationEnum::Value > DurationType() const;
    void setDurationType(boost::optional< ::Ifc4x3_rc1::IfcTaskDurationEnum::Value > v);
    /// The amount of time which is scheduled for completion of a
    ///   task.
    ///   The value might be measured or somehow calculated, which is defined by
    ///   ScheduleDataOrigin. 
    ///   The value is either given as elapsed time or work time, which is defined by
    ///   DurationType.
    /// 
    /// NOTE: Scheduled Duration may be calculated as the
    ///   time from scheduled start date to scheduled finish date.
    boost::optional< std::string > ScheduleDuration() const;
    void setScheduleDuration(boost::optional< std::string > v);
    /// The date on which a task is scheduled to be started. 
    ///   The value might be measured or somehow calculated, which is defined by
    ///   ScheduleDataOrigin.
    /// 
    /// NOTE: The scheduled start date must be greater than
    ///   or equal to the earliest start date.
    boost::optional< std::string > ScheduleStart() const;
    void setScheduleStart(boost::optional< std::string > v);
    /// The date on which a task is scheduled to be finished.
    ///   The value might be measured or somehow calculated, which is defined by
    ///   ScheduleDataOrigin.
    /// 
    /// NOTE: The scheduled finish date must be greater than
    ///   or equal to the earliest finish date.
    boost::optional< std::string > ScheduleFinish() const;
    void setScheduleFinish(boost::optional< std::string > v);
    /// The earliest date on which a task can be started. It is a calculated value.
    boost::optional< std::string > EarlyStart() const;
    void setEarlyStart(boost::optional< std::string > v);
    /// The earliest date on which a task can be finished. It is a calculated value.
    boost::optional< std::string > EarlyFinish() const;
    void setEarlyFinish(boost::optional< std::string > v);
    /// The latest date on which a task can be started. It is a calculated value.
    boost::optional< std::string > LateStart() const;
    void setLateStart(boost::optional< std::string > v);
    /// The latest date on which a task can be finished. It is a calculated value.
    boost::optional< std::string > LateFinish() const;
    void setLateFinish(boost::optional< std::string > v);
    /// The amount of time during which the start or finish of a
    ///   task may be varied without any effect on the overall
    ///   programme of work. It is a calculated elapsed time value.
    boost::optional< std::string > FreeFloat() const;
    void setFreeFloat(boost::optional< std::string > v);
    /// The difference between the duration available to carry out
    ///   a task and the scheduled duration of the task. It is a calculated 
    ///   elapsed time value.
    /// 
    /// NOTE: Total Float time may be calculated as being
    ///   the difference between the scheduled duration of a task and
    ///   the available duration from earliest start to latest
    ///   finish. Float time may be either positive, zero or
    ///   negative. Where it is zero or negative, the task becomes
    ///   critical.
    boost::optional< std::string > TotalFloat() const;
    void setTotalFloat(boost::optional< std::string > v);
    /// A flag which identifies whether a scheduled task is a
    ///   critical item within the programme.
    /// 
    /// NOTE: A task becomes critical when the float time
    ///   becomes zero or negative.
    boost::optional< bool > IsCritical() const;
    void setIsCritical(boost::optional< bool > v);
    /// The date or time at which the status of the tasks within
    ///   the schedule is analyzed.
    boost::optional< std::string > StatusTime() const;
    void setStatusTime(boost::optional< std::string > v);
    /// The actual duration of the task. It is a measured value.
    ///   The value is either given as elapsed time or work time, which is defined by
    ///   DurationType.
    boost::optional< std::string > ActualDuration() const;
    void setActualDuration(boost::optional< std::string > v);
    /// The date on which a task is actually started. It is a measured value.
    /// 
    /// NOTE: The scheduled start date must be greater than
    ///   or equal to the earliest start date. No constraint is
    ///   applied to the actual start date with respect to the
    ///   scheduled start date since a task may be started earlier
    ///   than had originally been scheduled if circumstances allow.
    boost::optional< std::string > ActualStart() const;
    void setActualStart(boost::optional< std::string > v);
    /// The date on which a task is actually finished.
    boost::optional< std::string > ActualFinish() const;
    void setActualFinish(boost::optional< std::string > v);
    /// The amount of time remaining to complete a task. It is a predicted value.
    ///   The value is either given as elapsed time or work time, which is defined by
    ///   DurationType.
    /// 
    /// NOTE: The time remaining in which to complete a task
    ///   may be determined both for tasks which have not yet started
    ///   and those which have. Remaining time for a task not yet
    ///   started has the same value as the scheduled duration. For a
    ///   task already started, remaining time is calculated as the
    ///   difference between the scheduled finish and the point of
    ///   analysis.
    boost::optional< std::string > RemainingTime() const;
    void setRemainingTime(boost::optional< std::string > v);
    /// The extent of completion expressed as a ratio or percentage.
    ///   It is a measured value.
    boost::optional< double > Completion() const;
    void setCompletion(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTaskTime (IfcEntityInstanceData&& e);
    IfcTaskTime (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin, boost::optional< ::Ifc4x3_rc1::IfcTaskDurationEnum::Value > v4_DurationType, boost::optional< std::string > v5_ScheduleDuration, boost::optional< std::string > v6_ScheduleStart, boost::optional< std::string > v7_ScheduleFinish, boost::optional< std::string > v8_EarlyStart, boost::optional< std::string > v9_EarlyFinish, boost::optional< std::string > v10_LateStart, boost::optional< std::string > v11_LateFinish, boost::optional< std::string > v12_FreeFloat, boost::optional< std::string > v13_TotalFloat, boost::optional< bool > v14_IsCritical, boost::optional< std::string > v15_StatusTime, boost::optional< std::string > v16_ActualDuration, boost::optional< std::string > v17_ActualStart, boost::optional< std::string > v18_ActualFinish, boost::optional< std::string > v19_RemainingTime, boost::optional< double > v20_Completion);
    typedef aggregate_of< IfcTaskTime > list;
};
/// IfcTaskTimeRecurring is a recurring instance of IfcTaskTime for handling regularly scheduled or repetitive tasks.
/// 
/// HISTORY: New entity in IFC2x4.
class IFC_PARSE_API IfcTaskTimeRecurring : public  IfcTaskTime {
public:
    ::Ifc4x3_rc1::IfcRecurrencePattern* Recurrence() const;
    void setRecurrence(::Ifc4x3_rc1::IfcRecurrencePattern* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTaskTimeRecurring (IfcEntityInstanceData&& e);
    IfcTaskTimeRecurring (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin, boost::optional< ::Ifc4x3_rc1::IfcTaskDurationEnum::Value > v4_DurationType, boost::optional< std::string > v5_ScheduleDuration, boost::optional< std::string > v6_ScheduleStart, boost::optional< std::string > v7_ScheduleFinish, boost::optional< std::string > v8_EarlyStart, boost::optional< std::string > v9_EarlyFinish, boost::optional< std::string > v10_LateStart, boost::optional< std::string > v11_LateFinish, boost::optional< std::string > v12_FreeFloat, boost::optional< std::string > v13_TotalFloat, boost::optional< bool > v14_IsCritical, boost::optional< std::string > v15_StatusTime, boost::optional< std::string > v16_ActualDuration, boost::optional< std::string > v17_ActualStart, boost::optional< std::string > v18_ActualFinish, boost::optional< std::string > v19_RemainingTime, boost::optional< double > v20_Completion, ::Ifc4x3_rc1::IfcRecurrencePattern* v21_Recurrence);
    typedef aggregate_of< IfcTaskTimeRecurring > list;
};
/// Definition: Address to which telephone, electronic mail and other forms of telecommunications should be addressed.
/// 
/// HISTORY New entity in IFC Release 2x.
/// 
/// IFC 2x4 change:  Added attribute MessagingIDs.
/// Type of attribute WWWHomePageURL compatibly changed from IfcLabel to IfcURIReference.
class IFC_PARSE_API IfcTelecomAddress : public  IfcAddress {
public:
    /// The list of telephone numbers at which telephone messages may be received.
    boost::optional< std::vector< std::string > /*[1:?]*/ > TelephoneNumbers() const;
    void setTelephoneNumbers(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// The list of fax numbers at which fax messages may be received.
    boost::optional< std::vector< std::string > /*[1:?]*/ > FacsimileNumbers() const;
    void setFacsimileNumbers(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// The pager number at which paging messages may be received.
    boost::optional< std::string > PagerNumber() const;
    void setPagerNumber(boost::optional< std::string > v);
    /// The list of Email addresses at which Email messages may be received.
    boost::optional< std::vector< std::string > /*[1:?]*/ > ElectronicMailAddresses() const;
    void setElectronicMailAddresses(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
    /// The world wide web address at which the preliminary page of information for the person or organization can be located.
    /// NOTE: Information on the world wide web for a person or organization may be separated 
    /// into a number of pages and across a number of host sites, all of which may be linked together. It is assumed that 
    /// all such information may be referenced from a single page that is termed the home page for that person or organization.
    boost::optional< std::string > WWWHomePageURL() const;
    void setWWWHomePageURL(boost::optional< std::string > v);
    /// IDs or addresses for any other means of telecommunication, for example instant messaging, voice-over-IP, or file transfer protocols. The communication protocol is indicated by the URI value with scheme designations such as irc:, sip:, or ftp:.
    boost::optional< std::vector< std::string > /*[1:?]*/ > MessagingIDs() const;
    void setMessagingIDs(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTelecomAddress (IfcEntityInstanceData&& e);
    IfcTelecomAddress (boost::optional< ::Ifc4x3_rc1::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose, boost::optional< std::vector< std::string > /*[1:?]*/ > v4_TelephoneNumbers, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_FacsimileNumbers, boost::optional< std::string > v6_PagerNumber, boost::optional< std::vector< std::string > /*[1:?]*/ > v7_ElectronicMailAddresses, boost::optional< std::string > v8_WWWHomePageURL, boost::optional< std::vector< std::string > /*[1:?]*/ > v9_MessagingIDs);
    typedef aggregate_of< IfcTelecomAddress > list;
};
/// Definition from ISO/CD 10303-46:1992: The text style is a presentation style for annotation text.
/// 
/// The IfcTextStyle provides the text style table for presentation information assigned to text literals. The style is defined by color, text font characteristics, and text box characteristics. The definitions are based upon:
/// 
/// definitions from ISO/IS 10303-46:1994 for (old) vector based and monospace text.
///   definitions from Cascading Style Sheets, level 1, W3C Recommendation 17 Dec 1996, revised 11 Jan 1999, CSS1, for all true type text. The use of the CSS1 definitions is the preferred way to represent text styles.
/// 
/// An IfcTextStyle, when representing (old) vector based and monospace text, is instantiated with:
/// 
/// TextCharacterAppearance:: IfcTextStyleForDefinedFont (with BackgroundColour = NIL)
///   TextStyle:: IfcTextStyleWithBoxCharacteristics
///   TextFontStyle:: IfcDraughtingPreDefinedTextFont or IfcExternallyDefinedTextFont
/// 
/// An IfcTextStyle, when representing (new) true type text, based on CSS1 definitions, is instantiated with:
/// 
/// TextCharacterAppearance:: IfcTextStyleForDefinedFont
///   TextStyle:: IfcTextStyleTextModel
///   TextFontStyle:: IfcTextStyleFontModel
/// 
/// An IfcTextStyle can be assigned to IfcTextLiteral via the IfcPresentationStyleAssignment through an intermediate IfcAnnotationTextOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: text_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. In order to avoid ANDOR subtype relationships, the IfcTextBlockStyleSelect has been introduced that allows the combination of a text style as having box characteristic, and/or having spacing, or having none of those additional properties.
/// 
/// NOTE  Corresponding CSS1 definitions are: Font properties (font-family, font-style, font-variant, font-weight, font-size), Color and background properties (color, background-color) and Text properties (word-spacing, letter-spacing, text-decoration, text-transform, text-align, text-indent, line-height).
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The IfcTextStyle has been changed by adding TextFontStyle and different data types for TextStyle and IfcCharacterStyleSelect.
class IFC_PARSE_API IfcTextStyle : public  IfcPresentationStyle, public  IfcPresentationStyleSelect {
public:
    /// A character style to be used for presented text.
    ::Ifc4x3_rc1::IfcTextStyleForDefinedFont* TextCharacterAppearance() const;
    void setTextCharacterAppearance(::Ifc4x3_rc1::IfcTextStyleForDefinedFont* v);
    /// The style applied to the text block for its visual appearance.
    /// It defines the text block characteristics, either for vector based or monospace text fonts (see select item IfcTextStyleWithBoxCharacteristics), or for true type text fonts (see select item IfcTextStyleTextModel.
    /// 
    /// IFC2x Edition 3 CHANGE  The attribute TextBlockStyle has been changed from SET[1:?] to a non-aggregated optional, it has been renamed from TextStyles.
    ::Ifc4x3_rc1::IfcTextStyleTextModel* TextStyle() const;
    void setTextStyle(::Ifc4x3_rc1::IfcTextStyleTextModel* v);
    /// The style applied to the text font for its visual appearance.
    /// It defines the font family, font style, weight and size.
    /// 
    /// IFC2x Edition 2 Addendum 2 CHANGE The attribute TextFontStyle is a new attribute attached to IfcTextStyle.
    ::Ifc4x3_rc1::IfcTextFontSelect* TextFontStyle() const;
    void setTextFontStyle(::Ifc4x3_rc1::IfcTextFontSelect* v);
    boost::optional< bool > ModelOrDraughting() const;
    void setModelOrDraughting(boost::optional< bool > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyle (IfcEntityInstanceData&& e);
    IfcTextStyle (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcTextStyleForDefinedFont* v2_TextCharacterAppearance, ::Ifc4x3_rc1::IfcTextStyleTextModel* v3_TextStyle, ::Ifc4x3_rc1::IfcTextFontSelect* v4_TextFontStyle, boost::optional< bool > v5_ModelOrDraughting);
    typedef aggregate_of< IfcTextStyle > list;
};
/// Definition from ISO/CD 10303-46:1992: A text style for defined font is a character glyph style for pre-defined or externally defined text fonts.
/// 
/// Definition from CSS1 (W3C Recommendation): These properties describe the color (often called foreground color) and background of an element (i.e. the surface onto which the content is rendered). One can set a background color.
/// 
/// NOTE  The CSS1 definition allows also for a background image. This has not been incorporated into IFC.
/// 
/// The IfcTextStyleForDefinedFont combines the text font color with an optional background color, that fills the text box, defined by the planar extent given to the text literal.
/// 
/// NOTE  Corresponding ISO 10303 name: text_style_for_defined_font. Please refer to ISO/IS
/// 10303-46:1994, p.122 for the final definition of the formal standard. The attribute BackgroundColour
/// has been added.
/// 
/// NOTE  Corresponding CSS1 definitions are Color and background properties (color, background-color).
/// 
/// HISTORY  New entity in IFC2x3.
/// 
/// IFC2x3 CHANGE  The IfcTextStyleForDefinedFont has been added and replaces IfcColour at the IfcCharacterStyleSelect.
class IFC_PARSE_API IfcTextStyleForDefinedFont : public  IfcPresentationItem {
public:
    /// This property describes the text color of an element (often referred to as the foreground color).
    ::Ifc4x3_rc1::IfcColour* Colour() const;
    void setColour(::Ifc4x3_rc1::IfcColour* v);
    /// This property sets the background color of an element.
    ::Ifc4x3_rc1::IfcColour* BackgroundColour() const;
    void setBackgroundColour(::Ifc4x3_rc1::IfcColour* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleForDefinedFont (IfcEntityInstanceData&& e);
    IfcTextStyleForDefinedFont (::Ifc4x3_rc1::IfcColour* v1_Colour, ::Ifc4x3_rc1::IfcColour* v2_BackgroundColour);
    typedef aggregate_of< IfcTextStyleForDefinedFont > list;
};
/// Definition from CSS1 (W3C Recommendation): The properties defined in the text model affect the visual presentation of characters, spaces, words, and paragraphs.
/// 
/// The IfcTextStyleTextModel combines all text style properties, that affect the presentation of a text literal within a given extent. It includes the spacing between characters and words, the horizontal and vertical alignment of the text within the planar box of the extent, decorations (like underline), transformations of the literal (like uppercase), and the height of each text line within a multi-line text block.
/// 
/// NOTE  Corresponding CSS1 definitions are Text properties (word-spacing, letter-spacing, text-decoration, vertical-align, text-transform, text-align, text-indent, line-height).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcTextStyleTextModel : public  IfcPresentationItem {
public:
    /// The property specifies the indentation that appears before the first formatted line.
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    ::Ifc4x3_rc1::IfcSizeSelect* TextIndent() const;
    void setTextIndent(::Ifc4x3_rc1::IfcSizeSelect* v);
    /// This property describes how text is aligned horizontally within the element. The actual justification algorithm used is dependent on the rendering algorithm.
    boost::optional< std::string > TextAlign() const;
    void setTextAlign(boost::optional< std::string > v);
    /// This property describes decorations that are added to the text of an element.
    boost::optional< std::string > TextDecoration() const;
    void setTextDecoration(boost::optional< std::string > v);
    /// The length unit indicates an addition to the default space between characters. Values can be negative, but there may be implementation-specific limits. The user agent is free to select the exact spacing algorithm. The letter spacing may also be influenced by justification (which is a value of the 'align' property).
    ///   NOTE  The following values are allowed, IfcDescriptiveMeasure with value='normal', or IfcLengthMeasure, the length unit is globally defined at IfcUnitAssignment.
    ::Ifc4x3_rc1::IfcSizeSelect* LetterSpacing() const;
    void setLetterSpacing(::Ifc4x3_rc1::IfcSizeSelect* v);
    /// The length unit indicates an addition to the default space between words. Values can be negative, but there may be implementation-specific limits. The user agent is free to select the exact spacing algorithm. The word spacing may also be influenced by justification (which is a value of the 'text-align' property).
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    ::Ifc4x3_rc1::IfcSizeSelect* WordSpacing() const;
    void setWordSpacing(::Ifc4x3_rc1::IfcSizeSelect* v);
    /// This property describes how text characters may transform to upper case, lower case, or capitalized case, independent of the character case used in the text literal.
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    boost::optional< std::string > TextTransform() const;
    void setTextTransform(boost::optional< std::string > v);
    /// The property sets the distance between two adjacent lines' baselines.
    /// When a ratio value is specified, the line height is given by the font size of the current element multiplied with the numerical value. A value of 'normal' sets the line height to a reasonable value for the element's font. It is suggested that user agents set the 'normal' value to be a ratio number in the range of 1.0 to 1.2.
    ///   NOTE  The following values are allowed: IfcDescriptiveMeasure with value='normal', or 
    /// IfcLengthMeasure, with non-negative values, the length unit is globally defined at IfcUnitAssignment, or IfcRatioMeasure.
    ::Ifc4x3_rc1::IfcSizeSelect* LineHeight() const;
    void setLineHeight(::Ifc4x3_rc1::IfcSizeSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleTextModel (IfcEntityInstanceData&& e);
    IfcTextStyleTextModel (::Ifc4x3_rc1::IfcSizeSelect* v1_TextIndent, boost::optional< std::string > v2_TextAlign, boost::optional< std::string > v3_TextDecoration, ::Ifc4x3_rc1::IfcSizeSelect* v4_LetterSpacing, ::Ifc4x3_rc1::IfcSizeSelect* v5_WordSpacing, boost::optional< std::string > v6_TextTransform, ::Ifc4x3_rc1::IfcSizeSelect* v7_LineHeight);
    typedef aggregate_of< IfcTextStyleTextModel > list;
};
/// The IfcTextureCoordinate a an abstract supertype of the different kinds to apply texture coordinates to geometries. For vertex based geometries an explicit assignment of 2D texture vertices to the 3D geometry points is supported by the subtype IfcTextureMap, in addition there can be a procedural description of how texture coordinates shall be applied to geometric items. If no IfcTextureCoordinate is provided for the IfcSurfaceTexture, the default mapping shall be used.
/// 
/// See relevant subtypes of IfcGeometricRepresentationItem for default texture mapping description.
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attribute Texture is deleted.
/// 
/// IFC2x4 CHANGE  The inverse attribute AnnotatedSurface is deleted, and the inverse AppliesTextures is added.
class IFC_PARSE_API IfcTextureCoordinate : public  IfcPresentationItem {
public:
    aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr Maps() const;
    void setMaps(aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureCoordinate (IfcEntityInstanceData&& e);
    IfcTextureCoordinate (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Maps);
    typedef aggregate_of< IfcTextureCoordinate > list;
};
/// The IfcTextureCoordinateGenerator describes a procedurally defined mapping function with input parameter to map 2D texture coordinates to 3D geometry vertices. The allowable Mode values and input Parameter need to be agreed upon in view definitions and implementer agreements.
/// 
/// It is recommended to use the texture coordinate generation modes as defined in X3D.
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) apply:
/// 
/// The TextureCoordinateGenerator supports the automatic generation of texture coordinates for geometric shapes.
/// The mode field describes the algorithm used to compute texture coordinates.
/// 
/// SPHERE,
/// CAMERASPACENORMAL,
/// CAMERASPACEPOSITION,
/// CAMERASPACEREFLECTIONVECTOR,
/// SPHERE-LOCAL,
/// COORD,
/// COORD-EYE,
/// NOISE,
/// NOISE-EYE,
/// SPHERE-REFLECT,
/// SPHERE-REFLECT-LOCAL
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY New entity in IFC2x2.
/// 
/// IFC2x2 Addendum 2 CHANGE  The attribute Texturehas been deleted.
class IFC_PARSE_API IfcTextureCoordinateGenerator : public  IfcTextureCoordinate {
public:
    /// The Mode attribute describes the algorithm used to compute texture coordinates.
    /// 
    /// NOTE  The applicable values for the Mode attribute are determined by view definitions or implementer agreements. It is recommended to use the modes described in ISO/IES 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1. See 18.4.8 TextureCoordinateGenerator for recommended values.
    std::string Mode() const;
    void setMode(std::string v);
    /// The parameters used as arguments by the function as specified by Mode.
    /// 
    /// IFC2x4 CHANGE  Made optional data type restricted to REAL.
    boost::optional< std::vector< double > /*[1:?]*/ > Parameter() const;
    void setParameter(boost::optional< std::vector< double > /*[1:?]*/ > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureCoordinateGenerator (IfcEntityInstanceData&& e);
    IfcTextureCoordinateGenerator (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Maps, std::string v2_Mode, boost::optional< std::vector< double > /*[1:?]*/ > v3_Parameter);
    typedef aggregate_of< IfcTextureCoordinateGenerator > list;
};
/// An IfcTextureMap provides the mapping of the
/// 2-dimensional texture coordinates to the surface onto which it is
/// mapped. It is used for mapping the texture to surfaces of vertex
/// based geometry models, such as
/// 
/// IfcFacetedBrep
/// IfcFacetedBrepWithVoids
/// IfcFaceBasedSurfaceModel
/// IfcShellBasedSurfaceModel
/// 
/// The IfcTextureMap has a list of TextureVertex,
/// that corresponds to the points of the face bound of the vertex
/// based geometry item. The corresponding pair of lists is:
/// 
/// the list of Polygon of type IfcCartesianPoint,
/// and
/// the list of Vertices of type
/// IfcTextureVertex.
/// 
/// Each IfcTextureVertex (given as S, T coordinates of the
/// 2-dimension texture coordinate system) corresponds to the geometric
/// coordinates of the IfcCartesianPoint (given as 3-dimension
/// X, Y, and Z coordinates within the object coordinate system of the
/// geometric item).
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// The TextureCoordinate node is a geometry property node that
/// specifies a set of 2D texture coordinates used by vertex-based
/// geometry nodes to map textures to vertices.
/// 
/// NOTE  In contrary to the
/// X3D vertext based geometry, for example IndexedFaceSet and
/// ElevationGrid, the vertext based geometry in IFC may include inner
/// loops. The areas of inner loops have to be cut-out from the texture
/// applied to the outer loop.
/// 
/// Figure 301 illustrates applying a texture map to a vertex based geometry.
/// 
/// Figure 301 — Texture map
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attribute Texture is deleted, and the attribute TextureMaps is added.
/// 
/// IFC2x4 CHANGE  The attribute TextureMap is replaced by Vertices, and the attribute AppliedTo is added.
/// 
/// Informal propositions:
/// 
/// The FaceBound referenced in AppliedTo shall be used by the vertex based geometry, to which this texture map is assigned to by through the IfcStyledItem.
class IFC_PARSE_API IfcTextureMap : public  IfcTextureCoordinate {
public:
    /// List of texture coordinate vertices that are applied to the corresponding points of the polyloop defining a face bound.
    /// 
    /// NOTE  The corresponding face bound may be an inner loop.
    aggregate_of< ::Ifc4x3_rc1::IfcTextureVertex >::ptr Vertices() const;
    void setVertices(aggregate_of< ::Ifc4x3_rc1::IfcTextureVertex >::ptr v);
    ::Ifc4x3_rc1::IfcFace* MappedTo() const;
    void setMappedTo(::Ifc4x3_rc1::IfcFace* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureMap (IfcEntityInstanceData&& e);
    IfcTextureMap (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Maps, aggregate_of< ::Ifc4x3_rc1::IfcTextureVertex >::ptr v2_Vertices, ::Ifc4x3_rc1::IfcFace* v3_MappedTo);
    typedef aggregate_of< IfcTextureMap > list;
};
/// An IfcTextureVertex is a list of 2 (S, T) texture coordinates. 
/// 
/// The following additional definitions from ISO 19775 apply:
/// 
/// Each vertex-based geometry node uses a set of 2D texture
/// coordinates that map textures to vertices. Texture map values (
/// ImageTexture, PixelTexture) range from [0.0, 1.0] along the S-axis and
/// T-axis. However, texture coordinate values may be in the range
/// (-∞,∞). Texture coordinates identify a location
/// (and thus a
/// colour value) in the texture map. The horizontal coordinate S is
/// specified first, followed by the vertical coordinate T. If the texture
/// map is repeated in a given direction (S-axis or T-axis), a texture
/// coordinate C (s or t) is mapped into a texture map that has N pixels in
/// the given direction as follows: 
/// 
/// Texture map location = (C - floor(C)) × N			 
/// 
/// If the texture map is not
/// repeated, the texture coordinates are
/// clamped to the 0.0 to 1.0 range as follows: 
/// 
/// Texture map location = N,     if C > 1.0,                     = 0.0,   if C < 0.0,                     = C × N, if 0.0 ≤ C ≤ 1.0.
/// 
/// Texture coordinates may be transformed (scaled, rotated, translated) by supplying a TextureTransform as a component of the texture's definition. 
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTextureVertex : public  IfcPresentationItem {
public:
    /// The first coordinate[1] is the S, the second coordinate[2] is the T parameter value.
    std::vector< double > /*[2:2]*/ Coordinates() const;
    void setCoordinates(std::vector< double > /*[2:2]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureVertex (IfcEntityInstanceData&& e);
    IfcTextureVertex (std::vector< double > /*[2:2]*/ v1_Coordinates);
    typedef aggregate_of< IfcTextureVertex > list;
};

class IFC_PARSE_API IfcTextureVertexList : public  IfcPresentationItem {
public:
    std::vector< std::vector< double > > TexCoordsList() const;
    void setTexCoordsList(std::vector< std::vector< double > > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureVertexList (IfcEntityInstanceData&& e);
    IfcTextureVertexList (std::vector< std::vector< double > > v1_TexCoordsList);
    typedef aggregate_of< IfcTextureVertexList > list;
};
/// IfcTimePeriod defines a time period given by a start and end time. Both time definitions consider the time zone and allow for the daylight savings offset.
/// 
/// HISTORY: New entity in IFC R2x4.
/// 
/// Use definitions
/// A time period is defined by a start and an end time, which is defined by IfcTime. The given time period should be within reasonable values (for example, the start time must be before the end time). It is furthermore expected that both time definitions use the same time zone and, if given, the same daylight saving offset.
class IFC_PARSE_API IfcTimePeriod : public  IfcUtil::IfcBaseEntity {
public:
    /// Start time of the time period.
    std::string StartTime() const;
    void setStartTime(std::string v);
    /// End time of the time period.
    std::string EndTime() const;
    void setEndTime(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimePeriod (IfcEntityInstanceData&& e);
    IfcTimePeriod (std::string v1_StartTime, std::string v2_EndTime);
    typedef aggregate_of< IfcTimePeriod > list;
};
/// A time series is a set of a time-stamped data entries. It allows a natural association of data collected over intervals of time. Time series can be regular or irregular. In regular time series data arrive predictably at predefined intervals.  In irregular time series  some or all time stamps do not follow a repetitive pattern and unpredictable bursts of data may arrive at unspecified points in time.
/// 
/// The modeling of buildings and their performance involves data that are generated and recorded over a period of time.  Such data cover a large spectrum, from weather data to schedules of all kinds to status measurements to reporting to everything else that has a time related aspect. Their correct placement in time is essential for their proper understanding and use, and the IfcTimeSeries subtypes provide the appropriate data structures to accommodate these types of data.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTimeSeries : public  IfcUtil::IfcBaseEntity, public  IfcMetricValueSelect, public  IfcObjectReferenceSelect, public  IfcResourceObjectSelect {
public:
    /// An unique name for the time series.
    std::string Name() const;
    void setName(std::string v);
    /// A text description of the data that the series represents.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The start time of a time series.
    std::string StartTime() const;
    void setStartTime(std::string v);
    /// The end time of a time series.
    std::string EndTime() const;
    void setEndTime(std::string v);
    /// The time series data type.
    ::Ifc4x3_rc1::IfcTimeSeriesDataTypeEnum::Value TimeSeriesDataType() const;
    void setTimeSeriesDataType(::Ifc4x3_rc1::IfcTimeSeriesDataTypeEnum::Value v);
    /// The orgin of a time series data.
    ::Ifc4x3_rc1::IfcDataOriginEnum::Value DataOrigin() const;
    void setDataOrigin(::Ifc4x3_rc1::IfcDataOriginEnum::Value v);
    /// Value of the data origin if DataOrigin attribute is USERDEFINED.
    boost::optional< std::string > UserDefinedDataOrigin() const;
    void setUserDefinedDataOrigin(boost::optional< std::string > v);
    /// The unit to be assigned to all values within the time series. Note that mixing units is not allowed. If the value is not given, the global unit for the type of IfcValue, as defined at IfcProject.UnitsInContext is used.
    ::Ifc4x3_rc1::IfcUnit* Unit() const;
    void setUnit(::Ifc4x3_rc1::IfcUnit* v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimeSeries (IfcEntityInstanceData&& e);
    IfcTimeSeries (std::string v1_Name, boost::optional< std::string > v2_Description, std::string v3_StartTime, std::string v4_EndTime, ::Ifc4x3_rc1::IfcTimeSeriesDataTypeEnum::Value v5_TimeSeriesDataType, ::Ifc4x3_rc1::IfcDataOriginEnum::Value v6_DataOrigin, boost::optional< std::string > v7_UserDefinedDataOrigin, ::Ifc4x3_rc1::IfcUnit* v8_Unit);
    typedef aggregate_of< IfcTimeSeries > list;
};
/// A time series value is a list of values that comprise the time series. At least one value must be supplied. Applications are expected to normalize values by applying the following three rules:
/// 
/// All time (universal, local, daylight savings, and solar) is normalized against the ISO 8601 standard GMT/UTC (Universal Coordinated Time).
/// Any rollover is handled by the application providing the data.  Rollover occurs, for example, when the measurement device resets itself while measuring and the recording data do not include the data measured before the reset.
/// The normalized data refer to the preceding time unit.  The time series example shown in Figure 241 below contains four time points: Time "a" indicates the beginning of the time series and the associated datum has no relevance.  Data at time points "b," "c" and "d" are associated with values 1, 2 and 3, respectively.
/// 
/// Figure 241 — Time series value 
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcTimeSeriesValue : public  IfcUtil::IfcBaseEntity {
public:
    /// A list of time-series values. At least one value is required.
    aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr ListValues() const;
    void setListValues(aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimeSeriesValue (IfcEntityInstanceData&& e);
    IfcTimeSeriesValue (aggregate_of< ::Ifc4x3_rc1::IfcValue >::ptr v1_ListValues);
    typedef aggregate_of< IfcTimeSeriesValue > list;
};
/// Definition from ISO/CD 10303-42:1992: The topological representation item is the supertype for all the topological representation items in the geometry resource. 
/// 
/// NOTE  Corresponding ISO 10303 entity: topological_representation_item. Please refer to ISO/IS 10303-42:1994, p.129 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcTopologicalRepresentationItem : public  IfcRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTopologicalRepresentationItem (IfcEntityInstanceData&& e);
    IfcTopologicalRepresentationItem ();
    typedef aggregate_of< IfcTopologicalRepresentationItem > list;
};
/// IfcTopologyRepresentation
/// represents the concept of a particular topological representation of a
/// product or a product component within a representation context. This
/// representation context does not need to be (but may be) a geometric
/// representation context. Several representation types for shape
/// representation are included as predefined types: 
/// 
/// Vertex
///   topological vertex
/// representation (with or without assigned geometry)
/// 
/// Edge
///   topological edge
/// representation (with or without assigned geometry)
/// 
/// Path
///   topological path
/// representation (with or without assigned geometry)
/// 
/// Face
///   topological face
/// representation (with or without assigned geometry)
/// 
/// Shell
///   topological shell
/// representation (with or without assigned geometry)
/// 
/// Undefined
///   no constraints imposed
/// 
/// The representation type is
/// given as a string value at the inherited attribute 'RepresentationType'.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTopologyRepresentation : public  IfcShapeModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTopologyRepresentation (IfcEntityInstanceData&& e);
    IfcTopologyRepresentation (::Ifc4x3_rc1::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, aggregate_of< ::Ifc4x3_rc1::IfcRepresentationItem >::ptr v4_Items);
    typedef aggregate_of< IfcTopologyRepresentation > list;
};
/// IfcUnitAssignment indicates a set of units which may be assigned. Within an IfcUnitAssigment each unit definition shall be unique; that is, there shall be no redundant unit definitions for the same unit type such as length unit or area unit. For currencies, there shall be only a single IfcMonetaryUnit within an IfcUnitAssignment.
/// 
/// NOTE  A project (IfcProject) has a unit assignment which establishes a set of units which will be used globally within the project, if not otherwise defined. Other objects may have local unit assignments if there is a requirement for them to make use of units which do not fall within the project unit assignment.
/// 
/// HISTORY  New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcUnitAssignment : public  IfcUtil::IfcBaseEntity {
public:
    /// Units to be included within a unit assignment.
    aggregate_of< ::Ifc4x3_rc1::IfcUnit >::ptr Units() const;
    void setUnits(aggregate_of< ::Ifc4x3_rc1::IfcUnit >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcUnitAssignment (IfcEntityInstanceData&& e);
    IfcUnitAssignment (aggregate_of< ::Ifc4x3_rc1::IfcUnit >::ptr v1_Units);
    typedef aggregate_of< IfcUnitAssignment > list;
};
/// Definition from ISO/CD 10303-42:1992: A vertex is the topological construct corresponding to a point. It has dimensionality 0 and extent 0. The domain of a vertex, if present, is a point in m dimensional real space RM; this is represented by the vertex point subtype. 
/// 
/// NOTE  Corresponding ISO 10303 entity: vertex. Please refer to ISO/IS 10303-42:1994, p. 129 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// Informal proposition:
/// 
/// The vertex has dimensionality 0. This is a fundamental property of the vertex.
/// The extent of a vertex is defined to be zero.
class IFC_PARSE_API IfcVertex : public  IfcTopologicalRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertex (IfcEntityInstanceData&& e);
    IfcVertex ();
    typedef aggregate_of< IfcVertex > list;
};
/// Definition from ISO/CD 10303-42:1992: A vertex point is a vertex which has its geometry defined as a point.  
/// 
/// NOTE  Corresponding ISO 10303 entity: vertex_point. Please refer to ISO/IS 10303-42:1994, p. 130 for the final definition of the formal standard. Due to the general IFC model specification rule not to use multiple inheritance, the subtype relationship to geometric_representation_item is not included.
/// 
/// HISTORY  New Entity in IFC2x.
/// 
/// Informal proposition: 
/// 
/// The domain of the vertex is formally defined to be the domain of its vertex point.
class IFC_PARSE_API IfcVertexPoint : public  IfcVertex, public  IfcPointOrVertexPoint {
public:
    /// The geometric point, which defines the position in geometric space of the vertex.
    ::Ifc4x3_rc1::IfcPoint* VertexGeometry() const;
    void setVertexGeometry(::Ifc4x3_rc1::IfcPoint* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertexPoint (IfcEntityInstanceData&& e);
    IfcVertexPoint (::Ifc4x3_rc1::IfcPoint* v1_VertexGeometry);
    typedef aggregate_of< IfcVertexPoint > list;
};
/// IfcVirtualGridIntersection defines the derived location of the intersection between two grid axes. Offset values may be given to set an offset distance to the grid axis for the calculation of the virtual grid intersection.
/// 
/// The two intersecting axes (IntersectingAxes) define the intersection point, which exact location (in terms of the Cartesian point representing the intersection) has to be calculated from the geometric representation of the two participating curves.
/// 
/// NOTE The IfcGrid local placement, that can be provided relative to the local placement of another spatial structure element, has to be taken into account for calculating the absolute placement of the IfcVirtualGridIntersection. Where rules and informal rules ensure, that the IntersectingAxes belong to the same IfcGrid
/// 
/// Offset values may be given (OffsetDistances). If given, the position within the list of OffsetDistances
/// corresponds with the position within the list of IntersectingAxes. Therefore:
/// 
/// OffsetDistances[1] sets the offset to IntersectingAxes[1],
/// OffsetDistances[2] sets the offset to IntersectingAxes[2], and
/// OffsetDistances[3] sets the offset to the virtual intersection in direction of the orientation of the cross product
/// of IntersectingAxes[1] and the orthogonal complement of the IntersectingAxes[1] (which is the positive or negative
/// direction of the z axis of the design grid position).
/// 
/// HISTORY  New entity in IFC Release 1.5. The entity name was changed from IfcConstraintRelIntersection in IFC Release 2x.
/// 
/// Informal Propositions:
/// 
/// Both, IntersectingAxes[1] and
/// IntersectingAxes[2] shall be two IfcGridAxis
/// defined by the same IfcGrid.
/// IntersectingAxes[1] and IntersectingAxes[2]
/// shall not be part of the same row of grid axes, i.e. both shall
/// not be within the same set of IfcGrid.UAxes or
/// IfcGrid.VAxes of the corresponding IfcGrid.
/// 
/// Geometry use definitions:
/// The following figures explain the usage of the OffsetDistances and IntersectingAxes attributes.
/// 
/// Figure 246 illustrates two offset distances given where the virtual intersection is defined in the xy plane of the grid axis placement.
/// 
/// Figure 246 — Virtual grid intersection with two offsets
/// 
/// Figure 247 illustrates three offset distances given where the virtual intersection is defined by an offset (in direction of the
/// z-axis of the design grid placement) to the virtual intersection in the xy plane of the grid axis placement.
/// 
/// Figure 247 — Virtual grid intersection with three offsets
/// 
/// The distance of the offset curve (OffsetDistances[n])
/// is measured from the basis curve. The distance may be positive,
/// negative or zero. A positive value of distance defines an offset
/// in the direction which is normal to the curve in the sense of an
/// anti-clockwise rotation through 90 degrees from the tangent
/// vector T at the given point. (This is in the direction of
/// orthogonal complement(T).) This can be reverted by the
/// SameSense attribute at IfcGridAxis which may switch
/// the sense of the AxisCurve.
/// Illustration
/// 
/// Figure 248 illustrates an example of a negative offset where the figure shows the side of the offset.
/// 
/// IntersectingAxes[1].AxisCurve is an
/// IfcTrimmedCurve with an IfcCircle as
/// BasisCurve and SenseAgreement = TRUE.
/// IntersectingAxes[1].SameSense = TRUE.
/// OffsetDistances[1] is a negative length measure
/// 
/// Figure 248 — Virtual grid intersection negative offset
class IFC_PARSE_API IfcVirtualGridIntersection : public  IfcUtil::IfcBaseEntity, public  IfcGridPlacementDirectionSelect {
public:
    /// Two grid axes which intersects at exactly one intersection (see also informal proposition at IfcGrid). If attribute OffsetDistances is omitted, the intersection defines the placement or ref direction of a grid placement directly. If OffsetDistances are given, the intersection is defined by the offset curves to the grid axes.
    aggregate_of< ::Ifc4x3_rc1::IfcGridAxis >::ptr IntersectingAxes() const;
    void setIntersectingAxes(aggregate_of< ::Ifc4x3_rc1::IfcGridAxis >::ptr v);
    /// Offset distances to the grid axes. If given, it defines virtual offset curves to the grid axes. The intersection of the offset curves specify the virtual grid intersection.
    std::vector< double > /*[2:3]*/ OffsetDistances() const;
    void setOffsetDistances(std::vector< double > /*[2:3]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVirtualGridIntersection (IfcEntityInstanceData&& e);
    IfcVirtualGridIntersection (aggregate_of< ::Ifc4x3_rc1::IfcGridAxis >::ptr v1_IntersectingAxes, std::vector< double > /*[2:3]*/ v2_OffsetDistances);
    typedef aggregate_of< IfcVirtualGridIntersection > list;
};
/// IfcWorkTime defines time periods that are used by IfcWorkCalendar for either describing working times or non-working exception times. Besides start and finish dates, a set of time periods can be given by various types of recurrence patterns.
/// 
/// HISTORY: New entity in IFC2x4.
/// 
/// Use definitions
/// A work time should have a meaningful name that describes the time periods (for example, working week, holiday name). Non-recurring time periods should have a start date (IfcWorkTime.Start) and a finish date (IfcWorkTime.Finish). In that case it is assumed that the time period begins at 0:00 on the start date and ends at 24:00 on the finish date.
/// 
/// The start and finish date is optional if a recurrence pattern is given (IfcWorkTime.RecurrencePattern).  They then restrict never-ending recurrence patterns.
class IFC_PARSE_API IfcWorkTime : public  IfcSchedulingTime {
public:
    /// Recurrence pattern that defines a time period, which, if given, is
    ///   valid within the time period defined by
    ///   IfcWorkTime.Start and IfcWorkTime.Finish.
    ::Ifc4x3_rc1::IfcRecurrencePattern* RecurrencePattern() const;
    void setRecurrencePattern(::Ifc4x3_rc1::IfcRecurrencePattern* v);
    /// Start date of the work time (0:00), that might be further
    ///   restricted by a recurrence pattern.
    boost::optional< std::string > Start() const;
    void setStart(boost::optional< std::string > v);
    /// End date of the work time (24:00), that might be further
    ///   restricted by a recurrence pattern.
    boost::optional< std::string > Finish() const;
    void setFinish(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcWorkTime (IfcEntityInstanceData&& e);
    IfcWorkTime (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin, ::Ifc4x3_rc1::IfcRecurrencePattern* v4_RecurrencePattern, boost::optional< std::string > v5_Start, boost::optional< std::string > v6_Finish);
    typedef aggregate_of< IfcWorkTime > list;
};
/// An IfcApprovalRelationship associates approvals (one
/// relating approval and one or more related approvals), each having different status or level as the approval process or the approved
/// objects evolve.
/// 
/// HISTORY: New entity in Release IFC2x2.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, order of attributes changed.
class IFC_PARSE_API IfcApprovalRelationship : public  IfcResourceLevelRelationship {
public:
    /// The approval that other approval is related to.
    ::Ifc4x3_rc1::IfcApproval* RelatingApproval() const;
    void setRelatingApproval(::Ifc4x3_rc1::IfcApproval* v);
    /// The approvals that are related to another (relating) approval.IFC2x Edition 4 CHANGE The cardinality of this attribute has been changed to SET.
    aggregate_of< ::Ifc4x3_rc1::IfcApproval >::ptr RelatedApprovals() const;
    void setRelatedApprovals(aggregate_of< ::Ifc4x3_rc1::IfcApproval >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApprovalRelationship (IfcEntityInstanceData&& e);
    IfcApprovalRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcApproval* v3_RelatingApproval, aggregate_of< ::Ifc4x3_rc1::IfcApproval >::ptr v4_RelatedApprovals);
    typedef aggregate_of< IfcApprovalRelationship > list;
};
/// The closed profile IfcArbitraryClosedProfileDef defines an arbitrary two-dimensional profile for the use within the swept surface geometry, the swept area solid or a sectioned spine. It is given by an outer boundary from which the surface or solid can be constructed. 
/// 
/// HISTORY: New entity in IFC 1.5. Entity has been renamed from IfcArbitraryProfileDef in IFC Release 2x.
/// 
/// Informal proposition: 
/// 
/// The OuterCurve has to be a closed curve.
///   The OuterCurve shall not intersect.
/// 
/// Figure 307 illustrates the arbitrary closed profile definition. The OuterCurve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either:
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The OuterCurve
/// attribute defines a two dimensional closed bounded curve.
/// 
/// Figure 307 — Arbitrary closed profile
class IFC_PARSE_API IfcArbitraryClosedProfileDef : public  IfcProfileDef {
public:
    /// Bounded curve, defining the outer boundaries of the arbitrary profile.
    ::Ifc4x3_rc1::IfcCurve* OuterCurve() const;
    void setOuterCurve(::Ifc4x3_rc1::IfcCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryClosedProfileDef (IfcEntityInstanceData&& e);
    IfcArbitraryClosedProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc4x3_rc1::IfcCurve* v3_OuterCurve);
    typedef aggregate_of< IfcArbitraryClosedProfileDef > list;
};
/// The open profile IfcArbitraryOpenProfileDef defines an arbitrary two-dimensional open profile for the use within the swept surface geometry. It is given by an open boundary from with the surface can be constructed. 
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Informal proposition:
/// 
/// The Curve has to be an open curve.
/// 
/// Figure 308 illustrates the arbitrary open profile definition. The Curve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface that uses the profile definition. It is the xy plane of: 
/// 
/// IfcSweptSurface.Position
/// 
/// The Curve attribute defines a two dimensional open bounded curve.
/// 
/// Figure 308 — Arbitrary open profile
class IFC_PARSE_API IfcArbitraryOpenProfileDef : public  IfcProfileDef {
public:
    /// Open bounded curve defining the profile.
    ::Ifc4x3_rc1::IfcBoundedCurve* Curve() const;
    void setCurve(::Ifc4x3_rc1::IfcBoundedCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryOpenProfileDef (IfcEntityInstanceData&& e);
    IfcArbitraryOpenProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc4x3_rc1::IfcBoundedCurve* v3_Curve);
    typedef aggregate_of< IfcArbitraryOpenProfileDef > list;
};
/// The IfcArbitraryProfileDefWithVoids defines an arbitrary closed two-dimensional profile with holes defined for the use for the swept area solid or a sectioned spine. It is given by an outer boundary and inner boundaries from with the solid the can be constructed.
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Informal propositions:
/// 
/// The outer curve and all inner curves shall be closed curves.
///   The outer curve shall enclose all inner curves.
///   No inner curve shall intersect with the outer curve or any other inner curve.
///   No inner curve may enclose another inner curve.
/// 
/// Figure 309 illustrates the arbitrary closed profile definition with voids. The OuterCurve, defined at the supertype IfcArbitraryClosedProfileDef
/// and the inner curves are defined in the same underlying coordinate system. The common underlying coordinate system is defined by the swept area solid that uses the profile definition. It is the xy plane of:
/// 
/// IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions.  The OuterCurve attribute defines a two dimensional closed bounded curve, the InnerCurves define a set of two dimensional closed bounded curves.
/// 
/// Figure 309 — Arbitrary profile with voids
class IFC_PARSE_API IfcArbitraryProfileDefWithVoids : public  IfcArbitraryClosedProfileDef {
public:
    /// Set of bounded curves, defining the inner boundaries of the arbitrary profile.
    aggregate_of< ::Ifc4x3_rc1::IfcCurve >::ptr InnerCurves() const;
    void setInnerCurves(aggregate_of< ::Ifc4x3_rc1::IfcCurve >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryProfileDefWithVoids (IfcEntityInstanceData&& e);
    IfcArbitraryProfileDefWithVoids (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc4x3_rc1::IfcCurve* v3_OuterCurve, aggregate_of< ::Ifc4x3_rc1::IfcCurve >::ptr v4_InnerCurves);
    typedef aggregate_of< IfcArbitraryProfileDefWithVoids > list;
};
/// An IfcBlobTexture provides a 2-dimensional distribution of the lighting parameters of a surface onto which it is mapped. The texture itself is given as a single binary blob, representing the content of a pixel format file. The file format of the pixel file is given by the RasterFormat attribute and allowable formats are guided by where rule SupportedRasterFormat.
/// 
/// NOTE  Toolbox specific implementations of the binary datatype may restrict the maximum length of the binary blob to capture the raster file content.
/// 
/// For interpretation of the texture nodes see IfcImageTexture definition.
/// 
/// HISTORY  New class in IFC2x3.
/// 
/// IFC2x4 CHANGE  Data type of RasterCode has been corrected to BINARY.
class IFC_PARSE_API IfcBlobTexture : public  IfcSurfaceTexture {
public:
    /// The format of the RasterCode often using a compression.
    std::string RasterFormat() const;
    void setRasterFormat(std::string v);
    /// Blob, given as a single binary, to capture the texture within one popular file (compression) format. The file format is provided by the RasterFormat attribute.
    boost::dynamic_bitset<> RasterCode() const;
    void setRasterCode(boost::dynamic_bitset<> v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBlobTexture (IfcEntityInstanceData&& e);
    IfcBlobTexture (bool v1_RepeatS, bool v2_RepeatT, boost::optional< std::string > v3_Mode, ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v4_TextureTransform, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_Parameter, std::string v6_RasterFormat, boost::dynamic_bitset<> v7_RasterCode);
    typedef aggregate_of< IfcBlobTexture > list;
};
/// The profile IfcCenterLineProfileDef defines an arbitrary two-dimensional open, not self intersecting profile for the use within the swept solid geometry. It is given by an area defined by applying a constant thickness to a centerline, generating an area from which the solid can be constructed.
/// 
/// Among else, IfcCenterLineProfileDef is used to model cold-formed
/// steel or aluminium sections (Sigma, Zeta, Omega, and similar sections
/// which are not covered by subtypes of IfcParameterizedProfileDef).
/// However, since IfcCenterLineProfileDef does not provide shape parameters
/// except for the thickness, there is generally a need to further specify the
/// profile definition by means of
/// 
/// the name,
///   external reference to a document or library,
///   profile properties,
/// 
/// or a combination of them.  See IfcProfileDef for guidance on external references for profiles.
/// 
/// HISTORY  New entity in IFC2x3.
/// 
/// Informal proposition: 
/// 
/// The Curve has to be an open curve.
///   The Curve has to be a non-intersecting curve.
/// 
/// Figure 311 illustrates the center line profile definition. The Curve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface that uses the profile  definition. It is the xy plane of: 
/// 
/// IfcSweptSurface.Position
/// 
/// The Curve attribute defines a two dimensional open bounded curve. The Thickness attribute defines a constant thickness along the curve.
/// 
/// Figure 311 — Centerline profile
class IFC_PARSE_API IfcCenterLineProfileDef : public  IfcArbitraryOpenProfileDef {
public:
    /// Constant thickness applied along the center line.
    double Thickness() const;
    void setThickness(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCenterLineProfileDef (IfcEntityInstanceData&& e);
    IfcCenterLineProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc4x3_rc1::IfcBoundedCurve* v3_Curve, double v4_Thickness);
    typedef aggregate_of< IfcCenterLineProfileDef > list;
};
/// An IfcClassification is used for the arrangement of objects into a class or category according to a common purpose or their possession of common
/// characteristics. A classification in the sense of IfcClassification is taxonomy, or taxonomic scheme, arranged in a hierarchical structure. A category of objects relates to other categories in a generalization-specialization relationship. Therefore the classification items in an
/// classification are organized in a tree structure.
/// 
/// HISTORY New class in IFC Release 1.5. Modified in IFC 2x.
/// 
/// IFC 2x4 CHANGE Attribute Edition made optional. Attributes: PublicationLocation, Description and ReferenceTokens added. Inverse attribute HasClassificationReferences added.
/// 
/// Classification use definitions
/// IfcClassification identifies the classification system or source from which a classification notation is derived. Each classification reference or classification item, belonging to a single classification system, shall reference a single instance of IfcClassification. Therefore, each particular classification system or source used should have only one IfcClassification instance. However, because multiple classification is allowed, there may be many IfcClassification objects used, each identifying a different classification system or source.
/// 
/// A classification system declared may be either formally published (such as Omniclass, Uniclass, Masterformat, or DIN) or it may be a locally defined method of classifiying information.  There are two methods to define a classification system within an IFC dataset:
/// 
/// Including the classification system structure within the dataset: Here a hierarchical tree of IfcClassificationItem's is included that defines the classification system including the relationship between the classification items. An IfcClassificationNotation is used to classify an object.
/// Referencing the classification system by a classification key or id: Here the IfcClassificationReference is used to assign a classification id or key to each classified object.
class IFC_PARSE_API IfcClassification : public  IfcExternalInformation, public  IfcClassificationReferenceSelect, public  IfcClassificationSelect {
public:
    /// Source (or publisher) for this classification.
    /// 
    /// NOTE that the source of the classification means the person or organization that was the original author or the person or organization currently acting as the publisher.
    boost::optional< std::string > Source() const;
    void setSource(boost::optional< std::string > v);
    /// The edition or version of the classification system from which the classification notation is derived.
    /// 
    /// NOTE the version labeling system is specific to the classification system. 
    /// 
    /// IFC2x4 CHANGE The attribute has been changed to be optional.
    boost::optional< std::string > Edition() const;
    void setEdition(boost::optional< std::string > v);
    /// The date on which the edition of the classification used became valid.
    /// 
    /// NOTE The indication of edition may be sufficient to identify the classification source uniquely but the edition date is provided as an optional attribute to enable more precise identification where required.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    boost::optional< std::string > EditionDate() const;
    void setEditionDate(boost::optional< std::string > v);
    /// The name or label by which the classification used is normally known.
    /// 
    /// NOTE Examples of names include CI/SfB, Masterformat, BSAB, Uniclass, STABU, DIN276, DIN277 etc.
    std::string Name() const;
    void setName(std::string v);
    /// Additional description provided for the classification.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Resource identifier or locator, provided as URI, URN or URL, of the classification.  
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Location() const;
    void setLocation(boost::optional< std::string > v);
    /// The delimiter tokens that are used to mark the boundaries of individual facets (substrings) in a classification reference.
    /// 
    /// This typically applies then the IfcClassification is used in
    /// conjuction with IfcClassificationReference's. If only one ReferenceToken is provided, it applies to all boundaries of individual facets, if more than one ReferenceToken are provided, the first token applies to the first boundary, the second token to the second boundary, and the nth token to the nth and any additional boundary. 
    /// 
    /// NOTE  Tokens are typically recommended within the classification itself and each token will have a particular role.
    /// 
    /// EXAMPLE 1  To indicate that the facet delimiter used for DIN277-2 reference key "2.1" ("Office rooms") is ".", a single ReferenceToken ['.'] is provided. To indicate that the facet delimiter used for Omniclass Table 13 (space by function) reference key "13-15 11 34 11" ("Office") are "-" and " ", two ReferenceToken's ['-', ' '] are provided. 
    /// 
    /// EXAMPLE 2  The use of ReferenceTokens can also be extended to include masks. The use need to be agreed in view definitions or implementer agreements that stipulates a "mask syntax" that should be used.  
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::vector< std::string > /*[1:?]*/ > ReferenceTokens() const;
    void setReferenceTokens(boost::optional< std::vector< std::string > /*[1:?]*/ > v);
        aggregate_of< IfcRelAssociatesClassification >::ptr ClassificationForObjects() const; // INVERSE IfcRelAssociatesClassification::RelatingClassification
    aggregate_of< IfcClassificationReference >::ptr HasReferences() const; // INVERSE IfcClassificationReference::ReferencedSource
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassification (IfcEntityInstanceData&& e);
    IfcClassification (boost::optional< std::string > v1_Source, boost::optional< std::string > v2_Edition, boost::optional< std::string > v3_EditionDate, std::string v4_Name, boost::optional< std::string > v5_Description, boost::optional< std::string > v6_Location, boost::optional< std::vector< std::string > /*[1:?]*/ > v7_ReferenceTokens);
    typedef aggregate_of< IfcClassification > list;
};
/// An IfcClassificationReference is a reference into a classification system or source (see IfcClassification) for a specific classification key (or notation).
/// 
/// The inherited attributes have the following meaning:
/// 
/// Identification: holds the key provided for a specific references to classification items (or tables).
/// Name: allows for a human interpretable designation of a classification notation.
/// Location: optionally holds a direct URI link into the classification system (or source) to hyperlink the classification key.
/// 
/// The IfcClassificationReference can either be assigned directly to the IfcClassification, such as if no classification hierarchy has to be included, or it references the parent classification notation, if the fully classification hierarchy is included in the data set. The attribute ReferencedSource then holds the following information (choice by IfcClassificationReferenceSelect):
/// 
/// being of type IfcClassification: direct reference to the classification system (with meta information provided), used for highest level of classification notations, or if the classification notation hierarchy is not relevant,
/// being of type IfcClassificationReference: reference to the parent classification notation within the classification hierarchy.
/// 
/// HISTORY New entity in IFC 2x.
/// 
/// IFC2x4 CHANGE The attribute Description and inverse attribute HasReferences are added.  The attribute Identification has been renamed from ItemReference.
/// 
/// Use definitions
/// The IfcClassificationReference can be used to only assign classification keys to objects, or to hold a fully classification hierarchy. The first is refered to as "lightweight classification", and the second as "full classification"
/// 
/// The IfcClassificationReference can be used as a form of 'lightweight' classification through the 'Identification' attribute inherited from the abstract IfcExternalReference class. In this case, the 'Identification' could take (for instance) the Uniclass notation "L6814" which, if the classification was well understood by all parties and was known to be taken from a particular classification source, would be sufficient. The Name attribute could be the title "Tanking". This would remove the need for the overhead of the more complete classification structure of the model.
class IFC_PARSE_API IfcClassificationReference : public  IfcExternalReference, public  IfcClassificationReferenceSelect, public  IfcClassificationSelect {
public:
    /// The classification system or source that is referenced.
    ::Ifc4x3_rc1::IfcClassificationReferenceSelect* ReferencedSource() const;
    void setReferencedSource(::Ifc4x3_rc1::IfcClassificationReferenceSelect* v);
    /// Description of the classification reference for informational purposes.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    boost::optional< std::string > Sort() const;
    void setSort(boost::optional< std::string > v);
        aggregate_of< IfcRelAssociatesClassification >::ptr ClassificationRefForObjects() const; // INVERSE IfcRelAssociatesClassification::RelatingClassification
    aggregate_of< IfcClassificationReference >::ptr HasReferences() const; // INVERSE IfcClassificationReference::ReferencedSource
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationReference (IfcEntityInstanceData&& e);
    IfcClassificationReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name, ::Ifc4x3_rc1::IfcClassificationReferenceSelect* v4_ReferencedSource, boost::optional< std::string > v5_Description, boost::optional< std::string > v6_Sort);
    typedef aggregate_of< IfcClassificationReference > list;
};

class IFC_PARSE_API IfcColourRgbList : public  IfcPresentationItem {
public:
    std::vector< std::vector< double > > ColourList() const;
    void setColourList(std::vector< std::vector< double > > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcColourRgbList (IfcEntityInstanceData&& e);
    IfcColourRgbList (std::vector< std::vector< double > > v1_ColourList);
    typedef aggregate_of< IfcColourRgbList > list;
};
/// Definition from ISO/CD 10303-46:1992: The colour specification entity contains a direct colour definition. Colour component values refer directly to a specific colour space.
/// 
/// NOTE  Corresponding ISO 10303 name: colour_specification. It has been made into an abstract entity in IFC. Please refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcColourSpecification : public  IfcPresentationItem, public  IfcColour, public  IfcFillStyleSelect {
public:
    /// Optional name given to a particular colour specification in addition to the colour components (like the RGB values).
    /// 
    /// NOTE  Examples are the names of a industry colour classification, such as RAL.
    /// IFC2x Edition 3 CHANGE  Attribute added.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcColourSpecification (IfcEntityInstanceData&& e);
    IfcColourSpecification (boost::optional< std::string > v1_Name);
    typedef aggregate_of< IfcColourSpecification > list;
};
/// The IfcCompositeProfileDef
/// defines the profile by composition of other profiles. The composition
/// is given by a set of at least two other profile definitions. Any
/// profile definition (except for another composite profile) can be used
/// to construct the composite. 
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Figure 314 illustrates the composite profile definition. The IfcCompositeProfileDef does not define an own position coordinate system, it is directly defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either:
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// Or in case of sectioned spines it is the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The IfcCompositeProfileDef is defined using other profile definitions. Those other profile definitions are directly inserted into the underlying coordinate system.
/// 
/// In case of parameterized profile definitions, the Position attribute of those standard profiles is used to place the profiles relatively to each other.
///   In case of arbitrary profile definitions, each Cartesian coordinate is given directly within the underlying coordinate system.
/// 
/// NOTE  The black coordinate axes show the underlying coordinate system of the swept surface or swept area solid.
/// 
/// Figure 314
/// 
/// Twin profiles special case
/// 
/// If twin profiles are modeled by profile composition, the base profile should
/// only be specified once. It is then included into the composite profile directly
/// and additionally indirectly via IfcMirroredProfileDef. For example, a
/// double angle made of two L100x10 with 10mm air gap between them, i.e. a
/// _| |_ shape, can be modeled as
/// 
/// single_L : IfcLShapeProfileDef := IfcLShapeProfileDef(AREA, 'L100X100X10',
///     IfcAxis2Placement2D(IfcCartesianPoint(((.100+.010)/2., .0)), ?),
///     .100, .100, .010, .012, ?, 0., ?, ?);
///  
/// double_L : IfcCompositeProfileDef := IfcCompositeProfileDef(AREA, 'double angle',
///     (single_L, IfcMirroredProfileDef(AREA, ?, single_L, ?)), 'twin profile');
class IFC_PARSE_API IfcCompositeProfileDef : public  IfcProfileDef {
public:
    /// The profiles which are used to define the composite profile.
    aggregate_of< ::Ifc4x3_rc1::IfcProfileDef >::ptr Profiles() const;
    void setProfiles(aggregate_of< ::Ifc4x3_rc1::IfcProfileDef >::ptr v);
    /// The name by which the composition may be referred to. The actual meaning of the name has to be defined in the context of applications.
    boost::optional< std::string > Label() const;
    void setLabel(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCompositeProfileDef (IfcEntityInstanceData&& e);
    IfcCompositeProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, aggregate_of< ::Ifc4x3_rc1::IfcProfileDef >::ptr v3_Profiles, boost::optional< std::string > v4_Label);
    typedef aggregate_of< IfcCompositeProfileDef > list;
};
/// Definition from ISO/CD 10303-42:1992: A connected_face_set is a set of faces such that the domain of faces together with their bounding edges and vertices is connected.  
/// 
/// NOTE  Corresponding ISO 10303 entity: connected_face_set, the subtype closed_shell is included as IfcClosedShell and the subtype open_shell is included as IfcOpenShell. Please refer to ISO/IS 10303-42:1994, p. 144 for the final definition of the formal standard.
/// 
/// HISTORY  New class in IFC Release 1.0
/// 
/// Informal proposition: 
/// 
/// The union of the domains of the faces and their bounding loops shall be arcwise connected.
class IFC_PARSE_API IfcConnectedFaceSet : public  IfcTopologicalRepresentationItem {
public:
    /// The set of faces arcwise connected along common edges or vertices.
    aggregate_of< ::Ifc4x3_rc1::IfcFace >::ptr CfsFaces() const;
    void setCfsFaces(aggregate_of< ::Ifc4x3_rc1::IfcFace >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectedFaceSet (IfcEntityInstanceData&& e);
    IfcConnectedFaceSet (aggregate_of< ::Ifc4x3_rc1::IfcFace >::ptr v1_CfsFaces);
    typedef aggregate_of< IfcConnectedFaceSet > list;
};
/// IfcConnectionCurveGeometry is used to describe the geometric constraints that facilitate the physical connection of two objects at a curve or at an edge with curve geometry associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// EXAMPLE  The connection relationship between two walls has a geometric constraint which describes the end caps (or cut-off of the wall ends) by a CurveOnRelatingElement for the first wall and a CurveOnRelatedElement for the second wall. The exact usage of the IfcConnectionCurveGeometry is further defined in the geometry use sections of the elements that use it.
/// 
/// The available geometry for the connection constraint may be further restricted to only allow straight segments by applying IfcPolyline
/// only. Such an usage constraint is provided at the object definition of the IfcElement subtype, utilizing the element connection by referring to the subtype of IfcRelConnects with the associated IfcConnectionCurveGeometry.
/// 
/// HISTORY  New entity in IFC Release 1.5, has been renamed from IfcLineConnectionGeometry in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcEdgeCurve, is enabled by using the IfcCurveOrEdgeCurve.
/// 
/// Geometry use definitions
/// The IfcCurve (or the IfcEdgeCurve with an associated IfcCurve) at the CurveOnRelatingElement attribute defines the curve where the basic geometry items of the connected elements connects. The curve geometry and coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnects Subtype that utilizes the IfcConnectionCurveGeometry. Optionally, the same curve geometry and coordinates can also be provided within the local coordinate system of the RelatedElement by using the CurveOnRelatedElement attribute.
class IFC_PARSE_API IfcConnectionCurveGeometry : public  IfcConnectionGeometry {
public:
    /// The bounded curve at which the connected objects are aligned at the relating element, given in the LCS of the relating element.
    ::Ifc4x3_rc1::IfcCurveOrEdgeCurve* CurveOnRelatingElement() const;
    void setCurveOnRelatingElement(::Ifc4x3_rc1::IfcCurveOrEdgeCurve* v);
    /// The bounded curve at which the connected objects are aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc4x3_rc1::IfcCurveOrEdgeCurve* CurveOnRelatedElement() const;
    void setCurveOnRelatedElement(::Ifc4x3_rc1::IfcCurveOrEdgeCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionCurveGeometry (IfcEntityInstanceData&& e);
    IfcConnectionCurveGeometry (::Ifc4x3_rc1::IfcCurveOrEdgeCurve* v1_CurveOnRelatingElement, ::Ifc4x3_rc1::IfcCurveOrEdgeCurve* v2_CurveOnRelatedElement);
    typedef aggregate_of< IfcConnectionCurveGeometry > list;
};
/// IfcConnectionPointEccentricity is used to describe the geometric constraints that facilitate the physical connection of two objects at a point or vertex point with associated point coordinates. There is a physical distance, or eccentricity, etween the connection points of both object. The eccentricity can be either given by:
/// 
/// providing the PointOnRelatingElement and the PointOnRelatedElement, where bothpoint coordinates are not identical within a common parent coordinate system (latestly within the world coordinate system),
/// providing the PointOnRelatingElement and the three distance measures, EccentricityInX, EccentricityInY, and EccentricityInZ (or only EccentricityInX, and EccentricityInY if the
/// underlying coordinate system is two-dimensional), or
/// providing both.
/// 
/// NOTE If both, PointOnRelatedElement, and EccentricityInX, EccentricityInY, (EccentricityInZ) are provided, the values should be consistent. In case of any non-consistency, the calculated distance between PointOnRelatingElement and PointOnRelatedElement takes precedence.
/// 
/// The explicit values for EccentricityInX, EccentricityInY, and EccentricityInZ are always
/// measured in the following direction and coordinate system (defining when the value is positive or negative):
/// 
/// from the PointOnRelatedElement to PointOnRelatingElement within the coordinate system of the RelatingElement.
/// in addition: when used to specify connections in structural analysis models, the IfcStructuralMember is to be used as the RelatingElement of the relationship object utilizing IfcConnectionPointEccentricity, and the IfcStructuralConnection is the RelatedElement.
/// 
/// HISTORY New entity in IFC 2x Edition 3.
/// 
/// Geometry use definitions
/// The IfcPoint (or the IfcVertexPoint with an associated IfcPoint) at the PointOnRelatingElement attribute defines the point where the basic geometry items of the connected elements connects. The point coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnects subtype that utilizes the IfcConnectionPointGeometry. Optionally, the same point coordinates can also be provided within the local coordinate system of the RelatedElement by using the PointOnRelatedElement attribute, otherwise the distance to the point at the RelatedElement has to be given by the three eccentricity values.
class IFC_PARSE_API IfcConnectionPointEccentricity : public  IfcConnectionPointGeometry {
public:
    /// Distance in x direction between the two points (or vertex points) engaged in the point connection.
    boost::optional< double > EccentricityInX() const;
    void setEccentricityInX(boost::optional< double > v);
    /// Distance in y direction between the two points (or vertex points) engaged in the point connection.
    boost::optional< double > EccentricityInY() const;
    void setEccentricityInY(boost::optional< double > v);
    /// Distance in z direction between the two points (or vertex points) engaged in the point connection.
    boost::optional< double > EccentricityInZ() const;
    void setEccentricityInZ(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionPointEccentricity (IfcEntityInstanceData&& e);
    IfcConnectionPointEccentricity (::Ifc4x3_rc1::IfcPointOrVertexPoint* v1_PointOnRelatingElement, ::Ifc4x3_rc1::IfcPointOrVertexPoint* v2_PointOnRelatedElement, boost::optional< double > v3_EccentricityInX, boost::optional< double > v4_EccentricityInY, boost::optional< double > v5_EccentricityInZ);
    typedef aggregate_of< IfcConnectionPointEccentricity > list;
};
/// Definition from ISO/CD 10303-41:1992: A context dependent unit is a unit which is not related to the SI system.
/// 
/// NOTE The number of parts in an assembly is a physical quantity measured in units that may be called "parts" but which cannot be related to an SI unit.
/// 
/// NOTE Corresponding ISO 10303 name: context_dependent_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcContextDependentUnit : public  IfcNamedUnit, public  IfcResourceObjectSelect {
public:
    /// The word, or group of words, by which the context dependent unit is referred to.
    std::string Name() const;
    void setName(std::string v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcContextDependentUnit (IfcEntityInstanceData&& e);
    IfcContextDependentUnit (::Ifc4x3_rc1::IfcDimensionalExponents* v1_Dimensions, ::Ifc4x3_rc1::IfcUnitEnum::Value v2_UnitType, std::string v3_Name);
    typedef aggregate_of< IfcContextDependentUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A conversion based unit is a unit that is defined based on a measure with unit.
/// 
/// NOTE Corresponding ISO 10303 name: conversion_based_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// 
/// IFC 2x3 change: standard names of typical units added.
/// 
/// IFC 2x4 change: further names added: square inch, square foot, square mile, square yard, cubic inch, cubic foot, cubic yard, fluid ounce UK/US, ton UK/US, degree.
/// 
/// Example: An inch is a converted unit. It is from the Imperial system, its name is "inch" and it can be related to the si unit, millimetre, through a measure with unit whose value is 25.4 millimetre. A foot is also a converted unit. It is from the Imperial system, its name is "foot" and it can be related to an IfcSIUnit, millimetre, either directly or through the unit called "inch". Note that several US customary units differ from Imperial units (nonmetric English units) of the same name.
/// 
/// To identify some commonly used conversion based units, the standard designations (case insensitive) for the Name attribute include the following:
/// 
/// Name	Description
///   'inch'		Length measure equal to 25.4 mm
///   'foot'		Length measure equal to 304.8 mm
///   'yard'		Length measure equal to 914 mm
///   'mile'		Length measure equal to 1609 m
///   'square inch'	Area measure equal to 0.0006452 square meters
///   'square foot'	Area measure equal to 0.09290 square meters
///   'square yard'	Area measure equal to 0.83612736 square meters
///   'acre'		Area measure equal to 4046.86 square meters
///   'square mile'	Area measure equal to 2 588 881 square meters
///   'cubic inch'	Volume measure equal to 0.00001639 cubic meters
///   'cubic foot'	Volume measure equal to 0.02832 cubic meters
///   'cubic yard'	Volume measure equal to 0.7636 cubic meters
///   'litre'		Volume measure equal to 0.001 cubic meters
///   'fluid ounce UK'	Volume measure equal to 0.0000284130625 cubic meters
///   'fluid ounce US'	Volume measure equal to 0.00002957353 cubic meters
///   'pint UK'		Volume measure equal to 0.000568 cubic meters
///   'pint US'		Volume measure equal to 0.000473 cubic meters
///   'gallon UK'	Volume measure equal to 0.004546 cubic meters
///   'gallon US'	Volume measure equal to 0.003785 cubic meters
///   'degree'		Angle measure equal to π/180 rad
///   'ounce'		Mass measure equal to 28.35 g
///   'pound'		Mass measure equal to 0.454 kg
///   'ton UK'		Mass measure equal to 1016.0469088 kg, also known as long ton, gross ton, shipper's ton
///   'ton US'		Mass measure equal to 907.18474 kg, also known as short ton, net ton
///   'lbf'		Force measure equal to 4.4482216153 N, pound-force
///   'kip'		Force measure equal to 4448.2216153 N, kilopound-force
///   'psi'		Pressure measure equal to 6894.7572932 Pa, pound-force per square inch
///   'ksi'		Pressure measure equal to 6894757.2932 Pa, kilopound-force per square inch
///   'minute'		Time measure equal to 60 s
///   'hour'		Time measure equal to 3600 s
///   'day'		Time measure equal to 86400 s
///   'btu'		Energy measure equal to 1055.056 J, British Thermal Unit
class IFC_PARSE_API IfcConversionBasedUnit : public  IfcNamedUnit, public  IfcResourceObjectSelect {
public:
    /// The word, or group of words, by which the conversion based unit is referred to.
    std::string Name() const;
    void setName(std::string v);
    /// The physical quantity from which the converted unit is derived.
    ::Ifc4x3_rc1::IfcMeasureWithUnit* ConversionFactor() const;
    void setConversionFactor(::Ifc4x3_rc1::IfcMeasureWithUnit* v);
        aggregate_of< IfcExternalReferenceRelationship >::ptr HasExternalReference() const; // INVERSE IfcExternalReferenceRelationship::RelatedResourceObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConversionBasedUnit (IfcEntityInstanceData&& e);
    IfcConversionBasedUnit (::Ifc4x3_rc1::IfcDimensionalExponents* v1_Dimensions, ::Ifc4x3_rc1::IfcUnitEnum::Value v2_UnitType, std::string v3_Name, ::Ifc4x3_rc1::IfcMeasureWithUnit* v4_ConversionFactor);
    typedef aggregate_of< IfcConversionBasedUnit > list;
};
/// IfcConversionBasedUnitWithOffset is a unit which is converted from another unit by applying a conversion factor and an offset.
/// 
/// HISTORY New entity in IFC 2x4.
/// 
/// Example: The temperature unit Fahrenheit is based on the temperature unit Kelvin as follows:
/// 
/// f = k · 1.8 – 459.67
/// 
/// wherein k is an absolute temperature expressed in Kelvin and f is the same temperature in Fahrenheit.  The following entity instances provide Fahrenheit as a unit:
/// 
/// IfcConversionBasedUnitWithOffset(
///     IfcDimensionalExponents(0, 0, 0, 0, 1, 0, 0),
///     THERMODYNAMICTEMPERATUREUNIT,
///     'Fahrenheit',
///     IfcMeasureWithUnit(
///         IfcThermodynamicTemperatureMeasure(1.8),
///         IfcSiUnit(THERMODYNAMICTEMPERATUREUNIT, ?, KELVIN)),
///     -459.67);
class IFC_PARSE_API IfcConversionBasedUnitWithOffset : public  IfcConversionBasedUnit {
public:
    /// A positive or negative offset to add after the inherited ConversionFactor was applied.
    double ConversionOffset() const;
    void setConversionOffset(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConversionBasedUnitWithOffset (IfcEntityInstanceData&& e);
    IfcConversionBasedUnitWithOffset (::Ifc4x3_rc1::IfcDimensionalExponents* v1_Dimensions, ::Ifc4x3_rc1::IfcUnitEnum::Value v2_UnitType, std::string v3_Name, ::Ifc4x3_rc1::IfcMeasureWithUnit* v4_ConversionFactor, double v5_ConversionOffset);
    typedef aggregate_of< IfcConversionBasedUnitWithOffset > list;
};
/// IfcCurrencyRelationship defines the rate of exchange
/// that applies between two designated currencies at a particular time
/// and as published by a particular source.
/// 
/// HISTORY  New Entity in IFC2x2.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, attribute order changed.
/// 
/// Use definitions
/// An IfcCurrencyRelationship is used where there may be a need to reference an IfcCostValue in one currency to an IfcCostValue in another currency. It takes account of fact that currency exchange rates may vary by requiring the recording the date and time of the currency exchange rate used and the source that publishes the rate. There may be many sources and there are different strategies for currency conversion (spot rate, forward buying of currency at a fixed rate).
/// The source for the currency exchange is defined as an instance of IfcLibraryInformation that includes a name and a URL.
class IFC_PARSE_API IfcCurrencyRelationship : public  IfcResourceLevelRelationship {
public:
    /// The monetary unit from which an exchange is derived. For instance, in the case of a conversion from GBP to USD, the relating monetary unit is GBP.
    ::Ifc4x3_rc1::IfcMonetaryUnit* RelatingMonetaryUnit() const;
    void setRelatingMonetaryUnit(::Ifc4x3_rc1::IfcMonetaryUnit* v);
    /// The monetary unit to which an exchange results. For instance, in the case of a conversion from GBP to USD, the related monetary unit is USD.
    ::Ifc4x3_rc1::IfcMonetaryUnit* RelatedMonetaryUnit() const;
    void setRelatedMonetaryUnit(::Ifc4x3_rc1::IfcMonetaryUnit* v);
    /// The currently agreed ratio of the amount of a related monetary unit that is equivalent to a unit amount of the relating monetary unit in a currency relationship. For instance, in the case of a conversion from GBP to USD, the value of the exchange rate may be 1.486 (USD) : 1 (GBP).
    double ExchangeRate() const;
    void setExchangeRate(double v);
    /// The date and time at which an exchange rate applies.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect. Attribute made optional.
    boost::optional< std::string > RateDateTime() const;
    void setRateDateTime(boost::optional< std::string > v);
    /// The source from which an exchange rate is obtained.
    ::Ifc4x3_rc1::IfcLibraryInformation* RateSource() const;
    void setRateSource(::Ifc4x3_rc1::IfcLibraryInformation* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurrencyRelationship (IfcEntityInstanceData&& e);
    IfcCurrencyRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcMonetaryUnit* v3_RelatingMonetaryUnit, ::Ifc4x3_rc1::IfcMonetaryUnit* v4_RelatedMonetaryUnit, double v5_ExchangeRate, boost::optional< std::string > v6_RateDateTime, ::Ifc4x3_rc1::IfcLibraryInformation* v7_RateSource);
    typedef aggregate_of< IfcCurrencyRelationship > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style specifies the visual appearance of curves.
/// 
/// An IfcCurveStyle provides the style table for presentation information assigned to geometric curves. The style is defined by a color, a font and a width. The IfcCurveStyle defines curve patterns as model patterns, that is, the distance between visible and invisible segments of curve patterns are given in model space dimensions (that have to be scaled using the target plot scale).
/// 
/// Styles are intended to be shared by multiple IfcStyledItem's, assigning the style to occurrences of (subtypes of) IfcGeometricRepresentationItem's. Measures given to a font pattern or a curve width are given in global drawing length units.
/// 
/// NOTE  global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// The measure values for font pattern and curve width apply to the model space with a target plot scale provided for the correct appearance in the default plot scale.. For different scale and projection dependent curve styles a different instance of IfcCurveStyle needs to be used by IfcPresentationStyleAssignment for different IfcGeometricRepresentationSubContext dependent representations.
/// 
/// NOTE  the target plot scale is given by IfcGeometricRepresentationSubContext.TargetScale.
/// 
/// An IfcCurveStyle can be assigned to IfcGeometricRepresentationItem's via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or IfcAnnotationCurveOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: curve_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyle : public  IfcPresentationStyle, public  IfcPresentationStyleSelect {
public:
    /// A curve style font which is used to present a curve. It can either be a predefined curve font, or an explicitly defined curve font. Both may be scaled. If not given, then the curve font should be taken from the layer assignment with style, if that is not given either, then the default curve font applies.
    ::Ifc4x3_rc1::IfcCurveFontOrScaledCurveFontSelect* CurveFont() const;
    void setCurveFont(::Ifc4x3_rc1::IfcCurveFontOrScaledCurveFontSelect* v);
    /// A positive length measure in units of the presentation area for the width of a presented curve. If not given, then the style should be taken from the layer assignment with style, if that is not given either, then the default style applies.
    ::Ifc4x3_rc1::IfcSizeSelect* CurveWidth() const;
    void setCurveWidth(::Ifc4x3_rc1::IfcSizeSelect* v);
    /// The colour of the visible part of the curve. If not given, then the colour should be taken from the layer assignment with style, if that is not given either, then the default colour applies.
    ::Ifc4x3_rc1::IfcColour* CurveColour() const;
    void setCurveColour(::Ifc4x3_rc1::IfcColour* v);
    boost::optional< bool > ModelOrDraughting() const;
    void setModelOrDraughting(boost::optional< bool > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyle (IfcEntityInstanceData&& e);
    IfcCurveStyle (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcCurveFontOrScaledCurveFontSelect* v2_CurveFont, ::Ifc4x3_rc1::IfcSizeSelect* v3_CurveWidth, ::Ifc4x3_rc1::IfcColour* v4_CurveColour, boost::optional< bool > v5_ModelOrDraughting);
    typedef aggregate_of< IfcCurveStyle > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font combines several curve style font pattern entities into a more complex pattern. The resulting pattern is repeated along the curve. 
/// 
/// NOTE: Corresponding ISO 10303 name: curve_style_font. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFont : public  IfcPresentationItem, public  IfcCurveFontOrScaledCurveFontSelect, public  IfcCurveStyleFontSelect {
public:
    /// Name that may be assigned with the curve font.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// A list of curve font pattern entities, that contains the simple patterns used for drawing curves. The patterns are applied in the order they occur in the list.
    aggregate_of< ::Ifc4x3_rc1::IfcCurveStyleFontPattern >::ptr PatternList() const;
    void setPatternList(aggregate_of< ::Ifc4x3_rc1::IfcCurveStyleFontPattern >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFont (IfcEntityInstanceData&& e);
    IfcCurveStyleFont (boost::optional< std::string > v1_Name, aggregate_of< ::Ifc4x3_rc1::IfcCurveStyleFontPattern >::ptr v2_PatternList);
    typedef aggregate_of< IfcCurveStyleFont > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font and scaling is a curve style font and a scalar factor for that font, so that a given curve style font may be applied at various scales.
/// 
/// The IfcCurveStyleFontAndScaling allows for the reuse of the same curve style definition in several sizes. The definition of the CurveFontScale is the scaling of a base curve style pattern to be used as a new or derived curve style pattern.
/// 
/// NOTE  The CurveFontScale should not be mixed up with the target plot scale.
/// 
/// An example for IfcCurveStyleFontAndScaling is the sizing of a basic curve style dash pattern 'dash' (visible 0.01m, invisible 0.005m) into 'dash large' with CurveFontScale = 2 (resulting in visible 0.02m, invisible 0.01m), and into 'dash small' with CurveFontScale = 0.5 (resulting in visible 0.005m, invisible 0.0025m).
/// 
/// NOTE  Corresponding ISO 10303 name: curve_style_font_and_scaling. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFontAndScaling : public  IfcPresentationItem, public  IfcCurveFontOrScaledCurveFontSelect {
public:
    /// Name that may be assigned with the scaling of a curve font.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// The curve font to be scaled.
    ::Ifc4x3_rc1::IfcCurveStyleFontSelect* CurveFont() const;
    void setCurveFont(::Ifc4x3_rc1::IfcCurveStyleFontSelect* v);
    /// The scale factor.
    double CurveFontScaling() const;
    void setCurveFontScaling(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFontAndScaling (IfcEntityInstanceData&& e);
    IfcCurveStyleFontAndScaling (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcCurveStyleFontSelect* v2_CurveFont, double v3_CurveFontScaling);
    typedef aggregate_of< IfcCurveStyleFontAndScaling > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font pattern is a pair of visible and invisible curve segment length measures in presentation area units. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_style_font_pattern. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFontPattern : public  IfcPresentationItem {
public:
    /// The length of the visible segment in the pattern definition.
    /// 
    /// NOTE  For a visible segment representing a point, the value 0. should be assigned.
    /// 
    /// IFC2x Edition 3 CHANGE  The datatype has been changed to IfcLengthMeasure with upward compatibility for file-based exchange.
    double VisibleSegmentLength() const;
    void setVisibleSegmentLength(double v);
    /// The length of the invisible segment in the pattern definition.
    double InvisibleSegmentLength() const;
    void setInvisibleSegmentLength(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFontPattern (IfcEntityInstanceData&& e);
    IfcCurveStyleFontPattern (double v1_VisibleSegmentLength, double v2_InvisibleSegmentLength);
    typedef aggregate_of< IfcCurveStyleFontPattern > list;
};
/// IfcDerivedProfileDef defines the profile by transformation from the parent profile. The transformation is given by a two dimensional transformation operator. Transformation includes translation, rotation, mirror and scaling. The latter can be uniform or non uniform. The derived profiles may be used to define swept surfaces, swept area solids or sectioned spines.
/// 
/// The transformation effects the position, rotation, mirroring or scale of the profile at the underlying coordinate system, i.e. the coordinate system defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either: 
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The position and potential rotation of the ParentProfile within the underlying coordinate system is taken into consideration before applying the Cartesian transformation operator.
/// 
/// Note, if only mirroring is required, IfcMirroredProfileDef should be used instead.
/// 
/// HISTORY: New entity in IFC Release 2x.
/// 
/// Figure 316 illustrates examples of derived profiles.
/// 
/// Parameter
/// The IfcDerivedProfileDef
/// is defined using the IfcCartesianTransformationOperator2D
/// (CTO), which is applied to the parent profile definition. 
/// 
/// Example
/// The example shows an uniform scaling and a transformation
/// of an IfcRectangleProfileDef
/// to match the lower-left cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = NIL (defaults to 1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(,)
///   Scale = 2.
/// 
/// Note: The ParentProfile has a Position
/// = IfcCartesianPoint(,) already.
/// 
/// Parameter
/// The IfcDerivedProfileDef is defined using
/// non uniform transformationsby applying the IfcCartesianTransformationOperator2DnonUniform
/// as a subtype of the 2D CTO.
/// 
/// Example
/// The example shows a non-uniform scaling and a translation of an IfcRectangleProfileDef
/// to match the lower-left cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = NIL (defaults to 1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(0.,<1/2 YDim)
///   Scale  = 1.
///   Scale2 = 2.
/// 
/// Note: The ParentProfile has a Position
/// = IfcCartesianPoint(,) already.
/// 
/// Parameter
/// The IfcDerivedProfileDef
/// is defined using mirroring by applying the IfcCartesianTransformationOperator2D
/// (CTO) to the parent profile.
/// 
/// Example
/// The example shows a mirroring of an IfcLShapeProfileDef
/// to match the centre cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = (-1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(0.,0.)
///   Scale = NIL (defaults to 1.)
/// 
/// Note: The ParentProfile has a Position = IfcCartesianPoint(0.,0.).
/// 
/// This example is for illustration only.
/// If the transformation results only in mirroring like shown in the example, then
/// IfcMirroredProfileDef should be used instead of IfcDerivedProfileDef.
/// 
/// Note: The following color map applies:
/// 
/// black coordinate axes show the
///   underlying coordinate system of the swept surface, swept area solid, or
///   sectioned spine
/// 
/// red coordinate axes
///   show the position coordinate system of the parent profile
/// 
/// brown coordinate axes
///   show the position coordinate system of the derived profile
/// 
/// Figure 316 — Derived profile
class IFC_PARSE_API IfcDerivedProfileDef : public  IfcProfileDef {
public:
    /// The parent profile provides the origin of the transformation.
    ::Ifc4x3_rc1::IfcProfileDef* ParentProfile() const;
    void setParentProfile(::Ifc4x3_rc1::IfcProfileDef* v);
    /// Transformation operator applied to the parent profile.
    ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* Operator() const;
    void setOperator(::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v);
    /// The name by which the transformation may be referred to. The actual meaning of the name has to be defined in the context of applications.
    boost::optional< std::string > Label() const;
    void setLabel(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedProfileDef (IfcEntityInstanceData&& e);
    IfcDerivedProfileDef (::Ifc4x3_rc1::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc4x3_rc1::IfcProfileDef* v3_ParentProfile, ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v4_Operator, boost::optional< std::string > v5_Label);
    typedef aggregate_of< IfcDerivedProfileDef > list;
};
/// IfcDocumentInformation captures "metadata" of an external document. The actual content of the document is not defined in IFC; instead, it can be found following the reference given to IfcDocumentReference. 
/// 
/// HISTORY: New entity in IFC 2x.
class IFC_PARSE_API IfcDocumentInformation : public  IfcExternalInformation, public  IfcDocumentSelect {
public:
    std::string Identification() const;
    void setIdentification(std::string v);
    /// File name or document name assigned by owner.
    std::string Name() const;
    void setName(std::string v);
    /// Description of document and its content.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// Resource identifier or locator, provided as URI, URN or URL, of the document information for online references.
    /// 
    /// IFC2x4 CHANGE  New attribute added at end of attribute list.
    boost::optional< std::string > Location() const;
    void setLocation(boost::optional< std::string > v);
    /// Purpose for this document.
    boost::optional< std::string > Purpose() const;
    void setPurpose(boost::optional< std::string > v);
    /// Intended use for this document.
    boost::optional< std::string > IntendedUse() const;
    void setIntendedUse(boost::optional< std::string > v);
    /// Scope for this document.
    boost::optional< std::string > Scope() const;
    void setScope(boost::optional< std::string > v);
    /// Document revision designation.
    boost::optional< std::string > Revision() const;
    void setRevision(boost::optional< std::string > v);
    /// Information about the person and/or organization acknowledged as the 'owner' of this document. In some contexts, the document owner determines who has access to or editing right to the document.
    ::Ifc4x3_rc1::IfcActorSelect* DocumentOwner() const;
    void setDocumentOwner(::Ifc4x3_rc1::IfcActorSelect* v);
    /// The persons and/or organizations who have created this document or contributed to it.
    boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorSelect >::ptr > Editors() const;
    void setEditors(boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorSelect >::ptr > v);
    /// Date and time stamp when the document was originally created.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDateTime, the date time string according to ISO8601.
    boost::optional< std::string > CreationTime() const;
    void setCreationTime(boost::optional< std::string > v);
    /// Date and time stamp when this document version was created.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDateTime, the date time string according to ISO8601.
    boost::optional< std::string > LastRevisionTime() const;
    void setLastRevisionTime(boost::optional< std::string > v);
    /// Describes the electronic format of the document being referenced, providing the file extension and the manner in which the content is provided.
    boost::optional< std::string > ElectronicFormat() const;
    void setElectronicFormat(boost::optional< std::string > v);
    /// Date when the document becomes valid.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    boost::optional< std::string > ValidFrom() const;
    void setValidFrom(boost::optional< std::string > v);
    /// Date until which the document remains valid.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    boost::optional< std::string > ValidUntil() const;
    void setValidUntil(boost::optional< std::string > v);
    /// The level of confidentiality of the document.
    boost::optional< ::Ifc4x3_rc1::IfcDocumentConfidentialityEnum::Value > Confidentiality() const;
    void setConfidentiality(boost::optional< ::Ifc4x3_rc1::IfcDocumentConfidentialityEnum::Value > v);
    /// The current status of the document. Examples of status values that might be used for a document information status include:
    /// - DRAFT
    /// - FINAL DRAFT
    /// - FINAL
    /// - REVISION
    boost::optional< ::Ifc4x3_rc1::IfcDocumentStatusEnum::Value > Status() const;
    void setStatus(boost::optional< ::Ifc4x3_rc1::IfcDocumentStatusEnum::Value > v);
        aggregate_of< IfcRelAssociatesDocument >::ptr DocumentInfoForObjects() const; // INVERSE IfcRelAssociatesDocument::RelatingDocument
    aggregate_of< IfcDocumentReference >::ptr HasDocumentReferences() const; // INVERSE IfcDocumentReference::ReferencedDocument
    aggregate_of< IfcDocumentInformationRelationship >::ptr IsPointedTo() const; // INVERSE IfcDocumentInformationRelationship::RelatedDocuments
    aggregate_of< IfcDocumentInformationRelationship >::ptr IsPointer() const; // INVERSE IfcDocumentInformationRelationship::RelatingDocument
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentInformation (IfcEntityInstanceData&& e);
    IfcDocumentInformation (std::string v1_Identification, std::string v2_Name, boost::optional< std::string > v3_Description, boost::optional< std::string > v4_Location, boost::optional< std::string > v5_Purpose, boost::optional< std::string > v6_IntendedUse, boost::optional< std::string > v7_Scope, boost::optional< std::string > v8_Revision, ::Ifc4x3_rc1::IfcActorSelect* v9_DocumentOwner, boost::optional< aggregate_of< ::Ifc4x3_rc1::IfcActorSelect >::ptr > v10_Editors, boost::optional< std::string > v11_CreationTime, boost::optional< std::string > v12_LastRevisionTime, boost::optional< std::string > v13_ElectronicFormat, boost::optional< std::string > v14_ValidFrom, boost::optional< std::string > v15_ValidUntil, boost::optional< ::Ifc4x3_rc1::IfcDocumentConfidentialityEnum::Value > v16_Confidentiality, boost::optional< ::Ifc4x3_rc1::IfcDocumentStatusEnum::Value > v17_Status);
    typedef aggregate_of< IfcDocumentInformation > list;
};
/// An IfcDocumentInformationRelationship is a relationship class that enables a document to have the ability to reference other documents.
/// 
/// HISTORY  New entity in Release IFC2x.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, order of attributes changed.
/// 
/// Use definitions
/// This class can be used to describe relationships in which one document may reference one or more other sub documents or where a document is used as a replacement for another document (but where both the original and the replacing document need to be retained).
class IFC_PARSE_API IfcDocumentInformationRelationship : public  IfcResourceLevelRelationship {
public:
    /// The document that acts as the parent, referencing or original document in a relationship.
    ::Ifc4x3_rc1::IfcDocumentInformation* RelatingDocument() const;
    void setRelatingDocument(::Ifc4x3_rc1::IfcDocumentInformation* v);
    /// The document that acts as the child, referenced or replacing document in a relationship.
    aggregate_of< ::Ifc4x3_rc1::IfcDocumentInformation >::ptr RelatedDocuments() const;
    void setRelatedDocuments(aggregate_of< ::Ifc4x3_rc1::IfcDocumentInformation >::ptr v);
    /// Describes the type of relationship between documents. This could be sub-document, replacement etc. The interpretation has to be established in an application context.
    boost::optional< std::string > RelationshipType() const;
    void setRelationshipType(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentInformationRelationship (IfcEntityInstanceData&& e);
    IfcDocumentInformationRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcDocumentInformation* v3_RelatingDocument, aggregate_of< ::Ifc4x3_rc1::IfcDocumentInformation >::ptr v4_RelatedDocuments, boost::optional< std::string > v5_RelationshipType);
    typedef aggregate_of< IfcDocumentInformationRelationship > list;
};
/// An IfcDocumentReference is a reference 
/// to the location of a document. The reference is given by a system 
/// interpretable Location attribute (a URL string) where the document can be found, and an optional inherited
///   internal reference Identification, which refers to a system
///   interpretable position within the document. The optional inherited
/// Name attribute is meant to have meaning for human readers. Optional 
/// document metadata can also be captured through reference to 
/// IfcDocumentInformation.
/// 
/// HISTORY: New Entity in IFC Release 2.0.
///   Modified in IFC 2x.
class IFC_PARSE_API IfcDocumentReference : public  IfcExternalReference, public  IfcDocumentSelect {
public:
    /// Description of the document reference for informational purposes.
    /// 
    /// IFC2x4 CHANGE  New attribute added at the end of the attribute list.
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    /// The document that is referenced.
    ::Ifc4x3_rc1::IfcDocumentInformation* ReferencedDocument() const;
    void setReferencedDocument(::Ifc4x3_rc1::IfcDocumentInformation* v);
        aggregate_of< IfcRelAssociatesDocument >::ptr DocumentRefForObjects() const; // INVERSE IfcRelAssociatesDocument::RelatingDocument
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentReference (IfcEntityInstanceData&& e);
    IfcDocumentReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_Identification, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, ::Ifc4x3_rc1::IfcDocumentInformation* v5_ReferencedDocument);
    typedef aggregate_of< IfcDocumentReference > list;
};
/// Definition from ISO/CD 10303-42:1992: An edge is the
/// topological construct corresponding to the connection of two
/// vertices. More abstractly, it may stand for a logical
/// relationship between two vertices. The domain of an edge, if
/// present, is a finite, non-self-intersecting open curve in
/// RM, that is, a connected 1-dimensional
/// manifold. The bounds of an edge are two vertices, which need not
/// be distinct. The edge is oriented by choosing its traversal
/// direction to run from the first to the second vertex. If the two
/// vertices are the same, the edge is a self loop. The domain of the
/// edge does not include its bounds, and 0 ≤ Ξ ≤ ∞.
/// Associated with an edge may be a geometric curve to locate the
/// edge in a coordinate space; this is represented by the edge curve
/// (IfcEdgeCurve) subtype. The curve shall be finite and
/// non-self-intersecting within the domain of the edge. An edge is a
/// graph, so its multiplicity M and graph genus Ge
/// may be determined by the graph traversal algorithm. Since
/// M = E = 1, the Euler equation (1) reduces in the
/// case to
/// 
/// where V = 1 or 2, and Ge = 1 or 0.
/// Specifically, the topological edge defining data shall
/// satisfy:
/// 
/// - an edge has two vertices
/// 
/// - the vertices need not be distinct
/// 
/// - Equation (2) shall hold.
/// 
/// The geometry between the two
/// vertices defaults to a straight line if no curve geometry is
/// assigned using the subtype IfcEdgeCurve. The
/// IfcEdge can therefore be used to exchange straight edges
/// without an associated geometry provided by IfcLine or
/// IfcPolyline thought IfcEdgeCurve.EdgeGeometry.
/// 
/// Figure 333 illustrates an example where the bounds of the IfcEdge are given by the EdgeStart and EdgeEnd; this also determines the direction of the edge. The location within a coordinate space is determined by the IfcVertexPoint type for EdgeStart and EdgeEnd. Since no edge geometry is assigned, it defaults to a straight line agreeing to the direction sense.
/// 
/// Figure 333 — Edge representation
/// 
/// NOTE  Corresponding ISO 10303 entity: edge. Please refer to ISO/IS 10303-42:1994, p. 130 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// Informal propositions:
/// 
/// The edge has dimensionality 1.
/// The extend of an edge shall be finite and nonzero.
class IFC_PARSE_API IfcEdge : public  IfcTopologicalRepresentationItem {
public:
    /// Start point (vertex) of the edge.
    ::Ifc4x3_rc1::IfcVertex* EdgeStart() const;
    void setEdgeStart(::Ifc4x3_rc1::IfcVertex* v);
    /// End point (vertex) of the edge. The same vertex can be used for both EdgeStart and EdgeEnd.
    ::Ifc4x3_rc1::IfcVertex* EdgeEnd() const;
    void setEdgeEnd(::Ifc4x3_rc1::IfcVertex* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEdge (IfcEntityInstanceData&& e);
    IfcEdge (::Ifc4x3_rc1::IfcVertex* v1_EdgeStart, ::Ifc4x3_rc1::IfcVertex* v2_EdgeEnd);
    typedef aggregate_of< IfcEdge > list;
};
/// Definition from ISO/CD 10303-42:1992: An edge curve is
/// a special subtype of edge which has its geometry fully defined.
/// The geometry is defined by associating the edge with a curve
/// which may be unbounded. As the topological and geometric
/// directions may be opposed, an indicator (same sense) is used to
/// identify whether the edge and curve directions agree or are
/// opposed. The Boolean value indicates whether the curve direction
/// agrees with (TRUE) or is in the opposite direction (FALSE) to the
/// edge direction. Any geometry associated with the vertices of the
/// edge shall be consistent with the edge geometry. Multiple edges
/// can reference the same curve.
/// 
/// Figure 334 illustrates an example where the edge geometry is given by an unbounded curve, here IfcCircle. The bounds are provided by the EdgeStart and EdgeEnd, the topological direction of the IfcEdgeCurve opposes the direction of the IfcCircle by SameSense = FALSE.
/// 
/// Figure 334 — Edge curve
/// 
/// NOTE  Corresponding ISO 10303 entity: edge_curve. Please refer to ISO/IS 10303-42:1994, p. 132
/// for the final definition of the formal standard. Due to the general IFC model specification rule not to use multiple inheritance, the subtype relationship to geometric_representation_item is not included.
/// 
/// <blockquote class="history"
/// HISTORY  New Entity in IFC2x.
/// 
/// Informal propositions:
/// 
/// The domain of the edge curve is formally defined to be the
/// domain of its edge geometry as trimmed by the vertices. This
/// domain does not include the vertices.
/// An edge curve has non-zero finite extent.
/// An edge curve is a manifold.
/// An edge curve is arcwise connected.
/// The edge start is not a part of the edge domain.
/// The edge end is not a part of the edge domain.
/// Vertex geometry shall be consistent with edge geometry.
class IFC_PARSE_API IfcEdgeCurve : public  IfcEdge, public  IfcCurveOrEdgeCurve {
public:
    /// The curve which defines the shape and spatial location of the edge. This curve may be unbounded and is implicitly trimmed by the vertices of the edge; this defines the edge domain. Multiple edges can reference the same curve.
    ::Ifc4x3_rc1::IfcCurve* EdgeGeometry() const;
    void setEdgeGeometry(::Ifc4x3_rc1::IfcCurve* v);
    /// This logical flag indicates whether (TRUE), or not (FALSE) the senses of the edge and the curve defining the edge geometry are the same. The sense of an edge is from the edge start vertex to the edge end vertex; the sense of a curve is in the direction of increasing parameter.
    bool SameSense() const;
    void setSameSense(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEdgeCurve (IfcEntityInstanceData&& e);
    IfcEdgeCurve (::Ifc4x3_rc1::IfcVertex* v1_EdgeStart, ::Ifc4x3_rc1::IfcVertex* v2_EdgeEnd, ::Ifc4x3_rc1::IfcCurve* v3_EdgeGeometry, bool v4_SameSense);
    typedef aggregate_of< IfcEdgeCurve > list;
};
/// IfcEventTime captures the time-related information about an event
///   including the different types of event dates (i.e. actual,
///   scheduled, early, and late).
/// 
/// HISTORY: New entity in IFC2x4.
///   Use definitions
/// 
/// All given values should be provided by the application,
///   i.e. the IFC schema does not deal with dependencies between
///   process time values. At this stage there is also no
///   consistency check through where rules that guarantee a
///   meaningful population of date values. Thus, an application
///   is responsible to provide reasonable values and, if an
///   application receives event dates, has to make consistency
///   checks by their own.
/// 
/// IfcEventTime furthermore provides a generic
///   mechanism to differentiate between user given time values
///   and time values derived from user given time values and
///   other constraints such as work calendars and assigned
///   resources (derived from the process graph). The data origin flag 
///   is provided as a single attribute applying to all date time related attributes 
///   of IfcEventTime.
class IFC_PARSE_API IfcEventTime : public  IfcSchedulingTime {
public:
    /// The date on which an event actually occurs. It is a measured value.
    boost::optional< std::string > ActualDate() const;
    void setActualDate(boost::optional< std::string > v);
    /// The earliest date on which an event can occur. It is a calculated value.
    boost::optional< std::string > EarlyDate() const;
    void setEarlyDate(boost::optional< std::string > v);
    /// The latest date on which an event can occur. It is a calculated value.
    boost::optional< std::string > LateDate() const;
    void setLateDate(boost::optional< std::string > v);
    /// The date on which an event is scheduled to occur. 
    ///   The value might be measured or somehow calculated, which is defined by
    ///   ScheduleDataOrigin.
    boost::optional< std::string > ScheduleDate() const;
    void setScheduleDate(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEventTime (IfcEntityInstanceData&& e);
    IfcEventTime (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin, boost::optional< std::string > v4_ActualDate, boost::optional< std::string > v5_EarlyDate, boost::optional< std::string > v6_LateDate, boost::optional< std::string > v7_ScheduleDate);
    typedef aggregate_of< IfcEventTime > list;
};

class IFC_PARSE_API IfcExtendedProperties : public  IfcPropertyAbstraction {
public:
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    boost::optional< std::string > Description() const;
    void setDescription(boost::optional< std::string > v);
    aggregate_of< ::Ifc4x3_rc1::IfcProperty >::ptr Properties() const;
    void setProperties(aggregate_of< ::Ifc4x3_rc1::IfcProperty >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExtendedProperties (IfcEntityInstanceData&& e);
    IfcExtendedProperties (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, aggregate_of< ::Ifc4x3_rc1::IfcProperty >::ptr v3_Properties);
    typedef aggregate_of< IfcExtendedProperties > list;
};
/// IfcExternalReferenceRelationship is a relationship entity that enables objects from the
/// IfcResourceObjectSelect to have the ability to be tagged by external references.
/// 
/// NOTE This relationship is used to assign classification, library or document information to entities that
/// do not inherit from IfcRoot. It has a similar functionality as the subtypes of IfcRelAssociates.
/// 
/// HISTORY New Entity in IFC 2x4
class IFC_PARSE_API IfcExternalReferenceRelationship : public  IfcResourceLevelRelationship {
public:
    /// An external reference that can be used to tag an object within the range of IfcResourceObjectSelect.
    /// 
    /// NOTE  External references can be a library reference (for example a dictionary or a catalogue reference), a classification reference, or a documentation reference.
    ::Ifc4x3_rc1::IfcExternalReference* RelatingReference() const;
    void setRelatingReference(::Ifc4x3_rc1::IfcExternalReference* v);
    /// Objects within the list of IfcResourceObjectSelect that can be tagged by an external reference to a dictionary, library, catalogue, classification or documentation.
    aggregate_of< ::Ifc4x3_rc1::IfcResourceObjectSelect >::ptr RelatedResourceObjects() const;
    void setRelatedResourceObjects(aggregate_of< ::Ifc4x3_rc1::IfcResourceObjectSelect >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternalReferenceRelationship (IfcEntityInstanceData&& e);
    IfcExternalReferenceRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc4x3_rc1::IfcExternalReference* v3_RelatingReference, aggregate_of< ::Ifc4x3_rc1::IfcResourceObjectSelect >::ptr v4_RelatedResourceObjects);
    typedef aggregate_of< IfcExternalReferenceRelationship > list;
};
/// Definition from ISO/CD 10303-42:1992: A face is a topological
///   entity of dimensionality 2 corresponding to the intuitive notion of a piece of
///   surface bounded by loops. Its domain, if present, is an oriented, connected,
///   finite 2-manifold in Rm. A face domain shall not have handles
///   but it may have holes, each hole bounded by a loop. The domain of the
///   underlying geometry of the face, if present, does not contain its bounds, and 0
///   < Ξ < ∞. 
///   A face is represented by its bounding loops, which are defined as face
///   bounds. A face has a topological normal n and the tangent to a loop is t. For a
///   loop bounding a face with defined geometry, the cross product n x t points
///   toward the interior of the face. That is, each loop runs counter-clockwise
///   around the face when viewed from above, if we consider the normal n to point
///   up. With each loop is associated a BOOLEAN flag to signify whether the loop
///   direction is oriented with respect to the face normal (TRUE) or should be
///   reversed (FALSE).  
///   A face shall have at least one bound, and the loops shall not intersect.
///   One loop is optionally distinguished as the outer loop of the face. If so, it
///   establishes a preferred way of embedding the face domain in the plane, in which
///   the other bounding loops of the face are inside the outer bound. Because the
///   face domain is arcwise connected, no inner loop will contain any other loop.
///   This is true regardless of which embedding in the plane is chosen.  
///   The edges and vertices referenced by the loops of a face form a graph,
///   of which the individual loops are the connected components. The Euler equation
///   (1) for this graph becomes: 
/// 
/// where Gli is the graph genus of the
///   i th loop. 
/// 
/// NOTE  Corresponding ISO 10303 entity: face. No subtypes of face have been incorporated
///   into this IFC Release. Please refer to ISO/IS 10303-42:1994, p. 140 for the
///   final definition of the formal standard. The WR1 has not been incorporated,
///   since it is always satisfied, due to the fact that only poly loops exist for
///   face bounds.
/// 
/// HISTORY  New class in IFC Release 1.0
/// 
/// Informal propositions: 
/// 
/// No edge shall be referenced by the face more than twice.  
///   Distinct face bounds of the face shall have no common vertices. 
///   If geometry is present, distinct loops of the same face shall not
///   intersect.  
///   The face shall satisfy the Euler Equation: (number of vertices) -
///   (number of edges) - (number of loops) + (sum of genus for loops) = 0.
class IFC_PARSE_API IfcFace : public  IfcTopologicalRepresentationItem {
public:
    /// Boundaries of the face.
    aggregate_of< ::Ifc4x3_rc1::IfcFaceBound >::ptr Bounds() const;
    void setBounds(aggregate_of< ::Ifc4x3_rc1::IfcFaceBound >::ptr v);
        aggregate_of< IfcTextureMap >::ptr HasTextureMaps() const; // INVERSE IfcTextureMap::MappedTo
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFace (IfcEntityInstanceData&& e);
    IfcFace (aggregate_of< ::Ifc4x3_rc1::IfcFaceBound >::ptr v1_Bounds);
    typedef aggregate_of< IfcFace > list;
};
/// Definition from ISO/CD 10303-42:1992: A face bound is a loop which is intended to be used for bounding a face.  
/// 
/// NOTE  Corresponding ISO 10303 entity: face_bound. Please refer to ISO/IS 10303-42:1994, p. 139 for the final definition of the formal standard.
/// 
/// HISTORY  New class in IFC Release 1.0
class IFC_PARSE_API IfcFaceBound : public  IfcTopologicalRepresentationItem {
public:
    /// The loop which will be used as a face boundary.
    ::Ifc4x3_rc1::IfcLoop* Bound() const;
    void setBound(::Ifc4x3_rc1::IfcLoop* v);
    /// This indicated whether (TRUE) or not (FALSE) the loop has the same sense when used to bound the face as when first defined. If sense is FALSE the senses of all its component oriented edges are implicitly reversed when used in the face.
    bool Orientation() const;
    void setOrientation(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceBound (IfcEntityInstanceData&& e);
    IfcFaceBound (::Ifc4x3_rc1::IfcLoop* v1_Bound, bool v2_Orientation);
    typedef aggregate_of< IfcFaceBound > list;
};
/// Definition from ISO/CD 10303-42:1992: A face outer bound is a special subtype of face bound which carries the additional semantics of defining an outer boundary on the face. No more than one boundary of a face shall be of this type.  
/// 
/// NOTE Corresponding ISO 10303 entity: face_outer_bound. Please refer to ISO/IS 10303-42:1994, p. 139 for the final definition of the formal standard.
/// 
/// HISTORY New class in IFC Release 1.0
class IFC_PARSE_API IfcFaceOuterBound : public  IfcFaceBound {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceOuterBound (IfcEntityInstanceData&& e);
    IfcFaceOuterBound (::Ifc4x3_rc1::IfcLoop* v1_Bound, bool v2_Orientation);
    typedef aggregate_of< IfcFaceOuterBound > list;
};
/// Definition from ISO/CD 10303-42:1992: A face surface
///   (IfcFaceSurface) is a subtype of face in which the geometry is defined by an
///   associated surface. The portion of the surface used by the face shall be
///   embeddable in the plane as an open disk, possibly with holes. However, the
///   union of the face with the edges and vertices of its bounding loops need not be
///   embeddable in the plane. It may, for example, cover an entire sphere or torus.
///   As both a face and a geometric surface have defined normal directions, a
///   BOOLEAN flag (the orientation attribute) is used to indicate whether the
///   surface normal agrees with (TRUE) or is opposed to (FALSE) the face normal
///   direction. The geometry associated with any component of the loops of the face
///   shall be consistent with the surface geometry, in the sense that the domains of
///   all the vertex points and edge curves are contained in the face geometry
///   surface. A surface may be referenced by more than one face surface. 
/// 
/// NOTE  Corresponding ISO 10303 entity:
///   face_surface. Please refer to ISO/IS 10303-42:1994, p. 204 for the final
///   definition of the formal standard. Due to the general IFC model specification
///   rule not to use multiple inheritance, the subtype relationship to
///   geometric_representation_item is not included.
/// 
/// HISTORY  New class in IFC2x
/// 
/// Informal propositions: 
/// 
/// The domain of the face surface is formally defined to be the domain
///   of its face geometry as trimmed by the loops, this domain does not include the
///   bounding loops. 
///   A face surface has non zero finite extent. 
///   A face surface is a manifold. 
///   A face surface is arcwise connected. 
///   A face surface has surface genus 0.
///   The loops are not part of the face domain.
///   Loop geometry shall be consistent with face geometry. This implies
///   that any edge - curves or vertex points used in defining the loops bounding the
///   face surface shall lie on the face geometry.
///   The loops of the face shall not intersect.
class IFC_PARSE_API IfcFaceSurface : public  IfcFace, public  IfcSurfaceOrFaceSurface {
public:
    /// The surface which defines the internal shape of the face. This surface may be unbounded. The domain of the face is defined by this surface and the bounding loops in the inherited attribute SELF\FaceBounds.
    ::Ifc4x3_rc1::IfcSurface* FaceSurface() const;
    void setFaceSurface(::Ifc4x3_rc1::IfcSurface* v);
    /// This flag indicates whether the sense of the surface normal agrees with (TRUE), or opposes (FALSE), the sense of the topological normal to the face.
    bool SameSense() const;
    void setSameSense(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceSurface (IfcEntityInstanceData&& e);
    IfcFaceSurface (aggregate_of< ::Ifc4x3_rc1::IfcFaceBound >::ptr v1_Bounds, ::Ifc4x3_rc1::IfcSurface* v2_FaceSurface, bool v3_SameSense);
    typedef aggregate_of< IfcFaceSurface > list;
};
/// Definition from IAI: Defines forces at which a support or connection fails.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcFailureConnectionCondition : public  IfcStructuralConnectionCondition {
public:
    /// Tension force in x-direction leading to failure of the connection.
    boost::optional< double > TensionFailureX() const;
    void setTensionFailureX(boost::optional< double > v);
    /// Tension force in y-direction leading to failure of the connection.
    boost::optional< double > TensionFailureY() const;
    void setTensionFailureY(boost::optional< double > v);
    /// Tension force in z-direction leading to failure of the connection.
    boost::optional< double > TensionFailureZ() const;
    void setTensionFailureZ(boost::optional< double > v);
    /// Compression force in x-direction leading to failure of the connection.
    boost::optional< double > CompressionFailureX() const;
    void setCompressionFailureX(boost::optional< double > v);
    /// Compression force in y-direction leading to failure of the connection.
    boost::optional< double > CompressionFailureY() const;
    void setCompressionFailureY(boost::optional< double > v);
    /// Compression force in z-direction leading to failure of the connection.
    boost::optional< double > CompressionFailureZ() const;
    void setCompressionFailureZ(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFailureConnectionCondition (IfcEntityInstanceData&& e);
    IfcFailureConnectionCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_TensionFailureX, boost::optional< double > v3_TensionFailureY, boost::optional< double > v4_TensionFailureZ, boost::optional< double > v5_CompressionFailureX, boost::optional< double > v6_CompressionFailureY, boost::optional< double > v7_CompressionFailureZ);
    typedef aggregate_of< IfcFailureConnectionCondition > list;
};
/// Definition from ISO/CD 10303-46:1992: The style for filling visible curve segments, annotation fill areas or surfaces with tiles or hatches.
/// 
/// An IfcFillAreaStyle provides the style table for presentation information assigned to annotation fill areas or surfaces for hatching and tiling. The IfcFillAreaStyle defines hatches as model hatches, that is, the distance between hatch lines, or the curve patterns of hatch lines are given in model space dimensions (that have to be scaled using the target plot scale). The IfcFillAreaStyle allows for the following combinations of defining the style of hatching and tiling:
/// 
/// Solid fill for areas and surfaces by only assigning IfcColour to the set of FillStyles. It then provides the background colour for the filled area or surface.
/// 
/// NOTE  Color information of surfaces for rendering is assigned by using IfcSurfaceStyle, not by using IfcFillAreaStyle.
/// 
/// Vector based hatching for areas and surfaces based on a single row of hatch lines by assigning a single instance of IfcFillAreaStyleHatching to the set of FillStyles.  If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching.  Vector based hatching for areas and surfaces based on two (potentially crossing) rows of hatch lines by assigning two instances of IfcFillAreaStyleHatching to the set of FillStyles. 
/// 
/// If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching. 
/// 
/// NOTE  Assigning more then two instances of IfcFillAreaStyleHatching to define three or more rows of hatch lines is not encouraged.
/// 
/// Tiling for areas and surfaces by assigning a single instance of IfcFillAreaStyleTiles to the set of FillStyles.  If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the tiling. 
/// 
/// IFC2x3 NOTE  The use of IfcFillAreaStyleTiles is discouraged., as its definition might change is future releases.
/// 
/// Externally defined hatch style by assigning a single instance of IfcExternallyDefinedHatchStyle to the set of FillStyles. 
///   If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching.
/// 
/// Measures given to a hatch or tile pattern are given in global drawing length units.
/// 
/// NOTE  Global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// The measure values for hatch or tile pattern apply to the model space with a target plot scale provided for the correct appearance in the default plot scale. For different scale and projection dependent fill area styles a different instance of IfcFillAreaStyle needs to be used by IfcPresentationStyleAssignment for different IfcGeometricRepresentationSubContext dependent representations.
/// 
/// NOTE  the target plot scale is given by IfcGeometricRepresentationSubContext.TargetScale.
/// 
/// An IfcFillAreaStyle can be assigned to IfcFillArea via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or subtype IfcAnnotationFillAreaOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: fill_area_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcFillAreaStyle : public  IfcPresentationStyle, public  IfcPresentationStyleSelect {
public:
    /// The set of fill area styles to use in presenting visible curve segments, annotation fill areas or surfaces.
    aggregate_of< ::Ifc4x3_rc1::IfcFillStyleSelect >::ptr FillStyles() const;
    void setFillStyles(aggregate_of< ::Ifc4x3_rc1::IfcFillStyleSelect >::ptr v);
    boost::optional< bool > ModelorDraughting() const;
    void setModelorDraughting(boost::optional< bool > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFillAreaStyle (IfcEntityInstanceData&& e);
    IfcFillAreaStyle (boost::optional< std::string > v1_Name, aggregate_of< ::Ifc4x3_rc1::IfcFillStyleSelect >::ptr v2_FillStyles, boost::optional< bool > v3_ModelorDraughting);
    typedef aggregate_of< IfcFillAreaStyle > list;
};
/// Definition from ISO/CD 10303-42:1992: A geometric
/// representation context is a representation context in which the
/// geometric representation items are geometrically founded. A
/// geometric representation context is a distinct coordinate space,
/// spatially unrelated to other coordinate spaces.
/// 
/// IfcGeometricRepresentationContext defines the context that
/// applies to several shape representations of products within a
/// project. It defines the type of the context in which the shape
/// representation is defined, and the numeric precision applicable
/// to the geometric representation items defined in this context. In
/// addition it can be used to offset the project coordinate system
/// from a global point of origin, using the
/// WorldCoordinateSystem attribute.
/// 
/// As shown in Figure 329, the TrueNorth attribute should be provided if the y axis of the WorldCoordinateSystem does not point to the global northing. Direction of the true north, or geographic northing direction, relative to the underlying project coordinate
/// system as established by the attribute WorldCoordinateSystem. It is given by a 2 dimensional direction within the xy-plane of the project coordinate system. If not resent, it defaults to [0.,1.] - i.e. the positive Y axis of the project coordinate system equals the geographic northing direction. The direction is provided within project coordinate system and identifies the true north direction (see
/// figure).
/// 
/// Figure 329 — Geometric representation context true north
/// 
/// NOTE The inherited attribute
/// ContextType shall have one of the following recognized
/// values: 'Sketch', 'Outline', 'Design', 'Detail',
/// 'Model', 'Plan',
/// 'NotDefined'.
/// 
/// The use of one instance of
/// IfcGeometricRepresentationContext to represent the model
/// (3D) view is mandatory, the use of a second instance of
/// IfcGeometricRepresentationContext to represent the plan
/// (2D) view is optional (but needs to be given, if there are scale
/// dependent plan views), the additional scale or view dependent
/// contexts need to be handled by using the subtype
/// IfcGeometricRepresentationSubContext pointing to the model
/// view (or the plan view) as the ParentContext.
/// 
/// Figure 330 illustrates use of representation contexts defined at IfcProject for 3D model and 2D plan context, including sub
/// context definitions for different target scales.
/// 
/// Figure 330 — Geometric representation context use
/// 
/// NOTE  The definition of this class relates to the ISO 10303 entity geometric_representation_context. Please refer to ISO/IS 10303-42:1994 for the final definition of the formal standard.
/// 
/// HISTORY New Entity in IFC Release 2.0
/// 
/// IFC2x3 CHANGE Applicable values for ContextType are only 'Model', 'Plan', and'NotDefined'. All other sub contexts are now handled by the new subtype in IFC2x Edition 2 IfcGeometricRepresentationSubContext. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcGeometricRepresentationContext : public  IfcRepresentationContext, public  IfcCoordinateReferenceSystemSelect {
public:
    /// The integer dimension count of the coordinate space modeled in a geometric representation context.
    int CoordinateSpaceDimension() const;
    void setCoordinateSpaceDimension(int v);
    /// Value of the model precision for geometric models. It is a double value (REAL), typically in 1E-5 to 1E-8 range, that indicates the tolerance under which two given points are still assumed to be identical. The value can be used e.g. to sets the maximum distance from an edge curve to the underlying face surface in brep models.
    boost::optional< double > Precision() const;
    void setPrecision(boost::optional< double > v);
    /// Establishment of the engineering coordinate system (often referred to as the world coordinate system in CAD) for all representation contexts used by the project. 
    /// 
    /// Note  it can be used to provide better numeric stability if the placement of the building(s) is far away from the origin. In most cases however it would be set to origin: (0.,0.,0.) and directions x(1.,0.,0.), y(0.,1.,0.), z(0.,0.,1.).
    ::Ifc4x3_rc1::IfcAxis2Placement* WorldCoordinateSystem() const;
    void setWorldCoordinateSystem(::Ifc4x3_rc1::IfcAxis2Placement* v);
    /// Direction of the true north, or geographic northing direction, relative to the underlying project coordinate system. It is given by a 2 dimensional direction within the xy-plane of the project coordinate system. If not resent, it defaults to 0. 1. - i.e. the positive Y axis of the project coordinate system equals the geographic northing direction.
    ::Ifc4x3_rc1::IfcDirection* TrueNorth() const;
    void setTrueNorth(::Ifc4x3_rc1::IfcDirection* v);
        aggregate_of< IfcGeometricRepresentationSubContext >::ptr HasSubContexts() const; // INVERSE IfcGeometricRepresentationSubContext::ParentContext
    aggregate_of< IfcCoordinateOperation >::ptr HasCoordinateOperation() const; // INVERSE IfcCoordinateOperation::SourceCRS
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationContext (IfcEntityInstanceData&& e);
    IfcGeometricRepresentationContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType, int v3_CoordinateSpaceDimension, boost::optional< double > v4_Precision, ::Ifc4x3_rc1::IfcAxis2Placement* v5_WorldCoordinateSystem, ::Ifc4x3_rc1::IfcDirection* v6_TrueNorth);
    typedef aggregate_of< IfcGeometricRepresentationContext > list;
};
/// Definition from ISO/CD 10303-43:1992: An geometric representation item is a representation item that has the additional meaning of having geometric position or orientation or both. This meaning is present by virtue of:  
/// 
/// being a Cartesian point or a direction  
///   referencing directly a Cartesian point or direction  
///   referencing indirectly a Cartesian point or direction  
/// 
/// An indirect reference to a Cartesian point or direction means that a given geometric item references the Cartesian point or direction through one or more intervening geometry or topology items.  
/// 
/// EXAMPLE: Consider a circle. It gains its geometric position and orientation by virtue of a reference to axis2_placement (IfcAxis2Placement) that is turn references a cartesian_point (IfcCartesianPoint) and several directions (IfcDirection). 
/// 
/// EXAMPLE: Consider a manifold brep. A manifold_solid_brep (IfcManifoldSolidBrep) is a geometric_representation_item (IfcGeometricRepresentationItem) that through several layers of topological_representation_item's (IfcTopologicalRepresentationItem) references poly loops (IfcPolyLoop). Through additional intervening entities poly loops reference cartesian_point's (IfcCartesianPoint).
/// 
/// The derivation of the dimensionality of the IfcGeometricRepresentationItem is different to ISO 10303; there is a specific derived attribute at each class that defines the dimensionality, whereas ISO 10303 does it for the representation_context and requires all geometric_representation_item's to have the same dimensionality therein.  
/// 
/// The definition of swept area solids as geometric representation items is different to ISO 10303; it is based on a set of predefined profiles (or cross sections), that is, a set of parameterized geometric primitives widely supported in the industry. Those profiles are used to create volumes through extrusion, revolution and cross section based sweep operations.
/// 
/// NOTE: Corresponding ISO 10303 entity: geometric_representation_item. Please refer to ISO/IS 10303-42:1994, p. 22 for the final definition of the formal standard. The following changes have been made: It does not inherit from ISO/IS 10303-43:1994 entity representation_item. The derived attribute Dim is demoted to the appropriate subtypes. The WR1 has not been incorporated. Not all subtypes that are in ISO/IS 10303-42:1994 have been added to the current IFC Release.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcGeometricRepresentationItem : public  IfcRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationItem (IfcEntityInstanceData&& e);
    IfcGeometricRepresentationItem ();
    typedef aggregate_of< IfcGeometricRepresentationItem > list;
};
/// IfcGeometricRepresentationSubContext defines the context that applies to several shape representations of a product being a sub context, sharing the WorldCoordinateSystem, CoordinateSpaceDimension, Precision and TrueNorth attributes with the parent IfcGeometricRepresentationContext.
/// 
/// The IfcGeometricRepresentationSubContext is used to define semantically distinguished representation types for different information content, dependent on the representation view and the target scale. It can be used to control the level of detail of the shape representation that is most applicable to this geometric representation context. addition the sub context is used to control the later appearance of the IfcShapeRepresentation within a plot view.
/// 
/// NOTE  If the IfcShapeRepresentation using this sub context has IfcStyledItem's assigned to the Items, the presentation style information (e.g. IfcCurveStyle, IfcTextStyle) associated with the IfcStyledItem is given in target plot dimensions. For example, a line thickness (IfcCurveStyle.CurveWidth) is given by a thickness measure relating to the thickness for a plot within the (range of) target scale.
/// 
/// Each IfcProduct can then have several instances of subtypes of IfcRepresentation, each being assigned to a different geometric representation context (IfcGeometricRepresentationContext or IfcGeometricRepresentationSubContext). The application can then choose the most appropriate representation for showing the geometric shape of the product, depending on the target view and scale.
/// 
/// NOTE  The provision of a model view (IfcGeometricRepresentationContext.ContextType = 'Model') is mandatory. Instances of IfcGeometricRepresentationSubContext relate to it as its ParentContext.
/// 
/// EXAMPLE  Instances of IfcGeometricRepresentationSubContext can be used to handle the multi-view blocks or macros, which are used in CAD programs to store several scale and/or view dependent geometric representations of the same object.
/// 
/// HISTORY  New entity in Release IFC 2x2.
class IFC_PARSE_API IfcGeometricRepresentationSubContext : public  IfcGeometricRepresentationContext {
public:
    /// Parent context from which the sub context derives its world coordinate system, precision, space coordinate dimension and true north.
    ::Ifc4x3_rc1::IfcGeometricRepresentationContext* ParentContext() const;
    void setParentContext(::Ifc4x3_rc1::IfcGeometricRepresentationContext* v);
    /// The target plot scale of the representation 
    /// to which this representation context applies.
    ///   Scale indicates the target plot scale for
    /// the representation sub context, all annotation styles are given in plot
    /// dimensions according to this target plot scale.
    /// If multiple instances of IfcGeometricRepresentationSubContext
    /// are given having the same TargetView value, the target plot scale 
    /// applies up to the next smaller scale, or up to unlimited small scale.
    /// 
    /// Note: Scale 1:100 (given as 0.01 within TargetScale)
    /// is bigger then 1:200 (given as 0.005 within TargetScale).
    boost::optional< double > TargetScale() const;
    void setTargetScale(boost::optional< double > v);
    /// Target view of the representation to which this representation context applies.
    ::Ifc4x3_rc1::IfcGeometricProjectionEnum::Value TargetView() const;
    void setTargetView(::Ifc4x3_rc1::IfcGeometricProjectionEnum::Value v);
    /// User defined target view, this attribute value shall be given, if the TargetView attribute is set to USERDEFINED.
    boost::optional< std::string > UserDefinedTargetView() const;
    void setUserDefinedTargetView(boost::optional< std::string > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationSubContext (IfcEntityInstanceData&& e);
    IfcGeometricRepresentationSubContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType, ::Ifc4x3_rc1::IfcGeometricRepresentationContext* v7_ParentContext, boost::optional< double > v8_TargetScale, ::Ifc4x3_rc1::IfcGeometricProjectionEnum::Value v9_TargetView, boost::optional< std::string > v10_UserDefinedTargetView);
    typedef aggregate_of< IfcGeometricRepresentationSubContext > list;
};
/// Definition from ISO/CD 10303-42:1992: This entity is intended for the transfer of models when a topological structure is not available. 
/// 
/// The IfcGeometricSet is used for the exchange of shape representations consisting of (2D or 3D) points, curves, and/or surfaces, which do not have a topological structure (such as connected face sets or shells) and are not solid models (such as swept solids, CSG or Brep) 
/// 
/// NOTE: Corresponding ISO 10303-42 entity: geometric_set. The derived attribute Dim has been added at this level and was therefore demoted from the geometric_representation_item. Please refer to ISO/IS 10303-42:1994, p. 190 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 2x.
class IFC_PARSE_API IfcGeometricSet : public  IfcGeometricRepresentationItem {
public:
    /// The geometric elements which make up the geometric set, these may be points, curves or surfaces; but are required to be of the same coordinate space dimensionality.
    aggregate_of< ::Ifc4x3_rc1::IfcGeometricSetSelect >::ptr Elements() const;
    void setElements(aggregate_of< ::Ifc4x3_rc1::IfcGeometricSetSelect >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricSet (IfcEntityInstanceData&& e);
    IfcGeometricSet (aggregate_of< ::Ifc4x3_rc1::IfcGeometricSetSelect >::ptr v1_Elements);
    typedef aggregate_of< IfcGeometricSet > list;
};
/// IfcGridPlacement provides a specialization of IfcObjectPlacement in which
/// the placement and axis direction of the object coordinate system is defined by a reference to the design grid as defined in IfcGrid.
/// The location of the object coordinate system is given by the attribute PlacementLocation. It is defined as an
/// IfcVirtualGridIntersection, that is, an intersection between two grid axes with optional offsets.
/// The axis direction of the x-axis of the object coordinate
/// system is given either:
/// 
/// PlacementRefDirection = NIL: by the tangent of the first grid axis (PlacementLocation.IntersectingAxes[1]) at the virtual intersection (maybe using the offset curve, if PlacementLocation.OffsetDistances is given);
/// PlacementRefDirection = IfcDirection: by the explicitly provided direction information;
/// PlacementRefDirection = IfcVirtualGridIntersection: by the tangent between the virtual grid intersection of PlacementLocation and the virtual grid intersection of PlacementRefDirection. Offsets as potentially provided in the IfcVirtualGridIntersection's of PlacementLocation and PlacementRefDirection have to be taken into account.
/// 
/// The direction of the y-axis of the IfcGridPlacement is the orthogonal complement to the x-axis. The plane defined by the x and y axis shall be co-planar to the xy plane of the local placement of the IfcGrid. 
/// The direction of the z-axis is the orientation of the cross product of the x-axis and the y-axis, i.e. the z-axis of the IfcGridPlacement shall be co-linear to the z-axis of the local placement of the IfcGrid.
/// 
/// NOTE The IfcGrid local placement, that can be provided relative to the local placement of another spatial structure element, has to be taken into account for calculating the absolute placement of the virtual grid intersection.
/// 
/// NOTE The PlacementLocation.OffsetDistances[3] and the PlacementRefDirection.OffsetDistances[3] shall either not be assigned or should have the same z offset value.
/// 
/// HISTORY New entity in IFC Release 1.5. The entity name was changed from IfcConstrainedPlacement in IFC Release 2x.
/// 
/// IFC2x4 CHANGE Attribute data type of PlacementRefDirection has been changed to IfcGridPlacementDirectionSelect.
/// 
/// Geometry use definitions
/// The following examples show the usage of placement location and direction for an IfcGridPlacement.
/// 
/// Figure 243 illustrates the case where PlacementRefDirection is not given - the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the tangent of the first intersecting axis in the offset location of the virtual grid intersection
/// 
/// Figure 243 — Grid placement
/// 
/// Figure 244 illustrates the case where PlacementRefDirection is given as an IfcDirection- the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the DirectionRatios of the IfcDirection, only the ratios for x and y are taken into account,
/// 
/// Figure 244 — Grid placement with direction
/// 
/// Figure 245 illustrates the case where PlacementRefDirection is given as an IfcVirtualGridIntersection- the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the tangent of the line between the virtual grid intersection of the PlacementLocation and the virtual grid intersection of the PlacementRefDirection.
/// 
/// Figure 245 — Grid placement with intersection
class IFC_PARSE_API IfcGridPlacement : public  IfcObjectPlacement {
public:
    /// Placement of the object coordinate system defined by the intersection of two grid axes.
    ::Ifc4x3_rc1::IfcVirtualGridIntersection* PlacementLocation() const;
    void setPlacementLocation(::Ifc4x3_rc1::IfcVirtualGridIntersection* v);
    /// Reference to either an explicit direction, or a second grid axis intersection, which defines the orientation of the grid placement.
    /// 
    /// IFC2x4 CHANGE  The select of an explict direction has been added.
    ::Ifc4x3_rc1::IfcGridPlacementDirectionSelect* PlacementRefDirection() const;
    void setPlacementRefDirection(::Ifc4x3_rc1::IfcGridPlacementDirectionSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGridPlacement (IfcEntityInstanceData&& e);
    IfcGridPlacement (::Ifc4x3_rc1::IfcObjectPlacement* v1_PlacementRelTo, ::Ifc4x3_rc1::IfcVirtualGridIntersection* v2_PlacementLocation, ::Ifc4x3_rc1::IfcGridPlacementDirectionSelect* v3_PlacementRefDirection);
    typedef aggregate_of< IfcGridPlacement > list;
};
/// Definition from ISO/CD 10303-42:1992: A half space solid is defined by the half space which is the regular subset of the domain which lies on one side of an unbounded surface. The side of the surface which is in the half space is determined by the surface normal and the agreement flag. If the agreement flag is TRUE, then the subset is the one the normal points away from. If the agreement flag is FALSE, then the subset is the one the normal points into. For a valid half space solid the surface shall divide the domain into exactly two subsets. Also, within the domain the surface shall be manifold and all surface normals shall point into the same subset.  
/// 
/// NOTE A half space is not a subtype of solid model (IfcSolidModel), half space solids are only useful as operands in Boolean expressions.
/// 
/// NOTE Corresponding STEP entity: half_space_solid. Please refer to ISO/IS 10303-42:1994, p. 185 for the final definition of the formal standard. The derived attribute Dim has been added at this level and was therefore demoted from the geometric_representation_item.
/// 
/// HISTORY New class in IFC Release 1.5
/// 
/// Informal propositions: 
/// 
/// The base surface shall divide the domain into exactly two subsets. If the half space solid is of subtype boxed half space (IfcBoxedHalfSpace), the domain in question is that of the attribute enclosure. In all other cases the domain is all of space and the base surface shall be unbounded.  The base surface shall be an unbounded surface (subtype of IfcElementarySurface). 
/// 
/// Figure 258 illustrates the definition of the IfcHalfSpaceSolid within a given coordinate system. The base surface is given by an unbounded plane, the red boundary is shown for visualization purposes only. 
/// 
/// Figure 258 — Half space solid geometry
class IFC_PARSE_API IfcHalfSpaceSolid : public  IfcGeometricRepresentationItem, public  IfcBooleanOperand {
public:
    /// Surface defining side of half space.
    ::Ifc4x3_rc1::IfcSurface* BaseSurface() const;
    void setBaseSurface(::Ifc4x3_rc1::IfcSurface* v);
    /// The agreement flag is TRUE if the normal to the BaseSurface points away from the material of the IfcHalfSpaceSolid. Otherwise it is FALSE.
    bool AgreementFlag() const;
    void setAgreementFlag(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcHalfSpaceSolid (IfcEntityInstanceData&& e);
    IfcHalfSpaceSolid (::Ifc4x3_rc1::IfcSurface* v1_BaseSurface, bool v2_AgreementFlag);
    typedef aggregate_of< IfcHalfSpaceSolid > list;
};
/// An IfcImageTexture provides a 2-dimensional texture that can be applied to a surface of an geometric item and that provides lighting parameters of a surface onto which it is mapped. The texture is provided as an image file at an external location for which an URL is provided.
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) apply:
/// 
/// The ImageTexture node defines a texture map by specifying an image file and general parameters for mapping to geometry. 
/// The texture is read from the URL specified by the url field. When the url field contains no [resolvable] values, texturing is disabled. Browsers shall support the JPEG and PNG (see ISO/IEC 15948) image file formats.
/// Texture nodes that require support for the PNG image format shall interpret the PNG pixel formats in the following way:
/// 
/// Greyscale pixels without alpha or simple transparency are treated as intensity textures.
/// >Greyscale pixels with alpha or simple transparency are treated as intensity plus alpha textures.
/// RGB pixels without alpha channel or simple transparency are treated as full RGB textures.
/// RGB pixels with alpha channel or simple transparency are treated as full RGB plus alpha textures.
/// 
/// If the image specifies colours as indexed-colour (that is, palettes or colourmaps), the following semantics should be used (note that `greyscale' refers to a palette entry with equal red, green, and blue values):
/// 
/// If all the colours in the palette are greyscale and there is no transparency chunk, it is treated as an intensity texture.
/// If all the colours in the palette are greyscale and there is a transparency chunk, it is treated as an intensity plus opacity texture.
/// >If any colour in the palette is not grey and there is no transparency chunk, it is treated as a full RGB texture.
/// If any colour in the palette is not grey and there is a transparency chunk, it is treated as a full RGB plus alpha texture.
/// 
/// Texture nodes that require support for JPEG files shall interpret JPEG files as follows:
/// 
/// Greyscale files (number of components equals 1) are treated as intensity textures.
/// YCbCr files are treated as full RGB textures.
/// No other JPEG file types are required. It is recommended that other JPEG files are treated as a full RGB textures.
/// 
/// Texture nodes that recommend support for GIF files shall follow the applicable semantics described above for the PNG format.
/// 
/// The Uniform Resource Locator (URL) is a form of an URI and specified in RFC1738 by IETF. It supports resources located on a particular server being accessed by a particular protocol (usually http), and resources located at a local machine.
/// 
/// NOTE  Exchange files following the ifcZIP convention may include a sub directory structure for image resources to be stored together with the product data set.
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in Release IFC2x2.
class IFC_PARSE_API IfcImageTexture : public  IfcSurfaceTexture {
public:
    /// Location, provided as an URI, at which the image texture is electronically published.
    std::string URLReference() const;
    void setURLReference(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcImageTexture (IfcEntityInstanceData&& e);
    IfcImageTexture (bool v1_RepeatS, bool v2_RepeatT, boost::optional< std::string > v3_Mode, ::Ifc4x3_rc1::IfcCartesianTransformationOperator2D* v4_TextureTransform, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_Parameter, std::string v6_URLReference);
    typedef aggregate_of< IfcImageTexture > list;
};

class IFC_PARSE_API IfcIndexedColourMap : public  IfcPresentationItem {
public:
    ::Ifc4x3_rc1::IfcTessellatedFaceSet* MappedTo() const;
    void setMappedTo(::Ifc4x3_rc1::IfcTessellatedFaceSet* v);
    boost::optional< double > Opacity() const;
    void setOpacity(boost::optional< double > v);
    ::Ifc4x3_rc1::IfcColourRgbList* Colours() const;
    void setColours(::Ifc4x3_rc1::IfcColourRgbList* v);
    std::vector< int > /*[1:?]*/ ColourIndex() const;
    void setColourIndex(std::vector< int > /*[1:?]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIndexedColourMap (IfcEntityInstanceData&& e);
    IfcIndexedColourMap (::Ifc4x3_rc1::IfcTessellatedFaceSet* v1_MappedTo, boost::optional< double > v2_Opacity, ::Ifc4x3_rc1::IfcColourRgbList* v3_Colours, std::vector< int > /*[1:?]*/ v4_ColourIndex);
    typedef aggregate_of< IfcIndexedColourMap > list;
};

class IFC_PARSE_API IfcIndexedTextureMap : public  IfcTextureCoordinate {
public:
    ::Ifc4x3_rc1::IfcTessellatedFaceSet* MappedTo() const;
    void setMappedTo(::Ifc4x3_rc1::IfcTessellatedFaceSet* v);
    ::Ifc4x3_rc1::IfcTextureVertexList* TexCoords() const;
    void setTexCoords(::Ifc4x3_rc1::IfcTextureVertexList* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIndexedTextureMap (IfcEntityInstanceData&& e);
    IfcIndexedTextureMap (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Maps, ::Ifc4x3_rc1::IfcTessellatedFaceSet* v2_MappedTo, ::Ifc4x3_rc1::IfcTextureVertexList* v3_TexCoords);
    typedef aggregate_of< IfcIndexedTextureMap > list;
};

class IFC_PARSE_API IfcIndexedTriangleTextureMap : public  IfcIndexedTextureMap {
public:
    boost::optional< std::vector< std::vector< int > > > TexCoordIndex() const;
    void setTexCoordIndex(boost::optional< std::vector< std::vector< int > > > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIndexedTriangleTextureMap (IfcEntityInstanceData&& e);
    IfcIndexedTriangleTextureMap (aggregate_of< ::Ifc4x3_rc1::IfcSurfaceTexture >::ptr v1_Maps, ::Ifc4x3_rc1::IfcTessellatedFaceSet* v2_MappedTo, ::Ifc4x3_rc1::IfcTextureVertexList* v3_TexCoords, boost::optional< std::vector< std::vector< int > > > v4_TexCoordIndex);
    typedef aggregate_of< IfcIndexedTriangleTextureMap > list;
};
/// In an irregular time series, unpredictable bursts of data arrive at unspecified points in time, or most time stamps cannot be characterized by a repeating pattern.
/// 
/// EXAMPLE: A circulating pump cycles on and off at unpredictable times as dictated by the demands on the piping system; the amount of light in a classroom varies depending on when the lights are manually switched on and off and and how many lamps are controlled by each switch.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcIrregularTimeSeries : public  IfcTimeSeries {
public:
    /// The collection of time series values.
    aggregate_of< ::Ifc4x3_rc1::IfcIrregularTimeSeriesValue >::ptr Values() const;
    void setValues(aggregate_of< ::Ifc4x3_rc1::IfcIrregularTimeSeriesValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIrregularTimeSeries (IfcEntityInstanceData&& e);
    IfcIrregularTimeSeries (std::string v1_Name, boost::optional< std::string > v2_Description, std::string v3_StartTime, std::string v4_EndTime, ::Ifc4x3_rc1::IfcTimeSeriesDataTypeEnum::Value v5_TimeSeriesDataType, ::Ifc4x3_rc1::IfcDataOriginEnum::Value v6_DataOrigin, boost::optional< std::string > v7_UserDefinedDataOrigin, ::Ifc4x3_rc1::IfcUnit* v8_Unit, aggregate_of< ::Ifc4x3_rc1::IfcIrregularTimeSeriesValue >::ptr v9_Values);
    typedef aggregate_of< IfcIrregularTimeSeries > list;
};
/// IfcLagTime describes the time parameters that may exist within a sequence relationship between two processes.
/// 
/// HISTORY: New entity in IFC Release 2x4.
/// 
/// Use Definitions
/// 
/// An IfcLagTime provides information about the
///   time lag that exists between the predecessor and successor
///   process in a sequence. The assertion of the time lag is
///   optional for a sequence but for work schedules that
///   specifically deal with processes occurring at particular
///   times, it should be asserted.
/// 
/// A lag time has a duration type. This allows the
///   identification of whether elapsed time or work time is
///   being measured (where work time is the estimate of the time
///   required to complete the process and elapsed time being the
///   amount of time actually allocated to the process)
/// 
/// The form of measurement of the duration can be captured.
///   Allowed values for this are MEASURED, PREDICTED or
///   SIMULATED. The selection of this value depends on the use
///   of the schedule. A NOTDEFINED value is also allowed.
/// 
/// The value of the time lag may be selected as being either a
///   percentage ratio or an actual time measure. If selected as
///   a ratio, the percentage should apply to the duration of the
///   predecessor process (relating process) such that e.g. a
///   value of 0.5 (50%) would indicate that the successor task
///   should start when the predecessor task is 50% complete (if
///   a START-START sequence type is used) or should wait for 50%
///   of the duration of the predecessor process to have elapsed
///   after the finish of the predecessor process in case of a
///   FINISH-START sequence type.
/// 
/// The time unit for the task duration may also be set and
///   this may be set to any allowed unit of time measure.
class IFC_PARSE_API IfcLagTime : public  IfcSchedulingTime {
public:
    /// Value of the time lag selected as being either a ratio or a
    ///   time measure.
    ::Ifc4x3_rc1::IfcTimeOrRatioSelect* LagValue() const;
    void setLagValue(::Ifc4x3_rc1::IfcTimeOrRatioSelect* v);
    /// The allowed types of task duration that specify the lag time
    ///   measurement (work time or elapsed time).
    ::Ifc4x3_rc1::IfcTaskDurationEnum::Value DurationType() const;
    void setDurationType(::Ifc4x3_rc1::IfcTaskDurationEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLagTime (IfcEntityInstanceData&& e);
    IfcLagTime (boost::optional< std::string > v1_Name, boost::optional< ::Ifc4x3_rc1::IfcDataOriginEnum::Value > v2_DataOrigin, boost::optional< std::string > v3_UserDefinedDataOrigin, ::Ifc4x3_rc1::IfcTimeOrRatioSelect* v4_LagValue, ::Ifc4x3_rc1::IfcTaskDurationEnum::Value v5_DurationType);
    typedef aggregate_of< IfcLagTime > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source entity is determined by the reflectance specified in the surface style rendering. Lighting is applied on a surface by surface basis: no interactions between surfaces such as shadows or reflections are defined. 
/// 
/// NOTE: Corresponding STEP entity: light_source. Please refer to ISO/IS 10303-46:1994, p. 31 for the final definition of the formal standard. 
/// 
/// NOTE: In addition to the attributes as defined in ISO10303-46 the following additional properties from ISO/IEC 14772-1:1997 (VRML) are added: ambientIntensity and Intensity. The attribute Name has been added as well (as it is not inherited via representation_item).
/// 
/// HISTORY: This is a new Entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSource : public  IfcGeometricRepresentationItem {
public:
    /// The name given to the light source in presentation.
    boost::optional< std::string > Name() const;
    void setName(boost::optional< std::string > v);
    /// Definition from ISO/CD 10303-46:1992: Based on the current lighting model, the colour of the light to be used for shading.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The color field specifies the spectral color properties of both the direct and ambient light emission as an RGB value.
    ::Ifc4x3_rc1::IfcColourRgb* LightColour() const;
    void setLightColour(::Ifc4x3_rc1::IfcColourRgb* v);
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The ambientIntensity specifies the intensity of the ambient emission from the light. Light intensity may range from 0.0 (no light emission) to 1.0 (full intensity).
    boost::optional< double > AmbientIntensity() const;
    void setAmbientIntensity(boost::optional< double > v);
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The intensity field specifies the brightness of the direct emission from the ligth. Light intensity may range from 0.0 (no light emission) to 1.0 (full intensity).
    boost::optional< double > Intensity() const;
    void setIntensity(boost::optional< double > v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSource (IfcEntityInstanceData&& e);
    IfcLightSource (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity);
    typedef aggregate_of< IfcLightSource > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source ambient entity is a subtype of light source. It lights a surface independent of the surface's orientation and position. 
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_ambient. Please refer to ISO/IS 10303-46:1994, p. 31 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO 10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) AmbientIntensity is inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourceAmbient : public  IfcLightSource {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceAmbient (IfcEntityInstanceData&& e);
    IfcLightSourceAmbient (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity);
    typedef aggregate_of< IfcLightSourceAmbient > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source directional is a subtype of light source. This entity has a light source direction. With a conceptual origin at infinity, all the rays of the light are parallel to this direction. This kind of light source lights a surface based on the surface's orientation, but not position. 
/// 
/// Definition from ISO/IEC 14772-1:1997: The directional light node defines a directional light source that illuminates along rays parallel to a given 3-dimensional vector. Directional light nodes do not attenuate with distance. Directional light nodes are specified in the local coordinate system and are affected by ancestor transformations. 
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_directional. Please refer to ISO/IS 10303-46:1994, p. 32 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO 10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) AmbientIntensity and Intensity are inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourceDirectional : public  IfcLightSource {
public:
    /// Definition from ISO/CD 10303-46:1992: This direction is the direction of the light source.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The direction field specifies the direction vector of the illumination emanating from the light source in the local coordinate system. Light is emitted along parallel rays from an infinite distance away.
    ::Ifc4x3_rc1::IfcDirection* Orientation() const;
    void setOrientation(::Ifc4x3_rc1::IfcDirection* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceDirectional (IfcEntityInstanceData&& e);
    IfcLightSourceDirectional (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc4x3_rc1::IfcDirection* v5_Orientation);
    typedef aggregate_of< IfcLightSourceDirectional > list;
};
/// IfcLightSourceGoniometric defines a light source for which exact lighting data is available. It specifies the type of a light emitter, defines the position and orientation of a light distribution curve and the data concerning lamp and photometric information. 
/// 
/// Figure 303 shows an example of a light emitter having two light sources (of type IfcLightSourceGoniometric). 
/// 
/// Figure 303 — Light source goniometric
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcLightSourceGoniometric : public  IfcLightSource {
public:
    /// The position of the light source. It is used to orientate the light distribution curves.
    ::Ifc4x3_rc1::IfcAxis2Placement3D* Position() const;
    void setPosition(::Ifc4x3_rc1::IfcAxis2Placement3D* v);
    /// Artificial light sources are classified in terms of their color appearance. To the human eye they all appear to be white; the difference can only be detected by direct comparison. Visual performance is not directly affected by differences in color appearance.
    ::Ifc4x3_rc1::IfcColourRgb* ColourAppearance() const;
    void setColourAppearance(::Ifc4x3_rc1::IfcColourRgb* v);
    /// The color temperature of any source of radiation is defined as the temperature (in Kelvin) of a black-body or Planckian radiator whose radiation has the same chromaticity as the source of radiation. Often the values are only approximate color temperatures as the black-body radiator cannot emit radiation of every chromaticity value. The color temperatures of the commonest artificial light sources range from less than 3000K (warm white) to 4000K (intermediate) and over 5000K (daylight).
    double ColourTemperature() const;
    void setColourTemperature(double v);
    /// Luminous flux is a photometric measure of radiant flux, i.e. the volume of light emitted from a light source. Luminous flux is measured either for the interior as a whole or for a part of the interior (partial luminous flux for a solid angle). All other photometric parameters are derivatives of luminous flux. Luminous flux is measured in lumens (lm). The luminous flux is given as a nominal value for each lamp.
    double LuminousFlux() const;
    void setLuminousFlux(double v);
    /// Identifies the types of light emitter from which the type required may be set.
    ::Ifc4x3_rc1::IfcLightEmissionSourceEnum::Value LightEmissionSource() const;
    void setLightEmissionSource(::Ifc4x3_rc1::IfcLightEmissionSourceEnum::Value v);
    /// The data source from which light distribution data is obtained.
    ::Ifc4x3_rc1::IfcLightDistributionDataSourceSelect* LightDistributionDataSource() const;
    void setLightDistributionDataSource(::Ifc4x3_rc1::IfcLightDistributionDataSourceSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceGoniometric (IfcEntityInstanceData&& e);
    IfcLightSourceGoniometric (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc4x3_rc1::IfcAxis2Placement3D* v5_Position, ::Ifc4x3_rc1::IfcColourRgb* v6_ColourAppearance, double v7_ColourTemperature, double v8_LuminousFlux, ::Ifc4x3_rc1::IfcLightEmissionSourceEnum::Value v9_LightEmissionSource, ::Ifc4x3_rc1::IfcLightDistributionDataSourceSelect* v10_LightDistributionDataSource);
    typedef aggregate_of< IfcLightSourceGoniometric > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source positional entity is a subtype of light source. This entity has a light source position and attenuation coefficients. A positional light source affects a surface based on the surface's orientation and position. 
/// 
/// Definition from ISO/IEC 14772-1:1997: The Point light node specifies a point light source at a 3D location in the local coordinate system. A point light source emits light equally in all directions; that is, it is omnidirectional. Point light nodes are specified in the local coordinate system and are affected by ancestor transformations.  
/// 
/// Point light node's illumination falls off with distance as specified by three attenuation coefficients. The attenuation factor is  
/// 
/// 1/max(attenuation[0] + attenuation[1] × r + attenuation[2] × r 2 , 1), 
/// 
/// where r is the distance from the light to the surface being illuminated. The default is no attenuation. An attenuation value of (0, 0, 0) is identical to (1, 0, 0). Attenuation values shall be greater than or equal to zero.  
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_positional. Please refer to ISO/IS 10303-46:1994, p. 32 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) Radius and QuadricAttenuation are added to this subtype and the AmbientIntensity and Intensity are inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourcePositional : public  IfcLightSource {
public:
    /// Definition from ISO/CD 10303-46:1992: The Cartesian point indicates the position of the light source.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: A Point light node illuminates geometry within radius of its location.
    ::Ifc4x3_rc1::IfcCartesianPoint* Position() const;
    void setPosition(::Ifc4x3_rc1::IfcCartesianPoint* v);
    /// Definition from IAI: The maximum distance from the light source for a surface still to be illuminated.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: A Point light node illuminates geometry within radius of its location.
    double Radius() const;
    void setRadius(double v);
    /// Definition from ISO/CD 10303-46:1992: This real indicates the value of the attenuation in the lighting equation that is constant.
    double ConstantAttenuation() const;
    void setConstantAttenuation(double v);
    /// Definition from ISO/CD 10303-46:1992: This real indicates the value of the attenuation in the lighting equation that proportional to the distance from the light source.
    double DistanceAttenuation() const;
    void setDistanceAttenuation(double v);
    /// Definition from the IAI: This real indicates the value of the attenuation in the lighting equation that proportional to the square value of the distance from the light source.
    double QuadricAttenuation() const;
    void setQuadricAttenuation(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourcePositional (IfcEntityInstanceData&& e);
    IfcLightSourcePositional (boost::optional< std::string > v1_Name, ::Ifc4x3_rc1::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc4x3_rc1::IfcCartesianPoint* v5_Position, double v6_Radius, double v7_ConstantAttenuation, double v8_DistanceAttenuation, double v9_QuadricAttenuation);
    typedef aggregate_of< IfcLightSourcePositional > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source spot entity is a subtype of light source. Spot light source entities have a light source colour, position, direction, attenuation coefficients, concentration exponent, and spread angle. If a point lies outside the cone of influence of a light source of this type as determined by the light source position, direction and spread angle its colour is not affected by that light source. 
/// 
/// NOTE  The IfcLightSourceSpot adds the BeamWidthAngle which defines the inner cone in which the light source emits light at uniform full intensity. The light source's emission intensity drops off from the inner solid angle (BeamWidthAngle) to the outer solid angle (SpreadAngle).
/// 
/// Definition from ISO/IEC 14772-1:1997: The Spot light node defines a light source that emits light from a specific point along a specific direction vector and constrained within a solid angle. Spot lights may illuminate geometry nodes that respond to light sources and intersect the solid angle defined by the Spot light. Spot light nodes are specified in the local coordinate system and are affected by ancestors' transformations. 
/// 
/// Figure 304 (from VRML97) shows