; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=mipsisa32r6 < %s | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc --mtriple=mips64 -mattr=+mips64r2 < %s | FileCheck %s --check-prefix=MIPS64R2
; RUN: llc --mtriple=mips64 -mattr=+mips64 < %s | FileCheck %s --check-prefix=MIPS64
; RUN: llc --mtriple=mips -mattr=+mips32r2 < %s | FileCheck %s --check-prefix=MIPS32R2
; RUN: llc --mtriple=mips -mattr=+mips32 < %s | FileCheck %s --check-prefix=MIPS32

declare float @llvm.maximumnum.f32(float, float)
declare double @llvm.maximumnum.f64(double, double)
declare float @llvm.minimumnum.f32(float, float)
declare double @llvm.minimumnum.f64(double, double)

define float @maximumnum_float(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f1, $f0
;
; MIPS64R2-LABEL: maximumnum_float:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.un.s $f12, $f12
; MIPS64R2-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.s $f13, $f13
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.ule.s $f12, $f0
; MIPS64R2-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    mfc1 $1, $f12
; MIPS64R2-NEXT:    mov.s $f1, $f0
; MIPS64R2-NEXT:    movz.s $f1, $f12, $1
; MIPS64R2-NEXT:    mtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.s $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS64-LABEL: maximumnum_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.un.s $f12, $f12
; MIPS64-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.s $f13, $f13
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    c.ule.s $f12, $f0
; MIPS64-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS64-NEXT:    mfc1 $1, $f12
; MIPS64-NEXT:    mov.s $f1, $f0
; MIPS64-NEXT:    movz.s $f1, $f12, $1
; MIPS64-NEXT:    mtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.s $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: maximumnum_float:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.un.s $f12, $f12
; MIPS32R2-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.s $f14, $f14
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.ule.s $f12, $f0
; MIPS32R2-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    mfc1 $1, $f12
; MIPS32R2-NEXT:    mov.s $f1, $f0
; MIPS32R2-NEXT:    movz.s $f1, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f2
; MIPS32R2-NEXT:    c.eq.s $f0, $f2
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32-LABEL: maximumnum_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.un.s $f12, $f12
; MIPS32-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.s $f14, $f14
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    c.ule.s $f12, $f0
; MIPS32-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32-NEXT:    mfc1 $1, $f12
; MIPS32-NEXT:    mov.s $f1, $f0
; MIPS32-NEXT:    movz.s $f1, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f2
; MIPS32-NEXT:    c.eq.s $f0, $f2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.s $f0, $f1, $fcc0
; MIPS32R5-LABEL: maximumnum_float:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.un.s $f12, $f12
; MIPS32R5-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.s $f14, $f14
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.ule.s $f12, $f0
; MIPS32R5-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    mfc1 $1, $f12
; MIPS32R5-NEXT:    mov.s $f1, $f0
; MIPS32R5-NEXT:    movz.s $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.s $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.s $f0, $f1, $fcc0
  %z = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}

define float @maximumnum_float_nsz(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f1, $f0
;
; MIPS64R2-LABEL: maximumnum_float_nsz:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.un.s $f12, $f12
; MIPS64R2-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.s $f13, $f13
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.ule.s $f12, $f0
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movf.s $f0, $f12, $fcc0
;
; MIPS64-LABEL: maximumnum_float_nsz:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.un.s $f12, $f12
; MIPS64-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.s $f13, $f13
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    c.ule.s $f12, $f0
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movf.s $f0, $f12, $fcc0
;
; MIPS32R2-LABEL: maximumnum_float_nsz:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.un.s $f12, $f12
; MIPS32R2-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.s $f14, $f14
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.ule.s $f12, $f0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movf.s $f0, $f12, $fcc0
;
; MIPS32-LABEL: maximumnum_float_nsz:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.un.s $f12, $f12
; MIPS32-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.s $f14, $f14
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    c.ule.s $f12, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32R5-LABEL: maximumnum_float_nsz:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.un.s $f12, $f12
; MIPS32R5-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.s $f14, $f14
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.ule.s $f12, $f0
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movf.s $f0, $f12, $fcc0
  %z = call nsz float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}

define float @maximumnum_float_nnan(float %x, float %y) {
; MIPS32R6-LABEL: maximumnum_float_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.s $f0, $f12, $f14
;
; MIPS64R2-LABEL: maximumnum_float_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.ule.s $f12, $f13
; MIPS64R2-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    mfc1 $1, $f12
; MIPS64R2-NEXT:    mov.s $f1, $f0
; MIPS64R2-NEXT:    movz.s $f1, $f12, $1
; MIPS64R2-NEXT:    mtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.s $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS64-LABEL: maximumnum_float_nnan:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.ule.s $f12, $f13
; MIPS64-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS64-NEXT:    mfc1 $1, $f12
; MIPS64-NEXT:    mov.s $f1, $f0
; MIPS64-NEXT:    movz.s $f1, $f12, $1
; MIPS64-NEXT:    mtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.s $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: maximumnum_float_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.ule.s $f12, $f14
; MIPS32R2-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    mfc1 $1, $f12
; MIPS32R2-NEXT:    mov.s $f1, $f0
; MIPS32R2-NEXT:    movz.s $f1, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f2
; MIPS32R2-NEXT:    c.eq.s $f0, $f2
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32-LABEL: maximumnum_float_nnan:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.ule.s $f12, $f14
; MIPS32-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32-NEXT:    mfc1 $1, $f12
; MIPS32-NEXT:    mov.s $f1, $f0
; MIPS32-NEXT:    movz.s $f1, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f2
; MIPS32-NEXT:    c.eq.s $f0, $f2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.s $f0, $f1, $fcc0
; MIPS32R5-LABEL: maximumnum_float_nnan:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.ule.s $f12, $f14
; MIPS32R5-NEXT:    movf.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    mfc1 $1, $f12
; MIPS32R5-NEXT:    mov.s $f1, $f0
; MIPS32R5-NEXT:    movz.s $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.s $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.s $f0, $f1, $fcc0
  %z = call nnan float @llvm.maximumnum.f32(float %x, float %y)
  ret float %z
}


define double @maximumnum_double(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f1, $f0
;
; MIPS64R2-LABEL: maximumnum_double:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.un.d $f12, $f12
; MIPS64R2-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.d $f13, $f13
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.ule.d $f12, $f0
; MIPS64R2-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    dmfc1 $1, $f12
; MIPS64R2-NEXT:    mov.d $f1, $f0
; MIPS64R2-NEXT:    movz.d $f1, $f12, $1
; MIPS64R2-NEXT:    dmtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.d $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS64-LABEL: maximumnum_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.un.d $f12, $f12
; MIPS64-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.d $f13, $f13
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    c.ule.d $f12, $f0
; MIPS64-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS64-NEXT:    dmfc1 $1, $f12
; MIPS64-NEXT:    mov.d $f1, $f0
; MIPS64-NEXT:    movz.d $f1, $f12, $1
; MIPS64-NEXT:    dmtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.d $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: maximumnum_double:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.un.d $f12, $f12
; MIPS32R2-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.d $f14, $f14
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.ule.d $f12, $f0
; MIPS32R2-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    cvt.s.d $f2, $f12
; MIPS32R2-NEXT:    mfc1 $1, $f2
; MIPS32R2-NEXT:    mov.d $f2, $f0
; MIPS32R2-NEXT:    movz.d $f2, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f4
; MIPS32R2-NEXT:    mthc1 $zero, $f4
; MIPS32R2-NEXT:    c.eq.d $f0, $f4
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f2, $fcc0
;
; MIPS32-LABEL: maximumnum_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.un.d $f12, $f12
; MIPS32-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.d $f14, $f14
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    c.ule.d $f12, $f0
; MIPS32-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32-NEXT:    cvt.s.d $f2, $f12
; MIPS32-NEXT:    mfc1 $1, $f2
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movz.d $f2, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f4
; MIPS32-NEXT:    mtc1 $zero, $f5
; MIPS32-NEXT:    c.eq.d $f0, $f4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.d $f0, $f2, $fcc0
; MIPS32R5-LABEL: maximumnum_double:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.un.d $f12, $f12
; MIPS32R5-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.d $f14, $f14
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.ule.d $f12, $f0
; MIPS32R5-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    cvt.s.d $f1, $f12
; MIPS32R5-NEXT:    mfc1 $1, $f1
; MIPS32R5-NEXT:    mov.d $f1, $f0
; MIPS32R5-NEXT:    movz.d $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    mthc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.d $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.d $f0, $f1, $fcc0
  %z = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define double @maximumnum_double_nsz(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f1, $f0
;
; MIPS64R2-LABEL: maximumnum_double_nsz:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.un.d $f12, $f12
; MIPS64R2-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.d $f13, $f13
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.ule.d $f12, $f0
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movf.d $f0, $f12, $fcc0
;
; MIPS64-LABEL: maximumnum_double_nsz:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.un.d $f12, $f12
; MIPS64-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.d $f13, $f13
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    c.ule.d $f12, $f0
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movf.d $f0, $f12, $fcc0
;
; MIPS32R2-LABEL: maximumnum_double_nsz:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.un.d $f12, $f12
; MIPS32R2-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.d $f14, $f14
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.ule.d $f12, $f0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movf.d $f0, $f12, $fcc0
;
; MIPS32-LABEL: maximumnum_double_nsz:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.un.d $f12, $f12
; MIPS32-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.d $f14, $f14
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    c.ule.d $f12, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32R5-LABEL: maximumnum_double_nsz:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.un.d $f12, $f12
; MIPS32R5-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.d $f14, $f14
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.ule.d $f12, $f0
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movf.d $f0, $f12, $fcc0
  %z = call nsz double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define double @maximumnum_double_nnan(double %x, double %y) {
; MIPS32R6-LABEL: maximumnum_double_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    max.d $f0, $f12, $f14
;
; MIPS64R2-LABEL: maximumnum_double_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.ule.d $f12, $f13
; MIPS64R2-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    dmfc1 $1, $f12
; MIPS64R2-NEXT:    mov.d $f1, $f0
; MIPS64R2-NEXT:    movz.d $f1, $f12, $1
; MIPS64R2-NEXT:    dmtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.d $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS64-LABEL: maximumnum_double_nnan:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.ule.d $f12, $f13
; MIPS64-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS64-NEXT:    dmfc1 $1, $f12
; MIPS64-NEXT:    mov.d $f1, $f0
; MIPS64-NEXT:    movz.d $f1, $f12, $1
; MIPS64-NEXT:    dmtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.d $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: maximumnum_double_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.ule.d $f12, $f14
; MIPS32R2-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    cvt.s.d $f2, $f12
; MIPS32R2-NEXT:    mfc1 $1, $f2
; MIPS32R2-NEXT:    mov.d $f2, $f0
; MIPS32R2-NEXT:    movz.d $f2, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f4
; MIPS32R2-NEXT:    mthc1 $zero, $f4
; MIPS32R2-NEXT:    c.eq.d $f0, $f4
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f2, $fcc0
;
; MIPS32-LABEL: maximumnum_double_nnan:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.ule.d $f12, $f14
; MIPS32-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32-NEXT:    cvt.s.d $f2, $f12
; MIPS32-NEXT:    mfc1 $1, $f2
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movz.d $f2, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f4
; MIPS32-NEXT:    mtc1 $zero, $f5
; MIPS32-NEXT:    c.eq.d $f0, $f4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.d $f0, $f2, $fcc0
; MIPS32R5-LABEL: maximumnum_double_nnan:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.ule.d $f12, $f14
; MIPS32R5-NEXT:    movf.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    cvt.s.d $f1, $f12
; MIPS32R5-NEXT:    mfc1 $1, $f1
; MIPS32R5-NEXT:    mov.d $f1, $f0
; MIPS32R5-NEXT:    movz.d $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    mthc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.d $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.d $f0, $f1, $fcc0
  %z = call nnan double @llvm.maximumnum.f64(double %x, double %y)
  ret double %z
}

define float @minimumnum_float(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f1, $f0
;
; MIPS64R2-LABEL: minimumnum_float:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.un.s $f12, $f12
; MIPS64R2-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.s $f13, $f13
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.olt.s $f12, $f0
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    mfc1 $1, $f12
; MIPS64R2-NEXT:    lui $2, 32768
; MIPS64R2-NEXT:    xor $1, $1, $2
; MIPS64R2-NEXT:    mov.s $f1, $f0
; MIPS64R2-NEXT:    movz.s $f1, $f12, $1
; MIPS64R2-NEXT:    mtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.s $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS64-LABEL: minimumnum_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.un.s $f12, $f12
; MIPS64-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.s $f13, $f13
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    c.olt.s $f12, $f0
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    mfc1 $1, $f12
; MIPS64-NEXT:    lui $2, 32768
; MIPS64-NEXT:    xor $1, $1, $2
; MIPS64-NEXT:    mov.s $f1, $f0
; MIPS64-NEXT:    movz.s $f1, $f12, $1
; MIPS64-NEXT:    mtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.s $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: minimumnum_float:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.un.s $f12, $f12
; MIPS32R2-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.s $f14, $f14
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.olt.s $f12, $f0
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    mfc1 $1, $f12
; MIPS32R2-NEXT:    lui $2, 32768
; MIPS32R2-NEXT:    xor $1, $1, $2
; MIPS32R2-NEXT:    mov.s $f1, $f0
; MIPS32R2-NEXT:    movz.s $f1, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f2
; MIPS32R2-NEXT:    c.eq.s $f0, $f2
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32-LABEL: minimumnum_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.un.s $f12, $f12
; MIPS32-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.s $f14, $f14
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    c.olt.s $f12, $f0
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    mfc1 $1, $f12
; MIPS32-NEXT:    lui $2, 32768
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    mov.s $f1, $f0
; MIPS32-NEXT:    movz.s $f1, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f2
; MIPS32-NEXT:    c.eq.s $f0, $f2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.s $f0, $f1, $fcc0
; MIPS32R5-LABEL: minimumnum_float:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.un.s $f12, $f12
; MIPS32R5-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.s $f14, $f14
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.olt.s $f12, $f0
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    mfc1 $1, $f12
; MIPS32R5-NEXT:    lui $2, 32768
; MIPS32R5-NEXT:    xor $1, $1, $2
; MIPS32R5-NEXT:    mov.s $f1, $f0
; MIPS32R5-NEXT:    movz.s $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.s $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.s $f0, $f1, $fcc0
  %z = call float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define float @minimumnum_float_nsz(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.s $f0, $f14, $f14
; MIPS32R6-NEXT:    min.s $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f1, $f0
;
; MIPS64R2-LABEL: minimumnum_float_nsz:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.un.s $f12, $f12
; MIPS64R2-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.s $f13, $f13
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.olt.s $f12, $f0
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
;
; MIPS64-LABEL: minimumnum_float_nsz:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.un.s $f12, $f12
; MIPS64-NEXT:    movt.s $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.s $f13, $f13
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    c.olt.s $f12, $f0
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
;
; MIPS32R2-LABEL: minimumnum_float_nsz:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.un.s $f12, $f12
; MIPS32R2-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.s $f14, $f14
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.olt.s $f12, $f0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
;
; MIPS32-LABEL: minimumnum_float_nsz:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.un.s $f12, $f12
; MIPS32-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.s $f14, $f14
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    c.olt.s $f12, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-LABEL: minimumnum_float_nsz:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.un.s $f12, $f12
; MIPS32R5-NEXT:    movt.s $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.s $f14, $f14
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.olt.s $f12, $f0
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
  %z = call nsz float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define float @minimumnum_float_nnan(float %x, float %y) {
; MIPS32R6-LABEL: minimumnum_float_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f12, $f14
;
; MIPS64R2-LABEL: minimumnum_float_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f13
; MIPS64R2-NEXT:    c.olt.s $f12, $f13
; MIPS64R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64R2-NEXT:    mfc1 $1, $f12
; MIPS64R2-NEXT:    lui $2, 32768
; MIPS64R2-NEXT:    xor $1, $1, $2
; MIPS64R2-NEXT:    mov.s $f1, $f0
; MIPS64R2-NEXT:    movz.s $f1, $f12, $1
; MIPS64R2-NEXT:    mtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.s $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS64-LABEL: minimumnum_float_nnan:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.s $f0, $f13
; MIPS64-NEXT:    c.olt.s $f12, $f13
; MIPS64-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS64-NEXT:    mfc1 $1, $f12
; MIPS64-NEXT:    lui $2, 32768
; MIPS64-NEXT:    xor $1, $1, $2
; MIPS64-NEXT:    mov.s $f1, $f0
; MIPS64-NEXT:    movz.s $f1, $f12, $1
; MIPS64-NEXT:    mtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.s $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: minimumnum_float_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f14
; MIPS32R2-NEXT:    c.olt.s $f12, $f14
; MIPS32R2-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R2-NEXT:    mfc1 $1, $f12
; MIPS32R2-NEXT:    lui $2, 32768
; MIPS32R2-NEXT:    xor $1, $1, $2
; MIPS32R2-NEXT:    mov.s $f1, $f0
; MIPS32R2-NEXT:    movz.s $f1, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f2
; MIPS32R2-NEXT:    c.eq.s $f0, $f2
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS32-LABEL: minimumnum_float_nnan:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.s $f0, $f14
; MIPS32-NEXT:    c.olt.s $f12, $f14
; MIPS32-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32-NEXT:    mfc1 $1, $f12
; MIPS32-NEXT:    lui $2, 32768
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    mov.s $f1, $f0
; MIPS32-NEXT:    movz.s $f1, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f2
; MIPS32-NEXT:    c.eq.s $f0, $f2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.s $f0, $f1, $fcc0
; MIPS32R5-LABEL: minimumnum_float_nnan:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.s $f0, $f14
; MIPS32R5-NEXT:    c.olt.s $f12, $f14
; MIPS32R5-NEXT:    movt.s $f0, $f12, $fcc0
; MIPS32R5-NEXT:    mfc1 $1, $f12
; MIPS32R5-NEXT:    lui $2, 32768
; MIPS32R5-NEXT:    xor $1, $1, $2
; MIPS32R5-NEXT:    mov.s $f1, $f0
; MIPS32R5-NEXT:    movz.s $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.s $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.s $f0, $f1, $fcc0
  %z = call nnan float @llvm.minimumnum.f32(float %x, float %y)
  ret float %z
}

define double @minimumnum_double(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f1, $f0
;
; MIPS64R2-LABEL: minimumnum_double:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.un.d $f12, $f12
; MIPS64R2-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.d $f13, $f13
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.olt.d $f12, $f0
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    dmfc1 $1, $f12
; MIPS64R2-NEXT:    daddiu $2, $zero, 1
; MIPS64R2-NEXT:    dsll $2, $2, 63
; MIPS64R2-NEXT:    xor $1, $1, $2
; MIPS64R2-NEXT:    mov.d $f1, $f0
; MIPS64R2-NEXT:    movz.d $f1, $f12, $1
; MIPS64R2-NEXT:    dmtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.d $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS64-LABEL: minimumnum_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.un.d $f12, $f12
; MIPS64-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.d $f13, $f13
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    c.olt.d $f12, $f0
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    dmfc1 $1, $f12
; MIPS64-NEXT:    daddiu $2, $zero, 1
; MIPS64-NEXT:    dsll $2, $2, 63
; MIPS64-NEXT:    xor $1, $1, $2
; MIPS64-NEXT:    mov.d $f1, $f0
; MIPS64-NEXT:    movz.d $f1, $f12, $1
; MIPS64-NEXT:    dmtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.d $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: minimumnum_double:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.un.d $f12, $f12
; MIPS32R2-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.d $f14, $f14
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.olt.d $f12, $f0
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    cvt.s.d $f2, $f12
; MIPS32R2-NEXT:    mfc1 $1, $f2
; MIPS32R2-NEXT:    lui $2, 32768
; MIPS32R2-NEXT:    xor $1, $1, $2
; MIPS32R2-NEXT:    mov.d $f2, $f0
; MIPS32R2-NEXT:    movz.d $f2, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f4
; MIPS32R2-NEXT:    mthc1 $zero, $f4
; MIPS32R2-NEXT:    c.eq.d $f0, $f4
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f2, $fcc0
;
; MIPS32-LABEL: minimumnum_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.un.d $f12, $f12
; MIPS32-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.d $f14, $f14
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    c.olt.d $f12, $f0
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    cvt.s.d $f2, $f12
; MIPS32-NEXT:    mfc1 $1, $f2
; MIPS32-NEXT:    lui $2, 32768
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movz.d $f2, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f4
; MIPS32-NEXT:    mtc1 $zero, $f5
; MIPS32-NEXT:    c.eq.d $f0, $f4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.d $f0, $f2, $fcc0
; MIPS32R5-LABEL: minimumnum_double:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.un.d $f12, $f12
; MIPS32R5-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.d $f14, $f14
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.olt.d $f12, $f0
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    cvt.s.d $f1, $f12
; MIPS32R5-NEXT:    mfc1 $1, $f1
; MIPS32R5-NEXT:    lui $2, 32768
; MIPS32R5-NEXT:    xor $1, $1, $2
; MIPS32R5-NEXT:    mov.d $f1, $f0
; MIPS32R5-NEXT:    movz.d $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    mthc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.d $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.d $f0, $f1, $fcc0
  %z = call double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}

define double @minimumnum_double_nsz(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double_nsz:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    min.d $f0, $f14, $f14
; MIPS32R6-NEXT:    min.d $f1, $f12, $f12
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f1, $f0
;
; MIPS64R2-LABEL: minimumnum_double_nsz:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.un.d $f12, $f12
; MIPS64R2-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64R2-NEXT:    c.un.d $f13, $f13
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    c.olt.d $f12, $f0
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
;
; MIPS64-LABEL: minimumnum_double_nsz:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.un.d $f12, $f12
; MIPS64-NEXT:    movt.d $f12, $f13, $fcc0
; MIPS64-NEXT:    c.un.d $f13, $f13
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    c.olt.d $f12, $f0
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
;
; MIPS32R2-LABEL: minimumnum_double_nsz:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.un.d $f12, $f12
; MIPS32R2-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R2-NEXT:    c.un.d $f14, $f14
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    c.olt.d $f12, $f0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
;
; MIPS32-LABEL: minimumnum_double_nsz:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.un.d $f12, $f12
; MIPS32-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32-NEXT:    c.un.d $f14, $f14
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    c.olt.d $f12, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-LABEL: minimumnum_double_nsz:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.un.d $f12, $f12
; MIPS32R5-NEXT:    movt.d $f12, $f14, $fcc0
; MIPS32R5-NEXT:    c.un.d $f14, $f14
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    c.olt.d $f12, $f0
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
  %z = call nsz double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}

define double @minimumnum_double_nnan(double %x, double %y) {
; MIPS32R6-LABEL: minimumnum_double_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f12, $f14
;
; MIPS64R2-LABEL: minimumnum_double_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f13
; MIPS64R2-NEXT:    c.olt.d $f12, $f13
; MIPS64R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64R2-NEXT:    daddiu $1, $zero, 1
; MIPS64R2-NEXT:    dsll $1, $1, 63
; MIPS64R2-NEXT:    dmfc1 $2, $f12
; MIPS64R2-NEXT:    xor $1, $2, $1
; MIPS64R2-NEXT:    mov.d $f1, $f0
; MIPS64R2-NEXT:    movz.d $f1, $f12, $1
; MIPS64R2-NEXT:    dmtc1 $zero, $f2
; MIPS64R2-NEXT:    c.eq.d $f0, $f2
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS64-LABEL: minimumnum_double_nnan:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    mov.d $f0, $f13
; MIPS64-NEXT:    c.olt.d $f12, $f13
; MIPS64-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS64-NEXT:    daddiu $1, $zero, 1
; MIPS64-NEXT:    dsll $1, $1, 63
; MIPS64-NEXT:    dmfc1 $2, $f12
; MIPS64-NEXT:    xor $1, $2, $1
; MIPS64-NEXT:    mov.d $f1, $f0
; MIPS64-NEXT:    movz.d $f1, $f12, $1
; MIPS64-NEXT:    dmtc1 $zero, $f2
; MIPS64-NEXT:    c.eq.d $f0, $f2
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    movt.d $f0, $f1, $fcc0
;
; MIPS32R2-LABEL: minimumnum_double_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f14
; MIPS32R2-NEXT:    c.olt.d $f12, $f14
; MIPS32R2-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R2-NEXT:    cvt.s.d $f2, $f12
; MIPS32R2-NEXT:    mfc1 $1, $f2
; MIPS32R2-NEXT:    lui $2, 32768
; MIPS32R2-NEXT:    xor $1, $1, $2
; MIPS32R2-NEXT:    mov.d $f2, $f0
; MIPS32R2-NEXT:    movz.d $f2, $f12, $1
; MIPS32R2-NEXT:    mtc1 $zero, $f4
; MIPS32R2-NEXT:    mthc1 $zero, $f4
; MIPS32R2-NEXT:    c.eq.d $f0, $f4
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f2, $fcc0
;
; MIPS32-LABEL: minimumnum_double_nnan:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    mov.d $f0, $f14
; MIPS32-NEXT:    c.olt.d $f12, $f14
; MIPS32-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32-NEXT:    cvt.s.d $f2, $f12
; MIPS32-NEXT:    mfc1 $1, $f2
; MIPS32-NEXT:    lui $2, 32768
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    movz.d $f2, $f12, $1
; MIPS32-NEXT:    mtc1 $zero, $f4
; MIPS32-NEXT:    mtc1 $zero, $f5
; MIPS32-NEXT:    c.eq.d $f0, $f4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    movt.d $f0, $f2, $fcc0
; MIPS32R5-LABEL: minimumnum_double_nnan:
; MIPS32R5:       # %bb.0:
; MIPS32R5-NEXT:    mov.d $f0, $f14
; MIPS32R5-NEXT:    c.olt.d $f12, $f14
; MIPS32R5-NEXT:    movt.d $f0, $f12, $fcc0
; MIPS32R5-NEXT:    cvt.s.d $f1, $f12
; MIPS32R5-NEXT:    mfc1 $1, $f1
; MIPS32R5-NEXT:    lui $2, 32768
; MIPS32R5-NEXT:    xor $1, $1, $2
; MIPS32R5-NEXT:    mov.d $f1, $f0
; MIPS32R5-NEXT:    movz.d $f1, $f12, $1
; MIPS32R5-NEXT:    mtc1 $zero, $f2
; MIPS32R5-NEXT:    mthc1 $zero, $f2
; MIPS32R5-NEXT:    c.eq.d $f0, $f2
; MIPS32R5-NEXT:    jr $ra
; MIPS32R5-NEXT:    movt.d $f0, $f1, $fcc0
  %z = call nnan double @llvm.minimumnum.f64(double %x, double %y)
  ret double %z
}
