; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=mips -mattr=+single-float < %s | FileCheck %s --check-prefix=MIPS32
; RUN: llc -mtriple=mips64 -mattr=+single-float < %s | FileCheck %s --check-prefix=MIPS64

define void @read_double(ptr %0) {
; MIPS32-LABEL: read_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    lw $2, 4($4)
; MIPS32-NEXT:    lw $3, 0($4)
; MIPS32-NEXT:    #APP
; MIPS32-NEXT:    #NO_APP
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS64-LABEL: read_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    ld $2, 0($4)
; MIPS64-NEXT:    #APP
; MIPS64-NEXT:    #NO_APP
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
  %2 = load double, ptr %0, align 8
  tail call void asm sideeffect "", "r,~{$1}"(double %2)
  ret void
}

define void @read_float(ptr %0) {
; MIPS32-LABEL: read_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    lwc1 $f0, 0($4)
; MIPS32-NEXT:    #APP
; MIPS32-NEXT:    #NO_APP
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
;
; MIPS64-LABEL: read_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    lwc1 $f0, 0($4)
; MIPS64-NEXT:    #APP
; MIPS64-NEXT:    #NO_APP
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
  %2 = load float, ptr %0, align 8
  tail call void asm sideeffect "", "f"(float %2)
  ret void
}

; Test that a proper register class is assigned to clobbers in single-float mode
define float @explicit_float_register_clobber(ptr %0) {
; MIPS32-LABEL: explicit_float_register_clobber:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    lwc1 $f1, 0($4)
; MIPS32-NEXT:    #APP
; MIPS32-NEXT:    #NO_APP
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    mov.s $f0, $f1
;
; MIPS64-LABEL: explicit_float_register_clobber:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    lwc1 $f1, 0($4)
; MIPS64-NEXT:    #APP
; MIPS64-NEXT:    #NO_APP
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    mov.s $f0, $f1
  %2 = load float, ptr %0, align 8
  tail call void asm sideeffect "", "~{$f0}"()
  ret float %2
}
