; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=mipsel-linux-gnu -mcpu=mips32r2 -mattr=+micromips -asm-show-inst < %s |\
; RUN:   FileCheck %s -check-prefixes=MMR2
; RUN: llc -mtriple=mipsel-linux-gnu -mcpu=mips32r2 -mattr=+dsp,+micromips -asm-show-inst < %s |\
; RUN:   FileCheck %s -check-prefixes=MMR2-DSP

define i64 @test(i32 signext %a, i32 signext %b) {
; MMR2-LABEL: test:
; MMR2:       # %bb.0: # %entry
; MMR2-NEXT:    li16 $2, 0 # <MCInst #[[#MCINST1:]] LI16_MM
; MMR2-NEXT:    # <MCOperand Reg:V0>
; MMR2-NEXT:    # <MCOperand Imm:0>>
; MMR2-NEXT:    li16 $3, 1 # <MCInst #[[#MCINST1]] LI16_MM
; MMR2-NEXT:    # <MCOperand Reg:V1>
; MMR2-NEXT:    # <MCOperand Imm:1>>
; MMR2-NEXT:    mtlo $3 # <MCInst #[[#MCINST2:]] MTLO_MM
; MMR2-NEXT:    # <MCOperand Reg:V1>>
; MMR2-NEXT:    mthi $2 # <MCInst #[[#MCINST3:]] MTHI_MM
; MMR2-NEXT:    # <MCOperand Reg:V0>>
; MMR2-NEXT:    madd $4, $5 # <MCInst #[[#MCINST4:]] MADD
; MMR2-NEXT:    # <MCOperand Reg:A0>
; MMR2-NEXT:    # <MCOperand Reg:A1>>
; MMR2-NEXT:    mflo16 $2 # <MCInst #[[#MCINST5:]] MFLO16_MM
; MMR2-NEXT:    # <MCOperand Reg:V0>>
; MMR2-NEXT:    mfhi16 $3 # <MCInst #[[#MCINST6:]] MFHI16_MM
; MMR2-NEXT:    # <MCOperand Reg:V1>>
; MMR2-NEXT:    jrc $ra # <MCInst #[[#MCINST7:]] JRC16_MM
; MMR2-NEXT:    # <MCOperand Reg:RA>>
;
; MMR2-DSP-LABEL: test:
; MMR2-DSP:       # %bb.0: # %entry
; MMR2-DSP-NEXT:    li16 $2, 0 # <MCInst #[[#MCINST1:]] LI16_MM
; MMR2-DSP-NEXT:    # <MCOperand Reg:V0>
; MMR2-DSP-NEXT:    # <MCOperand Imm:0>>
; MMR2-DSP-NEXT:    li16 $3, 1 # <MCInst #[[#MCINST1]] LI16_MM
; MMR2-DSP-NEXT:    # <MCOperand Reg:V1>
; MMR2-DSP-NEXT:    # <MCOperand Imm:1>>
; MMR2-DSP-NEXT:    mtlo $3, $ac0 # <MCInst #[[#MCINST8:]] MTLO_DSP
; MMR2-DSP-NEXT:    # <MCOperand Reg:LO0>
; MMR2-DSP-NEXT:    # <MCOperand Reg:V1>>
; MMR2-DSP-NEXT:    mthi $2, $ac0 # <MCInst #[[#MCINST9:]] MTHI_DSP
; MMR2-DSP-NEXT:    # <MCOperand Reg:HI0>
; MMR2-DSP-NEXT:    # <MCOperand Reg:V0>>
; MMR2-DSP-NEXT:    madd $ac0, $4, $5 # <MCInst #[[#MCINST10:]] MADD_DSP
; MMR2-DSP-NEXT:    # <MCOperand Reg:AC0>
; MMR2-DSP-NEXT:    # <MCOperand Reg:A0>
; MMR2-DSP-NEXT:    # <MCOperand Reg:A1>
; MMR2-DSP-NEXT:    # <MCOperand Reg:AC0>>
; MMR2-DSP-NEXT:    mflo $2, $ac0 # <MCInst #[[#MCINST11:]] MFLO_DSP
; MMR2-DSP-NEXT:    # <MCOperand Reg:V0>
; MMR2-DSP-NEXT:    # <MCOperand Reg:AC0>>
; MMR2-DSP-NEXT:    jr $ra # <MCInst #[[#MCINST12:]] JR_MM
; MMR2-DSP-NEXT:    # <MCOperand Reg:RA>>
; MMR2-DSP-NEXT:    mfhi $3, $ac0 # <MCInst #[[#MCINST13:]] MFHI_DSP
; MMR2-DSP-NEXT:    # <MCOperand Reg:V1>
; MMR2-DSP-NEXT:    # <MCOperand Reg:AC0>>
entry:
  %conv = sext i32 %a to i64
  %conv1 = sext i32 %b to i64
  %mul = mul nsw i64 %conv, %conv1
  %add = add nsw i64 %mul, 1
  ret i64 %add
}
