; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr6 -mattr=+altivec < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   < %s | FileCheck %s --check-prefix=NO-ALTIVEC

; Check vector round to single-precision toward -infinity (vrfim)
; instruction generation using Altivec.

declare <2 x double> @llvm.floor.v2f64(<2 x double> %p)
define <2 x double> @floor_v2f64(<2 x double> %p)
; CHECK-LABEL: floor_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frim 1, 1
; CHECK-NEXT:    frim 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: floor_v2f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -128(1)
; NO-ALTIVEC-NEXT:    std 0, 144(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 128
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 30, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 31, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 2
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 2, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    lfd 31, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 30, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 128
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <2 x double> @llvm.floor.v2f64(<2 x double> %p)
  ret <2 x double> %t
}

declare <4 x double> @llvm.floor.v4f64(<4 x double> %p)
define <4 x double> @floor_v4f64(<4 x double> %p)
; CHECK-LABEL: floor_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frim 1, 1
; CHECK-NEXT:    frim 2, 2
; CHECK-NEXT:    frim 3, 3
; CHECK-NEXT:    frim 4, 4
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: floor_v4f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -144(1)
; NO-ALTIVEC-NEXT:    std 0, 160(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 144
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f28, -32
; NO-ALTIVEC-NEXT:    .cfi_offset f29, -24
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 28, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 29, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 29, 2
; NO-ALTIVEC-NEXT:    stfd 30, 128(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 30, 3
; NO-ALTIVEC-NEXT:    stfd 31, 136(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 4
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 28, 1
; NO-ALTIVEC-NEXT:    fmr 1, 29
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 29, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl floor
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 4, 1
; NO-ALTIVEC-NEXT:    fmr 1, 28
; NO-ALTIVEC-NEXT:    lfd 31, 136(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 28, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    fmr 2, 29
; NO-ALTIVEC-NEXT:    fmr 3, 30
; NO-ALTIVEC-NEXT:    lfd 30, 128(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 29, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 144
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x double> @llvm.floor.v4f64(<4 x double> %p)
  ret <4 x double> %t
}

declare <2 x double> @llvm.ceil.v2f64(<2 x double> %p)
define <2 x double> @ceil_v2f64(<2 x double> %p)
; CHECK-LABEL: ceil_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frip 1, 1
; CHECK-NEXT:    frip 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: ceil_v2f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -128(1)
; NO-ALTIVEC-NEXT:    std 0, 144(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 128
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 30, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 31, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 2
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 2, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    lfd 31, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 30, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 128
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <2 x double> @llvm.ceil.v2f64(<2 x double> %p)
  ret <2 x double> %t
}

declare <4 x double> @llvm.ceil.v4f64(<4 x double> %p)
define <4 x double> @ceil_v4f64(<4 x double> %p)
; CHECK-LABEL: ceil_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frip 1, 1
; CHECK-NEXT:    frip 2, 2
; CHECK-NEXT:    frip 3, 3
; CHECK-NEXT:    frip 4, 4
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: ceil_v4f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -144(1)
; NO-ALTIVEC-NEXT:    std 0, 160(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 144
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f28, -32
; NO-ALTIVEC-NEXT:    .cfi_offset f29, -24
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 28, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 29, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 29, 2
; NO-ALTIVEC-NEXT:    stfd 30, 128(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 30, 3
; NO-ALTIVEC-NEXT:    stfd 31, 136(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 4
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 28, 1
; NO-ALTIVEC-NEXT:    fmr 1, 29
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 29, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl ceil
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 4, 1
; NO-ALTIVEC-NEXT:    fmr 1, 28
; NO-ALTIVEC-NEXT:    lfd 31, 136(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 28, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    fmr 2, 29
; NO-ALTIVEC-NEXT:    fmr 3, 30
; NO-ALTIVEC-NEXT:    lfd 30, 128(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 29, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 144
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x double> @llvm.ceil.v4f64(<4 x double> %p)
  ret <4 x double> %t
}

declare <2 x double> @llvm.trunc.v2f64(<2 x double> %p)
define <2 x double> @trunc_v2f64(<2 x double> %p)
; CHECK-LABEL: trunc_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    friz 1, 1
; CHECK-NEXT:    friz 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: trunc_v2f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -128(1)
; NO-ALTIVEC-NEXT:    std 0, 144(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 128
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 30, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 31, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 2
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 2, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    lfd 31, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 30, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 128
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <2 x double> @llvm.trunc.v2f64(<2 x double> %p)
  ret <2 x double> %t
}

declare <4 x double> @llvm.trunc.v4f64(<4 x double> %p)
define <4 x double> @trunc_v4f64(<4 x double> %p)
; CHECK-LABEL: trunc_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    friz 1, 1
; CHECK-NEXT:    friz 2, 2
; CHECK-NEXT:    friz 3, 3
; CHECK-NEXT:    friz 4, 4
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: trunc_v4f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -144(1)
; NO-ALTIVEC-NEXT:    std 0, 160(1)
; NO-ALTIVEC-NEXT:    .cfi_def_cfa_offset 144
; NO-ALTIVEC-NEXT:    .cfi_offset lr, 16
; NO-ALTIVEC-NEXT:    .cfi_offset f28, -32
; NO-ALTIVEC-NEXT:    .cfi_offset f29, -24
; NO-ALTIVEC-NEXT:    .cfi_offset f30, -16
; NO-ALTIVEC-NEXT:    .cfi_offset f31, -8
; NO-ALTIVEC-NEXT:    stfd 28, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 29, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 29, 2
; NO-ALTIVEC-NEXT:    stfd 30, 128(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 30, 3
; NO-ALTIVEC-NEXT:    stfd 31, 136(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 4
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 28, 1
; NO-ALTIVEC-NEXT:    fmr 1, 29
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 29, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl trunc
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 4, 1
; NO-ALTIVEC-NEXT:    fmr 1, 28
; NO-ALTIVEC-NEXT:    lfd 31, 136(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 28, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    fmr 2, 29
; NO-ALTIVEC-NEXT:    fmr 3, 30
; NO-ALTIVEC-NEXT:    lfd 30, 128(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 29, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 144
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x double> @llvm.trunc.v4f64(<4 x double> %p)
  ret <4 x double> %t
}

declare <2 x double> @llvm.nearbyint.v2f64(<2 x double> %p)
define <2 x double> @nearbyint_v2f64(<2 x double> %p) nounwind
; CHECK-LABEL: nearbyint_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -128(1)
; CHECK-NEXT:    std 0, 144(1)
; CHECK-NEXT:    stfd 30, 112(1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd 31, 120(1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr 31, 2
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 30, 1
; CHECK-NEXT:    fmr 1, 31
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 2, 1
; CHECK-NEXT:    fmr 1, 30
; CHECK-NEXT:    lfd 31, 120(1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd 30, 112(1) # 8-byte Folded Reload
; CHECK-NEXT:    addi 1, 1, 128
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: nearbyint_v2f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -128(1)
; NO-ALTIVEC-NEXT:    std 0, 144(1)
; NO-ALTIVEC-NEXT:    stfd 30, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 31, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 2
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 2, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    lfd 31, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 30, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 128
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> %p)
  ret <2 x double> %t
}

declare <4 x double> @llvm.nearbyint.v4f64(<4 x double> %p)
define <4 x double> @nearbyint_v4f64(<4 x double> %p) nounwind
; CHECK-LABEL: nearbyint_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -144(1)
; CHECK-NEXT:    std 0, 160(1)
; CHECK-NEXT:    stfd 28, 112(1) # 8-byte Folded Spill
; CHECK-NEXT:    stfd 29, 120(1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr 29, 2
; CHECK-NEXT:    stfd 30, 128(1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr 30, 3
; CHECK-NEXT:    stfd 31, 136(1) # 8-byte Folded Spill
; CHECK-NEXT:    fmr 31, 4
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 28, 1
; CHECK-NEXT:    fmr 1, 29
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 29, 1
; CHECK-NEXT:    fmr 1, 30
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 30, 1
; CHECK-NEXT:    fmr 1, 31
; CHECK-NEXT:    bl nearbyint
; CHECK-NEXT:    nop
; CHECK-NEXT:    fmr 4, 1
; CHECK-NEXT:    fmr 1, 28
; CHECK-NEXT:    lfd 31, 136(1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd 28, 112(1) # 8-byte Folded Reload
; CHECK-NEXT:    fmr 2, 29
; CHECK-NEXT:    fmr 3, 30
; CHECK-NEXT:    lfd 30, 128(1) # 8-byte Folded Reload
; CHECK-NEXT:    lfd 29, 120(1) # 8-byte Folded Reload
; CHECK-NEXT:    addi 1, 1, 144
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: nearbyint_v4f64:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    mflr 0
; NO-ALTIVEC-NEXT:    stdu 1, -144(1)
; NO-ALTIVEC-NEXT:    std 0, 160(1)
; NO-ALTIVEC-NEXT:    stfd 28, 112(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    stfd 29, 120(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 29, 2
; NO-ALTIVEC-NEXT:    stfd 30, 128(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 30, 3
; NO-ALTIVEC-NEXT:    stfd 31, 136(1) # 8-byte Folded Spill
; NO-ALTIVEC-NEXT:    fmr 31, 4
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 28, 1
; NO-ALTIVEC-NEXT:    fmr 1, 29
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 29, 1
; NO-ALTIVEC-NEXT:    fmr 1, 30
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 30, 1
; NO-ALTIVEC-NEXT:    fmr 1, 31
; NO-ALTIVEC-NEXT:    bl nearbyint
; NO-ALTIVEC-NEXT:    nop
; NO-ALTIVEC-NEXT:    fmr 4, 1
; NO-ALTIVEC-NEXT:    fmr 1, 28
; NO-ALTIVEC-NEXT:    lfd 31, 136(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 28, 112(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    fmr 2, 29
; NO-ALTIVEC-NEXT:    fmr 3, 30
; NO-ALTIVEC-NEXT:    lfd 30, 128(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    lfd 29, 120(1) # 8-byte Folded Reload
; NO-ALTIVEC-NEXT:    addi 1, 1, 144
; NO-ALTIVEC-NEXT:    ld 0, 16(1)
; NO-ALTIVEC-NEXT:    mtlr 0
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x double> @llvm.nearbyint.v4f64(<4 x double> %p)
  ret <4 x double> %t
}


declare <4 x float> @llvm.floor.v4f32(<4 x float> %p)
define <4 x float> @floor_v4f32(<4 x float> %p)
; CHECK-LABEL: floor_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfim 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: floor_v4f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfim 2, 2
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x float> @llvm.floor.v4f32(<4 x float> %p)
  ret <4 x float> %t
}

declare <8 x float> @llvm.floor.v8f32(<8 x float> %p)
define <8 x float> @floor_v8f32(<8 x float> %p)
; CHECK-LABEL: floor_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfim 2, 2
; CHECK-NEXT:    vrfim 3, 3
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: floor_v8f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfim 2, 2
; NO-ALTIVEC-NEXT:    vrfim 3, 3
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <8 x float> @llvm.floor.v8f32(<8 x float> %p)
  ret <8 x float> %t
}

declare <4 x float> @llvm.ceil.v4f32(<4 x float> %p)
define <4 x float> @ceil_v4f32(<4 x float> %p)
; CHECK-LABEL: ceil_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfip 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: ceil_v4f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfip 2, 2
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x float> @llvm.ceil.v4f32(<4 x float> %p)
  ret <4 x float> %t
}

declare <8 x float> @llvm.ceil.v8f32(<8 x float> %p)
define <8 x float> @ceil_v8f32(<8 x float> %p)
; CHECK-LABEL: ceil_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfip 2, 2
; CHECK-NEXT:    vrfip 3, 3
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: ceil_v8f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfip 2, 2
; NO-ALTIVEC-NEXT:    vrfip 3, 3
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <8 x float> @llvm.ceil.v8f32(<8 x float> %p)
  ret <8 x float> %t
}

declare <4 x float> @llvm.trunc.v4f32(<4 x float> %p)
define <4 x float> @trunc_v4f32(<4 x float> %p)
; CHECK-LABEL: trunc_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfiz 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: trunc_v4f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfiz 2, 2
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x float> @llvm.trunc.v4f32(<4 x float> %p)
  ret <4 x float> %t
}

declare <8 x float> @llvm.trunc.v8f32(<8 x float> %p)
define <8 x float> @trunc_v8f32(<8 x float> %p)
; CHECK-LABEL: trunc_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfiz 2, 2
; CHECK-NEXT:    vrfiz 3, 3
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: trunc_v8f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfiz 2, 2
; NO-ALTIVEC-NEXT:    vrfiz 3, 3
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <8 x float> @llvm.trunc.v8f32(<8 x float> %p)
  ret <8 x float> %t
}

declare <4 x float> @llvm.nearbyint.v4f32(<4 x float> %p)
define <4 x float> @nearbyint_v4f32(<4 x float> %p)
; CHECK-LABEL: nearbyint_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfin 2, 2
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: nearbyint_v4f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfin 2, 2
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> %p)
  ret <4 x float> %t
}

declare <8 x float> @llvm.nearbyint.v8f32(<8 x float> %p)
define <8 x float> @nearbyint_v8f32(<8 x float> %p)
; CHECK-LABEL: nearbyint_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrfin 2, 2
; CHECK-NEXT:    vrfin 3, 3
; CHECK-NEXT:    blr
;
; NO-ALTIVEC-LABEL: nearbyint_v8f32:
; NO-ALTIVEC:       # %bb.0:
; NO-ALTIVEC-NEXT:    vrfin 2, 2
; NO-ALTIVEC-NEXT:    vrfin 3, 3
; NO-ALTIVEC-NEXT:    blr
{
  %t = call <8 x float> @llvm.nearbyint.v8f32(<8 x float> %p)
  ret <8 x float> %t
}
