% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spruce.R
\name{spruce-multiple}
\alias{spruce-multiple}
\alias{spruce_numeric_multiple}
\alias{spruce_class_multiple}
\alias{spruce_prob_multiple}
\title{Spruce up multi-outcome predictions}
\usage{
spruce_numeric_multiple(...)

spruce_class_multiple(...)

spruce_prob_multiple(...)
}
\arguments{
\item{...}{Multiple vectors of predictions:
\itemize{
\item For \code{spruce_numeric_multiple()}, numeric vectors of equal size.
\item For \code{spruce_class_multiple()}, factors of "hard" class predictions of
equal size.
\item For \code{spruce_prob_multiple()}, tibbles of equal size, which are the result
of calling \code{\link[=spruce_prob]{spruce_prob()}} on each matrix of prediction probabilities.
}

If the \code{...} are named, then this name will be used as the suffix on the
resulting column name, otherwise a positional index will be used.}
}
\value{
\itemize{
\item For \code{spruce_numeric_multiple()}, a tibble of numeric columns named with the
pattern \verb{.pred_*}.
\item For \code{spruce_class_multiple()}, a tibble of factor columns named with the
pattern \verb{.pred_class_*}.
\item For \code{spruce_prob_multiple()}, a tibble of data frame columns named with the
pattern \verb{.pred_*}.
}
}
\description{
This family of \verb{spruce_*_multiple()} functions converts multi-outcome
predictions into a standardized format. They are generally called from a
prediction implementation function for the specific \code{type} of prediction to
return.
}
\examples{
spruce_numeric_multiple(1:3, foo = 2:4)

spruce_class_multiple(
  one_step = factor(c("a", "b", "c")),
  two_step = factor(c("a", "c", "c"))
)

one_step <- matrix(c(.3, .7, .0, .1, .3, .6), nrow = 2, byrow = TRUE)
two_step <- matrix(c(.2, .7, .1, .2, .4, .4), nrow = 2, byrow = TRUE)
binary <- matrix(c(.5, .5, .4, .6), nrow = 2, byrow = TRUE)

spruce_prob_multiple(
  one_step = spruce_prob(c("a", "b", "c"), one_step),
  two_step = spruce_prob(c("a", "b", "c"), two_step),
  binary = spruce_prob(c("yes", "no"), binary)
)
}
