if (FALSE) {
  df <- data.frame(x = 1:3, y = letters[1:3], stringsAsFactors = FALSE)
  write.csv(df, test_path("eol-lf.csv"), row.names = FALSE, eol = "\n")
  write.csv(df, test_path("eol-cr.csv"), row.names = FALSE, eol = "\r")
  write.csv(df, test_path("eol-crlf.csv"), row.names = FALSE, eol = "\r\n")

  write.fwf <- function(x, path, ...) {
    write.table(x, path, row.names = FALSE, quote = FALSE)
  }
  write.fwf(df, test_path("eol-lf.txt"), row.names = FALSE, eol = "\n")
  write.fwf(df, test_path("eol-cr.txt"), row.names = FALSE, eol = "\r")
  write.fwf(df, test_path("eol-crlf.txt"), row.names = FALSE, eol = "\r\n")
}

test_that("read_csv standardises line breaks", {
  expect_equal(read_csv(test_fixture("eol-lf.csv"))$y, letters[1:3])
  # expect_equal(read_csv(test_fixture("eol-cr.csv"))$y, letters[1:3])
  expect_equal(read_csv(test_fixture("eol-crlf.csv"))$y, letters[1:3])
})

test_that("read_csv skipping works with windows newlines", {
  expect_equal(
    read_csv(test_fixture("eol-lf.csv"), skip = 2, col_names = FALSE)[[2]],
    letters[2:3]
  )
  # expect_equal(read_csv(test_fixture("eol-cr.csv"), skip = 2, col_names = FALSE)[[2]], letters[2:3])
  expect_equal(
    read_csv(test_fixture("eol-crlf.csv"), skip = 2, col_names = FALSE)[[2]],
    letters[2:3]
  )
})

test_that("read_lines standardises line breaks", {
  lf <- read_lines(test_fixture("eol-lf.csv"))
  # expect_equal(read_lines(test_fixture("eol-cr.csv")), lf)
  expect_equal(read_lines(test_fixture("eol-crlf.csv")), lf)
})

test_that("read_fwf/read_table standardises line breaks", {
  expect_equal(read_table(test_fixture("eol-lf.txt"))$y, letters[1:3])
  # expect_equal(read_table(test_fixture("eol-cr.txt"))$y, letters[1:3])
  expect_equal(read_table(test_fixture("eol-crlf.txt"))$y, letters[1:3])
})
