# Contributing to Dalli

We welcome contributions from the community. Whether you're fixing a bug, adding a feature, or improving documentation, thank you for helping make Dalli better.

## How to Contribute

1. Fork the repository on GitHub.
2. Create a topic branch from `main` for your change.
3. Make your changes and ensure they include tests that verify the fix or feature.
4. Update the [CHANGELOG](CHANGELOG.md) with a one-sentence description of your change so you get credit as a contributor.
5. Make sure `bundle exec rubocop` passes with no offenses.
6. Make sure `bundle exec rake` passes with no test failures.
7. Submit a pull request.

## AI-Authored Contributions

Issues and pull requests from AI bots or AI-assisted tools are welcome. They are held to the same standards as any other contribution:

- Include tests that verify the change.
- Update the changelog.
- Pass CI (tests and linting).

**Disclosure is required.** If a contribution is authored or substantially generated by AI, indicate this in one of the following ways:

- Submit from a clearly identified bot account.
- Include a note in the PR or issue body (e.g., "This PR was generated with the assistance of [tool name]").
- Apply a `generated-by-ai` label.

## Development Setup

After cloning the repo:

```bash
bundle install          # Install dependencies
bundle exec rake        # Run the full test suite (requires memcached 1.6+ locally)
bundle exec rubocop     # Run the linter
```

See the [README](README.md) and [wiki](https://github.com/petergoldstein/dalli/wiki) for more details on the project and its architecture.
