#!/usr/bin/env sh

set -ex

export GIT_AUTHOR_DATE='2000-01-01T00:00:00' GIT_COMMITTER_DATE='2000-01-01T00:00:00'

if test -d TestRepo; then
    echo "error: 'TestRepo' exists, please remove."
    exit 1
fi

# This constructs a repository with the following commits:
#
# a8b9fcb (Initial commit, with README)
# 5eca9c3 (Add a subdirectory)
# d533439 (Add a directory of funny names)
# ....... (Add the construction script)

mkdir -p TestRepo
cd TestRepo
cp ../README.txt .
cp ../construct.sh .
git init
rm -rf .git/hooks
git config user.name "Example Example"
git config user.email example@example.com

# Create the initial commit.
git add README.txt
git commit -m "Initial commit."

# Create a test subdirectory.
mkdir subdir
touch subdir/empty.txt
git add subdir/empty.txt
git commit -m "Add a subdirectory."

# Create a commit with funny names.
mkdir funny-names
touch "funny-names/$(printf "a\tb")"
touch "funny-names/$(printf "a\nb")"
touch "funny-names/$(printf "a b")"
touch "funny-names/$(printf "a\"b")"
touch "funny-names/$(printf "a\$b")"
touch "funny-names/$(printf "a\\b")"
touch "funny-names/$(python -c 'print "a%cb" % 18')"
git add funny-names/a*
git commit -m "Add some funny names."

# Add the construct script.
#
# We do this last so changing it doesn't invalidate the previous hashes.
git add construct.sh
git commit -m "Add repository construction script."

# Add a tag.
git tag -m "Tag 1.0" 1.0

# Pack.
git gc
git repack
