/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import org.json.JSONException;

public class Kim {
    private byte[] bytes = null;
    private int hashcode = 0;
    public int length = 0;
    private String string = null;

    public Kim(byte[] bytes, int from, int thru) {
        int sum = 1;
        this.hashcode = 0;
        this.length = thru - from;
        if (this.length > 0) {
            this.bytes = new byte[this.length];
            for (int at = 0; at < this.length; ++at) {
                int value = bytes[at + from] & 0xFF;
                this.hashcode += (sum += value);
                this.bytes[at] = (byte)value;
            }
            this.hashcode += sum << 16;
        }
    }

    public Kim(byte[] bytes, int length) {
        this(bytes, 0, length);
    }

    public Kim(Kim kim, int from, int thru) {
        this(kim.bytes, from, thru);
    }

    public Kim(String string) throws JSONException {
        int stringLength = string.length();
        this.hashcode = 0;
        this.length = 0;
        if (stringLength > 0) {
            for (int i = 0; i < stringLength; ++i) {
                char c = string.charAt(i);
                if (c <= '\u007f') {
                    ++this.length;
                    continue;
                }
                if (c <= '\u3fff') {
                    this.length += 2;
                    continue;
                }
                if (c >= '\ud800' && c <= '\udfff') {
                    char d = string.charAt(++i);
                    if (c > '\udbff' || d < '\udc00' || d > '\udfff') {
                        throw new JSONException("Bad UTF16");
                    }
                }
                this.length += 3;
            }
            this.bytes = new byte[this.length];
            int at = 0;
            int sum = 1;
            for (int i = 0; i < stringLength; ++i) {
                int b;
                int character = string.charAt(i);
                if (character <= 127) {
                    this.bytes[at] = (byte)character;
                    this.hashcode += (sum += character);
                    ++at;
                    continue;
                }
                if (character <= 16383) {
                    b = 0x80 | character >>> 7;
                    this.bytes[at] = (byte)b;
                    this.hashcode += (sum += b);
                    b = character & 0x7F;
                    this.bytes[++at] = (byte)b;
                    this.hashcode += (sum += b);
                    ++at;
                    continue;
                }
                if (character >= 55296 && character <= 56319) {
                    character = ((character & 0x3FF) << 10 | string.charAt(++i) & 0x3FF) + 65536;
                }
                b = 0x80 | character >>> 14;
                this.bytes[at] = (byte)b;
                this.hashcode += (sum += b);
                b = 0x80 | character >>> 7 & 0xFF;
                this.bytes[++at] = (byte)b;
                this.hashcode += (sum += b);
                b = character & 0x7F;
                this.bytes[++at] = (byte)b;
                this.hashcode += (sum += b);
                ++at;
            }
            this.hashcode += sum << 16;
        }
    }

    public int characterAt(int at) throws JSONException {
        int c = this.get(at);
        if ((c & 0x80) == 0) {
            return c;
        }
        int c1 = this.get(at + 1);
        if ((c1 & 0x80) == 0) {
            int character = (c & 0x7F) << 7 | c1;
            if (character > 127) {
                return character;
            }
        } else {
            int c2 = this.get(at + 2);
            int character = (c & 0x7F) << 14 | (c1 & 0x7F) << 7 | c2;
            if ((c2 & 0x80) == 0 && character > 16383 && character <= 0x10FFFF && (character < 55296 || character > 57343)) {
                return character;
            }
        }
        throw new JSONException("Bad character at " + at);
    }

    public static int characterSize(int character) throws JSONException {
        if (character < 0 || character > 0x10FFFF) {
            throw new JSONException("Bad character " + character);
        }
        return character <= 127 ? 1 : (character <= 16383 ? 2 : 3);
    }

    public int copy(byte[] bytes, int at) {
        System.arraycopy(this.bytes, 0, bytes, at, this.length);
        return at + this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Kim)) {
            return false;
        }
        Kim that = (Kim)obj;
        if (this == that) {
            return true;
        }
        if (this.hashcode != that.hashcode) {
            return false;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int get(int at) throws JSONException {
        if (at < 0 || at > this.length) {
            throw new JSONException("Bad character at " + at);
        }
        return this.bytes[at] & 0xFF;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() throws JSONException {
        if (this.string == null) {
            int c;
            int length = 0;
            char[] chars = new char[this.length];
            for (int at = 0; at < this.length; at += Kim.characterSize(c)) {
                c = this.characterAt(at);
                if (c < 65536) {
                    chars[length] = (char)c;
                    ++length;
                    continue;
                }
                chars[length] = (char)(0xD800 | c - 65536 >>> 10);
                chars[++length] = (char)(0xDC00 | c & 0x3FF);
                ++length;
            }
            this.string = new String(chars, 0, length);
        }
        return this.string;
    }
}

