=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::PdfExportOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::AccessPermissions;
use AsposeSlidesCloud::Object::ExportOptions;
use AsposeSlidesCloud::Object::FontFallbackRule;
use AsposeSlidesCloud::Object::FontSubstRule;
use AsposeSlidesCloud::Object::SlidesLayoutOptions;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Provides options that control how a presentation is saved in Pdf format.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ format } = 'pdf';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Provides options that control how a presentation is saved in Pdf format.',
                                  class => 'PdfExportOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'default_regular_font' => {
    	datatype => 'string',
    	base_name => 'DefaultRegularFont',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'gradient_style' => {
    	datatype => 'string',
    	base_name => 'GradientStyle',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'font_fallback_rules' => {
    	datatype => 'ARRAY[FontFallbackRule]',
    	base_name => 'FontFallbackRules',
    	description => 'Gets of sets list of font fallback rules.',
    	format => '',
    	read_only => '',
    		},
    'font_subst_rules' => {
    	datatype => 'ARRAY[FontSubstRule]',
    	base_name => 'FontSubstRules',
    	description => 'Gets of sets list of font substitution rules.',
    	format => '',
    	read_only => '',
    		},
    'format' => {
    	datatype => 'string',
    	base_name => 'Format',
    	description => 'Export format.',
    	format => '',
    	read_only => '',
    		},
    'text_compression' => {
    	datatype => 'string',
    	base_name => 'TextCompression',
    	description => 'Specifies compression type to be used for all textual content in the document.',
    	format => '',
    	read_only => '',
    		},
    'embed_full_fonts' => {
    	datatype => 'boolean',
    	base_name => 'EmbedFullFonts',
    	description => 'Determines if all characters of font should be embedded or only used subset.',
    	format => '',
    	read_only => '',
    		},
    'compliance' => {
    	datatype => 'string',
    	base_name => 'Compliance',
    	description => 'Desired conformance level for generated PDF document.',
    	format => '',
    	read_only => '',
    		},
    'sufficient_resolution' => {
    	datatype => 'double',
    	base_name => 'SufficientResolution',
    	description => 'Returns or sets a value determining resolution of images inside PDF document.  Property affects on file size, time of export and image quality. The default value is 96.',
    	format => '',
    	read_only => '',
    		},
    'jpeg_quality' => {
    	datatype => 'int',
    	base_name => 'JpegQuality',
    	description => 'Returns or sets a value determining the quality of the JPEG images inside PDF document.',
    	format => '',
    	read_only => '',
    		},
    'draw_slides_frame' => {
    	datatype => 'boolean',
    	base_name => 'DrawSlidesFrame',
    	description => 'True to draw black frame around each slide.',
    	format => '',
    	read_only => '',
    		},
    'show_hidden_slides' => {
    	datatype => 'boolean',
    	base_name => 'ShowHiddenSlides',
    	description => 'Specifies whether the generated document should include hidden slides or not. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'save_metafiles_as_png' => {
    	datatype => 'boolean',
    	base_name => 'SaveMetafilesAsPng',
    	description => 'True to convert all metafiles used in a presentation to the PNG images.',
    	format => '',
    	read_only => '',
    		},
    'password' => {
    	datatype => 'string',
    	base_name => 'Password',
    	description => 'Setting user password to protect the PDF document. ',
    	format => '',
    	read_only => '',
    		},
    'embed_true_type_fonts_for_ascii' => {
    	datatype => 'boolean',
    	base_name => 'EmbedTrueTypeFontsForASCII',
    	description => 'Determines if Aspose.Slides will embed common fonts for ASCII (33..127 code range) text. Fonts for character codes greater than 127 are always embedded. Common fonts list includes PDF&#39;s base 14 fonts and additional user specified fonts.',
    	format => '',
    	read_only => '',
    		},
    'additional_common_font_families' => {
    	datatype => 'ARRAY[string]',
    	base_name => 'AdditionalCommonFontFamilies',
    	description => 'Returns or sets an array of user-defined names of font families which Aspose.Slides should consider common.',
    	format => '',
    	read_only => '',
    		},
    'slides_layout_options' => {
    	datatype => 'SlidesLayoutOptions',
    	base_name => 'SlidesLayoutOptions',
    	description => 'Slides layouting options',
    	format => '',
    	read_only => '',
    		},
    'image_transparent_color' => {
    	datatype => 'string',
    	base_name => 'ImageTransparentColor',
    	description => 'Image transparent color.',
    	format => '',
    	read_only => '',
    		},
    'apply_image_transparent' => {
    	datatype => 'boolean',
    	base_name => 'ApplyImageTransparent',
    	description => 'True to apply specified ImageTransparentColor  to an image.',
    	format => '',
    	read_only => '',
    		},
    'access_permissions' => {
    	datatype => 'AccessPermissions',
    	base_name => 'AccessPermissions',
    	description => 'Access permissions that should be granted when the document is opened with user access.  Default is AccessPermissions.None.             ',
    	format => '',
    	read_only => '',
    		},
    'hide_ink' => {
    	datatype => 'boolean',
    	base_name => 'HideInk',
    	description => 'True to hide Ink elements in exported document.',
    	format => '',
    	read_only => '',
    		},
    'interpret_mask_op_as_opacity' => {
    	datatype => 'boolean',
    	base_name => 'InterpretMaskOpAsOpacity',
    	description => 'True to use ROP operation or Opacity for rendering brush.',
    	format => '',
    	read_only => '',
    		},
    'rasterize_unsupported_font_styles' => {
    	datatype => 'boolean',
    	base_name => 'RasterizeUnsupportedFontStyles',
    	description => 'True if text should be rasterized as a bitmap and saved to PDF when the font does not support bold styling. This approach can enhance the quality of text in the resulting PDF for certain fonts.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'default_regular_font' => 'string',
    'gradient_style' => 'string',
    'font_fallback_rules' => 'ARRAY[FontFallbackRule]',
    'font_subst_rules' => 'ARRAY[FontSubstRule]',
    'format' => 'string',
    'text_compression' => 'string',
    'embed_full_fonts' => 'boolean',
    'compliance' => 'string',
    'sufficient_resolution' => 'double',
    'jpeg_quality' => 'int',
    'draw_slides_frame' => 'boolean',
    'show_hidden_slides' => 'boolean',
    'save_metafiles_as_png' => 'boolean',
    'password' => 'string',
    'embed_true_type_fonts_for_ascii' => 'boolean',
    'additional_common_font_families' => 'ARRAY[string]',
    'slides_layout_options' => 'SlidesLayoutOptions',
    'image_transparent_color' => 'string',
    'apply_image_transparent' => 'boolean',
    'access_permissions' => 'AccessPermissions',
    'hide_ink' => 'boolean',
    'interpret_mask_op_as_opacity' => 'boolean',
    'rasterize_unsupported_font_styles' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'default_regular_font' => 'DefaultRegularFont',
    'gradient_style' => 'GradientStyle',
    'font_fallback_rules' => 'FontFallbackRules',
    'font_subst_rules' => 'FontSubstRules',
    'format' => 'Format',
    'text_compression' => 'TextCompression',
    'embed_full_fonts' => 'EmbedFullFonts',
    'compliance' => 'Compliance',
    'sufficient_resolution' => 'SufficientResolution',
    'jpeg_quality' => 'JpegQuality',
    'draw_slides_frame' => 'DrawSlidesFrame',
    'show_hidden_slides' => 'ShowHiddenSlides',
    'save_metafiles_as_png' => 'SaveMetafilesAsPng',
    'password' => 'Password',
    'embed_true_type_fonts_for_ascii' => 'EmbedTrueTypeFontsForASCII',
    'additional_common_font_families' => 'AdditionalCommonFontFamilies',
    'slides_layout_options' => 'SlidesLayoutOptions',
    'image_transparent_color' => 'ImageTransparentColor',
    'apply_image_transparent' => 'ApplyImageTransparent',
    'access_permissions' => 'AccessPermissions',
    'hide_ink' => 'HideInk',
    'interpret_mask_op_as_opacity' => 'InterpretMaskOpAsOpacity',
    'rasterize_unsupported_font_styles' => 'RasterizeUnsupportedFontStyles'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
