package Locale::CLDR::Transformations::Any::Kana::Latn;
# This file auto generated from Data\common\transforms\Latin-Katakana.xml
#	on Wed 15 Jan 11:22:39 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ン),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ア イ ウ エ オ ナ ニ ヌ ネ ノ ヤ ユ ヨ ン]),
					replace => q(ン),
					result  => q(n'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヽ[゙゛]?),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q((.)),
					after   => q(),
					replace => q(ヽ[゙゛]?),
					result  => q($1),
					revisit => 0,
				},
				{
					before  => q(([bcdfghjklmnpqrstvwxyz]y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]?),
					result  => q($1),
					revisit => 0,
				},
				{
					before  => q(dz(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(dz$1),
					revisit => 0,
				},
				{
					before  => q(ts(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(ts$1),
					revisit => 0,
				},
				{
					before  => q(dj(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(dj$1),
					revisit => 0,
				},
				{
					before  => q(ch(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(ch$1),
					revisit => 0,
				},
				{
					before  => q(j(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(j$1),
					revisit => 0,
				},
				{
					before  => q(sh(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(sh$1),
					revisit => 0,
				},
				{
					before  => q(w(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(v$1),
					revisit => 0,
				},
				{
					before  => q(b(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(h$1),
					revisit => 0,
				},
				{
					before  => q(t(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(d$1),
					revisit => 0,
				},
				{
					before  => q(s(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(z$1),
					revisit => 0,
				},
				{
					before  => q(k(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(g$1),
					revisit => 0,
				},
				{
					before  => q(ts(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(dz$1),
					revisit => 0,
				},
				{
					before  => q(ch(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(dj$1),
					revisit => 0,
				},
				{
					before  => q(sh(y*[aeiou])),
					after   => q(),
					replace => q(ヽ[゙゛]),
					result  => q(j$1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ョ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ュ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ャ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヮ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ッ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ォ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ェ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゥ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ィ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ァ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ー),
					result  => q(̄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ヤユヨやゆよ]),
					replace => q(ッ),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ワヰヱヲわゐゑを]),
					replace => q(ッ),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([サシスセソさしすせそ]),
					replace => q(ッ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([タチツテトたちつてと]),
					replace => q(ッ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ラリルレロらりるれろ]),
					replace => q(ッ),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([フふ]),
					replace => q(ッ),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ハヒヘホはひへほ]),
					replace => q(ッ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ナニヌネノンなにぬねの]),
					replace => q(ッ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([マミムメモまみむめも]),
					replace => q(ッ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([カキクケコかきくけこ]),
					replace => q(ッ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ワヰヱヲ] ゙),
					replace => q(ッ),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([サシスセソさしすせそ][゙゛]),
					replace => q(ッ),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[ハヒヘホはひへほ]|[フふ])[゚゜]),
					replace => q(ッ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([カキクケコかきくけこ][゙゛]),
					replace => q(ッ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([タチツテトたちつてと][゙゛]),
					replace => q(ッ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[ハヒヘホはひへほ]|[フふ])[゙゛]),
					replace => q(ッ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([シし] [゙゛]),
					replace => q(ッ),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヨ),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ユ),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヤ),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヲ),
					result  => q(wo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヱ),
					result  => q(we),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヰ),
					result  => q(wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ワ),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ウ),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヴ),
					result  => q(vu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ツ),
					result  => q(tsu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ト),
					result  => q(to),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(テ),
					result  => q(te),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(テゥ),
					result  => q(tu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ティ),
					result  => q(ti),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(タ),
					result  => q(ta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(シ),
					result  => q(shi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ショ),
					result  => q(sho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(シェ),
					result  => q(she),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(シュ),
					result  => q(shu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(シィ),
					result  => q(shi\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(シャ),
					result  => q(sha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ソ),
					result  => q(so),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(セ),
					result  => q(se),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ス),
					result  => q(su),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(セィ),
					result  => q(si),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(サ),
					result  => q(sa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゾ),
					result  => q(zo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゼ),
					result  => q(ze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ズ),
					result  => q(zu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゼィ),
					result  => q(zi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ザ),
					result  => q(za),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ロ),
					result  => q(ro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(レ),
					result  => q(re),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ル),
					result  => q(ru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(リ),
					result  => q(ri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ラ),
					result  => q(ra),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(リ),
					result  => q(r),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(フ),
					result  => q(fu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(フォ),
					result  => q(fo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(フェ),
					result  => q(fe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(フィ),
					result  => q(fi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ファ),
					result  => q(fa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ホ),
					result  => q(ho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヘ),
					result  => q(he),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヘゥ),
					result  => q(hu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヒ),
					result  => q(hi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ハ),
					result  => q(ha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ヒ),
					result  => q(h),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ポ),
					result  => q(po),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ペ),
					result  => q(pe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(プ),
					result  => q(pu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ピ),
					result  => q(pi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(パ),
					result  => q(pa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ピ),
					result  => q(p),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(オ),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ノ),
					result  => q(no),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ネ),
					result  => q(ne),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヌ),
					result  => q(nu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ニ),
					result  => q(ni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ナ),
					result  => q(na),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ニ),
					result  => q(n),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(モ),
					result  => q(mo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(メ),
					result  => q(me),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ム),
					result  => q(mu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ミ),
					result  => q(mi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(マ),
					result  => q(ma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ミ),
					result  => q(m),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(コ),
					result  => q(ko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ケ),
					result  => q(ke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ク),
					result  => q(ku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(キ),
					result  => q(ki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(カ),
					result  => q(ka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(キ),
					result  => q(k),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジ),
					result  => q(ji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジョ),
					result  => q(jo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジェ),
					result  => q(je),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジュ),
					result  => q(ju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジィ),
					result  => q(ji\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ジャ),
					result  => q(ja),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(イ),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゴ),
					result  => q(go),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ゲ),
					result  => q(ge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(グ),
					result  => q(gu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ギ),
					result  => q(gi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ガ),
					result  => q(ga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ギ),
					result  => q(g),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(エ),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チ),
					result  => q(chi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チョ),
					result  => q(cho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チェ),
					result  => q(che),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チュ),
					result  => q(chu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チィ),
					result  => q(chi\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(チャ),
					result  => q(cha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂ),
					result  => q(dji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂョ),
					result  => q(djo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂェ),
					result  => q(dje),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂュ),
					result  => q(dju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂィ),
					result  => q(dji\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヂャ),
					result  => q(dja),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヅ),
					result  => q(dzu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ド),
					result  => q(do),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(デ),
					result  => q(de),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(デゥ),
					result  => q(du),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ディ),
					result  => q(di),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ダ),
					result  => q(da),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ボ),
					result  => q(bo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ベ),
					result  => q(be),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ブ),
					result  => q(bu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ビ),
					result  => q(bi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(バ),
					result  => q(ba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ャィュェョ]),
					replace => q(ビ),
					result  => q(b),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ア),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'ョ),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'ェ),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'ュ),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'ィ),
					result  => q(yi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'ャ),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヶ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヵ),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヺ),
					result  => q(vo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヹ),
					result  => q(ve),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヸ),
					result  => q(vi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ヷ),
					result  => q(va),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(、),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(。),
					result  => q(\'),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
