use Test;

use HTTP::Message;

plan 21;

# new
my $m = HTTP::Message.new('somecontent', a => ['a1', 'a2']);

isa-ok $m, HTTP::Message, 'new 1/4';
isa-ok $m.header, HTTP::Header, 'new 2/4';
is $m.field('a'), 'a1, a2', 'new 3/4';
is $m.content, 'somecontent', 'new 4/4';

# push-field
$m.push-field(a => 'a3');
is $m.field('a'), 'a1, a2, a3', 'push-field 1/2';
$m.push-field(a => <a4 a5>);
is $m.field('a'), 'a1, a2, a3, a4, a5', 'push-field 2/2';

# add-content
$m.add-content('some');
is $m.content, 'somecontentsome', 'add-content 1/2';

$m.add-content('line');
is $m.content, 'somecontentsomeline', 'add-content 2/2';

# remove-field
$m.remove-field('a');
nok $m.field('a'), 'remove-field 1/1';

# parse
my $to_parse =    "GET site HTTP/1.0\r\na: b, c\r\na: d\r\n"
                ~ "\r\nline\r\n";
$m.parse($to_parse);
is $m.field('a'), 'b, c, d', 'parse 1/4';
is $m.field('a').values[0], 'b', 'parse 2/4';
is $m.content, 'line', 'parse 3/4';
is $m.protocol, 'HTTP/1.0', 'parse 4/4';

# Str
is $m.Str, "a: b, c, d\n\nline\n", 'Str 1/2';
is $m.Str("\r\n"), "a: b, c, d\r\n\r\nline\r\n", 'Str 2/2';

# clear
$m.clear;
is $m.Str, '', 'clear 1/2';
is $m.content, '', 'clear 2/2';

## parse a more complex example
# new
my $m2 = HTTP::Message.new;

my $CRLF = "\r\n";
# parse
$to_parse = "HTTP/1.1 200 OK\r\n"
          ~ "Server: Apache/2.2.3 (CentOS)\r\n"
          ~ "Last-Modified: Sat, 31 May 2014 16:39:02 GMT\r\n"
          ~ "ETag: \"16d3e2-20416-4fab4ccb03580\"\r\n"
          ~ "Vary: Accept-Encoding\r\n"
          ~ "Content-Type: text/plain; charset=UTF-8\r\n"
          ~ "Transfer-Encoding: chunked\r\n"
          ~ "Date: Mon, 02 Jun 2014 17:07:52 GMT\r\n"
          ~ "X-Varnish: 1992382947 1992382859\r\n"
          ~ "Age: 40\r\n"
          ~ "Via: 1.1 varnish\r\n"
          ~ "Connection: close\r\n"
          ~ "X-Served-By: eu3.develooper.com\r\n"
          ~ "X-Cache: HIT\r\n"
          ~ "X-Cache-Hits: 2\r\n"
          ~ "\r\n"
          ~ "008000\r\n"
          ~ "# Last updated Sat May 31 16:39:01 2014 (UTC)\n"
          ~ "# \n"
          ~ "# Explanation of the syntax:\n";
$m2.parse($to_parse);

is ~$m2.field('ETag'), '"16d3e2-20416-4fab4ccb03580"', 'parse complex 1/3';
is ~$m2.field('Transfer-Encoding'), 'chunked', 'parse complex 2/3';
is ~$m2.field('Content-Type'), 'text/plain; charset=UTF-8', 'parse complex 3/3';

subtest {
   is HTTP::Message.new.charset, 'iso-8859-1', "dumb default charset";
   is HTTP::Message.new(Content-Type => 'text/plain').charset, 'iso-8859-1', 'default text charset';
   is HTTP::Message.new(Content-Type => 'application/xml').charset, 'utf-8', 'default "non-text" charset';
   is HTTP::Message.new(Content-Type => 'text/html; charset=utf-8').charset, 'utf-8', "explicity charset";
}, "charset";

done-testing;
