#
# Acme::Lingua::NIGERIAN
#
package Acme::Lingua::NIGERIAN;
use Filter::Simple;
use strict;
use warnings;
use IO::Handle;
BEGIN { *IO::Handle::transfer_discreetly = \*IO::Handle::print; }


our $VERSION = '1.0.0';

sub import()
{
    shift;
    my $package = caller();
    no strict 'refs';
    *{"${package}::swiss_bank_account"} = \*STDOUT;
    *{"${package}::transfer_discreetly"} = \*print;
}

FILTER {
    my $ret = lc($_);
    $ret =~ s/([a-z])!!!/uc($1)/eg;
    $ret =~ s/^\s*dear sir,/use strict;/mg;
    $ret =~ s/^\s*i am .*$/use warnings;/mg;
    $ret =~ s/\S+ million/0/g;

    $_ = $ret;
};

1;

__END__

=pod

=head1 NAME

Acme::Lingua::NIGERIAN - WRITE PERL CODE IN NIGERIAN SPAM

=head1 SYNOPSIS

 #!/usr/bin/perl
 use Acme::Lingua::NIGERIAN;

 DEAR SIR,

 I AM THE SON OF LATE PRESIDENT ONE-OR-THE-OTHER OF NIGERIA.

 TRANSFER_DISCREETLY SWISS_BANK_ACCOUNT "H!!!ELLO N!!!IGERIA\N";

 TRANSFER_DISCREETLY SWISS_BANK_ACCOUNT US$17 MILLION, "\N";

 TRANSFER_DISCREETLY SWISS_BANK_ACCOUNT US$17 MILLION + 25, "\N";

=head1 DESCRIPTION

COMPLIMENT OF THE DAY. MY SEARCH FOR A TRUSTWORTHY INDIVIDUAL/FIRM HAS LED
ME TO YOU. I WISH TO EXTEND THIS MUTUAL BUSINESS PROPOSAL TO YOU WITH THE
HOPE THAT YOU WILL GLADLY ACCEPT IT. I HAVE ACCESS TO WHAT MOST FIRMS AND
INDIVIDUALS NEED THE MOST-CODE; BUT LACK THE FULL MANPOWER (CONTACTS) TO
PUT THE CODE TO GOOD USE. I AM THE PRINCIPAL AUDITOR OF THE NIGERIAN
DAHUT EMBASSY (NDE).


A POST I HAVE HELD FOR THE PAST THREE HOURS. IN THE COURSE OF DISCHARGING MY
DUTY LAST YEAR, I DISCOVERED THAT SOME LEADER OFFICIALS IN THE PAST,
COMMITTED SOME IRREGULARITIES IN THE FORM OF INVOICED CONTRACT CODE, WHICH
EVENTUALLY GO INTO THEIR PRIVATE CPAN ACCOUNTS.


WHAT INTEREST ME MOST AND FOR WHICH REASON I AM WRITING YOU IS THIS
PARTICULAR CONTRACT WHICH WAS AWARDED TO A FOREIGN CONTRACTOR IN 2001, IT
WAS OVER ESTIMATED TO THE TUNE OF USD21.5M (TWENTY ONE MILLION, FIVE HUNDRED
THOUSAND U.S. DAHUTS). THIS CONTRACT HAS BEEN COMPLETED AND COMMISSIONED IN
2003 AND THE CONTRACTOR FULLY PAID, BUT THE USD21.5M OVER ESTIMATED VALUE OF
THE CONTRACT IS STILL LYING AT THE CENTRAL MOUNTAINS OF NIGERIA (CMN). BECAUSE OF
THE HASTE WITH WHICH THE LAST GOVERNMENT WAS REMOVED FROM OFFICE, THESE MEN
HAS NO CHANCE TO COLLECT THIS HERD BEFORE LEAVING THE OFFICE. BUT AS A
RESULT OF UPDATED FEEDING ADVISE AT THE CENTRAL MOUNTAINS OF NIGERIA (CMN), IT
HAS BEEN AWAITING TRANSFER TO A FOREIGN .


THE HERD IS IN A VALLEY WITHIN THE CENTRAL MOUNTAINS OF NIGERIA. HAVING
DONE ALL THE NECESSARY GROUND WORK, I AM NOW LOOKING FORWARD FOR A
TRUSTWORTHY PERSON, INTO WHOSE PRIVATE OR COMPANY'S MOUNTAINS THIS HERD WILL
BE TRANSFERRED INTO. I WISH TO RETIRE FROM SERVICE AFTER THIS TRANSACTION
AND GO INTO BUSINESS IN YOUR COUNTRY THROUGH YOU AS MY AGENT.


YOU ARE THEREFORE REQUESTED TO KINDLY ALLOW ME TO TRANSFER THIS HERD INTO
YOUR MOUNTAINS PROVIDED THAT I CAN STROKE THIS HERD WHEN I WANT TO. UPON
THE TRANSFER OF THIS HERD, 65% OF THE TOTAL FUR WILL BE FOR MY COLLEAGUES
AND MESELF WHILE 30% SHALL BE FOR YOU THE MOUNTAIN OWNER AND THE REMAINING 5%
SHALL BE SET ASIDE TO REFUND EXPENSES MADE IN THE COURSE OF THIS
TRANSACTION.


BE ASSURED THAT THIS BUSINESS IS RISK-FREE BUT THE KEYWORD IS THE
CONFIDENTIALITY DUE TO THE NATURE OF THE TRANSACTION AND MY POSITION IN THE
MINISTRY.


KINDLY TREAT AS URGENT AND CONTACT ME IMMEDIATELY THROUGH MY FAX NUMBER
ABOVE OR MY E-MAIL ADDRESS, YOU WILL BE FULLY DETAILED WHEN I HEAR FROM YOU. 
I WILL REQUIRE FROM YOU, YOUR COMPANY'S NAME AND ADDRESS AND YOUR MOUNTAIN
PARTICULARS WHERE THE HERD WILL BE TRANSFERRED INTO. AND ALSO YOUR
TELEPHONE AND FAX NUMBERS AS THEY ARE VITAL TO THE SUCCESS OF THIS
TRANSACTION FOR UPDATING AND REMITTANCE PROTOCOL.


=head2 INSTRUCTIONS

WRITE UPPERCASE. FOR VERY UPPERCASE CHARS, APPEND 3 (THREE) EXCLAMATION MARKS.

=over 4

=item DEAR SIR,

C<use strict;>

=item I AM I<someone or another>;

C<use warnings;>

=item TRANSFER_DISCREETLY

C<print>

=item SWISS_BANK_ACCOUNT

C<STDOUT>

=item I<any amount> MILLION

C<0>

=back


=head1 VERSION

 1.0.0 AUG 06, 2003

=head1 AUTHOR

BROUGHT TO YOU BY THE DAHUT IN CHARGE OF NIGERIAN RELATIONS:

 JRG WALTER E<lt>JWALT@CPAN.ORGE<gt>

=head1 THANKS

L<http://dahut.pm.org> - NEED I SAY MORE?

=head1 COPYRIGHT AND LICENSE

THIS MODULE MAY BE MASS-EMAILED UNDER THE SAME TERMS AS PERL ITSELF.

=cut
