# Generated by default/object.tt
package Paws::AppMesh::HttpGatewayRouteMatch;
  use Moose;
  has Headers => (is => 'ro', isa => 'ArrayRef[Paws::AppMesh::HttpGatewayRouteHeader]', request_name => 'headers', traits => ['NameInRequest']);
  has Hostname => (is => 'ro', isa => 'Paws::AppMesh::GatewayRouteHostnameMatch', request_name => 'hostname', traits => ['NameInRequest']);
  has Method => (is => 'ro', isa => 'Str', request_name => 'method', traits => ['NameInRequest']);
  has Path => (is => 'ro', isa => 'Paws::AppMesh::HttpPathMatch', request_name => 'path', traits => ['NameInRequest']);
  has Prefix => (is => 'ro', isa => 'Str', request_name => 'prefix', traits => ['NameInRequest']);
  has QueryParameters => (is => 'ro', isa => 'ArrayRef[Paws::AppMesh::HttpQueryParameter]', request_name => 'queryParameters', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::HttpGatewayRouteMatch

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::HttpGatewayRouteMatch object:

  $service_obj->Method(Att1 => { Headers => $value, ..., QueryParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::HttpGatewayRouteMatch object:

  $result = $service_obj->Method(...);
  $result->Att1->Headers

=head1 DESCRIPTION

An object that represents the criteria for determining a request match.

=head1 ATTRIBUTES


=head2 Headers => ArrayRef[L<Paws::AppMesh::HttpGatewayRouteHeader>]

The client request headers to match on.


=head2 Hostname => L<Paws::AppMesh::GatewayRouteHostnameMatch>

The host name to match on.


=head2 Method => Str

The method to match on.


=head2 Path => L<Paws::AppMesh::HttpPathMatch>

The path to match on.


=head2 Prefix => Str

Specifies the path to match requests with. This parameter must always
start with C</>, which by itself matches all requests to the virtual
service name. You can also match for path-based routing of requests.
For example, if your virtual service name is C<my-service.local> and
you want the route to match requests to C<my-service.local/metrics>,
your prefix should be C</metrics>.


=head2 QueryParameters => ArrayRef[L<Paws::AppMesh::HttpQueryParameter>]

The query parameter to match on.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

