# Generated by default/object.tt
package Paws::MQ::LdapServerMetadataOutput;
  use Moose;
  has Hosts => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'hosts', traits => ['NameInRequest']);
  has RoleBase => (is => 'ro', isa => 'Str', request_name => 'roleBase', traits => ['NameInRequest']);
  has RoleName => (is => 'ro', isa => 'Str', request_name => 'roleName', traits => ['NameInRequest']);
  has RoleSearchMatching => (is => 'ro', isa => 'Str', request_name => 'roleSearchMatching', traits => ['NameInRequest']);
  has RoleSearchSubtree => (is => 'ro', isa => 'Bool', request_name => 'roleSearchSubtree', traits => ['NameInRequest']);
  has ServiceAccountUsername => (is => 'ro', isa => 'Str', request_name => 'serviceAccountUsername', traits => ['NameInRequest']);
  has UserBase => (is => 'ro', isa => 'Str', request_name => 'userBase', traits => ['NameInRequest']);
  has UserRoleName => (is => 'ro', isa => 'Str', request_name => 'userRoleName', traits => ['NameInRequest']);
  has UserSearchMatching => (is => 'ro', isa => 'Str', request_name => 'userSearchMatching', traits => ['NameInRequest']);
  has UserSearchSubtree => (is => 'ro', isa => 'Bool', request_name => 'userSearchSubtree', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MQ::LdapServerMetadataOutput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MQ::LdapServerMetadataOutput object:

  $service_obj->Method(Att1 => { Hosts => $value, ..., UserSearchSubtree => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MQ::LdapServerMetadataOutput object:

  $result = $service_obj->Method(...);
  $result->Att1->Hosts

=head1 DESCRIPTION

The metadata of the LDAP server used to authenticate and authorize
connections to the broker.

=head1 ATTRIBUTES


=head2 Hosts => ArrayRef[Str|Undef]

Fully qualified domain name of the LDAP server. Optional failover
server.


=head2 RoleBase => Str

Fully qualified name of the directory to search for a userE<rsquo>s
groups.


=head2 RoleName => Str

Specifies the LDAP attribute that identifies the group name attribute
in the object returned from the group membership query.


=head2 RoleSearchMatching => Str

The search criteria for groups.


=head2 RoleSearchSubtree => Bool

The directory search scope for the role. If set to true, scope is to
search the entire sub-tree.


=head2 ServiceAccountUsername => Str

Service account username.


=head2 UserBase => Str

Fully qualified name of the directory where you want to search for
users.


=head2 UserRoleName => Str

Specifies the name of the LDAP attribute for the user group membership.


=head2 UserSearchMatching => Str

The search criteria for users.


=head2 UserSearchSubtree => Bool

The directory search scope for the user. If set to true, scope is to
search the entire sub-tree.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MQ>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

