use strict;
use warnings;
use Test::More tests => 360 * 4 + 22;
use Path::Class qw{dir file};
BEGIN { use_ok('RF::Antenna::Planet::MSI::Format') };

my $file    = file(file($0)->dir, 'anonymous.msi');
my $antenna = RF::Antenna::Planet::MSI::Format->new;
isa_ok($antenna, 'RF::Antenna::Planet::MSI::Format');

is($antenna->name("My Name"),            'My Name', 'name');
is($antenna->frequency('5555'),       '5555', 'frequency');
is($antenna->gain('14.12'),            '14.12', 'gain');
$antenna->header(extra=>"My Extra");
is($antenna->electrical_tilt('MECHANICAL'), 'MECHANICAL', 'electrical_tilt');
is($antenna->comment("My Comment"),         'My Comment', 'comment');

$antenna->horizontal([map {[$_ => 1.1]} 0 .. 359]);
$antenna->vertical  ([map {[$_ => 0.5]} 0 .. 359]);

isa_ok($antenna->header, 'HASH');
isa_ok($antenna->horizontal, 'ARRAY');
isa_ok($antenna->vertical, 'ARRAY');
is(scalar(@{$antenna->horizontal}), 360, 'sizeof horizontal');
is(scalar(@{$antenna->vertical}), 360, 'sizeof vertical');

is($antenna->name,            'My Name', 'name');
is($antenna->frequency,       '5555', 'frequency');
is($antenna->frequency_mhz,   5555, 'frequency_mhz');
is($antenna->frequency_ghz,   5.555, 'frequency_ghz');
is($antenna->gain,            '14.12', 'gain');
is($antenna->gain_dbd,        14.12, 'gain_dbd');
is($antenna->gain_dbi,        16.26, 'gain_dbi');
is($antenna->electrical_tilt, 'MECHANICAL', 'electrical_tilt');
is($antenna->comment,         'My Comment', 'comment');

foreach my $angle (0 .. 359) {
  is($antenna->horizontal->[$angle]->[0]+0, $angle);
  is($antenna->vertical->[$angle]->[0]+0, $angle);
  is($antenna->horizontal->[$angle]->[1]+0, 1.1);
  is($antenna->vertical->[$angle]->[1]+0, 0.5);
}

$antenna->write(\my $blob);
#print $blob;
my $data = join "", <DATA>;
is($data, $blob);

__DATA__
NAME My Name
FREQUENCY 5555
GAIN 14.12
extra My Extra
ELECTRICAL_TILT MECHANICAL
COMMENT My Comment
HORIZONTAL 360
0 1.1
1 1.1
2 1.1
3 1.1
4 1.1
5 1.1
6 1.1
7 1.1
8 1.1
9 1.1
10 1.1
11 1.1
12 1.1
13 1.1
14 1.1
15 1.1
16 1.1
17 1.1
18 1.1
19 1.1
20 1.1
21 1.1
22 1.1
23 1.1
24 1.1
25 1.1
26 1.1
27 1.1
28 1.1
29 1.1
30 1.1
31 1.1
32 1.1
33 1.1
34 1.1
35 1.1
36 1.1
37 1.1
38 1.1
39 1.1
40 1.1
41 1.1
42 1.1
43 1.1
44 1.1
45 1.1
46 1.1
47 1.1
48 1.1
49 1.1
50 1.1
51 1.1
52 1.1
53 1.1
54 1.1
55 1.1
56 1.1
57 1.1
58 1.1
59 1.1
60 1.1
61 1.1
62 1.1
63 1.1
64 1.1
65 1.1
66 1.1
67 1.1
68 1.1
69 1.1
70 1.1
71 1.1
72 1.1
73 1.1
74 1.1
75 1.1
76 1.1
77 1.1
78 1.1
79 1.1
80 1.1
81 1.1
82 1.1
83 1.1
84 1.1
85 1.1
86 1.1
87 1.1
88 1.1
89 1.1
90 1.1
91 1.1
92 1.1
93 1.1
94 1.1
95 1.1
96 1.1
97 1.1
98 1.1
99 1.1
100 1.1
101 1.1
102 1.1
103 1.1
104 1.1
105 1.1
106 1.1
107 1.1
108 1.1
109 1.1
110 1.1
111 1.1
112 1.1
113 1.1
114 1.1
115 1.1
116 1.1
117 1.1
118 1.1
119 1.1
120 1.1
121 1.1
122 1.1
123 1.1
124 1.1
125 1.1
126 1.1
127 1.1
128 1.1
129 1.1
130 1.1
131 1.1
132 1.1
133 1.1
134 1.1
135 1.1
136 1.1
137 1.1
138 1.1
139 1.1
140 1.1
141 1.1
142 1.1
143 1.1
144 1.1
145 1.1
146 1.1
147 1.1
148 1.1
149 1.1
150 1.1
151 1.1
152 1.1
153 1.1
154 1.1
155 1.1
156 1.1
157 1.1
158 1.1
159 1.1
160 1.1
161 1.1
162 1.1
163 1.1
164 1.1
165 1.1
166 1.1
167 1.1
168 1.1
169 1.1
170 1.1
171 1.1
172 1.1
173 1.1
174 1.1
175 1.1
176 1.1
177 1.1
178 1.1
179 1.1
180 1.1
181 1.1
182 1.1
183 1.1
184 1.1
185 1.1
186 1.1
187 1.1
188 1.1
189 1.1
190 1.1
191 1.1
192 1.1
193 1.1
194 1.1
195 1.1
196 1.1
197 1.1
198 1.1
199 1.1
200 1.1
201 1.1
202 1.1
203 1.1
204 1.1
205 1.1
206 1.1
207 1.1
208 1.1
209 1.1
210 1.1
211 1.1
212 1.1
213 1.1
214 1.1
215 1.1
216 1.1
217 1.1
218 1.1
219 1.1
220 1.1
221 1.1
222 1.1
223 1.1
224 1.1
225 1.1
226 1.1
227 1.1
228 1.1
229 1.1
230 1.1
231 1.1
232 1.1
233 1.1
234 1.1
235 1.1
236 1.1
237 1.1
238 1.1
239 1.1
240 1.1
241 1.1
242 1.1
243 1.1
244 1.1
245 1.1
246 1.1
247 1.1
248 1.1
249 1.1
250 1.1
251 1.1
252 1.1
253 1.1
254 1.1
255 1.1
256 1.1
257 1.1
258 1.1
259 1.1
260 1.1
261 1.1
262 1.1
263 1.1
264 1.1
265 1.1
266 1.1
267 1.1
268 1.1
269 1.1
270 1.1
271 1.1
272 1.1
273 1.1
274 1.1
275 1.1
276 1.1
277 1.1
278 1.1
279 1.1
280 1.1
281 1.1
282 1.1
283 1.1
284 1.1
285 1.1
286 1.1
287 1.1
288 1.1
289 1.1
290 1.1
291 1.1
292 1.1
293 1.1
294 1.1
295 1.1
296 1.1
297 1.1
298 1.1
299 1.1
300 1.1
301 1.1
302 1.1
303 1.1
304 1.1
305 1.1
306 1.1
307 1.1
308 1.1
309 1.1
310 1.1
311 1.1
312 1.1
313 1.1
314 1.1
315 1.1
316 1.1
317 1.1
318 1.1
319 1.1
320 1.1
321 1.1
322 1.1
323 1.1
324 1.1
325 1.1
326 1.1
327 1.1
328 1.1
329 1.1
330 1.1
331 1.1
332 1.1
333 1.1
334 1.1
335 1.1
336 1.1
337 1.1
338 1.1
339 1.1
340 1.1
341 1.1
342 1.1
343 1.1
344 1.1
345 1.1
346 1.1
347 1.1
348 1.1
349 1.1
350 1.1
351 1.1
352 1.1
353 1.1
354 1.1
355 1.1
356 1.1
357 1.1
358 1.1
359 1.1
VERTICAL 360
0 0.5
1 0.5
2 0.5
3 0.5
4 0.5
5 0.5
6 0.5
7 0.5
8 0.5
9 0.5
10 0.5
11 0.5
12 0.5
13 0.5
14 0.5
15 0.5
16 0.5
17 0.5
18 0.5
19 0.5
20 0.5
21 0.5
22 0.5
23 0.5
24 0.5
25 0.5
26 0.5
27 0.5
28 0.5
29 0.5
30 0.5
31 0.5
32 0.5
33 0.5
34 0.5
35 0.5
36 0.5
37 0.5
38 0.5
39 0.5
40 0.5
41 0.5
42 0.5
43 0.5
44 0.5
45 0.5
46 0.5
47 0.5
48 0.5
49 0.5
50 0.5
51 0.5
52 0.5
53 0.5
54 0.5
55 0.5
56 0.5
57 0.5
58 0.5
59 0.5
60 0.5
61 0.5
62 0.5
63 0.5
64 0.5
65 0.5
66 0.5
67 0.5
68 0.5
69 0.5
70 0.5
71 0.5
72 0.5
73 0.5
74 0.5
75 0.5
76 0.5
77 0.5
78 0.5
79 0.5
80 0.5
81 0.5
82 0.5
83 0.5
84 0.5
85 0.5
86 0.5
87 0.5
88 0.5
89 0.5
90 0.5
91 0.5
92 0.5
93 0.5
94 0.5
95 0.5
96 0.5
97 0.5
98 0.5
99 0.5
100 0.5
101 0.5
102 0.5
103 0.5
104 0.5
105 0.5
106 0.5
107 0.5
108 0.5
109 0.5
110 0.5
111 0.5
112 0.5
113 0.5
114 0.5
115 0.5
116 0.5
117 0.5
118 0.5
119 0.5
120 0.5
121 0.5
122 0.5
123 0.5
124 0.5
125 0.5
126 0.5
127 0.5
128 0.5
129 0.5
130 0.5
131 0.5
132 0.5
133 0.5
134 0.5
135 0.5
136 0.5
137 0.5
138 0.5
139 0.5
140 0.5
141 0.5
142 0.5
143 0.5
144 0.5
145 0.5
146 0.5
147 0.5
148 0.5
149 0.5
150 0.5
151 0.5
152 0.5
153 0.5
154 0.5
155 0.5
156 0.5
157 0.5
158 0.5
159 0.5
160 0.5
161 0.5
162 0.5
163 0.5
164 0.5
165 0.5
166 0.5
167 0.5
168 0.5
169 0.5
170 0.5
171 0.5
172 0.5
173 0.5
174 0.5
175 0.5
176 0.5
177 0.5
178 0.5
179 0.5
180 0.5
181 0.5
182 0.5
183 0.5
184 0.5
185 0.5
186 0.5
187 0.5
188 0.5
189 0.5
190 0.5
191 0.5
192 0.5
193 0.5
194 0.5
195 0.5
196 0.5
197 0.5
198 0.5
199 0.5
200 0.5
201 0.5
202 0.5
203 0.5
204 0.5
205 0.5
206 0.5
207 0.5
208 0.5
209 0.5
210 0.5
211 0.5
212 0.5
213 0.5
214 0.5
215 0.5
216 0.5
217 0.5
218 0.5
219 0.5
220 0.5
221 0.5
222 0.5
223 0.5
224 0.5
225 0.5
226 0.5
227 0.5
228 0.5
229 0.5
230 0.5
231 0.5
232 0.5
233 0.5
234 0.5
235 0.5
236 0.5
237 0.5
238 0.5
239 0.5
240 0.5
241 0.5
242 0.5
243 0.5
244 0.5
245 0.5
246 0.5
247 0.5
248 0.5
249 0.5
250 0.5
251 0.5
252 0.5
253 0.5
254 0.5
255 0.5
256 0.5
257 0.5
258 0.5
259 0.5
260 0.5
261 0.5
262 0.5
263 0.5
264 0.5
265 0.5
266 0.5
267 0.5
268 0.5
269 0.5
270 0.5
271 0.5
272 0.5
273 0.5
274 0.5
275 0.5
276 0.5
277 0.5
278 0.5
279 0.5
280 0.5
281 0.5
282 0.5
283 0.5
284 0.5
285 0.5
286 0.5
287 0.5
288 0.5
289 0.5
290 0.5
291 0.5
292 0.5
293 0.5
294 0.5
295 0.5
296 0.5
297 0.5
298 0.5
299 0.5
300 0.5
301 0.5
302 0.5
303 0.5
304 0.5
305 0.5
306 0.5
307 0.5
308 0.5
309 0.5
310 0.5
311 0.5
312 0.5
313 0.5
314 0.5
315 0.5
316 0.5
317 0.5
318 0.5
319 0.5
320 0.5
321 0.5
322 0.5
323 0.5
324 0.5
325 0.5
326 0.5
327 0.5
328 0.5
329 0.5
330 0.5
331 0.5
332 0.5
333 0.5
334 0.5
335 0.5
336 0.5
337 0.5
338 0.5
339 0.5
340 0.5
341 0.5
342 0.5
343 0.5
344 0.5
345 0.5
346 0.5
347 0.5
348 0.5
349 0.5
350 0.5
351 0.5
352 0.5
353 0.5
354 0.5
355 0.5
356 0.5
357 0.5
358 0.5
359 0.5
