/*
 * Decompiled with CFR 0.152.
 */
package com.zzo.javaserver;

import com.zzo.javaserver.Dealer;
import com.zzo.javaserver.Log;
import com.zzo.javaserver.TCPServer;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class SocketHandler
extends TCPServer {
    public InputStream is = null;
    public OutputStream os = null;
    public String authSecret = "";
    public final int default_event_port = 2001;

    public void run(Socket socket) {
        int n;
        Dealer dealer = null;
        try {
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
        }
        catch (Exception exception) {
            System.out.println("Socket error: " + exception);
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(this.is);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.os);
        String string = null;
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        Log.debug("Trying to get AUTH secret");
        try {
            string = this.readLine(bufferedReader);
        }
        catch (Exception exception) {
            Log.info("Couldn't read data from socket during authentication");
            return;
        }
        if (!string.startsWith("AUTH: ")) {
            Log.warn("Version skew from: " + socket.getInetAddress());
            printWriter.println("ERROR: Authentication required");
            printWriter.flush();
            return;
        }
        String string2 = string.substring(5);
        string2 = string2.trim();
        Log.debug("GOT AUTH secret: -" + string2 + "-");
        if (!string2.equals(this.authSecret)) {
            Log.warn("Authentication failed from: " + socket.getInetAddress());
            printWriter.println("ERROR: Authentication failed");
            printWriter.flush();
            return;
        }
        Log.debug("Shipping OK...");
        printWriter.println("OK");
        printWriter.flush();
        try {
            string = this.readLine(bufferedReader);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 2001;
        }
        Log.debug("Got event port: -" + n + "-");
        if (n > 0) {
            Socket socket2 = null;
            OutputStream outputStream = null;
            try {
                socket2 = new Socket(socket.getInetAddress(), n);
                outputStream = socket2.getOutputStream();
            }
            catch (Exception exception) {
                Log.warn("Socket Exception: ", exception);
                Log.warn("Tried to connect to: " + socket.getInetAddress() + ":" + n);
                return;
            }
            dealer = new Dealer(bufferedReader, new OutputStreamWriter(this.os), new OutputStreamWriter(outputStream));
        } else {
            dealer = new Dealer(bufferedReader, new OutputStreamWriter(this.os), null);
        }
        dealer.setDaemon(true);
        TCPServer.shutdownables.add(dealer);
        dealer.start();
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new EOFException();
        }
        return string;
    }
}

