# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::SqlRunConfiguration;
  use Moose;
  has InputId => (is => 'ro', isa => 'Str', required => 1);
  has InputStartingPositionConfiguration => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::InputStartingPositionConfiguration', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::SqlRunConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::SqlRunConfiguration object:

  $service_obj->Method(Att1 => { InputId => $value, ..., InputStartingPositionConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::SqlRunConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->InputId

=head1 DESCRIPTION

Describes the starting parameters for a SQL-based Kinesis Data
Analytics application.

=head1 ATTRIBUTES


=head2 B<REQUIRED> InputId => Str

The input source ID. You can get this ID by calling the
DescribeApplication operation.


=head2 B<REQUIRED> InputStartingPositionConfiguration => L<Paws::KinesisAnalyticsV2::InputStartingPositionConfiguration>

The point at which you want the application to start processing records
from the streaming source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

