# Generated by default/object.tt
package Paws::Macie2::SecurityHubConfiguration;
  use Moose;
  has PublishClassificationFindings => (is => 'ro', isa => 'Bool', request_name => 'publishClassificationFindings', traits => ['NameInRequest'], required => 1);
  has PublishPolicyFindings => (is => 'ro', isa => 'Bool', request_name => 'publishPolicyFindings', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SecurityHubConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SecurityHubConfiguration object:

  $service_obj->Method(Att1 => { PublishClassificationFindings => $value, ..., PublishPolicyFindings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SecurityHubConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->PublishClassificationFindings

=head1 DESCRIPTION

Specifies configuration settings that determine which findings are
published to Security Hub automatically. For information about how
Macie publishes findings to Security Hub, see Amazon Macie integration
with Security Hub
(https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html)
in the I<Amazon Macie User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> PublishClassificationFindings => Bool

Specifies whether to publish sensitive data findings to Security Hub.
If you set this value to true, Amazon Macie automatically publishes all
sensitive data findings that weren't suppressed by a findings filter.
The default value is false.


=head2 B<REQUIRED> PublishPolicyFindings => Bool

Specifies whether to publish policy findings to Security Hub. If you
set this value to true, Amazon Macie automatically publishes all new
and updated policy findings that weren't suppressed by a findings
filter. The default value is true.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

